/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.helper.C14nHelper;
import org.apache.xml.security.c14n.implementations.CanonicalizerBase;
import org.apache.xml.security.c14n.implementations.NameSpaceSymbTable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class Canonicalizer20010315
extends CanonicalizerBase {
    boolean firstCall = true;
    final SortedSet result = new TreeSet(CanonicalizerBase.COMPARE);
    static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    static final String XML_LANG_URI = "http://www.w3.org/XML/1998/namespace";

    public Canonicalizer20010315(boolean bl) {
        super(bl);
    }

    Iterator handleAttributesSubtree(Element element, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException {
        if (!element.hasAttributes() && !this.firstCall) {
            return null;
        }
        SortedSet sortedSet = this.result;
        sortedSet.clear();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node;
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getLocalName();
            String string2 = attr.getValue();
            String string3 = attr.getNamespaceURI();
            if (!XMLNS_URI.equals(string3)) {
                sortedSet.add(attr);
                continue;
            }
            if ("xml".equals(string) && XML_LANG_URI.equals(string2) || (node = nameSpaceSymbTable.addMappingAndRender(string, string2, attr)) == null) continue;
            sortedSet.add(node);
            if (!C14nHelper.namespaceIsRelative(attr)) continue;
            Object[] objectArray = new Object[]{element.getTagName(), string, attr.getNodeValue()};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
        }
        if (this.firstCall) {
            nameSpaceSymbTable.getUnrenderedNodes(sortedSet);
            this.addXmlAttributesSubtree(element, sortedSet);
            this.firstCall = false;
        }
        return sortedSet.iterator();
    }

    private void addXmlAttributesSubtree(Element element, SortedSet sortedSet) {
        Node node = element.getParentNode();
        HashMap<String, Attr> hashMap = new HashMap<String, Attr>();
        if (node != null && node.getNodeType() == 1) {
            for (Node node2 = node; node2 != null && node2.getNodeType() == 1; node2 = node2.getParentNode()) {
                Element element2 = (Element)node2;
                if (!element2.hasAttributes()) continue;
                NamedNodeMap namedNodeMap = element2.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    if (!XML_LANG_URI.equals(attr.getNamespaceURI()) || element.hasAttributeNS(XML_LANG_URI, attr.getLocalName()) || hashMap.containsKey(attr.getName())) continue;
                    hashMap.put(attr.getName(), attr);
                }
            }
        }
        sortedSet.addAll(hashMap.values());
    }

    Iterator handleAttributes(Element element, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException {
        Node node;
        boolean bl = this.isVisible(element);
        NamedNodeMap namedNodeMap = null;
        int n = 0;
        if (element.hasAttributes()) {
            namedNodeMap = element.getAttributes();
            n = namedNodeMap.getLength();
        }
        SortedSet sortedSet = this.result;
        sortedSet.clear();
        for (int i = 0; i < n; ++i) {
            Node node2;
            node = (Attr)namedNodeMap.item(i);
            String string = node.getLocalName();
            String string2 = node.getValue();
            String string3 = node.getNamespaceURI();
            if (!XMLNS_URI.equals(string3)) {
                if (!bl) continue;
                sortedSet.add(node);
                continue;
            }
            if ("xml".equals(string) && XML_LANG_URI.equals(string2) || !this.isVisible(node) || (node2 = nameSpaceSymbTable.addMappingAndRenderXNodeSet(string, string2, (Attr)node, bl)) == null) continue;
            sortedSet.add(node2);
            if (!C14nHelper.namespaceIsRelative((Attr)node)) continue;
            Object[] objectArray = new Object[]{element.getTagName(), string, node.getNodeValue()};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
        }
        if (bl) {
            Attr attr = element.getAttributeNodeNS(XMLNS_URI, "xmlns");
            node = null;
            if (attr == null) {
                node = nameSpaceSymbTable.getMapping("xmlns");
            } else if (!this.isVisible(attr)) {
                node = nameSpaceSymbTable.addMappingAndRenderXNodeSet("xmlns", "", CanonicalizerBase.nullNode, true);
            }
            if (node != null) {
                sortedSet.add(node);
            }
            this.addXmlAttributes(element, sortedSet);
        }
        return sortedSet.iterator();
    }

    private void addXmlAttributes(Element element, SortedSet sortedSet) {
        Node node = element.getParentNode();
        HashMap<String, Attr> hashMap = new HashMap<String, Attr>();
        if (node != null && node.getNodeType() == 1 && !this.isVisible(node)) {
            for (Node node2 = node; node2 != null && node2.getNodeType() == 1; node2 = node2.getParentNode()) {
                Element element2 = (Element)node2;
                if (!element2.hasAttributes()) continue;
                NamedNodeMap namedNodeMap = element2.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    if (!XML_LANG_URI.equals(attr.getNamespaceURI()) || element.hasAttributeNS(XML_LANG_URI, attr.getLocalName()) || hashMap.containsKey(attr.getName())) continue;
                    hashMap.put(attr.getName(), attr);
                }
            }
        }
        sortedSet.addAll(hashMap.values());
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set set, String string) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }

    public byte[] engineCanonicalizeSubTree(Node node, String string) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }
}

