/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.service.CustomerGatewayConfigurationService;
import com.amazon.aes.service.impl.CustomerGatewayConfigurationServiceImpl;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.VpnConnectionDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeVpnConnections
extends BaseCmd {
    private static final String[] OUTPUT_FORMAT_DESC = new String[]{"Causes the response to include customer gateway configuration", "information, in the format specified by this option. The returned", "information can be formatter for various devices, including Cisco", "(cisco-ios-isr), Juniper (juniper-junos-j), human-readable (generic)", "and in the native XML format (xml)."};
    private static final String STYLESHEET_DESC = "A custom stylesheet for the formatting of the configuration.";
    private CustomerGatewayConfigurationService configurationService = new CustomerGatewayConfigurationServiceImpl();
    private String format;
    private String stylesheet;

    public DescribeVpnConnections(String[] args) {
        super("ec2dvpn", "ec2-describe-vpn-connections");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected String getOptionString() {
        return "[ VPN_CONNECTION ... ] [SPECIFIC OPTIONS]";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)this.joinDescription("Add a filter criterion for the result-set."));
        options.addOption(OptionBuilder.create((String)"F"));
        OptionBuilder.withLongOpt((String)"format");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FORMAT");
        OptionBuilder.withDescription((String)DescribeVpnConnections.joinDescription(OUTPUT_FORMAT_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"stylesheet");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"STYLESHEET");
        OptionBuilder.withDescription((String)this.joinDescription(STYLESHEET_DESC));
        options.addOption(OptionBuilder.create());
        return options;
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Gives you information about one or more VPN connections. The");
        System.out.println("     VPN_CONNECTION parameters, if specified, are the IDs of the VPN");
        System.out.println("     connections to describe.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("format");
        this.printOption("stylesheet");
        this.printOption("filter");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.format = this.getOptionValue("format");
        this.stylesheet = this.getOptionValue("stylesheet");
        CustomerGatewayConfigurationService.ConfigurationOutputter configurationOutputter = this.stylesheet != null && !"".equals(this.stylesheet) ? this.configurationService.getConfigurationOutputterByLocation(System.out, this.stylesheet) : this.configurationService.getConfigurationOutputterByFormat(System.out, this.format);
        RequestResultPair rsp = jec2.describeVpnConnections(this.getFilterMap(true), this.getNonOptions());
        for (VpnConnectionDescription vpnConnection : (List)rsp.getResponse()) {
            out.output(System.out, vpnConnection);
            configurationOutputter.output(vpnConnection.getCustomerGatewayConfiguration());
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected void validateParameters() {
    }

    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    public static void main(String[] args) {
        new DescribeVpnConnections(args).invoke();
    }
}

