/////////////////////////////////////////////////////////////////////////////
// Name:        SubtitlePropDlg.h
// Purpose:     The subtitle properties dialog
// Author:      Alex Thuering
// Created:     24.02.2010
// RCS-ID:      $Id: SubtitlePropDlg.h,v 1.2 2010/06/04 07:27:17 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#ifndef SUBTITLE_PROP_DLG_H
#define SUBTITLE_PROP_DLG_H

#include "DVD.h"
#include <map>

// begin wxGlade: ::dependencies
#include <wx/spinctrl.h>
// end wxGlade

// begin wxGlade: ::extracode

// end wxGlade

using namespace std;
typedef map<wxString, map<wxString, wxString> > FontMap;

class SubtitlePropDlg: public wxDialog {
public:
    // begin wxGlade: SubtitlePropDlg::ids
    enum {
        FONT_FAMILY_BOX_ID  =  7900,
        FONT_STYLE_BOX_ID  =  7901,
        FONT_SIZE_SPIN_ID  =  7902,
        FONT_SIZE_BOX_ID  =  7903
    };
    // end wxGlade
    
    /**
     * Constructor
     */
    SubtitlePropDlg(wxWindow* parent, TextSub* textsub, const wxString& langCode);
    
    /**
     * Displays dialog
     */
    virtual int ShowModal();
    
    /**
     * Returns selected language code
     */
    wxString GetLangCode();
    
    /**
     * Returns font map (font family -> font style -> font filename)
     */
    static FontMap& GetFontMap();

private:
    // begin wxGlade: SubtitlePropDlg::methods
    void set_properties();
    void do_layout();
    // end wxGlade

    // begin wxGlade: SubtitlePropDlg::attributes
    wxStaticBox* boxSizer2_staticbox;
    wxStaticBox* boxSizer1_staticbox;
    wxStaticText* m_langLabel;
    wxChoice* m_langChoice;
    wxStaticText* m_charsetLabel;
    wxChoice* m_charsetChoice;
    wxStaticText* m_fontLabel;
    wxListBox* m_fontFamilyBox;
    wxListBox* m_fontStyleBox;
    wxSpinCtrl* m_fontSizeSpin;
    wxListBox* m_fontSizeBox;
    wxStaticText* m_previewLabel;
    wxTextCtrl* m_previewText;
    wxRadioButton* m_alignRadioTL;
    wxRadioButton* m_alignRadioTC;
    wxRadioButton* m_alignRadioTR;
    wxRadioButton* m_alignRadioCL;
    wxRadioButton* m_alignRadioCR;
    wxRadioButton* m_alignRadioBL;
    wxRadioButton* m_alignRadioBC;
    wxRadioButton* m_alignRadioBR;
    wxSpinCtrl* m_marginTop;
    wxSpinCtrl* m_marginLeft;
    wxSpinCtrl* m_marginRight;
    wxSpinCtrl* m_marginBottom;
    wxButton* okBt;
    wxButton* m_cancelBt;
    // end wxGlade
    
    TextSub* m_textsub;
    wxString m_langCode;
    static FontMap s_fonts;
    virtual void OnFontFamilySelected(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnFontStyleSelected(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnFontSizeChanged(wxSpinEvent &event); // wxGlade: <event_handler>
    virtual void OnFontSizeSelected(wxCommandEvent &event); // wxGlade: <event_handler>
    void OnFontChanged();
    
protected:
    DECLARE_EVENT_TABLE()
}; // wxGlade: end class


#endif // SUBTITLE_PROP_DLG_H
