/////////////////////////////////////////////////////////////////////////////
// Name:        About.cpp
// Purpose:     About dialog
// Author:      Alex Thuering
// Created:     6.11.2003
// RCS-ID:      $Id: About.cpp,v 1.69 2011/02/10 20:50:46 ntalex Exp $
// Copyright:  (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "About.h"
#include <wxVillaLib/utils.h>
#include <wx/statline.h>
#include <wx/notebook.h>
#include <wx/hyperlink.h>
#include <wx/utils.h>
#include "rc/logo.png.h"

BEGIN_EVENT_TABLE(About, wxDialog)
	EVT_HTML_LINK_CLICKED(wxID_ANY, About::OnLinkClicked)
END_EVENT_TABLE()

wxString FixEmail(const wxString& str) {
	wxString result = str;
	result.Replace(wxT(" at "), wxT("@"));
	result.Replace(wxT("<"), wxT("&lt;"));
	result.Replace(wxT(">"), wxT("&gt;"));
	return result;
}

About::About(wxWindow* parent): wxDialog(parent, -1, wxEmptyString,
		wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE | wxRESIZE_BORDER) {
    // sets the application icon
    SetTitle(_("About ..."));
	
	wxNotebook* notebook = new wxNotebook(this, -1);
	wxPanel* aboutPanel = new wxPanel(notebook, -1);
	notebook->AddPage(aboutPanel, _("About"));
	wxBoxSizer* aboutSizer = new wxBoxSizer(wxVERTICAL);
	aboutPanel->SetAutoLayout(true);
	aboutPanel->SetSizer(aboutSizer);
	
    // about info
    wxGridSizer* aboutinfo = new wxFlexGridSizer(2, 3, 3);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, _("Written by: ")), 0, wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, APP_MAINT), 1, wxEXPAND | wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, _("Version: ")), 0, wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, APP_VERSION), 1, wxEXPAND | wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, _("Licence type: ")), 0, wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, APP_LICENCE), 1, wxEXPAND | wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, _("Copyright: ")), 0, wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, APP_COPYRIGHT), 1, wxEXPAND | wxALIGN_LEFT);

    // about title/info
    wxBoxSizer* abouttext = new wxBoxSizer(wxVERTICAL);
    wxStaticText* appname = new wxStaticText(aboutPanel, -1, APP_NAME);
    appname->SetFont(wxFont(10, wxDEFAULT, wxNORMAL, wxBOLD));
    abouttext->Add(appname, 0, wxALIGN_LEFT);
    abouttext->Add(0, 10);
    abouttext->Add(aboutinfo, 1, wxEXPAND);

    // about icontitle//info
    wxBoxSizer* aboutpane = new wxBoxSizer(wxHORIZONTAL);
    wxBitmap bitmap = wxBITMAP_FROM_MEMORY(logo);
    aboutpane->Add(new wxStaticBitmap(aboutPanel, -1, bitmap), 0, wxALIGN_LEFT);
    aboutpane->Add(10, 0);
    aboutpane->Add(abouttext, 1, wxEXPAND);
	
    // about description
    aboutSizer->Add(aboutpane, 0, wxEXPAND | wxALL, 10);
    aboutSizer->Add(new wxStaticText(aboutPanel, -1,
	  _("DVDStyler is a crossplatform authoring system for Video DVD production.")),
	  0, wxALIGN_CENTER | wxLEFT | wxRIGHT, 10);
    aboutSizer->Add(0, 6);
    wxHyperlinkCtrl* website = new wxHyperlinkCtrl(aboutPanel, wxID_ANY, APP_WEBSITE, APP_WEBSITE);
    wxString url = APP_WEBSITE;
    website->SetURL(url);
    aboutSizer->Add(website, 0, wxALIGN_CENTER);
    
    // support
    wxHtmlWindow* supportPanel = new wxHtmlWindow(notebook, -1,
    		wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxHW_SCROLLBAR_AUTO);
    wxString page = wxT("<html><body>");
    page += wxT("<h5>") + wxString(_("Forum")) + wxT("</h5>");
    page += wxString::Format(_("Please use %sDVDStyler forum%s to get support, ask questions, or discuss this software."),
    		wxT("<a href=\"http://sourceforge.net/forum/forum.php?forum_id=318795\" target=\"_blank\">"), wxT("</a>"));
    page += wxT("<h5>") + wxString(_("WIKI")) + wxT("</h5>");
    page += wxString::Format(_("Some documentation and %sFAQ%s you can find in %sDVDStyler WIKI%s or you can publish there your comments or small guides."),
			wxT("<a href=\"http://sourceforge.net/apps/mediawiki/dvdstyler/index.php?title=FAQ\" target=\"_blank\">"), wxT("</a>"),
			wxT("<a href=\"http://sourceforge.net/apps/mediawiki/dvdstyler/index.php?title=Main_Page\" target=\"_blank\">"), wxT("</a>"));
    page += wxT("<h5>") + wxString(_("Bugs & RFE")) + wxT("</h5>");
    page += wxString::Format(_("Please use %sSourceforge Bugtracing system%s to report bug and %sSourceforge RFE system%s to submit a new feature request."),
    		wxT("<a href=\"http://sourceforge.net/tracker/?group_id=92301&atid=600266\" target=\"_blank\">"), wxT("</a>"),
    		wxT("<a href=\"http://sourceforge.net/tracker/?group_id=92301&atid=600269\" target=\"_blank\">"), wxT("</a>"));
    page += wxT("</body></html>");
    supportPanel->SetPage(page);
    notebook->AddPage(supportPanel, _("Support"));
	
	// authors
	wxHtmlWindow* authorsPanel = new wxHtmlWindow(notebook, -1,
	  wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxHW_SCROLLBAR_AUTO);
	page = _T("<html><body>");
	page += _T("<table width='100%' cellspacing='2' cellpadding='2' border='0' valign='top'>");
	
	page += _T("<tr><td colspan='3'><b>") + wxString(_("Author and Maintainer")) + _T("</b></td></tr>");
	page += _T("<tr><td>&nbsp;</td><td colspan='2'>");
	page += FixEmail(_T("Alex Th&uuml;ring <alex at thuering.biz>"));
	page += _T("</td></tr>");
	
	page += _T("<tr><td colspan='3'><b>") + wxString(_("Doc Writer")) + _T("</b></td></tr>");
	page += _T("<tr><td>&nbsp;</td><td colspan='2'>");
	page += FixEmail(_T("Don Brett <dlbrett at zoominternet.net>"));
	page += _T("</td></tr>");
	
	page += _T("<tr><td colspan='3'><b>") + wxString(_("Packager (.deb)")) + _T("</b></td></tr>");
	page += _T("<tr><td>&nbsp;</td><td colspan='2'>");
	page += FixEmail(_T("Fabrice Coutadeur <coutadeurf at gmail.com>"));
	page += _T("</td></tr>");
	
	page += _T("<tr><td colspan='3'><b>") + wxString(_("Translations")) + _T("</b></td></tr>");
	
	const wxString translations[][2] = {
		{ wxT("Armenian"), wxT("Hrant Ohanyan <hrantohanyan at mail.am>") },
		{ wxT("Chinese (Simplified)"), wxString(wxT("程序民工 <lyj8063 at sohu.com>"), wxConvUTF8) },
		{ wxT("Chinese (Traditional)"), wxString(wxT("紀明村 <tw.chi.ming at gmail.com>"), wxConvUTF8) },
		{ wxT("Basque"), wxT("Piarres Beobide <pi at beobide.net>") },
		{ wxT("Czech"), wxString(wxT("Vlastimil Skácel <vlastiks at gmail.com>"), wxConvUTF8) },
		{ wxT("Danish"), wxT("Patrick Fust <patrick_fust at hotmail.com>, Jørgen Rasmussen <l10n at joergenr.dk>") },
		{ wxT("Dutch"), wxT("Maikel Egberink <maikel.egberink at gmail.com>, Ron Vennix <ron.vennix at gmail.com>") },
		{ wxT("French"), wxT("Philippe MACE <philippe.mace at kioskeo.fr>, Pierre Buard <pierre.buard at gmail.com>") },
		{ wxT("German"), wxT("Alex Th&uuml;ring <alex at thuering.biz>") },
		{ wxT("Greek"), wxT("Aristotelis Pitaridis <pitaridis at gmail.com>") },
		{ wxT("Hungarian"), wxString(wxT("Fáczán László <faczan at freemail.hu>"), wxConvUTF8) },
		{ wxT("Italian"), wxT("Alessio Leonarduzzi <alessio.leonarduzzi at gmail.com>") },
		{ wxT("Japanese"), wxT("OKANO Takayoshi <kano at na.rim.or.jp>") },
		{ wxT("Korean"), wxString(wxT("김프사랑 <yongdoria at gmail.com>"), wxConvUTF8) },
		{ wxT("Macedonian"), wxT("Damjan Dimitrioski <damjandimitrioski at gmail.com>") },
		{ wxT("Norwegian"), wxString(wxT("Olav Inge Frøynes <olavinge at gmail.com>"), wxConvUTF8) },
		{ wxT("Polish"), wxString(wxT("Michal Jusyk <drewnozlasu at o2.pl>, Michał Trzebiatowski <hippie_1968 at hotmail.com>"), wxConvUTF8) },
		{ wxT("Portuguese"), wxString(wxT("João Frade / / 100 NOME PT <100nome.portugal at gmail.com>"), wxConvUTF8) },
		{ wxT("Portuguese (Brazilian)"), wxT("Henrique Lopes Barone <henriquebarone at quadrochave.com>") },
		{ wxT("Russian"), wxT("Alex Th&uuml;ring <alex at thuering.biz>") },
		{ wxT("Slovenian"), wxT("Martin Srebotnjak <miles at filmsi.net>") },
		{ wxT("Serbian"), wxT("CICIC Ivana <ozzii23 at gmail.com>") },
		{ wxT("Slovak"), wxT("Michal Kovac <deadsock at deadsock.co.uk>") },
		{ wxT("Spanish"), wxT("Redy Rodriguez <redy at telefonica.net>, Fabrice Coutadeur <coutadeurf at gmail.com>") },
		{ wxT("Swedish"), wxT("Daniel Nylander <po at danielnylander.se>") },
		{ wxT("Ukrainian"), wxT("Федір Зінчук <getthesite at gmail.com>") },
		{ wxT("Vietnamese"), wxT("Phan Anh <ppanhh at gmail.com>") },
	};
	
	for (unsigned int i = 0; i < sizeof(translations)/sizeof(translations[0]); i++)
		page += wxT("<tr><td>&nbsp;</td><td>") + translations[i][0] + wxT("</td><td width='100%'>")
				+ FixEmail(translations[i][1]) + wxT("</td></tr>");
	
	page += _T("<tr><td colspan='3'><b>") + wxString(_("Libraries and Tools")) + _T("</b></td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>wxWidgets</td><td>Julian Smart, Robert Roebling and other</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>dvdauthor</td><td>Scott Smith</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>cdrtools</td><td>Joerg Schilling</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>dvd+rw-tools</td><td>Andy Polyakov</td></tr>");
	
	page += _T("</table>");
	page += _T("</body></html>");
	authorsPanel->SetPage(page);
	notebook->AddPage(authorsPanel, _("Authors"));
	
	// licence
	wxHtmlWindow* licencePanel = new wxHtmlWindow(notebook, -1,
	  wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxHW_SCROLLBAR_AUTO);
	page = _T("<html><body>");
	page += _T("<p>");
	page += _("DVDStyler is <a href='http://www.gnu.org/philosophy/free-sw.html'>free software</a> \
distributed under <a href='http://www.gnu.org/copyleft/gpl.html'>GNU General Public License (GPL)</a>. \
Please visit those sites for details of each agreement.");
	page += _T("</p>");
	page += _T("<p>");
	page += _("THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, \
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, \
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS \
OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, \
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR \
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.");
	page += _T("</p>");
	page += _T("</body></html>");
	licencePanel->SetPage(page);
	notebook->AddPage(licencePanel, _("Licence"));
	
	// buttons
	wxBoxSizer* totalpane = new wxBoxSizer(wxVERTICAL);
	totalpane->Add(notebook, 1, wxEXPAND|wxALL, 6);
    wxButton* okButton = new wxButton(this, wxID_OK, _("OK"));
    okButton->SetDefault();
    okButton->SetFocus();
    totalpane->Add(okButton, 0, wxALIGN_CENTER|wxLEFT|wxRIGHT|wxBOTTOM, 10);
	
    SetSizerAndFit(totalpane);
	Center();

    ShowModal();
}

void About::OnLinkClicked(wxHtmlLinkEvent& event) {
	wxLaunchDefaultBrowser(event.GetLinkInfo().GetHref());
}
