/////////////////////////////////////////////////////////////////////////////
// Name:        MenuObjectPropDlg.h
// Purpose:     DVD menu button properties dialog
// Author:      Alex Thuering
// Created:	20.11.2003
// RCS-ID:      $Id: MenuObjectPropDlg.h,v 1.13 2009/12/30 17:46:21 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef BUTTON_PROP_DLG_H
#define BUTTON_PROP_DLG_H

#include <wx/wx.h>
#include <wxVillaLib/PropDlg.h>
#include "DVD.h"

enum ButtonDirCommand {
  bdNONE, bdLEFT, bdRIGHT, bdUP, bdDOWN
};

class MenuObjectPropDlg: public wxPropDlg {
  public:
    MenuObjectPropDlg(wxWindow *parent, wxString id, Menu *menu, DVD* dvd, int tsi, int pgci);
    virtual ~MenuObjectPropDlg() {}

  private:
    wxString m_id;
    MenuObject* m_object;
    Menu* m_menu;
    DVD* m_dvd;
    int m_tsi; // tsi of menu
    int m_pgci; // pgci of menu
    void CreatePropPanel(wxSizer* sizer);
    
    wxChoice* m_targetChoice;
    wxChoice* m_chapterChoice;
    /** Returns titleset id of selected target */
    int GetSelectedTsi();
    /** Returns PGC id of selected target */
    int GetSelectedPgci();
    /** Returns true if selected target is menu */
    bool IsSelectedMenu();
    /** Returns selected chapter number */
    int GetSelectedChapter();

    void* TargetToPtr(int tsi, int pgci, bool menu);
    void FillTargets(wxChoice* ctrl);
    void UpdateChapters();
    void OnChangeTarget(wxCommandEvent& WXUNUSED(evt));
    
    wxTextCtrl* m_imageEdit;
    wxRadioButton* m_imageRadio;
    wxRadioButton* m_videoFrameRadio;
    wxChoice* m_videoFrameChoice;
    wxString GetVideoFilename(bool withTimestamp = false, long position = -1);
    void OnImageRadio(wxCommandEvent& evt);
    
    wxTextCtrl* m_customActionEdit;
    void OnJumpActionSelected(wxCommandEvent& evt);
    void OnCustomActionSelected(wxCommandEvent& evt);
    
    wxTextCtrl* m_widthEdit;
    wxTextCtrl* m_heightEdit;
    void OnDefaultSizeSelected(wxCommandEvent& evt);
    void OnCustomSizeSelected(wxCommandEvent& evt);
    
    void AddDirectionProp(wxSizer* sizer, ButtonDirCommand dir);
    bool SetValues();
    
    DECLARE_EVENT_TABLE()
};

#endif // BUTTON_PROP_DLG_H
