[Setup]
AppName=DVDStyler
AppVerName=DVDStyler v1.8.0
AppPublisherURL=http://www.dvdstyler.org
AppSupportURL=http://www.dvdstyler.org
AppUpdatesURL=http://www.dvdstyler.org
DefaultDirName={pf}\DVDStyler
DefaultGroupName=DVDStyler
OutputBaseFilename=DVDStylerPorable-1.8.0-win32
Compression=lzma
SolidCompression=yes
UninstallDisplayIcon={app}\bin\DVDStyler.exe
PrivilegesRequired=none
WizardSmallImageFile=dvdstyler.bmp
AllowNoIcons=yes

[Languages]
Name: "cs"; MessagesFile: "compiler:Languages\Czech.isl"
Name: "da"; MessagesFile: "compiler:Languages\Danish.isl"
Name: "de"; MessagesFile: "compiler:Languages\German.isl"
Name: "el"; MessagesFile: "Languages\Greek.isl"
Name: "en"; MessagesFile: "compiler:Default.isl"
Name: "es"; MessagesFile: "compiler:Languages\Spanish.isl"
Name: "eu"; MessagesFile: "compiler:Languages\Basque.isl"
Name: "fr"; MessagesFile: "compiler:Languages\French.isl"
Name: "hu"; MessagesFile: "compiler:Languages\Hungarian.isl"
Name: "it"; MessagesFile: "compiler:Languages\Italian.isl"
Name: "ko"; MessagesFile: "Languages\Korean.isl"
Name: "mk"; MessagesFile: "Languages\Macedonian.isl"
Name: "nl"; MessagesFile: "compiler:Languages\Dutch.isl"
Name: "nb"; MessagesFile: "compiler:Languages\Norwegian.isl"
Name: "pl"; MessagesFile: "compiler:Languages\Polish.isl"
Name: "pt"; MessagesFile: "compiler:Languages\Portuguese.isl"
Name: "pt_BR"; MessagesFile: "compiler:Languages\BrazilianPortuguese.isl"
Name: "ru"; MessagesFile: "compiler:Languages\Russian.isl"
Name: "sk"; MessagesFile: "compiler:Languages\Slovak.isl"
Name: "sl"; MessagesFile: "compiler:Languages\Slovenian.isl"
Name: "sr"; MessagesFile: "Languages\Serbian.isl"
Name: "sv"; MessagesFile: "Languages\Swedish.isl"
Name: "vi"; MessagesFile: "Languages\Vietnamese.isl"
Name: "zh_TW"; MessagesFile: "Languages\ChineseTrad.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: "..\src\DVDStyler.exe"; DestDir: "{app}\bin"; Flags: ignoreversion
Source: "..\src\*.dll"; DestDir: "{app}\bin"; Flags: ignoreversion
Source: "..\backgrounds\*.jpg"; DestDir: "{app}\backgrounds"; Flags: ignoreversion
Source: "..\buttons\*.xml"; DestDir: "{app}\buttons"; Flags: ignoreversion
Source: "..\buttons\deprecated\*.xml"; DestDir: "{app}\buttons"; Flags: ignoreversion
Source: "..\buttons\*.lst"; DestDir: "{app}\buttons"; Flags: ignoreversion
Source: "..\objects\*.xml"; DestDir: "{app}\objects"; Flags: ignoreversion
Source: "..\templates\*.png"; DestDir: "{app}\templates"; Flags: ignoreversion
Source: "..\templates\*.dvdt"; DestDir: "{app}\templates"; Flags: ignoreversion
Source: "..\data\*.mpg"; DestDir: "{app}\data"; Flags: ignoreversion
Source: "..\data\*.rgb"; DestDir: "{app}\data"; Flags: ignoreversion
Source: "..\docs\help_de.zip"; DestDir: "{app}\docs"; Flags: ignoreversion
Source: "..\docs\help_en.zip"; DestDir: "{app}\docs"; Flags: ignoreversion
Source: "..\docs\help_ru.zip"; DestDir: "{app}\docs"; Flags: ignoreversion
Source: "..\COPYING"; DestDir: "{app}"; Flags: ignoreversion
Source: "..\ChangeLog"; DestDir: "{app}"; Flags: ignoreversion
Source: "..\dvdauthor\*"; DestDir: "{app}\dvdauthor"; Flags: ignoreversion

Source: "..\locale\cs\*"; DestDir: "{app}\locale\cs"; Flags: ignoreversion
Source: "..\locale\da\*"; DestDir: "{app}\locale\da"; Flags: ignoreversion
Source: "..\locale\de\*"; DestDir: "{app}\locale\de"; Flags: ignoreversion
Source: "..\locale\el\*"; DestDir: "{app}\locale\el"; Flags: ignoreversion
Source: "..\locale\es\*"; DestDir: "{app}\locale\es"; Flags: ignoreversion
Source: "..\locale\eu\*"; DestDir: "{app}\locale\eu"; Flags: ignoreversion
Source: "..\locale\fr\*"; DestDir: "{app}\locale\fr"; Flags: ignoreversion
Source: "..\locale\hu\*"; DestDir: "{app}\locale\hu"; Flags: ignoreversion
Source: "..\locale\it\*"; DestDir: "{app}\locale\it"; Flags: ignoreversion
Source: "..\locale\ko\*"; DestDir: "{app}\locale\ko"; Flags: ignoreversion
Source: "..\locale\mk\*"; DestDir: "{app}\locale\mk"; Flags: ignoreversion
Source: "..\locale\nb\*"; DestDir: "{app}\locale\nb"; Flags: ignoreversion
Source: "..\locale\nl\*"; DestDir: "{app}\locale\nl"; Flags: ignoreversion
Source: "..\locale\pl\*"; DestDir: "{app}\locale\pl"; Flags: ignoreversion
Source: "..\locale\pt\*"; DestDir: "{app}\locale\pt"; Flags: ignoreversion
Source: "..\locale\pt_BR\*"; DestDir: "{app}\locale\pt_BR"; Flags: ignoreversion
Source: "..\locale\ru\*"; DestDir: "{app}\locale\ru"; Flags: ignoreversion
Source: "..\locale\sk\*"; DestDir: "{app}\locale\sk"; Flags: ignoreversion
Source: "..\locale\sl\*"; DestDir: "{app}\locale\sl"; Flags: ignoreversion
Source: "..\locale\sr\*"; DestDir: "{app}\locale\sr"; Flags: ignoreversion
Source: "..\locale\sv\*"; DestDir: "{app}\locale\sv"; Flags: ignoreversion
Source: "..\locale\vi\*"; DestDir: "{app}\locale\vi"; Flags: ignoreversion
Source: "..\locale\zh_TW\*"; DestDir: "{app}\locale\zh_TW"; Flags: ignoreversion

[Icons]
Name: "{group}\DVDStyler"; Filename: "{app}\bin\DVDStyler.exe"
Name: "{group}\{cm:ProgramOnTheWeb,DVDStyler}"; Filename: "http://www.dvdstyler.org/"
Name: "{group}\{cm:UninstallProgram,DVDStyler}"; Filename: "{uninstallexe}"
Name: "{userdesktop}\DVDStyler"; Filename: "{app}\bin\DVDStyler.exe"; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\DVDStyler"; Filename: "{app}\bin\DVDStyler.exe"; Tasks: quicklaunchicon

[INI]
Filename: "{app}\DVDStyler.ini"; Section: "Interface"; Flags: uninsdeletesection
Filename: "{app}\DVDStyler.ini"; Section: "Interface"; Key: "LanguageCode"; String: "{language}"

[UninstallDelete]
Type: files; Name: "{app}\DVDStyler.ini"

[Run]
Filename: "{app}\bin\DVDStyler.exe"; Description: "{cm:LaunchProgram,DVDStyler}"; Flags: nowait postinstall skipifsilent



