/*
Copyright (C) 2000  Steffen Zschaler

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * DocCommentViewer.java
 *
 * Created on 18. September 2000, 16:13
 */
 
package tudresden.ocl.injection.reverseeng;

/** 
  * Viewer for documentation comments associated with an 
  * {@link AbstractDescriptor}. Automatically ensures up-to-dateness wrt. the descriptor.
  *
  * @author  sz9 (Steffen Zschaler)
  * @version 0.1
  */
public class DocCommentViewer extends javax.swing.JPanel implements AbstractDescriptor.AbstractDescriptorListener {

  private AbstractDescriptor m_adModel;
  
  /** 
    * Creates new form DocCommentViewer 
    */
  public DocCommentViewer () {
    super();
    
    initComponents ();    
  }

  public void setModel (AbstractDescriptor adModel) {
    if (m_adModel != null) {
      m_adModel.removeModifiedListener (this);
    }
    
    m_adModel = adModel;
    m_adModel.addModifiedListener (this);
    
    m_jtaDocComment.setText (m_adModel.getDocComment());
  }
  
  public boolean isEditable() {
    return m_jtaDocComment.isEditable();
  }
  
  public void setEditable (boolean fEditable) {
    m_jtaDocComment.setEditable (fEditable);
  }
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents () {//GEN-BEGIN:initComponents
    m_jspDocComment = new javax.swing.JScrollPane ();
    m_jtaDocComment = new javax.swing.JTextArea ();
    setLayout (new java.awt.GridBagLayout ());
    java.awt.GridBagConstraints gridBagConstraints1;


      m_jtaDocComment.setBackground (java.awt.Color.lightGray);
      m_jtaDocComment.setEditable (false);
  
      m_jspDocComment.setViewportView (m_jtaDocComment);
  

    gridBagConstraints1 = new java.awt.GridBagConstraints ();
    gridBagConstraints1.gridwidth = 0;
    gridBagConstraints1.gridheight = 0;
    gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints1.anchor = java.awt.GridBagConstraints.NORTHWEST;
    gridBagConstraints1.weightx = 1.0;
    gridBagConstraints1.weighty = 1.0;
    add (m_jspDocComment, gridBagConstraints1);

  }//GEN-END:initComponents


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JScrollPane m_jspDocComment;
  private javax.swing.JTextArea m_jtaDocComment;
  // End of variables declaration//GEN-END:variables

  public void onDescriptorModified (AbstractDescriptor.AbstractDescriptorEvent ade) {
    m_jtaDocComment.setText (m_adModel.getDocComment());
  }
  
  public void onFinalRemove() {
    m_adModel.removeModifiedListener (this);
  }
}