/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sablecc.sablecc.BooleanCast;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.NodeCast;
import org.sablecc.sablecc.NodeComparator;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.StringComparator;
import org.sablecc.sablecc.TypedLinkedList;
import org.sablecc.sablecc.TypedTreeMap;
import org.sablecc.sablecc.analysis.AnalysisAdapter;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.Alt1;
import org.sablecc.sablecc.node.Alt2;
import org.sablecc.sablecc.node.AltName1;
import org.sablecc.sablecc.node.AltNameOpt1;
import org.sablecc.sablecc.node.AltNameOpt2;
import org.sablecc.sablecc.node.Basic4;
import org.sablecc.sablecc.node.Elem1;
import org.sablecc.sablecc.node.ElemName1;
import org.sablecc.sablecc.node.ElemNameOpt1;
import org.sablecc.sablecc.node.ElemNameOpt2;
import org.sablecc.sablecc.node.HelperDef1;
import org.sablecc.sablecc.node.IdList1;
import org.sablecc.sablecc.node.IdListTail1;
import org.sablecc.sablecc.node.IgnTokens1;
import org.sablecc.sablecc.node.LookAhead1;
import org.sablecc.sablecc.node.Node;
import org.sablecc.sablecc.node.PkgName1;
import org.sablecc.sablecc.node.PkgNameTail1;
import org.sablecc.sablecc.node.Prod1;
import org.sablecc.sablecc.node.Productions1;
import org.sablecc.sablecc.node.Specifier1;
import org.sablecc.sablecc.node.SpecifierOpt1;
import org.sablecc.sablecc.node.StateList1;
import org.sablecc.sablecc.node.StateListTail1;
import org.sablecc.sablecc.node.States1;
import org.sablecc.sablecc.node.TSlash;
import org.sablecc.sablecc.node.Token;
import org.sablecc.sablecc.node.TokenDef1;
import org.sablecc.sablecc.node.Transition1;

public class ResolveIds
extends DepthFirstAdapter {
    public final Map helpers = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map states = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map tokens = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map ignTokens = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map prods = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map alts = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map elems = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map names = new TypedTreeMap(NodeComparator.instance, (Cast)NodeCast.instance, (Cast)StringCast.instance);
    public final Map errorNames = new TypedTreeMap(NodeComparator.instance, (Cast)NodeCast.instance, (Cast)StringCast.instance);
    public final Map elemTypes = new TypedTreeMap(NodeComparator.instance, (Cast)NodeCast.instance, (Cast)StringCast.instance);
    public final Map fixedTokens = new TypedTreeMap(NodeComparator.instance, (Cast)NodeCast.instance, (Cast)BooleanCast.instance);
    public final List tokenList = new TypedLinkedList(StringCast.instance);
    public final LinkedList stateList = new TypedLinkedList(StringCast.instance);
    public File pkgDir;
    public String pkgName = "";
    private boolean processingStates;
    private boolean processingIgnTokens;
    String currentProd;
    String currentAlt;
    private int lastLine;
    private int lastPos;
    private Map stateMap;

    public ResolveIds(File file) {
        this.pkgDir = file;
    }

    public void caseBasic4(Basic4 basic4) {
        String string = basic4.getNode1().getText();
        if (this.helpers.get(string) == null) {
            ResolveIds.error2(basic4.getNode1(), string);
        }
    }

    public void caseElem1(final Elem1 elem1) {
        elem1.getNode1().apply(new AnalysisAdapter(){

            public void caseElemNameOpt1(ElemNameOpt1 elemNameOpt1) {
                String string = String.valueOf(currentAlt) + "." + ResolveIds.name(((ElemName1)elemNameOpt1.getNode1()).getNode2().getText());
                if (elems.put(string, elem1) != null) {
                    ResolveIds.error(((ElemName1)elemNameOpt1.getNode1()).getNode2(), string);
                }
                if (((ElemName1)elemNameOpt1.getNode1()).getNode2().getText().equals("class")) {
                    ResolveIds.error5(((ElemName1)elemNameOpt1.getNode1()).getNode2());
                }
                names.put(elem1, ResolveIds.name(((ElemName1)elemNameOpt1.getNode1()).getNode2().getText()));
            }

            public void caseElemNameOpt2(ElemNameOpt2 elemNameOpt2) {
                String string = String.valueOf(currentAlt) + "." + ResolveIds.name(elem1.getNode3().getText());
                if (elems.put(string, elem1) != null) {
                    ResolveIds.error(elem1.getNode3(), string);
                }
                if (elem1.getNode3().getText().equals("class")) {
                    ResolveIds.error5(elem1.getNode3());
                }
                names.put(elem1, ResolveIds.name(elem1.getNode3().getText()));
            }
        });
    }

    public void defaultcase(Node node) {
        if (node instanceof Token) {
            Token token = (Token)node;
            this.lastLine = token.getLine();
            this.lastPos = token.getPos() + token.getText().length();
        }
    }

    private void error(String string) {
        throw new RuntimeException("[" + this.lastLine + "," + this.lastPos + "] " + "Redefinition of " + string + ".");
    }

    private static void error(Token token, String string) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + "Redefinition of " + string + ".");
    }

    private static void error2(Token token, String string) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + string + " undefined.");
    }

    private static void error3(Token token, String string) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + string + " is ignored.");
    }

    private static void error4(Token token, String string) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + "ambiguous " + string + ".");
    }

    private static void error5(Token token) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + "class is an invalid element name.");
    }

    public static String errorName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '_': {
                    stringBuffer.append(' ');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                    break;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void inAlt1(Alt1 alt1) {
        alt1.getNode1().apply(new Alt1Switch(alt1));
    }

    public void inAlt2(Alt2 alt2) {
        alt2.getNode2().apply(new Alt2Switch(alt2));
    }

    public void inIdList1(IdList1 idList1) {
        String string;
        if (this.processingStates) {
            string = idList1.getNode1().getText().toUpperCase();
            if (this.states.put(string, idList1.getNode1()) != null) {
                ResolveIds.error(idList1.getNode1(), string);
            }
            this.names.put(idList1.getNode1(), string);
            this.stateList.add(string);
        }
        if (this.processingIgnTokens) {
            string = "T" + ResolveIds.name(idList1.getNode1().getText());
            if (this.tokens.get(string) == null) {
                ResolveIds.error2(idList1.getNode1(), string);
            }
            if (this.ignTokens.put(string, idList1.getNode1()) != null) {
                ResolveIds.error(idList1.getNode1(), string);
            }
            this.names.put(idList1.getNode1(), string);
        }
    }

    public void inIdListTail1(IdListTail1 idListTail1) {
        String string;
        if (this.processingStates) {
            string = idListTail1.getNode2().getText().toUpperCase();
            if (this.states.put(string, idListTail1.getNode2()) != null) {
                ResolveIds.error(idListTail1.getNode2(), string);
            }
            this.names.put(idListTail1.getNode2(), string);
            this.stateList.add(string);
        }
        if (this.processingIgnTokens) {
            string = "T" + ResolveIds.name(idListTail1.getNode2().getText());
            if (this.tokens.get(string) == null) {
                ResolveIds.error2(idListTail1.getNode2(), string);
            }
            if (this.ignTokens.put(string, idListTail1.getNode2()) != null) {
                ResolveIds.error(idListTail1.getNode2(), string);
            }
            this.names.put(idListTail1.getNode2(), string);
        }
    }

    public void inIgnTokens1(IgnTokens1 ignTokens1) {
        this.processingIgnTokens = true;
    }

    public void inLookAhead1(LookAhead1 lookAhead1) {
        TSlash tSlash = lookAhead1.getNode1();
        throw new RuntimeException("[" + tSlash.getLine() + "," + tSlash.getPos() + "] " + "Look ahead not yet supported.");
    }

    public void inPkgName1(PkgName1 pkgName1) {
        this.pkgName = pkgName1.getNode1().getText();
        this.pkgDir = new File(this.pkgDir, pkgName1.getNode1().getText());
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    public void inPkgNameTail1(PkgNameTail1 pkgNameTail1) {
        this.pkgName = String.valueOf(this.pkgName) + "." + pkgNameTail1.getNode2().getText();
        this.pkgDir = new File(this.pkgDir, pkgNameTail1.getNode2().getText());
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    public void inProd1(Prod1 prod1) {
        this.currentProd = ResolveIds.name(prod1.getNode1().getText());
        String string = "P" + this.currentProd;
        if (this.prods.put(string, prod1) != null) {
            ResolveIds.error(prod1.getNode1(), string);
        }
        this.names.put(prod1, string);
    }

    public void inStateList1(StateList1 stateList1) {
        this.stateMap = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
        String string = stateList1.getNode2().getText().toUpperCase();
        if (this.states.get(string) == null) {
            ResolveIds.error2(stateList1.getNode2(), string);
        }
        if (this.stateMap.put(string, stateList1) != null) {
            ResolveIds.error(stateList1.getNode2(), string);
        }
    }

    public void inStateListTail1(StateListTail1 stateListTail1) {
        String string = stateListTail1.getNode2().getText().toUpperCase();
        if (this.states.get(string) == null) {
            ResolveIds.error2(stateListTail1.getNode2(), string);
        }
        if (this.stateMap.put(string, stateListTail1) != null) {
            ResolveIds.error(stateListTail1.getNode2(), string);
        }
    }

    public void inStates1(States1 states1) {
        this.processingStates = true;
    }

    public void inTransition1(Transition1 transition1) {
        String string = transition1.getNode2().getText().toUpperCase();
        if (this.states.get(string) == null) {
            ResolveIds.error2(transition1.getNode2(), string);
        }
    }

    public static String name(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '_': {
                    bl = true;
                    break;
                }
                default: {
                    if (bl) {
                        stringBuffer.append(Character.toUpperCase(c));
                        bl = false;
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void outHelperDef1(HelperDef1 helperDef1) {
        String string = helperDef1.getNode1().getText();
        if (this.helpers.put(string, helperDef1) != null) {
            ResolveIds.error(helperDef1.getNode1(), string);
        }
        this.names.put(helperDef1, string);
    }

    public void outIgnTokens1(IgnTokens1 ignTokens1) {
        this.processingIgnTokens = false;
    }

    public void outProductions1(Productions1 productions1) {
        productions1.apply(new DepthFirstAdapter(){

            public void caseElem1(Elem1 elem1) {
                String string = ResolveIds.name(elem1.getNode3().getText());
                if (elem1.getNode2() instanceof SpecifierOpt1) {
                    if (((SpecifierOpt1)elem1.getNode2()).getNode1() instanceof Specifier1) {
                        if (ResolveIds.this.tokens.get("T" + string) == null) {
                            ResolveIds.error2(elem1.getNode3(), "T" + string);
                        }
                        if (ResolveIds.this.ignTokens.get("T" + string) != null) {
                            ResolveIds.error3(elem1.getNode3(), "T" + string);
                        }
                        ResolveIds.this.elemTypes.put(elem1, "T" + string);
                    } else {
                        if (ResolveIds.this.prods.get("P" + string) == null) {
                            ResolveIds.error2(elem1.getNode3(), "P" + string);
                        }
                        ResolveIds.this.elemTypes.put(elem1, "P" + string);
                    }
                } else {
                    Object v = ResolveIds.this.tokens.get("T" + string);
                    Object v2 = ResolveIds.this.ignTokens.get("T" + string);
                    Object v3 = ResolveIds.this.prods.get("P" + string);
                    if (v == null && v3 == null) {
                        ResolveIds.error2(elem1.getNode3(), "P" + string + " and T" + string);
                    }
                    if (v != null) {
                        if (v3 != null) {
                            ResolveIds.error4(elem1.getNode3(), "P" + string + " and T" + string);
                        }
                        if (v2 != null) {
                            ResolveIds.error3(elem1.getNode3(), "T" + string);
                        }
                        ResolveIds.this.elemTypes.put(elem1, "T" + string);
                    } else {
                        ResolveIds.this.elemTypes.put(elem1, "P" + string);
                    }
                }
            }
        });
    }

    public void outStateList1(StateList1 stateList1) {
        this.stateMap = null;
    }

    public void outStates1(States1 states1) {
        this.processingStates = false;
    }

    public void outTokenDef1(TokenDef1 tokenDef1) {
        String string = "T" + ResolveIds.name(tokenDef1.getNode2().getText());
        String string2 = ResolveIds.errorName(tokenDef1.getNode2().getText());
        if (this.tokens.put(string, tokenDef1) != null) {
            ResolveIds.error(tokenDef1.getNode2(), string);
        }
        this.names.put(tokenDef1, string);
        this.errorNames.put(tokenDef1, string2);
        this.tokenList.add(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("Helpers:");
        stringBuffer.append(string);
        stringBuffer.append(this.helpers);
        stringBuffer.append(string);
        stringBuffer.append("States:");
        stringBuffer.append(string);
        stringBuffer.append(this.states);
        stringBuffer.append(string);
        stringBuffer.append("Tokens:");
        stringBuffer.append(string);
        stringBuffer.append(this.tokens);
        stringBuffer.append(string);
        stringBuffer.append("Ignored Tokens:");
        stringBuffer.append(string);
        stringBuffer.append(this.ignTokens);
        stringBuffer.append(string);
        stringBuffer.append("Productions:");
        stringBuffer.append(string);
        stringBuffer.append(this.prods);
        stringBuffer.append(string);
        stringBuffer.append("Alternatives:");
        stringBuffer.append(string);
        stringBuffer.append(this.alts);
        stringBuffer.append(string);
        stringBuffer.append("Elements:");
        stringBuffer.append(string);
        stringBuffer.append(this.elems);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private class Alt1Switch
    extends AnalysisAdapter {
        Alt1 alt;

        Alt1Switch(Alt1 alt1) {
            this.alt = alt1;
        }

        public void caseAltNameOpt1(AltNameOpt1 altNameOpt1) {
            ResolveIds.this.currentAlt = "A" + ResolveIds.name(((AltName1)altNameOpt1.getNode1()).getNode2().getText()) + ResolveIds.this.currentProd;
            if (ResolveIds.this.alts.put(ResolveIds.this.currentAlt, this.alt) != null) {
                ResolveIds.error(((AltName1)altNameOpt1.getNode1()).getNode2(), ResolveIds.this.currentAlt);
            }
            ResolveIds.this.names.put(this.alt, ResolveIds.this.currentAlt);
        }

        public void caseAltNameOpt2(AltNameOpt2 altNameOpt2) {
            ResolveIds.this.currentAlt = "A" + ResolveIds.this.currentProd;
            if (ResolveIds.this.alts.put(ResolveIds.this.currentAlt, this.alt) != null) {
                ResolveIds.this.error(ResolveIds.this.currentAlt);
            }
            ResolveIds.this.names.put(this.alt, ResolveIds.this.currentAlt);
        }
    }

    private class Alt2Switch
    extends AnalysisAdapter {
        Alt2 alt;

        Alt2Switch(Alt2 alt2) {
            this.alt = alt2;
        }

        public void caseAltNameOpt1(AltNameOpt1 altNameOpt1) {
            ResolveIds.this.currentAlt = "A" + ResolveIds.name(((AltName1)altNameOpt1.getNode1()).getNode2().getText()) + ResolveIds.this.currentProd;
            if (ResolveIds.this.alts.put(ResolveIds.this.currentAlt, this.alt) != null) {
                ResolveIds.error(((AltName1)altNameOpt1.getNode1()).getNode2(), ResolveIds.this.currentAlt);
            }
            ResolveIds.this.names.put(this.alt, ResolveIds.this.currentAlt);
        }

        public void caseAltNameOpt2(AltNameOpt2 altNameOpt2) {
            ResolveIds.this.currentAlt = "A" + ResolveIds.this.currentProd;
            if (ResolveIds.this.alts.put(ResolveIds.this.currentAlt, this.alt) != null) {
                ResolveIds.this.error(ResolveIds.this.currentAlt);
            }
            ResolveIds.this.names.put(this.alt, ResolveIds.this.currentAlt);
        }
    }
}

