/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.GenAlts;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.NodeCast;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.StringComparator;
import org.sablecc.sablecc.TypedTreeMap;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.Elem1;
import org.sablecc.sablecc.node.Prod1;
import org.sablecc.sablecc.node.UnOp1;
import org.sablecc.sablecc.node.UnOp3;

public class GenProds
extends DepthFirstAdapter {
    private MacroExpander macros;
    private ResolveIds ids;
    private File pkgDir;
    private String pkgName;
    private Map hiddenProds = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);

    public GenProds(ResolveIds resolveIds) {
        this.ids = resolveIds;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("productions.txt")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to open productions.txt.");
        }
        this.pkgDir = new File(resolveIds.pkgDir, "node");
        String string = this.pkgName = resolveIds.pkgName.equals("") ? "node" : String.valueOf(resolveIds.pkgName) + ".node";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    private void createAlternative(String string, String string2, String[] stringArray) {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, String.valueOf(string) + ".java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, String.valueOf(string) + ".java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, string2, stringArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, String.valueOf(string) + ".java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
    }

    private void createProduction(String string) {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, String.valueOf(string) + ".java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, String.valueOf(string) + ".java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "Production", new String[]{this.pkgName, string});
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, String.valueOf(string) + ".java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
    }

    public void inProd1(Prod1 prod1) {
        String string = (String)this.ids.names.get(prod1);
        this.createProduction(string);
    }

    public void inUnOp1(UnOp1 unOp1) {
        Elem1 elem1;
        String string;
        if (unOp1.getParent().getParent() instanceof Elem1 && this.hiddenProds.put("X" + (string = (String)this.ids.elemTypes.get(elem1 = (Elem1)unOp1.getParent().getParent())), elem1) == null) {
            this.createProduction("X" + string);
            this.createAlternative("X1" + string, "HiddenAlternative2", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "analysis" : String.valueOf(this.ids.pkgName) + ".analysis", "X1" + string, "X" + string, string, GenAlts.nodeName(string), GenAlts.nodeName("X" + string)});
            this.createAlternative("X2" + string, "HiddenAlternative1", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "analysis" : String.valueOf(this.ids.pkgName) + ".analysis", "X2" + string, "X" + string, string, GenAlts.nodeName(string)});
        }
    }

    public void inUnOp3(UnOp3 unOp3) {
        Elem1 elem1;
        String string;
        if (unOp3.getParent().getParent() instanceof Elem1 && this.hiddenProds.put("X" + (string = (String)this.ids.elemTypes.get(elem1 = (Elem1)unOp3.getParent().getParent())), elem1) == null) {
            this.createProduction("X" + string);
            this.createAlternative("X1" + string, "HiddenAlternative2", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "analysis" : String.valueOf(this.ids.pkgName) + ".analysis", "X1" + string, "X" + string, string, GenAlts.nodeName(string), GenAlts.nodeName("X" + string)});
            this.createAlternative("X2" + string, "HiddenAlternative1", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "analysis" : String.valueOf(this.ids.pkgName) + ".analysis", "X2" + string, "X" + string, string, GenAlts.nodeName(string)});
        }
    }
}

