/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.TypedLinkedList;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.Alt;
import org.sablecc.sablecc.node.Alt1;
import org.sablecc.sablecc.node.Alt2;
import org.sablecc.sablecc.node.Elem1;
import org.sablecc.sablecc.node.Prod1;
import org.sablecc.sablecc.node.Start1;
import org.sablecc.sablecc.node.TokenDef1;
import org.sablecc.sablecc.node.UnOp1;
import org.sablecc.sablecc.node.UnOp2;
import org.sablecc.sablecc.node.UnOp3;

public class GenAnalyses
extends DepthFirstAdapter {
    private MacroExpander macros;
    private ResolveIds ids;
    private File pkgDir;
    private String pkgName;
    private List elemList;
    private List altList = new TypedLinkedList(AltInfoCast.instance);
    private List tokenList = new TypedLinkedList(StringCast.instance);
    private String mainProduction;
    ElemInfo info;

    public GenAnalyses(ResolveIds resolveIds) {
        this.ids = resolveIds;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("analyses.txt")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to open analyses.txt.");
        }
        this.pkgDir = new File(resolveIds.pkgDir, "analysis");
        String string = this.pkgName = resolveIds.pkgName.equals("") ? "analysis" : String.valueOf(resolveIds.pkgName) + ".analysis";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    public void createAnalysis() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Analysis.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Analysis.java").getAbsolutePath());
        }
        try {
            Iterator iterator;
            this.macros.apply(bufferedWriter, "AnalysisHeader", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "node" : String.valueOf(this.ids.pkgName) + ".node"});
            if (this.mainProduction != null) {
                this.macros.apply(bufferedWriter, "AnalysisStart", null);
                iterator = this.altList.iterator();
                while (iterator.hasNext()) {
                    AltInfo altInfo = (AltInfo)iterator.next();
                    this.macros.apply(bufferedWriter, "AnalysisBody", new String[]{altInfo.name});
                }
                bufferedWriter.newLine();
            }
            iterator = this.tokenList.iterator();
            while (iterator.hasNext()) {
                this.macros.apply(bufferedWriter, "AnalysisBody", new String[]{(String)iterator.next()});
            }
            this.macros.apply(bufferedWriter, "AnalysisTail", null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Analysis.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
    }

    public void createAnalysisAdapter() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "AnalysisAdapter.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "AnalysisAdapter.java").getAbsolutePath());
        }
        try {
            Iterator iterator;
            this.macros.apply(bufferedWriter, "AnalysisAdapterHeader", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "node" : String.valueOf(this.ids.pkgName) + ".node"});
            if (this.mainProduction != null) {
                this.macros.apply(bufferedWriter, "AnalysisAdapterStart", null);
                iterator = this.altList.iterator();
                while (iterator.hasNext()) {
                    AltInfo altInfo = (AltInfo)iterator.next();
                    this.macros.apply(bufferedWriter, "AnalysisAdapterBody", new String[]{altInfo.name});
                }
            }
            iterator = this.tokenList.iterator();
            while (iterator.hasNext()) {
                this.macros.apply(bufferedWriter, "AnalysisAdapterBody", new String[]{(String)iterator.next()});
            }
            this.macros.apply(bufferedWriter, "AnalysisAdapterTail", null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "AnalysisAdapter.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
    }

    public void createDepthFirstAdapter() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "DepthFirstAdapter.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "DepthFirstAdapter.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "DepthFirstAdapterHeader", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "node" : String.valueOf(this.ids.pkgName) + ".node", this.mainProduction});
            Iterator iterator = this.altList.iterator();
            while (iterator.hasNext()) {
                AltInfo altInfo = (AltInfo)iterator.next();
                this.macros.apply(bufferedWriter, "DepthFirstAdapterInOut", new String[]{altInfo.name});
                this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseHeader", new String[]{altInfo.name});
                Iterator iterator2 = altInfo.elems.iterator();
                while (iterator2.hasNext()) {
                    ElemInfo elemInfo = (ElemInfo)iterator2.next();
                    switch (elemInfo.operator) {
                        case 0: 
                        case 2: {
                            this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseBodyNode", new String[]{elemInfo.name});
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseBodyList", new String[]{elemInfo.name, elemInfo.type});
                            break;
                        }
                    }
                }
                this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseTail", new String[]{altInfo.name});
            }
            this.macros.apply(bufferedWriter, "DepthFirstAdapterTail", null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "DepthFirstAdapter.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
    }

    public void createReversedDepthFirstAdapter() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "ReversedDepthFirstAdapter.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "ReversedDepthFirstAdapter.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "ReversedDepthFirstAdapterHeader", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "node" : String.valueOf(this.ids.pkgName) + ".node", this.mainProduction});
            Iterator iterator = this.altList.iterator();
            while (iterator.hasNext()) {
                AltInfo altInfo = (AltInfo)iterator.next();
                this.macros.apply(bufferedWriter, "DepthFirstAdapterInOut", new String[]{altInfo.name});
                this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseHeader", new String[]{altInfo.name});
                ListIterator listIterator = altInfo.elems.listIterator(altInfo.elems.size());
                while (listIterator.hasPrevious()) {
                    ElemInfo elemInfo = (ElemInfo)listIterator.previous();
                    switch (elemInfo.operator) {
                        case 0: 
                        case 2: {
                            this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseBodyNode", new String[]{elemInfo.name});
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.macros.apply(bufferedWriter, "ReversedDepthFirstAdapterCaseBodyList", new String[]{elemInfo.name, elemInfo.type});
                            break;
                        }
                    }
                }
                this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseTail", new String[]{altInfo.name});
            }
            this.macros.apply(bufferedWriter, "DepthFirstAdapterTail", null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "ReversedDepthFirstAdapter.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
    }

    public void inAlt(Alt alt) {
        this.elemList = new TypedLinkedList(ElemInfoCast.instance);
    }

    public void inAlt1(Alt1 alt1) {
        this.inAlt(alt1);
    }

    public void inAlt2(Alt2 alt2) {
        this.inAlt(alt2);
    }

    public void inElem1(Elem1 elem1) {
        this.info = new ElemInfo();
        this.info.name = (String)this.ids.names.get(elem1);
        this.info.type = (String)this.ids.elemTypes.get(elem1);
        this.info.operator = 0;
        elem1.getNode4().apply(new DepthFirstAdapter(){

            public void caseUnOp1(UnOp1 unOp1) {
                GenAnalyses.this.info.operator = 1;
            }

            public void caseUnOp2(UnOp2 unOp2) {
                GenAnalyses.this.info.operator = 2;
            }

            public void caseUnOp3(UnOp3 unOp3) {
                GenAnalyses.this.info.operator = 3;
            }
        });
        this.elemList.add(this.info);
        this.info = null;
    }

    public void inProd1(Prod1 prod1) {
        if (this.mainProduction == null) {
            this.mainProduction = (String)this.ids.names.get(prod1);
        }
    }

    public void inTokenDef1(TokenDef1 tokenDef1) {
        this.tokenList.add(this.ids.names.get(tokenDef1));
    }

    public void outAlt(Alt alt) {
        AltInfo altInfo = new AltInfo();
        altInfo.name = (String)this.ids.names.get(alt);
        altInfo.elems.addAll(this.elemList);
        this.elemList = null;
        this.altList.add(altInfo);
    }

    public void outAlt1(Alt1 alt1) {
        this.outAlt(alt1);
    }

    public void outAlt2(Alt2 alt2) {
        this.outAlt(alt2);
    }

    public void outStart1(Start1 start1) {
        this.createAnalysis();
        this.createAnalysisAdapter();
        if (this.mainProduction != null) {
            this.createDepthFirstAdapter();
            this.createReversedDepthFirstAdapter();
        }
    }

    private static class ElemInfo {
        static final int NONE = 0;
        static final int STAR = 1;
        static final int QMARK = 2;
        static final int PLUS = 3;
        String name;
        String type;
        int operator;

        ElemInfo() {
        }
    }

    private static class ElemInfoCast
    implements Cast {
        static final ElemInfoCast instance = new ElemInfoCast();

        private ElemInfoCast() {
        }

        public Object cast(Object object) {
            return (ElemInfo)object;
        }
    }

    private static class AltInfo {
        String name;
        final List elems = new TypedLinkedList(ElemInfoCast.instance);

        AltInfo() {
        }
    }

    private static class AltInfoCast
    implements Cast {
        static final AltInfoCast instance = new AltInfoCast();

        private AltInfoCast() {
        }

        public Object cast(Object object) {
            return (AltInfo)object;
        }
    }
}

