/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.uml.foundation.data_types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import ru.novosoft.uml.foundation.data_types.MMultiplicityRange;

public final class MMultiplicity
implements Serializable {
    public static final int N = -1;
    public static final MMultiplicity M0_1 = new MMultiplicity(0, 1);
    public static final MMultiplicity M1_1 = new MMultiplicity(1, 1);
    public static final MMultiplicity M0_N = new MMultiplicity(0, -1);
    public static final MMultiplicity M1_N = new MMultiplicity(1, -1);
    final List ranges;

    public List getRanges() {
        return this.ranges;
    }

    public int getUpper() {
        return ((MMultiplicityRange)this.ranges.get(this.ranges.size() - 1)).getUpper();
    }

    public int getLower() {
        return ((MMultiplicityRange)this.ranges.get(0)).getLower();
    }

    public String toString() {
        String rc = "";
        Iterator i = this.ranges.iterator();
        boolean first = true;
        while (i.hasNext()) {
            if (first) {
                first = false;
            } else {
                rc = rc + ",";
            }
            rc = rc + i.next();
        }
        return rc;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static List parseRanges(String str) {
        StringTokenizer stk = new StringTokenizer(str, ",");
        if (!stk.hasMoreTokens()) {
            throw new IllegalArgumentException("empty multiplicity");
        }
        ArrayList<MMultiplicityRange> rc = new ArrayList<MMultiplicityRange>();
        while (stk.hasMoreTokens()) {
            rc.add(new MMultiplicityRange(stk.nextToken()));
        }
        return rc;
    }

    public MMultiplicity(String str) {
        this.ranges = Collections.unmodifiableList(MMultiplicity.parseRanges(str));
    }

    public MMultiplicity(int lower, int upper) {
        ArrayList<MMultiplicityRange> l = new ArrayList<MMultiplicityRange>();
        l.add(new MMultiplicityRange(lower, upper));
        this.ranges = Collections.unmodifiableList(l);
    }

    public MMultiplicity(List ranges) {
        this.ranges = Collections.unmodifiableList(new ArrayList(ranges));
    }
}

