#!/bin/bash

# Copyright (c) 2002-2007 Userful Corporation. All rights reserved.
# http://www.userful.com/

# register.sh

LPB=/usr/share/1box-utils/launch-preferred-browser.sh

ERR_DLG=/usr/share/1box-utils/error-dialog.py
if [ ! -x $ERR_DLG ] ; then
    ERR_DLG=./error-dialog.py
fi 

if [ ! -x $ERR_DLG ] ; then
    ERR_DLG=echo
fi

# This URL will have the payload: a license file and MAC address in the first 
# 512 bytes of the URL string. The system information at the end is largely 
# optional, but nice.

# old url: URL="http://store.userful.com/license/control/GenerateLicense?"
#URL="http://store.userful.com/license/control/freelicense?"
URL="http://store.userful.com/license/control/licenseRegister?"
# for testing
#URL="http://bob.userful.ca/license/control/freelicense?"

ETH_NUM=0

MAC=`LANG=C /sbin/ifconfig -a eth$ETH_NUM | grep "HWaddr" | awk '{ print $5 }'`

if [ -z "$MAC" ] || [ ${#MAC} != 17 ] ; then 
    # MAC is no good
    MAC=nomac
fi

SYSID=none
if [ -f /etc/userful/sys-id ] ; then
    SYSID=`cat /etc/userful/sys-id`
fi
URL="${URL}sysid=$SYSID"

# license file order:
# http://wiki.userful.ca/wiki/index.php?title=License_File
# : - _

MAC_COLONS=$MAC
MAC_DASHES=${MAC//:/-}
MAC_UNDERS=${MAC//:/_}

#if false ; then
FILENAME=
if [ -e /etc/X11/$MAC_COLONS.1Box.info ]; then
    FILENAME="/etc/X11/$MAC_COLONS.1Box.info"
elif [ -e /etc/X11/$MAC_DASHES.1Box.info ]; then
    FILENAME=/etc/X11/$MAC_DASHES.1Box.info
elif [ -e /etc/X11/$MAC_UNDERS.1Box.info ]; then
    FILENAME=/etc/X11/$MAC_UNDERS.1Box.info
elif [ -e /etc/X11/1Box.info ] ; then
    FILENAME="/etc/X11/1Box.info"
elif [ -e /etc/X11/1Box.info.trial ]; then
    FILENAME="/etc/X11/1Box.info.trial"
fi

LICENSE_KEY=
if [ -n "$FILENAME" ] ; then
    echo Found license: $FILENAME
    LICENSE_KEY="`/usr/share/1box-utils/b64encode.py $FILENAME`"
    URL="${URL}&lickey=$LICENSE_KEY"
fi
#fi # if false

if [ $SYSID != none ] ; then
    MAC=000000000000
    # why not? 00000000
fi

if [ $MAC == nomac ] ; then
    exec $ERR_DLG "No valid MAC address found. Please contact Userful: http://store.userful.com/ or 1-(866)-USERFUL."
else
    URL="${URL}&mac=${MAC//:/}"
fi

if false ; then
if [ -r /dev/mem ] ; then
    /usr/sbin/dmidecode > /tmp/hardware-$$ 2> /dev/null
    RET=$?
    trap "rm -f /tmp/hardware-$$" EXIT
    if [ $RET == 0 ] ; then
        gzip /tmp/hardware-$$
        HARDWARE="`/usr/share/1box-utils/b64encode.py /tmp/hardware-$$.gz`"
        if [ -n "$HARDWARE" ] ; then
            URL="${URL}&info=$HARDWARE"
        fi
    fi
fi
fi # if false

if [ -z "$DISPLAY" ] ; then
	echo 
	echo "There is no DISPLAY variable set, I will not attempt to start a web browser."
	echo "Please go to the following URL to register:"
	echo 
	echo $URL
	echo 
	exit 0
fi

#firefox "$URL"
exec $LPB "$URL"
#exec $LPB "`cat /tmp/url-$$`"

