/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// RProgressor.h: interface for the CRProgressor class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_RPROGRESSOR_H__)
#define _RPROGRESSOR_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "globus.h"

typedef void   (*CRPStart)(void);
typedef void   (*CRPFinish)(void);
typedef Bool32 (*CRPStep)(Word32);

class CRProgressor
{

public:
	Bool32 SetStep(Word32 wPercent);
	Bool32 Finish(void);
	Bool32 Start(void);

public:
	Bool32 SetExternals(CRPStart pStart, CRPFinish pFinish, CRPStep pStep);
	CRProgressor();
	CRProgressor( CRPStart pStart, CRPFinish pFinish, CRPStep pStep);
	virtual ~CRProgressor();

protected:
	Handle hBufferForGray;
	Word32         mwLastPercent;
	Bool32         mbProgressStarted;
	CRPFinish      mfFinish;
	CRPStart       mfStart;
	CRPStep        mfStep;
private:
};
////////////////////////////////////////////////////////////////////////////////
typedef CRProgressor        *PCRProgressor, **PPCRProgressor;
////////////////////////////////////////////////////////////////////////////////
#endif // !defined(_RPROGRESSOR_H__)
