/**************************************************************************
 * 
 * Copyright (c) Intel Corp. 2007.
 * All Rights Reserved.
 *
 * Intel funded Tungsten Graphics (http://www.tungstengraphics.com) to
 * develop this driver.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDERS, AUTHORS AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE 
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 **************************************************************************/
/*
 */
#ifndef _PSB_H_
#define _PSB_H_

#include "xf86.h"
#include "xf86_OSproc.h"
#include "xf86Resources.h"
#include "compiler.h"
#include "xf86PciInfo.h"
#include "vgaHW.h"
#include "xf86Pci.h"
#include "vbe.h"
#include "vbeModes.h"
#include "xf86DDC.h"
#include "shadow.h"
#include "xf86int10.h"
#include "mibank.h"
#include "dgaproc.h"
#include "xf86Resources.h"
#include "xf86RAC.h"
#include "fb.h"
#include "xaa.h"
#include "xf86Crtc.h"
#include "xf86str.h"

#include "libmm/mm_defines.h"
#include "libmm/mm_interface.h"

#include "psb_buffers.h"
#include "psb_accel.h"

#ifdef XF86DRI
#include "psb_dri.h"
#define _XF86DRI_SERVER_
#include "GL/glxint.h"
#include "dri.h"
#if 0
#define PSB_LEGACY_DRI \
    ((DRIINFO_MAJOR_VERSION != 5) || (DRIINFO_MINOR_VERSION < 2))
#else
#define PSB_LEGACY_DRI 1
#endif
#endif

#define PSB_NUM_PIPES 2
#define PSB_MAX_CRTCS 2
#define PSB_MAX_SCREENS 2
#define PSB_SAVESWF_NUM 17

#define PSB_VERSION      4000
#define PSB_NAME         "PSB"
#define PSB_DRIVER_NAME  "Intel Poulsbo"
#define PSB_MAJOR_VERSION 0
#define PSB_MINOR_VERSION 0
#define PSB_PATCHLEVEL    1

#define PCI_CHIP_PSB  0x8108

#define PSB_DEBUG(_scrn, _level, ...)			\
  xf86DrvMsgVerb(_scrn, X_INFO, _level, "Debug: " __VA_ARGS__ )
#define ALIGN_TO(_arg, _align) \
  (((_arg) + ((_align) - 1)) & ~((_align) - 1))

/*
 * Multihead / Multiscreen note:
 * To clear up any confusion the following conventions are followed:
 * 
 * All resources common for a device are associated with a PsbDevice structure. Other structures may
 * have pointers to the PsbDevice structure they belong to.
 *
 * Each screen is associated with a logical framebuffer area somewhere in memory.
 * This logical framebuffer area may or may not have shadow copies (rotated or un-rotated).
 * Each screen is also assigned to a particular device.
 *
 * Each available output is a device resource and should be associated with a screen. This should either
 * be done from the configuration file, using default driver settings or through a utility function.
 *
 * A crtc is used to connect one or many outputs to their screen.
 * 
 */

typedef struct _PsbDevice
{

    unsigned deviceIndex;
    EntityInfoPtr pEnt;
    GDevPtr device;
    pciVideoPtr pciInfo;
    PCITAG pciTag;
    unsigned long regPhys;
    unsigned long regSize;
    unsigned long fbPhys;
    unsigned long fbSize;
    unsigned long stolenBase;
    unsigned long stolenSize;

    CARD8 *regMap;
    CARD8 *fbMap;

    int lastInstance;
    unsigned refCount;

    Bool outputInit;

#ifdef XF86DRI
    Bool hasDRM;
    int drmFD;
    drm_context_t drmContext;
    char *busIdString;
    int drmVerMajor;
    int drmVerMinor;
    int drmVerPL;
    int lockRefCount;
    void *pLSAREA;
    int irq;
#endif

    ScrnInfoPtr pScrns[PSB_MAX_SCREENS];
    unsigned numScreens;

    CARD32 saveSWF0;
    CARD32 saveSWF4;

    CARD32 saveSWF[PSB_SAVESWF_NUM];
    CARD32 saveVCLK_DIVISOR_VGA0;
    CARD32 saveVCLK_DIVISOR_VGA1;
    CARD32 saveVCLK_POST_DIV;
    CARD32 saveVGACNTRL;

    Bool swfSaved;
    Bool hwSaved;
    Bool deviceUp;

    MMManager *man;
    Bool mmLocked;
    int vtRefCount;

    char sdvoBName[60];
} PsbDevice, *PsbDevicePtr;

/*
 * Temporary i830 compatibility stuff. 
 */

typedef struct _I830Rec
{
    EntityInfoPtr pEnt;
    PCITAG PciTag;
    pciVideoPtr PciInfo;
    PsbDevicePtr pDevice;
} I830Rec, *I830Ptr;

#ifdef XF86DRI
typedef struct _PsbGLXConfig
{
    int numConfigs;
    __GLXvisualConfig *pConfigs;
    PsbConfigPrivPtr pPsbConfigs;
    PsbConfigPrivPtr *pPsbConfigPtrs;
} PsbGLXConfigRec, *PsbGLXConfigPtr;
#endif

typedef struct _PsbRec
{
/*
 * General stuff.
 */
    ScrnInfoPtr pScrn;
    PsbDevicePtr pDevice;
    CloseScreenProcPtr closeScreen;
    void (*PointerMoved)(int, int, int);
    Bool multiHead;
    Bool secondary;
    unsigned long serverGeneration;

    struct _MMBufList *list;
    struct _MMListHead buffers;

    PsbScanoutPtr front;

/*
 * Crtcs we can potentially use.
 */
    xf86CrtcPtr crtcs[PSB_MAX_CRTCS];
    unsigned numCrtcs;

/*
 *  Outputs we can potentially use.
 */

    MMListHead outputs;

/*
 * Virtual screen.
 */

    unsigned cpp;
    unsigned stride;
    unsigned long fbSize;
    CARD8 *fbMap;

    OptionInfoPtr options;

/*
 * ShadowFB
 */

    CARD8 *shadowMem;
    Bool shadowFB;
    CreateScreenResourcesProcPtr createScreenResources;
    ShadowUpdateProc update;
/*
 * Acceleration 
 */
    Bool noAccel;
    PsbExaPtr pPsbExa;
    unsigned long exaSize;
    unsigned long exaScratchSize;
    PsbTwodContextRec td;
    PsbTwodBufferRec cb;
    Bool exaCached;

/*
 * i830 driver compatibility.
 */

    I830Rec i830Ptr;

/*
 *  Misc
 */

    Bool sWCursor;
/* 
 * DRI
 */

#ifdef XF86DRI
    Bool dri;
    Bool driEnabled;
    DRIInfoPtr pDRIInfo;
    int drmFD;
    PsbGLXConfigRec glx;
    struct _MMListHead sAreaList;
#endif

} PsbRec, *PsbPtr;

#define PSB_CRTC0 (1 << 0)
#define PSB_CRTC1 (1 << 1)

typedef struct _PsbCrtcPrivateRec
{
    unsigned pipe;
    unsigned refCount;
    PsbScanoutPtr rotate;
    ScrnInfoPtr forScrn;

    /*
     * HW Cursor
     */

    Bool cursor_is_argb;
    unsigned long cursor_addr;
    unsigned long cursor_argb_addr;

    unsigned long cursor_offset;
    unsigned long cursor_argb_offset;

    struct _MMBuffer *cursor;

    CARD8 lutR[256];
    CARD8 lutG[256];
    CARD8 lutB[256];

    CARD32 saveDSPCNTR;
    CARD32 savePIPECONF;
    CARD32 savePIPESRC;
    CARD32 saveDPLL;
    CARD32 saveFP0;
    CARD32 saveFP1;
    CARD32 saveHTOTAL;
    CARD32 saveHBLANK;
    CARD32 saveHSYNC;
    CARD32 saveVTOTAL;
    CARD32 saveVBLANK;
    CARD32 saveVSYNC;
    CARD32 saveDSPSTRIDE;
    CARD32 saveDSPSIZE;
    CARD32 saveDSPPOS;
    CARD32 saveDSPBASE;
    CARD32 savePFITCTRL;
    CARD32 savePalette[256];

} PsbCrtcPrivateRec, *PsbCrtcPrivatePtr;

#define psbCrtcPrivate(_crtc)			\
    ((PsbCrtcPrivatePtr) (_crtc)->driver_private)

#define PSB_OUTPUT_UNUSED 0
#define PSB_OUTPUT_SDVO 1
#define PSB_OUTPUT_LVDS 2

typedef struct _PsbOutputPrivateRec
{
    int type;
    int refCount;
    I2CBusPtr pDDCBus;
    I2CBusPtr pI2CBus;
    PsbDevicePtr pDevice;
    Bool load_detect_temp;
    unsigned crtcMask;
    ScrnInfoPtr pScrn;		       /* Screen this output is currently assigned to. */
    const char *name;
    MMListHead driverOutputs;
} PsbOutputPrivateRec, *PsbOutputPrivatePtr;

static inline PsbPtr
psbPTR(ScrnInfoPtr pScrn)
{
    return ((PsbPtr) pScrn->driverPrivate);
}

static inline PsbDevicePtr
psbDevicePTR(PsbPtr pPsb)
{
    return pPsb->pDevice;
}

#define PSB_THALIA_OFFSET 0x00040000
#define PSB_SGX_2D_SLAVE_PORT 0x00044000
#define PSB_PAGE_SIZE 4096
#define PSB_PAGE_SHIFT 12
#define PSB_BIOS_POPUP_SIZE 4096;
#define PSB_BSM 0x5C
#define PSB_PGETBL_CTL 0x2020

#define PSB_RSGX32(_offs) \
  (*(volatile CARD32 *)(pDevice->regMap + PSB_THALIA_OFFSET + (_offs)))
#define PSB_WSGX32(_offs, _val)						\
  (*(volatile CARD32 *)(pDevice->regMap + PSB_THALIA_OFFSET + (_offs)) = (_val))
#define PSB_READ32(_offs)				\
  (*(volatile CARD32 *)(pDevice->regMap + (_offs)))
#define PSB_WRITE32(_offs, _val)				\
  (*(volatile CARD32 *)(pDevice->regMap + (_offs)) = (_val))
#define PSB_RSLAVE32(_offs)						\
  (*(volatile CARD32 *)(pDevice->regMap + PSB_SGX_2D_SLAVE_PORT + (_offs)))
#define PSB_WSLAVE32(_offs, _val)		\
  (PSB_RSLAVE32(_offs) = (_val))


/*
 * psb_shadow.c
 */

extern void psbUpdatePackedDepth15(ScreenPtr pScreen, shadowBufPtr pBuf);
extern void psbUpdatePackedDepth24(ScreenPtr pScreen, shadowBufPtr pBuf);
extern void *psbWindowLinear(ScreenPtr pScreen, CARD32 row, CARD32 offset,
    int mode, CARD32 * size, void *closure);

#ifdef XF86DRI

/*
 * psb_dri.c
 */
extern Bool psbDRIScreenInit(ScreenPtr pScreen);
extern void psbDRICloseScreen(ScreenPtr pScreen);
extern Bool psbDRMDeviceInit(PsbDevicePtr pDevice);
extern void psbDRMDeviceTakeDown(PsbDevicePtr pDevice);
extern void psbDRIUnlock(ScrnInfoPtr pScrn);
extern void psbDRILock(ScrnInfoPtr pScrn, int flags);
extern void psbDRMIrqTakeDown(PsbDevicePtr pDevice);
extern void psbDRMIrqInit(PsbDevicePtr pDevice);
extern Bool psbDRIFinishScreenInit(ScreenPtr pScreen);
extern void psbDRIUpdateScanouts(ScrnInfoPtr pScrn);

#else
#define psbDRILock(_a, _b)
#define psbDRIUnlock(_a)
#endif

/*
 * psb_outputs.c
 */
extern void psbOutputPrepare(xf86OutputPtr output);
extern void psbOutputCommit(xf86OutputPtr output);
extern DisplayModePtr psbOutputDDCGetModes(xf86OutputPtr output);
extern void psbOutputDestroy(PsbOutputPrivatePtr pOutput);
extern void psbOutputInit(PsbDevicePtr pDevice, PsbOutputPrivatePtr pOutput);
extern void psbOutputEnableCrtcForAllScreens(PsbDevicePtr pDevice, int crtc);
extern void psbOutputDisableCrtcForOtherScreens(ScrnInfoPtr pScrn, int crtc);
extern void psbOutputDestroyAll(ScrnInfoPtr pScrn);
extern Bool psbPtrAddToList(MMListHead * head, void *ptr);
extern Bool psbOutputCompat(ScrnInfoPtr pScrn);
extern Bool psbOutputAssignToScreen(ScrnInfoPtr pScrn, const char *name);
extern void psbOutputReleaseFromScreen(ScrnInfoPtr pScrn, const char *name);
extern xf86OutputPtr psbOutputClone(ScrnInfoPtr pScrn, ScrnInfoPtr origScrn,
    const char *name);
extern void psbOutputSave(ScrnInfoPtr pScrn);
extern void psbOutputRestore(ScrnInfoPtr pScrn);
extern void psbOutputDPMS(ScrnInfoPtr pScrn, int mode);

/*
 * psb_lvds.c 
 */

extern xf86OutputPtr psbLVDSInit(ScrnInfoPtr pScrn, const char *name);

/*
 * psb_sdvo.c
 */

extern xf86OutputPtr
psbSDVOInit(ScrnInfoPtr pScrn, int output_device, char *name);

/*
 * psb_crtc.c
 */

extern void psbCrtcLoadLut(xf86CrtcPtr crtc);
extern void psbDescribeOutputConfiguration(ScrnInfoPtr pScrn);
extern xf86CrtcPtr psbCrtcInit(ScrnInfoPtr pScrn, int pipe);
extern xf86CrtcPtr psbCrtcClone(ScrnInfoPtr pScrn, xf86CrtcPtr origCrtc);
extern void psbWaitForVblank(ScrnInfoPtr pScrn);
extern void psbPipeSetBase(xf86CrtcPtr crtc, int x, int y);
extern void psbCrtcSaveCursors(ScrnInfoPtr pScrn, Bool force);
extern int psbCrtcSetupCursors(ScrnInfoPtr pScrn);
extern void psbCrtcFreeCursors(ScrnInfoPtr pScrn);
extern DisplayModePtr psbCrtcModeGet(ScrnInfoPtr pScrn, xf86CrtcPtr crtc);

/*
 * psb_driver.c 
 */
extern void psbCheckCrtcs(PsbDevicePtr pDevice);
extern void psbEngineHang(ScrnInfoPtr pScrn);

/*
 * psb_cursor.c 
 */
void psbInitHWCursor(ScrnInfoPtr pScrn);
Bool psbCursorInit(ScreenPtr pScreen);
extern void psb_crtc_load_cursor_image(xf86CrtcPtr crtc, unsigned char *src);
extern void psb_crtc_load_cursor_argb(xf86CrtcPtr crtc, CARD32 * image);
extern void psb_crtc_set_cursor_position(xf86CrtcPtr crtc, int x, int y);
extern void psb_crtc_set_cursor_colors(xf86CrtcPtr crtc, int bg, int fg);
extern void psb_crtc_hide_cursor(xf86CrtcPtr crtc);
extern void psb_crtc_show_cursor(xf86CrtcPtr crtc);
#endif /*_PSB_H_*/
