function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._login = browser.getLogin();
        this._password = browser.getPassword();
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        function authorize(login, pass) {
            var name = document.evaluate('//input[@name=\"session[username_or_email]\"]', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;
            var password = document.evaluate('//input[@name=\"session[password]\"]', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;
            name.value = login;
            password.value = pass;
            password.form.submit();
        }
        if (!this._login) {
            this._browser.skipTest();
        }
        if (this._state === 0) {
            this._browser.injectScript("(function(){var authorize = " + authorize + "; authorize('" + this._login + "', '" + this._password + "');})();");
        } else if (this._state >= 1) {
            setTimeout(this._browser.finish.bind(this._browser), 10000);
        }
        this._state++;
    },

    validateCallLog: function (log, out) {
        assertEquals('Unity.init', log[0].func, 'Unity.init');
        assertEquals('Twitter', log[0].args[0].name, 'Twitter');
        assertFalse('Login', !log[2].args[0].login);

        var found = false, i;
        for (i = 0; i < out.length; i++) {
            if (out[i] === 'PASS SELF TEST') {
                found = true;
            }
        }
        assertTrue('PASS SELF TEST', found);
    },

    scriptName: 'Twitter/Twitter.user.js'
};
