function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        setTimeout(function () {
            this._browser.finish();
        }.bind(this), 5000);
    },

    validateCallLog: function (log) {
        assertEquals('Newsblur', log[0].args[0].name, 'Newsblur');
        var i;
        var launcherCount = false;
        for (i = 0; i < log.length; i++) {
            if (log[i].func === 'Unity.Launcher.setCount' && log[i].args[0] > 0) {
                launcherCount = true;
            }
        }
        assertTrue('Unity.Launcher.setCount', launcherCount);
    },

    scriptName: 'Newsblur/Newsblur.user.js'
};
