function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._login = browser.getLogin();
        this._password = browser.getPassword();
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        function authorize(login, password) {
            function insertText(text, node) {
                node.focus();
                var evt = document.createEvent('TextEvent');
                evt.initTextEvent('textInput', true, true, null, text, 9, "en-US");
                console.log(node.dispatchEvent(evt));
            }
            var name = document.evaluate('//input[@name=\"login\"]', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;
            name.value = login;

            var passwd = document.evaluate('//input[@name=\"passwd\"]', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;
            insertText(password, passwd);
            document.getElementById('idSIButton9').click();
        }

        if (!this._login) {
            this._browser.skipTest();
        }
        if (this._state === 0) {
            this._browser.injectScript("(function(){ var authorize = " + authorize + ";"
                                       + "authorize('" + this._login + "', '" + this._password + "'); })();");
        } else if (this._state === 1) {
            setTimeout(this._browser.finish.bind(this._browser), 50000);
        }
        this._state++;
    },

    validateCallLog: function (log) {
        assertEquals('Unity.init', log[0].func, 'Unity.init');
        assertEquals('live.com', log[0].args[0].name, 'live.com');
        assertEquals('Unity.MessagingIndicator.showIndicator', log[1].func, 'Unity.MessagingIndicator.showIndicator');
        assertEquals('Unity.MessagingIndicator.showIndicator', log[2].func, 'Unity.MessagingIndicator.showIndicator');
    },

    scriptName: 'LiveMail/LiveMail.user.js'
};
