function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._login = browser.getLogin();
        this._password = browser.getPassword();
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function (uri) {
        if (!this._login) {
            this._browser.skipTest();
        }
        if (this._state === 0) {
            this._browser.injectScript(makeAuthorizer('Email', 'Passwd', this._login, this._password));
        } else if (uri.match(/^https:\/\/plus.google.com/)) {
            this._browser.finish();
        }
        this._state++;
    },

    validateCallLog: function (log, out) {
        var i;
        assertEquals('Unity.init', log[0].func, 'Unity.init');

        var count = 0;
        for (i = 3; i < log.length; i++) {
            if (log[i].func === 'Unity.addAction') {
                count++;
            }
        }

        assertTrue('Unity.addAction', count > 5);
        var found = false;
        for (i = 0; i < out.length; i++) {
            if (out[i] === 'PASS SELF TEST') {
                found = true;
            }
        }
        assertTrue('PASS SELF TEST', found);
    },

    scriptName: 'GooglePlus/GooglePlus.user.js'
};
