/*unity_integration.js*/

(function ($) {
    var Unity;
    function getLastComment() {
        function parseResponse(msg) {
            var res = JSON.parse(msg);
            if (!res.comment || localStorage.getItem(res.comment)) {
                return;
            }

            localStorage.setItem(res.comment, true);
            Unity.Notification.showNotification(res.author, res.comment, null);
        }
        $.ajax({ type: "GET",
                 url: "?q=get_lastcomment",
                 data: null,
                 success: parseResponse,
                 complete: function () { setTimeout(getLastComment, 2000); }
               });
    }
    function messagingIndicatorSetup() {
        Unity.Launcher.addAction("New Post", function composeNewPost() {
            window.location.assign('?q=node/add/story');
        });

        getLastComment();
    }
    if (external && external.getUnityObject) {
        Unity = external.getUnityObject(1);
        Unity.init({ name: "Drupal",
                         iconUrl: 'http://drupal.org/sites/all/themes/bluecheese/images/sprites.png',
			 crop: { sx: 0, sy: 538, sw: 60, sh: 63 },
                         homepage: String(window.location).match(/^[^?]+/)[0],
                         onInit: messagingIndicatorSetup });
    }
}(jQuery));
