// ==UserScript==
// @include       http://news.google.*/*
// @include       https://news.google.*/*
// @require       utils.js
// @require       google-common.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);

function getPosts() {
    var res = [];
    var i, elements = document.getElementsByClassName('titletext');
    for (i = 0; i < elements.length; i++) {
	var title = elements[i].textContent;
	res.push({ icon: null, author: _("Google News"), body: title })
    }
    return res;
}

function markAsRead(items) {
    var i;
    for (i = 0; i < items.length; i++) {
        if (items[i].body) {
            localStorage.setItem(items[i].body, true);
        }
    }
}

function filterReaded(items) {
    return items.filter(function (item) {
        return item.body && !localStorage.getItem(item.body);
    });
}

function showItems(items) {
    var i;
    for (i = 0; i < items.length; i++) {
        localStorage.setItem(items[i].body, true);
        Unity.Notification.showNotification(items[i].author, items[i].body, items[i].icon);
    }
}

function messagingIndicatorSetup() {
    var tabActive = true;

    window.onblur = function () {
        tabActive = false;
    };
    window.onfocus = function () {
        tabActive = true;
    };

    var checkMessangesCount = wrapCallback(function () {
        var i, unreadItems = filterReaded(getPosts());
        var unread = String(unreadItems.length);

        Unity.MessagingIndicator.showIndicator(_("Unread"), { count: unread });
        if (tabActive) {
            markAsRead(unreadItems);
        } else {
            showItems(unreadItems);
        }
    });
    doMainMenuIntegration(document);

    checkMessangesCount();
    setInterval(checkMessangesCount, 1000);
}

Unity.init({ name: _("Google News"),
	     homepage: 'http://' + window.location.hostname + '/',
	     domain: window.location.hostname,
	     iconUrl: "icon://unity-webapps-google-news",
             onInit: wrapCallback(messagingIndicatorSetup) });
