function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._login = browser.getLogin();
        this._password = browser.getPassword();
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        if (!this._login) {
            this._browser.skipTest();
        }
        if (this._state === 0) {
            this._browser.injectScript(makeAuthorizer('username', 'passwd', this._login, this._password));
        } else if (this._state === 2) {
            this._browser.finish();
        }
        this._state++;
    },

    validateCallLog: function (log) {
        assertEquals('Unity.init', log[0].func, 'Unity.init');
        assertEquals('Yahoo Mail', log[0].args[0].name, 'Yahoo Mail');
        assertEquals('Unity.MessagingIndicator.clearIndicators', log[1].func, 'Unity.MessagingIndicator.clearIndicators');
        assertEquals('Unity.MessagingIndicator.showIndicator', log[2].func, 'Unity.MessagingIndicator.showIndicator');
    },

    scriptName: 'YahooMail/YahooMail.user.js'
};
