function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._login = browser.getLogin();
        this._password = browser.getPassword();
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function (uri) {
        if (!this._login) {
            this._browser.skipTest();
        }
        if (this._state === 0) {
            this._browser.injectScript(makeAuthorizer('Email', 'Passwd', this._login, this._password));
        } else if (uri.match(/^https?:\/\/www.google.com\/calendar\//)) {
            setTimeout(this._browser.finish.bind(this._browser), 5000);
        }
        this._state++;
    },

    validateCallLog: function (log) {
        assertEquals('Unity.init', log[0].func, 'Unity.init');
        assertEquals('Google Calendar', log[0].args[0].name, 'Google Calendar');
        assertEquals('Unity.Launcher.addAction', log[1].func, 'Unity.Launcher.addAction');
    },

    scriptName: 'GoogleCalendar/GoogleCalendar.user.js'
};
