/*
 * This file is part of the webaccounts-browser-plugin.
 * Copyright (C) Canonical Ltd. 2012
 *
 * Author: Alberto Mardegan <alberto.mardegan@canonical.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "fake-capture-service.h"

#include <gio/gio.h>
#include <string.h>

static FakeCaptureService *capture_service = NULL;

void fake_capture_service_init (FakeCaptureService *self)
{
    memset (self, 0, sizeof (FakeCaptureService));
    capture_service = self;
}

void fake_capture_service_unset (FakeCaptureService *self)
{
    g_free (self->provider_name);
    g_free (self->username);
    g_free (self->password);
    if (self->cookies != NULL)
        g_variant_unref (self->cookies);

    memset (self, 0, sizeof (FakeCaptureService));
}

void fake_capture_service_reset (FakeCaptureService *self)
{
    fake_capture_service_unset (self);
    fake_capture_service_init (self);
}

void
g_dbus_connection_call (GDBusConnection *connection,
                        const gchar *bus_name,
                        const gchar *object_path,
                        const gchar *interface_name,
                        const gchar *method_name,
                        GVariant *parameters,
                        const GVariantType *reply_type,
                        GDBusCallFlags flags,
                        gint timeout_msec,
                        GCancellable *cancellable,
                        GAsyncReadyCallback callback,
                        gpointer user_data)
{
    g_return_if_fail (capture_service != NULL);

    capture_service->called = TRUE;

    g_return_if_fail (parameters != NULL);

    g_variant_get (parameters, "(sss@a{ss})",
                   &capture_service->provider_name,
                   &capture_service->username,
                   &capture_service->password,
                   &capture_service->cookies);
}

