/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* sparql.sql */

static const char *tbl0 = 
"create table DB.DBA.RDF_QUAD (\n"
"G IRI_ID_8,\n"
"S IRI_ID_8,\n"
"P IRI_ID_8,\n"
"O any,\n"
"primary key (P, S, O, G)\n"
")\n"
"alter index RDF_QUAD on DB.DBA.RDF_QUAD partition (S int (0hexffff00))\n"
"\n"
"create distinct no primary key ref bitmap index RDF_QUAD_SP on RDF_QUAD (S, P) partition (S int (0hexffff00))\n"
"create bitmap index RDF_QUAD_POGS on RDF_QUAD (P, O, G, S) partition (O varchar (-1, 0hexffff))\n"
"create distinct no primary key ref bitmap index RDF_QUAD_GS on RDF_QUAD (G, S) partition (S int (0hexffff00))\n"
"create distinct no primary key ref index RDF_QUAD_OP on RDF_QUAD (O, P) partition (O varchar (-1, 0hexffff))\n";

static const char *proc0 = 
"create function DB.DBA.RDF_MAKE_IID_OF_QNAME_SAFE (in qname any) returns IRI_ID\n"
"{\n"
"return iri_to_id_nosignal (qname);\n"
"}\n"
"--src sparql.sql:38\n";

static const char *proc1 = 
"create function DB.DBA.RDF_MAKE_IID_OF_QNAME_COMP (in qname any) returns IRI_ID\n"
"{\n"
"return iri_to_id_nosignal (qname, 0);\n"
"}\n"
"--src sparql.sql:44\n";


static const char *other0 = 
" DB.DBA.RDF_MAKE_IID_OF_QNAME_SAFE (null)\n";

static const char *other1 = 
" DB.DBA.RDF_MAKE_IID_OF_QNAME_COMP (null)\n";
static const char *proc2 = 
"create function DB.DBA.RDF_QNAME_OF_IID (in iid IRI_ID) returns varchar\n"
"{\n"
"return id_to_iri_nosignal (iid);\n"
"}\n"
"--src sparql.sql:58\n";


static const char *other2 = 
" DB.DBA.RDF_QNAME_OF_IID (null)\n";
static const char *tbl1 = 
"create table DB.DBA.RDF_OBJ (\n"
"RO_ID bigint primary key,\n"
"RO_VAL varchar not null,\n"
"RO_LONG long varchar,\n"
"RO_FLAGS smallint not null default 0,\n"
"RO_DT_AND_LANG integer not null default 16843009 compress any\n"
")\n"
"alter index RDF_OBJ on RDF_OBJ partition (RO_ID int (0hexffff00))\n"
"\n"
"create index RO_VAL on DB.DBA.RDF_OBJ (RO_VAL, RO_DT_AND_LANG)\n"
"partition (RO_VAL varchar (-4, 0hexffff))\n";

static const char *tbl2 = 
"create table DB.DBA.RO_START (RS_START varchar, RS_DT_AND_LANG int, RS_RO_ID any,\n"
"primary key (RS_START, RS_DT_AND_LANG, RS_RO_ID))\n"
"alter index RO_START on DB.DBA.RO_START partition (RS_RO_ID varchar (-1, 0hexffff))\n";

static const char *tbl3 = 
"create table DB.DBA.RDF_DATATYPE (\n"
"RDT_IID IRI_ID_8 not null primary key,\n"
"RDT_TWOBYTE integer not null unique,\n"
"RDT_QNAME varchar not null unique )\n"
"alter index RDF_DATATYPE on RDF_DATATYPE partition cluster replicated\n"
"alter index DB_DBA_RDF_DATATYPE_UNQC_RDT_TWOBYTE   on RDF_DATATYPE partition cluster replicated\n"
"alter index DB_DBA_RDF_DATATYPE_UNQC_RDT_QNAME on RDF_DATATYPE partition cluster replicated\n";

static const char *tbl4 = 
"create table DB.DBA.RDF_LANGUAGE (\n"
"RL_ID varchar not null primary key,\n"
"RL_TWOBYTE integer not null unique )\n"
"alter index RDF_LANGUAGE on RDF_LANGUAGE  partition cluster replicated\n"
"alter index DB_DBA_RDF_LANGUAGE_UNQC_RL_TWOBYTE on RDF_LANGUAGE  partition cluster replicated\n";

static const char *tbl5 = 
"create table DB.DBA.SYS_SPARQL_HOST (\n"
"SH_HOST	varchar not null primary key,\n"
"SH_GRAPH_URI	varchar,\n"
"SH_USER_URI	varchar,\n"
"SH_DEFINES	long varchar\n"
")\n";

static const char *tbl6 = 
"create table DB.DBA.RDF_OBJ_FT_RULES (\n"
"ROFR_G varchar not null,\n"
"ROFR_P varchar not null,\n"
"ROFR_REASON varchar not null,\n"
"primary key (ROFR_G, ROFR_P, ROFR_REASON) )\n"
"alter index RDF_OBJ_FT_RULES on RDF_OBJ_FT_RULES partition cluster replicated\n";

static const char *tbl7 = 
"create table DB.DBA.SYS_SPARQL_SW_LOG (\n"
"PL_SERVER varchar,\n"
"PL_URI    varchar,\n"
"PL_TS     timestamp,\n"
"PL_RC     varchar,\n"
"PL_MSG    long varchar,\n"
"primary key (PL_SERVER, PL_URI, PL_TS))\n";

static const char *tbl8 = 
"create table DB.DBA.SYS_XML_PERSISTENT_NS_DECL\n"
"(\n"
"NS_PREFIX varchar not null primary key,\n"
"NS_URL varchar not null\n"
")\n"
"alter index SYS_XML_PERSISTENT_NS_DECL on SYS_XML_PERSISTENT_NS_DECL partition cluster replicated\n";

static const char *tbl9 = 
"create table DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH\n"
"(\n"
"REC_GRAPH_IID IRI_ID not null primary key\n"
")\n"
"alter index RDF_EXPLICITLY_CREATED_GRAPH on RDF_EXPLICITLY_CREATED_GRAPH partition cluster replicated\n";

static const char *tbl10 = 
"create table RDF_GEO (X real no compress, Y real no compress,X2 real no compress, Y2 real no compress, ID bigint no compress, primary key (X, Y, X2, Y2, ID))\n"
"alter index RDF_GEO on RDF_GEO partition (ID int (0hexffff00))\n";

static const char *tbl11 = 
"create table DB.DBA.RDF_LABEL (RL_O any primary key, RL_RO_ID bigint, RL_TEXT varchar, RL_LANG int)\n"
"alter index RDF_LABEL on RDF_LABEL partition (RL_O varchar (-1, 0hexffff))\n";

static const char *tbl12 = 
"create table DB.DBA.SYS_FAKE_0\n"
"(\n"
"ID integer not null primary key\n"
")\n";

static const char *tbl13 = 
"create table DB.DBA.SYS_FAKE_1\n"
"(\n"
"ID integer not null primary key\n"
")\n";

static const char *other3 = 
"insert soft DB.DBA.SYS_FAKE_1 (ID) values (0)\n";
static const char *other4 = 
"sequence_set (\'RDF_URL_IID_NAMED\', 1000000, 1)\n";
static const char *other5 = 
"sequence_set (\'RDF_PREF_SEQ\', 1, 1)\n";
static const char *other6 = 
"sequence_set (\'RDF_URL_IID_BLANK\', iri_id_num (min_bnode_iri_id ()), 1)\n";
static const char *other7 = 
"sequence_set (\'RDF_URL_IID_NAMED_BLANK\', iri_id_num (min_named_bnode_iri_id ()), 1)\n";
static const char *other8 = 
"sequence_set (\'RDF_RO_ID\', 1, 1)\n";
static const char *other9 = 
"sequence_set (\'RDF_DATATYPE_TWOBYTE\', 258, 1)\n";
static const char *other10 = 
"sequence_set (\'RDF_LANGUAGE_TWOBYTE\', 258, 1)\n";
static const char *proc3 = 
"create procedure RDF_GEO_INIT ()\n"
"{\n"
"if (not exists (select 1 from SYS_VT_INDEX where VI_COL = \'o\'))\n"
"{\n"
"insert soft SYS_VT_INDEX (VI_TABLE, VI_INDEX, VI_COL, VI_ID_COL, VI_INDEX_TABLE, VI_ID_IS_PK, VI_OPTIONS)\n"
"values (\'DB.DBA.RDF_QUAD\', \'RDF_QUAD_OP\', \'O\', \'O\', \'DB.DBA.RDF_GEO\', 1, \'GR\');\n"
"insert soft SYS_VT_INDEX (VI_TABLE, VI_INDEX, VI_COL, VI_ID_COL, VI_INDEX_TABLE, VI_ID_IS_PK, VI_OPTIONS)\n"
"values (\'DB.DBA.RDF_QUAD\', \'RDF_QUAD_OP\', \'o\', \'O\', \'DB.DBA.RDF_OBJ_RO_FLAGS_WORDS\', 1, null);\n"
"__ddl_changed (\'DB.DBA.RDF_QUAD\');\n"
"}\n"
"}\n"
"--src sparql.sql:204\n";

static const char *proc4 = 
"create procedure DB.DBA.RDF_OBJ_RO_FLAGS_INDEX_HOOK (inout vtb any, inout d_id any)\n"
"{\n"
"for (select RO_LONG, RO_VAL, RO_FLAGS\n"
"from DB.DBA.RDF_OBJ table option (no cluster) where RO_ID=d_id and bit_and (RO_FLAGS, 1)) do\n"
"{\n"
"if (bit_and (RO_FLAGS, 2))\n"
"vt_batch_feed (vtb, xml_tree_doc (__xml_deserialize_packed (RO_LONG)), 0);\n"
"else\n"
"vt_batch_feed (vtb, coalesce (RO_LONG, RO_VAL), 0);\n"
"}\n"
"return 1;\n"
"}\n"
"--src sparql.sql:217\n";

static const char *proc5 = 
"create procedure DB.DBA.RDF_OBJ_RO_FLAGS_UNINDEX_HOOK (inout vtb any, inout d_id any)\n"
"{\n"
"for (select RO_LONG, RO_VAL, RO_FLAGS\n"
"from DB.DBA.RDF_OBJ table option (no cluster) where RO_ID=d_id and bit_and (RO_FLAGS, 1)) do\n"
"{\n"
"if (bit_and (RO_FLAGS, 2))\n"
"vt_batch_feed (vtb, xml_tree_doc (__xml_deserialize_packed (RO_LONG)), 1);\n"
"else\n"
"vt_batch_feed (vtb, coalesce (RO_LONG, RO_VAL), 1);\n"
"}\n"
"return 1;\n"
"}\n"
"--src sparql.sql:231\n";

static const char *proc6 = 
"create procedure sparql_exec_quiet (in expn varchar)\n"
"{\n"
"declare sta, msg varchar;\n"
"exec (expn, sta, msg);\n"
"}\n"
"--src sparql.sql:245\n";

static const char *other11 = 
"sparql_exec_quiet (\'DB.DBA.vt_create_text_index (\n"
"fix_identifier_case (\'\'DB.DBA.RDF_OBJ\'\'),\n"
"fix_identifier_case (\'\'RO_FLAGS\'\'),\n"
"fix_identifier_case (\'\'RO_ID\'\'),\n"
"0, 0, vector (), 1, \'\'*ini*\'\', \'\'UTF-8-QR\'\')\')\n";
static const char *other12 = 
"sparql_exec_quiet (\'DB.DBA.vt_batch_update (fix_identifier_case (\'\'DB.DBA.RDF_OBJ\'\'), \'\'ON\'\', 1)\')\n";
static const char *proc7 = 
" create function DB.DBA.XML_SET_NS_DECL (in prefix varchar, in url varchar, in persist integer := 1) returns integer\n"
"{\n"
"declare res integer;\n"
"res := __xml_set_ns_decl (prefix, url, persist);\n"
"if (bit_and (res, 2))\n"
"{\n"
"declare exit handler for sqlstate \'*\' { __xml_remove_ns_by_prefix (prefix, persist); resignal; };\n"
"if (exists (select 1 from DB.DBA.SYS_XML_PERSISTENT_NS_DECL where NS_PREFIX = prefix and NS_URL = url))\n"
"return;\n"
"delete from DB.DBA.SYS_XML_PERSISTENT_NS_DECL where NS_PREFIX = prefix;\n"
"insert into DB.DBA.SYS_XML_PERSISTENT_NS_DECL (NS_PREFIX, NS_URL) values (prefix, url);\n"
"commit work;\n"
"}\n"
"return res;\n"
"}\n"
"--src sparql.sql:266\n";

static const char *proc8 = 
" create procedure DB.DBA.XML_REMOVE_NS_BY_PREFIX (in prefix varchar, in persist integer := 1)\n"
"{\n"
"declare res integer;\n"
"__xml_remove_ns_by_prefix (prefix, persist);\n"
"if (bit_and (persist, 2))\n"
"{\n"
"whenever sqlstate \'*\' goto again;\n"
"again:\n"
"delete from DB.DBA.SYS_XML_PERSISTENT_NS_DECL where NS_PREFIX=prefix;\n"
"commit work;\n"
"}\n"
"}\n"
"--src sparql.sql:284\n";

static const char *proc9 = 
" create procedure DB.DBA.XML_CLEAR_ALL_NS_DECLS (in persist integer := 1)\n"
"{\n"
"declare res integer;\n"
"__xml_clear_all_ns_decls (persist);\n"
"if (bit_and (persist, 2))\n"
"{\n"
"whenever sqlstate \'*\' goto again;\n"
"again:\n"
"delete from DB.DBA.SYS_XML_PERSISTENT_NS_DECL;\n"
"commit work;\n"
"}\n"
"}\n"
"--src sparql.sql:299\n";

static const char *proc10 = 
" create procedure DB.DBA.XML_SELECT_ALL_NS_DECLS (in persist integer := 3)\n"
"{\n"
"declare decls any;\n"
"declare ctr, len integer;\n"
"declare PREFIX, URI varchar;\n"
"decls := __xml_get_all_ns_decls (persist);\n"
"result_names (PREFIX, URI);\n"
"len := length (decls);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 2)\n"
"result (decls[ctr], decls[ctr+1]);\n"
"}\n"
"--src sparql.sql:314\n";

static const char *proc11 = 
"create procedure DB.DBA.XML_LOAD_ALL_NS_DECLS ()\n"
"{\n"
"for (select NS_PREFIX, NS_URL from DB.DBA.SYS_XML_PERSISTENT_NS_DECL) do\n"
"{\n"
"__xml_set_ns_decl (NS_PREFIX, NS_URL, 2);\n"
"}\n"
"DB.DBA.XML_SET_NS_DECL (	\'bif\'	, \'bif:\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'dawgt\'	, \'http://www.w3.org/2001/sw/DataAccess/tests/test-dawg#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'dbpedia\'	, \'http://dbpedia.org/resource/\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'dbpprop\'	, \'http://dbpedia.org/property/\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'dc\'	, \'http://purl.org/dc/elements/1.1/\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'go\'	, \'http://purl.org/obo/owl/GO#\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'geo\'	, \'http://www.w3.org/2003/01/geo/wgs84_pos#\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'foaf\'	, \'http://xmlns.com/foaf/0.1/\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'obo\'	, \'http://www.geneontology.org/formats/oboInOwl#\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'owl\'	, \'http://www.w3.org/2002/07/owl#\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'mesh\'	, \'http://purl.org/commons/record/mesh/\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'math\'	, \'http://www.w3.org/2000/10/swap/math#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'mf\'	, \'http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'nci\'	, \'http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'protseq\'	, \'http://purl.org/science/protein/bysequence/\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'rdf\'	, \'http://www.w3.org/1999/02/22-rdf-syntax-ns#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'rdfdf\'	, \'http://www.openlinksw.com/virtrdf-data-formats#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'rdfs\'	, \'http://www.w3.org/2000/01/rdf-schema#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'sc\'	, \'http://purl.org/science/owl/sciencecommons/\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'skos\'	, \'http://www.w3.org/2004/02/skos/core#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'sql\'	, \'sql:\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'virtrdf\'	, \'http://www.openlinksw.com/schemas/virtrdf#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'vcard\'	, \'http://www.w3.org/2001/vcard-rdf/3.0#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'xf\'	, \'http://www.w3.org/2004/07/xpath-functions\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'xml\'	, \'http://www.w3.org/XML/1998/namespace\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'xsd\'	, \'http://www.w3.org/2001/XMLSchema#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'xsl10\'	, \'http://www.w3.org/XSL/Transform/1.0\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'xsl1999\'	, \'http://www.w3.org/1999/XSL/Transform\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'xslwd\'	, \'http://www.w3.org/TR/WD-xsl\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'yago\'	, \'http://dbpedia.org/class/yago/\'	, 2);\n"
"}\n"
"--src sparql.sql:327\n";

static const char *other13 = 
"DB.DBA.XML_LOAD_ALL_NS_DECLS ()\n";
static const char *other14 = 
"rdf_inf_const_init ()\n";
static const char *proc12 = 
"create procedure DB.DBA.RDF_LOAD_ALL_FT_RULES ()\n"
"{\n"
"whenever sqlstate \'*\' goto again;\n"
"again:\n"
"for (select ROFR_G as rule_g, ROFR_P as rule_p, ROFR_REASON as reason from DB.DBA.RDF_OBJ_FT_RULES) do\n"
"{\n"
"declare rule_g_iid, rule_p_iid IRI_ID;\n"
"rule_g_iid := case (rule_g) when \'\' then null else iri_to_id (rule_g) end;\n"
"rule_p_iid := case (rule_p) when \'\' then null else iri_to_id (rule_p) end;\n"
"\n"
"__rdf_obj_ft_rule_add (rule_g_iid, rule_p_iid, reason);\n"
"}\n"
"}\n"
"--src sparql.sql:372\n";

static const char *other15 = 
"DB.DBA.RDF_LOAD_ALL_FT_RULES ()\n";

static const char *proc13 = 
" create procedure DB.DBA.RDF_GLOBAL_RESET (in hard integer := 0)\n"
"{\n"
"\n"
"__atomic (1);\n"
"iri_id_cache_flush ();\n"
"__rdf_obj_ft_rule_zap_all ();\n"
"for select rs_name from sys_rdf_schema do\n"
"rdf_inf_clear (rs_name);\n"
"delete from sys_rdf_schema;\n"
"delete from DB.DBA.RDF_QUAD;\n"
"delete from DB.DBA.RDF_OBJ_FT_RULES;\n"
"delete from DB.DBA.RDF_GRAPH_GROUP;\n"
"delete from DB.DBA.RDF_GRAPH_GROUP_MEMBER;\n"
"delete from DB.DBA.RDF_GRAPH_USER;\n"
"dict_zap (__rdf_graph_group_dict(), 2);\n"
"dict_zap (__rdf_graph_group_of_privates_dict(), 2);\n"
"dict_zap (__rdf_graph_default_perms_of_user_dict(0), 2);\n"
"dict_zap (__rdf_graph_default_perms_of_user_dict(1), 2);\n"
"dict_zap (__rdf_graph_public_perms_dict(), 2);\n"
"commit work;\n"
"if (hard)\n"
"{\n"
"\n"
"delete from DB.DBA.RDF_IRI;\n"
"delete from DB.DBA.RDF_PREFIX;\n"
"delete from DB.DBA.RDF_OBJ;\n"
"delete from DB.DBA.RDF_DATATYPE;\n"
"delete from DB.DBA.RDF_LANGUAGE;\n"
"\n"
"\n"
"delete from DB.DBA.VTLOG_DB_DBA_RDF_OBJ;\n"
"delete from DB.DBA.RDF_OBJ_RO_FLAGS_WORDS;\n"
"sequence_set (\'RDF_URL_IID_NAMED\', 1000000, 0);\n"
"sequence_set (\'RDF_URL_IID_BLANK\', iri_id_num (min_bnode_iri_id ()), 0);\n"
"sequence_set (\'RDF_URL_IID_NAMED_BLANK\', iri_id_num (min_named_bnode_iri_id ()), 0);\n"
"sequence_set (\'RDF_PREF_SEQ\', 1, 0);\n"
"sequence_set (\'RDF_RO_ID\', 1, 0);\n"
"sequence_set (\'RDF_DATATYPE_TWOBYTE\', 258, 0);\n"
"sequence_set (\'RDF_LANGUAGE_TWOBYTE\', 258, 0);\n"
"__atomic (0);\n"
"exec (\'checkpoint\');\n"
"raw_exit ();\n"
"}\n"
"sequence_set (\'RDF_URL_IID_NAMED\', 1000000, 1);\n"
"sequence_set (\'RDF_URL_IID_BLANK\', iri_id_num (min_bnode_iri_id ()), 1);\n"
"sequence_set (\'RDF_URL_IID_NAMED_BLANK\', iri_id_num (min_named_bnode_iri_id ()), 1);\n"
"sequence_set (\'RDF_PREF_SEQ\', 1, 1);\n"
"sequence_set (\'RDF_RO_ID\', 1, 1);\n"
"sequence_set (\'RDF_DATATYPE_TWOBYTE\', 258, 1);\n"
"sequence_set (\'RDF_LANGUAGE_TWOBYTE\', 258, 1);\n"
"DB.DBA.RDF_LOAD_ALL_FT_RULES ();\n"
"DB.DBA.TTLP (\n"
"cast ( DB.DBA.XML_URI_GET (\n"
"\'http://www.openlinksw.com/sparql/virtrdf-data-formats.ttl\', \'\' ) as varchar ),\n"
"\'\', \'http://www.openlinksw.com/schemas/virtrdf#\' );\n"
"DB.DBA.TTLP (\'\n"
"@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n"
"@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"@prefix owl: <http://www.w3.org/2002/07/owl#> .\n"
"@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n"
"@prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#> .\n"
"@prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#> .\n"
"@prefix atom: <http://atomowl.org/ontologies/atomrdf#> .\n"
"\n"
"virtrdf:DefaultQuadStorage\n"
"rdf:type virtrdf:QuadStorage ;\n"
"virtrdf:qsUserMaps virtrdf:DefaultQuadStorage-UserMaps ;\n"
"virtrdf:qsDefaultMap virtrdf:DefaultQuadMap ;\n"
"virtrdf:qsMatchingFlags virtrdf:SPART_QS_NO_IMPLICIT_USER_QM .\n"
"virtrdf:DefaultQuadStorage-UserMaps\n"
"rdf:type virtrdf:array-of-QuadMap .\n"
"\', \'\', \'http://www.openlinksw.com/schemas/virtrdf#\' );\n"
"delete from SYS_HTTP_SPONGE where HS_PARSER = \'DB.DBA.RDF_LOAD_HTTP_RESPONSE\';\n"
"commit work;\n"
"sequence_set (\'RDF_URL_IID_NAMED\', 1010000, 1);\n"
"sequence_set (\'RDF_URL_IID_BLANK\', iri_id_num (min_bnode_iri_id ()) + 10000, 1);\n"
"sequence_set (\'RDF_URL_IID_NAMED_BLANK\', iri_id_num (min_named_bnode_iri_id ()) + 10000, 1);\n"
"sequence_set (\'RDF_PREF_SEQ\', 101, 1);\n"
"sequence_set (\'RDF_RO_ID\', 1001, 1);\n"
"iri_id_cache_flush ();\n"
"DB.DBA.SPARQL_RELOAD_QM_GRAPH ();\n"
"__atomic (0);\n"
"exec (\'checkpoint\');\n"
"}\n"
"--src sparql.sql:391\n";

static const char *proc14 = 
"create function DB.DBA.RDF_MAKE_IID_OF_QNAME (in qname varchar) returns IRI_ID\n"
"{\n"
"return iri_to_id (qname);\n"
"}\n"
"--src sparql.sql:481\n";

static const char *proc15 = 
"create function DB.DBA.RDF_MAKE_IID_OF_LONG (in qname any) returns IRI_ID\n"
"{\n"
"if (isiri_id (qname))\n"
"return qname;\n"
"if (not isstring (qname))\n"
"{\n"
"if (__tag of rdf_box = __tag (qname) and rdf_box_is_complete (qname))\n"
"qname := rdf_box_data (qname, 1);\n"
"else\n"
"qname := __rdf_strsqlval (qname);\n"
"}\n"
"return iri_to_id_nosignal (qname);\n"
"}\n"
"--src sparql.sql:488\n";

static const char *proc16 = 
"create function DB.DBA.RDF_MAKE_GRAPH_IIDS_OF_QNAMES (in qnames any) returns any\n"
"{\n"
"if (__tag of vector <> __tag (qnames))\n"
"return vector ();\n"
"declare res_acc any;\n"
"vectorbld_init (res_acc);\n"
"foreach (any qname in qnames) do\n"
"{\n"
"declare iid IRI_ID;\n"
"whenever sqlstate \'*\' goto skip_acc;\n"
"iid := iri_to_id (qname, 0, 0);\n"
"if (not isinteger (iid))\n"
"vectorbld_acc (res_acc, iid);\n"
"skip_acc: ;\n"
"}\n"
"vectorbld_final (res_acc);\n"
"return res_acc;\n"
"}\n"
"--src sparql.sql:503\n";

static const char *proc17 = 
"create function DB.DBA.RDF_TWOBYTE_OF_DATATYPE (in iid IRI_ID) returns integer\n"
"{\n"
"declare res integer;\n"
"declare qname varchar;\n"
"if (iid is null)\n"
"return 257;\n"
"if (not isiri_id (iid))\n"
"{\n"
"declare new_iid IRI_ID;\n"
"new_iid := iri_to_id (iid);\n"
"if (new_iid is NULL or new_iid >= min_bnode_iri_id ())\n"
"signal (\'RDFXX\', \'Invalid datatype IRI_ID passes as an argument to DB.DBA.RDF_TWOBYTE_OF_DATATYPE()\');\n"
"iid := new_iid;\n"
"}\n"
"qname := id_to_iri (iid);\n"
"res := rdf_cache_id (\'t\', qname);\n"
"if (res)\n"
"return res;\n"
"whenever not found goto mknew;\n"
"set isolation=\'committed\';\n"
"select RDT_TWOBYTE into res from DB.DBA.RDF_DATATYPE where RDT_IID = iid;\n"
"return res;\n"
"\n"
"mknew:\n"
"set isolation=\'serializable\';\n"
"declare tb_cr cursor for select RDT_TWOBYTE from DB.DBA.RDF_DATATYPE where RDT_IID = iid;\n"
"open tb_cr (exclusive);\n"
"whenever not found goto mknew_ser;\n"
"fetch tb_cr into res;\n"
"return res;\n"
"\n"
"mknew_ser:\n"
"res := sequence_next (\'RDF_DATATYPE_TWOBYTE\');\n"
"if (0 = bit_and (res, 255))\n"
"res := sequence_next (\'RDF_DATATYPE_TWOBYTE\');\n"
"insert into DB.DBA.RDF_DATATYPE\n"
"(RDT_IID, RDT_TWOBYTE, RDT_QNAME)\n"
"values (iid, res, qname);\n"
"rdf_cache_id (\'t\', qname, res);\n"
"log_text (\'rdf_cache_id (\\\'t\\\', ?, ?)\', qname, res);\n"
"return res;\n"
"}\n"
"--src sparql.sql:526\n";

static const char *proc18 = 
"create function DB.DBA.RDF_TWOBYTE_OF_LANGUAGE (in id varchar) returns integer\n"
"{\n"
"declare res integer;\n"
"if (id is null)\n"
"return 257;\n"
"id := lower (id);\n"
"res := rdf_cache_id (\'l\', id);\n"
"if (res)\n"
"return res;\n"
"whenever not found goto mknew;\n"
"set isolation=\'committed\';\n"
"select RL_TWOBYTE into res from DB.DBA.RDF_LANGUAGE where RL_ID = id;\n"
"return res;\n"
"\n"
"mknew:\n"
"set isolation=\'serializable\';\n"
"declare tb_cr cursor for select RL_TWOBYTE from DB.DBA.RDF_LANGUAGE where RL_ID = id;\n"
"open tb_cr (exclusive);\n"
"whenever not found goto mknew_ser;\n"
"fetch tb_cr into res;\n"
"return res;\n"
"\n"
"mknew_ser:\n"
"res := sequence_next (\'RDF_LANGUAGE_TWOBYTE\');\n"
"if (0 = bit_and (res, 255))\n"
"res := sequence_next (\'RDF_LANGUAGE_TWOBYTE\');\n"
"insert into DB.DBA.RDF_LANGUAGE (RL_ID, RL_TWOBYTE) values (id, res);\n"
"rdf_cache_id (\'l\', id, res);\n"
"log_text (\'rdf_cache_id (\\\'l\\\', ?, ?)\', id, res);\n"
"return res;\n"
"}\n"
"--src sparql.sql:570\n";

static const char *proc19 = 
"create function DB.DBA.RQ_LONG_OF_O (in o_col any) returns any\n"
"{\n"
"return __rdf_long_of_obj (o_col);\n"
"}\n"
"--src sparql.sql:606\n";

static const char *proc20 = 
"create procedure DB.DBA.RDF_BOX_COMPLETE (inout o_col any)\n"
"{\n"
"__rdf_box_make_complete (o_col);\n"
"}\n"
"--src sparql.sql:612\n";

static const char *proc21 = 
"create function DB.DBA.RQ_SQLVAL_OF_O (in o_col any) returns any\n"
"{\n"
"return __rdf_sqlval_of_obj (o_col);\n"
"}\n"
"--src sparql.sql:618\n";

static const char *proc22 = 
"create function DB.DBA.RQ_BOOL_OF_O (in o_col any) returns any\n"
"{\n"
"declare t, len integer;\n"
"if (isiri_id (o_col))\n"
"return NULL;\n"
"if (isinteger (o_col))\n"
"{\n"
"if (o_col)\n"
"return 1;\n"
"return 0;\n"
"}\n"
"if (__tag of rdf_box = __tag (o_col))\n"
"{\n"
"declare twobyte integer;\n"
"declare dtqname any;\n"
"if (__tag of varchar <> rdf_box_data_tag (o_col))\n"
"{\n"
"whenever sqlstate \'*\' goto retnull;\n"
"return neq (rdf_box_data (o_col), 0.0);\n"
"}\n"
"twobyte := rdf_box_type (o_col);\n"
"if (257 = twobyte)\n"
"goto type_ok;\n"
"whenever not found goto badtype;\n"
"select RDT_QNAME into dtqname from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = twobyte;\n"
"if (dtqname <> UNAME\'http://www.w3.org/2001/XMLSchema#string\')\n"
"return null;\n"
"\n"
"type_ok:\n"
"return case (length (rdf_box_data (o_col))) when 0 then 0 else 1 end;\n"
"\n"
"badtype:\n"
"signal (\'RDFXX\', sprintf (\'Unknown datatype in DB.DBA.RQ_BOOL_OF_O, bad string \"%s\"\', o_col));\n"
"}\n"
"if (o_col is null)\n"
"return null;\n"
"whenever sqlstate \'*\' goto retnull;\n"
"return neq (o_col, 0.0);\n"
"retnull:\n"
"return null;\n"
"}\n"
"--src sparql.sql:624\n";

static const char *proc23 = 
"create function DB.DBA.RQ_IID_OF_O (in shortobj any) returns IRI_ID\n"
"{\n"
"return id_to_iri_nosignal (shortobj);\n"
"}\n"
"--src sparql.sql:667\n";

static const char *proc24 = 
"create function DB.DBA.RQ_O_IS_LIT (in shortobj any) returns integer\n"
"{\n"
"if (isiri_id (shortobj))\n"
"return 0;\n"
"return 1;\n"
"}\n"
"--src sparql.sql:673\n";

static const char *proc25 = 
"create procedure RDF_G_INS (in id int, in g any)\n"
"{\n"
"geo_insert (\'DB.DBA.RDF_GEO\', g, id);\n"
"}\n"
"--src sparql.sql:686\n";

static const char *proc26 = 
"create procedure cl_rdf_geo_insert (in id int, inout g any)\n"
"{\n"
"declare daq any;\n"
"daq := daq (1);\n"
"daq_call (daq, \'DB.DBA.RDF_OBJ\', \'RDF_OBJ\', \'DB.DBA.RDF_G_INS\', vector (id, g), 1);\n"
"daq_results (daq);\n"
"}\n"
"--src sparql.sql:692\n";

static const char *proc27 = 
"create function rdf_geo_add (in v any)\n"
"{\n"
"declare id, h, ser, g any;\n"
"if (rdf_box_ro_id (v))\n"
"return v;\n"
"g := rdf_box_data (v);\n"
"if (not isgeometry (g))\n"
"signal (\'22023\', \'RDFXX\', \'Must be geometry box if to be stored as geo object\');\n"
"ser := serialize (g);\n"
"if (length (ser) > 50)\n"
"h := mdigest5 (ser);\n"
"else\n"
"{\n"
"h := ser;\n"
"ser := null;\n"
"}\n"
"set isolation = \'committed\';\n"
"id := (select ro_id, ro_val, ro_long from rdf_obj where ro_val = h and ro_dt_and_lang = 0hex1000101 and case when ro_long is not null then eq (blob_to_string (ro_long),  ser) else 1 end );\n"
"if (id is not null)\n"
"{\n"
"rdf_box_set_ro_id (v, id);\n"
"return v;\n"
"}\n"
"set isolation = \'serializable\';\n"
"id := (select ro_id, ro_val, ro_long from rdf_obj where ro_val = h and ro_dt_and_lang = 0hex1000101 and case when ro_long is not null then eq (blob_to_string (ro_long),  ser) else 1 end for update);\n"
"if (id is not null)\n"
"{\n"
"rdf_box_set_ro_id (v, id);\n"
"return v;\n"
"}\n"
"id := sequence_next (\'RDF_RO_ID\');\n"
"set triggers off;\n"
"insert into rdf_obj (ro_id, ro_val, ro_long, ro_dt_and_lang)\n"
"values (id, h, ser, 0hex1000101);\n"
"if (1 = sys_stat (\'cl_run_local_only\'))\n"
"geo_insert (\'DB.DBA.RDF_GEO\', g, id);\n"
"else\n"
"cl_rdf_geo_insert (id, g);\n"
"rdf_box_set_ro_id (v, id);\n"
"return v;\n"
"}\n"
"--src sparql.sql:701\n";

static const char *proc28 = 
"create function DB.DBA.RDF_OBJ_ADD (in dt_twobyte integeR, in v varchar, in lang_twobyte integeR, in ro_id_dict any := null) returns varchar\n"
"{\n"
"declare llong, id, need_digest integer;\n"
"declare digest any;\n"
"declare old_flags, dt_and_lang integer;\n"
"\n"
"if (126 = __tag (v))\n"
"v := blob_to_string (v);\n"
"if (isstring (rdf_box_data (v)))\n"
"need_digest := rdf_box_needs_digest (v, ro_id_dict);\n"
"else if (__tag of XML = __tag (v))\n"
"need_digest := 1;\n"
"if (__tag of rdf_box = __tag (v))\n"
"{\n"
"if (256 = rdf_box_type (v))\n"
"return rdf_geo_add (v);\n"
"if (0 = need_digest)\n"
"return v;\n"
"if (1 = need_digest)\n"
"{\n"
"if (0 <> rdf_box_ro_id (v))\n"
"return v;\n"
"}\n"
"dt_twobyte := rdf_box_type (v);\n"
"lang_twobyte := rdf_box_lang (v);\n"
"v := __rdf_sqlval_of_obj (v, 1);\n"
"}\n"
"else\n"
"{\n"
"if (dt_twobyte <> 257 or lang_twobyte <> 257)\n"
"need_digest := 3;\n"
"else if (0 = need_digest)\n"
"return v;\n"
"if (dt_twobyte < 257)\n"
"signal (\'RDFXX\', sprintf (\'Bad datatype code: DB.DBA.RDF_OBJ_ADD (%d, %s, %d)\',\n"
"dt_twobyte, \"LEFT\" (cast (v as varchar), 100), lang_twobyte) );\n"
"if (lang_twobyte < 257)\n"
"signal (\'RDFXX\', sprintf (\'Bad lang code: DB.DBA.RDF_OBJ_ADD (%d, %s, %d)\',\n"
"dt_twobyte, \"LEFT\" (cast (v as varchar), 100), lang_twobyte) );\n"
"}\n"
"dt_and_lang := bit_or (bit_shift (dt_twobyte, 16), lang_twobyte);\n"
"if (not isstring (v))\n"
"{\n"
"declare sum64 varchar;\n"
"if (__tag of XML <> __tag (v))\n"
"signal (\'RDFXX\', sprintf (\'Bad call: DB.DBA.RDF_OBJ_ADD (%d, %s, %d)\',\n"
"dt_twobyte, \"LEFT\" (cast (v as varchar), 100), lang_twobyte) );\n"
"sum64 := xtree_sum64 (v);\n"
"whenever not found goto serializable_xtree;\n"
"set isolation=\'committed\';\n"
"select RO_ID, RO_FLAGS into id, old_flags\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = sum64\n"
"and RO_DT_AND_LANG = dt_and_lang\n"
"and bit_and (RO_FLAGS, 2);\n"
"\n"
"\n"
"goto found_xtree;\n"
"serializable_xtree:\n"
"whenever not found goto new_xtree;\n"
"set isolation=\'serializable\';\n"
"declare id_cr cursor for\n"
"select RO_ID, RO_FLAGS from DB.DBA.RDF_OBJ table option (index RO_VAL) where RO_VAL = sum64\n"
"and RO_DT_AND_LANG = dt_and_lang\n"
"and bit_and (RO_FLAGS, 2);\n"
"\n"
"open id_cr (exclusive);\n"
"fetch id_cr into id, old_flags;\n"
"found_xtree:\n"
"digest := rdf_box (v, dt_twobyte, lang_twobyte, id, 1);\n"
"if (ro_id_dict is not null)\n"
"{\n"
"if (not (bit_and (old_flags, 1)))\n"
"{\n"
"update DB.DBA.RDF_OBJ set RO_FLAGS = bit_or (RO_FLAGS, 1) where RO_ID = id;\n"
"\n"
"}\n"
"dict_put (ro_id_dict, id, 1);\n"
"}\n"
"if (not (rdf_box_is_storeable (digest)))\n"
"signal (\'RDFX2\', \'DB.DBA.RDF_OBJ_ADD() tries to return bad digest\');\n"
"return digest;\n"
"\n"
"new_xtree:\n"
"id := sequence_next (\'RDF_RO_ID\');\n"
"digest := rdf_box (v, dt_twobyte, lang_twobyte, id, 1);\n"
"insert into DB.DBA.RDF_OBJ (RO_ID, RO_VAL, RO_LONG, RO_FLAGS, RO_DT_AND_LANG) values\n"
"(id, sum64, __xml_serialize_packed (v), case (isnull (ro_id_dict)) when 0 then 3 else 2 end, dt_and_lang);\n"
"\n"
"\n"
"if (ro_id_dict is not null)\n"
"dict_put (ro_id_dict, id, 1);\n"
"if (not (rdf_box_is_storeable (digest)))\n"
"signal (\'RDFX3\', \'DB.DBA.RDF_OBJ_ADD() tries to return bad digest\');\n"
"return digest;\n"
"\n"
"\n"
"}\n"
"if ((dt_twobyte = 257) and (lang_twobyte = 257) and (length (v) <= -1))\n"
"{\n"
"if (1 >= need_digest)\n"
"return v;\n"
"whenever not found goto serializable_veryshort;\n"
"set isolation=\'committed\';\n"
"select RO_ID into id\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = v and RO_DT_AND_LANG = dt_and_lang and not (bit_and (RO_FLAGS, 2));\n"
"goto found_veryshort;\n"
"serializable_veryshort:\n"
"whenever not found goto new_veryshort;\n"
"set isolation=\'serializable\';\n"
"declare id_cr cursor for select RO_ID\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = v and RO_DT_AND_LANG = dt_and_lang and not (bit_and (RO_FLAGS, 2));\n"
"open id_cr (exclusive);\n"
"fetch id_cr into id;\n"
"found_veryshort:\n"
"if (ro_id_dict is not null)\n"
"{\n"
"dict_put (ro_id_dict, id, 1);\n"
"\n"
"}\n"
"if (not (rdf_box_is_storeable (v)))\n"
"signal (\'RDFX4\', \'DB.DBA.RDF_OBJ_ADD() tries to return bad digest\');\n"
"return v;\n"
"new_veryshort:\n"
"id := sequence_next (\'RDF_RO_ID\');\n"
"insert into DB.DBA.RDF_OBJ (RO_ID, RO_VAL, RO_FLAGS, RO_DT_AND_LANG) values (id, v, 1, dt_and_lang);\n"
"if (ro_id_dict is not null)\n"
"{\n"
"dict_put (ro_id_dict, id, 1);\n"
"}\n"
"insert into DB.DBA.RO_START (RS_START, RS_DT_AND_LANG, RS_RO_ID)\n"
"values (subseq (v, 0, case when length (v) > 10 then 10 else length (v) end), dt_and_lang, rdf_box (0, 257, 257, id, 0));\n"
"if (not (rdf_box_is_storeable (v)))\n"
"signal (\'RDFX5\', \'DB.DBA.RDF_OBJ_ADD() tries to return bad digest\');\n"
"return v;\n"
"}\n"
"llong := 50;\n"
"if (length (v) > llong)\n"
"{\n"
"declare chksm varchar;\n"
"chksm := mdigest5 (v, 1);\n"
"whenever not found goto serializable_long;\n"
"set isolation=\'committed\';\n"
"select RO_ID, RO_FLAGS into id, old_flags\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = chksm\n"
"and RO_DT_AND_LANG = dt_and_lang\n"
"and not (bit_and (RO_FLAGS, 2))\n"
"and blob_to_string (RO_LONG) = v;\n"
"goto found_long;\n"
"serializable_long:\n"
"whenever not found goto new_long;\n"
"set isolation=\'serializable\';\n"
"declare id_cr cursor for\n"
"select RO_ID, RO_FLAGS from DB.DBA.RDF_OBJ\n"
"table option (index RO_VAL) where RO_VAL = chksm\n"
"and RO_DT_AND_LANG = dt_and_lang\n"
"and not (bit_and (RO_FLAGS, 2))\n"
"and blob_to_string (RO_LONG) = v;\n"
"open id_cr (exclusive);\n"
"fetch id_cr into id, old_flags;\n"
"found_long:\n"
"digest := rdf_box (v, dt_twobyte, lang_twobyte, id, 1);\n"
"if ((not (bit_and (old_flags, 1))) and (1 < need_digest))\n"
"update DB.DBA.RDF_OBJ set RO_FLAGS = bit_or (RO_FLAGS, 1) where RO_ID = id;\n"
"if (ro_id_dict is not null)\n"
"{\n"
"dict_put (ro_id_dict, id, 1);\n"
"}\n"
"if (not (rdf_box_is_storeable (digest)))\n"
"signal (\'RDFX6\', \'DB.DBA.RDF_OBJ_ADD() tries to return bad digest\');\n"
"return digest;\n"
"new_long:\n"
"id := sequence_next (\'RDF_RO_ID\');\n"
"digest := rdf_box (v, dt_twobyte, lang_twobyte, id, 1);\n"
"if (1 < need_digest)\n"
"insert into DB.DBA.RDF_OBJ (RO_ID, RO_VAL, RO_LONG, RO_FLAGS, RO_DT_AND_LANG)\n"
"values (id, chksm, v, 1, dt_and_lang);\n"
"else\n"
"{\n"
"set triggers off;\n"
"insert into DB.DBA.RDF_OBJ (RO_ID, RO_VAL, RO_LONG, RO_DT_AND_LANG)\n"
"values (id, chksm, v, dt_and_lang);\n"
"set triggers on;\n"
"}\n"
"if (ro_id_dict is not null)\n"
"{\n"
"dict_put (ro_id_dict, id, 1);\n"
"}\n"
"insert into DB.DBA.RO_START (RS_START, RS_DT_AND_LANG, RS_RO_ID)\n"
"\n"
"values (subseq (v, 0, 10), dt_and_lang, rdf_box (0, 257, 257, id, 0));\n"
"if (not (rdf_box_is_storeable (digest)))\n"
"signal (\'RDFX7\', \'DB.DBA.RDF_OBJ_ADD() tries to return bad digest\');\n"
"return digest;\n"
"}\n"
"else\n"
"{\n"
"whenever not found goto serializable_short;\n"
"set isolation=\'committed\';\n"
"select RO_ID, RO_FLAGS into id, old_flags\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = v\n"
"and RO_DT_AND_LANG = dt_and_lang;\n"
"goto found_short;\n"
"serializable_short:\n"
"whenever not found goto new_short;\n"
"set isolation=\'serializable\';\n"
"declare id_cr cursor for select RO_ID, RO_FLAGS\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = v\n"
"and RO_DT_AND_LANG = dt_and_lang;\n"
"open id_cr (exclusive);\n"
"fetch id_cr into id, old_flags;\n"
"found_short:\n"
"digest := rdf_box (v, dt_twobyte, lang_twobyte, id, 1);\n"
"if ((not (bit_and (old_flags, 1))) and (1 < need_digest))\n"
"update DB.DBA.RDF_OBJ set RO_FLAGS = bit_or (RO_FLAGS, 1) where RO_ID = id;\n"
"if (ro_id_dict is not null)\n"
"{\n"
"dict_put (ro_id_dict, id, 1);\n"
"}\n"
"if (not (rdf_box_is_storeable (digest)))\n"
"signal (\'RDFX8\', \'DB.DBA.RDF_OBJ_ADD() tries to return bad digest\');\n"
"return digest;\n"
"new_short:\n"
"id := sequence_next (\'RDF_RO_ID\');\n"
"digest := rdf_box (v, dt_twobyte, lang_twobyte, id, 1);\n"
"if (1 < need_digest)\n"
"insert into DB.DBA.RDF_OBJ (RO_ID, RO_VAL, RO_FLAGS, RO_DT_AND_LANG)\n"
"values (id, v, 1, dt_and_lang);\n"
"else\n"
"{\n"
"set triggers off;\n"
"insert into DB.DBA.RDF_OBJ (RO_ID, RO_VAL, RO_FLAGS, RO_DT_AND_LANG)\n"
"values (id, v, 0, dt_and_lang);\n"
"set triggers on;\n"
"}\n"
"insert into DB.DBA.RO_START (RS_START, RS_DT_AND_LANG, RS_RO_ID)\n"
"values (subseq (v, 0, case when length (v) > 10 then 10 else length (v) end), dt_and_lang, rdf_box (0, 257, 257, id, 0));\n"
"if (ro_id_dict is not null)\n"
"{\n"
"dict_put (ro_id_dict, id, 1);\n"
"}\n"
"if (not (rdf_box_is_storeable (digest)))\n"
"signal (\'RDFX9\', \'DB.DBA.RDF_OBJ_ADD() tries to return bad digest\');\n"
"return digest;\n"
"}\n"
"recheck:\n"
"\n"
"signal (\'FUNNY\', \'Debug code of DB.DBA.RDF_OBJ_ADD() is reached. This can not happen (I believe). Please report this error.\');\n"
"}\n"
"--src sparql.sql:744\n";

static const char *proc29 = 
"create function DB.DBA.RDF_FIND_RO_DIGEST (in dt_twobyte integeR, in v varchar, in lang_twobyte integeR) returns varchar\n"
"{\n"
"declare llong, dt_and_lang int;\n"
"declare dt_s, lang_s, chksm, sum64 varchar;\n"
"declare digest, old_digest any;\n"
"if (126 = __tag (v))\n"
"v := blob_to_string (v);\n"
"dt_and_lang := bit_or (bit_shift (dt_twobyte, 16), lang_twobyte);\n"
"if (not (isstring (v)))\n"
"{\n"
"if (__tag of XML <> __tag (v))\n"
"return v;\n"
"sum64 := xtree_sum64 (v);\n"
"return (select rdf_box (v, dt_twobyte, lang_twobyte, RO_ID, 1)\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = sum64\n"
"and RO_DT_AND_LANG = dt_and_lang\n"
"and bit_and (RO_FLAGS, 2)\n"
"\n"
");\n"
"}\n"
"if ((dt_twobyte = 257) and (lang_twobyte = 257) and (length (v) <= 20))\n"
"return v;\n"
"llong := 50;\n"
"if (length (v) > llong)\n"
"{\n"
"chksm := mdigest5 (v, 1);\n"
"return (select rdf_box (v, dt_twobyte, lang_twobyte, RO_ID, 1)\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = chksm\n"
"and RO_DT_AND_LANG = dt_and_lang\n"
"and not (bit_and (RO_FLAGS, 2))\n"
"and blob_to_string (RO_LONG) = v );\n"
"}\n"
"else\n"
"{\n"
"return (select rdf_box (v, dt_twobyte, lang_twobyte, RO_ID, 1)\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = v\n"
"and RO_DT_AND_LANG = dt_and_lang\n"
"and not (bit_and (RO_FLAGS, 2)) );\n"
"}\n"
"}\n"
"--src sparql.sql:1000\n";

static const char *proc30 = 
"create function DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL (in v any) returns any\n"
"{\n"
"declare t int;\n"
"t := __tag (v);\n"
"if (not (t in (126, __tag of varchar, 217, __tag of nvarchar, __tag of XML, __tag of rdf_box)))\n"
"return v;\n"
"if (__tag of nvarchar = t)\n"
"v := charset_recode (v, \'_WIDE_\', \'UTF-8\');\n"
"else if (t in (126, 217))\n"
"v := cast (v as varchar);\n"
"return DB.DBA.RDF_OBJ_ADD (257, v, 257);\n"
"}\n"
"--src sparql.sql:1045\n";

static const char *proc31 = 
"create function DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT (in v any, in g_iid IRI_ID, in p_iid IRI_ID, in ro_id_dict any := null) returns any\n"
"{\n"
"declare t int;\n"
"t := __tag (v);\n"
"if (not (t in (126, __tag of varchar, 217, __tag of nvarchar, __tag of XML, __tag of rdf_box)))\n"
"return v;\n"
"if (__tag of nvarchar = t)\n"
"v := charset_recode (v, \'_WIDE_\', \'UTF-8\');\n"
"else if (t in (126, 217))\n"
"v := cast (v as varchar);\n"
"if (not __rdf_obj_ft_rule_check (g_iid, p_iid))\n"
"ro_id_dict := null;\n"
"else\n"
"{\n"
"if (ro_id_dict is null)\n"
"{\n"
"declare res any;\n"
"ro_id_dict := dict_new ();\n"
"res := DB.DBA.RDF_OBJ_ADD (257, v, 257, ro_id_dict);\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (g_iid, ro_id_dict);\n"
"return res;\n"
"}\n"
"}\n"
"return DB.DBA.RDF_OBJ_ADD (257, v, 257, ro_id_dict);\n"
"}\n"
"--src sparql.sql:1059\n";

static const char *proc32 = 
"create function DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL (in v any, in dt_iid IRI_ID, in lang varchar) returns any\n"
"{\n"
"declare t, dt_twobyte, lang_twobyte int;\n"
"retry_unrdf:\n"
"t := __tag (v);\n"
"if (not (t in (126, __tag of varchar, 217, __tag of nvarchar, __tag of XML)))\n"
"{\n"
"if (__tag of rdf_box = t)\n"
"{\n"
"v := rdf_box_data (v);\n"
"goto retry_unrdf;\n"
"}\n"
"\n"
"return v;\n"
"}\n"
"if (__tag of nvarchar = t)\n"
"v := charset_recode (v, \'_WIDE_\', \'UTF-8\');\n"
"else if (217 = t or 126 = t)\n"
"v := cast (v as varchar);\n"
"if (dt_iid is not null)\n"
"dt_twobyte := DB.DBA.RDF_TWOBYTE_OF_DATATYPE (dt_iid);\n"
"else\n"
"dt_twobyte := 257;\n"
"if (lang is not null)\n"
"lang_twobyte := DB.DBA.RDF_TWOBYTE_OF_LANGUAGE (lang);\n"
"else\n"
"lang_twobyte := 257;\n"
"return DB.DBA.RDF_OBJ_ADD (dt_twobyte, v, lang_twobyte);\n"
"}\n"
"--src sparql.sql:1086\n";

static const char *proc33 = 
"create function DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_FT (in v any, in dt_iid IRI_ID, in lang varchar, in g_iid IRI_ID, in p_iid IRI_ID, in ro_id_dict any := null) returns any\n"
"{\n"
"declare t, dt_twobyte, lang_twobyte int;\n"
"\n"
"retry_unrdf:\n"
"t := __tag (v);\n"
"if (not (t in (126, __tag of varchar, 217, __tag of nvarchar, __tag of XML)))\n"
"{\n"
"if (__tag of rdf_box = t)\n"
"{\n"
"v := rdf_box_data (v);\n"
"goto retry_unrdf;\n"
"}\n"
"\n"
"return v;\n"
"}\n"
"if (__tag of nvarchar = t)\n"
"v := charset_recode (v, \'_WIDE_\', \'UTF-8\');\n"
"else if (217 = t or 126 = t)\n"
"v := cast (v as varchar);\n"
"if (dt_iid is not null)\n"
"dt_twobyte := DB.DBA.RDF_TWOBYTE_OF_DATATYPE (dt_iid);\n"
"else\n"
"dt_twobyte := 257;\n"
"if (lang is not null)\n"
"lang_twobyte := DB.DBA.RDF_TWOBYTE_OF_LANGUAGE (lang);\n"
"else\n"
"lang_twobyte := 257;\n"
"if (not __rdf_obj_ft_rule_check (g_iid, p_iid))\n"
"ro_id_dict := null;\n"
"else\n"
"{\n"
"if (ro_id_dict is null)\n"
"{\n"
"declare res any;\n"
"ro_id_dict := dict_new ();\n"
"res := DB.DBA.RDF_OBJ_ADD (dt_twobyte, v, lang_twobyte, ro_id_dict);\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (g_iid, ro_id_dict);\n"
"return res;\n"
"}\n"
"}\n"
"return DB.DBA.RDF_OBJ_ADD (dt_twobyte, v, lang_twobyte, ro_id_dict);\n"
"}\n"
"--src sparql.sql:1117\n";

static const char *proc34 = 
"create function DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_STRINGS (\n"
"in o_val any, in o_type varchar, in o_lang varchar ) returns any\n"
"{\n"
"if (__tag (o_type) in (__tag of varchar, 217))\n"
"{\n"
"declare parsed any;\n"
"parsed := __xqf_str_parse_to_rdf_box (o_val, o_type, isstring (o_val));\n"
"if (parsed is not null)\n"
"{\n"
"if (__tag of XML = __tag (parsed))\n"
"{\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, iri_to_id (s_uri), p_iid,\n"
"DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL (\n"
"parsed, iri_to_id (o_type), null ) );\n"
"return;\n"
"}\n"
"if (__tag of rdf_box = __tag (parsed))\n"
"rdf_box_set_type (parsed,\n"
"DB.DBA.RDF_TWOBYTE_OF_DATATYPE (iri_to_id (o_type)));\n"
"return parsed;\n"
"}\n"
"return DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL (\n"
"o_val,\n"
"iri_to_id (o_type),\n"
"o_lang );\n"
"}\n"
"if (isstring (o_lang))\n"
"{\n"
"return DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL (\n"
"o_val, NULL, o_lang );\n"
"}\n"
"return DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL (o_val);\n"
"}\n"
"--src sparql.sql:1162\n";

static const char *proc35 = 
"create function DB.DBA.RDF_LONG_OF_OBJ (in shortobj any) returns any\n"
"{\n"
"return __rdf_long_of_obj (shortobj);\n"
"}\n"
"--src sparql.sql:1198\n";

static const char *proc36 = 
"create function DB.DBA.RDF_DATATYPE_OF_OBJ (in shortobj any, in dflt varchar := \'http://www.w3.org/2001/XMLSchema#string\') returns any\n"
"{\n"
"declare twobyte integer;\n"
"declare res any;\n"
"if (__tag of rdf_box <> __tag (shortobj))\n"
"{\n"
"if (isiri_id (shortobj))\n"
"return null;\n"
"return iri_to_id (__xsd_type (shortobj, dflt));\n"
"}\n"
"twobyte := rdf_box_type (shortobj);\n"
"if (257 = twobyte)\n"
"return case (rdf_box_lang (shortobj)) when 257 then iri_to_id (dflt) else null end;\n"
"whenever not found goto badtype;\n"
"select RDT_IID into res from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = twobyte;\n"
"return res;\n"
"\n"
"badtype:\n"
"signal (\'RDFXX\', sprintf (\'Unknown datatype in DB.DBA.RQ_DATATYPE_OF_OBJ, bad type id %d, string value \"%s\"\',\n"
"twobyte, cast (rdf_box_data (shortobj) as varchar) ) );\n"
"}\n"
"--src sparql.sql:1204\n";

static const char *proc37 = 
"create function DB.DBA.RDF_LANGUAGE_OF_OBJ (in shortobj any, in dflt varchar := \'\') returns any\n"
"{\n"
"declare twobyte integer;\n"
"declare res varchar;\n"
"if (__tag of rdf_box <> __tag (shortobj))\n"
"return case (isiri_id (shortobj)) when 0 then dflt else null end;\n"
"twobyte := rdf_box_lang (shortobj);\n"
"if (257 = twobyte)\n"
"return dflt;\n"
"whenever not found goto badtype;\n"
"select lower (RL_ID) into res from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = twobyte;\n"
"return res;\n"
"\n"
"badtype:\n"
"signal (\'RDFXX\', sprintf (\'Unknown language in DB.DBA.RDF_LANGUAGE_OF_OBJ, bad string \"%s\"\', shortobj));\n"
"}\n"
"--src sparql.sql:1227\n";

static const char *proc38 = 
"create function DB.DBA.RDF_SQLVAL_OF_OBJ (in shortobj any) returns any\n"
"{\n"
"return __rdf_sqlval_of_obj (shortobj);\n"
"}\n"
"--src sparql.sql:1245\n";

static const char *proc39 = 
"create function DB.DBA.RDF_BOOL_OF_OBJ (in shortobj any) returns any\n"
"{\n"
"if (isiri_id (shortobj))\n"
"return null;\n"
"if (isinteger (shortobj))\n"
"{\n"
"if (shortobj)\n"
"return 1;\n"
"return 0;\n"
"}\n"
"if (__tag of rdf_box <> __tag (shortobj))\n"
"{\n"
"if (shortobj is null)\n"
"return null;\n"
"if (equ (shortobj, 0.0) or equ (shortobj, \'\')) return 0; else return 1;\n"
"}\n"
"declare twobyte integer;\n"
"twobyte := rdf_box_type (shortobj);\n"
"if (257 = twobyte)\n"
"goto type_ok;\n"
"declare dtqname varchar;\n"
"whenever not found goto badtype;\n"
"select RDT_QNAME into dtqname from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = twobyte;\n"
"if (dtqname <> UNAME\'http://www.w3.org/2001/XMLSchema#string\')\n"
"return null;\n"
"\n"
"type_ok:\n"
"return case length (rdf_box_data (shortobj)) when 0 then 0 else 1 end;\n"
"\n"
"badtype:\n"
"signal (\'RDFXX\', sprintf (\'Unknown datatype in DB.DBA.RDF_BOOL_OF_OBJ, bad type id %d, string value \"%s\"\',\n"
"twobyte, cast (rdf_box_data (shortobj) as varchar) ) );\n"
"}\n"
"--src sparql.sql:1251\n";

static const char *proc40 = 
"create function DB.DBA.RDF_QNAME_OF_OBJ (in shortobj any) returns varchar\n"
"{\n"
"return id_to_iri_nosignal (shortobj);\n"
"}\n"
"--src sparql.sql:1286\n";

static const char *proc41 = 
"create function DB.DBA.RDF_STRSQLVAL_OF_OBJ (in shortobj any)\n"
"{\n"
"return __rdf_strsqlval (shortobj, 0);\n"
"}\n"
"--src sparql.sql:1292\n";

static const char *proc42 = 
"create function DB.DBA.RDF_OBJ_OF_LONG (in longobj any) returns any\n"
"{\n"
"if (__tag of rdf_box <> __tag(longobj))\n"
"return longobj;\n"
"if (0 = rdf_box_needs_digest (longobj))\n"
"return longobj;\n"
"return DB.DBA.RDF_OBJ_ADD (257, longobj, 257);\n"
"}\n"
"--src sparql.sql:1298\n";

static const char *proc43 = 
"create function DB.DBA.RDF_OBJ_OF_SQLVAL (in v any) returns any\n"
"{\n"
"declare t int;\n"
"t := __tag (v);\n"
"if (not (t in (__tag of varchar, 126, 217, __tag of nvarchar)))\n"
"return v;\n"
"if (__tag of nvarchar = t)\n"
"v := charset_recode (v, \'_WIDE_\', \'UTF-8\');\n"
"else if (t in (126, 217))\n"
"v := cast (v as varchar);\n"
"else if (1 = __box_flags (v))\n"
"return iri_to_id (v);\n"
"return DB.DBA.RDF_OBJ_ADD (257, v, 257);\n"
"}\n"
"--src sparql.sql:1308\n";

static const char *proc44 = 
"create function DB.DBA.RDF_MAKE_LONG_OF_SQLVAL (in v any) returns any\n"
"{\n"
"declare t int;\n"
"declare res any;\n"
"t := __tag (v);\n"
"if (not (t in (126, __tag of varchar, 217, __tag of nvarchar, __tag of XML)))\n"
"return v;\n"
"if (__tag of nvarchar = t)\n"
"v := charset_recode (v, \'_WIDE_\', \'UTF-8\');\n"
"else if (217 = t or 126 = t)\n"
"v := cast (v as varchar);\n"
"else if (1 = __box_flags (v))\n"
"return iri_to_id (v);\n"
"res := rdf_box (v, 257, 257, 0, 1);\n"
"return res;\n"
"}\n"
"--src sparql.sql:1327\n";

static const char *proc45 = 
"create function DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL (in v any, in dt_iid IRI_ID, in lang varchar) returns any\n"
"{\n"
"declare t, dt_twobyte, lang_twobyte int;\n"
"declare res any;\n"
"t := __tag (v);\n"
"\n"
"\n"
"if (__tag of nvarchar = t)\n"
"v := charset_recode (v, \'_WIDE_\', \'UTF-8\');\n"
"else if (217 = t)\n"
"v := cast (v as varchar);\n"
"else if (__tag of varchar = t and 1 = __box_flags (v) and dt_iid is null and lang is null)\n"
"return iri_to_id (v);\n"
"if (__tag of varchar <> __tag (v))\n"
"{\n"
"declare xsdt IRI_ID;\n"
"if (lang is not null)\n"
"signal (\'RDFXX\', \'Language is set for typed literal in DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL()\');\n"
"xsdt := cast (__xsd_type (v, UNAME\'http://www.w3.org/2001/XMLSchema#string\', NULL) as varchar);\n"
"if (dt_iid = case (isiri_id (dt_iid)) when 1 then iri_to_id (xsdt) else xsdt end)\n"
"return v;\n"
"\n"
"}\n"
"if (dt_iid is not null)\n"
"dt_twobyte := DB.DBA.RDF_TWOBYTE_OF_DATATYPE (dt_iid);\n"
"else\n"
"dt_twobyte := 257;\n"
"if (lang is not null)\n"
"lang_twobyte := DB.DBA.RDF_TWOBYTE_OF_LANGUAGE (lang);\n"
"else\n"
"lang_twobyte := 257;\n"
"res := rdf_box (v, dt_twobyte, lang_twobyte, 0, 1);\n"
"return res;\n"
"}\n"
"--src sparql.sql:1346\n";

static const char *proc46 = 
"create function DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL_STRINGS (\n"
"in o_val any, in o_type varchar, in o_lang varchar ) returns any\n"
"{\n"
"if (__tag (o_type) in (__tag of varchar, 217))\n"
"{\n"
"declare parsed any;\n"
"parsed := __xqf_str_parse_to_rdf_box (o_val, o_type, isstring (o_val));\n"
"if (parsed is not null)\n"
"{\n"
"if (__tag of rdf_box = __tag (parsed))\n"
"rdf_box_set_type (parsed,\n"
"DB.DBA.RDF_TWOBYTE_OF_DATATYPE (iri_to_id (o_type)));\n"
"return parsed;\n"
"}\n"
"return DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL (\n"
"o_val,\n"
"iri_to_id (o_type),\n"
"o_lang );\n"
"}\n"
"if (__tag (o_lang) in (__tag of varchar, 217))\n"
"return DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL (o_val, NULL, o_lang);\n"
"return DB.DBA.RDF_MAKE_LONG_OF_SQLVAL (o_val);\n"
"}\n"
"--src sparql.sql:1382\n";

static const char *proc47 = 
"create function DB.DBA.RDF_QNAME_OF_LONG_SAFE (in longobj any) returns varchar\n"
"{\n"
"return id_to_iri_nosignal (longobj);\n"
"}\n"
"--src sparql.sql:1407\n";

static const char *proc48 = 
"create function DB.DBA.RDF_SQLVAL_OF_LONG (in longobj any) returns any\n"
"{\n"
"return __rdf_sqlval_of_obj (longobj);\n"
"}\n"
"--src sparql.sql:1413\n";

static const char *proc49 = 
"create function DB.DBA.RDF_BOOL_OF_LONG (in longobj any) returns any\n"
"{\n"
"if (isiri_id (longobj))\n"
"return NULL;\n"
"if (isinteger (longobj))\n"
"{\n"
"if (longobj)\n"
"return 1;\n"
"return 0;\n"
"}\n"
"if (__tag of rdf_box <> __tag (longobj))\n"
"{\n"
"if (longobj is null)\n"
"return null;\n"
"if (equ (longobj, 0.0) or equ (longobj, \'\')) return 0; else return 1;\n"
"}\n"
"declare dtqname any;\n"
"if (257 = rdf_box_type (longobj))\n"
"goto type_ok;\n"
"whenever not found goto badtype;\n"
"select RDT_QNAME into dtqname from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = rdf_box_type (longobj);\n"
"if (dtqname <> UNAME\'http://www.w3.org/2001/XMLSchema#string\')\n"
"return null;\n"
"\n"
"type_ok:\n"
"return case (length (rdf_box_data (longobj))) when 0 then 0 else 1 end;\n"
"\n"
"badtype:\n"
"signal (\'RDFXX\', sprintf (\'Unknown datatype in DB.DBA.RDF_BOOL_OF_LONG (code %d)\', rdf_box_type(longobj)));\n"
"}\n"
"--src sparql.sql:1419\n";

static const char *proc50 = 
"create function DB.DBA.RDF_DATATYPE_OF_LONG (in longobj any, in dflt any := UNAME\'http://www.w3.org/2001/XMLSchema#string\') returns any\n"
"{\n"
"if (__tag of rdf_box = __tag (longobj))\n"
"{\n"
"declare twobyte integer;\n"
"declare res varchar;\n"
"twobyte := rdf_box_type (longobj);\n"
"if (257 = twobyte)\n"
"return case (rdf_box_lang (longobj)) when 257 then iri_to_id (dflt) else null end;\n"
"whenever not found goto badtype;\n"
"select RDT_IID into res from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = twobyte;\n"
"return res;\n"
"\n"
"badtype:\n"
"signal (\'RDFXX\', sprintf (\'Unknown datatype in DB.DBA.RDF_DATATYPE_OF_LONG, bad id %d\', twobyte));\n"
"}\n"
"if (isiri_id (longobj))\n"
"return NULL;\n"
"return iri_to_id (__xsd_type (longobj, dflt));\n"
"}\n"
"--src sparql.sql:1451\n";

static const char *proc51 = 
"create function DB.DBA.RDF_DATATYPE_IRI_OF_LONG (in longobj any, in dflt any := UNAME\'http://www.w3.org/2001/XMLSchema#string\') returns any\n"
"{\n"
"if (__tag of rdf_box = __tag (longobj))\n"
"{\n"
"declare twobyte integer;\n"
"declare res varchar;\n"
"twobyte := rdf_box_type (longobj);\n"
"if (257 = twobyte)\n"
"return case (rdf_box_lang (longobj)) when 257 then dflt else null end;\n"
"whenever not found goto badtype;\n"
"select RDT_QNAME into res from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = twobyte;\n"
"return res;\n"
"\n"
"badtype:\n"
"signal (\'RDFXX\', sprintf (\'Unknown datatype in DB.DBA.RDF_DATATYPE_IRI_OF_LONG, bad id %d\', twobyte));\n"
"}\n"
"if (isiri_id (longobj))\n"
"return NULL;\n"
"return __xsd_type (longobj, dflt);\n"
"}\n"
"--src sparql.sql:1473\n";

static const char *proc52 = 
"create function DB.DBA.RDF_LANGUAGE_OF_LONG (in longobj any, in dflt varchar := \'\') returns any\n"
"{\n"
"if (__tag of rdf_box = __tag (longobj))\n"
"{\n"
"declare twobyte integer;\n"
"declare res varchar;\n"
"twobyte := rdf_box_lang (longobj);\n"
"if (257 = twobyte)\n"
"return dflt;\n"
"whenever not found goto badlang;\n"
"select lower (RL_ID) into res from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = twobyte;\n"
"return res;\n"
"\n"
"badlang:\n"
"signal (\'RDFXX\', sprintf (\'Unknown language in DB.DBA.RDF_LANGUAGE_OF_LONG, bad id %d\', twobyte));\n"
"}\n"
"return case (isiri_id (longobj)) when 0 then dflt else null end;\n"
"}\n"
"--src sparql.sql:1495\n";

static const char *proc53 = 
"create function DB.DBA.RDF_STRSQLVAL_OF_LONG (in longobj any)\n"
"{\n"
"return __rdf_strsqlval (longobj, 0);\n"
"}\n"
"--src sparql.sql:1515\n";

static const char *proc54 = 
"create function DB.DBA.RDF_WIDESTRSQLVAL_OF_LONG (in longobj any)\n"
"{\n"
"declare t, len integer;\n"
"if (__tag of rdf_box = __tag (longobj))\n"
"{\n"
"if (rdf_box_is_complete (longobj))\n"
"{\n"
"if (__tag of varchar = rdf_box_data_tag (longobj))\n"
"return charset_recode (rdf_box_data (longobj), \'UTF-8\', \'_WIDE_\');\n"
"if (__tag of datetime = rdf_box_data_tag (longobj))\n"
"{\n"
"declare vc varchar;\n"
"vc := cast (rdf_box_data (longobj) as varchar);\n"
"return cast (replace (vc, \' \', \'T\') as nvarchar);\n"
"}\n"
"if (__tag of XML = rdf_box_data_tag (longobj))\n"
"{\n"
"return charset_recode (serialize_to_UTF8_xml (rdf_box_data (longobj)), \'UTF-8\', \'_WIDE_\');\n"
"}\n"
"return cast (rdf_box_data (longobj) as nvarchar);\n"
"}\n"
"declare id integer;\n"
"declare v2 any;\n"
"id := rdf_box_ro_id (longobj);\n"
"if (__tag of XML = rdf_box_data_tag (longobj))\n"
"{\n"
"v2 := (select xml_tree_doc (__xml_deserialize_packed (RO_LONG)) from DB.DBA.RDF_OBJ where RO_ID = id);\n"
"rdf_box_set_data (longobj, v2, 1);\n"
"return charset_recode (serialize_to_UTF8_xml (v2), \'UTF-8\', \'_WIDE_\');\n"
"}\n"
"else\n"
"v2 := (select case (isnull (RO_LONG)) when 0 then blob_to_string (RO_LONG) else RO_VAL end from DB.DBA.RDF_OBJ where RO_ID = id);\n"
"if (v2 is null)\n"
"signal (\'RDFXX\', sprintf (\'Integrity violation in DB.DBA.RDF_WIDESTRSQLVAL_OF_LONG, bad id %d\', id));\n"
"rdf_box_set_data (longobj, v2, 1);\n"
"return charset_recode (v2, \'UTF-8\', \'_WIDE_\');\n"
"}\n"
"if (isiri_id (longobj))\n"
"{\n"
"declare res varchar;\n"
"res := id_to_iri (longobj);\n"
"\n"
"if (res is null)\n"
"signal (\'RDFXX\', \'Wrong iid in DB.DBA.RDF_WIDESTRSQLVAL_OF_LONG()\');\n"
"return charset_recode (res, \'UTF-8\', \'_WIDE_\');\n"
"}\n"
"if (__tag of datetime = __tag (longobj))\n"
"{\n"
"declare vc varchar;\n"
"vc := cast (longobj as varchar);\n"
"return cast (replace (vc, \' \', \'T\') as nvarchar);\n"
"}\n"
"if (__tag of nvarchar = __tag (longobj))\n"
"return longobj;\n"
"if (__tag of XML = __tag (longobj))\n"
"{\n"
"return charset_recode (serialize_to_UTF8_xml (longobj), \'UTF-8\', \'_WIDE_\');\n"
"}\n"
"return cast (longobj as nvarchar);\n"
"}\n"
"--src sparql.sql:1521\n";

static const char *proc55 = 
" create function DB.DBA.RDF_DATATYPE_OF_SQLVAL (in v any,\n"
"in strg_datatype any := UNAME\'http://www.w3.org/2001/XMLSchema#string\',\n"
"in default_res any := NULL) returns any\n"
"{\n"
"if (__tag of rdf_box = __tag (v))\n"
"{\n"
"declare twobyte integer;\n"
"declare res varchar;\n"
"twobyte := rdf_box_type (v);\n"
"if (257 = twobyte)\n"
"return case (rdf_box_lang (v)) when 257 then iri_to_id (strg_datatype) else null end;\n"
"whenever not found goto badtype;\n"
"select RDT_IID into res from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = twobyte;\n"
"return res;\n"
"\n"
"badtype:\n"
"signal (\'RDFXX\', sprintf (\'Unknown datatype in DB.DBA.RDF_DATATYPE_OF_SQLVAL, bad id %d\', twobyte));\n"
"}\n"
"return iri_to_id (__xsd_type (v, strg_datatype, default_res));\n"
"}\n"
"--src sparql.sql:1584\n";

static const char *proc56 = 
"create function DB.DBA.RDF_LONG_OF_SQLVAL (in v varchar) returns any\n"
"{\n"
"declare t int;\n"
"t := __tag (v);\n"
"if (not (t in (126, __tag of varchar, 217, __tag of nvarchar)))\n"
"return v;\n"
"if (__tag of nvarchar = t)\n"
"v := charset_recode (v, \'_WIDE_\', \'UTF-8\');\n"
"else if (t in (126, 217))\n"
"v := cast (v as varchar);\n"
"else if ((t = __tag of varchar) and (1 = __box_flags (v)))\n"
"return iri_to_id (v);\n"
"return rdf_box (v, 257, 257, 0, 1);\n"
"}\n"
"--src sparql.sql:1606\n";

static const char *proc57 = 
" create function DB.DBA.RDF_STRSQLVAL_OF_SQLVAL (in sqlval any)\n"
"{\n"
"declare t, len integer;\n"
"if (__tag of rdf_box = __tag (sqlval))\n"
"sqlval := __ro2sq (sqlval, 1);\n"
"if (isiri_id (sqlval))\n"
"{\n"
"declare res varchar;\n"
"res := id_to_iri (sqlval);\n"
"\n"
"if (res is null)\n"
"signal (\'RDFXX\', \'Wrong iid in DB.DBA.RDF_STRSQLVAL_OF_SQLVAL()\');\n"
"__box_flags_set (res, 2);\n"
"return res;\n"
"}\n"
"if (__tag of datetime = __tag (sqlval))\n"
"{\n"
"declare vc varchar;\n"
"vc := cast (sqlval as varchar);\n"
"return replace (vc, \' \', \'T\');\n"
"}\n"
"if (__tag of nvarchar = __tag (sqlval))\n"
"return charset_recode (sqlval, \'_WIDE_\', \'UTF-8\');\n"
"return cast (sqlval as varchar);\n"
"}\n"
"--src sparql.sql:1626\n";

static const char *proc58 = 
" create function DB.DBA.RDF_LANGUAGE_OF_SQLVAL (in v any, in dflt varchar := \'\') returns any\n"
"{\n"
"declare t int;\n"
"return case (isiri_id (v)) when 0 then dflt else null end;\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"--src sparql.sql:1654\n";

static const char *proc59 = 
" create function DB.DBA.RDF_IS_BLANK_REF (in v any) returns any\n"
"{\n"
"if ((__tag (v) = 217) or ((__tag (v) = __tag of varchar) and bit_and (1, __box_flags (v))))\n"
"{\n"
"if (\"LEFT\" (v, 9) <> \'nodeID://\')\n"
"return 0;\n"
"return 1;\n"
"}\n"
"if (__tag (v) = 243)\n"
"{\n"
"if (v < min_bnode_iri_id)\n"
"return 0;\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src sparql.sql:1666\n";

static const char *proc60 = 
" create function DB.DBA.RDF_IS_URI_REF (in v any) returns any\n"
"{\n"
"if ((__tag (v) = 217) or ((__tag (v) = __tag of varchar) and bit_and (1, __box_flags (v))))\n"
"{\n"
"if (\"LEFT\" (v, 9) <> \'nodeID://\')\n"
"return 1;\n"
"return 0;\n"
"}\n"
"if (__tag (v) = 243)\n"
"{\n"
"if (v < min_bnode_iri_id)\n"
"return 1;\n"
"return 0;\n"
"}\n"
"return 0;\n"
"}\n"
"--src sparql.sql:1685\n";

static const char *proc61 = 
" create function DB.DBA.RDF_IS_REF (in v any) returns any\n"
"{\n"
"if (__tag (v) in (217, 243))\n"
"return 1;\n"
"if ((__tag of varchar = __tag (v)) and bit_and (1, __box_flags (v)))\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src sparql.sql:1704\n";

static const char *proc62 = 
" create function DB.DBA.RDF_IS_LITERAL (in v any) returns any\n"
"{\n"
"if (__tag (v) in (217, 243))\n"
"return 0;\n"
"if ((__tag of varchar = __tag (v)) and bit_and (1, __box_flags (v)))\n"
"return 0;\n"
"return 1;\n"
"}\n"
"--src sparql.sql:1715\n";

static const char *proc63 = 
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#boolean\" (in strg any) returns integer\n"
"{\n"
"if (isstring (strg))\n"
"{\n"
"if ((\'true\' = strg) or (\'1\' = strg))\n"
"return 1;\n"
"if ((\'false\' = strg) or (\'0\' = strg))\n"
"return 0;\n"
"}\n"
"if (isinteger (strg))\n"
"return case (strg) when 0 then 0 else 1 end;\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:1729\n";

static const char *proc64 = 
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#date\" (in strg any) returns date\n"
"{\n"
"if (__tag of datetime = __tag (strg))\n"
"return strg;\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"if (isstring (strg))\n"
"return __xqf_str_parse (\'date\', strg);\n"
"return cast (strg as date);\n"
"ret_null:\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:1745\n";

static const char *proc65 = 
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#dateTime\" (in strg any) returns datetime\n"
"{\n"
"if (__tag of datetime = __tag (strg))\n"
"return strg;\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"if (isstring (strg))\n"
"return __xqf_str_parse (\'dateTime\', strg);\n"
"return cast (strg as datetime);\n"
"ret_null:\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:1759\n";

static const char *proc66 = 
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#double\" (in strg varchar) returns double precision\n"
"{\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (strg as double precision);\n"
"ret_null:\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:1773\n";

static const char *proc67 = 
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#float\" (in strg varchar) returns float\n"
"{\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (strg as float);\n"
"ret_null:\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:1783\n";

static const char *proc68 = 
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#integer\" (in strg varchar) returns integer\n"
"{\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (strg as integer);\n"
"ret_null:\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:1793\n";

static const char *proc69 = 
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#int\" (in strg varchar) returns integer\n"
"{\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (strg as integer);\n"
"ret_null:\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:1803\n";

static const char *proc70 = 
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#time\" (in strg any) returns time\n"
"{\n"
"if (__tag of datetime = __tag (strg))\n"
"return strg;\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"if (isstring (strg))\n"
"return __xqf_str_parse (\'time\', strg);\n"
"return cast (strg as time);\n"
"ret_null:\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:1813\n";

static const char *proc71 = 
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#string\" (in strg any) returns any\n"
"{\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"declare t, dt_twobyte, lang_twobyte int;\n"
"t := __tag (strg);\n"
"if (__tag of nvarchar = t)\n"
"strg := charset_recode (strg, \'_WIDE_\', \'UTF-8\');\n"
"else if (__tag of varchar <> t)\n"
"strg := cast (strg as varchar);\n"
"return DB.DBA.RDF_OBJ_ADD (\n"
"DB.DBA.RDF_TWOBYTE_OF_DATATYPE (\'http://www.w3.org/2001/XMLSchema#string\'),\n"
"strg, 257 );\n"
"\n"
"ret_null:\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:1827\n";

static const char *proc72 = 
" create function DB.DBA.__and (in e1 any, in e2 any) returns integer\n"
"{\n"
"if (e1 and e2)\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src sparql.sql:1849\n";

static const char *proc73 = 
" create function DB.DBA.__or (in e1 any, in e2 any) returns integer\n"
"{\n"
"if (e1 or e2)\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src sparql.sql:1858\n";

static const char *proc74 = 
" create function DB.DBA.__not (in e1 any) returns integer\n"
"{\n"
"if (e1)\n"
"return 0;\n"
"return 1;\n"
"}\n"
"--src sparql.sql:1867\n";

static const char *proc75 = 
"create procedure DB.DBA.RDF_QUAD_URI (in g_uri varchar, in s_uri varchar, in p_uri varchar, in o_uri varchar)\n"
"{\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (\n"
"iri_to_id (g_uri),\n"
"iri_to_id (s_uri),\n"
"iri_to_id (p_uri),\n"
"iri_to_id (o_uri) );\n"
"}\n"
"--src sparql.sql:1879\n";

static const char *proc76 = 
"create procedure DB.DBA.RDF_QUAD_URI_L (in g_uri varchar, in s_uri varchar, in p_uri varchar, in o_lit any, in ro_id_dict any := null)\n"
"{\n"
"declare g_iid, p_iid IRI_ID;\n"
"g_iid := iri_to_id (g_uri);\n"
"p_iid := iri_to_id (p_uri);\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (\n"
"g_iid,\n"
"iri_to_id (s_uri),\n"
"p_iid,\n"
"DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT (o_lit, g_iid, p_iid, ro_id_dict) );\n"
"}\n"
"--src sparql.sql:1890\n";

static const char *proc77 = 
"create procedure DB.DBA.RDF_QUAD_URI_L_TYPED (in g_uri varchar, in s_uri varchar, in p_uri varchar, in o_lit any, in dt any, in lang varchar, in ro_id_dict any := null)\n"
"{\n"
"declare g_iid, p_iid IRI_ID;\n"
"g_iid := iri_to_id (g_uri);\n"
"p_iid := iri_to_id (p_uri);\n"
"if (dt is null and lang is null)\n"
"{\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (\n"
"g_iid,\n"
"iri_to_id (s_uri),\n"
"p_iid,\n"
"DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT (o_lit, g_iid, p_iid, ro_id_dict) );\n"
"return;\n"
"}\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (\n"
"g_iid,\n"
"iri_to_id (s_uri),\n"
"p_iid,\n"
"DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_FT (\n"
"o_lit, iri_to_id (dt), lang, g_iid, p_iid, ro_id_dict ) );\n"
"}\n"
"--src sparql.sql:1904\n";

static const char *proc78 = 
"create procedure DB.DBA.TTLP_EV_NEW_GRAPH (inout g varchar, inout g_iid IRI_ID, inout app_env any) {\n"
"\n"
"if (__rdf_obj_ft_rule_count_in_graph (g_iid))\n"
"app_env[1] := dict_new (app_env[2]);\n"
"else\n"
"app_env[1] := null;\n"
"}\n"
"--src sparql.sql:1929\n";

static const char *proc79 = 
"create procedure DB.DBA.TTLP_EV_NEW_BLANK (inout g_iid IRI_ID, inout app_env any, inout res IRI_ID) {\n"
"res := iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\'));\n"
"\n"
"}\n"
"--src sparql.sql:1938\n";

static const char *proc80 = 
"create procedure DB.DBA.TTLP_EV_GET_IID (inout uri varchar, inout g_iid IRI_ID, inout app_env any, inout res IRI_ID) {\n"
"\n"
"res := iri_to_id (uri);\n"
"\n"
"}\n"
"--src sparql.sql:1944\n";

static const char *proc81 = 
"create procedure DB.DBA.TTLP_EV_TRIPLE (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_uri varchar,\n"
"inout app_env any )\n"
"{\n"
"\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, iri_to_id (s_uri), iri_to_id (p_uri), iri_to_id (o_uri) );\n"
"}\n"
"--src sparql.sql:1951\n";

static const char *proc82 = 
"create procedure DB.DBA.TTLP_EV_TRIPLE_L (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout app_env any )\n"
"{\n"
"\n"
"declare log_mode integer;\n"
"declare p_iid IRI_ID;\n"
"declare ro_id_dict any;\n"
"log_mode := app_env[0];\n"
"ro_id_dict := app_env[1];\n"
"p_iid := iri_to_id (p_uri);\n"
"if (isstring (o_type))\n"
"{\n"
"declare parsed any;\n"
"parsed := __xqf_str_parse_to_rdf_box (o_val, o_type, isstring (o_val));\n"
"if (parsed is not null)\n"
"{\n"
"if (__tag of XML = __tag (parsed))\n"
"{\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, iri_to_id (s_uri), p_iid,\n"
"DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT (\n"
"parsed, g_iid, p_iid, ro_id_dict ) );\n"
"return;\n"
"}\n"
"if (__tag of rdf_box = __tag (parsed))\n"
"{\n"
"if (256 = rdf_box_type (parsed))\n"
"db..rdf_geo_add (parsed);\n"
"else\n"
"rdf_box_set_type (parsed,\n"
"DB.DBA.RDF_TWOBYTE_OF_DATATYPE (iri_to_id (o_type)));\n"
"}\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, iri_to_id (s_uri), p_iid, parsed);\n"
"return;\n"
"}\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, iri_to_id (s_uri), p_iid,\n"
"DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_FT (\n"
"o_val,\n"
"iri_to_id (o_type),\n"
"case (isstring (o_lang)) when 0 then null else o_lang end,\n"
"g_iid, p_iid, ro_id_dict ) );\n"
"return;\n"
"}\n"
"if (isstring (o_lang))\n"
"{\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, iri_to_id (s_uri), p_iid,\n"
"DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_FT (o_val, NULL, o_lang, g_iid, p_iid, ro_id_dict) );\n"
"return;\n"
"}\n"
"if (isstring (o_val) or (__tag of XML = __tag (o_val)))\n"
"{\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, iri_to_id (s_uri), p_iid,\n"
"DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT (o_val, g_iid, p_iid, ro_id_dict) );\n"
"}\n"
"else\n"
"{\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, iri_to_id (s_uri), p_iid,\n"
"o_val );\n"
"}\n"
"}\n"
"--src sparql.sql:1962\n";

static const char *proc83 = 
"create procedure DB.DBA.TTLP_EV_COMMIT (inout g varchar, inout app_env any) {\n"
"\n"
"declare log_mode integer;\n"
"declare ro_id_dict any;\n"
"log_mode := app_env[0];\n"
"ro_id_dict := app_env[1];\n"
"if (ro_id_dict is not null)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (iri_to_id (g), ro_id_dict);\n"
"}\n"
"--src sparql.sql:2031\n";

static const char *proc84 = 
"create procedure DB.DBA.TTLP_EV_REPORT_DEFAULT (\n"
"inout msg_no integer, inout msg_type varchar,\n"
"inout src varchar, inout base varchar, inout graph varchar,\n"
"inout line_no integer, inout triple_no integer,\n"
"inout sstate varchar, inout smore varchar, inout descr varchar,\n"
"inout env any )\n"
"{\n"
"\n"
" ;\n"
"}\n"
"--src sparql.sql:2042\n";

static const char *proc85 = 
"create procedure DB.DBA.TTLP_EV_TRIPLE_XLAT (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_uri varchar,\n"
"inout app_env any )\n"
"{\n"
"declare xlat_cbk, s_xlat, o_xlat varchar;\n"
"declare xlat_env any;\n"
"\n"
"xlat_cbk := app_env[3];\n"
"xlat_env := app_env[4];\n"
"s_xlat := call(xlat_cbk)(s_uri, xlat_env);\n"
"o_xlat := call(xlat_cbk)(o_uri, xlat_env);\n"
"DB.DBA.TTLP_EV_TRIPLE (g_iid, s_xlat, p_uri, o_xlat, app_env);\n"
"}\n"
"--src sparql.sql:2054\n";

static const char *proc86 = 
"create procedure DB.DBA.TTLP_EV_TRIPLE_L_XLAT (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout app_env any )\n"
"{\n"
"declare xlat_cbk, s_xlat varchar;\n"
"declare xlat_env any;\n"
"\n"
"xlat_cbk := app_env[3];\n"
"xlat_env := app_env[4];\n"
"s_xlat := call(xlat_cbk)(s_uri, xlat_env);\n"
"DB.DBA.TTLP_EV_TRIPLE_L (g_iid, s_xlat, p_uri, o_val, o_type, o_lang, app_env);\n"
"}\n"
"--src sparql.sql:2070\n";

static const char *proc87 = 
" create procedure DB.DBA.TTLP_XLAT_CONCAT (\n"
"inout iri varchar, inout env any )\n"
"{\n"
"if (__tag (iri) <> __tag of varchar)\n"
"return iri;\n"
"if (iri like \'http://%\')\n"
"return concat (env, subseq (iri, 7));\n"
"return iri;\n"
"}\n"
"--src sparql.sql:2086\n";

static const char *proc88 = 
"create procedure DB.DBA.TTLP (in strg varchar, in base varchar, in graph varchar := null, in flags integer := 0,\n"
"in log_enable int := null, in transactional int := 0)\n"
"{\n"
"declare app_env any;\n"
"declare old_log_mode int;\n"
"if (graph = \'\')\n"
"signal (\'22023\', \'Empty string is not a valid graph IRI in DB.DBA.TTLP()\');\n"
"else if (graph is null)\n"
"{\n"
"graph := base;\n"
"if ((graph is null) or (graph = \'\'))\n"
"signal (\'22023\', \'DB.DBA.TTLP() requires a valid IRI as a base argument if graph is not specified\');\n"
"}\n"
"old_log_mode := null;\n"
"if (transactional = 0)\n"
"{\n"
"if (log_enable = 0 or log_enable = 1)\n"
"log_enable := log_enable + 2;\n"
"}\n"
"if (log_enable is not null)\n"
"{\n"
"old_log_mode := log_enable (log_enable, 1);\n"
"}\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"DB.DBA.TTLP_CL (strg, base, graph, flags);\n"
"return;\n"
"}\n"
"if (126 = __tag (strg))\n"
"strg := cast (strg as varchar);\n"
"app_env := vector (flags, null, __max (length (strg) / 100, 100000));\n"
"return rdf_load_turtle (strg, base, graph, flags,\n"
"vector (\n"
"\'DB.DBA.TTLP_EV_NEW_GRAPH\',\n"
"\'DB.DBA.TTLP_EV_NEW_BLANK\',\n"
"\'DB.DBA.TTLP_EV_GET_IID\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_L\',\n"
"\'DB.DBA.TTLP_EV_COMMIT\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"app_env);\n"
"}\n"
"--src sparql.sql:2097\n";

static const char *proc89 = 
"create procedure DB.DBA.TTLP_WITH_IRI_TRANSLATION (in strg varchar, in base varchar, in graph varchar, in flags integer,\n"
"in log_enable integer, in transactional integer,\n"
"in iri_xlate_cbk varchar, in iri_xlate_env any )\n"
"{\n"
"declare app_env any;\n"
"declare old_log_mode int;\n"
"if (graph = \'\')\n"
"signal (\'22023\', \'Empty string is not a valid graph IRI in DB.DBA.TTLP()\');\n"
"else if (graph is null)\n"
"{\n"
"graph := base;\n"
"if ((graph is null) or (graph = \'\'))\n"
"signal (\'22023\', \'DB.DBA.TTLP() requires a valid IRI as a base argument if graph is not specified\');\n"
"}\n"
"old_log_mode := null;\n"
"if (transactional = 0)\n"
"{\n"
"if (log_enable = 0 or log_enable = 1)\n"
"log_enable := log_enable + 2;\n"
"}\n"
"if (log_enable is not null)\n"
"{\n"
"old_log_mode := log_enable (log_enable, 1);\n"
"}\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"DB.DBA.TTLP_CL (strg, base, graph, flags);\n"
"return;\n"
"}\n"
"if (126 = __tag (strg))\n"
"strg := cast (strg as varchar);\n"
"app_env := vector (flags, null, __max (length (strg) / 100, 100000), iri_xlate_cbk, iri_xlate_env);\n"
"return rdf_load_turtle (strg, base, graph, flags,\n"
"vector (\n"
"\'DB.DBA.TTLP_EV_NEW_GRAPH\',\n"
"\'DB.DBA.TTLP_EV_NEW_BLANK\',\n"
"\'DB.DBA.TTLP_EV_GET_IID\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_XLAT\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_L_XLAT\',\n"
"\'DB.DBA.TTLP_EV_COMMIT\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"app_env);\n"
"}\n"
"--src sparql.sql:2141\n";

static const char *proc90 = 
"create procedure DB.DBA.TTLP_VALIDATE (in strg varchar, in base varchar, in graph varchar := null, in flags integer := 0, in report_cbk varchar := \'\')\n"
"{\n"
"declare app_env any;\n"
"declare old_log_mode int;\n"
"if (126 = __tag (strg))\n"
"strg := cast (strg as varchar);\n"
"return rdf_load_turtle (strg, base, graph, flags,\n"
"vector (\'\', \'\', \'\', \'\', \'\', \'\', report_cbk),\n"
"app_env);\n"
"}\n"
"--src sparql.sql:2186\n";

static const char *proc91 = 
"create procedure DB.DBA.TTLP_VALIDATE_LOCAL_FILE (in strg varchar, in base varchar, in graph varchar := null, in flags integer := 0, in report_cbk varchar := \'\')\n"
"{\n"
"declare app_env any;\n"
"declare old_log_mode int;\n"
"if (126 = __tag (strg))\n"
"strg := cast (strg as varchar);\n"
"return rdf_load_turtle_local_file (strg, base, graph, flags,\n"
"vector (\'\', \'\', \'\', \'\', \'\', \'\', report_cbk),\n"
"app_env);\n"
"}\n"
"--src sparql.sql:2198\n";

static const char *proc92 = 
"create procedure DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH (inout g varchar, inout g_iid IRI_ID, inout app_env any) {\n"
"\n"
" ;\n"
"}\n"
"--src sparql.sql:2210\n";

static const char *proc93 = 
"create procedure DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK (inout g_iid IRI_ID, inout app_env any, inout res IRI_ID) {\n"
"res := iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\'));\n"
"\n"
"}\n"
"--src sparql.sql:2216\n";

static const char *proc94 = 
"create procedure DB.DBA.RDF_TTL2HASH_EXEC_GET_IID (inout uri varchar, inout g_iid IRI_ID, inout app_env any, inout res IRI_ID) {\n"
"\n"
"res := iri_to_id (uri);\n"
"\n"
"}\n"
"--src sparql.sql:2222\n";

static const char *proc95 = 
"create procedure DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_uri varchar,\n"
"inout app_env any )\n"
"{\n"
"dict_put (app_env,\n"
"vector (iri_to_id (s_uri), iri_to_id (p_uri), iri_to_id (o_uri)),\n"
"0 );\n"
"}\n"
"--src sparql.sql:2229\n";

static const char *proc96 = 
"create procedure DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout app_env any )\n"
"{\n"
"if (not isstring (o_type))\n"
"o_type := null;\n"
"if (not isstring (o_lang))\n"
"o_lang := null;\n"
"dict_put (app_env,\n"
"vector (\n"
"iri_to_id (s_uri),\n"
"iri_to_id (p_uri),\n"
"DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL_STRINGS (o_val,\n"
"case (isstring (o_type)) when 0 then null else o_type end,\n"
"case (isstring (o_lang)) when 0 then null else o_lang end) ),\n"
"0 );\n"
"}\n"
"--src sparql.sql:2240\n";

static const char *proc97 = 
"create function DB.DBA.RDF_TTL2HASH (in strg varchar, in base varchar, in graph varchar := null, in flags integer := 0) returns any\n"
"{\n"
"declare res any;\n"
"res := dict_new ();\n"
"if (126 = __tag (strg))\n"
"strg := cast (strg as varchar);\n"
"res := dict_new (length (strg) / 100);\n"
"rdf_load_turtle (strg, base, graph, flags,\n"
"vector (\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_GET_IID\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L\',\n"
"\'\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"res);\n"
"return res;\n"
"}\n"
"--src sparql.sql:2260\n";

static const char *proc98 = 
"create procedure DB.DBA.RDF_TTL2SQLHASH_EXEC_GET_IID (inout uri varchar, inout g_iid IRI_ID, inout app_env any, inout res IRI_ID) {\n"
"\n"
"res := __bft (uri, 1);\n"
"\n"
"}\n"
"--src sparql.sql:2281\n";

static const char *proc99 = 
"create procedure DB.DBA.RDF_TTL2SQLHASH_EXEC_TRIPLE (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_uri varchar,\n"
"inout app_env any )\n"
"{\n"
"dict_put (app_env,\n"
"vector (\n"
"__bft (s_uri, 1),\n"
"__bft (p_uri, 1),\n"
"__bft (o_uri, 1) ),\n"
"0 );\n"
"}\n"
"--src sparql.sql:2288\n";

static const char *proc100 = 
"create procedure DB.DBA.RDF_TTL2SQLHASH_EXEC_TRIPLE_L (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout app_env any )\n"
"{\n"
"if (not isstring (o_type))\n"
"o_type := null;\n"
"if (not isstring (o_lang))\n"
"o_lang := null;\n"
"dict_put (app_env,\n"
"vector (\n"
"__bft (s_uri, 1),\n"
"__bft (p_uri, 1),\n"
"DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL_STRINGS (o_val,\n"
"case (isstring (o_type)) when 0 then null else o_type end,\n"
"case (isstring (o_lang)) when 0 then null else o_lang end) ),\n"
"0 );\n"
"}\n"
"--src sparql.sql:2302\n";

static const char *proc101 = 
"create function DB.DBA.RDF_TTL2SQLHASH (in strg varchar, in base varchar, in graph varchar := null, in flags integer := 0) returns any\n"
"{\n"
"declare res any;\n"
"res := dict_new ();\n"
"if (126 = __tag (strg))\n"
"strg := cast (strg as varchar);\n"
"res := dict_new (length (strg) / 100);\n"
"rdf_load_turtle (strg, base, graph, flags,\n"
"vector (\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK\',\n"
"\'DB.DBA.RDF_TTL2SQLHASH_EXEC_GET_IID\',\n"
"\'DB.DBA.RDF_TTL2SQLHASH_EXEC_TRIPLE\',\n"
"\'DB.DBA.RDF_TTL2SQLHASH_EXEC_TRIPLE_L\',\n"
"\'\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"res);\n"
"return res;\n"
"}\n"
"--src sparql.sql:2322\n";

static const char *proc102 = 
"create procedure DB.DBA.RDF_LOAD_RDFXML (in strg varchar, in base varchar, in graph varchar,\n"
"in log_enable int := null, in transactional int := 0)\n"
"{\n"
"declare app_env any;\n"
"declare old_log_mode int;\n"
"if (graph = \'\')\n"
"signal (\'22023\', \'Empty string is not a valid graph IRI in DB.DBA.RDF_LOAD_RDFXML()\');\n"
"else if (graph is null)\n"
"{\n"
"graph := base;\n"
"if ((graph is null) or (graph = \'\'))\n"
"signal (\'22023\', \'DB.DBA.RDF_LOAD_RDFXML() requires a valid IRI as a base argument if graph is not specified\');\n"
"}\n"
"old_log_mode := null;\n"
"if (transactional = 0)\n"
"{\n"
"if (log_enable = 0 or log_enable = 1)\n"
"log_enable := log_enable + 2;\n"
"}\n"
"if (log_enable is not null)\n"
"{\n"
"old_log_mode := log_enable (log_enable, 1);\n"
"}\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"return rdf_load_rdfxml_cl (strg, base, graph);\n"
"app_env := vector (null, null, __max (length (strg) / 100, 100000));\n"
"rdf_load_rdfxml (strg, 0,\n"
"graph,\n"
"vector (\n"
"\'DB.DBA.TTLP_EV_NEW_GRAPH\',\n"
"\'DB.DBA.TTLP_EV_NEW_BLANK\',\n"
"\'DB.DBA.TTLP_EV_GET_IID\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_L\',\n"
"\'DB.DBA.TTLP_EV_COMMIT\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"app_env,\n"
"base );\n"
"return graph;\n"
"}\n"
"--src sparql.sql:2343\n";

static const char *proc103 = 
"create procedure DB.DBA.RDF_RDFXML_TO_DICT (in strg varchar, in base varchar, in graph varchar := null)\n"
"{\n"
"declare res any;\n"
"res := dict_new (length (strg) / 100);\n"
"rdf_load_rdfxml (strg, 0,\n"
"graph,\n"
"vector (\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_GET_IID\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L\',\n"
"\'\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"res,\n"
"base );\n"
"return res;\n"
"}\n"
"--src sparql.sql:2385\n";

static const char *proc104 = 
"create procedure DB.DBA.RDF_LOAD_RDFA (in strg varchar, in base varchar, in graph varchar := null, in xml_parse_mode integer := 0)\n"
"{\n"
"declare app_env any;\n"
"if (graph = \'\')\n"
"signal (\'22023\', \'Empty string is not a valid graph IRI in DB.DBA.RDF_LOAD_RDFA()\');\n"
"else if (graph is null)\n"
"{\n"
"graph := base;\n"
"if ((graph is null) or (graph = \'\'))\n"
"signal (\'22023\', \'DB.DBA.RDF_LOAD_RDFA() requires a valid IRI as a base argument if graph is not specified\');\n"
"}\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"return DB.DBA.RDF_LOAD_RDFA_CL (strg, base, graph, xml_parse_mode);\n"
"app_env := vector (null, null, __max (length (strg) / 100, 100000));\n"
"rdf_load_rdfxml (strg, bit_or (2, bit_shift (xml_parse_mode, 8)),\n"
"graph,\n"
"vector (\n"
"\'DB.DBA.TTLP_EV_NEW_GRAPH\',\n"
"\'DB.DBA.TTLP_EV_NEW_BLANK\',\n"
"\'DB.DBA.TTLP_EV_GET_IID\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_L\',\n"
"\'DB.DBA.TTLP_EV_COMMIT\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"app_env,\n"
"base );\n"
"return graph;\n"
"}\n"
"--src sparql.sql:2405\n";

static const char *proc105 = 
"create procedure DB.DBA.RDF_LOAD_RDFA_WITH_IRI_TRANSLATION (in strg varchar, in base varchar, in graph varchar, in xml_parse_mode integer,\n"
"in iri_xlate_cbk varchar, in iri_xlate_env any )\n"
"{\n"
"declare app_env any;\n"
"if (graph = \'\')\n"
"signal (\'22023\', \'Empty string is not a valid graph IRI in DB.DBA.RDF_LOAD_RDFA_WITH_IRI_TRANSLATION ()\');\n"
"else if (graph is null)\n"
"{\n"
"graph := base;\n"
"if ((graph is null) or (graph = \'\'))\n"
"signal (\'22023\', \'DB.DBA.RDF_LOAD_RDFA_WITH_IRI_TRANSLATION () requires a valid IRI as a base argument if graph is not specified\');\n"
"}\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"return DB.DBA.RDF_LOAD_RDFA_WITH_IRI_TRANSLATION_CL (strg, base, graph, xml_parse_mode, iri_xlate_cbk, iri_xlate_env);\n"
"app_env := vector (null, null, __max (length (strg) / 100, 100000), iri_xlate_cbk, iri_xlate_env);\n"
"rdf_load_rdfxml (strg, bit_or (2, bit_shift (xml_parse_mode, 8)),\n"
"graph,\n"
"vector (\n"
"\'DB.DBA.TTLP_EV_NEW_GRAPH\',\n"
"\'DB.DBA.TTLP_EV_NEW_BLANK\',\n"
"\'DB.DBA.TTLP_EV_GET_IID\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_XLAT\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_L_XLAT\',\n"
"\'DB.DBA.TTLP_EV_COMMIT\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"app_env,\n"
"base );\n"
"return graph;\n"
"}\n"
"--src sparql.sql:2435\n";

static const char *proc106 = 
"create procedure DB.DBA.RDF_RDFA_TO_DICT (in strg varchar, in base varchar, in graph varchar := null)\n"
"{\n"
"declare res any;\n"
"res := dict_new (length (strg) / 100);\n"
"rdf_load_rdfxml (strg, 2,\n"
"graph,\n"
"vector (\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_GET_IID\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L\',\n"
"\'\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"res,\n"
"base );\n"
"return res;\n"
"}\n"
"--src sparql.sql:2466\n";

static const char *proc107 = 
" create procedure DB.DBA.RDF_XML_IRI_TO_TTL (inout obj any, inout ses any)\n"
"{\n"
"declare res varchar;\n"
"if (isiri_id (obj))\n"
"{\n"
"if (obj >= min_bnode_iri_id ())\n"
"{\n"
"if (obj >= #ib0)\n"
"http (sprintf (\'_:bb%d \', iri_id_num (obj) - iri_id_num (#ib0)), ses);\n"
"else\n"
"http (sprintf (\'_:b%d \', iri_id_num (obj)), ses);\n"
"}\n"
"else\n"
"{\n"
"res := coalesce (id_to_iri (obj), sprintf (\'_:bad_iid_%d\', iri_id_num (obj)));\n"
"\n"
"http (\'<\', ses);\n"
"http_escape (res, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"}\n"
"else if (__tag of varchar = __tag (obj))\n"
"{\n"
"if (\"LEFT\" (obj, 9) = \'nodeID://\')\n"
"{\n"
"http (\'_:\', ses);\n"
"http (subseq (obj, 9), ses);\n"
"http (\' \', ses);\n"
"}\n"
"else\n"
"{\n"
"http (\'<\', ses);\n"
"http_escape (obj, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"http (\'<\', ses);\n"
"http_escape (cast (obj as varchar), 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"}\n"
"--src sparql.sql:2490\n";

static const char *proc108 = 
" create procedure DB.DBA.RDF_XML_OBJ_TO_TTL (\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout ses any)\n"
"{\n"
"declare res varchar;\n"
"if (isiri_id (o_val))\n"
"{\n"
"if (o_val >= min_bnode_iri_id ())\n"
"{\n"
"if (o_val >= #ib0)\n"
"http (sprintf (\'_:bb%d \', iri_id_num (o_val) - iri_id_num (#ib0)), ses);\n"
"else\n"
"http (sprintf (\'_:b%d \', iri_id_num (o_val)), ses);\n"
"}\n"
"else\n"
"{\n"
"res := coalesce (id_to_iri (o_val), sprintf (\'_:bad_iid_%d\', iri_id_num (o_val)));\n"
"http (\'<\', ses);\n"
"http_escape (res, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"return;\n"
"}\n"
"http (\'\"\', ses);\n"
"if (__tag of XML = o_val)\n"
"http_escape (serialize_to_UTF8_xml (o_val), 11, ses, 1, 1);\n"
"else\n"
"http_escape (o_val, 11, ses, 1, 1);\n"
"if (isstring (o_type))\n"
"{\n"
"http (\'\"^^<\', ses);\n"
"http_escape (o_type, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"else if (isstring (o_lang))\n"
"{\n"
"http (\'\"@\', ses);\n"
"http (o_lang, ses);\n"
"http (\' \', ses);\n"
"}\n"
"else\n"
"http (\'\" \', ses);\n"
"}\n"
"--src sparql.sql:2536\n";

static const char *proc109 = 
" create procedure DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_NEW_BLANK (inout g_iid IRI_ID, inout app_env any, inout res IRI_ID)\n"
"{\n"
" ;\n"
"}\n"
"--src sparql.sql:2582\n";

static const char *proc110 = 
" create procedure DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_TRIPLE (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_uri varchar,\n"
"inout app_env any )\n"
"{\n"
"DB.DBA.RDF_XML_IRI_TO_TTL (s_uri, app_env);\n"
"DB.DBA.RDF_XML_IRI_TO_TTL (p_uri, app_env);\n"
"DB.DBA.RDF_XML_IRI_TO_TTL (o_uri, app_env);\n"
"http (\'.\\n\', app_env);\n"
"}\n"
"--src sparql.sql:2589\n";

static const char *proc111 = 
" create procedure DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_TRIPLE_L (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout app_env any )\n"
"{\n"
"DB.DBA.RDF_XML_IRI_TO_TTL (s_uri, app_env);\n"
"DB.DBA.RDF_XML_IRI_TO_TTL (p_uri, app_env);\n"
"DB.DBA.RDF_XML_OBJ_TO_TTL (o_val, o_type, o_lang, app_env);\n"
"http (\'.\\n\', app_env);\n"
"}\n"
"--src sparql.sql:2602\n";

static const char *proc112 = 
" create procedure DB.DBA.RDF_CONVERT_RDFXML_TO_TTL (in strg varchar, in base varchar, inout ttl_ses any)\n"
"{\n"
"rdf_load_rdfxml (strg, 0,\n"
"\'http://example.com\',\n"
"vector (\n"
"\'\',\n"
"\'DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_NEW_BLANK\',\n"
"\'DB.DBA.TTLP_EV_GET_IID\',\n"
"\'DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_TRIPLE\',\n"
"\'DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_TRIPLE_L\',\n"
"\'\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"ttl_ses,\n"
"base );\n"
"}\n"
"--src sparql.sql:2615\n";

static const char *proc113 = 
" create procedure DB.DBA.RDF_CONVERT_RDFXML_FILE_TO_TTL_FILE (in rdfxml_source_filename varchar, in base varchar, in ttl_target_filename varchar)\n"
"{\n"
"declare in_ses, out_ses any;\n"
"in_ses := file_to_string_output (rdfxml_source_filename);\n"
"out_ses := string_output ();\n"
"DB.DBA.RDF_CONVERT_RDFXML_TO_TTL (in_ses, base, out_ses);\n"
"string_to_file (ttl_target_filename, out_ses, -2);\n"
"}\n"
"--src sparql.sql:2633\n";

static const char *proc114 = 
"create procedure DB.DBA.RDF_LONG_TO_TTL (inout obj any, inout ses any)\n"
"{\n"
"declare res varchar;\n"
"if (obj is null)\n"
"signal (\'RDFXX\', \'DB.DBA.RDF_LONG_TO_TTL(): object is NULL\');\n"
"if (isiri_id (obj))\n"
"{\n"
"if (obj >= min_bnode_iri_id ())\n"
"{\n"
"if (obj >= #ib0)\n"
"http (sprintf (\'_:bb%d \', iri_id_num (obj) - iri_id_num (#ib0)), ses);\n"
"else\n"
"http (sprintf (\'_:b%d \', iri_id_num (obj)), ses);\n"
"}\n"
"else\n"
"{\n"
"res := coalesce (id_to_iri (obj), sprintf (\'_:bad_iid_%d\', iri_id_num (obj)));\n"
"\n"
"http (\'<\', ses);\n"
"http_escape (res, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"}\n"
"else if (__tag of rdf_box = __tag (obj))\n"
"{\n"
"http (\'\"\', ses);\n"
"if (rdf_box_data_tag (obj) in (__tag of varchar, __tag of long varchar, __tag of nvarchar, __tag of long nvarchar, 185))\n"
"http_escape (__rdf_sqlval_of_obj (obj, 1), 11, ses, 1, 1);\n"
"else if (__tag of datetime = rdf_box_data_tag (obj))\n"
"__rdf_long_to_ttl (obj, ses);\n"
"else if (__tag of XML = rdf_box_data_tag (obj))\n"
"http_escape (serialize_to_UTF8_xml (__rdf_sqlval_of_obj (obj, 1)), 11, ses, 1, 1);\n"
"else if (__tag of varbinary = rdf_box_data_tag (obj))\n"
"{\n"
"http (\'\"\', ses);\n"
"http_escape (__rdf_sqlval_of_obj (obj, 1), 11, ses, 0, 0);\n"
"http (\'\" \', ses);\n"
"}\n"
"else\n"
"http_escape (cast (__rdf_sqlval_of_obj (obj, 1) as varchar), 11, ses, 1, 1);\n"
"if (257 <> rdf_box_type (obj))\n"
"{\n"
"res := coalesce ((select RDT_QNAME from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = rdf_box_type (obj)));\n"
"if (res is null)\n"
"signal (\'RDFXX\', sprintf (\'Bad rdf box type (%d), box \"%s\"\', rdf_box_type (obj), cast (rdf_box_data (obj) as varchar)));\n"
"http (\'\"^^<\', ses);\n"
"http_escape (res, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"else if (257 <> rdf_box_lang (obj))\n"
"{\n"
"res := coalesce ((select lower (RL_ID) from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = rdf_box_lang (obj)));\n"
"http (\'\"@\', ses); http (res, ses); http (\' \', ses);\n"
"}\n"
"else\n"
"http (\'\" \', ses);\n"
"}\n"
"else if (__tag of varchar = __tag (obj))\n"
"{\n"
"if (1 = __box_flags (obj))\n"
"{\n"
"http (\'<\', ses);\n"
"http_escape (obj, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"else\n"
"{\n"
"http (\'\"\', ses);\n"
"http_escape (obj, 11, ses, 1, 1);\n"
"http (\'\" \', ses);\n"
"}\n"
"}\n"
"else if (__tag (obj) in (__tag of long varchar, __tag of nvarchar, __tag of long nvarchar, 185))\n"
"{\n"
"http (\'\"\', ses);\n"
"http_escape (obj, 11, ses, 1, 1);\n"
"http (\'\" \', ses);\n"
"}\n"
"else if (__tag of datetime = rdf_box_data_tag (obj))\n"
"{\n"
"http (\'\"\', ses);\n"
"__rdf_long_to_ttl (obj, ses);\n"
"http (\'\"^^<\', ses);\n"
"http_escape (cast (__xsd_type (obj) as varchar), 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"else if (__tag of varbinary =  __tag (obj))\n"
"{\n"
"http (\'\"\', ses);\n"
"http_escape (obj, 11, ses, 0, 0);\n"
"http (\'\" \', ses);\n"
"}\n"
"else\n"
"{\n"
"http (\'\"\', ses);\n"
"http_escape (__rdf_strsqlval (obj), 11, ses, 1, 1);\n"
"http (\'\"^^<\', ses);\n"
"http_escape (cast (__xsd_type (obj) as varchar), 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"}\n"
"--src sparql.sql:2646\n";

static const char *proc115 = 
"create procedure DB.DBA.RDF_TRIPLES_TO_VERBOSE_TTL (inout triples any, inout ses any)\n"
"{\n"
"declare tcount, tctr integer;\n"
"declare prev_s, prev_p IRI_ID;\n"
"declare res varchar;\n"
"declare string_subjs_found, string_preds_found integer;\n"
"string_subjs_found := 0;\n"
"string_preds_found := 0;\n"
"tcount := length (triples);\n"
"\n"
"if (0 = tcount)\n"
"{\n"
"http (\'# Empty TURTLE\\n\', ses);\n"
"return;\n"
"}\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare subj,pred any;\n"
"subj := triples[tctr][0];\n"
"pred := triples[tctr][1];\n"
"if (not (isiri_id (subj)))\n"
"{\n"
"if (isstring (subj) and (1 = __box_flags (subj)))\n"
"string_subjs_found := 1;\n"
"else\n"
"{\n"
"if (subj is null)\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_TTL(): subject is NULL\');\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_TTL(): subject is literal\');\n"
"}\n"
"}\n"
"if (not isiri_id (pred))\n"
"{\n"
"if (isstring (pred) and (1 = __box_flags (pred)))\n"
"string_preds_found := 1;\n"
"else\n"
"{\n"
"if (pred is null)\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_TTL(): predicate is NULL\');\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_TTL(): predicate is literal\');\n"
"}\n"
"}\n"
"if (pred >= min_bnode_iri_id ())\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_TTL(): blank node as predicate\');\n"
"}\n"
"if (not string_preds_found)\n"
"rowvector_digit_sort (triples, 1, 1);\n"
"if (not string_subjs_found)\n"
"rowvector_digit_sort (triples, 0, 1);\n"
"prev_s := null;\n"
"prev_p := null;\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare subj,pred,obj any;\n"
"subj := triples[tctr][0];\n"
"pred := triples[tctr][1];\n"
"obj := triples[tctr][2];\n"
"if (prev_s = subj)\n"
"{\n"
"if (prev_p = pred)\n"
"{\n"
"http (\',\\n\\t\\t\', ses);\n"
"goto print_o;\n"
"}\n"
"http (\';\\n\\t\', ses);\n"
"goto print_p;\n"
"}\n"
"if (prev_s is not null)\n"
"http (\'.\\n\', ses);\n"
"if (isstring (subj))\n"
"{\n"
"if (subj like \'nodeID://%\')\n"
"{\n"
"http (\'_:\', ses);\n"
"http_escape (subseq (subj, 9), 12, ses, 1, 1);\n"
"http (\' \', ses);\n"
"}\n"
"else\n"
"{\n"
"http (\'<\', ses);\n"
"http_escape (subj, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"}\n"
"else if (subj >= min_bnode_iri_id ())\n"
"{\n"
"if (subj >= #ib0)\n"
"http (sprintf (\'_:bb%d \', iri_id_num (subj) - iri_id_num (#ib0)), ses);\n"
"else\n"
"http (sprintf (\'_:b%d \', iri_id_num (subj)), ses);\n"
"}\n"
"else\n"
"{\n"
"res := id_to_iri (subj);\n"
"http (\'<\', ses);\n"
"http_escape (res, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"prev_s := subj;\n"
"prev_p := null;\n"
"print_p:\n"
"if (isstring (pred))\n"
"{\n"
"if (pred like \'nodeID://%\')\n"
"{\n"
"http (\'_:\', ses);\n"
"http_escape (subseq (pred, 9), 12, ses, 1, 1);\n"
"http (\' \', ses);\n"
"}\n"
"else\n"
"{\n"
"http (\'<\', ses);\n"
"http_escape (pred, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"res := id_to_iri (pred);\n"
"http (\'<\', ses);\n"
"http_escape (res, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"prev_p := pred;\n"
"print_o:\n"
"DB.DBA.RDF_LONG_TO_TTL (obj, ses);\n"
"}\n"
"http (\'.\\n\', ses);\n"
"}\n"
"--src sparql.sql:2750\n";

static const char *proc116 = 
"create procedure DB.DBA.RDF_TRIPLES_TO_TTL (inout triples any, inout ses any)\n"
"{\n"
"declare env any;\n"
"declare tcount, tctr integer;\n"
"tcount := length (triples);\n"
"\n"
"if (0 = tcount)\n"
"{\n"
"http (\'# Empty TURTLE\\n\', ses);\n"
"return;\n"
"}\n"
"env := vector (dict_new (__min (tcount, 16000)), 0, \'\', \'\', \'\', 0, 0, 0, 0);\n"
"{ whenever sqlstate \'*\' goto end_pred_sort;\n"
"rowvector_subj_sort (triples, 1, 1);\n"
"end_pred_sort: ;\n"
"}\n"
"{ whenever sqlstate \'*\' goto end_subj_sort;\n"
"rowvector_subj_sort (triples, 0, 1);\n"
"end_subj_sort: ;\n"
"}\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"http_ttl_triple (env, triples[tctr][0], triples[tctr][1], triples[tctr][2], ses);\n"
"}\n"
"http (\' .\', ses);\n"
"}\n"
"--src sparql.sql:2881\n";

static const char *proc117 = 
"create procedure DB.DBA.RDF_TRIPLES_TO_NT (inout triples any, inout ses any)\n"
"{\n"
"declare env any;\n"
"declare tcount, tctr integer;\n"
"tcount := length (triples);\n"
"\n"
"if (0 = tcount)\n"
"{\n"
"http (\'# Empty NT\\n\', ses);\n"
"return;\n"
"}\n"
"env := vector (0, 0, 0);\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"http_nt_triple (env, triples[tctr][0], triples[tctr][1], triples[tctr][2], ses);\n"
"}\n"
"}\n"
"--src sparql.sql:2909\n";

static const char *proc118 = 
"create procedure DB.DBA.RDF_GRAPH_TO_TTL (in graph_iri varchar, inout ses any)\n"
"{\n"
"declare tcount integer;\n"
"declare res varchar;\n"
"declare prev_s, prev_p IRI_ID;\n"
"\n"
"tcount := 0;\n"
"prev_s := null;\n"
"prev_p := null;\n"
"for (select S as subj, P as pred, O as obj from RDF_QUAD where G = iri_to_id (graph_iri)) do\n"
"{\n"
"if (prev_s = subj)\n"
"{\n"
"if (prev_p = pred)\n"
"{\n"
"http (\',\\n\\t\\t\', ses);\n"
"goto print_o;\n"
"}\n"
"http (\';\\n\\t\', ses);\n"
"goto print_p;\n"
"}\n"
"if (prev_s is not null)\n"
"http (\'.\\n\', ses);\n"
"if (subj >= min_bnode_iri_id ())\n"
"{\n"
"if (subj >= #ib0)\n"
"http (sprintf (\'_:bb%d \', iri_id_num (subj) - iri_id_num (#ib0)), ses);\n"
"else\n"
"http (sprintf (\'_:b%d \', iri_id_num (subj)), ses);\n"
"}\n"
"else\n"
"{\n"
"res := id_to_iri (subj);\n"
"http (\'<\', ses);\n"
"http_escape (res, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"prev_s := subj;\n"
"prev_p := null;\n"
"print_p:\n"
"if (pred >= min_bnode_iri_id ())\n"
"signal (\'RDFXX\', \'DB.DBA.RDF_GRAPH_TO_TTL(): blank node as predicate\');\n"
"else\n"
"{\n"
"res := id_to_iri (pred);\n"
"http (\'<\', ses);\n"
"http_escape (res, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"prev_p := pred;\n"
"print_o:\n"
"DB.DBA.RDF_LONG_TO_TTL (obj, ses);\n"
"tcount := tcount + 1;\n"
"}\n"
"if (0 = tcount)\n"
"http (\'# Empty TURTLE\\n\', ses);\n"
"else\n"
"http (\'.\\n\', ses);\n"
"}\n"
"--src sparql.sql:2928\n";

static const char *proc119 = 
"create procedure DB.DBA.RDF_TRIPLES_TO_RDF_XML_TEXT (inout triples any, in print_top_level integer, inout ses any)\n"
"{\n"
"declare tcount, tctr integer;\n"
"tcount := length (triples);\n"
"if (print_top_level)\n"
"{\n"
"http (\'<?xml version=\"1.0\" encoding=\"utf-8\" ?>\\n<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" \'||\n"
"\'xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\">\', ses);\n"
"}\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare subj, pred, obj any;\n"
"declare pred_tagname varchar;\n"
"declare res varchar;\n"
"subj := triples[tctr][0];\n"
"pred := triples[tctr][1];\n"
"obj := triples[tctr][2];\n"
"\n"
"\n"
"\n"
"http (\'\\n<rdf:Description\', ses);\n"
"if (not isiri_id (subj))\n"
"{\n"
"if (isstring (subj) and (1 = __box_flags (subj)))\n"
"{\n"
"if (subj like \'nodeID://%\')\n"
"{\n"
"http (\' rdf:nodeID=\"b\', ses); http_value (subseq (subj, 9), 0, ses); http (\'\">\', ses);\n"
"}\n"
"else\n"
"{\n"
"http (\' rdf:about=\"\', ses); http_value (subj, 0, ses); http (\'\">\', ses);\n"
"}\n"
"}\n"
"else if (subj is null)\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_RDF_XML_TEXT(): subject is NULL\');\n"
"else\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_RDF_XML_TEXT(): subject is literal\');\n"
"}\n"
"else if (subj >= min_bnode_iri_id ())\n"
"http (sprintf (\' rdf:nodeID=\"b%d\">\', iri_id_num (subj)), ses);\n"
"else\n"
"{\n"
"res := id_to_iri (subj);\n"
"\n"
"http (\' rdf:about=\"\', ses); http_value (res, 0, ses); http (\'\">\', ses);\n"
"}\n"
"if (not isiri_id (pred))\n"
"{\n"
"if (isstring (pred) and (1 = __box_flags (pred)))\n"
"{\n"
"if (pred like \'nodeID://%\')\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_RDF_XML_TEXT(): blank node as predicate\');\n"
"res := pred;\n"
"goto res_for_pred;\n"
"}\n"
"else if (pred is null)\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_RDF_XML_TEXT(): predicate is NULL\');\n"
"else\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_RDF_XML_TEXT(): predicate is literal\');\n"
"}\n"
"if (pred >= min_bnode_iri_id ())\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_RDF_XML_TEXT(): blank node as predicate\');\n"
"res := id_to_iri (pred);\n"
"res_for_pred:\n"
"declare delim, delim1, delim2, delim3 integer;\n"
"delim1 := coalesce (strrchr (res, \'/\'), -1);\n"
"delim2 := coalesce (strrchr (res, \'#\'), -1);\n"
"delim3 := coalesce (strrchr (res, \':\'), -1);\n"
"delim := __max (delim1, delim2, delim3);\n"
"if (delim < 0)\n"
"delim := null;\n"
"if (delim is null)\n"
"{\n"
"pred_tagname := res;\n"
"http (\'<\', ses); http (pred_tagname, ses);\n"
"}\n"
"else\n"
"{\n"
"declare p_ns_uri, p_ns_pref varchar;\n"
"p_ns_uri := subseq (res, 0, delim+1);\n"
"if (p_ns_uri = \'http://www.w3.org/1999/02/22-rdf-syntax-ns#\')\n"
"{\n"
"pred_tagname := \'rdf:\' || subseq (res, delim+1);\n"
"http (\'<\', ses); http (pred_tagname, ses);\n"
"}\n"
"else if (p_ns_uri = \'http://www.w3.org/2000/01/rdf-schema#\')\n"
"{\n"
"pred_tagname := \'rdfs:\' || subseq (res, delim+1);\n"
"http (\'<\', ses); http (pred_tagname, ses);\n"
"}\n"
"else\n"
"{\n"
"p_ns_pref := coalesce (__xml_get_ns_prefix (p_ns_uri, 3), \'n0pred\');\n"
"pred_tagname := p_ns_pref || \':\' || subseq (res, delim+1);\n"
"http (\'<\', ses); http (pred_tagname, ses);\n"
"http (\' xmlns:\' || p_ns_pref || \'=\"\', ses); http_value (p_ns_uri, 0, ses); http (\'\"\', ses);\n"
"}\n"
"}\n"
"if (obj is null)\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_RDF_XML_TEXT(): object is NULL\');\n"
"if (isiri_id (obj))\n"
"{\n"
"if (obj >= min_bnode_iri_id ())\n"
"http (sprintf (\' rdf:nodeID=\"b%d\"/>\', iri_id_num (obj)), ses);\n"
"else\n"
"{\n"
"res := coalesce (id_to_iri(obj), sprintf (\'_:bad_iid_%d\', iri_id_num (obj)));\n"
"\n"
"http (\' rdf:resource=\"\', ses); http_value (res, 0, ses); http (\'\"/>\', ses);\n"
"}\n"
"}\n"
"else if (__tag of rdf_box = __tag (obj))\n"
"{\n"
"declare dat any;\n"
"if (257 <> rdf_box_type (obj))\n"
"{\n"
"res := coalesce ((select RDT_QNAME from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = rdf_box_type (obj)));\n"
"http (\' rdf:datatype=\"\', ses); http_value (res, 0, ses); http (\'\"\', ses);\n"
"}\n"
"else if (257 <> rdf_box_lang (obj))\n"
"{\n"
"res := coalesce ((select lower (RL_ID) from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = rdf_box_lang (obj)));\n"
"http (\' xml:lang=\"\', ses); http_value (res, 0, ses); http (\'\"\', ses);\n"
"}\n"
"dat := __rdf_sqlval_of_obj (obj, 1);\n"
"if (__tag of XML = __tag (dat))\n"
"{\n"
"http (\' rdf:parseType=\"Literal\">\', ses);\n"
"http_value (dat, 0, ses);\n"
"http (\'</\', ses); http (pred_tagname, ses); http (\'>\', ses);\n"
"}\n"
"else if (__tag of datetime = rdf_box_data_tag (obj))\n"
"{\n"
"if (257 = rdf_box_type (obj))\n"
"{\n"
"http (\' rdf:datatype=\"\', ses);\n"
"http_escape (cast (__xsd_type (dat) as varchar), 12, ses, 1, 1);\n"
"http (\'\">\', ses);\n"
"}\n"
"else\n"
"http (\'>\', ses);\n"
"__rdf_long_to_ttl (dat, ses);\n"
"http (\'</\', ses); http (pred_tagname, ses); http (\'>\', ses);\n"
"}\n"
"else\n"
"{\n"
"declare tmp any;\n"
"http (\'>\', ses);\n"
"tmp := __rdf_strsqlval (obj);\n"
"if (__tag of varchar = __tag (tmp))\n"
"tmp := charset_recode (tmp, \'UTF-8\', \'_WIDE_\');\n"
"http_value (tmp, 0, ses);\n"
"http (\'</\', ses); http (pred_tagname, ses); http (\'>\', ses);\n"
"}\n"
"}\n"
"else if (__tag of varchar = __tag (obj))\n"
"{\n"
"if (1 = __box_flags (obj))\n"
"{\n"
"if (obj like \'nodeID://%\')\n"
"{\n"
"http (\' rdf:nodeID=\"b\', ses); http_value (subseq (obj, 9), 0, ses); http (\'\"/>\', ses);\n"
"}\n"
"else\n"
"{\n"
"http (\' rdf:resource=\"\', ses); http_value (obj, 0, ses); http (\'\"/>\', ses);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"http (\'>\', ses);\n"
"obj := charset_recode (obj, \'UTF-8\', \'_WIDE_\');\n"
"http_value (obj, 0, ses);\n"
"http (\'</\', ses); http (pred_tagname, ses); http (\'>\', ses);\n"
"}\n"
"}\n"
"else if (__tag of varbinary = __tag (obj))\n"
"{\n"
"http (\'>\', ses);\n"
"http_value (obj, 0, ses);\n"
"http (\'</\', ses); http (pred_tagname, ses); http (\'>\', ses);\n"
"}\n"
"else if (__tag of XML = __tag (obj))\n"
"{\n"
"http (\' rdf:parseType=\"Literal\">\', ses);\n"
"http_value (obj, 0, ses);\n"
"http (\'</\', ses); http (pred_tagname, ses); http (\'>\', ses);\n"
"}\n"
"else if (__tag of datetime = rdf_box_data_tag (obj))\n"
"{\n"
"http (\' rdf:datatype=\"\', ses);\n"
"http_escape (cast (__xsd_type (obj) as varchar), 12, ses, 1, 1);\n"
"http (\'\">\', ses);\n"
"__rdf_long_to_ttl (obj, ses);\n"
"http (\'</\', ses); http (pred_tagname, ses); http (\'>\', ses);\n"
"}\n"
"else\n"
"{\n"
"http (\' rdf:datatype=\"\', ses);\n"
"http_value (__xsd_type (obj), 0, ses);\n"
"http (\'\">\', ses);\n"
"http_value (__rdf_strsqlval (obj), 0, ses);\n"
"http (\'</\', ses); http (pred_tagname, ses); http (\'>\', ses);\n"
"}\n"
"http (\'</rdf:Description>\', ses);\n"
"}\n"
"if (print_top_level)\n"
"{\n"
"http (\'\\n</rdf:RDF>\', ses);\n"
"}\n"
"}\n"
"--src sparql.sql:3002\n";

static const char *proc120 = 
"create procedure DB.DBA.RDF_TRIPLES_TO_TALIS_JSON (inout triples any, inout ses any)\n"
"{\n"
"declare env any;\n"
"declare tcount, tctr, status integer;\n"
"tcount := length (triples);\n"
"\n"
"if (0 = tcount)\n"
"{\n"
"http (\'{ }\\n\', ses);\n"
"return;\n"
"}\n"
"env := vector (0, 0, 0, null);\n"
"\n"
"rowvector_subj_sort (triples, 1, 1);\n"
"rowvector_subj_sort (triples, 0, 1);\n"
"http (\'{\\n  \', ses);\n"
"status := 0;\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"if (http_talis_json_triple (env, triples[tctr][0], triples[tctr][1], triples[tctr][2], ses))\n"
"status := 1;\n"
"}\n"
"if (status)\n"
"http (\' ] }\\n\', ses);\n"
"http (\'}\\n\', ses);\n"
"}\n"
"--src sparql.sql:3229\n";

static const char *proc121 = 
"create procedure DB.DBA.RDF_TRIPLES_TO_JSON (inout triples any, inout ses any)\n"
"{\n"
"declare tcount, tctr, env integer;\n"
"tcount := length (triples);\n"
"http (\'\\n{ \"head\": { \"link\": [], \"vars\": [ \"s\", \"p\", \"o\" ] },\\n  \"results\": { \"distinct\": false, \"ordered\": true, \"bindings\": [\', ses);\n"
"tcount := length (triples);\n"
"env := vector (0, 0, vector (\'s\', \'p\', \'o\'), null);\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare triple any;\n"
"if (tctr > 0)\n"
"http(\',\', ses);\n"
"triple := aref_set_0 (triples, tctr);\n"
"sparql_rset_json_write_row (ses, env, triple);\n"
"aset_zap_arg (triples, tctr, triple);\n"
"}\n"
"http (\' ] } }\', ses);\n"
"}\n"
"--src sparql.sql:3257\n";

static const char *proc122 = 
"create procedure DB.DBA.RDF_TRIPLES_TO_RDFA_XHTML (inout triples any, inout ses any)\n"
"{\n"
"declare env, prev_subj, nsdict, nslist any;\n"
"declare ctr, len, tcount, tctr, status integer;\n"
"tcount := length (triples);\n"
"\n"
"http (\'<?xml version=\"1.0\" encoding=\"UTF-8\"?>\\n\n"
"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML+RDFa 1.0//EN\" \"http://www.w3.org/MarkUp/DTD/xhtml-rdfa-1.dtd\">\\n\', ses);\n"
"if (0 = tcount)\n"
"{\n"
"http (\'<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
"<head><title>Empty RDFa+XHTML document</title></head><body>\n"
"<p>This document is empty and basically useless. It is generated by a web service that can make some statements in XHTML+RDFa format.\n"
"This time the service made zero such statements, sorry.</p></body></html>\', ses);\n"
"return;\n"
"}\n"
"nsdict := dict_new (10 + cast (sqrt(tcount) as integer));\n"
"dict_put (nsdict, \'http://www.w3.org/1999/02/22-rdf-syntax-ns#\', \'rdf\');\n"
"dict_put (nsdict, \'http://www.w3.org/2001/XMLSchema#\', \'xsdh\');\n"
"for (tctr := 0; (tctr < tcount) and (1000 > dict_size (nsdict)); tctr := tctr + 1)\n"
"{\n"
"sparql_iri_split_rdfa_qname (triples[tctr][0], nsdict, 1);\n"
"sparql_iri_split_rdfa_qname (triples[tctr][1], nsdict, 1);\n"
"sparql_iri_split_rdfa_qname (triples[tctr][2], nsdict, 1);\n"
"}\n"
"http (\'<html xmlns=\"http://www.w3.org/1999/xhtml\"\', ses);\n"
"nslist := dict_to_vector (nsdict, 0);\n"
"len := length (nslist);\n"
"for (ctr := len - 2; ctr >= 0; ctr := ctr-2)\n"
"{\n"
"http (sprintf (\'\\n  xmlns:%s=\"\', nslist[ctr+1]), ses);\n"
"http_escape (nslist[ctr], 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"http (\'>\\n<head><title>RDFa+XHTML document</title></head><body>\\n\', ses);\n"
"http (sprintf (\'<p>This document contains %d facts in XHTML+RDFa format.</p>\',\n"
"tcount), ses);\n"
"http (\'<p>A generic web browser may not display them but the document can be saved on disk and used by some appropriate program or sent to a third party.\n"
"Use \"Save As\" or \"Send To\" menu item of the browser; choose \"HTML\" file type, not \"text file\" or \"web archive\".\n"
"</p><p>The rest of the document may look like garbage for humans or not displayed by the browser.</p>\', ses);\n"
"env := vector (0, 0, 0, null);\n"
"rowvector_subj_sort (triples, 0, 1);\n"
"prev_subj := null;\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare subj, pred, obj, split, obj_iri_split any;\n"
"declare pred_tagname varchar;\n"
"declare res varchar;\n"
"subj := triples[tctr][0];\n"
"pred := triples[tctr][1];\n"
"obj := triples[tctr][2];\n"
"\n"
"\n"
"\n"
"if (prev_subj is null or (subj <> prev_subj))\n"
"{\n"
"if (prev_subj is not null)\n"
"http (\'\\n</div>\', ses);\n"
"http (\'\\n<div about=\"[\', ses);\n"
"split := sparql_iri_split_rdfa_qname (subj, nsdict, 2);\n"
"\n"
"if (\'\' = split[1])\n"
"{\n"
"http_escape (split[2], 3, ses, 1, 1);\n"
"http (\']\">\', ses);\n"
"}\n"
"else if (isstring (split[0]))\n"
"{\n"
"http_escape (concat (split[0], \':\', split[2]), 3, ses, 1, 1);\n"
"http (\']\">\', ses);\n"
"}\n"
"else\n"
"{\n"
"http_escape (concat (\'s:\', split[2]), 3, ses, 1, 1);\n"
"http (\']\" xmlns:s=\"\', ses);\n"
"http_escape (split[1], 3, ses, 1, 1);\n"
"http (\'\">\', ses);\n"
"}\n"
"prev_subj := subj;\n"
"}\n"
"obj_iri_split := sparql_iri_split_rdfa_qname (obj, nsdict, 2);\n"
"http (case (isvector (obj_iri_split)) when 0 then \'\\n<div property=\"\' else \'\\n<div rel=\"\' end, ses);\n"
"split := sparql_iri_split_rdfa_qname (pred, nsdict, 2);\n"
"if (\'\' = split[1])\n"
"{\n"
"http_escape (split[2], 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"else if (isstring (split[0]))\n"
"{\n"
"http_escape (concat (split[0], \':\', split[2]), 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"else\n"
"{\n"
"http_escape (concat (\'p:\', split[2]), 3, ses, 1, 1);\n"
"http (\'\" xmlns:p=\"\', ses);\n"
"http_escape (split[1], 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"if (obj is null)\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_RDFA_XHTML: object is NULL\');\n"
"if (isvector (obj_iri_split))\n"
"{\n"
"http (\' resource=\"\', ses);\n"
"if (isstring (obj_iri_split[0]))\n"
"{\n"
"http (\'[\', ses);\n"
"http_escape (concat (obj_iri_split[0], \':\', obj_iri_split[2]), 3, ses, 1, 1);\n"
"http (\']\" />\', ses);\n"
"}\n"
"else\n"
"{\n"
"http_escape (concat (obj_iri_split[1], \':\', obj_iri_split[2]), 3, ses, 1, 1);\n"
"http (\'\" />\', ses);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"declare sqlval any;\n"
"declare dt, lang, strval any;\n"
"dt := 0; lang := 0;\n"
"if (__tag of rdf_box = __tag (obj))\n"
"{\n"
"if (257 <> rdf_box_type (obj))\n"
"dt := coalesce ((select __bft (RDT_QNAME, 1) from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = rdf_box_type (obj)));\n"
"else if (257 <> rdf_box_lang (obj))\n"
"lang := coalesce ((select lower (RL_ID) from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = rdf_box_lang (obj)));\n"
"sqlval := __rdf_sqlval_of_obj (obj, 1);\n"
"if (__tag of datetime = __tag (sqlval))\n"
"{\n"
"if (257 = rdf_box_type (obj))\n"
"dt := __xsd_type (sqlval);\n"
"}\n"
"}\n"
"else if (__tag (obj) not in (__tag of varchar, __tag of varbinary))\n"
"{\n"
"sqlval := obj;\n"
"dt := __xsd_type (sqlval);\n"
"}\n"
"else\n"
"sqlval := obj;\n"
"if (not (isinteger (dt)))\n"
"{\n"
"http (\' datatype=\"\', ses);\n"
"split := sparql_iri_split_rdfa_qname (dt, nsdict, 2);\n"
"if (\'\' = split[1])\n"
"{\n"
"http_escape (split[2], 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"else if (isstring (split[0]))\n"
"{\n"
"http_escape (concat (split[0], \':\', split[2]), 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"else\n"
"{\n"
"http_escape (concat (\'dt:\', split[2]), 3, ses, 1, 1);\n"
"http (\'\" xmlns:dt=\"\', ses);\n"
"http_escape (split[1], 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"}\n"
"if (isstring (lang))\n"
"{\n"
"http (\' xml:lang=\"\', ses);\n"
"http_escape (lang, 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"http (\'>\', ses);\n"
"if (__tag of datetime = __tag(sqlval))\n"
"__rdf_long_to_ttl (sqlval, ses);\n"
"else if (__tag (sqlval) in (__tag of varbinary, __tag of XML))\n"
"http_value (sqlval, 0, ses);\n"
"else if (__tag of varchar = __tag (sqlval))\n"
"http_value (charset_recode (sqlval, \'UTF-8\', \'_WIDE_\'), 0, ses);\n"
"else\n"
"{\n"
"sqlval := __rdf_strsqlval (obj);\n"
"if (__tag of varchar = __tag (sqlval))\n"
"sqlval := charset_recode (sqlval, \'UTF-8\', \'_WIDE_\');\n"
"http_value (sqlval, 0, ses);\n"
"}\n"
"http (\'</div>\', ses);\n"
"}\n"
"}\n"
"if (prev_subj is not null)\n"
"http (\'\\n</div>\', ses);\n"
"http (\'\\n</body></html>\\n\', ses);\n"
"}\n"
"--src sparql.sql:3277\n";

static const char *proc123 = 
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_INIT (inout _env any)\n"
"{\n"
"_env := string_output();\n"
"http (\'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"@prefix rs: <http://www.w3.org/2005/sparql-results#> .\n"
"@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n"
"[ rdf:type rs:results ;\', _env);\n"
"}\n"
"--src sparql.sql:3475\n";

static const char *proc124 = 
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_ACC (inout _env any, inout colvalues any, inout colnames any)\n"
"{\n"
"declare col_ctr, col_count integer;\n"
"declare blank_ids any;\n"
"if (185 <> __tag(_env))\n"
"DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_INIT (_env);\n"
"http (\'\\n  rs:result [\', _env);\n"
"col_count := length (colnames);\n"
"for (col_ctr := 0; col_ctr < col_count; col_ctr := col_ctr + 1)\n"
"{\n"
"declare _name varchar;\n"
"declare _val any;\n"
"_name := colnames[col_ctr];\n"
"_val := colvalues[col_ctr];\n"
"if (_val is null)\n"
"goto end_of_binding;\n"
"http (\'\\n      rs:binding [ rs:name \"\', _env);\n"
"http_value (colnames[col_ctr], 0, _env);\n"
"http (\'\" ; rs:value \', _env);\n"
"if (isiri_id (_val))\n"
"{\n"
"if (_val >= min_bnode_iri_id ())\n"
"{\n"
"http (sprintf (\'_:nodeID%d ] ;\', iri_id_num (_val)), _env);\n"
"}\n"
"else\n"
"{\n"
"declare res varchar;\n"
"res := id_to_iri (_val);\n"
"\n"
"if (res is null)\n"
"res := sprintf (\'<bad://%d>\', iri_id_num (_val));\n"
"http (sprintf (\'<%V> ] ;\', res), _env);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.RDF_LONG_TO_TTL (_val, _env);\n"
"http (sprintf (\' ] ;\'), _env);\n"
"}\n"
"end_of_binding: ;\n"
"\n"
"}\n"
"http (\'\\n      ] ;\', _env);\n"
"}\n"
"--src sparql.sql:3485\n";

static const char *proc125 = 
"create function DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_FIN (inout _env any) returns long varchar\n"
"{\n"
"if (185 <> __tag(_env))\n"
"DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_INIT (_env);\n"
"\n"
"http (\'\\n    ] .\', _env);\n"
"return string_output_string (_env);\n"
"}\n"
"--src sparql.sql:3532\n";

static const char *other16 = 
"create aggregate DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL (in colvalues any, in colnames any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_INIT, DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_ACC, DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_FIN\n";

static const char *proc126 = 
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_INIT (inout _env any)\n"
"{\n"
"_env := string_output();\n"
"http (\'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"@prefix rs: <http://www.w3.org/2005/sparql-results#> .\n"
"@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n"
"_:_ <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2005/sparql-results#results> .\\n\', _env);\n"
"}\n"
"--src sparql.sql:3547\n";

static const char *proc127 = 
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_ACC (inout _env any, inout colvalues any, inout colnames any)\n"
"{\n"
"declare col_ctr, col_count integer;\n"
"declare rowid varchar;\n"
"declare blank_ids any;\n"
"if (__tag of vector <> __tag(_env))\n"
"{\n"
"declare col_buf any;\n"
"col_count := length (colnames);\n"
"if (185 <> __tag(_env))\n"
"DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_INIT (_env);\n"
"col_buf := make_array (col_count * 7, \'any\');\n"
"for (col_ctr := 0; col_ctr < col_count; col_ctr := col_ctr + 1)\n"
"col_buf [col_ctr * 7] := colnames[col_ctr];\n"
"_env := vector (0, col_buf, _env);\n"
"}\n"
"sparql_rset_nt_write_row (0, _env, colvalues);\n"
"}\n"
"--src sparql.sql:3557\n";

static const char *proc128 = 
"create function DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_FIN (inout _env any) returns long varchar\n"
"{\n"
"if (185 <> __tag(_env))\n"
"DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_INIT (_env);\n"
"return string_output_string (_env);\n"
"}\n"
"--src sparql.sql:3577\n";

static const char *other17 = 
"create aggregate DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT (in colvalues any, in colnames any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_INIT, DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_ACC, DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_FIN\n";

static const char *proc129 = 
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_INIT (inout _env any)\n"
"{\n"
"_env := string_output();\n"
"http (\'<rdf:RDF\n"
"xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n"
"xmlns:rs=\"http://www.w3.org/2005/sparql-results#\"\n"
"xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\" >\n"
"<rs:results rdf:nodeID=\"rset\">\', _env);\n"
"}\n"
"--src sparql.sql:3589\n";

static const char *proc130 = 
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_ACC (inout _env any, inout colvalues any, inout colnames any)\n"
"{\n"
"declare sol_id varchar;\n"
"declare col_ctr, col_count integer;\n"
"declare blank_ids any;\n"
"if (185 <> __tag(_env))\n"
"DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_INIT (_env);\n"
"sol_id := cast (length (_env) as varchar);\n"
"http (\'\\n  <rs:result rdf:nodeID=\"sol\' || sol_id || \'\">\', _env);\n"
"col_count := length (colnames);\n"
"for (col_ctr := 0; col_ctr < col_count; col_ctr := col_ctr + 1)\n"
"{\n"
"declare _name varchar;\n"
"declare _val any;\n"
"_name := colnames[col_ctr];\n"
"_val := colvalues[col_ctr];\n"
"if (_val is null)\n"
"goto end_of_binding;\n"
"http (\'\\n   <rs:binding rdf:nodeID=\"sol\' || sol_id || \'-\' || cast (col_ctr as varchar) || \'\" rs:name=\"\', _env);\n"
"http_value (colnames[col_ctr], 0, _env);\n"
"http (\'\"><rs:value\', _env);\n"
"if (isiri_id (_val))\n"
"{\n"
"if (_val >= min_bnode_iri_id ())\n"
"{\n"
"http (sprintf (\' rdf:nodeID=\"b%d\"/></rs:binding>\', iri_id_num (_val)), _env);\n"
"}\n"
"else\n"
"{\n"
"declare res varchar;\n"
"res := id_to_iri (_val);\n"
"\n"
"if (res is null)\n"
"res := sprintf (\'bad://%d\', iri_id_num (_val));\n"
"http (sprintf (\' rdf:resource=\"%V\"/></rs:binding>\', res), _env);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"declare lang, dt varchar;\n"
"lang := DB.DBA.RDF_LANGUAGE_OF_LONG (_val, null);\n"
"dt := DB.DBA.RDF_DATATYPE_IRI_OF_LONG (_val, null);\n"
"if (lang is not null)\n"
"{\n"
"if (dt is not null)\n"
"http (sprintf (\' xml:lang=\"%V\" rdf:datatype=\"%V\">\',\n"
"cast (lang as varchar), cast (dt as varchar)), _env);\n"
"else\n"
"http (sprintf (\' xml:lang=\"%V\">\',\n"
"cast (lang as varchar)), _env);\n"
"}\n"
"else\n"
"{\n"
"if (dt is not null)\n"
"http (sprintf (\' rdf:datatype=\"%V\">\',\n"
"cast (dt as varchar)), _env);\n"
"else\n"
"http (sprintf (\'>\'), _env);\n"
"}\n"
"http_value (__rdf_strsqlval (_val), 0, _env);\n"
"http (\'</rs:value></rs:binding>\', _env);\n"
"}\n"
"end_of_binding: ;\n"
"\n"
"}\n"
"http (\'\\n  </rs:result>\', _env);\n"
"}\n"
"--src sparql.sql:3600\n";

static const char *proc131 = 
"create function DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_FIN (inout _env any) returns long varchar\n"
"{\n"
"if (185 <> __tag(_env))\n"
"DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_INIT (_env);\n"
"\n"
"http (\'\\n </rs:results>\\n</rdf:RDF>\', _env);\n"
"return string_output_string (_env);\n"
"}\n"
"--src sparql.sql:3669\n";

static const char *other18 = 
"create aggregate DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML (in colvalues any, in colnames any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_INIT, DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_ACC, DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_FIN\n";

static const char *proc132 = 
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_INIT (inout _env any)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src sparql.sql:3683\n";

static const char *proc133 = 
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_ACC (inout _env any, inout colvalues any, inout colnames any)\n"
"{\n"
"declare sol_id varchar;\n"
"declare col_ctr, col_count, need_comma integer;\n"
"declare blank_ids any;\n"
"col_count := length (colnames);\n"
"if (185 <> __tag(_env))\n"
"{\n"
"_env := string_output ();\n"
"http (\'\\n{ \"head\": { \"link\": [], \"vars\": [\', _env);\n"
"for (col_ctr := 0; col_ctr < col_count; col_ctr := col_ctr + 1)\n"
"{\n"
"if (col_ctr > 0)\n"
"http(\', \"\', _env);\n"
"else\n"
"http(\'\"\', _env);\n"
"http_escape (colnames[col_ctr], 11, _env, 0, 1);\n"
"http(\'\"\', _env);\n"
"}\n"
"http (\'] },\\n  \"results\": { \"distinct\": false, \"ordered\": true, \"bindings\": [\\n    {\', _env);\n"
"}\n"
"else\n"
"http(\',\\n    {\', _env);\n"
"need_comma := 0;\n"
"for (col_ctr := 0; col_ctr < col_count; col_ctr := col_ctr + 1)\n"
"{\n"
"declare val any;\n"
"val := colvalues[col_ctr];\n"
"if (val is null)\n"
"goto end_of_val_print;\n"
"if (need_comma)\n"
"http(\'\\t,\', _env);\n"
"else\n"
"need_comma := 1;\n"
"DB.DBA.SPARQL_RESULTS_JSON_WRITE_BINDING (_env, colnames[col_ctr], val);\n"
"end_of_val_print: ;\n"
"}\n"
"http(\'}\', _env);\n"
"}\n"
"--src sparql.sql:3689\n";

static const char *proc134 = 
"create function DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_FIN (inout _env any) returns long varchar\n"
"{\n"
"if (185 <> __tag(_env))\n"
"{\n"
"_env := string_output ();\n"
"http (\'\\n{ \"head\": { \"link\": [], \"vars\": [] },\\n  \"results\": { \"distinct\": false, \"ordered\": true, \"bindings\": [\', _env);\n"
"}\n"
"http (\' ] } }\', _env);\n"
"return string_output_string (_env);\n"
"}\n"
"--src sparql.sql:3730\n";

static const char *other19 = 
"create aggregate DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON (in colvalues any, in colnames any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_INIT, DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_ACC, DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_FIN\n";

static const char *proc135 = 
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TTL (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_TTL (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:3746\n";

static const char *proc136 = 
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_NT (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_NT (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:3761\n";

static const char *proc137 = 
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_RDF_XML (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_RDF_XML_TEXT (triples, 1, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:3776\n";

static const char *proc138 = 
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TALIS_JSON (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_TALIS_JSON (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:3791\n";

static const char *proc139 = 
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_RDFA_XHTML (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_RDFA_XHTML (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:3806\n";

static const char *proc140 = 
" create procedure DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_INIT (inout _env any)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src sparql.sql:3822\n";

static const char *proc141 = 
" create procedure DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_ACC (inout _env any, inout one any)\n"
"{\n"
"_env := 1;\n"
"}\n"
"--src sparql.sql:3829\n";

static const char *proc142 = 
" create function DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_FIN (inout _env any) returns long varchar\n"
"{\n"
"declare ses any;\n"
"declare ans varchar;\n"
"ses := string_output ();\n"
"if (isinteger (_env) and _env)\n"
"ans := \'true\';\n"
"else\n"
"ans := \'false\';\n"
"http (\'<sparql xmlns=\"http://www.w3.org/2005/sparql-results#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2.xsd\">\n"
"<head></head>\n"
"<boolean>\' || ans || \'</boolean>\n"
"</sparql>\', ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:3836\n";

static const char *other20 = 
"create aggregate DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML (inout one any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_INIT, DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_ACC, DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_FIN\n";

static const char *proc143 = 
" create procedure DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_INIT (inout _env any)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src sparql.sql:3858\n";

static const char *proc144 = 
" create procedure DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_ACC (inout _env any, inout one any)\n"
"{\n"
"_env := 1;\n"
"}\n"
"--src sparql.sql:3865\n";

static const char *proc145 = 
" create function DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_FIN (inout _env any) returns long varchar\n"
"{\n"
"declare ses any;\n"
"declare ans varchar;\n"
"ses := string_output ();\n"
"if (isinteger (_env) and _env)\n"
"ans := \'1\';\n"
"else\n"
"ans := \'0\';\n"
"http (\'<rdf:RDF\n"
"xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n"
"xmlns:rs=\"http://www.w3.org/2005/sparql-results#\"\n"
"xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\" >\n"
"<rs:results rdf:nodeID=\"rset\">\n"
"<rs:boolean rdf:datatype=\"http://www.w3.org/2001/XMLSchema#boolean\">\' || ans || \'</rs:boolean></results></rdf:RDF>\', ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:3872\n";

static const char *other21 = 
"create aggregate DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML (inout one any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_INIT, DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_ACC, DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_FIN\n";

static const char *proc146 = 
" create procedure DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_INIT (inout _env any)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src sparql.sql:3896\n";

static const char *proc147 = 
" create procedure DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_ACC (inout _env any, inout one any)\n"
"{\n"
"_env := 1;\n"
"}\n"
"--src sparql.sql:3903\n";

static const char *proc148 = 
" create function DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_FIN (inout _env any) returns long varchar\n"
"{\n"
"declare ses any;\n"
"declare ans varchar;\n"
"ses := string_output ();\n"
"if (isinteger (_env) and _env)\n"
"ans := \'TRUE\';\n"
"else\n"
"ans := \'FALSE\';\n"
"http (\'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"@prefix rs: <http://www.w3.org/2005/sparql-results#> .\\n\', ses);\n"
"http (sprintf (\'[] rdf:type rs:results ; rs:boolean %s .\', ans), ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:3910\n";

static const char *other22 = 
"create aggregate DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL (inout one any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_INIT, DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_ACC, DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_FIN\n";

static const char *proc149 = 
" create function DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_NT_FIN (inout _env any) returns long varchar\n"
"{\n"
"declare ses any;\n"
"declare ans varchar;\n"
"ses := string_output ();\n"
"if (isinteger (_env) and _env)\n"
"ans := \'true\';\n"
"else\n"
"ans := \'false\';\n"
"http (sprintf (\'_:_ <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2005/sparql-results#results> .\\n_:_ <http://www.w3.org/2005/sparql-results#boolean> \"%s\"^^<http://www.w3.org/2001/XMLSchema#boolean> .\\n\', ans), ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:3931\n";

static const char *other23 = 
"create aggregate DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_NT (inout one any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_NT_INIT, DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_NT_ACC, DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_NT_FIN\n";

static const char *proc150 = 
"create procedure DB.DBA.RDF_INSERT_TRIPLES_CL (inout graph_iri any, inout triples any, in log_mode integer := null)\n"
"{\n"
"declare is_text, ctr, old_log_enable, l integer;\n"
"declare ro_id_dict, dp any;\n"
"if (\'1\' = registry_get (\'cl_rdf_text_index\'))\n"
"is_text := 1;\n"
"if (not isiri_id (graph_iri))\n"
"graph_iri := iri_to_id (graph_iri);\n"
"connection_set (\'g_iid\', graph_iri);\n"
"ro_id_dict := dict_new ();\n"
"connection_set (\'g_dict\', ro_id_dict);\n"
"dp := dpipe (0, \'IRI_TO_ID_1\', \'IRI_TO_ID_1\', \'IRI_TO_ID_1\', \'MAKE_RO_1\', \'IRI_TO_ID_1\');\n"
"dpipe_set_rdf_load (dp);\n"
"l := length (triples);\n"
"for (ctr := 0; ctr < l; ctr := ctr + 1)\n"
"{\n"
"declare r, o_val any;\n"
"r := triples[ctr];\n"
"o_val := r[2];\n"
"if (__tag (o_val) in (__tag of varchar, __tag of XML))\n"
"{\n"
"if (is_text)\n"
"{\n"
"\n"
"declare o_val_2 any;\n"
"o_val_2 := rdf_box (o_val, 300, 257, 0, 1);\n"
"rdf_box_set_is_text (o_val_2, 1);\n"
"rdf_box_set_type (o_val_2, 257);\n"
"\n"
"dpipe_input (dp, r[0], r[1], null, o_val_2, null);\n"
"}\n"
"else\n"
"{\n"
"\n"
"dpipe_input (dp, r[0], r[1], null, o_val, null);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"\n"
"dpipe_input (dp, r[0], r[1], null, o_val, null);\n"
"}\n"
"if (mod (ctr + 1, 40000) = 0 and l > 60000)\n"
"{\n"
"dpipe_next (dp, 0);\n"
"dpipe_next (dp, 1);\n"
"dpipe_reuse (dp);\n"
"}\n"
"}\n"
"dpipe_next (dp, 0);\n"
"dpipe_next (dp, 1);\n"
"if (ro_id_dict is not null)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (graph_iri, ro_id_dict);\n"
"}\n"
"--src sparql.sql:3953\n";

static const char *proc151 = 
"create procedure DB.DBA.RDF_INSERT_TRIPLES (in graph_iri any, inout triples any, in log_mode integer := null)\n"
"{\n"
"declare ctr, old_log_enable integer;\n"
"declare ro_id_dict any;\n"
"if (0 = sys_stat (\'cl_run_local_only\'))\n"
"return RDF_INSERT_TRIPLES_CL (graph_iri, triples, log_mode);\n"
"if (not isiri_id (graph_iri))\n"
"graph_iri := iri_to_id (graph_iri);\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"ro_id_dict := null;\n"
"for (ctr := length (triples) - 1; ctr >= 0; ctr := ctr - 1)\n"
"{\n"
"declare p_iid, o_orig, o_final any;\n"
"declare need_digest integer;\n"
"p_iid := triples[ctr][1];\n"
"o_final := o_orig := triples[ctr][2];\n"
"if (isiri_id (o_final))\n"
"goto do_insert;\n"
"if (ro_id_dict is null and __rdf_obj_ft_rule_check (graph_iri, p_iid))\n"
"ro_id_dict := dict_new ();\n"
"need_digest := rdf_box_needs_digest (o_final, ro_id_dict);\n"
"if (1 < need_digest)\n"
"{\n"
"o_final := DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT (o_final, graph_iri, p_iid, ro_id_dict);\n"
"if (not rdf_box_is_storeable (o_final))\n"
"{\n"
"\n"
"signal (\'OBLOM\', \'Bad O after MAKE_OBJ_OF_SQLVAL_FT\');\n"
"}\n"
"}\n"
"else\n"
"{\n"
"o_final := DB.DBA.RDF_OBJ_ADD (257, o_final, 257);\n"
"if (not rdf_box_is_storeable (o_final))\n"
"{\n"
"\n"
"signal (\'OBLOM\', \'Bad O after MAKE_OBJ_OF_SQLVAL_FT\');\n"
"}\n"
"}\n"
"do_insert:\n"
"\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (graph_iri, triples[ctr][0], p_iid, o_final);\n"
"}\n"
"if (ro_id_dict is not null)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (graph_iri, ro_id_dict);\n"
"log_enable (old_log_enable, 1);\n"
"}\n"
"--src sparql.sql:4009\n";

static const char *proc152 = 
"create procedure DB.DBA.RDF_DELETE_TRIPLES (in graph_iri any, in triples any, in log_mode integer := null)\n"
"{\n"
"declare ctr, old_log_enable integer;\n"
"if (not isiri_id (graph_iri))\n"
"graph_iri := iri_to_id (graph_iri);\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"for (ctr := length (triples) - 1; ctr >= 0; ctr := ctr - 1)\n"
"{\n"
"declare o_short any;\n"
"o_short := DB.DBA.RDF_OBJ_OF_LONG (triples[ctr][2]);\n"
"\n"
"\n"
"delete from DB.DBA.RDF_QUAD\n"
"where G = graph_iri and S = triples[ctr][0] and P = triples[ctr][1] and O = o_short;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"log_enable (old_log_enable, 1);\n"
"}\n"
"--src sparql.sql:4060\n";

static const char *proc153 = 
"create procedure DB.DBA.RDF_DELETE_TRIPLES_AGG (in graph_iri any, inout triples any, in log_mode integer := null)\n"
"{\n"
"declare ctr, old_log_enable, l integer;\n"
"if (not isiri_id (graph_iri))\n"
"graph_iri := iri_to_id (graph_iri);\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"if (0 = sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"declare dp any;\n"
"log_enable (bit_and (coalesce (log_mode, old_log_enable), 1), 1);\n"
"dp := dpipe (0, \'__I2IDN\', \'__I2IDN\', \'O_LOOKN\');\n"
"dpipe_set_rdf_load (dp, 3);\n"
"connection_set (\'g_iid\', graph_iri);\n"
"l := length (triples);\n"
"for (ctr := 0; ctr < l; ctr := ctr + 1)\n"
"{\n"
"declare r any;\n"
"r := triples[ctr];\n"
"dpipe_input (dp, r[0], r[1], r[2]);\n"
"if (mod (ctr + 1, 40000) = 0 and l > 60000)\n"
"{\n"
"dpipe_next (dp, 0);\n"
"dpipe_next (dp, 1);\n"
"dpipe_reuse (dp);\n"
"if (bit_and (coalesce (log_mode, old_log_enable), 2))\n"
"commit work;\n"
"}\n"
"}\n"
"dpipe_next (dp, 0);\n"
"dpipe_next (dp, 1);\n"
"if (bit_and (coalesce (log_mode, old_log_enable), 2))\n"
"commit work;\n"
"}\n"
"else\n"
"{\n"
"for (ctr := length (triples) - 1; ctr >= 0; ctr := ctr - 1)\n"
"{\n"
"declare o_short any;\n"
"o_short := DB.DBA.RDF_OBJ_OF_LONG (triples[ctr][2]);\n"
"delete from DB.DBA.RDF_QUAD\n"
"where G = graph_iri and S = triples[ctr][0] and P = triples[ctr][1] and O = o_short;\n"
"}\n"
"log_enable (old_log_enable, 1);\n"
"}\n"
"}\n"
"--src sparql.sql:4090\n";

static const char *proc154 = 
"create procedure DB.DBA.RDF_MODIFY_TRIPLES (in graph_iri any, in del_triples any, in ins_triples any, in log_mode integer := null)\n"
"{\n"
"DB.DBA.RDF_DELETE_TRIPLES (graph_iri, del_triples, log_mode);\n"
"DB.DBA.RDF_INSERT_TRIPLES (graph_iri, ins_triples, log_mode);\n"
"}\n"
"--src sparql.sql:4151\n";

static const char *proc155 = 
" create procedure DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_INIT (inout _env any)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src sparql.sql:4159\n";

static const char *proc156 = 
" create procedure DB.DBA.SPARQL_INS_OR_DEL_CTOR_IMPL (inout _env any, in graph_iri any, in opcodes any, in vars any, in log_mode integer, in ctor_op integer)\n"
"{\n"
"declare triple_ctr integer;\n"
"declare blank_ids any;\n"
"declare action_ctr integer;\n"
"declare old_log_enable integer;\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"blank_ids := 0;\n"
"action_ctr := 0;\n"
"for (triple_ctr := length (opcodes) - 1; triple_ctr >= 0; triple_ctr := triple_ctr-1)\n"
"{\n"
"declare fld_ctr integer;\n"
"declare triple_vec any;\n"
"triple_vec := vector (0,0,0);\n"
"for (fld_ctr := 2; fld_ctr >= 0; fld_ctr := fld_ctr - 1)\n"
"{\n"
"declare op integer;\n"
"declare arg any;\n"
"op := opcodes[triple_ctr][fld_ctr * 2];\n"
"arg := opcodes[triple_ctr][fld_ctr * 2 + 1];\n"
"if (1 = op)\n"
"{\n"
"declare i any;\n"
"i := vars[arg];\n"
"if (i is null)\n"
"goto end_of_adding_triple;\n"
"if ((2 > fld_ctr) and not isiri_id (i))\n"
"signal (\'RDF01\',\n"
"sprintf (\'Bad variable value in INSERT: \"%.100s\" is not a valid %s, only object of a triple can be a literal\',\n"
"__rdf_strsqlval (i),\n"
"case (fld_ctr) when 1 then \'predicate\' else \'subject\' end ) );\n"
"if ((1 = fld_ctr) and isiri_id (i) and (i >= min_bnode_iri_id ()))\n"
"signal (\'RDF01\', \'Bad variable value in INSERT: blank node can not be used as predicate\');\n"
"triple_vec[fld_ctr] := i;\n"
"}\n"
"else if (2 = op)\n"
"{\n"
"if (isinteger (blank_ids))\n"
"blank_ids := vector (iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\')));\n"
"while (arg >= length (blank_ids))\n"
"blank_ids := vector_concat (blank_ids, vector (iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\'))));\n"
"if (1 = fld_ctr)\n"
"signal (\'RDF01\', \'Bad triple for INSERT: blank node can not be used as predicate\');\n"
"triple_vec[fld_ctr] := blank_ids[arg];\n"
"}\n"
"else if (3 = op)\n"
"{\n"
"if (arg is null)\n"
"goto end_of_adding_triple;\n"
"if ((2 > fld_ctr) and not isiri_id (arg))\n"
"signal (\'RDF01\', sprintf (\'Bad const value in INSERT: \"%.100s\" is not a valid %s, only object of a triple can be a literal\',\n"
"__rdf_strsqlval (arg),\n"
"case (fld_ctr) when 1 then \'predicate\' else \'subject\' end ) );\n"
"if ((1 = fld_ctr) and isiri_id (arg) and (arg >= min_bnode_iri_id ()))\n"
"signal (\'RDF01\', \'Bad const value in CONSTRUCT: blank node can not be used as predicate\');\n"
"triple_vec[fld_ctr] := arg;\n"
"}\n"
"else signal (\'RDFXX\', \'Bad opcode in DB.DBA.SPARQL_INSERT_CTOR()\');\n"
"}\n"
"\n"
"if (1 = ctor_op)\n"
"{\n"
"\n"
"\n"
"declare dict any;\n"
"dict := _env[3];\n"
"dict_put (dict, triple_vec, 1);\n"
"if (80000 < dict_size (dict))\n"
"DB.DBA.RDF_DELETE_TRIPLES_AGG (_env[0], dict_list_keys (dict, 2), _env[5]);\n"
"}\n"
"else\n"
"{\n"
"\n"
"\n"
"declare dict any;\n"
"dict := _env[4];\n"
"dict_put (dict, triple_vec, 1);\n"
"if (80000 < dict_size (dict))\n"
"DB.DBA.RDF_INSERT_TRIPLES (_env[0], dict_list_keys (dict, 2), _env[5]);\n"
"}\n"
"action_ctr := action_ctr + 1;\n"
"end_of_adding_triple: ;\n"
"}\n"
"_env[ctor_op] := _env[ctor_op] + action_ctr;\n"
"log_enable (old_log_enable, 1);\n"
"}\n"
"--src sparql.sql:4166\n";

static const char *proc157 = 
" create function DB.DBA.SPARQL_DELETE_CTOR_ACC (inout _env any, in graph_iri any, in opcodes any, in vars any, in uid integer, in log_mode integer)\n"
"{\n"
"if (not (isarray (_env)))\n"
"_env := vector (iri_to_id (graph_iri), 0, 0, dict_new (80000), null, log_mode);\n"
"if (not _env[1])\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL DELETE\');\n"
"DB.DBA.SPARQL_INS_OR_DEL_CTOR_IMPL (_env, graph_iri, opcodes, vars, log_mode, 1);\n"
"}\n"
"--src sparql.sql:4256\n";

static const char *proc158 = 
" create procedure DB.DBA.SPARQL_INSERT_CTOR_ACC (inout _env any, in graph_iri any, in opcodes any, in vars any, in uid integer, in log_mode integer)\n"
"{\n"
"\n"
"if (not (isarray (_env)))\n"
"_env := vector (iri_to_id (graph_iri), 0, 0, null, dict_new (80000), log_mode);\n"
"if (not _env[2])\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL INSERT\');\n"
"DB.DBA.SPARQL_INS_OR_DEL_CTOR_IMPL (_env, graph_iri, opcodes, vars, log_mode, 2);\n"
"}\n"
"--src sparql.sql:4267\n";

static const char *proc159 = 
" create procedure DB.DBA.SPARQL_MODIFY_CTOR_ACC (inout _env any, in graph_iri any, in del_opcodes any, in ins_opcodes any, in vars any, in uid integer, in log_mode integer)\n"
"{\n"
"if (not (isarray (_env)))\n"
"_env := vector (iri_to_id (graph_iri), 0, 0, dict_new (80000), dict_new (80000), log_mode);\n"
"if (not _env[1] and not _env[2])\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL MODIFY\');\n"
"DB.DBA.SPARQL_INS_OR_DEL_CTOR_IMPL (_env, graph_iri, del_opcodes, vars, log_mode, 1);\n"
"DB.DBA.SPARQL_INS_OR_DEL_CTOR_IMPL (_env, graph_iri, ins_opcodes, vars, log_mode, 2);\n"
"}\n"
"--src sparql.sql:4279\n";

static const char *proc160 = 
" create procedure DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_FIN (inout _env any)\n"
"{\n"
"if (isarray (_env))\n"
"{\n"
"declare dict any;\n"
"dict := _env[3];\n"
"if (dict is not null and (0 < dict_size (dict)))\n"
"{\n"
"_env[3] := null;\n"
"DB.DBA.RDF_DELETE_TRIPLES (_env[0], dict_list_keys (dict, 2), _env[5]);\n"
"}\n"
"dict := _env[4];\n"
"if (dict is not null and (0 < dict_size (dict)))\n"
"{\n"
"_env[4] := null;\n"
"DB.DBA.RDF_INSERT_TRIPLES (_env[0], dict_list_keys (dict, 2), _env[5]);\n"
"}\n"
"}\n"
"return _env;\n"
"}\n"
"--src sparql.sql:4291\n";

static const char *other24 = 
" create aggregate DB.DBA.SPARQL_DELETE_CTOR (in graph_iri any, in opcodes any, in vars any, in uid integer, in log_mode integer) returns any\n"
"from DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_INIT, DB.DBA.SPARQL_DELETE_CTOR_ACC, DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_FIN\n";

static const char *other25 = 
" create aggregate DB.DBA.SPARQL_INSERT_CTOR (in graph_iri any, in opcodes any, in vars any, in uid integer, in log_mode integer) returns any\n"
"from DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_INIT, DB.DBA.SPARQL_INSERT_CTOR_ACC, DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_FIN\n";

static const char *other26 = 
" create aggregate DB.DBA.SPARQL_MODIFY_CTOR (in graph_iri any, in del_opcodes any, in ins_opcodes any, in vars any, in uid integer, in log_mode integer) returns any\n"
"from DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_INIT, DB.DBA.SPARQL_MODIFY_CTOR_ACC, DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_FIN\n";

static const char *proc161 = 
"create function DB.DBA.SPARQL_INSERT_DICT_CONTENT (in graph_iri any, in triples_dict any, in uid integer, in log_mode integer := null, in compose_report integer := 0) returns any\n"
"{\n"
"declare triples any;\n"
"declare ins_count integer;\n"
"ins_count := 0;\n"
"if (__tag of vector = __tag (graph_iri))\n"
"{\n"
"ins_count := graph_iri[2];\n"
"graph_iri := graph_iri[0];\n"
"}\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL INSERT\');\n"
"while (dict_size (triples_dict) > 0)\n"
"{\n"
"triples := dict_destructive_list_rnd_keys (triples_dict, 80000);\n"
"DB.DBA.RDF_INSERT_TRIPLES (graph_iri, triples, log_mode);\n"
"ins_count := ins_count + length (triples);\n"
"}\n"
"if (isiri_id (graph_iri))\n"
"graph_iri := id_to_iri (graph_iri);\n"
"if (compose_report)\n"
"return sprintf (\'Insert into <%s>, %d triples -- done\', graph_iri, ins_count);\n"
"else\n"
"return ins_count;\n"
"}\n"
"--src sparql.sql:4328\n";

static const char *proc162 = 
"create function DB.DBA.SPARQL_DELETE_DICT_CONTENT (in graph_iri any, in triples_dict any, in uid integer, in log_mode integer := null, in compose_report integer := 0) returns any\n"
"{\n"
"declare triples any;\n"
"declare del_count integer;\n"
"del_count := 0;\n"
"if (__tag of vector = __tag (graph_iri))\n"
"{\n"
"del_count := graph_iri[1];\n"
"graph_iri := graph_iri[0];\n"
"}\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL DELETE\');\n"
"while (dict_size (triples_dict) > 0)\n"
"{\n"
"triples := dict_destructive_list_rnd_keys (triples_dict, 2000000);\n"
"DB.DBA.RDF_DELETE_TRIPLES_AGG (graph_iri, triples, log_mode);\n"
"del_count := del_count + length (triples);\n"
"}\n"
"if (isiri_id (graph_iri))\n"
"graph_iri := id_to_iri (graph_iri);\n"
"if (compose_report)\n"
"return sprintf (\'Delete from <%s>, %d triples -- done\', graph_iri, del_count);\n"
"else\n"
"return del_count;\n"
"}\n"
"--src sparql.sql:4354\n";

static const char *proc163 = 
"create function DB.DBA.SPARQL_MODIFY_BY_DICT_CONTENTS (in graph_iri any, in del_triples_dict any, in ins_triples_dict any, in uid integer, in log_mode integer := null, in compose_report integer := 0) returns any\n"
"{\n"
"declare del_count, ins_count integer;\n"
"del_count := 0;\n"
"ins_count := 0;\n"
"if (__tag of vector = __tag (graph_iri))\n"
"{\n"
"del_count := graph_iri[1];\n"
"ins_count := graph_iri[2];\n"
"graph_iri := graph_iri[0];\n"
"}\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL MODIFY\');\n"
"if (del_triples_dict is not null)\n"
"{\n"
"del_count := del_count + dict_size (del_triples_dict);\n"
"DB.DBA.SPARQL_DELETE_DICT_CONTENT (graph_iri, del_triples_dict, uid, log_mode);\n"
"}\n"
"if (ins_triples_dict is not null)\n"
"{\n"
"ins_count := ins_count + dict_size (ins_triples_dict);\n"
"DB.DBA.SPARQL_INSERT_DICT_CONTENT (graph_iri, ins_triples_dict, uid, log_mode);\n"
"}\n"
"if (isiri_id (graph_iri))\n"
"graph_iri := id_to_iri (graph_iri);\n"
"if (compose_report)\n"
"return sprintf (\'Modify <%s>, delete %d and insert %d triples -- done\', graph_iri, del_count, ins_count);\n"
"else\n"
"return del_count + ins_count;\n"
"}\n"
"--src sparql.sql:4380\n";

static const char *proc164 = 
"create function DB.DBA.SPARUL_CLEAR (in graph_iri any, in inside_sponge integer, in uid integer := 0, in log_mode integer := null, in compose_report integer := 0) returns any\n"
"{\n"
"declare g any;\n"
"declare old_log_enable integer;\n"
"g := graph_iri;\n"
"if (isiri_id (g))\n"
"g := id_to_iri (g);\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL CLEAR GRAPH\');\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"exec (sprintf (\'\n"
"delete from DB.DBA.RDF_QUAD\n"
"where G = __i2id (\'\'%S\'\') \', g));\n"
"delete from DB.DBA.RDF_OBJ_RO_FLAGS_WORDS\n"
"where VT_WORD = rdf_graph_keyword (iri_to_id (graph_iri));\n"
"if (isiri_id (graph_iri))\n"
"graph_iri := id_to_iri (graph_iri);\n"
"if (not inside_sponge)\n"
"{\n"
"delete from DB.DBA.SYS_HTTP_SPONGE where HS_LOCAL_IRI = graph_iri;\n"
"delete from DB.DBA.SYS_HTTP_SPONGE where HS_LOCAL_IRI like concat (\'destMD5=\', md5 (graph_iri), \'&graphMD5=%\');\n"
"}\n"
"/*091202 commit work; */\n"
"log_enable (old_log_enable, 1);\n"
"if (compose_report)\n"
"return sprintf (\'Clear <%s> -- done\', graph_iri);\n"
"else\n"
"return 1;\n"
"}\n"
"--src sparql.sql:4414\n";

static const char *proc165 = 
"create function DB.DBA.SPARUL_LOAD (in graph_iri any, in resource varchar, in uid integer, in log_mode integer, in compose_report integer) returns any\n"
"{\n"
"declare old_log_enable integer;\n"
"declare grab_params any;\n"
"declare grabbed any;\n"
"declare res integer;\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL LOAD\');\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"grabbed := dict_new();\n"
"if (isiri_id (graph_iri))\n"
"graph_iri := id_to_iri (graph_iri);\n"
"grab_params := vector (\'base_iri\', resource, \'get:destination\', graph_iri,\n"
"\'resolver\', \'DB.DBA.RDF_GRAB_RESOLVER_DEFAULT\', \'loader\', \'DB.DBA.RDF_SPONGE_UP\',\n"
"\'get:soft\', \'replacing\',\n"
"\'get:refresh\', -1,\n"
"\'get:error-recovery\', \'signal\',\n"
"\n"
"\'grabbed\', grabbed );\n"
"commit work;\n"
"res := DB.DBA.RDF_GRAB_SINGLE (resource, grabbed, grab_params);\n"
"commit work;\n"
"log_enable (old_log_enable, 1);\n"
"if (res)\n"
"{\n"
"if (compose_report)\n"
"return sprintf (\'Load <%s> into graph <%s> -- done\', resource, graph_iri);\n"
"else\n"
"return 1;\n"
"}\n"
"else\n"
"{\n"
"if (compose_report)\n"
"return sprintf (\'Load <%s> into graph <%s> -- failed\', resource, graph_iri);\n"
"else\n"
"return 0;\n"
"}\n"
"}\n"
"--src sparql.sql:4445\n";

static const char *proc166 = 
"create function DB.DBA.SPARUL_CREATE (in graph_iri any, in silent integer, in uid integer, in log_mode integer, in compose_report integer) returns any\n"
"{\n"
"declare old_log_enable integer;\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL CREATE GRAPH\');\n"
"if (exists (select top 1 1 from DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH where REC_GRAPH_IID = iri_to_id (graph_iri)))\n"
"{\n"
"if (silent)\n"
"{\n"
"if (compose_report)\n"
"return sprintf (\'Create silent graph <%s> -- already exists\', graph_iri);\n"
"else\n"
"return 0;\n"
"}\n"
"else\n"
"signal (\'22023\', \'SPARUL_CREATE() failed: graph <\' || graph_iri || \'> has been explicitly created before\');\n"
"}\n"
"if (silent)\n"
"{\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"insert soft DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH (REC_GRAPH_IID) values (iri_to_id (graph_iri));\n"
"/*091202 commit work; */\n"
"log_enable (old_log_enable, 1);\n"
"if (compose_report)\n"
"return sprintf (\'Create silent graph <%s> -- done\', graph_iri);\n"
"else\n"
"return 1;\n"
"}\n"
"if (exists (select top 1 1 from DB.DBA.RDF_QUAD where G = iri_to_id (graph_iri)))\n"
"signal (\'22023\', \'SPARUL_CREATE() failed: graph <\' || graph_iri || \'> contains triples already\');\n"
"if (exists (sparql define input:storage \"\"\n"
"ask from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?qmv virtrdf:qmGraphRange-rvrFixedValue `iri(?:graph_iri)` } ) )\n"
"signal (\'22023\', \'SPARUL_CREATE() failed: graph <\' || graph_iri || \'> is used for mapping relational data to RDF\');\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"insert soft DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH (REC_GRAPH_IID) values (iri_to_id (graph_iri));\n"
"/*091202 commit work; */\n"
"log_enable (old_log_enable, 1);\n"
"if (compose_report)\n"
"return sprintf (\'Create graph <%s> -- done\', graph_iri);\n"
"else\n"
"return 1;\n"
"}\n"
"--src sparql.sql:4485\n";

static const char *proc167 = 
"create function DB.DBA.SPARUL_DROP (in graph_iri any, in silent integer, in uid integer, in log_mode integer, in compose_report integer) returns any\n"
"{\n"
"declare old_log_enable integer;\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL DROP GRAPH\');\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH where REC_GRAPH_IID = iri_to_id (graph_iri)))\n"
"{\n"
"if (silent)\n"
"{\n"
"if (exists (select top 1 1 from DB.DBA.RDF_QUAD where G = iri_to_id (graph_iri)))\n"
"{\n"
"DB.DBA.SPARUL_CLEAR (graph_iri, 0, uid);\n"
"log_enable (old_log_enable, 1);\n"
"if (compose_report)\n"
"return sprintf (\'Drop silent graph <%s> -- graph has not been explicitly created before, triples were removed\', graph_iri);\n"
"else\n"
"return 2;\n"
"}\n"
"if (compose_report)\n"
"return sprintf (\'Drop silent graph <%s> -- nothing to do\', graph_iri);\n"
"else\n"
"return 0;\n"
"}\n"
"else\n"
"signal (\'22023\', \'SPARUL_DROP() failed: graph <\' || graph_iri || \'> has not been explicitly created before\');\n"
"}\n"
"if (silent)\n"
"{\n"
"DB.DBA.SPARUL_CLEAR (graph_iri, 0, uid);\n"
"delete from DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH where REC_GRAPH_IID = iri_to_id (graph_iri);\n"
"/*091202 commit work; */\n"
"log_enable (old_log_enable, 1);\n"
"if (compose_report)\n"
"return sprintf (\'Drop silent graph <%s> -- done\', graph_iri);\n"
"else\n"
"return 1;\n"
"}\n"
"if (exists (sparql define input:storage \"\"\n"
"ask from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?qmv virtrdf:qmGraphRange-rvrFixedValue `iri(?:graph_iri)` } ) )\n"
"signal (\'22023\', \'SPARUL_CREATE() failed: graph <\' || graph_iri || \'> is used for mapping relational data to RDF\');\n"
"DB.DBA.SPARUL_CLEAR (graph_iri, 0, uid);\n"
"delete from DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH where REC_GRAPH_IID = iri_to_id (graph_iri);\n"
"log_enable (old_log_enable, 1);\n"
"/*091202 commit work; */\n"
"if (compose_report)\n"
"return sprintf (\'Drop graph <%s> -- done\', graph_iri);\n"
"else\n"
"return 1;\n"
"}\n"
"--src sparql.sql:4531\n";

static const char *proc168 = 
"create function DB.DBA.SPARUL_RUN (in results any, in compose_report integer := 0) returns any\n"
"{\n"
"\n"
"if (compose_report)\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"foreach (varchar r in results) do\n"
"{\n"
"http (r || \'\\n\', ses);\n"
"}\n"
"http (\'Commit -- done\\n\', ses);\n"
"return string_output_string (ses);\n"
"}\n"
"else\n"
"{\n"
"declare res integer;\n"
"res := 0;\n"
"foreach (integer c in results) do\n"
"{\n"
"res := res + c;\n"
"}\n"
"return res;\n"
"}\n"
"}\n"
"--src sparql.sql:4584\n";

static const char *proc169 = 
"create procedure DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS (in return_iris varchar := 1, in lim integer := 2000000000)\n"
"{\n"
"declare specials, specials_vec any;\n"
"declare last_iri_id, cur_iri_id IRI_ID;\n"
"declare cr cursor for select G from DB.DBA.RDF_QUAD where G > last_iri_id and not (dict_get (specials, G, 0));\n"
"declare cr_cl cursor for select G from DB.DBA.RDF_QUAD where G > last_iri_id and 0 >= position (G, specials_vec);\n"
"declare GRAPH_IRI varchar;\n"
"declare GRAPH_IID IRI_ID;\n"
"declare ctr, len integer;\n"
"if (return_iris)\n"
"result_names (GRAPH_IRI);\n"
"else\n"
"result_names (GRAPH_IID);\n"
"specials := dict_new (50);\n"
"set isolation = \'repeatable\';\n"
"for (sparql define input:storage \"\"\n"
"select distinct ?graph_rvr_fixed\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?qmv virtrdf:qmGraphRange-rvrFixedValue ?graph_rvr_fixed } ) do\n"
"{\n"
"dict_put (specials, iri_to_id (\"graph_rvr_fixed\"), 1);\n"
"}\n"
"if (dict_size (specials) >= lim)\n"
"goto done_all;\n"
"for (select REC_GRAPH_IID from DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH) do\n"
"{\n"
"dict_put (specials, REC_GRAPH_IID, 2);\n"
"}\n"
"len := dict_size (specials);\n"
"if (len >= lim)\n"
"goto done_all;\n"
"last_iri_id := #i0;\n"
"\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"specials_vec := dict_list_keys (specials, 0);\n"
"whenever not found goto done_rdf_quad_cl;\n"
"open cr_cl (prefetch 1);\n"
"\n"
"next_fetch_cr_cl:\n"
"fetch cr_cl into cur_iri_id;\n"
"if (return_iris)\n"
"result (id_to_iri (cur_iri_id));\n"
"else\n"
"result (cur_iri_id);\n"
"lim := lim - 1;\n"
"if (len >= lim)\n"
"goto done_rdf_quad_cl;\n"
"last_iri_id := cur_iri_id;\n"
"close cr_cl;\n"
"open cr_cl (prefetch 1);\n"
"goto next_fetch_cr_cl;\n"
"\n"
"done_rdf_quad_cl:\n"
"close cr_cl;\n"
"}\n"
"else\n"
"{\n"
"whenever not found goto done_rdf_quad;\n"
"open cr (prefetch 1);\n"
"\n"
"next_fetch_cr:\n"
"fetch cr into cur_iri_id;\n"
"if (return_iris)\n"
"result (id_to_iri (cur_iri_id));\n"
"else\n"
"result (cur_iri_id);\n"
"lim := lim - 1;\n"
"if (len >= lim)\n"
"goto done_rdf_quad;\n"
"last_iri_id := cur_iri_id;\n"
"goto next_fetch_cr;\n"
"\n"
"done_rdf_quad:\n"
"close cr;\n"
"}\n"
"\n"
"done_all:\n"
"specials := dict_list_keys (specials, 1);\n"
"len := length (specials);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 1)\n"
"if (return_iris)\n"
"result (id_to_iri (specials[ctr]));\n"
"else\n"
"result (specials[ctr]);\n"
"}\n"
"--src sparql.sql:4611\n";

static const char *proc170 = 
" create function DB.DBA.RDF_REGEX (in s varchar, in p varchar, in coll varchar := null)\n"
"{\n"
"if (not iswidestring (s) and not isstring (s))\n"
"return 0;\n"
"if (regexp_match (p, s, 0, coalesce (coll, \'\'), 1) is not null)\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src sparql.sql:4703\n";

static const char *proc171 = 
" create function DB.DBA.RDF_LANGMATCHES (in r varchar, in t varchar)\n"
"{\n"
"if ((t is null) or (r is null))\n"
"return null;\n"
"if (\'*\' = t)\n"
"{\n"
"if (r <> \'\')\n"
"return 1;\n"
"return 0;\n"
"}\n"
"t := upper (t);\n"
"r := upper (r);\n"
"if (r = t)\n"
"return 1;\n"
"if (r like t || \'-%\')\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src sparql.sql:4714\n";

static const char *proc172 = 
" create procedure DB.DBA.BEST_LANGMATCH_INIT (inout env any)\n"
"{\n"
"env := vector (0, -2);\n"
"}\n"
"--src sparql.sql:4735\n";

static const char *proc173 = 
" create procedure DB.DBA.BEST_LANGMATCH_ACC (inout env any, inout obj any, in range varchar, in dflt_lang varchar)\n"
"{\n"
"declare lang varchar;\n"
"declare pct integer;\n"
"if (obj is null)\n"
"return;\n"
"if (__tag (env) <> __tag of vector)\n"
"env := vector (0, -2);\n"
"if (__tag of rdf_box = __tag (obj))\n"
"{\n"
"declare twobyte integer;\n"
"twobyte := rdf_box_lang (obj);\n"
"if (257 = twobyte)\n"
"lang := dflt_lang;\n"
"else\n"
"{\n"
"whenever not found goto badlang;\n"
"select lower (RL_ID) into lang from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = twobyte;\n"
"goto lang_ready;\n"
"badlang:\n"
"signal (\'RDFXX\', sprintf (\'Unknown language in DB.DBA.BEST_LANGMATCH_ACC, bad lang id %d\', twobyte));\n"
"}\n"
"}\n"
"else if (__tag of varchar = __tag (obj))\n"
"lang := dflt_lang;\n"
"else\n"
"{\n"
"if (env[1] = -2)\n"
"env := vector (obj, -1);\n"
"return;\n"
"}\n"
"lang_ready:\n"
"pct := langmatches_pct_http (lang, range);\n"
"if (env[1] < pct)\n"
"env := vector (obj, pct);\n"
"}\n"
"--src sparql.sql:4742\n";

static const char *proc174 = 
" create function DB.DBA.BEST_LANGMATCH_FINAL (inout env any) returns any\n"
"{\n"
"if (__tag (env) <> __tag of vector)\n"
"return null;\n"
"return env[0];\n"
"}\n"
"--src sparql.sql:4781\n";

static const char *other27 = 
" create aggregate DB.DBA.BEST_LANGMATCH (inout obj any, in range varchar, in dflt_lang varchar) from\n"
"DB.DBA.BEST_LANGMATCH_INIT,\n"
"DB.DBA.BEST_LANGMATCH_ACC,\n"
"DB.DBA.BEST_LANGMATCH_FINAL\n";

static const char *proc175 = 
" create procedure DB.DBA.SPARQL_CONSTRUCT_INIT (inout _env any)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src sparql.sql:4797\n";

static const char *proc176 = 
" create procedure DB.DBA.SPARQL_CONSTRUCT_ACC (inout _env any, in opcodes any, in vars any, in stats any, in use_dict_limit integer)\n"
"{\n"
"declare triple_ctr integer;\n"
"declare blank_ids any;\n"
"if (214 <> __tag(_env))\n"
"{\n"
"if (use_dict_limit)\n"
"_env := dict_new (31, sys_stat (\'sparql_result_set_max_rows\'), sys_stat (\'sparql_max_mem_in_use\'));\n"
"else\n"
"_env := dict_new (31);\n"
"if (0 < length (stats))\n"
"DB.DBA.SPARQL_CONSTRUCT_ACC (_env, stats, vector(), vector(), use_dict_limit);\n"
"}\n"
"blank_ids := 0;\n"
"for (triple_ctr := length (opcodes) - 1; triple_ctr >= 0; triple_ctr := triple_ctr-1)\n"
"{\n"
"declare fld_ctr integer;\n"
"declare triple_vec any;\n"
"triple_vec := vector (0,0,0);\n"
"\n"
"for (fld_ctr := 2; fld_ctr >= 0; fld_ctr := fld_ctr - 1)\n"
"{\n"
"declare op integer;\n"
"declare arg any;\n"
"op := opcodes[triple_ctr][fld_ctr * 2];\n"
"arg := opcodes[triple_ctr][fld_ctr * 2 + 1];\n"
"if (1 = op)\n"
"{\n"
"declare i any;\n"
"i := vars[arg];\n"
"if (i is null)\n"
"goto end_of_adding_triple;\n"
"if (isiri_id (i))\n"
"{\n"
"if ((1 = fld_ctr) and is_bnode_iri_id (i))\n"
"signal (\'RDF01\', \'Bad variable value in CONSTRUCT: blank node can not be used as predicate\');\n"
"}\n"
"else if ((isstring (i) and (1 = __box_flags (i))) or (217 = __tag(i)))\n"
"{\n"
"if ((1 = fld_ctr) and (i like \'bnode://%\'))\n"
"signal (\'RDF01\', \'Bad variable value in CONSTRUCT: blank node can not be used as predicate\');\n"
"i := iri_to_id (i);\n"
"}\n"
"else if (2 > fld_ctr)\n"
"signal (\'RDF01\',\n"
"sprintf (\'Bad variable value in CONSTRUCT: \"%.100s\" (tag %d box flags %d) is not a valid %s, only object of a triple can be a literal\',\n"
"__tag (i), __box_flags (i),\n"
"__rdf_strsqlval (i),\n"
"case (fld_ctr) when 1 then \'predicate\' else \'subject\' end ) );\n"
"triple_vec[fld_ctr] := i;\n"
"}\n"
"else if (2 = op)\n"
"{\n"
"if (isinteger (blank_ids))\n"
"blank_ids := vector (iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\')));\n"
"while (arg >= length (blank_ids))\n"
"blank_ids := vector_concat (blank_ids, vector (iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\'))));\n"
"if (1 = fld_ctr)\n"
"signal (\'RDF01\', \'Bad triple for CONSTRUCT: blank node can not be used as predicate\');\n"
"triple_vec[fld_ctr] := blank_ids[arg];\n"
"}\n"
"else if (3 = op)\n"
"{\n"
"if (arg is null)\n"
"goto end_of_adding_triple;\n"
"\n"
"if (isiri_id (arg))\n"
"{\n"
"if ((1 = fld_ctr) and is_bnode_iri_id (arg))\n"
"signal (\'RDF01\', \'Bad const value in CONSTRUCT: blank node can not be used as predicate\');\n"
"}\n"
"else if ((isstring (arg) and (1 = __box_flags (arg))) or (217 = __tag(arg)))\n"
"{\n"
"if ((1 = fld_ctr) and (arg like \'bnode://%\'))\n"
"signal (\'RDF01\', \'Bad const value in CONSTRUCT: blank node can not be used as predicate\');\n"
"arg := iri_to_id (arg);\n"
"}\n"
"else if (2 > fld_ctr)\n"
"signal (\'RDF01\',\n"
"sprintf (\'Bad const value in CONSTRUCT: \"%.100s\" (tag %d box flags %d) is not a valid %s, only object of a triple can be a literal\',\n"
"__tag (arg), __box_flags (arg),\n"
"__rdf_strsqlval (arg),\n"
"case (fld_ctr) when 1 then \'predicate\' else \'subject\' end ) );\n"
"else if (__tag of vector = __tag (arg))\n"
"arg := DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL_STRINGS (arg[0], arg[1], arg[2]);\n"
"triple_vec[fld_ctr] := arg;\n"
"}\n"
"else signal (\'RDFXX\', \'Bad opcode in DB.DBA.SPARQL_CONSTRUCT()\');\n"
"}\n"
"\n"
"dict_put (_env, triple_vec, 0);\n"
"end_of_adding_triple: ;\n"
"}\n"
"}\n"
"--src sparql.sql:4804\n";

static const char *proc177 = 
" create procedure DB.DBA.SPARQL_CONSTRUCT_FIN (inout _env any)\n"
"{\n"
"if (214 <> __tag(_env))\n"
"_env := dict_new ();\n"
"return _env;\n"
"}\n"
"--src sparql.sql:4901\n";

static const char *other28 = 
" create aggregate DB.DBA.SPARQL_CONSTRUCT (in opcodes any, in vars any, in stats any, in use_dict_limit integer) returns any\n"
"from DB.DBA.SPARQL_CONSTRUCT_INIT, DB.DBA.SPARQL_CONSTRUCT_ACC, DB.DBA.SPARQL_CONSTRUCT_FIN\n";

static const char *proc178 = 
"create procedure DB.DBA.SPARQL_DESC_AGG_INIT (inout _env any)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src sparql.sql:4914\n";

static const char *proc179 = 
"create procedure DB.DBA.SPARQL_DESC_AGG_ACC (inout _env any, in vars any)\n"
"{\n"
"declare var_ctr integer;\n"
"declare blank_ids any;\n"
"if (214 <> __tag(_env))\n"
"{\n"
"_env := dict_new (31, sys_stat (\'sparql_result_set_max_rows\'), sys_stat (\'sparql_max_mem_in_use\'));\n"
"}\n"
"for (var_ctr := length (vars) - 1; var_ctr >= 0; var_ctr := var_ctr - 1)\n"
"{\n"
"declare i any;\n"
"i := vars[var_ctr];\n"
"if (isiri_id (i))\n"
"dict_put (_env, i, 0);\n"
"}\n"
"}\n"
"--src sparql.sql:4920\n";

static const char *proc180 = 
"create procedure DB.DBA.SPARQL_DESC_AGG_FIN (inout _env any)\n"
"{\n"
"declare subjects, options, res any;\n"
"declare subj_ctr integer;\n"
"if (214 <> __tag(_env))\n"
"return dict_new ();\n"
"return _env;\n"
"}\n"
"--src sparql.sql:4938\n";

static const char *other29 = 
"create aggregate DB.DBA.SPARQL_DESC_AGG (in vars any) returns any\n"
"from DB.DBA.SPARQL_DESC_AGG_INIT, DB.DBA.SPARQL_DESC_AGG_ACC, DB.DBA.SPARQL_DESC_AGG_FIN\n";

static const char *proc181 = 
"create procedure DB.DBA.SPARQL_DESC_DICT (in subj_dict any, in consts any, in good_graphs any, in bad_graphs any, in storage_name any, in options any)\n"
"{\n"
"declare all_subj_descs, phys_subjects, sorted_good_graphs, sorted_bad_graphs, g_dict, res any;\n"
"declare uid, graphs_listed, g_ctr, good_g_count, bad_g_count, s_ctr, all_s_count, phys_s_count integer;\n"
"declare gs_app_callback, gs_app_uid varchar;\n"
"declare rdf_type_iid IRI_ID;\n"
"uid := get_keyword (\'uid\', options, http_nobody_uid());\n"
"gs_app_callback := get_keyword (\'gs-app-callback\', options);\n"
"if (gs_app_callback is not null)\n"
"gs_app_uid := get_keyword (\'gs-app-uid\', options);\n"
"rdf_type_iid := iri_to_id (UNAME\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\');\n"
"res := dict_new ();\n"
"if (isinteger (consts))\n"
"return res;\n"
"foreach (any c in consts) do\n"
"{\n"
"if (isiri_id (c))\n"
"dict_put (subj_dict, c, 0);\n"
"}\n"
"all_subj_descs := dict_list_keys (subj_dict, 1);\n"
"all_s_count := length (all_subj_descs);\n"
"if (0 = all_s_count)\n"
"return res;\n"
"gvector_sort (all_subj_descs, 1, 0, 0);\n"
"if (__tag of integer = __tag (good_graphs))\n"
"graphs_listed := 0;\n"
"else\n"
"{\n"
"vectorbld_init (sorted_good_graphs);\n"
"foreach (any g in good_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id () and\n"
"__rgs_ack_cbk (g, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (g, gs_app_uid))) )\n"
"vectorbld_acc (sorted_good_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_good_graphs);\n"
"good_g_count := length (sorted_good_graphs);\n"
"if (0 = good_g_count)\n"
"return res;\n"
"graphs_listed := 1;\n"
"}\n"
"vectorbld_init (sorted_bad_graphs);\n"
"foreach (any g in bad_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id ())\n"
"vectorbld_acc (sorted_bad_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_bad_graphs);\n"
"bad_g_count := length (sorted_bad_graphs);\n"
"vectorbld_init (phys_subjects);\n"
"if (isinteger (storage_name))\n"
"storage_name := \'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadStorage\';\n"
"else if (\'\' = storage_name)\n"
"{\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s, phys_s any;\n"
"s := all_subj_descs [s_ctr];\n"
"if (isiri_id (s))\n"
"vectorbld_acc (phys_subjects, s);\n"
"else\n"
"{\n"
"phys_s := iri_to_id (s, 0, 0);\n"
"if (not isinteger (phys_s))\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"}\n"
"vectorbld_final (phys_subjects);\n"
"goto describe_physical_subjects;\n"
"}\n"
"\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s, phys_s, maps any;\n"
"declare maps_len integer;\n"
"s := all_subj_descs [s_ctr];\n"
"maps := sparql_quad_maps_for_quad (NULL, s, NULL, NULL, storage_name, case (graphs_listed) when 0 then vector() else sorted_good_graphs end, sorted_bad_graphs);\n"
"\n"
"maps_len := length (maps);\n"
"if ((maps_len > 0) and (maps[maps_len-1][0] = UNAME\'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadMap\'))\n"
"{\n"
"if (isiri_id (s))\n"
"{\n"
"phys_s := s;\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"else\n"
"{\n"
"phys_s := iri_to_id (s, 0, 0);\n"
"if (not isinteger (phys_s))\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"maps := subseq (maps, 0, maps_len-1);\n"
"maps_len := maps_len - 1;\n"
"}\n"
"if (maps_len > 0)\n"
"all_subj_descs [s_ctr] := vector (s, maps);\n"
"else\n"
"all_subj_descs [s_ctr] := 0;\n"
"\n"
"\n"
"}\n"
"vectorbld_final (phys_subjects);\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s_desc, s, maps any;\n"
"declare map_ctr, maps_len integer;\n"
"declare fname varchar;\n"
"s_desc := all_subj_descs [s_ctr];\n"
"if (isinteger (s_desc))\n"
"goto end_of_s;\n"
"s := s_desc[0];\n"
"maps := s_desc[1];\n"
"maps_len := length (maps);\n"
"fname := sprintf (\'SPARQL_DESC_DICT_QMV1_%U\', md5 (storage_name || cast (graphs_listed as varchar) || md5_box (maps) || md5_box (sorted_bad_graphs)));\n"
"if (not exists (select top 1 1 from Db.DBA.SYS_PROCEDURES where P_NAME = \'DB.DBA.\' || fname))\n"
"{\n"
"declare ses, txt, saved_user any;\n"
"ses := string_output ();\n"
"http (\'create procedure DB.DBA.\"\' || fname || \'\" (in subj any, inout res any\', ses);\n"
"if (graphs_listed)\n"
"http (\', inout sorted_good_graphs any\', ses);\n"
"http (\')\\n\', ses);\n"
"http (\'{\\n\', ses);\n"
"http (\'  declare subj_iri varchar;\\n\', ses);\n"
"http (\'  subj_iri := id_to_iri_nosignal (subj);\\n\', ses);\n"
"http (\'  for (sparql define output:valmode \"LONG\" define input:storage <\' || storage_name || \'> \', ses);\n"
"foreach (any g in sorted_bad_graphs) do\n"
"{\n"
"http (\'  define input:named-graph-exclude <\' || id_to_iri_nosignal (g) || \'>\\n\', ses);\n"
"}\n"
"http (\'select ?g1 ?p1 ?o1\\n\', ses);\n"
"http (\'      where { graph ?g1 {\\n\', ses);\n"
"for (map_ctr := 0; map_ctr < maps_len; map_ctr := map_ctr + 1)\n"
"{\n"
"if (map_ctr > 0) http (\'              union\\n\', ses);\n"
"http (\'              { quad map <\' || maps[map_ctr][0] || \'> { ?:subj_iri ?p1 ?o1 } }\\n\', ses);\n"
"}\n"
"http (\'            } } ) do { \', ses);\n"
"if (graphs_listed)\n"
"http (\'      if (position (\"g1\", sorted_good_graphs))\\n\', ses);\n"
"http (\'      dict_put (res, vector (subj, \"p1\", \"o1\"), 1); } }\\n\', ses);\n"
"txt := string_output_string (ses);\n"
"\n"
"saved_user := user;\n"
"set_user_id (\'dba\', 1);\n"
"exec (txt);\n"
"set_user_id (saved_user);\n"
"}\n"
"if (graphs_listed)\n"
"{\n"
"\n"
"call (\'DB.DBA.\' || fname)(s, res, sorted_good_graphs);\n"
"}\n"
"else\n"
"{\n"
"\n"
"call (\'DB.DBA.\' || fname)(s, res);\n"
"}\n"
"end_of_s: ;\n"
"}\n"
"\n"
"describe_physical_subjects:\n"
"gvector_sort (phys_subjects, 1, 0, 0);\n"
"phys_s_count := length (phys_subjects);\n"
"\n"
"if (0 = phys_s_count)\n"
"return res;\n"
"\n"
"if (graphs_listed)\n"
"{\n"
"gvector_sort (sorted_good_graphs, 1, 0, 0);\n"
"\n"
"for (g_ctr := good_g_count - 1; g_ctr >= 0; g_ctr := g_ctr - 1)\n"
"{\n"
"declare graph any;\n"
"graph := sorted_good_graphs [g_ctr];\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := phys_subjects [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where G = graph and S = subj) do\n"
"{\n"
"\n"
"dict_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 0);\n"
"}\n"
"for (select S as s1, P as p1 from DB.DBA.RDF_QUAD\n"
"where G = graph and O = subj and P <> rdf_type_iid\n"
"option (QUIETCAST)) do\n"
"{\n"
"\n"
"dict_put (res, vector (s1, p1, subj), 1);\n"
"}\n"
"}\n"
"}\n"
"return res;\n"
"}\n"
"g_dict := dict_new ();\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj, graph any;\n"
"subj := phys_subjects [s_ctr];\n"
"graph := coalesce ((select top 1 G as g1 from DB.DBA.RDF_QUAD where O = subj and\n"
"0 = position (G, sorted_bad_graphs) and\n"
"__rgs_ack_cbk (G, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (G, gs_app_uid))) ) );\n"
"if (graph is not null)\n"
"dict_put (g_dict, graph, 0);\n"
"}\n"
"sorted_good_graphs := dict_list_keys (g_dict, 1);\n"
"if (0 = length (sorted_good_graphs))\n"
"{\n"
"g_dict := dict_new ();\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj, graph any;\n"
"subj := phys_subjects [s_ctr];\n"
"graph := coalesce ((select top 1 G as g1 from DB.DBA.RDF_QUAD where S = subj and P = rdf_type_iid and\n"
"0 = position (G, sorted_bad_graphs) and\n"
"__rgs_ack_cbk (G, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (G, gs_app_uid))) ) );\n"
"if (graph is not null)\n"
"dict_put (g_dict, graph, 0);\n"
"}\n"
"sorted_good_graphs := dict_list_keys (g_dict, 1);\n"
"}\n"
"\n"
"gvector_sort (sorted_good_graphs, 1, 0, 0);\n"
"good_g_count := length (sorted_good_graphs);\n"
"\n"
"for (g_ctr := good_g_count - 1; g_ctr >= 0; g_ctr := g_ctr - 1)\n"
"{\n"
"declare graph any;\n"
"graph := sorted_good_graphs [g_ctr];\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := phys_subjects [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where G = graph and S = subj) do\n"
"{\n"
"\n"
"dict_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 0);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"for (select S as s1, P as p1 from DB.DBA.RDF_QUAD\n"
"where G = graph and O = subj and P <> rdf_type_iid\n"
"option (QUIETCAST)) do\n"
"{\n"
"\n"
"dict_put (res, vector (s1, p1, subj), 1);\n"
"}\n"
"}\n"
"}\n"
"\n"
"return res;\n"
"}\n"
"--src sparql.sql:4952\n";

static const char *proc182 = 
"create procedure DB.DBA.SPARQL_DESC_DICT_SPO (in subj_dict any, in consts any, in good_graphs any, in bad_graphs any, in storage_name any, in options any)\n"
"{\n"
"declare all_subj_descs, phys_subjects, sorted_good_graphs, sorted_bad_graphs, res any;\n"
"declare uid, graphs_listed, g_ctr, good_g_count, bad_g_count, s_ctr, all_s_count, phys_s_count integer;\n"
"declare gs_app_callback, gs_app_uid varchar;\n"
"declare rdf_type_iid IRI_ID;\n"
"uid := get_keyword (\'uid\', options, http_nobody_uid());\n"
"gs_app_callback := get_keyword (\'gs-app-callback\', options);\n"
"if (gs_app_callback is not null)\n"
"gs_app_uid := get_keyword (\'gs-app-uid\', options);\n"
"rdf_type_iid := iri_to_id (UNAME\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\');\n"
"res := dict_new ();\n"
"if (isinteger (consts))\n"
"return res;\n"
"foreach (any c in consts) do\n"
"{\n"
"if (isiri_id (c))\n"
"dict_put (subj_dict, c, 0);\n"
"}\n"
"all_subj_descs := dict_list_keys (subj_dict, 1);\n"
"all_s_count := length (all_subj_descs);\n"
"if (0 = all_s_count)\n"
"return res;\n"
"gvector_sort (all_subj_descs, 1, 0, 0);\n"
"if (__tag of integer = __tag (good_graphs))\n"
"graphs_listed := 0;\n"
"else\n"
"{\n"
"vectorbld_init (sorted_good_graphs);\n"
"foreach (any g in good_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id () and\n"
"__rgs_ack_cbk (g, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (g, gs_app_uid))) )\n"
"vectorbld_acc (sorted_good_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_good_graphs);\n"
"good_g_count := length (sorted_good_graphs);\n"
"if (0 = good_g_count)\n"
"return res;\n"
"graphs_listed := 1;\n"
"}\n"
"vectorbld_init (sorted_bad_graphs);\n"
"foreach (any g in bad_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id ())\n"
"vectorbld_acc (sorted_bad_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_bad_graphs);\n"
"bad_g_count := length (sorted_bad_graphs);\n"
"vectorbld_init (phys_subjects);\n"
"if (isinteger (storage_name))\n"
"storage_name := \'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadStorage\';\n"
"else if (\'\' = storage_name)\n"
"{\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s, phys_s any;\n"
"s := all_subj_descs [s_ctr];\n"
"if (isiri_id (s))\n"
"vectorbld_acc (phys_subjects, s);\n"
"else\n"
"{\n"
"phys_s := iri_to_id (s, 0, 0);\n"
"if (not isinteger (phys_s))\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"}\n"
"vectorbld_final (phys_subjects);\n"
"goto describe_physical_subjects;\n"
"}\n"
"\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s, phys_s, maps any;\n"
"declare maps_len integer;\n"
"s := all_subj_descs [s_ctr];\n"
"maps := sparql_quad_maps_for_quad (NULL, s, NULL, NULL, storage_name, case (graphs_listed) when 0 then vector() else sorted_good_graphs end, sorted_bad_graphs);\n"
"\n"
"maps_len := length (maps);\n"
"if ((maps_len > 0) and (maps[maps_len-1][0] = UNAME\'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadMap\'))\n"
"{\n"
"if (isiri_id (s))\n"
"{\n"
"phys_s := s;\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"else\n"
"{\n"
"phys_s := iri_to_id (s, 0, 0);\n"
"if (not isinteger (phys_s))\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"maps := subseq (maps, 0, maps_len-1);\n"
"maps_len := maps_len - 1;\n"
"}\n"
"if (maps_len > 0)\n"
"all_subj_descs [s_ctr] := vector (s, maps);\n"
"else\n"
"all_subj_descs [s_ctr] := 0;\n"
"\n"
"\n"
"}\n"
"vectorbld_final (phys_subjects);\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s_desc, s, maps any;\n"
"declare map_ctr, maps_len integer;\n"
"declare fname varchar;\n"
"s_desc := all_subj_descs [s_ctr];\n"
"if (isinteger (s_desc))\n"
"goto end_of_s;\n"
"s := s_desc[0];\n"
"maps := s_desc[1];\n"
"maps_len := length (maps);\n"
"fname := sprintf (\'SPARQL_DESC_DICT_QMV1_%U\', md5 (storage_name || cast (graphs_listed as varchar) || md5_box (maps) || md5_box (sorted_bad_graphs)));\n"
"if (not exists (select top 1 1 from Db.DBA.SYS_PROCEDURES where P_NAME = \'DB.DBA.\' || fname))\n"
"{\n"
"declare ses, txt, saved_user any;\n"
"ses := string_output ();\n"
"http (\'create procedure DB.DBA.\"\' || fname || \'\" (in subj any, inout res any\', ses);\n"
"if (graphs_listed)\n"
"http (\', inout sorted_good_graphs any\', ses);\n"
"http (\')\\n\', ses);\n"
"http (\'{\\n\', ses);\n"
"http (\'  declare subj_iri varchar;\\n\', ses);\n"
"http (\'  subj_iri := id_to_iri_nosignal (subj);\\n\', ses);\n"
"http (\'  for (sparql define output:valmode \"LONG\" define input:storage <\' || storage_name || \'> \', ses);\n"
"foreach (any g in sorted_bad_graphs) do\n"
"{\n"
"http (\'  define input:named-graph-exclude <\' || id_to_iri_nosignal (g) || \'>\\n\', ses);\n"
"}\n"
"http (\'select ?g1 ?p1 ?o1\\n\', ses);\n"
"http (\'      where { graph ?g1 {\\n\', ses);\n"
"for (map_ctr := 0; map_ctr < maps_len; map_ctr := map_ctr + 1)\n"
"{\n"
"if (map_ctr > 0) http (\'              union\\n\', ses);\n"
"http (\'              { quad map <\' || maps[map_ctr][0] || \'> { ?:subj_iri ?p1 ?o1 } }\\n\', ses);\n"
"}\n"
"http (\'            } } ) do { \', ses);\n"
"if (graphs_listed)\n"
"http (\'      if (position (\"g1\", sorted_good_graphs))\\n\', ses);\n"
"http (\'      dict_put (res, vector (subj, \"p1\", \"o1\"), 1); } }\\n\', ses);\n"
"txt := string_output_string (ses);\n"
"\n"
"saved_user := user;\n"
"set_user_id (\'dba\', 1);\n"
"exec (txt);\n"
"set_user_id (saved_user);\n"
"}\n"
"if (graphs_listed)\n"
"{\n"
"\n"
"call (\'DB.DBA.\' || fname)(s, res, sorted_good_graphs);\n"
"}\n"
"else\n"
"{\n"
"\n"
"call (\'DB.DBA.\' || fname)(s, res);\n"
"}\n"
"end_of_s: ;\n"
"}\n"
"\n"
"describe_physical_subjects:\n"
"gvector_sort (phys_subjects, 1, 0, 0);\n"
"phys_s_count := length (phys_subjects);\n"
"\n"
"if (0 = phys_s_count)\n"
"return res;\n"
"\n"
"if (graphs_listed)\n"
"{\n"
"gvector_sort (sorted_good_graphs, 1, 0, 0);\n"
"\n"
"for (g_ctr := good_g_count - 1; g_ctr >= 0; g_ctr := g_ctr - 1)\n"
"{\n"
"declare graph any;\n"
"graph := sorted_good_graphs [g_ctr];\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := phys_subjects [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where G = graph and S = subj) do\n"
"{\n"
"\n"
"dict_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 0);\n"
"}\n"
"}\n"
"}\n"
"return res;\n"
"}\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := phys_subjects [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where\n"
"0 = position (G, sorted_bad_graphs) and\n"
"S = subj and\n"
"__rgs_ack_cbk (G, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (G, gs_app_uid))) ) do\n"
"{\n"
"\n"
"dict_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 0);\n"
"}\n"
"}\n"
"return res;\n"
"}\n"
"--src sparql.sql:5219\n";

static const char *proc183 = 
"create procedure DB.DBA.SPARQL_DESC_DICT_SPO_PHYSICAL (in subj_dict any, in consts any, in good_graphs any, in bad_graphs any, in storage_name any, in options any)\n"
"{\n"
"declare all_subj_descs, phys_subjects, sorted_good_graphs, sorted_bad_graphs, g_dict, res any;\n"
"declare uid, graphs_listed, g_ctr, good_g_count, bad_g_count, s_ctr, all_s_count, phys_s_count integer;\n"
"declare gs_app_callback, gs_app_uid varchar;\n"
"declare rdf_type_iid IRI_ID;\n"
"uid := get_keyword (\'uid\', options, http_nobody_uid());\n"
"gs_app_callback := get_keyword (\'gs-app-callback\', options);\n"
"if (gs_app_callback is not null)\n"
"gs_app_uid := get_keyword (\'gs-app-uid\', options);\n"
"rdf_type_iid := iri_to_id (UNAME\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\');\n"
"res := dict_new ();\n"
"if (isinteger (consts))\n"
"return res;\n"
"foreach (any c in consts) do\n"
"{\n"
"if (isiri_id (c))\n"
"dict_put (subj_dict, c, 0);\n"
"}\n"
"all_subj_descs := dict_list_keys (subj_dict, 1);\n"
"all_s_count := length (all_subj_descs);\n"
"if (0 = all_s_count)\n"
"return res;\n"
"gvector_sort (all_subj_descs, 1, 0, 0);\n"
"if (__tag of integer = __tag (good_graphs))\n"
"graphs_listed := 0;\n"
"else\n"
"{\n"
"vectorbld_init (sorted_good_graphs);\n"
"foreach (any g in good_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id () and\n"
"__rgs_ack_cbk (g, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (g, gs_app_uid))) )\n"
"vectorbld_acc (sorted_good_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_good_graphs);\n"
"good_g_count := length (sorted_good_graphs);\n"
"if (0 = good_g_count)\n"
"return res;\n"
"graphs_listed := 1;\n"
"}\n"
"vectorbld_init (sorted_bad_graphs);\n"
"foreach (any g in bad_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id ())\n"
"vectorbld_acc (sorted_bad_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_bad_graphs);\n"
"bad_g_count := length (sorted_bad_graphs);\n"
"vectorbld_init (phys_subjects);\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s, phys_s any;\n"
"s := all_subj_descs [s_ctr];\n"
"if (isiri_id (s))\n"
"vectorbld_acc (phys_subjects, s);\n"
"else\n"
"{\n"
"phys_s := iri_to_id (s, 0, 0);\n"
"if (not isinteger (phys_s))\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"}\n"
"vectorbld_final (phys_subjects);\n"
"gvector_sort (phys_subjects, 1, 0, 0);\n"
"phys_s_count := length (phys_subjects);\n"
"\n"
"if (0 = phys_s_count)\n"
"return res;\n"
"\n"
"if (graphs_listed)\n"
"{\n"
"gvector_sort (sorted_good_graphs, 1, 0, 0);\n"
"\n"
"for (g_ctr := good_g_count - 1; g_ctr >= 0; g_ctr := g_ctr - 1)\n"
"{\n"
"declare graph any;\n"
"graph := sorted_good_graphs [g_ctr];\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := phys_subjects [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where G = graph and S = subj) do\n"
"{\n"
"\n"
"dict_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 0);\n"
"}\n"
"}\n"
"}\n"
"return res;\n"
"}\n"
"g_dict := dict_new ();\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj, graph any;\n"
"subj := phys_subjects [s_ctr];\n"
"graph := coalesce ((select top 1 G as g1 from DB.DBA.RDF_QUAD where O = subj and\n"
"0 = position (G, sorted_bad_graphs) and\n"
"__rgs_ack_cbk (G, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (G, gs_app_uid))) ) );\n"
"if (graph is not null)\n"
"dict_put (g_dict, graph, 0);\n"
"}\n"
"sorted_good_graphs := dict_list_keys (g_dict, 1);\n"
"if (0 = length (sorted_good_graphs))\n"
"{\n"
"g_dict := dict_new ();\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj, graph any;\n"
"subj := phys_subjects [s_ctr];\n"
"graph := coalesce ((select top 1 G as g1 from DB.DBA.RDF_QUAD where S = subj and P = rdf_type_iid and\n"
"0 = position (G, sorted_bad_graphs) and\n"
"__rgs_ack_cbk (G, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (G, gs_app_uid))) ) );\n"
"if (graph is not null)\n"
"dict_put (g_dict, graph, 0);\n"
"}\n"
"sorted_good_graphs := dict_list_keys (g_dict, 1);\n"
"}\n"
"\n"
"gvector_sort (sorted_good_graphs, 1, 0, 0);\n"
"good_g_count := length (sorted_good_graphs);\n"
"\n"
"for (g_ctr := good_g_count - 1; g_ctr >= 0; g_ctr := g_ctr - 1)\n"
"{\n"
"declare graph any;\n"
"graph := sorted_good_graphs [g_ctr];\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := phys_subjects [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where G = graph and S = subj) do\n"
"{\n"
"\n"
"dict_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 0);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"}\n"
"\n"
"return res;\n"
"}\n"
"--src sparql.sql:5428\n";

static const char *proc184 = 
"create procedure DB.DBA.SPARQL_DESC_DICT_CBD (in subj_dict any, in consts any, in good_graphs any, in bad_graphs any, in storage_name any, in options any)\n"
"{\n"
"declare all_subjs, phys_subjects, sorted_good_graphs, sorted_bad_graphs, next_iter_subjs, res any;\n"
"declare uid, graphs_listed, g_ctr, good_g_count, bad_g_count, s_ctr, all_s_count, phys_s_count integer;\n"
"declare gs_app_callback, gs_app_uid varchar;\n"
"declare rdf_type_iid IRI_ID;\n"
"uid := get_keyword (\'uid\', options, http_nobody_uid());\n"
"gs_app_callback := get_keyword (\'gs-app-callback\', options);\n"
"if (gs_app_callback is not null)\n"
"gs_app_uid := get_keyword (\'gs-app-uid\', options);\n"
"rdf_type_iid := iri_to_id (UNAME\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\');\n"
"res := dict_new ();\n"
"if (isinteger (consts))\n"
"return res;\n"
"foreach (any c in consts) do\n"
"{\n"
"if (isiri_id (c))\n"
"dict_put (subj_dict, c, 0);\n"
"}\n"
"all_subjs := dict_list_keys (subj_dict, 0);\n"
"next_iter_subjs := dict_new ();\n"
"all_s_count := length (all_subjs);\n"
"if (0 = all_s_count)\n"
"return res;\n"
"\n"
"next_iteration:\n"
"all_s_count := length (all_subjs);\n"
"gvector_sort (all_subjs, 1, 0, 0);\n"
"\n"
"if (__tag of integer = __tag (good_graphs))\n"
"graphs_listed := 0;\n"
"else\n"
"{\n"
"vectorbld_init (sorted_good_graphs);\n"
"foreach (any g in good_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id () and\n"
"__rgs_ack_cbk (g, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (g, gs_app_uid))) )\n"
"vectorbld_acc (sorted_good_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_good_graphs);\n"
"good_g_count := length (sorted_good_graphs);\n"
"if (0 = good_g_count)\n"
"return res;\n"
"graphs_listed := 1;\n"
"}\n"
"vectorbld_init (sorted_bad_graphs);\n"
"foreach (any g in bad_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id ())\n"
"vectorbld_acc (sorted_bad_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_bad_graphs);\n"
"bad_g_count := length (sorted_bad_graphs);\n"
"vectorbld_init (phys_subjects);\n"
"if (isinteger (storage_name))\n"
"storage_name := \'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadStorage\';\n"
"else if (\'\' = storage_name)\n"
"{\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s, phys_s any;\n"
"s := all_subjs [s_ctr];\n"
"if (isiri_id (s))\n"
"vectorbld_acc (phys_subjects, s);\n"
"else\n"
"{\n"
"phys_s := iri_to_id (s, 0, 0);\n"
"if (not isinteger (phys_s))\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"}\n"
"vectorbld_final (phys_subjects);\n"
"goto describe_physical_subjects;\n"
"}\n"
"\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s, phys_s, maps any;\n"
"declare maps_len integer;\n"
"s := all_subjs [s_ctr];\n"
"maps := sparql_quad_maps_for_quad (NULL, s, NULL, NULL, storage_name, case (graphs_listed) when 0 then vector() else sorted_good_graphs end, sorted_bad_graphs);\n"
"\n"
"maps_len := length (maps);\n"
"if ((maps_len > 0) and (maps[maps_len-1][0] = UNAME\'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadMap\'))\n"
"{\n"
"if (isiri_id (s))\n"
"{\n"
"phys_s := s;\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"else\n"
"{\n"
"phys_s := iri_to_id (s, 0, 0);\n"
"if (not isinteger (phys_s))\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"maps := subseq (maps, 0, maps_len-1);\n"
"maps_len := maps_len - 1;\n"
"}\n"
"if (maps_len > 0)\n"
"all_subjs [s_ctr] := vector (s, maps);\n"
"else\n"
"all_subjs [s_ctr] := 0;\n"
"\n"
"\n"
"}\n"
"vectorbld_final (phys_subjects);\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s_desc, s, maps any;\n"
"declare map_ctr, maps_len integer;\n"
"declare fname varchar;\n"
"s_desc := all_subjs [s_ctr];\n"
"if (isinteger (s_desc))\n"
"goto end_of_s;\n"
"s := s_desc[0];\n"
"maps := s_desc[1];\n"
"maps_len := length (maps);\n"
"fname := sprintf (\'SPARQL_DESC_DICT_CBD_QMV1_%U\', md5 (storage_name || cast (graphs_listed as varchar) || md5_box (maps) || md5_box (sorted_bad_graphs)));\n"
"if (not exists (select top 1 1 from Db.DBA.SYS_PROCEDURES where P_NAME = \'DB.DBA.\' || fname))\n"
"{\n"
"declare ses, txt, saved_user any;\n"
"ses := string_output ();\n"
"http (\'create procedure DB.DBA.\"\' || fname || \'\" (in subj any, inout subj_dict any, inout next_iter_subjs any, inout res any\', ses);\n"
"if (graphs_listed)\n"
"http (\', inout sorted_good_graphs any\', ses);\n"
"http (\')\\n\', ses);\n"
"http (\'{\\n\', ses);\n"
"http (\'  declare subj_iri varchar;\\n\', ses);\n"
"http (\'  subj_iri := id_to_iri_nosignal (subj);\\n\', ses);\n"
"http (\'  for (sparql define output:valmode \"LONG\" define input:storage <\' || storage_name || \'> \', ses);\n"
"foreach (any g in sorted_bad_graphs) do\n"
"{\n"
"http (\'  define input:named-graph-exclude <\' || id_to_iri_nosignal (g) || \'>\\n\', ses);\n"
"}\n"
"http (\'select ?g1 ?p1 ?o1 ?g2 ?st2\\n\', ses);\n"
"http (\'      where { graph ?g1 {\\n\', ses);\n"
"for (map_ctr := 0; map_ctr < maps_len; map_ctr := map_ctr + 1)\n"
"{\n"
"if (map_ctr > 0) http (\'              union\\n\', ses);\n"
"http (\'              { quad map <\' || maps[map_ctr][0] || \'> { ?:subj_iri ?p1 ?o1 } }\\n\', ses);\n"
"}\n"
"http (\'            }\\n\', ses);\n"
"http (\'          optional { graph ?g2 {\\n\', ses);\n"
"http (\'                  ?st2 a rdf:Statement ; rdf:subject ?:subj_iri ; rdf:predicate ?p1 ; rdf:object ?o1 } }\\n\', ses);\n"
"http (\' } ) do { \', ses);\n"
"http (\'            } } ) do { \', ses);\n"
"if (graphs_listed)\n"
"http (\'      if (position (\"g1\", sorted_good_graphs)) {\\n\', ses);\n"
"http (\'      dict_put (res, vector (subj, \"p1\", \"o1\"), 1);\\n\', ses);\n"
"http (\'      if (isiri_id (\"o1\") and \"o1\" > min_bnode_iri_id() and dict_get (subj_dict, \"o1\") is null)\\n\', ses);\n"
"http (\'        dict_put (next_iter_subjs, \"o1\", 1);\\n\', ses);\n"
"if (graphs_listed)\n"
"http (\'      if (position (\"g2\", sorted_good_graphs)) {\\n\', ses);\n"
"http (\'      if (\"st2\" is not null and dict_get (subj_dict, \"st2\") is null)\\n\', ses);\n"
"http (\'        dict_put (next_iter_subjs, \"o1\", 1);\\n\', ses);\n"
"if (graphs_listed)\n"
"http (\'        } }\\n\', ses);\n"
"http (\'      } } }\\n\', ses);\n"
"txt := string_output_string (ses);\n"
"\n"
"saved_user := user;\n"
"set_user_id (\'dba\', 1);\n"
"exec (txt);\n"
"set_user_id (saved_user);\n"
"}\n"
"if (graphs_listed)\n"
"{\n"
"\n"
"call (\'DB.DBA.\' || fname)(s, subj_dict, next_iter_subjs, res, sorted_good_graphs);\n"
"}\n"
"else\n"
"{\n"
"\n"
"call (\'DB.DBA.\' || fname)(s, subj_dict, next_iter_subjs, res);\n"
"}\n"
"end_of_s: ;\n"
"}\n"
"\n"
"describe_physical_subjects:\n"
"gvector_sort (phys_subjects, 1, 0, 0);\n"
"phys_s_count := length (phys_subjects);\n"
"\n"
"if (0 = phys_s_count)\n"
"return res;\n"
"\n"
"if (graphs_listed)\n"
"{\n"
"gvector_sort (sorted_good_graphs, 1, 0, 0);\n"
"\n"
"for (g_ctr := good_g_count - 1; g_ctr >= 0; g_ctr := g_ctr - 1)\n"
"{\n"
"declare graph any;\n"
"graph := sorted_good_graphs [g_ctr];\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := phys_subjects [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where G = graph and S = subj) do\n"
"{\n"
"\n"
"dict_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 0);\n"
"if (isiri_id (obj1) and obj1 > min_bnode_iri_id() and dict_get (subj_dict, obj1) is null)\n"
"dict_put (next_iter_subjs, obj1, 1);\n"
"for (sparql define output:valmode \"LONG\"\n"
"select ?g2 ?st2 where {\n"
"graph ?g2 {\n"
"?st2 a rdf:Statement ; rdf:subject ?:subj ; rdf:predicate ?:p1 ; rdf:object ?:obj1 } } ) do\n"
"{\n"
"if (position (\"g2\", sorted_good_graphs) and dict_get (subj_dict, \"st2\") is null)\n"
"dict_put (next_iter_subjs, st2, 1);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"}\n"
"else\n"
"{\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := phys_subjects [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where\n"
"0 = position (G, sorted_bad_graphs) and\n"
"S = subj and\n"
"__rgs_ack_cbk (G, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (G, gs_app_uid))) ) do\n"
"{\n"
"\n"
"dict_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 0);\n"
"if (isiri_id (obj1) and obj1 > min_bnode_iri_id() and dict_get (subj_dict, obj1) is null)\n"
"dict_put (next_iter_subjs, obj1, 1);\n"
"for (sparql define output:valmode \"LONG\"\n"
"select ?g2 ?st2 where {\n"
"graph ?g2 {\n"
"?st2 a rdf:Statement ; rdf:subject ?:subj ; rdf:predicate ?:p1 ; rdf:object ?:obj1 } } ) do\n"
"{\n"
"if (0 = position (\"g2\", sorted_bad_graphs) and\n"
"dict_get (subj_dict, \"st2\") is null and\n"
"__rgs_ack_cbk (\"g2\", uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (\"g2\", gs_app_uid))) )\n"
"dict_put (next_iter_subjs, st2, 1);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"ret_or_next_iter:\n"
"if (0 = dict_size (next_iter_subjs))\n"
"{\n"
"\n"
"return res;\n"
"}\n"
"all_subjs := dict_list_keys (next_iter_subjs, 1);\n"
"foreach (IRI_ID s in all_subjs) do dict_put (subj_dict, s, 1);\n"
"goto next_iteration;\n"
"}\n"
"--src sparql.sql:5589\n";

static const char *proc185 = 
"create procedure DB.DBA.SPARQL_DESC_DICT_CBD_PHYSICAL (in subj_dict any, in consts any, in good_graphs any, in bad_graphs any, in storage_name any, in options any)\n"
"{\n"
"declare all_subjs, sorted_good_graphs, sorted_bad_graphs, next_iter_subjs, res any;\n"
"declare uid, graphs_listed, g_ctr, good_g_count, bad_g_count, s_ctr, all_s_count integer;\n"
"declare gs_app_callback, gs_app_uid varchar;\n"
"declare rdf_type_iid IRI_ID;\n"
"uid := get_keyword (\'uid\', options, http_nobody_uid());\n"
"gs_app_callback := get_keyword (\'gs-app-callback\', options);\n"
"if (gs_app_callback is not null)\n"
"gs_app_uid := get_keyword (\'gs-app-uid\', options);\n"
"rdf_type_iid := iri_to_id (UNAME\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\');\n"
"res := dict_new ();\n"
"if (isinteger (consts))\n"
"return res;\n"
"foreach (any c in consts) do\n"
"{\n"
"if (isiri_id (c))\n"
"dict_put (subj_dict, c, 0);\n"
"}\n"
"all_subjs := dict_list_keys (subj_dict, 0);\n"
"next_iter_subjs := dict_new ();\n"
"all_s_count := length (all_subjs);\n"
"if (0 = all_s_count)\n"
"return res;\n"
"\n"
"next_iteration:\n"
"all_s_count := length (all_subjs);\n"
"gvector_sort (all_subjs, 1, 0, 0);\n"
"\n"
"if (__tag of integer = __tag (good_graphs))\n"
"graphs_listed := 0;\n"
"else\n"
"{\n"
"vectorbld_init (sorted_good_graphs);\n"
"foreach (any g in good_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id () and\n"
"__rgs_ack_cbk (g, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (g, gs_app_uid))) )\n"
"vectorbld_acc (sorted_good_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_good_graphs);\n"
"good_g_count := length (sorted_good_graphs);\n"
"if (0 = good_g_count)\n"
"return res;\n"
"graphs_listed := 1;\n"
"}\n"
"vectorbld_init (sorted_bad_graphs);\n"
"foreach (any g in bad_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id ())\n"
"vectorbld_acc (sorted_bad_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_bad_graphs);\n"
"bad_g_count := length (sorted_bad_graphs);\n"
"\n"
"if (0 = all_s_count)\n"
"return res;\n"
"\n"
"if (graphs_listed)\n"
"{\n"
"gvector_sort (sorted_good_graphs, 1, 0, 0);\n"
"\n"
"for (g_ctr := good_g_count - 1; g_ctr >= 0; g_ctr := g_ctr - 1)\n"
"{\n"
"declare graph any;\n"
"graph := sorted_good_graphs [g_ctr];\n"
"for (s_ctr := all_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := all_subjs [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where G = graph and S = subj) do\n"
"{\n"
"\n"
"dict_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 0);\n"
"if (isiri_id (obj1) and obj1 > min_bnode_iri_id() and dict_get (subj_dict, obj1) is null)\n"
"dict_put (next_iter_subjs, obj1, 1);\n"
"for (sparql define output:valmode \"LONG\"\n"
"select ?g2 ?st2 where {\n"
"graph ?g2 {\n"
"?st2 a rdf:Statement ; rdf:subject ?:subj ; rdf:predicate ?:p1 ; rdf:object ?:obj1 } } ) do\n"
"{\n"
"if (position (\"g2\", sorted_good_graphs) and dict_get (subj_dict, \"st2\") is null)\n"
"dict_put (next_iter_subjs, st2, 1);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"}\n"
"else\n"
"{\n"
"for (s_ctr := all_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := all_subjs [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where\n"
"0 = position (G, sorted_bad_graphs) and\n"
"S = subj and\n"
"__rgs_ack_cbk (G, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (G, gs_app_uid))) ) do\n"
"{\n"
"\n"
"dict_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 0);\n"
"if (isiri_id (obj1) and obj1 > min_bnode_iri_id() and dict_get (subj_dict, obj1) is null)\n"
"dict_put (next_iter_subjs, obj1, 1);\n"
"for (sparql define output:valmode \"LONG\"\n"
"select ?g2 ?st2 where {\n"
"graph ?g2 {\n"
"?st2 a rdf:Statement ; rdf:subject ?:subj ; rdf:predicate ?:p1 ; rdf:object ?:obj1 } } ) do\n"
"{\n"
"if (0 = position (\"g2\", sorted_bad_graphs) and\n"
"dict_get (subj_dict, \"st2\") is null and\n"
"__rgs_ack_cbk (\"g2\", uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (\"g2\", gs_app_uid))) )\n"
"dict_put (next_iter_subjs, st2, 1);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"\n"
"ret_or_next_iter:\n"
"if (0 = dict_size (next_iter_subjs))\n"
"{\n"
"\n"
"return res;\n"
"}\n"
"all_subjs := dict_list_keys (next_iter_subjs, 1);\n"
"foreach (IRI_ID s in all_subjs) do dict_put (subj_dict, s, 1);\n"
"goto next_iteration;\n"
"}\n"
"--src sparql.sql:5849\n";

static const char *proc186 = 
" create procedure DB.DBA.RDF_DICT_OF_TRIPLES_TO_THREE_COLS (in dict any, in destructive integer := 0)\n"
"{\n"
"declare ctr, len integer;\n"
"declare O any;\n"
"declare S, P, O_DT, O_LANG varchar;\n"
"declare O_IS_IRI, dt_twobyte, lang_twobyte integer;\n"
"dict := dict_list_keys (dict, destructive);\n"
"result_names (S, P, O\n"
");\n"
"len := length (dict);\n"
"for (ctr := 0; ctr < len; ctr := ctr+1)\n"
"{\n"
"S := id_to_iri (dict[ctr][0]);\n"
"P := id_to_iri (dict[ctr][1]);\n"
"O := dict[ctr][2];\n"
"if (isiri_id (O))\n"
"{\n"
"result (S, P, id_to_iri (O)\n"
");\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"else\n"
"result (S, P, O\n"
");\n"
"}\n"
"}\n"
"--src sparql.sql:5982\n";

static const char *proc187 = 
"create function DB.DBA.RDF_TYPEMIN_OF_OBJ (in obj any) returns any\n"
"{\n"
"declare tag integer;\n"
"if (obj is null)\n"
"return NULL;\n"
"tag := __tag (obj);\n"
"if (tag in (__tag of integer, __tag of double precision, __tag of numeric))\n"
"return -3.40282347e+38;\n"
"if (tag = __tag of datetime)\n"
"return cast (\'0101-01-01\' as datetime);\n"
"if (tag = __tag of rdf_box)\n"
"return rdf_box (\'\', rdf_box_type (obj), 257, 0, 1);\n"
"if (tag = (__tag of varchar))\n"
"return \'\';\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:6023\n";

static const char *proc188 = 
"create function DB.DBA.RDF_TYPEMAX_OF_OBJ (in obj any) returns any\n"
"{\n"
"declare tag integer;\n"
"if (obj is null)\n"
"return NULL;\n"
"tag := __tag (obj);\n"
"if (tag in (__tag of integer, __tag of double precision, __tag of numeric))\n"
"return 3.40282347e+38;\n"
"if (tag = __tag of datetime)\n"
"return cast (\'9999-12-30\' as datetime);\n"
"if (tag = __tag of rdf_box)\n"
"return rdf_box (\'\\377\\377\\377\\377\\377\\377\', rdf_box_type (obj), 257, 0, 1);\n"
"if (tag = (__tag of varchar))\n"
"return \'\\377\\377\\377\\377\\377\\377\';\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:6041\n";

static const char *proc189 = 
"create function DB.DBA.RDF_IID_CMP (in obj1 any, in obj2 any) returns integer\n"
"{\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:6059\n";

static const char *proc190 = 
"create function DB.DBA.RDF_OBJ_CMP (in obj1 any, in obj2 any) returns integer\n"
"{\n"
"declare tag1, tag2 integer;\n"
"if (obj1 is null or obj2 is null)\n"
"return NULL;\n"
"tag1 := __tag (obj1);\n"
"tag2 := __tag (obj2);\n"
"if (tag1 = __tag of rdf_box)\n"
"{\n"
"if (tag2 = __tag of rdf_box)\n"
"{\n"
"if (obj1 = obj2)\n"
"return 0;\n"
"if (rdf_box_type (obj1) <> rdf_box_type (obj2))\n"
"return null;\n"
"if (not rdf_box_is_complete (obj1))\n"
"{\n"
"declare id1 integer;\n"
"declare full1 varchar;\n"
"id1 := rdf_box_ro_id (obj1);\n"
"if (__tag of XML = rdf_box_data_tag (obj1))\n"
"return null;\n"
"full1 := (select case (isnull (RO_LONG)) when 0 then blob_to_string (RO_LONG) else RO_VAL end from DB.DBA.RDF_OBJ where RO_ID = id1);\n"
"if (full1 is null)\n"
"signal (\'RDFXX\', sprintf (\'Integrity violation in DB.DBA.RDF_OBJ_CMP, bad id %d\', id1));\n"
"rdf_box_set_data (obj1, full1, 1);\n"
"}\n"
"if (not rdf_box_is_complete (obj2))\n"
"{\n"
"declare id2 integer;\n"
"declare full2 varchar;\n"
"id2 := rdf_box_ro_id (obj2);\n"
"if (__tag of XML = rdf_box_data_tag (obj2))\n"
"return null;\n"
"full2 := (select case (isnull (RO_LONG)) when 0 then blob_to_string (RO_LONG) else RO_VAL end from DB.DBA.RDF_OBJ where RO_ID = id2);\n"
"if (full2 is null)\n"
"signal (\'RDFXX\', sprintf (\'Integrity violation in DB.DBA.RDF_OBJ_CMP, bad id %d\', id2));\n"
"rdf_box_set_data (obj2, full2, 1);\n"
"}\n"
"return rdf_box_strcmp (obj1, obj2);\n"
"}\n"
"return null;\n"
"}\n"
"if (tag1 in (__tag of integer, __tag of double precision, __tag of numeric))\n"
"{\n"
"if (tag2 in (__tag of integer, __tag of double precision, __tag of numeric))\n"
"{\n"
"if (obj1 <> obj2)\n"
"{\n"
"if (obj1 < obj2)\n"
"return -1;\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"return null;\n"
"}\n"
"if (tag1 = __tag of datetime)\n"
"{\n"
"if (tag2 = __tag of datetime)\n"
"{\n"
"if (obj1 <> obj2)\n"
"{\n"
"if (obj1 < obj2)\n"
"return -1;\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"return null;\n"
"}\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:6065\n";

static const char *proc191 = 
"create function DB.DBA.RDF_LONG_CMP (in long1 any, in long2 any) returns integer\n"
"{\n"
"declare tag1, tag2 integer;\n"
"if (long1 is null or long2 is null)\n"
"return NULL;\n"
"tag1 := __tag (long1);\n"
"tag2 := __tag (long2);\n"
"if (tag1 = __tag of rdf_box)\n"
"{\n"
"if (tag2 = __tag of rdf_box)\n"
"return rdf_box_strcmp (long1, long2);\n"
"return null;\n"
"}\n"
"if (tag1 in (__tag of integer, __tag of double precision, __tag of numeric))\n"
"{\n"
"if (tag2 in (__tag of integer, __tag of double precision, __tag of numeric))\n"
"{\n"
"if (long1 <> long2)\n"
"{\n"
"if (long1 < long2)\n"
"return -1;\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"return null;\n"
"}\n"
"if (tag1 = __tag of datetime)\n"
"{\n"
"if (tag2 = __tag of datetime)\n"
"{\n"
"if (long1 <> long2)\n"
"{\n"
"if (long1 < long2)\n"
"return -1;\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"return null;\n"
"}\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:6140\n";

static const char *proc192 = 
" create function DB.DBA.RDF_DIST_SER_LONG (in val any) returns any\n"
"{\n"
"if (not (isstring (val)))\n"
"{\n"
"if (__tag of rdf_box = __tag (val))\n"
"{\n"
"if (rdf_box_is_storeable (val))\n"
"return serialize (val);\n"
"return serialize (vector (rdf_box_data (val), rdf_box_type (val), rdf_box_lang (val), rdf_box_is_complete (val)));\n"
"}\n"
"return serialize (val);\n"
"}\n"
"if (\'\' = val)\n"
"return val;\n"
"if (val[0] < 128)\n"
"return val;\n"
"return serialize (val);\n"
"}\n"
"--src sparql.sql:6187\n";

static const char *proc193 = 
" create function DB.DBA.RDF_DIST_DESER_LONG (in strg any) returns any\n"
"{\n"
"if (not (isstring (strg)))\n"
"return strg;\n"
"if (\'\' = strg)\n"
"return strg;\n"
"if (strg[0] < 128)\n"
"return strg;\n"
"declare res any;\n"
"res := deserialize (strg);\n"
"if (__tag of vector <> __tag (res))\n"
"return res;\n"
"return rdf_box (res[0], res[1], res[2], 0, res[3]);\n"
"}\n"
"--src sparql.sql:6208\n";

static const char *proc194 = 
"create function JSO_MAKE_INHERITANCE (in jgraph varchar, in class varchar, in rootinst varchar, in destinst varchar, in dest_iid iri_id, inout noinherits any, inout inh_stack any)\n"
"{\n"
"declare base_iid iri_id;\n"
"declare baseinst, \"pred\" varchar;\n"
"\n"
"inh_stack := vector_concat (inh_stack, vector (destinst));\n"
"baseinst := null;\n"
"if (not exists (sparql\n"
"define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"ask where {\n"
"graph ?:jgraph { ?:dest_iid rdf:type `iri(?:class)`\n"
"} } ) )\n"
"signal (\'22023\', \'JSO_MAKE_INHERITANCE has not found object <\' || destinst || \'> of type <\' || class || \'>\');\n"
"/* This fails. !!!TBD: fix sparql2sql.c to preserve data about equalities, fixed values and globals when triples are moved from gp to gp\n"
"for (sparql\n"
"define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?srcinst\n"
"where {\n"
"graph ?:jgraph {\n"
"{ {\n"
"?destnode rdf:type `iri(?:class)` .\n"
"filter (?destnode = iri(?:destinst)) }\n"
"union\n"
"{\n"
"?destnode rdf:type `iri(?:class)` .\n"
"?destnode rdf:name `iri(?:destinst)` } } .\n"
"?destnode virtrdf:inheritFrom ?srcinst .\n"
"?srcinst rdf:type `iri(?:class)` .\n"
"} } ) do\n"
"*/\n"
"for (sparql\n"
"define input:storage \"\"\n"
"define output:valmode \"LONG\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?src_iid\n"
"where {\n"
"graph ?:jgraph { ?:dest_iid virtrdf:inheritFrom ?src_iid } } ) do\n"
"{\n"
"declare srcinst varchar;\n"
"srcinst := id_to_iri_nosignal (\"src_iid\");\n"
"if (baseinst is null)\n"
"{\n"
"if (not exists (sparql\n"
"define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"ask where { graph ?:jgraph { ?:\"src_iid\" rdf:type `iri(?:class)` } } ) )\n"
"signal (\'22023\', \'JSO_MAKE_INHERITANCE has found that the object <\' || destinst || \'> has wrong virtrdf:inheritFrom <\' || srcinst || \'> that is not an instance of type <\' || class || \'>\');\n"
"base_iid := \"src_iid\";\n"
"baseinst := srcinst;\n"
"}\n"
"else if (baseinst <> srcinst)\n"
"signal (\'22023\', \'JSO_MAKE_INHERITANCE has found that the object <\' || destinst || \'> has multiple virtrdf:inheritFrom declarations: <\' || baseinst || \'> and <\' || srcinst || \'>\');\n"
"}\n"
"if (position (baseinst, inh_stack))\n"
"signal (\'22023\', \'JSO_MAKE_INHERITANCE has found that the object <\' || baseinst || \'> is recursively inherited from itself\');\n"
"/* This fails. !!!TBD: fix sparql2sql.c to preserve data about equalities, fixed values and globals when triples are moved from gp to gp\n"
"for (sparql\n"
"define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?pred\n"
"where {\n"
"graph ?:jgraph {\n"
"{ {\n"
"?destnode rdf:type `iri(?:class)` .\n"
"filter (?destnode = iri(?:destinst)) }\n"
"union\n"
"{\n"
"?destnode rdf:type `iri(?:class)` .\n"
"?destnode rdf:name `iri(?:destinst)` } } .\n"
"?destnode virtrdf:noInherit ?pred .\n"
"} } ) do\n"
"*/\n"
"for (sparql\n"
"define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?pred\n"
"where {\n"
"graph ?:jgraph {\n"
"?:dest_iid virtrdf:noInherit ?pred\n"
"} } ) do\n"
"{\n"
"if (baseinst is null)\n"
"signal (\'22023\', \'JSO_MAKE_INHERITANCE has found that the object <\' || destinst || \'> has set virtrdf:noInherit but has no virtrdf:inheritFrom\');\n"
"dict_put (noinherits, \"pred\", destinst);\n"
"}\n"
"if (baseinst is null)\n"
"return;\n"
"for (select \"pred_id\", \"predval\"\n"
"from (sparql\n"
"define input:storage \"\"\n"
"define output:valmode \"LONG\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?pred_id, ?predval\n"
"where {\n"
"graph ?:jgraph {\n"
"?:base_iid ?pred_id ?predval\n"
"} } ) as \"t00\"\n"
"where not exists (sparql\n"
"define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"ask where { graph ?:jgraph { ?:\"t00\".\"pred_id\" virtrdf:loadAs virtrdf:jsoTriple } } )\n"
") do\n"
"{\n"
"\"pred\" := id_to_iri (\"pred_id\");\n"
"if (DB.DBA.RDF_LANGUAGE_OF_LONG (\"predval\", null) is not null)\n"
"signal (\'22023\', \'JSO_MAKE_INHERITANCE does not support language marks on objects\');\n"
"if (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\' = \"pred\")\n"
" ;\n"
"else if (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#name\' = \"pred\")\n"
" ;\n"
"else if (\'http://www.openlinksw.com/schemas/virtrdf#inheritFrom\' = \"pred\")\n"
" ;\n"
"else if (\'http://www.openlinksw.com/schemas/virtrdf#noInherit\' = \"pred\")\n"
" ;\n"
"else if (dict_get (noinherits, \"pred\", baseinst) = baseinst)\n"
"{\n"
"jso_set (class, rootinst, \"pred\", __rdf_sqlval_of_obj (\"predval\"), isiri_id (\"predval\"));\n"
"dict_put (noinherits, \"pred\", baseinst);\n"
"}\n"
"}\n"
"JSO_MAKE_INHERITANCE (jgraph, class, rootinst, baseinst, base_iid, noinherits, inh_stack);\n"
"}\n"
"--src sparql.sql:6227\n";

static const char *proc195 = 
"create function JSO_LOAD_INSTANCE (in jgraph varchar, in jinst varchar, in delete_first integer, in make_new integer, in jsubj_iid iri_id := 0)\n"
"{\n"
"declare jinst_iid, jgraph_iid IRI_ID;\n"
"declare jclass varchar;\n"
"declare noinherits, inh_stack, \"p\" any;\n"
"\n"
"noinherits := dict_new ();\n"
"jinst_iid := iri_ensure (jinst);\n"
"jgraph_iid := iri_ensure (jgraph);\n"
"if (jsubj_iid is null)\n"
"{\n"
"jsubj_iid := (sparql\n"
"define input:storage \"\"\n"
"define output:valmode \"LONG\"\n"
"select ?s\n"
"where { graph ?:jgraph { ?s rdf:name ?:jinst } } );\n"
"if (jsubj_iid is null)\n"
"jsubj_iid := jinst_iid;\n"
"}\n"
"jclass := (sparql\n"
"define input:storage \"\"\n"
"select ?t\n"
"where {\n"
"graph ?:jgraph { ?:jsubj_iid rdf:type ?t } } );\n"
"if (jclass is null)\n"
"{\n"
"if (exists (sparql\n"
"define input:storage \"\"\n"
"select ?x\n"
"where { graph ?:jgraph {\n"
"{ ?:jinst ?x ?o }\n"
"union\n"
"{ ?x rdf:name ?ji .\n"
"filter (str (?ji) = ?:jinst)\n"
"} } } ) )\n"
"signal (\'22023\', \'JSO_LOAD_INSTANCE can not detect the type of <\' || jinst || \'>\');\n"
"else\n"
"signal (\'22023\', \'JSO_LOAD_INSTANCE can not find an object <\' || jinst || \'>\');\n"
"}\n"
"if (delete_first)\n"
"jso_delete (jclass, jinst, 1);\n"
"if (make_new)\n"
"jso_new (jclass, jinst);\n"
"for (select \"p_id\", coalesce (\"o2\", \"o1\") as \"o\"\n"
"from (sparql\n"
"define input:storage \"\"\n"
"define output:valmode \"LONG\"\n"
"select ?p_id ?o1 ?o2\n"
"where {\n"
"graph ?:jgraph {\n"
"{ ?:jsubj_iid ?p_id ?o1 }  optional { ?o1 rdf:name ?o2 }\n"
"} }\n"
") as \"t00\"\n"
"where not exists (sparql\n"
"define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"ask where { graph ?:jgraph_iid { ?:\"t00\".\"p_id\" virtrdf:loadAs virtrdf:jsoTriple } } ) option (quietcast)\n"
") do\n"
"{\n"
"\"p\" := id_to_iri (\"p_id\");\n"
"if (DB.DBA.RDF_LANGUAGE_OF_LONG (\"o\", null) is not null)\n"
"signal (\'22023\', \'JSO_LOAD_INSTANCE does not support language marks on objects\');\n"
"if (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\' = \"p\")\n"
"{\n"
"if (__rdf_sqlval_of_obj (\"o\") <> jclass)\n"
"signal (\'22023\', \'JSO_LOAD_INSTANCE has found that the object <\' || jinst || \'> has multiple type declarations\');\n"
"}\n"
"else if (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#name\' = \"p\")\n"
" ;\n"
"else if (\'http://www.openlinksw.com/schemas/virtrdf#inheritFrom\' = \"p\")\n"
" ;\n"
"else if (\'http://www.openlinksw.com/schemas/virtrdf#noInherit\' = \"p\")\n"
" ;\n"
"else\n"
"{\n"
"jso_set (jclass, jinst, \"p\", __rdf_sqlval_of_obj (\"o\"), isiri_id (\"o\"));\n"
"dict_put (noinherits, \"p\", jinst);\n"
"}\n"
"}\n"
"inh_stack := vector ();\n"
"JSO_MAKE_INHERITANCE (jgraph, jclass, jinst, jinst, jsubj_iid, noinherits, inh_stack);\n"
"}\n"
"--src sparql.sql:6353\n";

static const char *proc196 = 
"create procedure JSO_LIST_INSTANCES_OF_GRAPH (in jgraph varchar, out instances any)\n"
"{\n"
"declare md, res, st, msg any;\n"
"st:= \'00000\';\n"
"exec (\n"
"\'select DB.DBA.VECTOR_AGG (\n"
"vector (\n"
"id_to_iri (\"jclass\"),\n"
"id_to_iri (\"jinst\"),\n"
"coalesce (\"s\", \"jinst\") ) )\n"
"from ( sparql\n"
"define output:valmode \"LONG\"\n"
"define input:storage \"\"\n"
"select ?jclass ?jinst ?s\n"
"where {\n"
"graph ?? {\n"
"{ ?jinst rdf:type ?jclass .\n"
"filter (!isBLANK (?jinst)) }\n"
"union\n"
"{ ?s rdf:type ?jclass .\n"
"?s rdf:name ?jinst .\n"
"filter (isBLANK (?s))\n"
"} } }\n"
") as inst\',\n"
"st, msg, vector (jgraph), 1, md, res);\n"
"if (st <> \'00000\') signal (st, msg);\n"
"instances := res[0][0];\n"
"}\n"
"--src sparql.sql:6437\n";

static const char *proc197 = 
"create function JSO_LOAD_GRAPH (in jgraph varchar, in pin_now integer := 1)\n"
"{\n"
"declare jgraph_iid IRI_ID;\n"
"declare instances, chk any;\n"
"\n"
"jgraph_iid := iri_ensure (jgraph);\n"
"JSO_LIST_INSTANCES_OF_GRAPH (jgraph, instances);\n"
"/* Pass 1. Deleting all obsolete instances. */\n"
"foreach (any j in instances) do\n"
"jso_delete (j[0], j[1], 1);\n"
"/* Pass 2. Creating all instances. */\n"
"foreach (any j in instances) do\n"
"jso_new (j[0], j[1]);\n"
"/* Pass 3. Loading all instances, including loading inherited values. */\n"
"foreach (any j in instances) do\n"
"JSO_LOAD_INSTANCE (jgraph, j[1], 0, 0, j[2]);\n"
"/* Pass 4. Validation all instances. */\n"
"foreach (any j in instances) do\n"
"jso_validate (j[0], j[1], 1);\n"
"/* Pass 5. Pin all instances. */\n"
"if (pin_now)\n"
"{\n"
"foreach (any j in instances) do\n"
"jso_pin (j[0], j[1]);\n"
"}\n"
"/* Pass 6. Load all separate triples */\n"
"exec (\'sparql\n"
"define input:storage \"\"\n"
"define sql:table-option \"LOOP\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select (bif:jso_triple_add (?s, ?p, ?o))\n"
"where { graph <\' || id_to_iri (jgraph_iid) || \'> { ?p virtrdf:loadAs virtrdf:jsoTriple . ?s ?p ?o } }\');\n"
"chk := jso_triple_get_objs (\n"
"UNAME\'http://www.openlinksw.com/schemas/virtrdf#loadAs\',\n"
"UNAME\'http://www.openlinksw.com/schemas/virtrdf#loadAs\' );\n"
"if ((1 <> length (chk)) or (cast (chk[0] as varchar) <> \'http://www.openlinksw.com/schemas/virtrdf#jsoTriple\'))\n"
"signal (\'22023\', \'JSO_LOAD_GRAPH has not found expected metadata in the graph\');\n"
"}\n"
"--src sparql.sql:6467\n";

static const char *proc198 = 
"create function JSO_PIN_GRAPH (in jgraph varchar)\n"
"{\n"
"declare instances any;\n"
"JSO_LIST_INSTANCES_OF_GRAPH (jgraph, instances);\n"
"foreach (any j in instances) do\n"
"jso_pin (j[0], j[1]);\n"
"}\n"
"--src sparql.sql:6507\n";

static const char *proc199 = 
" create function JSO_SYS_GRAPH () returns varchar\n"
"{\n"
"return \'http://www.openlinksw.com/schemas/virtrdf#\';\n"
"}\n"
"--src sparql.sql:6517\n";

static const char *proc200 = 
"create procedure JSO_LOAD_AND_PIN_SYS_GRAPH_RO (in graphiri varchar := null)\n"
"{\n"
"if (graphiri is null)\n"
"graphiri := JSO_SYS_GRAPH();\n"
"JSO_LOAD_GRAPH (graphiri, 0);\n"
"JSO_PIN_GRAPH (graphiri);\n"
"}\n"
"--src sparql.sql:6524\n";

static const char *proc201 = 
"create procedure JSO_LOAD_AND_PIN_SYS_GRAPH (in graphiri varchar := null)\n"
"{\n"
"if (graphiri is null)\n"
"graphiri := JSO_SYS_GRAPH();\n"
"commit work;\n"
"JSO_LOAD_GRAPH (graphiri, 0);\n"
"JSO_PIN_GRAPH (graphiri);\n"
"for (select P_NAME from SYS_PROCEDURES\n"
"where (\n"
"(P_NAME like \'DB.DBA.SPARQL_DESC_DICT_QMV1_%\') or\n"
"(P_NAME like \'DB.DBA.SPARQL_DESC_DICT_CBD_QMV1_%\') )\n"
"for update) do\n"
"{\n"
"exec (\'drop procedure DB.DBA.\"\' || subseq (P_NAME, 7) || \'\"\');\n"
"}\n"
"commit work;\n"
"}\n"
"--src sparql.sql:6533\n";

static const char *proc202 = 
"create function JSO_DUMP_IRI (in v varchar, inout ses any)\n"
"{\n"
"\n"
"\n"
"if (v like \'http://www.w3.org/2000/01/rdf-schema#%\')\n"
"{ http (\'rdfs:\' || subseq (v, 37), ses); return; }\n"
"\n"
"\n"
"if (v like \'http://www.w3.org/1999/02/22-rdf-syntax-ns#%\')\n"
"{ http (\'rdf:\' || subseq (v, 43), ses); return; }\n"
"\n"
"\n"
"if (v like \'http://www.w3.org/2002/07/owl#%\')\n"
"{ http (\'owl:\' || subseq (v, 30), ses); return; }\n"
"\n"
"\n"
"if (v like \'http://www.w3.org/2001/XMLSchema#%\')\n"
"{ http (\'xsd:\' || subseq (v, 33), ses); return; }\n"
"\n"
"\n"
"if (v like \'http://www.openlinksw.com/schemas/virtrdf#%\')\n"
"{ http (\'virtrdf:\' || subseq (v, 42), ses); return; }\n"
"\n"
"\n"
"if (v like \'http://www.openlinksw.com/virtrdf-data-formats#%\')\n"
"{ http (\'rdfdf:\' || subseq (v, 47), ses); return; }\n"
"http (\'<\', ses);\n"
"http_escape (v, 12, ses, 1, 1);\n"
"http (\'>\', ses);\n"
"}\n"
"--src sparql.sql:6552\n";

static const char *proc203 = 
"create function JSO_DUMP_FLD (in v any, inout ses any)\n"
"{\n"
"declare v_tag integer;\n"
"v_tag := __tag(v);\n"
"if (v_tag = 217)\n"
"JSO_DUMP_IRI (cast (v as varchar), ses);\n"
"else if (v_tag = 243)\n"
"JSO_DUMP_IRI (id_to_iri (v), ses);\n"
"else if (v_tag = 203)\n"
"http (jso_dbg_dump_rtti (v), ses);\n"
"else if (v_tag = __tag of varchar)\n"
"{\n"
"http (\'\"\', ses);\n"
"http_escape (v, 11, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"else if (isinteger (v))\n"
"http_value (v, 0, ses);\n"
"else if (v_tag = __tag of rdf_box)\n"
"DB.DBA.RDF_LONG_TO_TTL (v, ses);\n"
"else\n"
"{\n"
"http (\'\"\', ses);\n"
"http_escape (__rdf_strsqlval (v), 11, ses, 1, 1);\n"
"http (\'\"^^<\', ses);\n"
"http_escape (cast (__xsd_type (v) as varchar), 12, ses, 1, 1);\n"
"http (\'>\', ses);\n"
"}\n"
"}\n"
"--src sparql.sql:6584\n";

static const char *proc204 = 
"create function DB.DBA.JSO_VECTOR_TO_TTL (inout proplist any) returns any\n"
"{\n"
"declare prev_obj, ses any;\n"
"declare ctr, len integer;\n"
"ses := string_output ();\n"
"len := length (proplist);\n"
"gvector_sort (proplist, 1, 0, 1);\n"
"prev_obj := null;\n"
"for (ctr := 0; ctr < len; ctr := ctr+1)\n"
"{\n"
"declare obj, p, o any;\n"
"declare base IRI_ID;\n"
"obj := proplist[ctr][0];\n"
"p := proplist[ctr][1];\n"
"o := proplist[ctr][2];\n"
"if (obj = prev_obj)\n"
"http (\';\\n  \', ses);\n"
"else\n"
"{\n"
"if (prev_obj is null)\n"
"http (\n"
"\'@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n"
"@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"@prefix owl: <http://www.w3.org/2002/07/owl#> .\n"
"@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n"
"@prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#> .\n"
"@prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#> .\n"
"\', ses );\n"
"else\n"
"http (\'.\\n\', ses);\n"
"prev_obj := obj;\n"
"JSO_DUMP_FLD (obj, ses);\n"
"http (\'\\n  \', ses);\n"
"}\n"
"JSO_DUMP_FLD (p, ses);\n"
"http (\'\\t\', ses);\n"
"JSO_DUMP_FLD (o, ses);\n"
"}\n"
"if (prev_obj is not null)\n"
"http (\'.\\n\', ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6615\n";

static const char *proc205 = 
"create function DB.DBA.JSO_FILTERED_PROPLIST (in only_custom integer := 0, in loading_status integer := 1, in long_valmode integer := 1) returns any\n"
"{\n"
"declare proplist, res any;\n"
"declare sys_dict, sys_inh any;\n"
"declare sys_txt, sys_vect any;\n"
"declare ctr, len integer;\n"
"declare inh_id IRI_ID;\n"
"if (loading_status = 0)\n"
"{\n"
"proplist := ((select DB.DBA.VECTOR_AGG (vector (\"sub\".\"s\", \"sub\".\"p\", \"sub\".\"o\")) from (\n"
"sparql define input:storage \"\" define output:valmode \"LONG\"\n"
"select ?s ?p ?o from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o } ) as \"sub\"));\n"
"}\n"
"else\n"
"{\n"
"proplist := vector_concat (jso_proplist (loading_status), jso_triple_list ());\n"
"}\n"
"gvector_sort (proplist, 1, 0, 1);\n"
"if (not only_custom and not long_valmode)\n"
"return proplist;\n"
"if (only_custom)\n"
"{\n"
"sys_txt := cast ( DB.DBA.XML_URI_GET (\n"
"\'http://www.openlinksw.com/sparql/virtrdf-data-formats.ttl\', \'\' ) as varchar );\n"
"sys_dict := DB.DBA.RDF_TTL2HASH (sys_txt, \'\');\n"
"sys_vect := dict_list_keys (sys_dict, 0);\n"
"\n"
"inh_id := iri_ensure (\'http://www.openlinksw.com/schemas/virtrdf#inheritFrom\');\n"
"sys_inh := dict_new (127);\n"
"foreach (any triple in sys_vect) do\n"
"{\n"
"if (triple[1] = inh_id)\n"
"dict_put (sys_inh, triple[0], triple[2]);\n"
"}\n"
"}\n"
"len := length (proplist);\n"
"vectorbld_init (res);\n"
"for (ctr := 0; ctr < len; ctr := ctr+1)\n"
"{\n"
"declare obj, p, o any;\n"
"declare obj_long, p_long, o_long any;\n"
"declare base IRI_ID;\n"
"obj := proplist[ctr][0];\n"
"p := proplist[ctr][1];\n"
"o := proplist[ctr][2];\n"
"if (217 = __tag (obj))\n"
"obj_long := iri_ensure (obj);\n"
"else\n"
"obj_long := obj;\n"
"if (217 = __tag (p))\n"
"p_long := iri_ensure (p);\n"
"else\n"
"p_long := p;\n"
"if (217 = __tag (o))\n"
"o_long := iri_ensure (o);\n"
"else\n"
"o_long := __rdf_long_of_obj (DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL (o));\n"
"\n"
"if (only_custom)\n"
"{\n"
"if (dict_get (sys_dict, vector (obj_long, p_long, o_long)) is not null)\n"
"goto end_of_step;\n"
"base := dict_get (sys_inh, obj_long);\n"
"if (base is not null and dict_get (sys_dict, vector (base, p_long, o_long)) is not null)\n"
"goto end_of_step;\n"
"}\n"
"if (long_valmode)\n"
"vectorbld_acc (res, vector (obj_long, p_long, o_long));\n"
"else\n"
"vectorbld_acc (res, proplist[ctr]);\n"
"end_of_step: ;\n"
"}\n"
"vectorbld_final (res);\n"
"return res;\n"
"}\n"
"--src sparql.sql:6659\n";

static const char *proc206 = 
"create function DB.DBA.JSO_DUMP_ALL (in only_custom integer := 0, in loading_status integer := 1) returns any\n"
"{\n"
"declare proplist any;\n"
"proplist := DB.DBA.JSO_FILTERED_PROPLIST (only_custom, loading_status, 0);\n"
"return DB.DBA.JSO_VECTOR_TO_TTL (proplist);\n"
"}\n"
"--src sparql.sql:6737\n";

static const char *proc207 = 
"create function DB.DBA.RDF_BACKUP_METADATA (in save_to_file integer := 0, in backup_name varchar := null) returns varchar\n"
"{\n"
"declare proplist any;\n"
"proplist := DB.DBA.JSO_FILTERED_PROPLIST (1, 0, 1);\n"
"if (backup_name is null)\n"
"backup_name := replace (cast (now() as varchar), \' \', \'T\');\n"
"if (save_to_file)\n"
"{\n"
"declare proplist_debug any;\n"
"proplist_debug := DB.DBA.JSO_FILTERED_PROPLIST (0, 0, 1);\n"
"string_to_file (backup_name || \'.ttl\', \'# RDF_BACKUP_METADATA #\\n\', -2);\n"
"string_to_file (backup_name || \'.ttl\', DB.DBA.JSO_VECTOR_TO_TTL (proplist), -1);\n"
"string_to_file (backup_name || \'-DEBUG.ttl\', \'# RDF_BACKUP_METADATA - DEBUG #\\n\', -2);\n"
"string_to_file (backup_name || \'-DEBUG.ttl\', DB.DBA.JSO_VECTOR_TO_TTL (proplist_debug), -1);\n"
"return backup_name || \'.ttl\';\n"
"}\n"
"else\n"
"{\n"
"if (exists (sparql define input:storage \"\" ask where { graph `iri(?:backup_name)` { ?s ?p ?o }}))\n"
"signal (\'22023\', sprintf (\'Can not backup RDF metadata into nonempty graph <%.300s>\', backup_name));\n"
"foreach (any triple in proplist) do\n"
"{\n"
"declare s,p,o any;\n"
"s := triple[0];\n"
"p := triple[1];\n"
"o := triple[2];\n"
"sparql insert into graph iri(?:backup_name) { ?:s ?:p ?:o };\n"
"}\n"
"commit work;\n"
"}\n"
"return backup_name;\n"
"}\n"
"--src sparql.sql:6748\n";

static const char *proc208 = 
"create function DB.DBA.RDF_RESTORE_METADATA (in read_from_file integer, in backup_name varchar) returns any\n"
"{\n"
"declare graphiri_id IRI_ID;\n"
"declare proplist any;\n"
"if (read_from_file)\n"
"{\n"
"declare txt any;\n"
"txt := file_to_string (backup_name);\n"
"if (not (\"LEFT\" (txt, 23) = \'# RDF_BACKUP_METADATA #\'))\n"
"signal (\'22023\', sprintf (\'Can not restore RDF metadata from file %.300s: file does not start with signature \"# RDF_BACKUP_METADATA #\"\', backup_name));\n"
"proplist := dict_list_keys (DB.DBA.RDF_TTL2HASH (txt, \'\'), 1);\n"
"}\n"
"else\n"
"proplist := ((select DB.DBA.VECTOR_AGG (vector (\"sub\".\"s\", \"sub\".\"p\", \"sub\".\"o\")) from (\n"
"sparql define input:storage \"\" define output:valmode \"LONG\"\n"
"select ?s ?p ?o where { graph `iri(?:backup_name)` { ?s ?p ?o } } ) as \"sub\"));\n"
"if (0 = length (proplist))\n"
"signal (\'22023\', sprintf (\'There are no metadata in %.200 to restore\', backup_name));\n"
"graphiri_id := iri_ensure (DB.DBA.JSO_SYS_GRAPH ());\n"
"sparql define input:storage \"\" clear graph ?:graphiri_id;\n"
"commit work;\n"
"DB.DBA.SPARQL_RELOAD_QM_GRAPH ();\n"
"commit work;\n"
"foreach (any triple in proplist) do\n"
"{\n"
"declare sl,pl,ol any;\n"
"sl := triple[0];\n"
"pl := triple[1];\n"
"ol := triple[2];\n"
"if (pl <> iri_ensure (\'http://www.openlinksw.com/schemas/virtrdf#status\'))\n"
"{\n"
"\n"
"sparql define input:storage \"\" insert into graph ?:graphiri_id { ?:sl ?:pl ?:ol };\n"
"}\n"
"}\n"
"commit work;\n"
"DB.DBA.SPARQL_RELOAD_QM_GRAPH ();\n"
"commit work;\n"
"return backup_name;\n"
"}\n"
"--src sparql.sql:6782\n";

static const char *proc209 = 
"create procedure DB.DBA.RDF_AUDIT_METADATA (in fix_bugs integer := 0, in unlocker varchar := null, in graphiri varchar := null, in call_result_names integer := 1)\n"
"{\n"
"declare chksum varchar;\n"
"declare chksum_acc any;\n"
"declare STAT, MSG varchar;\n"
"declare graphiri_id IRI_ID;\n"
"declare all_lists, prev_list, prev_subj any;\n"
"if (call_result_names)\n"
"result_names (STAT, MSG);\n"
"if (graphiri is null)\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"else\n"
"{\n"
"if (graphiri <> DB.DBA.JSO_SYS_GRAPH ())\n"
"result (\'00000\', \'Note: non-default graph IRI <\' || graphiri || \'> is used\');\n"
"}\n"
"graphiri_id := iri_to_id (graphiri);\n"
"vectorbld_init (chksum_acc);\n"
"for (sparql define input:storage \"\"\n"
"select ?st ?trx where { graph ?:graphiri_id {\n"
"?st virtrdf:qsAlterInProgress ?trx } } ) do\n"
"{\n"
"result (\'00000\', \'Quad storage <\' || \"st\" || \'> is flagged as being edited \' || cast (\"trx\" as varchar));\n"
"vectorbld_acc (chksum_acc, vector (\"st\", \"trx\"));\n"
"}\n"
"vectorbld_final (chksum_acc);\n"
"if (length (chksum_acc))\n"
"{\n"
"chksum := md5 (serialize (chksum_acc));\n"
"if ((fix_bugs = 0) or (unlocker is null) or ((chksum <> unlocker) and (unlocker <> \'*\')))\n"
"{\n"
"result (\'42000\', \'Can not process data that are being edited by someone else.\');\n"
"result (\'00000\', \'To force tests/bugfixing, pass 1 as first argument and either \'\'\' || chksum || \'\'\' or \'\'*\'\' as second argument of the DB.DBA.RDF_AUDIT_METADATA() call\');\n"
"return;\n"
"}\n"
"sparql define input:storage \"\"\n"
"delete from graph ?:graphiri_id {\n"
"?st virtrdf:qsAlterInProgress ?trx }\n"
"where { graph ?:graphiri_id {\n"
"?st virtrdf:qsAlterInProgress ?trx } };\n"
"}\n"
"if ((graphiri = DB.DBA.JSO_SYS_GRAPH ()) and fix_bugs)\n"
"{\n"
"declare txt1 varchar;\n"
"declare dict1, lst1 any;\n"
"result (\'00000\', \'Reloading built-in metadata, this might fix some errors without accurate reporting that they did exist\');\n"
"txt1 := cast ( DB.DBA.XML_URI_GET (\n"
"\'http://www.openlinksw.com/sparql/virtrdf-data-formats.ttl\', \'\' ) as varchar );\n"
"dict1 := DB.DBA.RDF_TTL2HASH (txt1, \'\');\n"
"lst1 := dict_list_keys (dict1, 1);\n"
"foreach (any triple in lst1) do\n"
"{\n"
"delete from DB.DBA.RDF_QUAD table option (index RDF_QUAD) where G = graphiri_id and S = triple[0] and P = triple[1];\n"
"}\n"
"DB.DBA.RDF_INSERT_TRIPLES (graphiri_id, lst1);\n"
"commit work;\n"
"result (\'00000\', \'Built-in metadata were reloaded\');\n"
"if (fix_bugs > 1)\n"
"{\n"
"for (sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?s from <http://www.openlinksw.com/schemas/virtrdf#> where {\n"
"?s rdf:type virtrdf:array-of-QuadMap } ) do\n"
"{\n"
"if (DB.DBA.RDF_QM_GC_SUBTREE (\"s\", 1) is null)\n"
"result (\'00000\', \'Quad map array <\' || \"s\" || \'> is not used, removed\');\n"
"}\n"
"for (sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?s from <http://www.openlinksw.com/schemas/virtrdf#> where {\n"
"?s rdf:type virtrdf:QuadMap } ) do\n"
"{\n"
"if (DB.DBA.RDF_QM_GC_MAPPING_SUBTREE (\"s\", 1) is null)\n"
"result (\'00000\', \'Quad map <\' || \"s\" || \'> is not used, removed\');\n"
"}\n"
"for (sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?s from <http://www.openlinksw.com/schemas/virtrdf#> where {\n"
"?s rdf:type virtrdf:array-of-QuadMapFormat } ) do\n"
"{\n"
"if (DB.DBA.RDF_QM_GC_SUBTREE (\"s\", 1) is null)\n"
"result (\'00000\', \'Quad map format array <\' || \"s\" || \'> is not used, removed\');\n"
"}\n"
"for (sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?s from <http://www.openlinksw.com/schemas/virtrdf#> where {\n"
"?s rdf:type virtrdf:QuadMapFormat } ) do\n"
"{\n"
"if (DB.DBA.RDF_QM_GC_SUBTREE (\"s\", 1) is null)\n"
"result (\'00000\', \'Quad map format <\' || \"s\" || \'> is not used, removed\');\n"
"}\n"
"}\n"
"}\n"
"for (select * from (sparql define input:storage \"\" define output:valmode \"LONG\"\n"
"select ?lst ?p ?itm where { graph ?:graphiri_id {\n"
"?lst ?p ?itm .\n"
"optional { ?itm a ?t } .\n"
"filter (! bound (?t) && isiri (?itm) && str(?p) > str(rdf:_) && str(?p) < str(rdf:_A))\n"
"} } ) as sub for update) do\n"
"{\n"
"result (\'00000\', \'List <\' || id_to_iri(\"lst\") || \'> contains IRI <\' || id_to_iri(\"itm\") || \'> that has no type\');\n"
"if (fix_bugs)\n"
"{\n"
"sparql define input:storage \"\"\n"
"delete from graph ?:graphiri_id { ?:\"lst\" ?:\"p\" ?:\"itm\" };\n"
"}\n"
"}\n"
"vectorbld_init (all_lists);\n"
"prev_subj := #i0;\n"
"for (\n"
"select \"sub\".\"lst\", cast (\"sub\".\"idx\" as integer) as \"idx\", serialize (\"sub\".\"itm\") as \"itmsz\", \"sub\".\"itmstr\", \"sub\".\"itmislit\", \"sub\".\"t\"\n"
"from (sparql define input:storage \"\" define output:valmode \"LONG\"\n"
"select ?lst\n"
"(bif:aref (bif:sprintf_inverse (str(?p),\n"
"bif:concat (str (rdf:_), \"%d\"), 2 ),\n"
"0 ) ) as ?idx\n"
"?itm\n"
"(str(?itm)) as ?itmstr\n"
"(isliteral(?itm)) as ?itmislit\n"
"?t\n"
"where { graph ?:graphiri_id {\n"
"?lst ?p ?itm .\n"
"optional { ?itm a ?t } .\n"
"filter (\n"
"str(?p) > str(rdf:_) && str(?p) < str(rdf:_A))\n"
"} } ) as \"sub\"\n"
"order by 1, 2, 3, 4 ) do\n"
"{\n"
"if (prev_subj <> \"lst\")\n"
"{\n"
"if (prev_subj <> #i0)\n"
"{\n"
"vectorbld_final (prev_list);\n"
"vectorbld_acc (all_lists, vector (prev_subj, prev_list));\n"
"}\n"
"prev_subj := \"lst\";\n"
"vectorbld_init (prev_list);\n"
"}\n"
"vectorbld_acc (prev_list, vector (\"idx\", deserialize(\"itmsz\"), \"itmstr\", \"itmislit\", \"t\"));\n"
"}\n"
"if (prev_subj <> #i0)\n"
"{\n"
"vectorbld_final (prev_list);\n"
"vectorbld_acc (all_lists, vector (prev_subj, prev_list));\n"
"}\n"
"vectorbld_final (all_lists);\n"
"foreach (any pair in all_lists) do\n"
"{\n"
"declare subj, items any;\n"
"declare pos, len, last_idx, list_needs_rebuild integer;\n"
"list_needs_rebuild := 0;\n"
"last_idx := 0;\n"
"subj := pair[0];\n"
"items := pair[1];\n"
"len := length (items);\n"
"last_idx := 0;\n"
"for (pos := 0; pos < len; pos := pos+1)\n"
"{\n"
"declare curr_idx integer;\n"
"curr_idx := items[pos][0];\n"
"if (curr_idx <= last_idx)\n"
"{\n"
"result (\'42000\', sprintf (\'Item rdf:_%d is out of order in list <%s>\', curr_idx, id_to_iri (subj)));\n"
"list_needs_rebuild := 1;\n"
"}\n"
"else if ((last_idx + 3) < curr_idx)\n"
"{\n"
"result (\'42000\', sprintf (\'Items rdf:_%d to rdf:_%d are not set in list <%s>\', last_idx + 1, curr_idx - 1, id_to_iri (subj)));\n"
"list_needs_rebuild := 1;\n"
"}\n"
"else\n"
"{\n"
"while ((last_idx + 1) < curr_idx)\n"
"{\n"
"result (\'42000\', sprintf (\'Item rdf:_%d is not set in list <%s>\', last_idx + 1, id_to_iri (subj)));\n"
"last_idx := last_idx + 1;\n"
"list_needs_rebuild := 1;\n"
"}\n"
"}\n"
"last_idx := curr_idx;\n"
"}\n"
"if (fix_bugs and list_needs_rebuild)\n"
"{\n"
"for (pos := 0; pos < len; pos := pos+1)\n"
"{\n"
"declare curr_idx integer;\n"
"curr_idx := items[pos][0];\n"
"sparql define input:storage \"\"\n"
"delete from graph ?:graphiri_id {\n"
"`iri(?:subj)` ?p ?o }\n"
"where { graph ?:graphiri_id {\n"
"`iri(?:subj)` ?p ?o .\n"
"filter (?p = iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:curr_idx))) } };\n"
"}\n"
"for (pos := 0; pos < len; pos := pos+1)\n"
"{\n"
"declare curr_idx integer;\n"
"declare obj any;\n"
"declare objstr varchar;\n"
"declare objislit integer;\n"
"curr_idx := items[pos][0];\n"
"obj := items[pos][1];\n"
"objstr := items[pos][2];\n"
"objislit := items[pos][3];\n"
"if (objislit)\n"
"{\n"
"sparql define input:storage \"\"\n"
"insert into graph ?:graphiri_id {\n"
"`iri(?:subj)` `iri (bif:sprintf (\"%s%d\", str (rdf:_), 1 + ?:pos))` ?:obj };\n"
"}\n"
"else\n"
"{\n"
"sparql define input:storage \"\"\n"
"insert into graph ?:graphiri_id {\n"
"`iri(?:subj)` `iri (bif:sprintf (\"%s%d\", str (rdf:_), 1 + ?:pos))` `iri(?:objstr)` };\n"
"}\n"
"}\n"
"}\n"
"}\n"
"commit work;\n"
"if ((graphiri = DB.DBA.JSO_SYS_GRAPH ()) and fix_bugs)\n"
"{\n"
"whenever sqlstate \'*\' goto jso_load_failed;\n"
"DB.DBA.JSO_LOAD_AND_PIN_SYS_GRAPH ();\n"
"result (\'00000\', \'Metadata from system graph are cached in memory-resident JSOs (JavaScript Objects)\');\n"
"return;\n"
"}\n"
"return;\n"
"\n"
"jso_load_failed:\n"
"result (__SQL_STATE, __SQL_MESSAGE);\n"
"result (\'42000\', \'The previous error can not be fixed automatically. Sorry.\');\n"
"return;\n"
"}\n"
"--src sparql.sql:6824\n";

static const char *proc210 = 
"create procedure DB.DBA.RDF_QM_CHANGE (in warninglist any)\n"
"{\n"
"declare STATE, MESSAGE varchar;\n"
"result_names (STATE, MESSAGE);\n"
"foreach (any warnings in warninglist) do\n"
"{\n"
"foreach (any warning in warnings) do\n"
"result (warning[0], warning[1]);\n"
"}\n"
"commit work;\n"
"}\n"
"--src sparql.sql:7063\n";

static const char *proc211 = 
"create procedure DB.DBA.RDF_QM_CHANGE_OPT (in cmdlist any)\n"
"{\n"
"declare cmdctr, cmdcount integer;\n"
"declare eaqs varchar;\n"
"declare STATE, MESSAGE varchar;\n"
"cmdcount := length (cmdlist);\n"
"result_names (STATE, MESSAGE);\n"
"eaqs := \'\';\n"
"for (cmdctr := 0; cmdctr < cmdcount; cmdctr := cmdctr + 1)\n"
"{\n"
"declare cmd, exectext, arglist, warnings,md,rs any;\n"
"declare argctr, argcount integer;\n"
"cmd := cmdlist[cmdctr];\n"
"exectext := string_output();\n"
"http (\'select \', exectext);\n"
"http_value (cmd[0], 0, exectext);\n"
"http (\' (\', exectext);\n"
"if (length (cmd) > 2)\n"
"arglist := vector_concat (cmd[1], vector (cmd[2]));\n"
"else\n"
"arglist := cmd[1];\n"
"argcount := length (arglist);\n"
"for (argctr := 0; argctr < argcount; argctr := argctr + 1)\n"
"{\n"
"if (argctr > 0)\n"
"http (\',\', exectext);\n"
"http (\'?\', exectext);\n"
"}\n"
"http (\')\', exectext);\n"
"STATE := \'00000\';\n"
"warnings := exec (string_output_string (exectext), STATE, MESSAGE, arglist, md, rs);\n"
"\n"
"if (__tag of vector = __tag (warnings))\n"
"{\n"
"foreach (any warning in warnings) do\n"
"result (warning[0], warning[1]);\n"
"}\n"
"commit work;\n"
"if (STATE <> \'00000\')\n"
"{\n"
"result (STATE, MESSAGE);\n"
"if (\'\' <> eaqs)\n"
"exec (\'DB.DBA.RDF_QM_END_ALTER_QUAD_STORAGE (?)\', STATE, MESSAGE, vector (eaqs));\n"
"DB.DBA.RDF_AUDIT_METADATA (1, null, null, 0);\n"
"return;\n"
"}\n"
"if (UNAME\'DB.DBA.RDF_QM_BEGIN_ALTER_QUAD_STORAGE\' = cmd[0])\n"
"eaqs := arglist[0];\n"
"else if (UNAME\'DB.DBA.RDF_QM_END_ALTER_QUAD_STORAGE\' = cmd[0])\n"
"eaqs := \'\';\n"
"}\n"
"result (\'00000\', sprintf (\'%d RDF metadata manipulation operations done\', cmdcount));\n"
"}\n"
"--src sparql.sql:7076\n";

static const char *proc212 = 
"create function DB.DBA.RDF_QM_APPLY_CHANGES (in deleted any, in affected any) returns any\n"
"{\n"
"declare ctr, len integer;\n"
"commit work;\n"
"DB.DBA.JSO_LOAD_AND_PIN_SYS_GRAPH ();\n"
"len := length (deleted);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 2)\n"
"jso_delete (deleted [ctr], deleted [ctr+1], 1);\n"
"len := length (affected);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 1)\n"
"jso_mark_affected (affected [ctr]);\n"
"return vector (vector (\'00000\', \'Transaction committed, SPARQL compiler re-configured\'));\n"
"}\n"
"--src sparql.sql:7131\n";

static const char *proc213 = 
"create function DB.DBA.RDF_QM_ASSERT_JSO_TYPE (in inst varchar, in expected varchar, in allow_missing integer := 0) returns integer\n"
"{\n"
"declare actual varchar;\n"
"if (expected is null)\n"
"{\n"
"actual := coalesce ((sparql\n"
"define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?t where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> { `iri(?:inst)` rdf:type ?t } } ));\n"
"if (actual is not null)\n"
"signal (\'22023\', \'The RDF QM schema object <\' || inst || \'> already exists, type <\' || cast (actual as varchar) || \'>\');\n"
"}\n"
"else\n"
"{\n"
"declare hit integer;\n"
"hit := 0;\n"
"for (sparql\n"
"define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?t where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> { `iri(?:inst)` rdf:type ?t } } ) do\n"
"{\n"
"if (\"t\" <> expected)\n"
"signal (\'22023\', \'The RDF QM schema object <\' || inst || \'> has type <\' || cast (actual as varchar) || \'>, cannot use same identifier for <\' || expected || \'>\');\n"
"hit := 1;\n"
"}\n"
"if (not hit)\n"
"{\n"
"if (allow_missing)\n"
"return 0;\n"
"signal (\'22023\', \'The RDF QM schema object <\' || inst || \'> does not exist, should be of type <\' || expected || \'>\');\n"
"}\n"
"}\n"
"return 1;\n"
"}\n"
"--src sparql.sql:7146\n";

static const char *proc214 = 
"create procedure DB.DBA.RDF_QM_ASSERT_STORAGE_FLAG (in storage varchar, in req_flag integer)\n"
"{\n"
"declare graphiri varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (storage, \'http://www.openlinksw.com/schemas/virtrdf#QuadStorage\');\n"
"for (sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"select ?startdt where {\n"
"graph ?:graphiri {\n"
"`iri(?:storage)` virtrdf:qsAlterInProgress ?startdt .\n"
"} } ) do\n"
"{\n"
"if (req_flag)\n"
"return;\n"
"signal (\'22023\', \'The quad storage \"\' || storage || \'\" is edited by other client, started \' || cast (\"startdt\" as varchar));\n"
"}\n"
"if (not req_flag)\n"
"return;\n"
"signal (\'22023\', \'The quad storage \"\' || storage || \'\" is not flagged as being edited, cannot change it\' );\n"
"}\n"
"--src sparql.sql:7184\n";

static const char *proc215 = 
"create procedure DB.DBA.RDF_QM_ASSERT_STORAGE_CONTAINS_MAPPING (in storage varchar, in qmid varchar, in must_contain integer)\n"
"{\n"
"declare graphiri varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"if (exists (sparql define input:storage \"\"\n"
"ask where {\n"
"graph ?:graphiri {\n"
"{ `iri(?:storage)` virtrdf:qsDefaultMap `iri(?:qmid)` }\n"
"union\n"
"{ `iri(?:storage)` virtrdf:qsUserMaps ?qmlist .\n"
"?qmlist ?p `iri(?:qmid)` .\n"
"} } } ) )\n"
"{\n"
"if (must_contain)\n"
"return;\n"
"signal (\'22023\', \'The quad storage \"\' || storage || \'\" contains quad map \' || qmid );\n"
"}\n"
"if (not must_contain)\n"
"return;\n"
"signal (\'22023\', \'The quad storage \"\' || storage || \'\" does not contains quad map \' || qmid );\n"
"}\n"
"--src sparql.sql:7206\n";

static const char *proc216 = 
"create procedure DB.DBA.RDF_QM_ASSERT_STORAGE_IS_FLAGGED (in storage varchar)\n"
"{\n"
"if (not DB.DBA.RDF_QM_GET_STORAGE_FLAG (storage))\n"
"signal (\'22023\', \'The quad storage \"\' || storage || \'\" is not flagged as being edited\' );\n"
"}\n"
"--src sparql.sql:7229\n";

static const char *proc217 = 
"create function DB.DBA.RDF_QM_GC_SUBTREE (in seed any, in quick_gc_only integer := 0) returns integer\n"
"{\n"
"declare graphiri varchar;\n"
"declare seed_id, graphiri_id, subjs, objs any;\n"
"declare o_to_s, s_to_o any;\n"
"declare subjs_of_o, objs_of_s any;\n"
"set isolation = \'serializable\';\n"
"\n"
"o_to_s := dict_new ();\n"
"s_to_o := dict_new ();\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"graphiri_id := iri_to_id (graphiri);\n"
"seed_id := iri_to_id (seed);\n"
"for (sparql define input:storage \"\"\n"
"define output:valmode \"LONG\"\n"
"select ?s\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s virtrdf:item ?:seed_id } ) do\n"
"{\n"
"\n"
"return \"s\";\n"
"}\n"
"for (sparql define input:storage \"\"\n"
"define output:valmode \"LONG\"\n"
"select ?s\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s a [] ; ?p ?:seed_id } ) do\n"
"{\n"
"\n"
"if (quick_gc_only)\n"
"return \"s\";\n"
"goto do_full_gc;\n"
"}\n"
"vectorbld_init (objs_of_s);\n"
"for (sparql define input:storage \"\"\n"
"define output:valmode \"LONG\"\n"
"define sql:table-option \"LOOP\"\n"
"select ?o\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?:seed_id a [] ; ?p ?o . ?o a [] } ) do\n"
"{\n"
"vectorbld_acc (objs_of_s, \"o\");\n"
"}\n"
"vectorbld_final (objs_of_s);\n"
"\n"
"delete from DB.DBA.RDF_QUAD where G = graphiri_id and S = seed_id;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s virtrdf:isSubClassOf ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s virtrdf:isSubClassOf ?o . filter (?o = iri(?:seed_id)) };\n"
"\n"
"commit work;\n"
"foreach (IRI_ID descendant in objs_of_s) do\n"
"{\n"
"DB.DBA.RDF_QM_GC_SUBTREE (descendant, 1);\n"
"}\n"
"\n"
"return null;\n"
"\n"
"do_full_gc:\n"
"for (sparql define input:storage \"\"\n"
"define output:valmode \"LONG\"\n"
"define sql:table-option \"LOOP\"\n"
"select ?s ?o\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s a [] ; ?p ?o . ?o a [] } ) do\n"
"{\n"
"\n"
"subjs_of_o := dict_get (o_to_s, \"o\", NULL);\n"
"if (subjs_of_o is null)\n"
"dict_put (o_to_s, \"o\", vector (\"s\"));\n"
"else if (0 >= position (\"s\", subjs_of_o))\n"
"dict_put (o_to_s, \"o\", vector_concat (vector (\"s\"), subjs_of_o));\n"
"objs_of_s := dict_get (s_to_o, \"s\", NULL);\n"
"if (objs_of_s is null)\n"
"dict_put (s_to_o, \"s\", vector (\"o\"));\n"
"else if (0 >= position (\"o\", objs_of_s))\n"
"dict_put (s_to_o, \"s\", vector_concat (vector (\"o\"), objs_of_s));\n"
"}\n"
"subjs := vector (seed_id);\n"
"again:\n"
"vectorbld_init (objs);\n"
"foreach (IRI_ID nod in subjs) do\n"
"{\n"
"\n"
"declare subjs_of_nod, objs_of_nod any;\n"
"subjs_of_nod := dict_get (o_to_s, nod, NULL);\n"
"if (subjs_of_nod is not null)\n"
"{\n"
"\n"
"if (nod = seed_id)\n"
"return subjs_of_nod[0];\n"
"goto nop_nod;\n"
"}\n"
"\n"
"\n"
"\n"
"delete from DB.DBA.RDF_QUAD where G = graphiri_id and S = nod;\n"
"objs_of_nod := dict_get (s_to_o, nod, NULL);\n"
"dict_remove (s_to_o, nod);\n"
"foreach (IRI_ID sub in objs_of_nod) do\n"
"{\n"
"declare subjs_of_sub any;\n"
"declare nod_pos integer;\n"
"subjs_of_sub := dict_get (o_to_s, sub, NULL);\n"
"nod_pos := position (nod, subjs_of_sub);\n"
"if (0 < nod_pos)\n"
"subjs_of_sub := vector_concat (subseq (subjs_of_sub, 0, nod_pos - 1), subseq (subjs_of_sub, nod_pos));\n"
"if (0 = length (subjs_of_sub))\n"
"{\n"
"\n"
"dict_remove (o_to_s, sub);\n"
"vectorbld_acc (objs, sub);\n"
"}\n"
"else\n"
"{\n"
"dict_put (o_to_s, sub, subjs_of_sub);\n"
"\n"
"}\n"
"}\n"
"nop_nod: ;\n"
"}\n"
"vectorbld_final (objs);\n"
"if (0 < length (objs))\n"
"{\n"
"\n"
"subjs := objs;\n"
"goto again;\n"
"}\n"
"\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:7236\n";

static const char *proc218 = 
"create function DB.DBA.RDF_QM_GC_MAPPING_SUBTREE (in mapname any, in quick_gc integer) returns any\n"
"{\n"
"declare gc_res, submaps any;\n"
"submaps := (select DB.DBA.VECTOR_AGG (s1.\"subm\") from (\n"
"sparql define input:storage \"\"\n"
"select ?subm where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:mapname)` virtrdf:qmUserSubMaps ?submlist .\n"
"?submlist ?p ?subm } } ) as s1 );\n"
"gc_res := DB.DBA.RDF_QM_GC_SUBTREE (mapname, quick_gc);\n"
"if (gc_res is not null)\n"
"return gc_res;\n"
"commit work;\n"
"foreach (any submapname in submaps) do\n"
"{\n"
"DB.DBA.RDF_QM_GC_MAPPING_SUBTREE (submapname, quick_gc);\n"
"}\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:7371\n";

static const char *proc219 = 
"create function DB.DBA.RDF_QM_DROP_MAPPING (in storage varchar, in mapname any) returns any\n"
"{\n"
"declare graphiri varchar;\n"
"declare qmid, qmgraph varchar;\n"
"declare silent integer;\n"
"qmid := get_keyword_ucase (\'ID\', mapname, NULL);\n"
"qmgraph := get_keyword_ucase (\'GRAPH\', mapname, NULL);\n"
"silent := get_keyword_ucase (\'SILENT\', mapname, 0);\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"if (qmid is null)\n"
"{\n"
"qmid := coalesce ((sparql\n"
"define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?s from <http://www.openlinksw.com/schemas/virtrdf#> where {\n"
"?s rdf:type virtrdf:QuadMap .\n"
"?s virtrdf:qmGraphRange-rvrFixedValue `iri(?:qmgraph)` .\n"
"?s virtrdf:qmTableName \"\" .\n"
"} ));\n"
"if (qmid is null)\n"
"return vector (vector (\'00100\', \'Quad map for graph <\' || qmgraph || \'> is not found\'));\n"
"}\n"
"else\n"
"{\n"
"if (silent and not exists ((sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"select (1) where {\n"
"graph ?:graphiri {\n"
"`iri(?:qmid)` a ?t } } ) ) )\n"
"return vector (vector (\'00000\', \'Quad map <\' || qmid || \'> does not exist, the DROP statement is ignored due to SILENT option\'));\n"
"}\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (qmid, \'http://www.openlinksw.com/schemas/virtrdf#QuadMap\');\n"
"if (storage is null)\n"
"{\n"
"for (sparql\n"
"define input:storage \"\"\n"
"select ?st where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"{ ?st virtrdf:qsUserMaps ?subm .\n"
"?subm ?p `iri(?:qmid)` }\n"
"union\n"
"{ ?st virtrdf:qsDefaultMap `iri(?:qmid)` }\n"
"} } ) do\n"
"{\n"
"\n"
"DB.DBA.RDF_QM_DELETE_MAPPING_FROM_STORAGE (\"st\", NULL, qmid);\n"
"}\n"
"DB.DBA.RDF_QM_GC_MAPPING_SUBTREE (qmid, 0);\n"
"return vector (vector (\'00000\', \'Quad map <\' || qmid || \'> is deleted\'));\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.RDF_QM_DELETE_MAPPING_FROM_STORAGE (storage, NULL, qmid);\n"
"DB.DBA.RDF_QM_GC_MAPPING_SUBTREE (qmid, 1);\n"
"return vector (vector (\'00000\', \'Quad map <\' || qmid || \'> is no longer used in storage <\' || storage || \'>\'));\n"
"}\n"
"}\n"
"--src sparql.sql:7392\n";

static const char *proc220 = 
"create function DB.DBA.RDF_QM_MACROEXPAND_TEMPLATE (in iritmpl varchar) returns varchar\n"
"{\n"
"declare pos integer;\n"
"pos := strstr (iritmpl, \'^{URIQADefaultHost}^\');\n"
"if (pos is not null)\n"
"{\n"
"declare host varchar;\n"
"host := registry_get (\'URIQADefaultHost\');\n"
"if (not isstring (host))\n"
"signal (\'22023\', \'Can not use ^{URIQADefaultHost}^ in IRI template if there is no DefaultHost parameter in [URIQA] section of Virtuoso configuration file\');\n"
"iritmpl := replace (iritmpl, \'^{URIQADefaultHost}^\', host);\n"
"}\n"
"pos := strstr (iritmpl, \'^{DynamicLocalFormat}^\');\n"
"if (pos is not null)\n"
"{\n"
"declare host varchar;\n"
"host := registry_get (\'URIQADefaultHost\');\n"
"if (not isstring (host))\n"
"signal (\'22023\', \'Can not use ^{DynamicLocalFormat}^ in IRI template if there is no DefaultHost parameter in [URIQA] section of Virtuoso configuration file\');\n"
"\n"
"\n"
"if ((pos > 0) and (pos < 10) and strchr (subseq (iritmpl, 0, pos), \':\') is not null)\n"
"signal (\'22023\', \'Misplaced ^{DynamicLocalFormat}^: its expansion will contain protocol prefix but the template contains one already\');\n"
"if (strchr (host, \':\') is not null)\n"
"iritmpl := replace (iritmpl, \'^{DynamicLocalFormat}^\', \'http://%{WSHostName}U:%{WSHostPort}U\');\n"
"else\n"
"iritmpl := replace (iritmpl, \'^{DynamicLocalFormat}^\', \'http://%{WSHost}U\');\n"
"}\n"
"pos := strstr (iritmpl, \'^{\');\n"
"if (pos is not null)\n"
"{\n"
"declare pos2 integer;\n"
"pos2 := strstr (subseq (iritmpl, pos), \'^}\');\n"
"if (pos2 is not null)\n"
"signal (\'22023\', \'The macro \' || subseq (iritmpl, pos, pos + pos2 + 2) || \' is not known, supported names are ^{URIQADefaultHost}^ and ^{DynamicLocalFormat}^\');\n"
"}\n"
"return iritmpl;\n"
"}\n"
"--src sparql.sql:7451\n";

static const char *proc221 = 
"create function DB.DBA.RDF_QM_CBD_OF_IRI_CLASS (in classiri varchar) returns any\n"
"{\n"
"declare descr any;\n"
"descr := ((sparql define input:storage \"\"\n"
"construct {\n"
"<class> ?cp ?co .\n"
"<class> virtrdf:qmfValRange-rvrSprintffs <sprintffs> .\n"
"<sprintffs> ?sffp ?sffo .\n"
"<class> virtrdf:qmfSuperFormats <sups> .\n"
"<sups> ?supp ?supo . }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where {\n"
"{\n"
"`iri(?:classiri)` ?cp ?co .\n"
"filter (!(?cp in (virtrdf:qmfValRange-rvrSprintffs, virtrdf:qmfSuperFormats)))\n"
"} union {\n"
"`iri(?:classiri)` virtrdf:qmfValRange-rvrSprintffs ?sffs .\n"
"optional { ?sffs ?sffp ?sffo . }\n"
"} union {\n"
"`iri(?:classiri)` virtrdf:qmfSuperFormats ?sups .\n"
"optional { ?sups ?supp ?supo . }\n"
"} } ) );\n"
"descr := dict_list_keys (descr, 2);\n"
"rowvector_digit_sort (descr, 1, 1);\n"
"return descr;\n"
"}\n"
"--src sparql.sql:7491\n";

static const char *proc222 = 
"create function DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FORMAT (in classiri varchar, in iritmpl varchar, in arglist any, in options any, in origclassiri varchar := null) returns any\n"
"{\n"
"declare graphiri varchar;\n"
"declare sprintffsid, superformatsid varchar;\n"
"declare basetype, basetypeiri varchar;\n"
"declare bij, deref integer;\n"
"declare sffs, res any;\n"
"declare argctr, arglist_len, isnotnull, sff_ctr, sff_count, bij_sff_count integer;\n"
"declare needs_arg_dtps integer;\n"
"declare arg_dtps varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"bij := get_keyword_ucase (\'BIJECTION\', options, 0);\n"
"deref := get_keyword_ucase (\'DEREF\', options, 0);\n"
"sffs := get_keyword_ucase (\'RETURNS\', options);\n"
"if (sffs is null)\n"
"sffs := vector (iritmpl);\n"
"sff_count := length (sffs);\n"
"iritmpl := DB.DBA.RDF_QM_MACROEXPAND_TEMPLATE (iritmpl);\n"
"sprintffsid := classiri || \'--Sprintffs\';\n"
"superformatsid := classiri || \'--SuperFormats\';\n"
"res := vector ();\n"
"foreach (any arg in arglist) do\n"
"if (UNAME\'in\' <> arg[0])\n"
"signal (\'22023\', \'Only \"in\" parameters are now supported in argument lists of class formats, \"\' || arg[0] || \'\" is not supported in CREATE IRI CLASS <\' || classiri || \'>\' );\n"
"arglist_len := length (arglist);\n"
"isnotnull := 1;\n"
"needs_arg_dtps := 0;\n"
"arg_dtps := \'\';\n"
"if (arglist_len <> 1)\n"
"{\n"
"declare type_name varchar;\n"
"declare dtp integer;\n"
"if (arglist_len = 0)\n"
"basetype := \'zeropart-uri\';\n"
"else\n"
"basetype := \'multipart-uri\';\n"
"for (argctr := 0; (argctr < arglist_len) and isnotnull; argctr := argctr + 1)\n"
"{\n"
"if (not (coalesce (arglist[argctr][3], 0)))\n"
"isnotnull := 0;\n"
"type_name := lower (arglist[argctr][2]);\n"
"dtp := case (type_name)\n"
"when \'integer\' then __tag of integer\n"
"when \'varchar\' then __tag of varchar\n"
"when \'date\' then __tag of date\n"
"when \'datetime\' then __tag of datetime\n"
"when \'doubleprecision\' then __tag of double precision\n"
"when \'numeric\' then __tag of numeric\n"
"when \'nvarchar\' then __tag of nvarchar\n"
"else 255 end;\n"
"if (type_name = \'nvarchar\')\n"
"needs_arg_dtps := 1;\n"
"arg_dtps := arg_dtps || chr (bit_and (127, dtp));\n"
"}\n"
"}\n"
"else /* arglist is 1 item long */\n"
"{\n"
"basetype := lower (arglist[0][2]);\n"
"if (not (basetype in (\'integer\', \'varchar\', \'date\', \'datetime\', \'doubleprecision\', \'numeric\', \'nvarchar\')))\n"
"signal (\'22023\', \'The datatype \"\' || basetype || \'\" is not supported in CREATE IRI CLASS <\' || classiri || \'>\' );\n"
"basetype := \'sql-\' || basetype || \'-uri\';\n"
"if (not (coalesce (arglist[0][3], 0)))\n"
"isnotnull := 0;\n"
"if (basetype = \'nvarchar\')\n"
"{\n"
"needs_arg_dtps := 1;\n"
"arg_dtps := chr (bit_and (127, __tag of nvarchar));\n"
"}\n"
"}\n"
"if (not isnotnull)\n"
"basetype := basetype || \'-nullable\';\n"
"basetypeiri := \'http://www.openlinksw.com/virtrdf-data-formats#\' || basetype;\n"
"if (origclassiri is null)\n"
"{\n"
"if (isnotnull and (arglist_len > 0))\n"
"{\n"
"declare arglist_copy any;\n"
"if (classiri like \'%-nullable\')\n"
"signal (\'22023\', \'The name of non-nullable IRI class in CREATE IRI CLASS <\' || classiri || \'> is misleading\' );\n"
"arglist_copy := arglist;\n"
"for (argctr := 0; (argctr < arglist_len); argctr := argctr + 1)\n"
"arglist_copy[argctr][3] := 0;\n"
"res := vector_concat (res,\n"
"DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FORMAT (classiri || \'-nullable\', iritmpl, arglist_copy, options, NULL) );\n"
"}\n"
"origclassiri := classiri;\n"
"}\n"
"if (DB.DBA.RDF_QM_ASSERT_JSO_TYPE (classiri, \'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\', 1))\n"
"{\n"
"declare side_s IRI_ID;\n"
"side_s := DB.DBA.RDF_QM_GC_SUBTREE (classiri);\n"
"if (side_s is not null)\n"
"{\n"
"declare tmpname varchar;\n"
"declare old_descr, new_descr any;\n"
"tmpname := uuid();\n"
"{ declare exit handler for sqlstate \'*\' {\n"
"signal (\'22023\', \'Can not change IRI class <\' || classiri || \'> because it is used by other quad map objects, e.g., <\' || id_to_iri_nosignal (side_s) || \'>; moreover, the new declaration may be invalid.\'); };\n"
"DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FORMAT (tmpname, iritmpl, arglist, options, classiri);\n"
"}\n"
"old_descr := DB.DBA.RDF_QM_CBD_OF_IRI_CLASS(classiri);\n"
"new_descr := DB.DBA.RDF_QM_CBD_OF_IRI_CLASS(tmpname);\n"
"if (md5 (serialize (old_descr)) = md5 (serialize (new_descr)))\n"
"{\n"
"sparql define input:storage \"\"\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#>  { `iri(?:tmpname)` ?p ?o }\n"
"where { `iri(?:tmpname)` ?p ?o };\n"
"return vector (vector (\'00000\', \'Previous definition of IRI class <\' || classiri || \'> is identical to the new one, not touched\'));\n"
"}\n"
"signal (\'22023\', \'Can not change IRI class <\' || classiri || \'> because it is used by other quad map objects, e.g., <\' || id_to_iri_nosignal (side_s) || \'>\');\n"
"}\n"
"res := vector_concat (res, vector (vector (\'00000\', \'Previous definition of IRI class <\' || classiri || \'> has been dropped\')));\n"
"}\n"
"else\n"
"res := vector ();\n"
"if (bij)\n"
"{\n"
"if (__sprintff_is_proven_unparseable (iritmpl))\n"
"signal (\'22023\', \'IRI class <\' || classiri || \'> has OPTION (BIJECTION) but its format string can not be unambiguously parsed by sprintf_inverse()\');\n"
"}\n"
"else\n"
"{\n"
"if (__sprintff_is_proven_bijection (iritmpl))\n"
"bij := 1;\n"
"}\n"
"bij_sff_count := 0;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:sprintffsid)) };\n"
"for (sff_ctr := 0; sff_ctr < sff_count; sff_ctr := sff_ctr + 1)\n"
"{\n"
"declare sff varchar;\n"
"sff := sffs [sff_ctr];\n"
"sff := DB.DBA.RDF_QM_MACROEXPAND_TEMPLATE (sff);\n"
"if ((not bij) and __sprintff_is_proven_bijection (sff))\n"
"bij_sff_count := bij_sff_count + 1;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:sprintffsid)`\n"
"`iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:sff_ctr+1))` ?:sff };\n"
"}\n"
"if ((not bij) and (bij_sff_count = sff_count) and (bij_sff_count > 0))\n"
"bij := 1;\n"
"if (not needs_arg_dtps)\n"
"arg_dtps := NULL;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:classiri)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:superformatsid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#>\n"
"{\n"
"`iri(?:classiri)`\n"
"rdf:type virtrdf:QuadMapFormat ;\n"
"virtrdf:inheritFrom `iri(?:basetypeiri)`;\n"
"virtrdf:noInherit virtrdf:qmfName ;\n"
"virtrdf:noInherit virtrdf:qmfCustomString1 ;\n"
"virtrdf:qmfName `bif:concat (?:basetype, \'-user-\', ?:origclassiri)` ;\n"
"virtrdf:qmfCustomString1 ?:iritmpl ;\n"
"virtrdf:qmfColumnCount ?:arglist_len ;\n"
"virtrdf:qmfSuperFormats `iri(?:superformatsid)` ;\n"
"virtrdf:qmfIsBijection ?:bij ;\n"
"virtrdf:qmfDerefFlags ?:deref ;\n"
"virtrdf:qmfArgDtps ?:arg_dtps ;\n"
"virtrdf:qmfValRange-rvrRestrictions\n"
"virtrdf:SPART_VARR_IS_REF ,\n"
"virtrdf:SPART_VARR_IS_IRI ,\n"
"virtrdf:SPART_VARR_SPRINTFF ;\n"
"virtrdf:qmfValRange-rvrSprintffs `iri(?:sprintffsid)` ;\n"
"virtrdf:qmfValRange-rvrSprintffCount ?:sff_count .\n"
"`iri(?:sprintffsid)`\n"
"rdf:type virtrdf:array-of-string .\n"
"`iri(?:superformatsid)`\n"
"rdf:type virtrdf:array-of-QuadMapFormat };\n"
"if (isnotnull and (arglist_len > 0))\n"
"{\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:classiri)`\n"
"virtrdf:qmfValRange-rvrRestrictions\n"
"virtrdf:SPART_VARR_NOT_NULL .\n"
"`iri(?:superformatsid)`\n"
"rdf:_1 `iri(bif:concat (?:classiri, \"-nullable\"))` };\n"
"}\n"
"return vector_concat (res, vector_concat (res, vector (vector (\'00000\', \'IRI class <\' || classiri || \'> has been defined (inherited from rdfdf:\' || basetype || \')\'))));\n"
"}\n"
"--src sparql.sql:7519\n";

static const char *proc223 = 
"create function DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FUNCTIONS (in classiri varchar, in fheaders any, in options any, in origclassiri varchar := null) returns any\n"
"{\n"
"/*\n"
"fheaders is, say,\n"
"vector ( \'\n"
"vector ( \'DB.DBA.RDF_DF_GRANTEE_ID_URI\' ,\n"
"vector (\n"
"vector ( 306,  \'id\' ,  \'integer\' ,  NULL ) ),  \'varchar\' ,  NULL ),\n"
"vector ( \'DB.DBA.RDF_DF_GRANTEE_ID_URI_INVERSE\' ,\n"
"vector (\n"
"vector ( 306,  \'id_iri\' ,  \'varchar\' ,  NULL ) ),  \'integer\' ,  NULL ) ) )\n"
"*/\n"
"declare uriprint any;\n"
"declare uriprintname, uriparsename varchar;\n"
"declare arglist_len, isnotnull integer;\n"
"declare graphiri varchar;\n"
"declare superformatsid varchar;\n"
"declare bij, deref integer;\n"
"declare sffs any;\n"
"declare res any;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"superformatsid := classiri || \'--SuperFormats\';\n"
"bij := get_keyword_ucase (\'BIJECTION\', options, 0);\n"
"deref := get_keyword_ucase (\'DEREF\', options, 0);\n"
"sffs := get_keyword_ucase (\'RETURNS\', options);\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (classiri, NULL);\n"
"DB.DBA.RDF_QM_CHECK_CLASS_FUNCTION_HEADERS (fheaders, 1, 0, \'IRI composing\', \'IRI parsing\', bij, deref);\n"
"uriprint := fheaders[0];\n"
"uriprintname := uriprint[0];\n"
"declare arglist, basetype, basetypeiri varchar;\n"
"arglist := uriprint[1];\n"
"arglist_len := length (arglist);\n"
"if (arglist_len <> 1)\n"
"{\n"
"if (arglist_len = 0)\n"
"basetype := \'zeropart-uri-fn-nullable\';\n"
"else\n"
"basetype := \'multipart-uri-fn-nullable\';\n"
"isnotnull := 0;\n"
"}\n"
"else\n"
"{\n"
"basetype := lower (arglist[0][2]);\n"
"if (not (basetype in (\'integer\', \'varchar\', /* \'date\', \'doubleprecision\', */ \'numeric\', \'nvarchar\')))\n"
"signal (\'22023\', \'The datatype \"\' || basetype || \'\" is not supported in CREATE IRI CLASS <\' || classiri || \'> USING FUNCTION\' );\n"
"basetype := \'sql-\' || basetype || \'-uri-fn\';\n"
"if (coalesce (arglist[0][3], 0))\n"
"isnotnull := 1;\n"
"else\n"
"{\n"
"basetype := basetype || \'-nullable\';\n"
"isnotnull := 0;\n"
"}\n"
"}\n"
"basetypeiri := \'http://www.openlinksw.com/virtrdf-data-formats#\' || basetype;\n"
"if (origclassiri is null)\n"
"origclassiri := classiri;\n"
"if (DB.DBA.RDF_QM_ASSERT_JSO_TYPE (classiri, \'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\', 1))\n"
"{\n"
"declare side_s IRI_ID;\n"
"side_s := DB.DBA.RDF_QM_GC_SUBTREE (classiri);\n"
"if (side_s is not null)\n"
"{\n"
"declare tmpname varchar;\n"
"declare old_descr, new_descr any;\n"
"tmpname := uuid();\n"
"{ declare exit handler for sqlstate \'*\' {\n"
"signal (\'22023\', \'Can not change IRI class <\' || classiri || \'> because it is used by other quad map objects, e.g., <\' || id_to_iri_nosignal (side_s) || \'>; moreover, the new declaration may be invalid.\'); };\n"
"DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FUNCTIONS (tmpname, fheaders, options, classiri);\n"
"}\n"
"old_descr := DB.DBA.RDF_QM_CBD_OF_IRI_CLASS(classiri);\n"
"new_descr := DB.DBA.RDF_QM_CBD_OF_IRI_CLASS(tmpname);\n"
"if (md5 (serialize (old_descr)) = md5 (serialize (new_descr)))\n"
"{\n"
"sparql define input:storage \"\"\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#>  { `iri(?:tmpname)` ?p ?o }\n"
"where { `iri(?:tmpname)` ?p ?o };\n"
"return vector (vector (\'00000\', \'Previous definition of IRI class <\' || classiri || \'> is identical to the new one, not touched\'));\n"
"}\n"
"signal (\'22023\', \'Can not change class <\' || classiri || \'> because it is used by other quad map objects, e.g., <\' || id_to_iri_nosignal (side_s) || \'>\');\n"
"}\n"
"res := vector (vector (\'00000\', \'Previous definition of class <\' || classiri || \'> has been dropped\'));\n"
"}\n"
"else\n"
"res := vector ();\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:classiri)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:superformatsid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:classiri)`\n"
"rdf:type virtrdf:QuadMapFormat;\n"
"virtrdf:inheritFrom `iri(?:basetypeiri)`;\n"
"virtrdf:noInherit virtrdf:qmfName ;\n"
"virtrdf:noInherit virtrdf:qmfCustomString1 ;\n"
"virtrdf:qmfName `bif:concat (?:basetype, \'-user-\', ?:origclassiri)` ;\n"
"virtrdf:qmfColumnCount ?:arglist_len ;\n"
"virtrdf:qmfCustomString1 ?:uriprintname ;\n"
"virtrdf:qmfSuperFormats `iri(?:superformatsid)` ;\n"
"virtrdf:qmfIsBijection ?:bij ;\n"
"virtrdf:qmfDerefFlags ?:deref ;\n"
"virtrdf:qmfValRange-rvrRestrictions\n"
"virtrdf:SPART_VARR_IS_REF ,\n"
"virtrdf:SPART_VARR_IS_IRI ,\n"
"virtrdf:SPART_VARR_IRI_CALC .\n"
"`iri(?:superformatsid)`\n"
"rdf:type virtrdf:array-of-QuadMapFormat };\n"
"if (isnotnull)\n"
"{\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:classiri)`\n"
"virtrdf:qmfValRange-rvrRestrictions\n"
"virtrdf:SPART_VARR_NOT_NULL };\n"
"}\n"
"if (sffs is not null)\n"
"{\n"
"declare sff_count, sff_ctr integer;\n"
"declare sffsid varchar;\n"
"sffsid := classiri || \'--Sprintffs\';\n"
"sff_count := length (sffs);\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:sffsid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:classiri)`\n"
"virtrdf:qmfValRange-rvrRestrictions\n"
"virtrdf:SPART_VARR_SPRINTFF ;\n"
"virtrdf:qmfValRange-rvrSprintffs `iri(?:sffsid)` ;\n"
"virtrdf:qmfValRange-rvrSprintffCount ?:sff_count .\n"
"`iri(?:sffsid)`\n"
"rdf:type virtrdf:array-of-string };\n"
"for (sff_ctr := 0; sff_ctr < sff_count; sff_ctr := sff_ctr + 1)\n"
"{\n"
"declare sff varchar;\n"
"sff := sffs [sff_ctr];\n"
"sff := DB.DBA.RDF_QM_MACROEXPAND_TEMPLATE (sff);\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:sffsid)`\n"
"`iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:sff_ctr+1))` ?:sff };\n"
"}\n"
"}\n"
"return vector_concat (res, vector (vector (\'00000\', \'IRI class <\' || classiri || \'> has been defined (inherited from rdfdf:\' || basetype || \') using \' || uriprintname)));\n"
"}\n"
"--src sparql.sql:7718\n";

static const char *proc224 = 
"create function DB.DBA.RDF_QM_DEFINE_LITERAL_CLASS_FUNCTIONS (in classiri varchar, in fheaders any, in options any, in origclassiri varchar := null) returns any\n"
"{\n"
"/*\n"
"fheaders is identical to DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FUNCTIONS\n"
"*/\n"
"declare uriprint any;\n"
"declare uriprintname, uriparsename varchar;\n"
"declare arglist_len integer;\n"
"declare superformatsid varchar;\n"
"declare res any;\n"
"declare const_dt, dt_expn, const_lang varchar;\n"
"declare bij, deref integer;\n"
"superformatsid := classiri || \'--SuperFormats\';\n"
"const_dt := get_keyword_ucase (\'DATATYPE\', options);\n"
"const_lang := get_keyword_ucase (\'LANG\', options);\n"
"bij := get_keyword_ucase (\'BIJECTION\', options, 0);\n"
"deref := get_keyword_ucase (\'DEREF\', options, 0);\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (classiri, NULL);\n"
"DB.DBA.RDF_QM_CHECK_CLASS_FUNCTION_HEADERS (fheaders, 0, 0, \'LITERAL composing\', \'LITERAL parsing\', bij, deref);\n"
"uriprint := fheaders[0];\n"
"uriprintname := uriprint[0];\n"
"declare arglist, basetype, basetypeiri varchar;\n"
"arglist := uriprint[1];\n"
"arglist_len := length (arglist);\n"
"if (arglist_len <> 1)\n"
"{\n"
"if (arglist_len = 0)\n"
"basetype := \'zeropart-literal-fn-nullable\';\n"
"else\n"
"basetype := \'multipart-literal-fn-nullable\';\n"
"}\n"
"else\n"
"{\n"
"basetype := lower (arglist[0][2]);\n"
"if (not (basetype in (\'integer\', \'varchar\' /*, \'date\', \'doubleprecision\'*/, \'nvarchar\')))\n"
"signal (\'22023\', \'The datatype \"\' || basetype || \'\" is not supported in CREATE IRI CLASS <\' || classiri || \'> USING FUNCTION\' );\n"
"basetype := \'sql-\' || basetype || \'-literal-fn\';\n"
"if (not (coalesce (arglist[0][3], 0)))\n"
"basetype := basetype || \'-nullable\';\n"
"}\n"
"basetypeiri := \'http://www.openlinksw.com/virtrdf-data-formats#\' || basetype;\n"
"if (const_dt is not null)\n"
"dt_expn := \' \' || WS.WS.STR_SQL_APOS (const_dt);\n"
"else\n"
"dt_expn := NULL;\n"
"if (origclassiri is null)\n"
"origclassiri := classiri;\n"
"if (DB.DBA.RDF_QM_ASSERT_JSO_TYPE (classiri, \'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\', 1))\n"
"{\n"
"declare side_s IRI_ID;\n"
"side_s := DB.DBA.RDF_QM_GC_SUBTREE (classiri);\n"
"if (side_s is not null)\n"
"{\n"
"declare tmpname varchar;\n"
"declare old_descr, new_descr any;\n"
"tmpname := uuid();\n"
"{ declare exit handler for sqlstate \'*\' {\n"
"signal (\'22023\', \'Can not change IRI class <\' || classiri || \'> because it is used by other quad map objects, e.g., <\' || id_to_iri_nosignal (side_s) || \'>; moreover, the new declaration may be invalid.\'); };\n"
"DB.DBA.RDF_QM_DEFINE_LITERAL_CLASS_FUNCTIONS (tmpname, fheaders, options, classiri);\n"
"}\n"
"old_descr := DB.DBA.RDF_QM_CBD_OF_IRI_CLASS(classiri);\n"
"new_descr := DB.DBA.RDF_QM_CBD_OF_IRI_CLASS(tmpname);\n"
"if (md5 (serialize (old_descr)) = md5 (serialize (new_descr)))\n"
"{\n"
"sparql define input:storage \"\"\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#>  { `iri(?:tmpname)` ?p ?o }\n"
"where { `iri(?:tmpname)` ?p ?o };\n"
"return vector (vector (\'00000\', \'Previous definition of literal class <\' || classiri || \'> is identical to the new one, not touched\'));\n"
"}\n"
"signal (\'22023\', \'Can not change class <\' || classiri || \'> because it is used by other quad map objects, e.g., <\' || id_to_iri_nosignal (side_s) || \'>\');\n"
"}\n"
"res := vector (vector (\'00000\', \'Previous definition of class <\' || classiri || \'> has been dropped\'));\n"
"}\n"
"else\n"
"res := vector ();\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:classiri)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:superformatsid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:classiri)`\n"
"rdf:type virtrdf:QuadMapFormat ;\n"
"virtrdf:inheritFrom `iri(?:basetypeiri)` ;\n"
"virtrdf:noInherit virtrdf:qmfName ;\n"
"virtrdf:noInherit virtrdf:qmfCustomString1 ;\n"
"virtrdf:qmfName `bif:concat (?:basetype, \'-user-\', ?:origclassiri)` ;\n"
"virtrdf:qmfColumnCount ?:arglist_len ;\n"
"virtrdf:qmfCustomString1 ?:uriprintname ;\n"
"virtrdf:qmfDatatypeOfShortTmpl ?:dt_expn ;\n"
"virtrdf:qmfIsBijection ?:bij ;\n"
"virtrdf:qmfDerefFlags ?:deref ;\n"
"virtrdf:qmfValRange-rvrRestrictions virtrdf:SPART_VARR_IS_LIT ;\n"
"virtrdf:qmfValRange-rvrDatatype ?:const_dt ;\n"
"virtrdf:qmfValRange-rvrLanguage ?:const_lang ;\n"
"virtrdf:qmfSuperFormats `iri(?:superformatsid)` .\n"
"`iri(?:superformatsid)`\n"
"rdf:type virtrdf:array-of-QuadMapFormat };\n"
"if (const_dt is not null)\n"
"{\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:classiri)`\n"
"virtrdf:qmfValRange-rvrRestrictions virtrdf:SPART_VARR_TYPED };\n"
"}\n"
"return vector_concat (res, vector (vector (\'00000\', \'LITERAL class <\' || classiri || \'> has been defined (inherited from rdfdf:\' || basetype || \') using \' || uriprintname)));\n"
"}\n"
"--src sparql.sql:7879\n";

static const char *proc225 = 
" create function DB.DBA.RDF_BAD_CLASS_INV_FUNCTION (inout val any) returns any\n"
"{\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:7997\n";

static const char *proc226 = 
" create function DB.DBA.SQLNAME_NOTATION_TO_NAME (in str varchar) returns varchar\n"
"{\n"
"if (\'\' = str)\n"
"return NULL;\n"
"if (34 = str[0])\n"
"return subseq (str, 1, length (str) - 1);\n"
"return fix_identifier_case (str);\n"
"}\n"
"--src sparql.sql:8004\n";

static const char *proc227 = 
" create function DB.DBA.SQLQNAME_NOTATION_TO_QNAME (in str varchar, in expected_part_count integer) returns varchar\n"
"{\n"
"declare part_ctr, dot_pos integer;\n"
"declare name, res varchar;\n"
"res := \'\';\n"
"part_ctr := 1;\n"
"next_dot:\n"
"dot_pos := strchr (str, \'.\');\n"
"if (dot_pos is not null)\n"
"{\n"
"if (0 = dot_pos)\n"
"{\n"
"if (2 = part_ctr)\n"
"res := res || USER || \'.\';\n"
"else\n"
"return NULL;\n"
"}\n"
"else\n"
"{\n"
"name := DB.DBA.SQLNAME_NOTATION_TO_NAME(subseq (str, 0, dot_pos));\n"
"if (name is null)\n"
"return NULL;\n"
"res := res || name  || \'.\';\n"
"}\n"
"str := subseq (str, dot_pos + 1);\n"
"part_ctr := part_ctr + 1;\n"
"goto next_dot;\n"
"}\n"
"if (expected_part_count <> part_ctr)\n"
"return NULL;\n"
"name := DB.DBA.SQLNAME_NOTATION_TO_NAME (str);\n"
"if (name is null)\n"
"return NULL;\n"
"return res || name;\n"
"}\n"
"--src sparql.sql:8015\n";

static const char *proc228 = 
"create procedure DB.DBA.RDF_QM_CHECK_CLASS_FUNCTION_HEADERS (inout fheaders any, in is_iri_decl integer, in only_one_arg integer, in pdesc varchar, in invdesc varchar, in bij integer, in deref integer)\n"
"{\n"
"declare uriprint any;\n"
"declare uriprintname varchar;\n"
"declare argctr, argcount integer;\n"
"uriprint := fheaders[0];\n"
"uriprintname := uriprint[0];\n"
"argcount := length (uriprint[1]);\n"
"if (only_one_arg and (1 <> length (uriprint[1])))\n"
"signal (\'22023\', pdesc || \' function \"\' || uriprintname || \'\" should have exactly one argument\');\n"
"if (1 = length (fheaders))\n"
"{\n"
"if (bij or deref)\n"
"{\n"
"if (0 = argcount)\n"
"signal (\'22023\',\n"
"sprintf (\'%s function \"%s\" can not be used in a class with OPTION (BIJECTION) or OPTION (DEREF), because it has no arguments.\',\n"
"pdesc, uriprintname ) );\n"
"signal (\'22023\',\n"
"sprintf (\'%s function \"%s\" can not be used in a class with OPTION (BIJECTION) or OPTION (DEREF) without related %d inverse functions\',\n"
"pdesc, uriprintname, argcount ) );\n"
"}\n"
"}\n"
"if (is_iri_decl and (uriprint[2] <> \'varchar\'))\n"
"signal (\'22023\', pdesc || \' function \"\' || uriprintname || \'\" should return varchar, not \' || uriprint[2]);\n"
"foreach (any arg in uriprint[1]) do\n"
"if (UNAME\'in\' <> arg[0])\n"
"signal (\'22023\', \'Only \"in\" parameters are now supported in argument lists of \' || pdesc || \' functions, not \"\' || arg[0] || \'\"\');\n"
"if (argcount <> (length (fheaders) - 1))\n"
"{\n"
"if ((1 <> length (fheaders)) or (0 = argcount))\n"
"signal (\'22023\',\n"
"sprintf (\'%s function \"%s\" has %d arguments but %d inverse functions\',\n"
"pdesc, uriprintname, argcount, (length (fheaders) - 1)\n"
") );\n"
"declare inv any;\n"
"inv := vector (\'DB.DBA.RDF_BAD_CLASS_INV_FUNCTION\', vector (vector (\'in\', \'val\', \'any\', 0)), \'any\', 0);\n"
"fheaders := make_array (1 + argcount, \'any\');\n"
"fheaders[0] := uriprint;\n"
"for (argctr := 0; argctr < argcount; argctr := argctr + 1)\n"
"{\n"
"inv[2] := uriprint[1][argctr][2];\n"
"fheaders[argctr+1] := inv;\n"
"}\n"
"}\n"
"else if (1 = argcount)\n"
"{\n"
"declare uriparsename varchar;\n"
"if (uriprintname like \'%\"\')\n"
"uriparsename := subseq (uriprintname, 0, length (uriprintname)-1) || \'_INVERSE\"\';\n"
"else\n"
"uriparsename := uriprintname || \'_INVERSE\';\n"
"if (fheaders[1][0] <> uriparsename)\n"
"signal (\'22023\', \'Name of \' || invdesc || \' function should be \' || uriparsename || \', not \' || fheaders[1][0] || \', other variants are not supported by the current version\' );\n"
"}\n"
"else\n"
"{\n"
"for (argctr := 0; argctr < argcount; argctr := argctr + 1)\n"
"{\n"
"declare uriparsename varchar;\n"
"if (uriprintname like \'%\"\')\n"
"uriparsename := sprintf (\'%s_INV_%d\"\', subseq (uriprintname, 0, length (uriprintname)-1), argctr+1);\n"
"else\n"
"uriparsename := sprintf (\'%s_INV_%d\', uriprintname, argctr+1);\n"
"if (fheaders[argctr + 1][0] <> uriparsename)\n"
"signal (\'22023\', \'Name of inverse function should be \' || uriparsename || \', not \' || fheaders[argctr + 1][0] || \', other variants are not supported by the current version\' );\n"
"}\n"
"}\n"
"for (argctr := 0; argctr < argcount; argctr := argctr + 1)\n"
"{\n"
"declare uriparse any;\n"
"uriparse := fheaders [argctr + 1];\n"
"if (1 <> length (uriparse[1]))\n"
"signal (\'22023\', invdesc || \' function \' || uriparse[0] || \' should have only one argument\');\n"
"if (UNAME\'in\' <> uriparse[1][0][0])\n"
"signal (\'22023\', \'Only \"in\" parameters are now supported in argument lists of \' || invdesc || \' functions, not \"\' || uriparse[1][0][0] || \'\"\');\n"
"if ((uriparse[1][0][2] <> uriprint[2]) and (uriparse[1][0][2] <> \'any\'))\n"
"signal (\'22023\', invdesc || \' function \"\' || uriparse[0] || \'\" should have argument of type \' || uriprint[2] || \', not \' || uriparse[1][0][2]);\n"
"if ((uriparse[2] <> uriprint[1][argctr][2]) and (uriprint[1][argctr][2] <> \'any\'))\n"
"signal (\'22023\', \'The return value of \"\' || uriparse[0] || \'\" and the argument #\' || cast (argctr+1 as varchar) || \' of \"\' || uriprintname || \'\" should be of the same data type\');\n"
"if (coalesce (uriparse[1][0][3], 0))\n"
"signal (\'22023\', invdesc || \' function \' || uriparse[0] || \' should have nullable argument\');\n"
"}\n"
"}\n"
"--src sparql.sql:8052\n";

static const char *proc229 = 
"create function DB.DBA.RDF_QM_DEFINE_SUBCLASS (in subclassiri varchar, in superclassiri varchar) returns any\n"
"{\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (subclassiri, \'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\');\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (superclassiri, \'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\');\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:subclassiri)` virtrdf:isSubclassOf `iri(?:superclassiri)` };\n"
"return vector (vector (\'00000\', \'IRI class <\' || subclassiri || \'> is now known as a subclass of <\' || superclassiri || \'>\'));\n"
"}\n"
"--src sparql.sql:8138\n";

static const char *proc230 = 
"create function DB.DBA.RDF_QM_DROP_CLASS (in classiri varchar, in silent integer := 0) returns any\n"
"{\n"
"declare graphiri varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"if (silent and not exists ((sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"select (1) where {\n"
"graph ?:graphiri {\n"
"`iri(?:classiri)` a ?t } } ) ) )\n"
"return vector (vector (\'00000\', \'Class <\' || classiri || \'> does not exist, the DROP statement is ignored due to SILENT option\'));\n"
"if (DB.DBA.RDF_QM_ASSERT_JSO_TYPE (classiri, \'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\', 1))\n"
"{\n"
"declare side_s IRI_ID;\n"
"side_s := DB.DBA.RDF_QM_GC_SUBTREE (classiri);\n"
"if (side_s is not null)\n"
"signal (\'22023\', \'Can not drop class <\' || classiri || \'> because it is used by other quad map objects, e.g., <\' || id_to_iri_nosignal (side_s) || \'>\');\n"
"}\n"
"return vector (vector (\'00000\', \'Previous definition of class <\' || classiri || \'> has been dropped\'));\n"
"}\n"
"--src sparql.sql:8150\n";

static const char *proc231 = 
"create function DB.DBA.RDF_QM_DROP_QUAD_STORAGE (in storage varchar, in silent integer := 0) returns any\n"
"{\n"
"declare graphiri varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"if (silent and not exists ((sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"select (1) where {\n"
"graph ?:graphiri {\n"
"`iri(?:storage)` a ?t } } ) ) )\n"
"return vector (vector (\'00000\', \'Quad storage <\' || storage || \'> does not exist, the DROP statement is ignored due to SILENT option\'));\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_FLAG (storage, 0);\n"
"DB.DBA.RDF_QM_GC_SUBTREE (storage);\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:storage)` ?p ?o\n"
"}\n"
"where { graph ?:graphiri { `iri(?:storage)` ?p ?o } };\n"
"return vector (vector (\'00000\', \'Quad storage <\' || storage || \'> is removed from the quad mapping schema\'));\n"
"}\n"
"--src sparql.sql:8171\n";

static const char *proc232 = 
"create function DB.DBA.RDF_QM_DEFINE_QUAD_STORAGE (in storage varchar) returns any\n"
"{\n"
"declare graphiri, qsusermaps varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (storage, NULL);\n"
"qsusermaps := storage || \'--UserMaps\';\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:storage)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:qsusermaps)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:storage)`\n"
"rdf:type virtrdf:QuadStorage ;\n"
"virtrdf:qsUserMaps `iri(?:qsusermaps)` .\n"
"`iri(?:qsusermaps)`\n"
"rdf:type virtrdf:array-of-QuadMap };\n"
"return vector (vector (\'00000\', \'A new empty quad storage <\' || storage || \'> is added to the quad mapping schema\'));\n"
"}\n"
"--src sparql.sql:8193\n";

static const char *proc233 = 
"create function DB.DBA.RDF_QM_BEGIN_ALTER_QUAD_STORAGE (in storage varchar) returns any\n"
"{\n"
"declare graphiri varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_FLAG (storage, 0);\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:storage)` virtrdf:qsAlterInProgress `bif:now NIL` };\n"
"return vector (vector (\'00000\', \'Quad storage <\' || storage || \'> is flagged as being edited\'));\n"
"}\n"
"--src sparql.sql:8221\n";

static const char *proc234 = 
"create function DB.DBA.RDF_QM_END_ALTER_QUAD_STORAGE (in storage varchar) returns any\n"
"{\n"
"declare graphiri varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (storage, \'http://www.openlinksw.com/schemas/virtrdf#QuadStorage\');\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:storage)` virtrdf:qsAlterInProgress ?dtstart }\n"
"where { graph ?:graphiri {\n"
"`iri(?:storage)` virtrdf:qsAlterInProgress ?dtstart } };\n"
"return vector (vector (\'00000\', \'Quad storage <\' || storage || \'> is unflagged and can be edited by other transactions\'));\n"
"}\n"
"--src sparql.sql:8234\n";

static const char *proc235 = 
"create function DB.DBA.RDF_QM_STORE_ATABLES (in qmvid varchar, in atablesid varchar, inout atables any)\n"
"{\n"
"declare atablectr, atablecount integer;\n"
"atablecount := length (atables);\n"
"for (atablectr := 0; atablectr < atablecount; atablectr := atablectr + 1)\n"
"{\n"
"declare pair any;\n"
"declare qtable, alias, inner_id varchar;\n"
"pair := atables [atablectr];\n"
"alias := pair[0];\n"
"qtable := pair[1];\n"
"inner_id := qmvid || \'-atable-\' || alias || \'-\' || qtable;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:inner_id)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:atablesid)`\n"
"`iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:atablectr+1))` `iri(?:inner_id)` .\n"
"`iri(?:inner_id)`\n"
"rdf:type virtrdf:QuadMapATable ;\n"
"virtrdf:qmvaAlias ?:alias ;\n"
"virtrdf:qmvaTableName ?:qtable };\n"
"}\n"
"}\n"
"--src sparql.sql:8249\n";

static const char *proc236 = 
"create function DB.DBA.RDF_QM_FT_USAGE (in ft_type varchar, in ft_alias varchar, in ft_aliased_col any, in sqlcols any, in conds any, in options any := null)\n"
"{\n"
"declare ft_tbl, ft_col, ftid, ftcondsid varchar;\n"
"declare condctr, condcount, ft_isxml integer;\n"
"ft_tbl := ft_aliased_col[0];\n"
"ft_col := ft_aliased_col[2];\n"
"ft_isxml := case (isnull (ft_type)) when 0 then 1 else null end;\n"
"if (ft_alias <> ft_aliased_col[1])\n"
"signal (\'22023\', sprintf (\'\"TEXT LITERAL %I.%I\" should be at the end of \"FROM ... AS %I\" declaration\', ft_aliased_col[1], ft_aliased_col, ft_alias));\n"
"condcount := length (conds);\n"
"ftid := \'sys:ft-\' || md5 (serialize (vector (ft_alias, ft_tbl, ft_col, conds, options)));\n"
"if (condcount > 0)\n"
"ftcondsid := ftid || \'-conds\';\n"
"else\n"
"ftcondsid := NULL;\n"
"/* Trick to avoid repeating re-declarations */\n"
"if (exists (sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"ask where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"?:ftid\n"
"rdf:type virtrdf:QuadMapFText ;\n"
"virtrdf:qmvftAlias ?:ft_alias ;\n"
"virtrdf:qmvftTableName ?:ft_tbl ;\n"
"virtrdf:qmvftColumnName ?:ft_col ;\n"
"virtrdf:qmvftConds `iri(?:ftcondsid)` } } ) )\n"
"return ftid;\n"
"if (ftcondsid is not null)\n"
"DB.DBA.RDF_QM_GC_SUBTREE (ftcondsid);\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:ftid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:ftcondsid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:ftid)`\n"
"rdf:type virtrdf:QuadMapFText ;\n"
"virtrdf:qmvftAlias ?:ft_alias ;\n"
"virtrdf:qmvftTableName ?:ft_tbl ;\n"
"virtrdf:qmvftColumnName ?:ft_col ;\n"
"virtrdf:qmvftXmlIndex ?:ft_isxml ;\n"
"virtrdf:qmvftConds `iri(?:ftcondsid)` .\n"
"`iri(?:ftcondsid)`\n"
"rdf:type virtrdf:array-of-string };\n"
"for (condctr := 0; condctr < condcount; condctr := condctr + 1)\n"
"{\n"
"declare sqlcond varchar;\n"
"sqlcond := conds [condctr];\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:ftcondsid)`\n"
"`iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:condctr+1))` ?:sqlcond };\n"
"}\n"
"return ftid;\n"
"}\n"
"--src sparql.sql:8279\n";

static const char *proc237 = 
"create function DB.DBA.RDF_QM_CHECK_COLUMNS_FORM_KEY (in sqlcols any) returns integer\n"
"{\n"
"declare alias, tbl varchar;\n"
"declare colctr, colcount integer;\n"
"colcount := length (sqlcols);\n"
"if (0 = colcount)\n"
"return 0;\n"
"tbl := sqlcols[0][0];\n"
"alias := sqlcols[0][1];\n"
"for (colctr := 1; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"if ((sqlcols[colctr][0] <> tbl) or (sqlcols[colctr][1] <> alias))\n"
"return 0;\n"
"}\n"
"for (select KEY_ID, KEY_N_SIGNIFICANT from DB.DBA.SYS_KEYS where (KEY_TABLE = tbl) and KEY_IS_UNIQUE) do\n"
"{\n"
"declare keycolnames any;\n"
"if (KEY_N_SIGNIFICANT > colcount)\n"
"goto no_match;\n"
"for (select \"COLUMN\" as COL\n"
"from DB.DBA.SYS_KEY_PARTS join DB.DBA.SYS_COLS on (KP_COL = COL_ID)\n"
"where KP_KEY_ID = KEY_ID and KP_NTH < KEY_N_SIGNIFICANT ) do\n"
"{\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"if (sqlcols[colctr][2] = COL)\n"
"goto col_ok;\n"
"}\n"
"goto no_match;\n"
"col_ok: ;\n"
"}\n"
"return 1;\n"
"\n"
"no_match: ;\n"
"}\n"
"return 0;\n"
"}\n"
"--src sparql.sql:8344\n";

static const char *proc238 = 
"create function DB.DBA.RDF_QM_DEFINE_MAP_VALUE (in qmv any, in fldname varchar, inout tablename varchar, in o_dt any := null, in o_lang any := null) returns varchar\n"
"{\n"
"/* iqi qmv: vector ( UNAME\'http://www.openlinksw.com/schemas/oplsioc#user_iri\' ,\n"
"vector ( vector (\'alias1\', \'DB.DBA.SYS_USERS\')),\n"
"vector ( vector (\'DB.DBA.SYS_USERS\', \'alias1\', \'U_ID\') ),\n"
"vector (\'^{alias1.}^.U+IS_ROLE = 0\'),\n"
"NULL\n"
") */\n"
"declare atables, sqlcols, conds any;\n"
"declare ftextid varchar;\n"
"declare atablectr, atablecount integer;\n"
"declare colctr, colcount, fmtcolcount integer;\n"
"declare condctr, condcount integer;\n"
"declare columnsformkey integer;\n"
"declare fmtid, iriclassid, qmvid, qmvatablesid, qmvcolsid, qmvcondsid varchar;\n"
"\n"
"fmtid := qmv[0];\n"
"atables := qmv[1];\n"
"sqlcols := qmv[2];\n"
"conds := qmv[3];\n"
"ftextid := qmv[4];\n"
"atablecount := length (atables);\n"
"colcount := length (sqlcols);\n"
"condcount := length (conds);\n"
"if (fmtid <> UNAME\'literal\')\n"
"{\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (fmtid, \'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\');\n"
"if (o_dt is not null)\n"
"signal (\'22023\', \'Only default literal class can have DATATYPE clause in the mapping, <\' || fmtid || \'> can not\');\n"
"if (o_lang is not null)\n"
"signal (\'22023\', \'Only default literal class can have LANG clause in the mapping, <\' || fmtid || \'> can not\');\n"
"fmtcolcount := ((sparql define input:storage \"\"\n"
"select ?cc from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { `iri(?:fmtid)` virtrdf:qmfColumnCount ?cc } ) );\n"
"if (fmtcolcount <> colcount)\n"
"signal (\'22023\', \'Number of columns of quad map value does not match number of arguments of format <\' || fmtid || \'>\');\n"
"}\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"declare sqlcol any;\n"
"declare final_tblname, final_colname varchar;\n"
"sqlcol := sqlcols [colctr];\n"
"final_tblname := DB.DBA.SQLQNAME_NOTATION_TO_QNAME (sqlcol[0], 3);\n"
"final_colname := DB.DBA.SQLNAME_NOTATION_TO_NAME (sqlcol[2]);\n"
"if (not exists (select top 1 1 from DB.DBA.TABLE_COLS where \"TABLE\" = final_tblname))\n"
"{\n"
"if (sqlcol[1] is not null)\n"
"signal (\'22023\', \'No table \' || sqlcol[0] || \' (alias \' || sqlcol[1] || \') in database, please check spelling and character case\');\n"
"else\n"
"signal (\'22023\', \'No table \' || sqlcol[0] || \' in database, please check spelling and character case\');\n"
"}\n"
"if (not exists (select top 1 1 from DB.DBA.TABLE_COLS where \"TABLE\" = final_tblname and \"COLUMN\" = final_colname))\n"
"{\n"
"if (sqlcol[1] is not null)\n"
"signal (\'22023\', \'No column \' || sqlcol[2] || \' in table \' || sqlcol[0] || \' (alias \' || sqlcol[1] || \') in database, please check spelling and character case\');\n"
"else\n"
"signal (\'22023\', \'No column \' || sqlcol[2] || \' in table \' || sqlcol[0] || \' in database, please check spelling and character case\');\n"
"}\n"
"if (tablename is null)\n"
"tablename := sqlcol[0];\n"
"else if (tablename <> sqlcol[0])\n"
"tablename := \'\';\n"
"}\n"
"if (tablename is null)\n"
"tablename := \'\';\n"
"if (fmtid = UNAME\'literal\')\n"
"{\n"
"declare sqlcol any;\n"
"declare final_tblname, final_colname varchar;\n"
"declare coldtp, colnullable integer;\n"
"declare coltype varchar;\n"
"sqlcol := sqlcols [0];\n"
"final_tblname := DB.DBA.SQLQNAME_NOTATION_TO_QNAME (sqlcol[0], 3);\n"
"final_colname := DB.DBA.SQLNAME_NOTATION_TO_NAME (sqlcol[2]);\n"
"select COL_DTP, coalesce (COL_NULLABLE, 1) into coldtp, colnullable\n"
"from DB.DBA.TABLE_COLS where \"TABLE\" = final_tblname and \"COLUMN\" = final_colname;\n"
"coltype := case (coldtp)\n"
"when __tag of long varchar then \'longvarchar\'\n"
"when __tag of timestamp then \'datetime\'\n"
"when __tag of date then \'date\'\n"
"when __tag of time then \'time\'\n"
"when __tag of long varbinary then \'longvarbinary\'\n"
"when 188 then \'integer\'\n"
"when __tag of integer then \'integer\'\n"
"when __tag of varchar then \'varchar\'\n"
"when __tag of real then \'doubleprecision\'\n"
"when __tag of double precision then \'doubleprecision\'\n"
"when 192 then \'varchar\'\n"
"when __tag of datetime then \'datetime\'\n"
"when __tag of numeric then \'numeric\'\n"
"when __tag of nvarchar then \'nvarchar\'\n"
"when __tag of long nvarchar then \'longnvarchar\'\n"
"when __tag of bigint then \'integer\'\n"
"else NULL end;\n"
"if (coltype is null)\n"
"signal (\'22023\', \'The datatype of column \"\' || sqlcols[0][2] ||\n"
"\'\" of table \"\' || sqlcols[0][0] || \'\" (COL_DTP=\' || cast (coldtp as varchar) ||\n"
"\') can not be mapped to an RDF literal in current version of Virtuoso\' );\n"
"if (o_lang is not null and not (coltype in (\'varchar\', \'longvarchar\', \'nvarchar\', \'longnvarchar\')))\n"
"signal (\'22023\', \'The datatype of column \"\' || sqlcols[0][2] ||\n"
"\'\" of table \"\' || sqlcols[0][0] || \'\" (COL_DTP=\' || cast (coldtp as varchar) ||\n"
"\') conflicts with LANG clause, only strings may have language\' );\n"
"if (o_dt is not null and not (coltype in (\'varchar\', \'longvarchar\', \'nvarchar\', \'longnvarchar\')))\n"
"signal (\'22023\', \'Current version of Virtuoso does not support DATATYPE clause for columns other than varchar/nvarchar; the column \"\' || sqlcols[0][2] ||\n"
"\'\" of table \"\' || sqlcols[0][0] || \'\" has COL_DTP=\' || cast (coldtp as varchar) );\n"
"fmtid := \'http://www.openlinksw.com/virtrdf-data-formats#sql-\' || coltype;\n"
"if (o_dt is not null)\n"
"{\n"
"if (__tag (o_dt) = __tag of vector)\n"
"{\n"
"if (o_dt[1] <> sqlcols[0][1])\n"
"signal (\'22023\', \'The alias in DATATYPE clause and the alias in object column should be the same\');\n"
"fmtid := fmtid || \'-dt\';\n"
"sqlcols := vector_concat (sqlcols, vector (o_dt));\n"
"colcount := colcount + 1;\n"
"}\n"
"else\n"
"fmtid := DB.DBA.RDF_QM_DEFINE_LITERAL_CLASS_WITH_FIXED_DT (coltype, o_dt);\n"
"}\n"
"if (o_lang is not null)\n"
"{\n"
"if (__tag (o_lang) = __tag of vector)\n"
"{\n"
"if (o_lang[1] <> sqlcols[0][1])\n"
"signal (\'22023\', \'The alias in LANG clause and the alias in object column should be the same\');\n"
"fmtid := fmtid || \'-lang\';\n"
"sqlcols := vector_concat (sqlcols, vector (o_lang));\n"
"colcount := colcount + 1;\n"
"}\n"
"else\n"
"fmtid := DB.DBA.RDF_QM_DEFINE_LITERAL_CLASS_WITH_FIXED_LANG (coltype, o_lang);\n"
"}\n"
"if (colnullable)\n"
"fmtid := fmtid || \'-nullable\';\n"
"iriclassid := null;\n"
"}\n"
"else\n"
"iriclassid := fmtid;\n"
"qmvid := \'sys:qmv-\' || md5 (serialize (vector (fmtid, sqlcols)));\n"
"qmvatablesid := qmvid || \'-atables\';\n"
"qmvcolsid := qmvid || \'-cols\';\n"
"qmvcondsid := qmvid || \'-conds\';\n"
"/* Trick to avoid repeating re-declarations */\n"
"if (exists (sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"ask where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"?:qmvid\n"
"rdf:type virtrdf:QuadMapValue ;\n"
"virtrdf:qmvATables `iri(?:qmvatablesid)` ;\n"
"virtrdf:qmvColumns `iri(?:qmvcolsid)` ;\n"
"virtrdf:qmvConds `iri(?:qmvcondsid)` ;\n"
"virtrdf:qmvFormat `iri(?:fmtid)` . } } ) )\n"
"return qmvid;\n"
"/* Create everything if qmv has not been found */\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvid)` ?p ?o . }\n"
"where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvid)` ?p ?o .\n"
"} };\n"
"for (sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"select ?atable where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvatablesid)` ?p ?atable } } ) do {\n"
"DB.DBA.RDF_QM_GC_SUBTREE (\"atable\");\n"
"}\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvatablesid)` ?p ?o }\n"
"where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvatablesid)` ?p ?o .\n"
"} };\n"
"for (sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"select ?col where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvcolsid)` ?p ?col } } ) do {\n"
"DB.DBA.RDF_QM_GC_SUBTREE (\"col\");\n"
"}\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvcolsid)` ?p ?o }\n"
"where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvcolsid)` ?p ?o .\n"
"} };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvcondsid)` ?p ?o }\n"
"where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvcondsid)` ?p ?o .\n"
"} };\n"
"if (0 = atablecount)\n"
"qmvatablesid := NULL;\n"
"if (0 = condcount)\n"
"qmvcondsid := NULL;\n"
"columnsformkey := DB.DBA.RDF_QM_CHECK_COLUMNS_FORM_KEY (sqlcols);\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:qmvid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:qmvatablesid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:qmvcolsid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:qmvcondsid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvid)`\n"
"rdf:type virtrdf:QuadMapValue ;\n"
"virtrdf:qmvTableName ?:tablename ;\n"
"virtrdf:qmvATables `iri(?:qmvatablesid)` ;\n"
"virtrdf:qmvColumns `iri(?:qmvcolsid)` ;\n"
"virtrdf:qmvConds `iri(?:qmvcondsid)` ;\n"
"virtrdf:qmvFormat `iri(?:fmtid)` ;\n"
"virtrdf:qmvFText `iri(?:ftextid)` ;\n"
"virtrdf:qmvIriClass `iri(?:iriclassid)` ;\n"
"virtrdf:qmvColumnsFormKey ?:columnsformkey .\n"
"`iri(?:qmvatablesid)`\n"
"rdf:type virtrdf:array-of-QuadMapATable .\n"
"`iri(?:qmvcolsid)`\n"
"rdf:type virtrdf:array-of-QuadMapColumn .\n"
"`iri(?:qmvcondsid)`\n"
"rdf:type virtrdf:array-of-string };\n"
"DB.DBA.RDF_QM_STORE_ATABLES (qmvid, qmvatablesid, atables);\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"declare sqlcol any;\n"
"declare qtable, alias, colname, inner_id varchar;\n"
"sqlcol := sqlcols [colctr];\n"
"alias := sqlcol[1];\n"
"colname := sqlcol[2];\n"
"inner_id := qmvid || \'-col-\' || alias || \'-\' || colname;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:inner_id)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvcolsid)`\n"
"`iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:colctr+1))` `iri(?:inner_id)` .\n"
"`iri(?:inner_id)`\n"
"rdf:type virtrdf:QuadMapColumn ;\n"
"virtrdf:qmvcAlias ?:alias ;\n"
"virtrdf:qmvcColumnName ?:colname };\n"
"}\n"
"for (condctr := 0; condctr < condcount; condctr := condctr + 1)\n"
"{\n"
"declare sqlcond varchar;\n"
"sqlcond := conds [condctr];\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvcondsid)`\n"
"`iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:condctr+1))` ?:sqlcond };\n"
"}\n"
"return qmvid;\n"
"}\n"
"--src sparql.sql:8383\n";

static const char *proc239 = 
"create procedure DB.DBA.RDF_QM_NORMALIZE_QMV (\n"
"inout qmv any, inout qmvfix any, inout qmvid any,\n"
"in can_be_literal integer, in fldname varchar, inout tablename varchar, in o_dt any := null, in o_lang any := null )\n"
"{\n"
"\n"
"qmvid := qmvfix := NULL;\n"
"if ((__tag of vector = __tag (qmv)) and (5 = length (qmv)))\n"
"qmvid := DB.DBA.RDF_QM_DEFINE_MAP_VALUE (qmv, fldname, tablename, o_dt, o_lang);\n"
"else if (217 = __tag (qmv))\n"
"qmvfix := iri_to_id (qmv);\n"
"else if (qmv is not null and not can_be_literal)\n"
"signal (\'22023\', sprintf (\'Quad map declaration can not specify a literal (non-IRI) constant for its %s (tag %d, length %d)\',\n"
"fldname, __tag (qmv), length (qmv) ) );\n"
"else if (__tag of vector = __tag (qmv))\n"
"signal (\'22023\', sprintf (\'Quad map declaration contains constant %s of unsupported type (tag %d, length %d)\',\n"
"fldname, __tag (qmv), length (qmv) ) );\n"
"else\n"
"qmvfix := qmv;\n"
"\n"
"}\n"
"--src sparql.sql:8660\n";

static const char *proc240 = 
"create function DB.DBA.RDF_QM_DEFINE_MAPPING (in storage varchar,\n"
"in qmrawid varchar, in qmid varchar, in qmparentid varchar,\n"
"in qmv_g any, in qmv_s any, in qmv_p any, in qmv_o any, in o_dt any, in o_lang any,\n"
"in is_real integer, in atables any, in conds any, in opts any ) returns any\n"
"{\n"
"declare old_actual_type varchar;\n"
"declare tablename, qmvid_g, qmvid_s, qmvid_p, qmvid_o varchar;\n"
"declare qmvfix_g, qmvfix_s, qmvfix_p, qmvfix_o any;\n"
"declare qm_exclusive, qm_soft_exclusive, qm_empty, qm_is_default, qmusersubmapsid, atablesid, qmcondsid varchar;\n"
"declare qm_order, atablectr, atablecount, condctr, condcount integer;\n"
"\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_FLAG (storage, 1);\n"
"\n"
"old_actual_type := coalesce ((sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?t where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmid)` rdf:type ?t } } ));\n"
"if (old_actual_type is not null)\n"
"{\n"
"declare old_lstiri, old_side_use varchar;\n"
"if (old_actual_type <> \'http://www.openlinksw.com/schemas/virtrdf#QuadMap\')\n"
"signal (\'22023\', \'The RDF QM schema object <\' || qmid || \'> already exists, type <\' || old_actual_type || \'>\');\n"
"old_lstiri := (sparql define input:storage \"\"\n"
"select ?lst where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:storage)` virtrdf:qsUserMaps ?lst } } );\n"
"old_side_use := coalesce ((sparql define input:storage \"\"\n"
"select ?s where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"?s ?p `iri(?:qmid)` filter ((?s != iri(?:storage)) && (?s != iri(?:old_lstiri))) } } ) );\n"
"if (old_side_use is not null)\n"
"signal (\'22023\', \'Can not re-create the RDF Quad Mapping <\' || qmid || \'> because it is referenced by <\' || old_side_use || \'>\');\n"
"DB.DBA.RDF_QM_DELETE_MAPPING_FROM_STORAGE (storage, NULL, qmid);\n"
"DB.DBA.RDF_QM_GC_SUBTREE (qmid);\n"
"}\n"
"if (qmparentid is not null)\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (qmparentid, \'http://www.openlinksw.com/schemas/virtrdf#QuadMap\');\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_CONTAINS_MAPPING (storage, qmid, 0);\n"
"tablename := NULL;\n"
"DB.DBA.RDF_QM_NORMALIZE_QMV (qmv_g, qmvfix_g, qmvid_g, 0, \'graph\', tablename);\n"
"DB.DBA.RDF_QM_NORMALIZE_QMV (qmv_s, qmvfix_s, qmvid_s, 0, \'subject\', tablename);\n"
"DB.DBA.RDF_QM_NORMALIZE_QMV (qmv_p, qmvfix_p, qmvid_p, 0, \'predicate\', tablename);\n"
"DB.DBA.RDF_QM_NORMALIZE_QMV (qmv_o, qmvfix_o, qmvid_o, 1, \'object\', tablename, o_dt, o_lang);\n"
"if (get_keyword_ucase (\'EXCLUSIVE\', opts))\n"
"qm_exclusive := \'http://www.openlinksw.com/schemas/virtrdf#SPART_QM_EXCLUSIVE\';\n"
"else\n"
"qm_exclusive := NULL;\n"
"if (get_keyword_ucase (\'OK_FOR_ANY_QUAD\', opts))\n"
"qm_is_default := \'http://www.openlinksw.com/schemas/virtrdf#SPART_QM_OK_FOR_ANY_QUAD\';\n"
"else\n"
"qm_is_default := NULL;\n"
"if (get_keyword_ucase (\'SOFT_EXCLUSIVE\', opts))\n"
"qm_soft_exclusive := \'http://www.openlinksw.com/schemas/virtrdf#SPART_QM_SOFT_EXCLUSIVE\';\n"
"else\n"
"qm_soft_exclusive := NULL;\n"
"if (not is_real)\n"
"{\n"
"qm_empty := \'http://www.openlinksw.com/schemas/virtrdf#SPART_QM_EMPTY\';\n"
"}\n"
"else\n"
"{\n"
"qm_empty := NULL;\n"
"if (tablename is null)\n"
"{\n"
"tablename := \'DB.DBA.SYS_FAKE_1\';\n"
"if (0 < length (conds))\n"
"signal (\'22023\', \'Quad Mapping <\' || qmid || \'> has four constants and no one quad map value; it do not access tables so it can not have WHERE conditions\');\n"
"}\n"
"}\n"
"if (\'\' = tablename)\n"
"tablename := NULL;\n"
"qm_order := get_keyword_ucase (\'ORDER\', opts);\n"
"if (not is_real)\n"
"{\n"
"qmusersubmapsid := qmid || \'--UserSubMaps\';\n"
"atablesid := NULL;\n"
"qmcondsid := NULL;\n"
"}\n"
"else\n"
"{\n"
"qmusersubmapsid := NULL;\n"
"atablesid := qmid || \'--ATables\';\n"
"qmcondsid := qmid || \'--Conds\';\n"
"}\n"
"if (qm_is_default is not null)\n"
"{\n"
"if (qm_order is not null)\n"
"signal (\'22023\', \'ORDER option is not applicable to default quad map\');\n"
"if (qmparentid is not null)\n"
"signal (\'22023\', \'A default quad map can not be a sub-map of other quad map\');\n"
"}\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:atablesid)` ?p ?o }\n"
"where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:atablesid)` ?p ?o .\n"
"} };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmcondsid)` ?p ?o }\n"
"where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmcondsid)` ?p ?o .\n"
"} };\n"
"atablecount := length (atables);\n"
"condcount := length (conds);\n"
"if (0 = atablecount)\n"
"atablesid := NULL;\n"
"if (0 = condcount)\n"
"qmcondsid := NULL;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:qmid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:atablesid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:qmcondsid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:qmusersubmapsid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmid)`\n"
"rdf:type virtrdf:QuadMap ;\n"
"virtrdf:qmGraphRange-rvrFixedValue ?:qmvfix_g ;\n"
"virtrdf:qmGraphMap `iri(?:qmvid_g)` ;\n"
"virtrdf:qmSubjectRange-rvrFixedValue ?:qmvfix_s ;\n"
"virtrdf:qmSubjectMap `iri(?:qmvid_s)` ;\n"
"virtrdf:qmPredicateRange-rvrFixedValue ?:qmvfix_p ;\n"
"virtrdf:qmPredicateMap `iri(?:qmvid_p)` ;\n"
"virtrdf:qmObjectRange-rvrFixedValue ?:qmvfix_o ;\n"
"virtrdf:qmObjectMap `iri(?:qmvid_o)` ;\n"
"virtrdf:qmTableName ?:tablename ;\n"
"virtrdf:qmATables `iri(?:atablesid)` ;\n"
"virtrdf:qmConds `iri(?:qmcondsid)` ;\n"
"virtrdf:qmUserSubMaps `iri(?:qmusersubmapsid)` ;\n"
"virtrdf:qmMatchingFlags `iri(?:qm_exclusive)` ;\n"
"virtrdf:qmMatchingFlags `iri(?:qm_empty)` ;\n"
"virtrdf:qmMatchingFlags `iri(?:qm_is_default)` ;\n"
"virtrdf:qmMatchingFlags `iri(?:qm_soft_exclusive)` ;\n"
"virtrdf:qmPriorityOrder ?:qm_order .\n"
"`iri(?:atablesid)`\n"
"rdf:type virtrdf:array-of-QuadMapATable .\n"
"`iri(?:qmcondsid)`\n"
"rdf:type virtrdf:array-of-string .\n"
"`iri(?:qmusersubmapsid)`\n"
"rdf:type virtrdf:array-of-QuadMap };\n"
"DB.DBA.RDF_QM_STORE_ATABLES (qmid, atablesid, atables);\n"
"for (condctr := 0; condctr < condcount; condctr := condctr + 1)\n"
"{\n"
"declare sqlcond varchar;\n"
"sqlcond := conds [condctr];\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmcondsid)`\n"
"`iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:condctr+1))` ?:sqlcond };\n"
"}\n"
"if (qm_is_default is not null)\n"
"DB.DBA.RDF_QM_SET_DEFAULT_MAPPING (storage, qmid);\n"
"else\n"
"DB.DBA.RDF_QM_ADD_MAPPING_TO_STORAGE (storage, qmparentid, qmid, qm_order);\n"
"return vector (vector (\'00000\', \'Quad map <\' || qmid || \'> has been created and added to the <\' || storage || \'>\'));\n"
"}\n"
"--src sparql.sql:8682\n";

static const char *proc241 = 
"create function DB.DBA.RDF_QM_ATTACH_MAPPING (in storage varchar, in source varchar, in opts any) returns any\n"
"{\n"
"declare graphiri varchar;\n"
"declare qmid, qmgraph varchar;\n"
"declare qm_order, qm_is_default integer;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"qmid := get_keyword_ucase (\'ID\', opts, NULL);\n"
"qmgraph := get_keyword_ucase (\'GRAPH\', opts, NULL);\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_FLAG (storage, 1);\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_FLAG (source, 0);\n"
"if (qmid is null)\n"
"{\n"
"qmid := coalesce ((sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?s where {\n"
"graph ?:graphiri {\n"
"?s rdf:type virtrdf:QuadMap .\n"
"?s virtrdf:qmGraphRange-rvrFixedValue `iri(?:qmgraph)` .\n"
"?s virtrdf:qmMatchingFlags virtrdf:SPART_QM_EMPTY .\n"
"} } ));\n"
"if (qmid is null)\n"
"return vector (vector (\'00100\', \'Quad map for graph <\' || qmgraph || \'> is not found\'));\n"
"}\n"
"qm_order := coalesce ((sparql define input:storage \"\"\n"
"select ?o where { graph ?:graphiri {\n"
"`iri(?:qmid)` virtrdf:qmPriorityOrder ?o } } ) );\n"
"if (exists (sparql define input:storage \"\"\n"
"ask where { graph ?:graphiri {\n"
"`iri(?:qmid)` virtrdf:qmMatchingFlags virtrdf:SPART_QM_OK_FOR_ANY_QUAD } } ) )\n"
"qm_is_default := 1;\n"
"else\n"
"qm_is_default := 0;\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_CONTAINS_MAPPING (storage, qmid, 0);\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_CONTAINS_MAPPING (source, qmid, 1);\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (qmid, \'http://www.openlinksw.com/schemas/virtrdf#QuadMap\');\n"
"if (qm_is_default)\n"
"DB.DBA.RDF_QM_SET_DEFAULT_MAPPING (storage, qmid);\n"
"else\n"
"DB.DBA.RDF_QM_ADD_MAPPING_TO_STORAGE (storage, NULL, qmid, NULL /* !!!TBD: place real value instead of constant NULL */);\n"
"return vector (vector (\'00000\', \'Quad map <\' || qmid || \'> is added to the storage <\' || storage || \'>\'));\n"
"}\n"
"--src sparql.sql:8860\n";

static const char *proc242 = 
"create procedure DB.DBA.RDF_QM_ADD_MAPPING_TO_STORAGE (in storage varchar, in qmparent varchar, in qmid varchar, in qmorder integer)\n"
"{\n"
"declare graphiri, lstiri varchar;\n"
"declare iris_and_orders any;\n"
"declare ctr, qmid_is_printed integer;\n"
"\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"if (qmparent is not null)\n"
"lstiri := (sparql define input:storage \"\"\n"
"select ?lst where { graph ?:graphiri {\n"
"`iri(?:qmparent)` virtrdf:qmUserSubMaps ?lst } } );\n"
"else\n"
"lstiri := (sparql define input:storage \"\"\n"
"select ?lst where { graph ?:graphiri {\n"
"`iri(?:storage)` virtrdf:qsUserMaps ?lst } } );\n"
"\n"
"if (qmorder is null)\n"
"qmorder := 1999;\n"
"iris_and_orders := (\n"
"select DB.DBA.VECTOR_AGG (vector (sub.\"id\", sub.\"p\", sub.\"ord1\"))\n"
"from (\n"
"select sp.\"id\", sp.\"p\", sp.\"ord1\"\n"
"from (\n"
"sparql define input:storage \"\"\n"
"select ?id ?p\n"
"(bif:coalesce (?ord,\n"
"1000 + bif:aref (\n"
"bif:sprintf_inverse (\n"
"str(?p),\n"
"bif:concat (str (rdf:_), \"%d\"),\n"
"2),\n"
"0 ) ) ) as ?ord1\n"
"where { graph ?:graphiri {\n"
"`iri(?:lstiri)` ?p ?id .\n"
"filter (! bif:isnull (bif:aref (\n"
"bif:sprintf_inverse (\n"
"str(?p),\n"
"bif:concat (str (rdf:_), \"%d\"),\n"
"2),\n"
"0 ) ) ) .\n"
"optional {?id virtrdf:qmPriorityOrder ?ord} } } ) as sp\n"
"order by 3, 2, 1 ) as sub );\n"
"\n"
"foreach (any itm in iris_and_orders) do\n"
"{\n"
"declare id, p varchar;\n"
"id := itm[0];\n"
"p := itm[1];\n"
"sparql define input:storage \"\"\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:lstiri)` `iri(?:p)` `iri(?:id)` };\n"
"}\n"
"ctr := 1;\n"
"qmid_is_printed := 0;\n"
"foreach (any itm in iris_and_orders) do\n"
"{\n"
"declare id varchar;\n"
"declare ord integer;\n"
"id := itm[0];\n"
"ord := itm[2];\n"
"if (ord > qmorder)\n"
"{\n"
"sparql define input:storage \"\"\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:lstiri)`\n"
"`iri(bif:sprintf(\"%s%d\", str(rdf:_), ?:ctr))`\n"
"`iri(?:qmid)` };\n"
"\n"
"ctr := ctr + 1;\n"
"qmid_is_printed := 1;\n"
"}\n"
"sparql define input:storage \"\"\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:lstiri)`\n"
"`iri(bif:sprintf(\"%s%d\", str(rdf:_), ?:ctr))`\n"
"`iri(?:id)` };\n"
"ctr := ctr + 1;\n"
"}\n"
"if (not qmid_is_printed)\n"
"{\n"
"sparql define input:storage \"\"\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:lstiri)`\n"
"`iri(bif:sprintf(\"%s%d\", str(rdf:_), ?:ctr))`\n"
"`iri(?:qmid)` };\n"
"\n"
"ctr := ctr + 1;\n"
"}\n"
"}\n"
"--src sparql.sql:8903\n";

static const char *proc243 = 
"create procedure DB.DBA.RDF_QM_DELETE_MAPPING_FROM_STORAGE (in storage varchar, in qmparent varchar, in qmid varchar)\n"
"{\n"
"declare graphiri, lstiri varchar;\n"
"declare iris_and_orders any;\n"
"declare ctr integer;\n"
"\n"
"qmid := iri_to_id (qmid, 0, NULL);\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"if (qmparent is not null)\n"
"lstiri := (sparql define input:storage \"\"\n"
"select ?lst where { graph ?:graphiri {\n"
"`iri(?:qmparent)` virtrdf:qmUserSubMaps ?lst } } );\n"
"else\n"
"lstiri := (sparql define input:storage \"\"\n"
"select ?lst where { graph ?:graphiri {\n"
"`iri(?:storage)` virtrdf:qsUserMaps ?lst } } );\n"
"\n"
"iris_and_orders := (\n"
"select DB.DBA.VECTOR_AGG (vector (sub.\"id\", sub.\"p\", sub.\"ord1\"))\n"
"from (\n"
"select sp.\"id\", sp.\"p\", sp.\"ord1\"\n"
"from (\n"
"sparql define input:storage \"\"\n"
"select ?id ?p\n"
"(bif:coalesce (?ord,\n"
"1000 + bif:aref (\n"
"bif:sprintf_inverse (\n"
"str(?p),\n"
"bif:concat (str (rdf:_), \"%d\"),\n"
"2),\n"
"0 ) ) ) as ?ord1\n"
"where { graph ?:graphiri {\n"
"`iri(?:lstiri)` ?p ?id .\n"
"filter (! bif:isnull (bif:aref (\n"
"bif:sprintf_inverse (\n"
"str(?p),\n"
"bif:concat (str (rdf:_), \"%d\"),\n"
"2),\n"
"0 ) ) ) .\n"
"optional {?id virtrdf:qmPriorityOrder ?ord} } } ) as sp\n"
"order by 3, 2, 1 ) as sub );\n"
"\n"
"foreach (any itm in iris_and_orders) do\n"
"{\n"
"declare id, p varchar;\n"
"id := itm[0];\n"
"p := itm[1];\n"
"sparql define input:storage \"\"\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:lstiri)` `iri(?:p)` `iri(?:id)` . };\n"
"}\n"
"ctr := 1;\n"
"foreach (any itm in iris_and_orders) do\n"
"{\n"
"declare id varchar;\n"
"declare ord integer;\n"
"id := itm[0];\n"
"ord := itm[2];\n"
"if (iri_to_id (id, 0, 0) <> qmid)\n"
"{\n"
"sparql define input:storage \"\"\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:lstiri)`\n"
"`iri(bif:sprintf(\"%s%d\", str(rdf:_), ?:ctr))`\n"
"`iri(?:id)` . };\n"
"ctr := ctr + 1;\n"
"}\n"
"else\n"
"{\n"
"\n"
" ;\n"
"}\n"
"}\n"
"}\n"
"--src sparql.sql:8994\n";

static const char *proc244 = 
"create procedure DB.DBA.RDF_QM_SET_DEFAULT_MAPPING (in storage varchar, in qmid varchar)\n"
"{\n"
"declare graphiri, old_qmid varchar;\n"
"\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"old_qmid := coalesce ((sparql define input:storage \"\"\n"
"select ?qm where { graph ?:graphiri {\n"
"`iri(?:storage)` virtrdf:qsDefaultMap ?qm } } ) );\n"
"if (old_qmid is not null)\n"
"{\n"
"if (cast (old_qmid as varchar) = cast (qmid as varchar))\n"
"return;\n"
"signal (\'22023\', \'Quad map storage <\' || storage || \'> has set a default quad map <\' || old_qmid || \'>, drop it before adding <\' || qmid || \'>\');\n"
"}\n"
"sparql define input:storage \"\"\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> { `iri(?:storage)` virtrdf:qsDefaultMap `iri(?:qmid)` . };\n"
"}\n"
"--src sparql.sql:9070\n";

static const char *proc245 = 
"create procedure DB.DBA.TTLP_EV_TRIPLE_W (\n"
"in g_iid IRI_ID, in s_uri varchar, in p_uri varchar,\n"
"in o_uri varchar, in env any )\n"
"{\n"
"\n"
"declare log_mode integer;\n"
"declare s_iid, p_iid, o_iid IRI_ID;\n"
"log_mode := env[0];\n"
"if (log_mode = 1)\n"
"{\n"
"whenever sqlstate \'40001\' goto deadlock_1;\n"
"again_1:\n"
"log_enable (1, 1);\n"
"s_iid := iri_to_id (s_uri);\n"
"p_iid := iri_to_id (p_uri);\n"
"o_iid := iri_to_id (o_uri);\n"
"commit work;\n"
"log_enable (0, 1);\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, s_iid, p_iid, o_iid);\n"
"commit work;\n"
"\n"
"return;\n"
"}\n"
"if (log_mode = 0)\n"
"{\n"
"whenever sqlstate \'40001\' goto deadlock_0;\n"
"again_0:\n"
"log_enable (0, 1);\n"
"s_iid := iri_to_id (s_uri);\n"
"p_iid := iri_to_id (p_uri);\n"
"o_iid := iri_to_id (o_uri);\n"
"commit work;\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O) values (g_iid, s_iid, p_iid, o_iid);\n"
"commit work;\n"
"\n"
"return;\n"
"}\n"
"whenever sqlstate \'40001\' goto deadlock_2;\n"
"again_2:\n"
"log_enable (1, 1);\n"
"s_iid := iri_to_id (s_uri);\n"
"p_iid := iri_to_id (p_uri);\n"
"o_iid := iri_to_id (o_uri);\n"
"commit work;\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O) values (g_iid, s_iid, p_iid, o_iid);\n"
"commit work;\n"
"\n"
"return;\n"
"deadlock_0:\n"
"rollback work;\n"
"goto again_0;\n"
"deadlock_1:\n"
"rollback work;\n"
"goto again_1;\n"
"deadlock_2:\n"
"rollback work;\n"
"goto again_2;\n"
"}\n"
"--src sparql.sql:9094\n";

static const char *proc246 = 
"create procedure DB.DBA.TTLP_EV_TRIPLE_L_W (\n"
"in g_iid IRI_ID, in s_uri varchar, in p_uri varchar,\n"
"in o_val any, in o_type any, in o_lang any, in env any )\n"
"{\n"
"\n"
"declare log_mode integer;\n"
"declare ro_id_dict any;\n"
"log_mode := env[0];\n"
"ro_id_dict := env[1];\n"
"declare s_iid, p_iid IRI_ID;\n"
"if (isstring (o_type))\n"
"{\n"
"declare parsed any;\n"
"parsed := __xqf_str_parse_to_rdf_box (o_val, o_type, isstring (o_val));\n"
"if (parsed is not null)\n"
"{\n"
"if (__tag of rdf_box = __tag (parsed))\n"
"{\n"
"rdf_box_set_type (parsed,\n"
"DB.DBA.RDF_TWOBYTE_OF_DATATYPE (iri_to_id (o_type)));\n"
"\n"
"}\n"
"o_val := parsed;\n"
"}\n"
"}\n"
"whenever sqlstate \'40001\' goto deadlck;\n"
"again:\n"
"if (log_mode = 0)\n"
"log_enable (0, 1);\n"
"else\n"
"log_enable (1, 1);\n"
"s_iid := iri_to_id (s_uri);\n"
"p_iid := iri_to_id (p_uri);\n"
"if (isstring (o_val) or (__tag of XML = __tag (o_val)))\n"
"{\n"
"if (isstring (o_type) or isstring (o_lang))\n"
"{\n"
"if (not isstring (o_type))\n"
"o_type := null;\n"
"if (not isstring (o_lang))\n"
"o_lang := null;\n"
"o_val := DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_FT (o_val,\n"
"iri_to_id (o_type),\n"
"o_lang, g_iid, p_iid, ro_id_dict );\n"
"}\n"
"else\n"
"o_val := DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT (o_val, g_iid, p_iid, ro_id_dict);\n"
"}\n"
"else if (__tag of rdf_box = __tag (o_val))\n"
"{\n"
"if (__tag of varchar = rdf_box_data_tag (o_val) and __rdf_obj_ft_rule_check (g_iid, p_iid))\n"
"o_val := DB.DBA.RDF_OBJ_ADD (257, o_val, 257, ro_id_dict);\n"
"else if (0 < rdf_box_needs_digest (o_val))\n"
"o_val := DB.DBA.RDF_OBJ_ADD (257, o_val, 257);\n"
"}\n"
"\n"
"if (log_mode <= 1)\n"
"log_enable (0, 1);\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, s_iid, p_iid, o_val);\n"
"\n"
"commit work;\n"
"return;\n"
"deadlck:\n"
"rollback work;\n"
"goto again;\n"
"}\n"
"--src sparql.sql:9156\n";

static const char *proc247 = 
"create procedure DB.DBA.TTLP_EV_NEW_GRAPH_A (inout g varchar, inout g_iid IRI_ID, inout app_env any) {\n"
"\n"
"if (__rdf_obj_ft_rule_count_in_graph (g_iid))\n"
"app_env[2][1] := dict_new (app_env[3]);\n"
"else\n"
"app_env[2][1] := null;\n"
"}\n"
"--src sparql.sql:9225\n";

static const char *proc248 = 
"create procedure DB.DBA.TTLP_EV_TRIPLE_A (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_uri varchar,\n"
"inout app_env any )\n"
"{\n"
"\n"
"app_env[1] := aq_request (\n"
"app_env[0], \'DB.DBA.TTLP_EV_TRIPLE_W\',\n"
"vector (g_iid, s_uri, p_uri, o_uri, app_env[2]) );\n"
"if (mod (app_env[1], 100000) = 0)\n"
"{\n"
"declare ro_id_dict any;\n"
"ro_id_dict := app_env[2][1];\n"
"if (ro_id_dict is not null)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (g_iid, ro_id_dict);\n"
"commit work;\n"
"aq_wait_all (app_env[0]);\n"
"}\n"
"}\n"
"--src sparql.sql:9234\n";

static const char *proc249 = 
"create procedure DB.DBA.TTLP_EV_TRIPLE_L_A (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout app_env any )\n"
"{\n"
"\n"
"if (__tag of XML = __tag (o_val))\n"
"{\n"
"DB.DBA.TTLP_EV_TRIPLE_L_W (g_iid, s_uri, p_uri, o_val, o_type, o_lang, app_env[2]);\n"
"return;\n"
"}\n"
"app_env[1] := aq_request (\n"
"app_env[0], \'DB.DBA.TTLP_EV_TRIPLE_L_W\',\n"
"vector (g_iid, s_uri, p_uri, o_val, o_type, o_lang, app_env[2]) );\n"
"if (mod (app_env[1], 100000) = 0)\n"
"{\n"
"declare ro_id_dict any;\n"
"ro_id_dict := app_env[2][1];\n"
"if (ro_id_dict is not null)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (g_iid, ro_id_dict);\n"
"commit work;\n"
"aq_wait_all (app_env[0]);\n"
"}\n"
"}\n"
"--src sparql.sql:9255\n";

static const char *proc250 = 
"create procedure DB.DBA.TTLP_EV_COMMIT_A (\n"
"inout graph_iri varchar, inout app_env any )\n"
"{\n"
"\n"
"commit work;\n"
"aq_wait_all (app_env[0]);\n"
"commit work;\n"
"DB.DBA.TTLP_EV_COMMIT (graph_iri, app_env[2]);\n"
"commit work;\n"
"}\n"
"--src sparql.sql:9281\n";

static const char *proc251 = 
"create function DB.DBA.TTLP_MT (in strg varchar, in base varchar, in graph varchar := null, in flags integer := 0,\n"
"in log_mode integer := 2, in threads integer := 3, in transactional int := 0)\n"
"{\n"
"declare app_env any;\n"
"if (graph = \'\')\n"
"signal (\'22023\', \'Empty string is not a valid graph IRI in DB.DBA.TTLP_MT()\');\n"
"else if (graph is null)\n"
"{\n"
"graph := base;\n"
"if ((graph is null) or (graph = \'\'))\n"
"signal (\'22023\', \'DB.DBA.TTLP_MT() requires a valid IRI as a base argument if graph is not specified\');\n"
"}\n"
"if (transactional = 0)\n"
"{\n"
"if (log_mode = 1 or log_mode = 0)\n"
"log_mode := log_mode + 2;\n"
"}\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"DB.DBA.TTLP_CL (strg, base, graph, flags);\n"
"return;\n"
"}\n"
"if (126 = __tag (strg))\n"
"strg := cast (strg as varchar);\n"
"app_env := vector (async_queue (threads), 0, vector (log_mode, null), __max (length (strg) / 100, 100000));\n"
"rdf_load_turtle (strg, base, graph, flags,\n"
"vector (\n"
"\'DB.DBA.TTLP_EV_NEW_GRAPH_A\',\n"
"\'DB.DBA.TTLP_EV_NEW_BLANK\',\n"
"\'!iri_to_id\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_A\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_L_A\',\n"
"\'DB.DBA.TTLP_EV_COMMIT_A\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"app_env);\n"
"return graph;\n"
"}\n"
"--src sparql.sql:9293\n";

static const char *proc252 = 
"create function DB.DBA.TTLP_MT_LOCAL_FILE (in filename varchar, in base varchar, in graph varchar := null, in flags integer := 0,\n"
"in log_mode integer := 2, in threads integer := 3, in transactional int := 0)\n"
"{\n"
"declare app_env any;\n"
"if (graph = \'\')\n"
"signal (\'22023\', \'Empty string is not a valid graph IRI in DB.DBA.TTLP_MT_LOCAL_FILE()\');\n"
"else if (graph is null)\n"
"{\n"
"graph := base;\n"
"if ((graph is null) or (graph = \'\'))\n"
"signal (\'22023\', \'DB.DBA.TTLP_MT_LOCAL_FILE() requires a valid IRI as a base argument if graph is not specified\');\n"
"}\n"
"if (transactional = 0)\n"
"{\n"
"if (log_mode = 1 or log_mode = 0)\n"
"log_mode := log_mode + 2;\n"
"}\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"DB.DBA.TTLP_CL_LOCAL_FILE (filename, base, graph, flags);\n"
"return;\n"
"}\n"
"app_env := vector (async_queue (threads), 0, vector (log_mode, null), 1000000);\n"
"rdf_load_turtle_local_file (filename, base, graph, flags,\n"
"vector (\n"
"\'DB.DBA.TTLP_EV_NEW_GRAPH_A\',\n"
"\'DB.DBA.TTLP_EV_NEW_BLANK\',\n"
"\'!iri_to_id\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_A\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_L_A\',\n"
"\'DB.DBA.TTLP_EV_COMMIT_A\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"app_env);\n"
"return graph;\n"
"}\n"
"--src sparql.sql:9332\n";

static const char *proc253 = 
"create function DB.DBA.RDF_LOAD_RDFXML_MT (in strg varchar, in base varchar, in graph varchar,\n"
"in log_mode integer := 2, in threads integer := 3, in transactional int := 0)\n"
"{\n"
"declare ro_id_dict, app_env any;\n"
"if (graph = \'\')\n"
"signal (\'22023\', \'Empty string is not a valid graph IRI in DB.DBA.RDFL_LOAD_RDFXML_MT()\');\n"
"else if (graph is null)\n"
"{\n"
"graph := base;\n"
"if ((graph is null) or (graph = \'\'))\n"
"signal (\'22023\', \'DB.DBA.RDF_LOAD_RDFXML_MT() requires a valid IRI as a base argument if graph is not specified\');\n"
"}\n"
"if (transactional = 0)\n"
"{\n"
"if (log_mode = 1 or log_mode = 0)\n"
"log_mode := log_mode + 2;\n"
"}\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"return rdf_load_rdfxml_cl (strg, base, graph);\n"
"if (__rdf_obj_ft_rule_count_in_graph (iri_to_id (graph)))\n"
"ro_id_dict := dict_new ();\n"
"else\n"
"ro_id_dict := null;\n"
"app_env := vector (async_queue (threads), 0, vector (log_mode, ro_id_dict), __max (length (strg) / 100, 100000));\n"
"rdf_load_rdfxml (strg, 0,\n"
"graph,\n"
"vector (\n"
"\'DB.DBA.TTLP_EV_NEW_GRAPH_A\',\n"
"\'DB.DBA.TTLP_EV_NEW_BLANK\',\n"
"\'!iri_to_id\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_A\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_L_A\',\n"
"\'DB.DBA.TTLP_EV_COMMIT_A\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"app_env,\n"
"base );\n"
"return graph;\n"
"}\n"
"--src sparql.sql:9369\n";

static const char *proc254 = 
"create function DB.DBA.VT_DECODE_KEYWORD_ITM (inout vtdata varchar, inout ofs integer)\n"
"{\n"
"declare res integer;\n"
"if ((5 <> vtdata[ofs]) or (0 <> vtdata[ofs+5]))\n"
"signal (\'23023\', \'Invalid VT_WORD data in DB.DBA.VT_DECODE_KEYWORD_ITM\');\n"
"res := (((vtdata[ofs+1] * 256) + vtdata[ofs+2]) * 256 + vtdata[ofs+3]) * 256 + vtdata[ofs+4];\n"
"ofs := ofs + 6;\n"
"return res;\n"
"}\n"
"--src sparql.sql:9413\n";

static const char *proc255 = 
"create procedure DB.DBA.VT_ENCODE_KEYWORD_ITM (in id integer, inout ses any)\n"
"{\n"
"declare strg varchar;\n"
"strg := \'012345\';\n"
"strg[5] := 0;\n"
"strg[4] := bit_and (id, 255); id := bit_shift (id, -8);\n"
"strg[3] := bit_and (id, 255); id := bit_shift (id, -8);\n"
"strg[2] := bit_and (id, 255); id := bit_shift (id, -8);\n"
"strg[1] := bit_and (id, 255); if (id > 255) signal (\'22023\', \'Abnormally big document id in DB.DBA.VT_ENCODE_KEYWORD_ITM\');\n"
"strg[0] := 5;\n"
"http (strg, ses);\n"
"}\n"
"--src sparql.sql:9424\n";

static const char *proc256 = 
"create function DB.DBA.VT_COMPOSE_KEYWORD_INDEX_LINES (\n"
"inout carry_d_id integer,\n"
"inout carry_d_id_2 integer,\n"
"inout carry_data varchar,\n"
"in old_d_id integer,\n"
"in old_d_id_2 integer,\n"
"in old_data varchar,\n"
"inout ro_id_offset integer,\n"
"inout new_ro_ids any )\n"
"returns any\n"
"{\n"
"declare res_acc, mix_ses any;\n"
"declare old_data_ofs, old_data_len, old_curr_id, mix_id integer;\n"
"declare new_ro_id_idx, new_ro_ids_count, mix_d_id, mix_d_id_2, mix_count integer;\n"
"\n"
"vectorbld_init (res_acc);\n"
"mix_ses := string_output();\n"
"if (carry_data <> \'\')\n"
"{\n"
"mix_d_id := carry_d_id;\n"
"mix_d_id_2 := carry_d_id_2;\n"
"http (carry_data, mix_ses);\n"
"mix_count := length (carry_data) / 6;\n"
"}\n"
"else\n"
"{\n"
"mix_d_id := null;\n"
"mix_d_id_2 := null;\n"
"mix_count := 0;\n"
"}\n"
"old_data_ofs := 0;\n"
"if (old_data is null)\n"
"old_curr_id := null;\n"
"else\n"
"old_curr_id := DB.DBA.VT_DECODE_KEYWORD_ITM (old_data, old_data_ofs);\n"
"old_data_len := length (old_data);\n"
"new_ro_ids_count := length (new_ro_ids);\n"
"new_ro_id_idx := ro_id_offset;\n"
"if (new_ro_id_idx < new_ro_ids_count)\n"
"mix_id := new_ro_ids [new_ro_id_idx];\n"
"else\n"
"mix_id := null;\n"
"\n"
"mix_d_id := __min_notnull (mix_d_id, old_curr_id, mix_id);\n"
"\n"
"\n"
"next_mix:\n"
"if (old_curr_id is null)\n"
"{\n"
"if ((new_ro_id_idx >= new_ro_ids_count) or (new_ro_ids [new_ro_id_idx] > old_d_id_2))\n"
"goto complete;\n"
"mix_id := new_ro_ids [new_ro_id_idx];\n"
"new_ro_id_idx := new_ro_id_idx + 1;\n"
"}\n"
"else\n"
"{\n"
"if ((new_ro_id_idx >= new_ro_ids_count) or (new_ro_ids [new_ro_id_idx] >= old_curr_id))\n"
"{\n"
"if ((new_ro_id_idx < new_ro_ids_count) and (new_ro_ids [new_ro_id_idx] = old_curr_id))\n"
"new_ro_id_idx := new_ro_id_idx + 1;\n"
"mix_id := old_curr_id;\n"
"if (old_data_ofs >= old_data_len)\n"
"old_curr_id := null;\n"
"else\n"
"old_curr_id := DB.DBA.VT_DECODE_KEYWORD_ITM (old_data, old_data_ofs);\n"
"}\n"
"else\n"
"{\n"
"mix_id := new_ro_ids [new_ro_id_idx];\n"
"new_ro_id_idx := new_ro_id_idx + 1;\n"
"}\n"
"}\n"
"if ((mix_count > 180) or ((mix_d_id_2 / 10000) <> (mix_id  / 10000)))\n"
"{\n"
"\n"
"vectorbld_acc (res_acc, vector (mix_d_id, mix_d_id_2, string_output_string (mix_ses)));\n"
"mix_ses := string_output ();\n"
"mix_d_id := mix_id;\n"
"mix_count := 0;\n"
"}\n"
"DB.DBA.VT_ENCODE_KEYWORD_ITM (mix_id, mix_ses);\n"
"mix_d_id_2 := mix_id;\n"
"mix_count := mix_count + 1;\n"
"goto next_mix;\n"
"\n"
"complete:\n"
"ro_id_offset := new_ro_id_idx;\n"
"if (mix_count > 150)\n"
"{\n"
"\n"
"vectorbld_acc (res_acc, vector (mix_d_id, mix_d_id_2, string_output_string (mix_ses)));\n"
"carry_data := \'\';\n"
"carry_d_id := carry_d_id_2 := null;\n"
"}\n"
"else\n"
"{\n"
"carry_data := string_output_string (mix_ses);\n"
"carry_d_id := mix_d_id;\n"
"carry_d_id_2 := mix_d_id_2;\n"
"}\n"
"vectorbld_final (res_acc);\n"
"\n"
"return res_acc;\n"
"}\n"
"--src sparql.sql:9438\n";

static const char *proc257 = 
" create function DB.DBA.RDF_OBJ_PATCH_CONTAINS_BY_GRAPH (in phrase varchar, in graph_iri varchar)\n"
"{\n"
"declare graph_keyword any;\n"
"whenever sqlstate \'*\' goto err;\n"
"graph_keyword := iri_to_id (graph_iri, 0, 0);\n"
"if (isinteger (graph_keyword))\n"
"goto err;\n"
"graph_keyword := WS.WS.STR_SQL_APOS (rdf_graph_keyword  (graph_keyword));\n"
"return sprintf (\'[__enc \"UTF-8\"] ^%s AND (%s)\', graph_keyword, phrase);\n"
"err:\n"
"return \'^\"#nosuch\"\';\n"
"}\n"
"--src sparql.sql:9545\n";

static const char *proc258 = 
" create function DB.DBA.RDF_OBJ_PATCH_CONTAINS_BY_MANY_GRAPHS (in phrase varchar, in graph_iris any)\n"
"{\n"
"declare isfirst, gctr, gcount integer;\n"
"declare ses, graph_keyword any;\n"
"whenever sqlstate \'*\' goto err;\n"
"gcount := length (graph_iris);\n"
"ses := string_output ();\n"
"isfirst := 1;\n"
"for (gctr := 0; gctr < gcount; gctr := gctr + 1)\n"
"{\n"
"graph_keyword := iri_to_id (graph_iris[gctr], 0, 0);\n"
"if (not isinteger (graph_keyword))\n"
"{\n"
"if (isfirst)\n"
"{\n"
"http (\'^\', ses);\n"
"isfirst := 0;\n"
"}\n"
"else\n"
"http (\' OR ^\', ses);\n"
"http (WS.WS.STR_SQL_APOS (rdf_graph_keyword (graph_keyword)), ses);\n"
"}\n"
"}\n"
"if (not isfirst)\n"
"return sprintf (\'[__enc \"UTF-8\"] (%s) AND (%s)\', string_output_string (ses), phrase);\n"
"err:\n"
"return \'^\"#nosuch\"\';\n"
"}\n"
"--src sparql.sql:9560\n";

static const char *proc259 = 
"create procedure DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (in graph_iid IRI_ID, inout ro_id_dict any, in daq any := 0)\n"
"{\n"
"declare ro_id_offset, ro_ids_count integer;\n"
"declare new_ro_ids, vtb any;\n"
"declare gwordump varchar;\n"
"declare n_w, n_ins, n_upd, n_next integer;\n"
"next_batch:\n"
"new_ro_ids := dict_destructive_list_rnd_keys (ro_id_dict, 500000);\n"
"ro_ids_count := length (new_ro_ids);\n"
"if (0 = ro_ids_count)\n"
"return;\n"
"gwordump := \' \' || rdf_graph_keyword (graph_iid);\n"
"gwordump[0] := length (gwordump) - 1;\n"
"gvector_digit_sort (new_ro_ids, 1, 0, 1);\n"
"if (0 = sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"commit work;\n"
"cl_g_words (new_ro_ids, gwordump, daq);\n"
"goto next_batch;\n"
"}\n"
"vtb := vt_batch (__min (__max (ro_ids_count, 31), 500000));\n"
"commit work;\n"
"whenever sqlstate \'40001\' goto retry_add;\n"
"again:\n"
"for (ro_id_offset := 0; ro_id_offset < ro_ids_count; ro_id_offset := ro_id_offset + 1)\n"
"{\n"
"vt_batch_d_id (vtb, new_ro_ids[ro_id_offset]);\n"
"vt_batch_feed_wordump (vtb, gwordump, 0);\n"
"}\n"
"if (0 = sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"declare is_local_daq int;\n"
"if (0 = daq)\n"
"{\n"
"daq := daq (1);\n"
"is_local_daq := 1;\n"
"}\n"
"cl_g_text_index (vtb, daq);\n"
"if (is_local_daq)\n"
"{\n"
"while (daq_next (daq));\n"
"commit work;\n"
"goto next_batch;\n"
"}\n"
"}\n"
"else\n"
"\"DB\".\"DBA\".\"VT_BATCH_PROCESS_DB_DBA_RDF_OBJ\" (vtb, null);\n"
"commit work;\n"
"goto next_batch;\n"
"retry_add:\n"
"rollback work;\n"
"goto again;\n"
"}\n"
"--src sparql.sql:9590\n";

static const char *proc260 = 
"create procedure DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH_OLD (in graph_iid IRI_ID, inout ro_id_dict any)\n"
"{\n"
"declare start_vt_d_id, aligned_start_vt_d_id, uncommited_ro_id_offset, ro_id_offset, ro_ids_count integer;\n"
"declare old_d_id, old_d_id_2, carry_d_id, carry_d_id_2 integer;\n"
"declare old_data, carry_data varchar;\n"
"declare split_ctr, split_len integer;\n"
"declare dbg_smallest_d_id, dbg_largest_d_id, dbg_prev_d_id, dbg_prev_d_id_2 integer;\n"
"declare split any;\n"
"declare cr cursor for (\n"
"select VT_D_ID, VT_D_ID_2, coalesce (VT_DATA, cast (VT_LONG_DATA as varchar)) from RDF_OBJ_RO_FLAGS_WORDS\n"
"where (VT_WORD = cast (graph_iid as varchar)) and (VT_D_ID >= aligned_start_vt_d_id) and VT_D_ID_2 >= start_vt_d_id for update);\n"
"declare new_ro_ids any;\n"
"\n"
"new_ro_ids := dict_list_keys (ro_id_dict, 2);\n"
"ro_ids_count := length (new_ro_ids);\n"
"if (0 = ro_ids_count)\n"
"return;\n"
"gvector_digit_sort (new_ro_ids, 1, 0, 1);\n"
"\n"
"dbg_smallest_d_id := new_ro_ids[0];\n"
"dbg_largest_d_id := new_ro_ids[length (new_ro_ids) - 1];\n"
"dbg_prev_d_id := 0;\n"
"dbg_prev_d_id_2 := 0;\n"
"\n"
"commit work;\n"
"whenever sqlstate \'40001\' goto retry_add;\n"
"uncommited_ro_id_offset := 0;\n"
"again:\n"
"ro_id_offset := uncommited_ro_id_offset;\n"
"start_vt_d_id := new_ro_ids[ro_id_offset];\n"
"aligned_start_vt_d_id := ((start_vt_d_id / 10000) * 10000);\n"
"carry_d_id := 0;\n"
"carry_d_id_2 := 0;\n"
"carry_data := \'\';\n"
"set isolation = \'serializable\';\n"
"whenever not found goto no_more_olds;\n"
"open cr (prefetch 1);\n"
"\n"
"next_split:\n"
"fetch cr into old_d_id, old_d_id_2, old_data;\n"
"split := DB.DBA.VT_COMPOSE_KEYWORD_INDEX_LINES (carry_d_id, carry_d_id_2, carry_data, old_d_id, old_d_id_2, old_data, ro_id_offset, new_ro_ids);\n"
"split_len := length (split);\n"
"split_ctr := 0;\n"
"if ((split_len > 0) and (split[split_len-1][0] = old_d_id))\n"
"{\n"
"if ((old_d_id_2 = split[split_len-1][1]) and (old_data = split[split_len-1][2]))\n"
"{ ; }\n"
"else\n"
"update RDF_OBJ_RO_FLAGS_WORDS set VT_D_ID_2 = split[split_len-1][1], VT_DATA = split[split_len-1][2], VT_LONG_DATA = null\n"
"where current of cr;\n"
"split_len := split_len - 1;\n"
"}\n"
"if (split_len > 0)\n"
"{\n"
"delete from RDF_OBJ_RO_FLAGS_WORDS\n"
"where (VT_WORD = cast (graph_iid as varchar)) and (VT_D_ID >= split[0][0]) and (VT_D_ID_2 <= split[split_len-1][1]);\n"
"}\n"
"for (split_ctr := 0; split_ctr < split_len; split_ctr := split_ctr+1)\n"
"{\n"
"insert replacing RDF_OBJ_RO_FLAGS_WORDS (VT_WORD, VT_D_ID, VT_D_ID_2, VT_DATA)\n"
"values (cast (graph_iid as varchar), split[split_ctr][0], split[split_ctr][1], split[split_ctr][2]);\n"
"}\n"
"if (carry_data = \'\')\n"
"{\n"
"commit work;\n"
"uncommited_ro_id_offset := ro_id_offset;\n"
"if (ro_id_offset >= ro_ids_count)\n"
"{\n"
"start_vt_d_id := 1024 * 65536 * 65536 * 65536;\n"
"goto no_more_olds;\n"
"}\n"
"start_vt_d_id := new_ro_ids[uncommited_ro_id_offset];\n"
"aligned_start_vt_d_id := ((start_vt_d_id / 10000) * 10000);\n"
"close cr;\n"
"open cr (prefetch 1);\n"
"}\n"
"goto next_split;\n"
"\n"
"no_more_olds:\n"
"split := DB.DBA.VT_COMPOSE_KEYWORD_INDEX_LINES (carry_d_id, carry_d_id_2, carry_data, null, null, null, ro_id_offset, new_ro_ids);\n"
"split_len := length (split);\n"
"split_ctr := 0;\n"
"if (split_len > 0)\n"
"{\n"
"delete from RDF_OBJ_RO_FLAGS_WORDS\n"
"where (VT_WORD = cast (graph_iid as varchar)) and (VT_D_ID >= split[0][0]) and (VT_D_ID_2 <= split[split_len-1][1]);\n"
"}\n"
"for (split_ctr := 0; split_ctr < split_len; split_ctr := split_ctr+1)\n"
"{\n"
"insert replacing RDF_OBJ_RO_FLAGS_WORDS (VT_WORD, VT_D_ID, VT_D_ID_2, VT_DATA)\n"
"values (cast (graph_iid as varchar), split[split_ctr][0], split[split_ctr][1], split[split_ctr][2]);\n"
"}\n"
"if (length (carry_data)  <> 0)\n"
"{\n"
"insert replacing RDF_OBJ_RO_FLAGS_WORDS (VT_WORD, VT_D_ID, VT_D_ID_2, VT_DATA)\n"
"values (cast (graph_iid as varchar), carry_d_id, carry_d_id_2, carry_data);\n"
"}\n"
"commit work;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"return;\n"
"retry_add:\n"
"close cr;\n"
"rollback work;\n"
"goto again;\n"
"}\n"
"--src sparql.sql:9645\n";

static const char *proc261 = 
"create function DB.DBA.RDF_OBJ_FT_RULE_ADD (in rule_g varchar, in rule_p varchar, in reason varchar) returns integer\n"
"{\n"
"declare rule_g_iid, rule_p_iid IRI_ID;\n"
"declare ro_id_dict any;\n"
"if (0 = sys_stat (\'cl_run_local_only\'))\n"
"signal (\'42000\', \'rdf_obj_ft_rule_add not available in cluster.  Do cl_text_index (1) to enable text index on all future rdf loads on cluster.\');\n"
"if (rule_g is null)\n"
"rule_g := \'\';\n"
"if (rule_p is null)\n"
"rule_p := \'\';\n"
"rule_g_iid := case (rule_g) when \'\' then null else iri_to_id (rule_g) end;\n"
"rule_p_iid := case (rule_p) when \'\' then null else iri_to_id (rule_p) end;\n"
"if (reason is null)\n"
"signal (\'RDFXX\', \'DB.DBA.RDF_OBJ_FT_RULE_ADD() expects string as argument 3\');\n"
"if (exists (\n"
"select top 1 1 from DB.DBA.RDF_OBJ_FT_RULES\n"
"where ROFR_G = rule_g and ROFR_P = rule_p and ROFR_REASON = reason))\n"
"return 0;\n"
"if (not exists (\n"
"select top 1 1 from DB.DBA.RDF_OBJ_FT_RULES\n"
"where (ROFR_G = rule_g or ROFR_G = \'\') and (ROFR_P = rule_p or ROFR_P = \'\') ) )\n"
"{\n"
"\n"
"commit work;\n"
"exec (\'checkpoint\');\n"
"__atomic (1);\n"
"declare exit handler for sqlstate \'*\' {\n"
"__atomic (0);\n"
"signal (__SQL_STATE, __SQL_MESSAGE); };\n"
"if ((rule_g <> \'\') and (rule_p <> \'\'))\n"
"{\n"
"ro_id_dict := dict_new (100000);\n"
"for (select O as obj from DB.DBA.RDF_QUAD where G=rule_g_iid and P=rule_p_iid and not isiri_id (O)) do\n"
"{\n"
"if (isstring (obj))\n"
"{\n"
"DB.DBA.RDF_OBJ_ADD (257, obj, 257, ro_id_dict);\n"
"commit work;\n"
"}\n"
"else\n"
"{\n"
"declare id integer;\n"
"id := rdf_box_ro_id (obj);\n"
"if (0 <> id)\n"
"{\n"
"update DB.DBA.RDF_OBJ set RO_FLAGS = bit_or (RO_FLAGS, 1) where RO_ID = id and not (bit_and (RO_FLAGS, 1));\n"
"\n"
"dict_put (ro_id_dict, id, 1);\n"
"}\n"
"commit work;\n"
"}\n"
"if (dict_size (ro_id_dict) > 100000)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (iri_to_id (rule_g), ro_id_dict);\n"
"}\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (iri_to_id (rule_g), ro_id_dict);\n"
"}\n"
"else if (rule_g <> \'\')\n"
"{\n"
"ro_id_dict := dict_new (100000);\n"
"for (select O as obj from DB.DBA.RDF_QUAD where G=rule_g_iid and not isiri_id (O)) do\n"
"{\n"
"if (isstring (obj))\n"
"{\n"
"DB.DBA.RDF_OBJ_ADD (257, obj, 257, ro_id_dict);\n"
"commit work;\n"
"}\n"
"else\n"
"{\n"
"declare id integer;\n"
"id := rdf_box_ro_id (obj);\n"
"if (0 <> id)\n"
"{\n"
"update DB.DBA.RDF_OBJ set RO_FLAGS = bit_or (RO_FLAGS, 1) where RO_ID = id and not (bit_and (RO_FLAGS, 1));\n"
"\n"
"dict_put (ro_id_dict, id, 1);\n"
"}\n"
"commit work;\n"
"}\n"
"if (dict_size (ro_id_dict) > 100000)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (iri_to_id (rule_g), ro_id_dict);\n"
"}\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (iri_to_id (rule_g), ro_id_dict);\n"
"}\n"
"else\n"
"{\n"
"declare old_g IRI_ID;\n"
"ro_id_dict := dict_new (100000);\n"
"old_g := #i0;\n"
"for (select O as obj, G as curr_g from DB.DBA.RDF_QUAD where ((rule_p = \'\') or equ (P,rule_p_iid)) and not isiri_id (O) ) do\n"
"{\n"
"if (isstring (obj))\n"
"{\n"
"if (curr_g <> old_g)\n"
"{\n"
"if (old_g <> #i0)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (old_g, ro_id_dict);\n"
"ro_id_dict := dict_new (100000);\n"
"old_g := curr_g;\n"
"}\n"
"DB.DBA.RDF_OBJ_ADD (257, obj, 257, ro_id_dict);\n"
"commit work;\n"
"if (dict_size (ro_id_dict) > 100000)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (curr_g, ro_id_dict);\n"
"}\n"
"else\n"
"{\n"
"declare id integer;\n"
"id := rdf_box_ro_id (obj);\n"
"if (0 <> id)\n"
"{\n"
"if (curr_g <> old_g)\n"
"{\n"
"if (old_g <> #i0)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (old_g, ro_id_dict);\n"
"ro_id_dict := dict_new (100000);\n"
"old_g := curr_g;\n"
"}\n"
"update DB.DBA.RDF_OBJ set RO_FLAGS = bit_or (RO_FLAGS, 1) where RO_ID = id and not (bit_and (RO_FLAGS, 1));\n"
"\n"
"dict_put (ro_id_dict, id, 1);\n"
"commit work;\n"
"if (dict_size (ro_id_dict) > 100000)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (curr_g, ro_id_dict);\n"
"}\n"
"}\n"
"}\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (old_g, ro_id_dict);\n"
"commit work;\n"
"}\n"
"__atomic (0);\n"
"exec (\'checkpoint\');\n"
"}\n"
"insert into DB.DBA.RDF_OBJ_FT_RULES (ROFR_G, ROFR_P, ROFR_REASON) values (rule_g, rule_p, reason);\n"
"commit work;\n"
"__rdf_obj_ft_rule_add (rule_g_iid, rule_p_iid, reason);\n"
"return 1;\n"
"}\n"
"--src sparql.sql:9772\n";

static const char *proc262 = 
"create function DB.DBA.RDF_OBJ_FT_RULE_DEL (in rule_g varchar, in rule_p varchar, in reason varchar) returns integer\n"
"{\n"
"declare rule_g_iid, rule_p_iid IRI_ID;\n"
"if (rule_g is null)\n"
"rule_g := \'\';\n"
"if (rule_p is null)\n"
"rule_p := \'\';\n"
"rule_g_iid := case (rule_g) when \'\' then null else iri_to_id (rule_g) end;\n"
"rule_p_iid := case (rule_p) when \'\' then null else iri_to_id (rule_p) end;\n"
"if (reason is null)\n"
"signal (\'RDFXX\', \'DB.DBA.RDF_OBJ_FT_RULE_DEL() expects string as argument 3\');\n"
"if (not exists (\n"
"select top 1 1 from DB.DBA.RDF_OBJ_FT_RULES\n"
"where ROFR_G = rule_g and ROFR_P = rule_p and ROFR_REASON = reason))\n"
"return 0;\n"
"delete from DB.DBA.RDF_OBJ_FT_RULES where ROFR_G = rule_g and ROFR_P = rule_p and ROFR_REASON = reason;\n"
"commit work;\n"
"__rdf_obj_ft_rule_del (rule_g_iid, rule_p_iid, reason);\n"
"return 1;\n"
"}\n"
"--src sparql.sql:9911\n";

static const char *proc263 = 
"create procedure DB.DBA.RDF_OBJ_FT_RECOVER ()\n"
"{\n"
"declare stat, msg, STRG varchar;\n"
"declare metas, rset any;\n"
"result_names (STRG);\n"
"exec (\'\n"
"select ROFR_G, ROFR_P, MAX (ROFR_REASON), COUNT (1), MIN (ROFR_REASON)\n"
"from DB.DBA.RDF_OBJ_FT_RULES\n"
"group by ROFR_G, ROFR_P\n"
"order by (1024 * length (ROFR_G) + 1024 * length (ROFR_P))\',\n"
"stat, msg, vector (), 100000, metas, rset);\n"
"foreach (any ftrule in rset) do\n"
"{\n"
"result (sprintf (\'Temporary drop of rule \"%s\" for graph <%s> predicate <%s>...\', ftrule[2], ftrule[0], ftrule[1]));\n"
"{ whenever sqlstate \'*\' goto add_back;\n"
"DB.DBA.RDF_OBJ_FT_RULE_DEL (ftrule[0], ftrule[1], ftrule[2]);\n"
"result (\'... done\'); }\n"
"add_back:\n"
"result (sprintf (\'Restoring rule \"%s\" for graph <%s> predicate <%s>...\', ftrule[2], ftrule[0], ftrule[1]));\n"
"{ whenever sqlstate \'*\' goto restored;\n"
"DB.DBA.RDF_OBJ_FT_RULE_ADD (ftrule[0], ftrule[1], ftrule[2]);\n"
"result (\'... done\'); }\n"
"restored:\n"
"if (ftrule[3] > 1)\n"
"result (sprintf (\'No need to re-apply additional %d rules for this graph and predicate, e.g., rule \"%s\"\', ftrule[4]));\n"
"}\n"
"result (\'Now starting incremental update of free-text index...\');\n"
"VT_INC_INDEX_DB_DBA_RDF_OBJ();\n"
"result (\'... done\');\n"
"}\n"
"--src sparql.sql:9933\n";

static const char *tbl14 = 
"create table DB.DBA.RDF_GRAPH_GROUP (\n"
"RGG_IID IRI_ID not null primary key,\n"
"RGG_IRI varchar not null,\n"
"RGG_MEMBER_PATTERN varchar,\n"
"RGG_COMMENT varchar\n"
")\n"
"alter index RDF_GRAPH_GROUP on DB.DBA.RDF_GRAPH_GROUP partition cluster replicated\n"
"create index RDF_GRAPH_GROUP_IRI on DB.DBA.RDF_GRAPH_GROUP (RGG_IRI) partition cluster replicated\n";

static const char *tbl15 = 
"create table DB.DBA.RDF_GRAPH_GROUP_MEMBER (\n"
"RGGM_GROUP_IID IRI_ID not null,\n"
"RGGM_MEMBER_IID IRI_ID not null,\n"
"primary key (RGGM_GROUP_IID, RGGM_MEMBER_IID)\n"
")\n"
"alter index RDF_GRAPH_GROUP_MEMBER on DB.DBA.RDF_GRAPH_GROUP_MEMBER partition cluster replicated\n";

static const char *tbl16 = 
"create table DB.DBA.RDF_GRAPH_USER (\n"
"RGU_GRAPH_IID IRI_ID not null,\n"
"RGU_USER_ID integer not null,\n"
"RGU_PERMISSIONS integer not null,\n"
"primary key (RGU_GRAPH_IID, RGU_USER_ID)\n"
")\n"
"alter index RDF_GRAPH_USER on DB.DBA.RDF_GRAPH_USER partition cluster replicated\n";

static const char *proc264 = 
"create procedure DB.DBA.RDF_GRAPH_GROUP_CREATE (in group_iri varchar, in quiet integer, in member_pattern varchar := null, in comment varchar := null)\n"
"{\n"
"declare group_iid IRI_ID;\n"
"group_iri := cast (group_iri as varchar);\n"
"group_iid := iri_to_id (group_iri);\n"
"if (exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = group_iri))\n"
"{\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = group_iri and RGG_IID = group_iid))\n"
"signal (\'RDF99\', sprintf (\'Integrity violation in DB.DBA.RDF_GRAPH_GROUP table, IRI=<%s>\', group_iri));\n"
"if (quiet)\n"
"return;\n"
"signal (\'RDF99\', sprintf (\'The graph group <%s> already exists (%s)\', group_iri, coalesce (\n"
"(select top 1 RGG_COMMENT from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = group_iri), \'group has no comment\' ) ) );\n"
"}\n"
"insert into DB.DBA.RDF_GRAPH_GROUP (\n"
"RGG_IID, RGG_IRI, RGG_MEMBER_PATTERN, RGG_COMMENT )\n"
"values (group_iid, group_iri, member_pattern, comment);\n"
"dict_put (__rdf_graph_group_dict(), group_iid, vector ());\n"
"commit work;\n"
"jso_mark_affected (group_iri);\n"
"}\n"
"--src sparql.sql:9995\n";

static const char *proc265 = 
"create procedure DB.DBA.RDF_GRAPH_GROUP_DROP (in group_iri varchar, in quiet integer)\n"
"{\n"
"declare group_iid IRI_ID;\n"
"group_iri := cast (group_iri as varchar);\n"
"group_iid := iri_to_id (group_iri);\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = group_iri))\n"
"{\n"
"if (exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = group_iri and RGG_IID = group_iid))\n"
"signal (\'RDF99\', sprintf (\'Integrity violation in DB.DBA.RDF_GRAPH_GROUP table, IRI=<%s>\', group_iri));\n"
"if (quiet)\n"
"return;\n"
"signal (\'RDF99\', sprintf (\'The graph group <%s> does not exist (%s)\', group_iri, coalesce (\n"
"(select top 1 RGG_COMMENT from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = group_iri), \'group has no comment\' ) ) );\n"
"}\n"
"if (group_iri = \'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\')\n"
"signal (\'RDF99\', sprintf (\'The graph group <%s> is a special one and used to control security, can not drop it\' ) );\n"
"delete from DB.DBA.RDF_GRAPH_GROUP_MEMBER where RGGM_GROUP_IID = group_iid;\n"
"delete from DB.DBA.RDF_GRAPH_GROUP where RGG_IID = group_iid;\n"
"commit work;\n"
"dict_remove (__rdf_graph_group_dict(), group_iid);\n"
"jso_mark_affected (group_iri);\n"
"if (group_iri = \'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\')\n"
"{\n"
"declare privates any;\n"
"privates := dict_list_keys (__rdf_graph_group_of_privates_dict(), 2);\n"
"foreach (IRI_ID iid in privates) do\n"
"jso_mark_affected (id_to_iri (iid));\n"
"}\n"
"}\n"
"--src sparql.sql:10018\n";

static const char *proc266 = 
"create procedure DB.DBA.RDF_GRAPH_CHECK_VISIBILITY_CHANGE (in memb_iri varchar, in special_iid IRI_ID)\n"
"{\n"
"declare memb_iid IRI_ID;\n"
"memb_iid := iri_to_id (memb_iri);\n"
"declare new_default_perms integer;\n"
"new_default_perms := (select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = special_iid and RGU_USER_ID = http_nobody_uid());\n"
"for (select g.RGU_PERMISSIONS as g_perms, s.RGU_PERMISSIONS as s_perms, g.RGU_USER_ID as uid\n"
"from DB.DBA.RDF_GRAPH_USER as g left outer join DB.DBA.RDF_GRAPH_USER as s on (g.RGU_USER_ID = s.RGU_USER_ID and s.RGU_GRAPH_IID = special_iid)\n"
"where g.RGU_GRAPH_IID = memb_iid ) do\n"
"{\n"
"if (s_perms is not null and bit_and (s_perms, bit_not (g_perms)))\n"
"signal (\'RDF99\', sprintf (\'Default %s permissions of user \"%s\" (UID %d) on RDF store can not be broader than permissions on specific graph <%s> so the graph can not be %s now\',\n"
"case (equ (special_iid, #i8192)) when 0 then \'\"world\"\' else \'\"private area\"\' end,\n"
"(select U_NAME from DB.DBA.SYS_USERS where U_ID = uid),\n"
"uid,\n"
"memb_iri,\n"
"case (equ (special_iid, #i8192)) when 0 then \'removed from the \"private area\"\' else \'added to the \"private area\"\' end ) );\n"
"if (new_default_perms is not null and bit_and (new_default_perms, bit_not (g_perms)))\n"
"signal (\'RDF99\', sprintf (\'Default %s permissions of unauthenticated user on RDF store can not be broader than permissions of user \"%s\" (UID %d)  on specific graph <%s> so the graph can not be %s now\',\n"
"case (equ (special_iid, #i8192)) when 0 then \'\"world\"\' else \'\"private area\"\' end,\n"
"(select U_NAME from DB.DBA.SYS_USERS where U_ID = uid),\n"
"uid,\n"
"memb_iri,\n"
"case (equ (special_iid, #i8192)) when 0 then \'removed from the \"private area\"\' else \'added to the \"private area\"\' end ) );\n"
"}\n"
"}\n"
"--src sparql.sql:10049\n";

static const char *proc267 = 
"create procedure DB.DBA.RDF_GRAPH_GROUP_INS_MEMONLY (in group_iri varchar, in group_iid IRI_ID, in memb_iri varchar, in memb_iid IRI_ID)\n"
"{\n"
"group_iri := cast (group_iri as varchar);\n"
"memb_iri := cast (memb_iri as varchar);\n"
"jso_mark_affected (group_iri);\n"
"dict_put (__rdf_graph_iri2id_dict(), __uname(group_iri), group_iid);\n"
"dict_put (__rdf_graph_id2iri_dict(), group_iid, __uname(group_iri));\n"
"dict_put (__rdf_graph_iri2id_dict(), __uname(memb_iri), memb_iid);\n"
"dict_put (__rdf_graph_id2iri_dict(), memb_iid, __uname(memb_iri));\n"
"if (group_iri = \'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\')\n"
"{\n"
"dict_put (__rdf_graph_group_of_privates_dict(), memb_iid, 1);\n"
"jso_mark_affected (memb_iri);\n"
"}\n"
"}\n"
"--src sparql.sql:10077\n";

static const char *proc268 = 
"create procedure DB.DBA.RDF_GRAPH_GROUP_INS (in group_iri varchar, in memb_iri varchar)\n"
"{\n"
"declare group_iid, memb_iid IRI_ID;\n"
"group_iri := cast (group_iri as varchar);\n"
"memb_iri := cast (memb_iri as varchar);\n"
"group_iid := iri_to_id (group_iri);\n"
"memb_iid := iri_to_id (memb_iri);\n"
"set isolation = \'serializable\';\n"
"commit work;\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = group_iri))\n"
"signal (\'RDF99\', sprintf (\'Graph group <%s> does not exist\', group_iri));\n"
"if (group_iri = \'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\')\n"
"DB.DBA.RDF_GRAPH_CHECK_VISIBILITY_CHANGE (memb_iri, #i8192);\n"
"insert soft DB.DBA.RDF_GRAPH_GROUP_MEMBER (RGGM_GROUP_IID, RGGM_MEMBER_IID)\n"
"values (group_iid, memb_iid);\n"
"dict_put (__rdf_graph_group_dict(), group_iid,\n"
"(select VECTOR_AGG (RGGM_MEMBER_IID) from DB.DBA.RDF_GRAPH_GROUP_MEMBER\n"
"where RGGM_GROUP_IID = group_iid\n"
"order by RGGM_MEMBER_IID ) );\n"
"commit work;\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'DB.DBA.RDF_GRAPH_GROUP_INS_MEMONLY (?, ?, ?, ?)\', vector (group_iri, group_iid, memb_iri, memb_iid));\n"
"}\n"
"--src sparql.sql:10094\n";

static const char *proc269 = 
"create procedure DB.DBA.RDF_GRAPH_GROUP_DEL_MEMONLY (in group_iri varchar, in group_iid IRI_ID, in memb_iri varchar, in memb_iid IRI_ID)\n"
"{\n"
"group_iri := cast (group_iri as varchar);\n"
"memb_iri := cast (memb_iri as varchar);\n"
"dict_put (__rdf_graph_iri2id_dict(), __uname(group_iri), group_iid);\n"
"dict_put (__rdf_graph_id2iri_dict(), group_iid, __uname(group_iri));\n"
"dict_put (__rdf_graph_iri2id_dict(), __uname(memb_iri), memb_iid);\n"
"dict_put (__rdf_graph_id2iri_dict(), memb_iid, __uname(memb_iri));\n"
"if (group_iri = \'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\')\n"
"{\n"
"dict_remove (__rdf_graph_group_of_privates_dict(), memb_iid);\n"
"jso_mark_affected (memb_iri);\n"
"}\n"
"}\n"
"--src sparql.sql:10118\n";

static const char *proc270 = 
"create procedure DB.DBA.RDF_GRAPH_GROUP_DEL (in group_iri varchar, in memb_iri varchar)\n"
"{\n"
"declare group_iid, memb_iid IRI_ID;\n"
"group_iri := cast (group_iri as varchar);\n"
"memb_iri := cast (memb_iri as varchar);\n"
"group_iid := iri_to_id (group_iri);\n"
"memb_iid := iri_to_id (memb_iri);\n"
"set isolation = \'serializable\';\n"
"commit work;\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = group_iri))\n"
"signal (\'RDF99\', sprintf (\'Graph group <%s> does not exist\', group_iri));\n"
"if (group_iri = \'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\')\n"
"DB.DBA.RDF_GRAPH_CHECK_VISIBILITY_CHANGE (memb_iri, #i0);\n"
"delete from DB.DBA.RDF_GRAPH_GROUP_MEMBER\n"
"where RGGM_GROUP_IID = group_iid and RGGM_MEMBER_IID = memb_iid;\n"
"dict_put (__rdf_graph_group_dict(), group_iid,\n"
"(select VECTOR_AGG (RGGM_MEMBER_IID) from DB.DBA.RDF_GRAPH_GROUP_MEMBER\n"
"where RGGM_GROUP_IID = group_iid\n"
"order by RGGM_MEMBER_IID ) );\n"
"commit work;\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'DB.DBA.RDF_GRAPH_GROUP_DEL_MEMONLY (?, ?, ?, ?)\', vector (group_iri, group_iid, memb_iri, memb_iid));\n"
"}\n"
"--src sparql.sql:10134\n";

static const char *proc271 = 
"create function DB.DBA.RDF_GRAPH_USER_PERMS_GET (in graph_iri varchar, in uid any) returns integer\n"
"{\n"
"declare graph_iid IRI_ID;\n"
"declare res integer;\n"
"graph_iid := iri_to_id (graph_iri);\n"
"if (isstring (uid))\n"
"uid := ((select U_ID from DB.DBA.SYS_USERS where U_NAME = uid and (U_NAME=\'nobody\' or (U_SQL_ENABLE and not U_ACCOUNT_DISABLED))));\n"
"if (uid is null)\n"
"return 0;\n"
"if (uid = 0)\n"
"return 1023;\n"
"res := coalesce (\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = graph_iid and RGU_USER_ID = uid),\n"
"__rdf_graph_approx_perms (graph_iid, uid) );\n"
"return res;\n"
"}\n"
"--src sparql.sql:10158\n";

static const char *proc272 = 
"create function DB.DBA.RDF_GRAPH_USER_PERMS_ACK (in graph_iri any, in uid any, in req_perms integer) returns integer\n"
"{\n"
"declare app_cbk, app_uid varchar;\n"
"declare graph_iid IRI_ID;\n"
"declare perms integer;\n"
"\n"
"graph_iid := iri_to_id (graph_iri);\n"
"if (__tag (uid) = __tag of vector)\n"
"{\n"
"app_cbk := uid[1];\n"
"app_uid := uid[2];\n"
"uid := uid[0];\n"
"}\n"
"else\n"
"app_cbk := NULL;\n"
"if (isstring (uid))\n"
"uid := ((select U_ID from DB.DBA.SYS_USERS where U_NAME = uid and (U_NAME=\'nobody\' or (U_SQL_ENABLE and not U_ACCOUNT_DISABLED))));\n"
"if (uid is null)\n"
"perms := 0;\n"
"else if (uid = 0)\n"
"perms := 1023;\n"
"else\n"
"{\n"
"perms := __rdf_graph_approx_perms (graph_iid, uid);\n"
"if (bit_and (perms, req_perms) <> req_perms)\n"
"perms := coalesce ((select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = graph_iid and RGU_USER_ID = uid), perms);\n"
"}\n"
"if (bit_and (perms, req_perms) <> req_perms)\n"
"return 0;\n"
"if (app_cbk is not null)\n"
"{\n"
"perms := call (app_cbk)(graph_iid, app_uid);\n"
"if (bit_and (perms, req_perms) <> req_perms)\n"
"return 0;\n"
"}\n"
"return 1;\n"
"}\n"
"--src sparql.sql:10176\n";

static const char *proc273 = 
" create function DB.DBA.RDF_GRAPH_USER_PERM_TITLE (in perms integer) returns varchar\n"
"{\n"
"if (bit_and (perms, 1))\n"
"return \'read\';\n"
"if (bit_and (perms, 2))\n"
"return \'write\';\n"
"if (bit_and (perms, 4))\n"
"return \'sponge\';\n"
"if (bit_and (perms, 8))\n"
"return \'get-group-list\';\n"
"return sprintf (\'\"%d\"\', perms);\n"
"}\n"
"--src sparql.sql:10216\n";

static const char *proc274 = 
"create function DB.DBA.RDF_GRAPH_USER_PERMS_ASSERT (in graph_iri varchar, in uid any, in req_perms integer, in opname varchar) returns varchar\n"
"{\n"
"declare app_cbk, app_uid varchar;\n"
"declare graph_iid IRI_ID;\n"
"declare perms integer;\n"
"\n"
"return __rgs_assert_cbk (graph_iri, uid, req_perms, opname);\n"
"graph_iid := iri_to_id (graph_iri);\n"
"if (__tag (uid) = __tag of vector)\n"
"{\n"
"app_cbk := uid[1];\n"
"app_uid := uid[2];\n"
"uid := uid[0];\n"
"}\n"
"else\n"
"app_cbk := NULL;\n"
"if (isstring (uid))\n"
"uid := ((select U_ID from DB.DBA.SYS_USERS where U_NAME = uid and (U_NAME=\'nobody\' or (U_SQL_ENABLE and not U_ACCOUNT_DISABLED))));\n"
"if (uid is null)\n"
"perms := 0;\n"
"else if (uid = 0)\n"
"perms := 1023;\n"
"else\n"
"perms := coalesce (\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = graph_iid and RGU_USER_ID = uid),\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = graph_iid and RGU_USER_ID = http_nobody_uid()),\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = #i0 and RGU_USER_ID = uid),\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = #i0 and RGU_USER_ID = http_nobody_uid()),\n"
"15 );\n"
"if (bit_and (perms, req_perms) <> req_perms)\n"
"signal (\'RDF02\', sprintf (\'%s access denied: database user %s (%s) has no %s permission on graph %s\',\n"
"opname, cast (uid as varchar), coalesce ((select top 1 U_NAME from DB.DBA.SYS_USERS where U_ID=uid)),\n"
"DB.DBA.RDF_GRAPH_USER_PERM_TITLE (bit_and (bit_not (perms), req_perms)),\n"
"graph_iri ) );\n"
"if (app_cbk is not null)\n"
"{\n"
"perms := call (app_cbk)(graph_iid, app_uid);\n"
"if (bit_and (perms, req_perms) <> req_perms)\n"
"signal (\'RDF02\', sprintf (\'%s access denied: application user %s has no %s permission on graph %s\',\n"
"opname, cast (uid as varchar), coalesce ((select top 1 U_NAME from DB.DBA.SYS_USERS where U_ID=uid)),\n"
"DB.DBA.RDF_GRAPH_USER_PERM_TITLE (bit_and (bit_not (perms), req_perms)),\n"
"graph_iri ) );\n"
"}\n"
"return graph_iri;\n"
"}\n"
"--src sparql.sql:10230\n";

static const char *proc275 = 
"create procedure DB.DBA.RDF_DEFAULT_USER_PERMS_SET_MEMONLY (in uname varchar, in uid integer, in perms integer, in special_iid IRI_ID, in set_private integer, in affected_jso any)\n"
"{\n"
"dict_put (__rdf_graph_default_perms_of_user_dict (set_private), uid, perms);\n"
"if (uid = http_nobody_uid())\n"
"dict_put (__rdf_graph_public_perms_dict(), special_iid, perms);\n"
"foreach (varchar jso_key in affected_jso) do\n"
"jso_mark_affected (jso_key);\n"
"}\n"
"--src sparql.sql:10277\n";

static const char *proc276 = 
"create procedure DB.DBA.RDF_DEFAULT_USER_PERMS_SET (in uname varchar, in perms integer, in set_private integer := 0)\n"
"{\n"
"declare uid integer;\n"
"declare special_iid IRI_ID;\n"
"declare affected_jso any;\n"
"\n"
"uid := ((select U_ID from DB.DBA.SYS_USERS where U_NAME = uname and (U_NAME=\'nobody\' or (U_SQL_ENABLE and not U_ACCOUNT_DISABLED))));\n"
"set isolation = \'serializable\';\n"
"commit work;\n"
"if (uid is null)\n"
"signal (\'RDF99\', sprintf (\'No active SQL user \"%s\" found, can not set its default permissions on RDF quad storage\', uname));\n"
"if (set_private)\n"
"{\n"
"special_iid := #i8192;\n"
"for (select RGU_GRAPH_IID, RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER\n"
"where RGU_GRAPH_IID <> #i0 and RGU_GRAPH_IID <> #i8192 and\n"
"RGU_USER_ID = uid and bit_and (bit_not (RGU_PERMISSIONS), perms) <> 0 and\n"
"exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP_MEMBER where\n"
"RGGM_GROUP_IID = iri_to_id (\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\') and\n"
"RGGM_MEMBER_IID = RGU_GRAPH_IID ) ) do\n"
"signal (\'RDF99\', sprintf (\'Default \"private area\" permissions of user \"%s\" on RDF quad store can not become broader than permissions on specific \"private\" graph <%s>\',\n"
"uname, id_to_iri (RGU_GRAPH_IID) ) );\n"
"}\n"
"else\n"
"{\n"
"special_iid := #i0;\n"
"for (select RGU_GRAPH_IID, RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER\n"
"where RGU_GRAPH_IID <> #i0 and RGU_GRAPH_IID <> #i8192 and\n"
"RGU_USER_ID = uid and bit_and (bit_not (RGU_PERMISSIONS), perms) <> 0 and\n"
"not exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP_MEMBER where\n"
"RGGM_GROUP_IID = iri_to_id (\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\') and\n"
"RGGM_MEMBER_IID = RGU_GRAPH_IID ) ) do\n"
"signal (\'RDF99\', sprintf (\'Default \"world\" permissions of user \"%s\" on RDF quad store can not become broader than permissions on specific \"world\" graph <%s>\',\n"
"uname, id_to_iri (RGU_GRAPH_IID) ) );\n"
"}\n"
"if (uname=\'nobody\')\n"
"{\n"
"for (select RGU_USER_ID, RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER\n"
"where RGU_USER_ID <> uid and RGU_GRAPH_IID = special_iid and bit_and (bit_not (RGU_PERMISSIONS), perms) <> 0 ) do\n"
"signal (\'RDF99\', sprintf (\'Default %s permissions of unauthenticated user (\"nobody\") on RDF quad store can not become broader than permissions of user %s (UID %d)\',\n"
"(case (set_private) when 0 then \'\"world\"\' else \'\"private area\"\' end),\n"
"(select top 1 U_NAME from Db.DBA.SYS_USERS where U_ID = RGU_USER_ID), RGU_USER_ID) );\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"if (uname <> \'dba\')\n"
"{\n"
"if (not (exists (select top 1 1 from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = #i0 and RGU_USER_ID = 0)))\n"
"DB.DBA.RDF_DEFAULT_USER_PERMS_SET (\'dba\', 1023);\n"
"if (not (exists (select top 1 1 from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = #i8192 and RGU_USER_ID = 0)))\n"
"DB.DBA.RDF_DEFAULT_USER_PERMS_SET (\'dba\', 1023, 1);\n"
"}\n"
"insert replacing DB.DBA.RDF_GRAPH_USER (RGU_GRAPH_IID, RGU_USER_ID, RGU_PERMISSIONS)\n"
"values (special_iid, uid, perms);\n"
"\n"
"commit work;\n"
"if (uname = \'nobody\')\n"
"affected_jso := ((select DB.DBA.VECTOR_AGG (sub.\"jso_key\")\n"
"from (sparql\n"
"define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select (str(?s)) as ?jso_key where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> { { ?s a virtrdf:QuadMap } union { ?s a virtrdf:QuadMap } } } ) sub\n"
"option (QUIETCAST) ));\n"
"else\n"
"affected_jso := vector (uname);\n"
"commit work;\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'DB.DBA.RDF_DEFAULT_USER_PERMS_SET_MEMONLY (?,?,?,?,?,?)\', vector (uname, uid, perms, special_iid, set_private, affected_jso));\n"
"}\n"
"--src sparql.sql:10287\n";

static const char *proc277 = 
"create procedure DB.DBA.RDF_GRAPH_USER_PERMS_SET_MEMONLY (in graph_iri varchar, in graph_iid IRI_ID, in uid integer, in perms integer)\n"
"{\n"
"graph_iri := cast (graph_iri as varchar);\n"
"dict_put (__rdf_graph_iri2id_dict(), __uname(graph_iri), graph_iid);\n"
"dict_put (__rdf_graph_id2iri_dict(), graph_iid, __uname(graph_iri));\n"
"if (uid = http_nobody_uid())\n"
"dict_put (__rdf_graph_public_perms_dict(), graph_iid, perms);\n"
"else\n"
"__rdf_graph_specific_perms_of_user (graph_iid, uid, perms);\n"
"jso_mark_affected (graph_iri);\n"
"}\n"
"--src sparql.sql:10360\n";

static const char *proc278 = 
"create procedure DB.DBA.RDF_GRAPH_USER_PERMS_SET (in graph_iri varchar, in uname varchar, in perms integer)\n"
"{\n"
"declare graph_iid IRI_ID;\n"
"declare uid, graph_is_private, common_perms integer;\n"
"declare special_iid IRI_ID;\n"
"\n"
"graph_iid := iri_to_id (graph_iri);\n"
"uid := ((select U_ID from DB.DBA.SYS_USERS where U_NAME = uname and (U_NAME=\'nobody\' or (U_SQL_ENABLE and not U_ACCOUNT_DISABLED))));\n"
"set isolation = \'serializable\';\n"
"commit work;\n"
"if (uid is null)\n"
"signal (\'RDF99\', sprintf (\'No active SQL user \"%s\" found, can not set its permissions on graph <%s>\', uname, graph_iri));\n"
"graph_is_private := (select count (1) from DB.DBA.RDF_GRAPH_GROUP_MEMBER where\n"
"RGGM_GROUP_IID = iri_to_id (\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\') and\n"
"RGGM_MEMBER_IID = graph_iid );\n"
"if (graph_is_private)\n"
"special_iid := #i8192;\n"
"else\n"
"special_iid := #i0;\n"
"common_perms := coalesce (\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = special_iid and RGU_USER_ID = uid),\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = special_iid and RGU_USER_ID = http_nobody_uid()),\n"
"15 );\n"
"if (bit_and (bit_not (perms), common_perms))\n"
"signal (\'RDF99\', sprintf (\'Default permissions of user \"%s\" on RDF quad store are broader than new permissions on specific graph <%s>\', uname, graph_iri));\n"
"if (uname = \'nobody\')\n"
"jso_mark_affected (graph_iri);\n"
"else\n"
"{\n"
"common_perms := coalesce (\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = graph_iid and RGU_USER_ID = http_nobody_uid()),\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = special_iid and RGU_USER_ID = http_nobody_uid()),\n"
"15 );\n"
"if (bit_and (bit_not (perms), common_perms))\n"
"signal (\'RDF99\', sprintf (\'Permissions of unauthenticated user are broader than new permissions of user \"%s\" on specific graph <%s>\', uname, graph_iri));\n"
"}\n"
"if (not (exists (select top 1 1 from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = #i0 and RGU_USER_ID = 0)))\n"
"DB.DBA.RDF_DEFAULT_USER_PERMS_SET (\'dba\', 1023);\n"
"if (not (exists (select top 1 1 from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = #i8192 and RGU_USER_ID = 0)))\n"
"DB.DBA.RDF_DEFAULT_USER_PERMS_SET (\'dba\', 1023, 1);\n"
"insert replacing DB.DBA.RDF_GRAPH_USER (RGU_GRAPH_IID, RGU_USER_ID, RGU_PERMISSIONS)\n"
"values (graph_iid, uid, perms);\n"
"\n"
"commit work;\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'DB.DBA.RDF_GRAPH_USER_PERMS_SET_MEMONLY (?,?,?,?)\', vector (graph_iri, graph_iid, uid, perms));\n"
"}\n"
"--src sparql.sql:10373\n";

static const char *proc279 = 
"create function DB.DBA.RDF_GRAPH_GROUP_LIST_GET (in group_iri any, in extra_graphs any, in uid any, in gs_app_cbk varchar, in gs_app_uid varchar, in req_perms integer) returns any\n"
"{\n"
"declare group_iid IRI_ID;\n"
"declare world_perms, private_perms, common_perms, perms integer;\n"
"declare perms_dict, full_list, filtered_list any;\n"
"\n"
"if (isstring (uid))\n"
"uid := ((select U_ID from DB.DBA.SYS_USERS where U_NAME = uid and (U_NAME=\'nobody\' or (U_SQL_ENABLE and not U_ACCOUNT_DISABLED))));\n"
"if (uid is null)\n"
"return vector ();\n"
"perms_dict := __rdf_graph_default_perms_of_user_dict(0);\n"
"world_perms := coalesce (\n"
"dict_get (perms_dict, uid, NULL),\n"
"dict_get (perms_dict, 0, NULL),\n"
"15 );\n"
"perms_dict := __rdf_graph_default_perms_of_user_dict(1);\n"
"private_perms := coalesce (\n"
"dict_get (perms_dict, uid, NULL),\n"
"dict_get (perms_dict, 0, NULL),\n"
"15 );\n"
"if (gs_app_cbk is not null)\n"
"{\n"
"world_perms := bit_and (world_perms, call (gs_app_cbk)(#i0, gs_app_uid));\n"
"private_perms := bit_and (private_perms, call (gs_app_cbk)(#i8192, gs_app_uid));\n"
"}\n"
"common_perms := bit_and (world_perms, private_perms);\n"
"\n"
"if (__tag (group_iri) = __tag of vector)\n"
"{\n"
"vectorbld_init (full_list);\n"
"foreach (any g_iri in group_iri) do\n"
"{\n"
"group_iid := iri_to_id (g_iri);\n"
"if (not bit_and (common_perms, 8))\n"
"{\n"
"perms := __rdf_graph_approx_perms (group_iid, uid);\n"
"if (not bit_and (perms, 8))\n"
"perms := coalesce (\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = group_iid and RGU_USER_ID = uid),\n"
"perms );\n"
"if (gs_app_cbk is not null and bit_and (perms, 8))\n"
"perms := bit_and (perms, call (gs_app_cbk)(group_iid, gs_app_uid));\n"
"\n"
"}\n"
"else\n"
"perms := common_perms;\n"
"if (bit_and (perms, 8))\n"
"vectorbld_concat_acc (full_list, dict_get (__rdf_graph_group_dict(), group_iid, vector ()));\n"
"}\n"
"vectorbld_final (full_list);\n"
"}\n"
"else\n"
"{\n"
"group_iid := iri_to_id (group_iri);\n"
"if (not bit_and (common_perms, 8))\n"
"{\n"
"perms := __rdf_graph_approx_perms (group_iid, uid);\n"
"if (not bit_and (perms, 8))\n"
"perms := coalesce (\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = group_iid and RGU_USER_ID = uid),\n"
"perms );\n"
"if (gs_app_cbk is not null and bit_and (perms, 8))\n"
"perms := bit_and (perms, call (gs_app_cbk)(group_iid, gs_app_uid));\n"
"\n"
"}\n"
"else\n"
"perms := common_perms;\n"
"if (bit_and (perms, 8))\n"
"full_list := dict_get (__rdf_graph_group_dict(), group_iid, vector ());\n"
"else\n"
"full_list := vector ();\n"
"}\n"
"\n"
"if (bit_and (common_perms, req_perms) = req_perms)\n"
"{\n"
"declare ctr integer;\n"
"if (extra_graphs is null)\n"
"return full_list;\n"
"ctr := length (extra_graphs);\n"
"while (ctr > 0)\n"
"{\n"
"ctr := ctr - 1;\n"
"extra_graphs [ctr] := iri_to_id (extra_graphs[ctr]);\n"
"}\n"
"return vector_concat (full_list, extra_graphs);\n"
"}\n"
"vectorbld_init (filtered_list);\n"
"foreach (IRI_ID member_iid in full_list) do\n"
"{\n"
"perms := __rdf_graph_approx_perms (member_iid, uid);\n"
"if (bit_and (perms, req_perms) <> req_perms)\n"
"perms := coalesce (\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = member_iid and RGU_USER_ID = uid),\n"
"dict_get (__rdf_graph_public_perms_dict(), member_iid, NULL),\n"
"perms );\n"
"if (gs_app_cbk is not null and bit_and (perms, req_perms) = req_perms)\n"
"perms := bit_and (perms, call (gs_app_cbk)(member_iid, gs_app_uid));\n"
"\n"
"if (bit_and (perms, req_perms) = req_perms)\n"
"vectorbld_acc (filtered_list, member_iid);\n"
"}\n"
"foreach (any g in extra_graphs) do\n"
"{\n"
"declare g_iid IRI_ID;\n"
"g_iid := iri_to_id (g);\n"
"perms := coalesce (\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = g_iid and RGU_USER_ID = uid),\n"
"dict_get (__rdf_graph_public_perms_dict(), g_iid, NULL),\n"
"common_perms );\n"
"if (gs_app_cbk is not null and bit_and (perms, req_perms) = req_perms)\n"
"perms := bit_and (perms, call (gs_app_cbk)(g_iid, gs_app_uid));\n"
"\n"
"if (bit_and (perms, req_perms) = req_perms)\n"
"vectorbld_acc (filtered_list, g_iid);\n"
"}\n"
"vectorbld_final (filtered_list);\n"
"return filtered_list;\n"
"}\n"
"--src sparql.sql:10421\n";

static const char *proc280 = 
"create procedure DB.DBA.SPARQL_RELOAD_QM_GRAPH ()\n"
"{\n"
"declare ver varchar;\n"
"declare inx int;\n"
"ver := \'2010-01-19 0001v6g\';\n"
"if (USER <> \'dba\')\n"
"signal (\'RDFXX\', \'Only DBA can reload quad map metadata\');\n"
"if (not exists (sparql define input:storage \"\" ask where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"<http://www.openlinksw.com/sparql/virtrdf-data-formats.ttl>\n"
"virtrdf:version ?:ver\n"
"} } ) )\n"
"{\n"
"declare txt1, txt2 varchar;\n"
"declare jso_sys_g_iid IRI_ID;\n"
"declare dict1, lst1, dict2, lst2, sum_lst any;\n"
"txt1 := cast ( DB.DBA.XML_URI_GET (\n"
"\'http://www.openlinksw.com/sparql/virtrdf-data-formats.ttl\', \'\' ) as varchar );\n"
"txt2 := \'\n"
"@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n"
"@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"@prefix owl: <http://www.w3.org/2002/07/owl#> .\n"
"@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n"
"@prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#> .\n"
"@prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#> .\n"
"\n"
"virtrdf:DefaultQuadStorage\n"
"rdf:type virtrdf:QuadStorage ;\n"
"virtrdf:qsUserMaps virtrdf:DefaultQuadStorage-UserMaps ;\n"
"virtrdf:qsDefaultMap virtrdf:DefaultQuadMap ;\n"
"virtrdf:qsMatchingFlags virtrdf:SPART_QS_NO_IMPLICIT_USER_QM .\n"
"virtrdf:DefaultQuadStorage-UserMaps\n"
"rdf:type virtrdf:array-of-QuadMap .\n"
"\';\n"
"jso_sys_g_iid := iri_to_id (JSO_SYS_GRAPH ());\n"
"dict1 := DB.DBA.RDF_TTL2HASH (txt1, \'\');\n"
"dict2 := DB.DBA.RDF_TTL2HASH (txt2, \'\');\n"
"lst1 := dict_list_keys (dict1, 1);\n"
"lst2 := dict_list_keys (dict2, 1);\n"
"sum_lst := vector_concat (lst1, lst2);\n"
"inx := 0;\n"
"foreach (any triple in sum_lst) do\n"
"{\n"
"if ((triple[1] = iri_to_id (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\')) and\n"
"isiri_id (triple[2]) and (triple[2] = iri_to_id (\'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\')))\n"
"{\n"
"\n"
"delete from DB.DBA.RDF_QUAD where G = jso_sys_g_iid and S = triple[0];\n"
"}\n"
"else\n"
"delete from DB.DBA.RDF_QUAD where G = jso_sys_g_iid and S = triple[0] and P = triple[1];\n"
"if (\n"
"triple[0] = iri_to_id (\'http://www.openlinksw.com/sparql/virtrdf-data-formats.ttl\')\n"
"and\n"
"triple[1] = iri_to_id (\'http://www.openlinksw.com/schemas/virtrdf#version\')\n"
"and\n"
"triple[2] <> ver\n"
")\n"
"{\n"
"log_message (sprintf (\'RDF metadata version: %s\', ver));\n"
"triple[2] := ver;\n"
"sum_lst[inx] := triple;\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"DB.DBA.RDF_INSERT_TRIPLES (jso_sys_g_iid, sum_lst);\n"
"commit work;\n"
"}\n"
"DB.DBA.JSO_LOAD_AND_PIN_SYS_GRAPH ();\n"
"sequence_set (\'RDF_URL_IID_NAMED\', 1010000, 1);\n"
"sequence_set (\'RDF_URL_IID_BLANK\', iri_id_num (min_bnode_iri_id ()) + 10000, 1);\n"
"sequence_set (\'RDF_URL_IID_NAMED_BLANK\', iri_id_num (min_named_bnode_iri_id ()) + 10000, 1);\n"
"sequence_set (\'RDF_PREF_SEQ\', 101, 1);\n"
"sequence_set (\'RDF_RO_ID\', 1001, 1);\n"
"}\n"
"--src sparql.sql:10544\n";

static const char *proc281 = 
"create procedure DB.DBA.RDF_CREATE_SPARQL_ROLES ()\n"
"{\n"
"declare state, msg varchar;\n"
"declare cmds any;\n"
"cmds := vector (\n"
"\'create role SPARQL_SELECT\',\n"
"\'create role SPARQL_SPONGE\',\n"
"\'create role SPARQL_UPDATE\',\n"
"\'grant SPARQL_SELECT to SPARQL_UPDATE\',\n"
"\'grant SPARQL_SELECT to SPARQL_SPONGE\',\n"
"\'grant SPARQL_SPONGE to SPARQL_UPDATE\',\n"
"\'grant select on DB.DBA.RDF_QUAD to SPARQL_SELECT\',\n"
"\'grant all on DB.DBA.RDF_QUAD to SPARQL_UPDATE\',\n"
"\'grant select on DB.DBA.RDF_PREFIX to SPARQL_SELECT\',\n"
"\'grant all on DB.DBA.RDF_PREFIX to SPARQL_UPDATE\',\n"
"\'grant select on DB.DBA.RDF_IRI to SPARQL_SELECT\',\n"
"\'grant all on DB.DBA.RDF_IRI to SPARQL_UPDATE\',\n"
"\'grant select on DB.DBA.RDF_OBJ to SPARQL_SELECT\',\n"
"\'grant all on DB.DBA.RDF_OBJ to SPARQL_UPDATE\',\n"
"\n"
"\n"
"\'grant select on DB.DBA.RDF_DATATYPE to SPARQL_SELECT\',\n"
"\'grant all on DB.DBA.RDF_DATATYPE to SPARQL_UPDATE\',\n"
"\'grant select on DB.DBA.RDF_LANGUAGE to SPARQL_SELECT\',\n"
"\'grant all on DB.DBA.RDF_LANGUAGE to SPARQL_UPDATE\',\n"
"\'grant select on DB.DBA.SYS_SPARQL_HOST to SPARQL_SELECT\',\n"
"\'grant all on DB.DBA.SYS_SPARQL_HOST to SPARQL_UPDATE\',\n"
"\'grant select on DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH to SPARQL_SELECT\',\n"
"\'grant all on DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH to SPARQL_UPDATE\',\n"
"\'grant select on DB.DBA.SYS_FAKE_0 to SPARQL_SELECT\',\n"
"\'grant select on DB.DBA.SYS_FAKE_1 to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_GLOBAL_RESET to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_IID_OF_QNAME to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_IID_OF_QNAME_SAFE to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_IID_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_QNAME_OF_IID to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_GRAPH_IIDS_OF_QNAMES to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TWOBYTE_OF_DATATYPE to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TWOBYTE_OF_LANGUAGE to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RQ_LONG_OF_O to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RQ_SQLVAL_OF_O to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_BOOL_OF_O to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RQ_IID_OF_O to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RQ_O_IS_LIT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_OBJ_ADD to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_OBJ_FIND_EXISTING to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_FT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_STRINGS to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_LONG_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_DATATYPE_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_LANGUAGE_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_SQLVAL_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_BOOL_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_QNAME_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_STRSQLVAL_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_OBJ_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_OBJ_OF_SQLVAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_LONG_OF_SQLVAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL_STRINGS to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_QNAME_OF_LONG_SAFE to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_SQLVAL_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_BOOL_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_DATATYPE_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_DATATYPE_IRI_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_LANGUAGE_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_STRSQLVAL_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_WIDESTRSQLVAL_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_LONG_OF_SQLVAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_QUAD_URI to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_QUAD_URI_L to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_QUAD_URI_L_TYPED to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_NEW_GRAPH to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_NEW_BLANK to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_GET_IID to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_TRIPLE to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_TRIPLE_L to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_TRIPLE_XLAT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_TRIPLE_L_XLAT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_WITH_IRI_TRANSLATION to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TTL2HASH_EXEC_GET_IID to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TTL2HASH to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_LOAD_RDFXML to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_LOAD_RDFA to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_LOAD_RDFA_WITH_IRI_TRANSLATION to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_RDFXML_TO_DICT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_LONG_TO_TTL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_TTL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_NT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_GRAPH_TO_TTL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_RDF_XML_TEXT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_TALIS_JSON to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_RDFA_XHTML to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_INIT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_ACC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_FIN to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_INIT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_ACC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_FIN to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_INIT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_ACC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_FIN to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_INIT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_ACC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_FIN to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TTL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_NT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_RDF_XML to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_INSERT_TRIPLES to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_DELETE_TRIPLES to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_DELETE_TRIPLES_AGG to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_MODIFY_TRIPLES to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARQL_INSERT_DICT_CONTENT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARQL_DELETE_DICT_CONTENT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARQL_MODIFY_BY_DICT_CONTENTS to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARUL_CLEAR to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARUL_LOAD to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARUL_CREATE to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARUL_DROP to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARUL_RUN to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_AGG_INIT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_AGG_ACC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_AGG_FIN to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_DICT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_DICT_SPO to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_DICT_SPO_PHYSICAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_DICT_CBD to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_DICT_CBD_PHYSICAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_CONSTRUCT_INIT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_CONSTRUCT_ACC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_CONSTRUCT_FIN to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TYPEMIN_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TYPEMAX_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_IID_CMP to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_OBJ_CMP to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_LONG_CMP to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.TTLP_MT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_MT_LOCAL_FILE to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_TRIPLE_W to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_TRIPLE_L_W to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_NEW_GRAPH_A to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_TRIPLE_A to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_TRIPLE_L_A to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_LOAD_RDFXML_MT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_LOAD_HTTP_RESPONSE to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_FORGET_HTTP_RESPONSE to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_COMMIT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_PROC_COLS to \"SPARQL\"\',\n"
"\'grant execute on DB.DBA.RDF_GRAPH_USER_PERMS_ACK to \"SPARQL_SELECT\"\',\n"
"\'grant execute on DB.DBA.RDF_GRAPH_USER_PERMS_ASSERT to \"SPARQL_SELECT\"\',\n"
"\'grant execute on DB.DBA.RDF_GRAPH_GROUP_LIST_GET to \"SPARQL_SELECT\"\' );\n"
"foreach (varchar cmd in cmds) do\n"
"{\n"
"exec (cmd, state, msg);\n"
"}\n"
"}\n"
"--src sparql.sql:10621\n";

static const char *proc282 = 
"create procedure DB.DBA.RDF_QUAD_AUDIT ()\n"
"{\n"
"declare stat, msg varchar;\n"
"declare err_dict any;\n"
"result_names (stat, msg);\n"
"if (exists (select top 1 1 from DB.DBA.SYS_COLS\n"
"where \"TABLE\" = fix_identifier_case (\'DB.DBA.RDF_OBJ_RO_FLAGS_WORDS\')\n"
"and \"COLUMN\" = fix_identifier_case (\'VT_WORD\') )\n"
"and exists (select top 1 1 from DB.DBA.SYS_COLS\n"
"where \"TABLE\" = fix_identifier_case (\'DB.DBA.RDF_OBJ\')\n"
"and \"COLUMN\" = fix_identifier_case (\'RO_FLAGS\')\n"
"and COL_DTP = 188 ) )\n"
"goto check_new_style;\n"
"err_dict := dict_new ();\n"
"if (isstring (registry_get (\'DB.DBA.RDF_QUAD_FT_UPGRADE\')))\n"
"{\n"
"result (\'ERRol\', \'old layout but isstring (registry_get (\'\'DB.DBA.RDF_QUAD_FT_UPGRADE\'\'))\');\n"
"return;\n"
"}\n"
"for (select O as o_old from DB.DBA.RDF_QUAD where isstring (O)) do\n"
"{\n"
"declare o_old_len integer;\n"
"declare o_long any;\n"
"declare o_strval varchar;\n"
"declare val_len, o_id integeR;\n"
"declare o_dt, o_lang integeR;\n"
"o_old_len := length (o_old);\n"
"if (dict_size (err_dict) > 10000)\n"
"{\n"
"result (\'ERRxx\', \'Too many errors, bye\');\n"
"return;\n"
"}\n"
"if (dict_get (err_dict, o_old, 0))\n"
"goto known_bug;\n"
"if (o_old_len = 29)\n"
"{\n"
"if (o_old [22] <> 0)\n"
"{ result (\'ERRol\', sprintf (\'ill literal |%U| (escaped like URL)\', o_old)); dict_put (err_dict, o_old, 1); }\n"
"else\n"
"{\n"
"o_long := jso_parse_digest (o_old);\n"
"o_strval := (select case (isnull (RO_LONG)) when 0 then blob_to_string (RO_LONG) else RO_VAL end from DB.DBA.RDF_OBJ where RO_ID = o_long[3]);\n"
"if (o_strval is null)\n"
"{ result (\'ERRol\', sprintf (\'Non-existing RO_ID %d in literal |%U| (escaped like URL)\', o_long[3], o_old)); dict_put (err_dict, o_old, 1); }\n"
"else if (\"LEFT\" (o_strval, 20) <> o_long[1])\n"
"{ result (\'ERRol\', sprintf (\'Full value of RO_ID %d starts with |%U|, does not match to literal |%U| (escaped like URL)\', o_long[3], \"LEFT\" (o_strval, 20), o_old)); dict_put (err_dict, o_old, 1); }\n"
"o_dt := o_long[0];\n"
"o_lang := o_long[2];\n"
"}\n"
"}\n"
"else if (o_old_len < 5)\n"
"{ result (\'ERRot\', sprintf (\'ill literal |%U| (escaped like URL)\', o_old)); dict_put (err_dict, o_old, 1); }\n"
"else if (o_old_len < 29)\n"
"{\n"
"val_len := length (o_old) - 5;\n"
"o_dt := o_old[0] + o_old[1]*256;\n"
"o_lang := o_old[val_len+3] + o_old[val_len+4]*256;\n"
"if ((o_old [val_len+2] <> 0) or 0 = o_old[0] or 0 = o_old[1] or 0 = o_old[val_len+3] or 0 = o_old[val_len+4])\n"
"{ result (\'ERRos\', sprintf (\'ill short literal |%U| (escaped like URL)\', o_old)); dict_put (err_dict, o_old, 1); }\n"
"}\n"
"else\n"
"{ result (\'ERRoh\', sprintf (\'Too long literal |%U| (truncated, escaped like URL)\', \"LEFT\" (o_old, 100))); dict_put (err_dict, o_old, 1); }\n"
"known_bug: ;\n"
"}\n"
"return;\n"
"\n"
"check_new_style:\n"
"if (not isstring (registry_get (\'DB.DBA.RDF_QUAD_FT_UPGRADE\')))\n"
"result (\'ERRft\', \'new layout but not isstring (registry_get (\'\'DB.DBA.RDF_QUAD_FT_UPGRADE\'\'))\');\n"
"}\n"
"--src sparql.sql:10788\n";

static const char *proc283 = 
"create procedure DB.DBA.RDF_QUAD_FT_UPGRADE ()\n"
"{\n"
"declare stat, msg varchar;\n"
"declare fake integer;\n"
"if (USER <> \'dba\')\n"
"signal (\'RDFXX\', \'Only DBA can alter RDF_QUAD schema or initialize RDF storage\');\n"
"rdf_geo_init ();\n"
"\n"
"fake := (select count (rdf_cache_id (\'t\', RDT_QNAME, RDT_TWOBYTE)) from DB.DBA.RDF_DATATYPE);\n"
"fake := (select count (rdf_cache_id (\'l\', RL_ID, RL_TWOBYTE)) from DB.DBA.RDF_LANGUAGE);\n"
"fake := (select\n"
"count (dict_put (__rdf_graph_iri2id_dict(), __uname (id_to_iri (RGG_IID)), RGG_IID)) +\n"
"count (dict_put (__rdf_graph_id2iri_dict(), RGG_IID, __uname (id_to_iri (RGG_IID))))\n"
"from DB.DBA.RDF_GRAPH_GROUP );\n"
"fake := (select\n"
"count (dict_put (__rdf_graph_iri2id_dict(), __uname (id_to_iri (RGGM_MEMBER_IID)), RGGM_MEMBER_IID)) +\n"
"count (dict_put (__rdf_graph_id2iri_dict(), RGGM_MEMBER_IID, __uname (id_to_iri (RGGM_MEMBER_IID))))\n"
"from DB.DBA.RDF_GRAPH_GROUP_MEMBER );\n"
"fake := (select\n"
"count (dict_put (__rdf_graph_iri2id_dict(), __uname (id_to_iri (RGU_GRAPH_IID)), RGU_GRAPH_IID)) +\n"
"count (dict_put (__rdf_graph_id2iri_dict(), RGU_GRAPH_IID, __uname (id_to_iri (RGU_GRAPH_IID))))\n"
"from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID <> #i8192 );\n"
"fake := (select count (dict_put (__rdf_graph_group_dict(), g.RGG_IID,\n"
"(select DB.DBA.VECTOR_AGG (RGGM_MEMBER_IID) from DB.DBA.RDF_GRAPH_GROUP_MEMBER as gm\n"
"where gm.RGGM_GROUP_IID = g.RGG_IID order by gm.RGGM_MEMBER_IID ) ) )\n"
"from DB.DBA.RDF_GRAPH_GROUP as g );\n"
"fake := (select count (dict_put (__rdf_graph_group_of_privates_dict(), RGGM_MEMBER_IID, 1))\n"
"from DB.DBA.RDF_GRAPH_GROUP_MEMBER where RGGM_GROUP_IID = iri_to_id(\'PrivateGraphs\'));\n"
"fake := (select count (dict_put (__rdf_graph_default_perms_of_user_dict(0), RGU_USER_ID, RGU_PERMISSIONS))\n"
"from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = #i0 );\n"
"fake := (select count (dict_put (__rdf_graph_default_perms_of_user_dict(1), RGU_USER_ID, RGU_PERMISSIONS))\n"
"from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = #i8192 );\n"
"fake := (select count (dict_put (__rdf_graph_public_perms_dict(), RGU_GRAPH_IID, RGU_PERMISSIONS))\n"
"from DB.DBA.RDF_GRAPH_USER where RGU_USER_ID = http_nobody_uid () );\n"
"fake := (select count (__rdf_graph_specific_perms_of_user (RGU_GRAPH_IID, RGU_USER_ID, RGU_PERMISSIONS))\n"
"from DB.DBA.RDF_GRAPH_USER where RGU_USER_ID <> http_nobody_uid () and not (RGU_GRAPH_IID in (#i0, #i8192)) );\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"goto final_qm_reload;\n"
"if (244 = coalesce ((select COL_DTP from SYS_COLS where \"TABLE\" = \'DB.DBA.RDF_QUAD\' and \"COLUMN\"=\'G\'), 0))\n"
"{\n"
"__set_64bit_min_bnode_iri_id();\n"
"sequence_set (\'RDF_URL_IID_BLANK\', iri_id_num (min_bnode_iri_id ()), 1);\n"
"}\n"
"if (coalesce (cfg_item_value (virtuoso_ini_path (), \'SPARQL\', \'RecoveryMode\'), \'0\') > \'0\')\n"
"{\n"
"log_message (\'Switching to RecoveryMode as set in [SPARQL] section of the configuration.\');\n"
"log_message (\'For safety, the use of SPARQL_UPDATE role is restricted.\');\n"
"exec (\'revoke \"SPARQL_UPDATE\" from \"SPARQL\"\', stat, msg);\n"
"return;\n"
"}\n"
"if (not isstring (registry_get (\'DB.DBA.RDF_QUAD_FT_UPGRADE-tridgell32-2\')))\n"
"{\n"
"__atomic (1);\n"
"{\n"
"set isolation=\'uncommitted\';\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"log_message (\'Error during upgrade of RDF_OBJ:\');\n"
"log_message (__SQL_STATE || \': \' || \"LEFT\" (__SQL_MESSAGE, 1000));\n"
"goto describe_recovery;\n"
"};\n"
"declare rolong_cur cursor for select RO_VAL, RO_LONG from DB.DBA.RDF_OBJ where RO_LONG is not null and length (RO_VAL) = 6 for update;\n"
"whenever not found goto rolong_cur_end;\n"
"open rolong_cur;\n"
"while (1)\n"
"{\n"
"declare rl any;\n"
"declare old_rv, new_rv varchar;\n"
"fetch rolong_cur into old_rv, rl;\n"
"new_rv := tridgell32 (blob_to_string (rl));\n"
"if (new_rv <> old_rv)\n"
"update DB.DBA.RDF_OBJ set RO_VAL = new_rv where current of rolong_cur;\n"
"}\n"
"rolong_cur_end: ;\n"
"registry_set (\'DB.DBA.RDF_QUAD_FT_UPGRADE-tridgell32-2\', \'1\');\n"
"}\n"
"__atomic (0);\n"
"exec (\'checkpoint\');\n"
"}\n"
"tridgell_ok:\n"
"\n"
"if (exists (select top 1 1 from DB.DBA.SYS_COLS\n"
"where \"TABLE\" = fix_identifier_case (\'DB.DBA.RDF_OBJ_RO_FLAGS_WORDS\')\n"
"and \"COLUMN\" = fix_identifier_case (\'VT_WORD\') )\n"
"and exists (select top 1 1 from DB.DBA.SYS_COLS\n"
"where \"TABLE\" = fix_identifier_case (\'DB.DBA.RDF_OBJ\')\n"
"and \"COLUMN\" = fix_identifier_case (\'RO_FLAGS\')\n"
"and COL_DTP = 188 ) )\n"
"goto final_qm_reload;\n"
"exec (\'DB.DBA.vt_create_text_index (\n"
"fix_identifier_case (\'\'DB.DBA.RDF_OBJ\'\'),\n"
"fix_identifier_case (\'\'RO_FLAGS\'\'),\n"
"fix_identifier_case (\'\'RO_ID\'\'),\n"
"0, 0, vector (), 1, \'\'*ini*\'\', \'\'UTF-8-QR\'\')\', stat, msg);\n"
"__vt_index (\'DB.DBA.RDF_QUAD\', \'RDF_QUAD_OP\', \'O\', \'O\', \'DB.DBA.RDF_OBJ_RO_FLAGS_WORDS\');\n"
"exec (\'DB.DBA.vt_batch_update (fix_identifier_case (\'\'DB.DBA.RDF_OBJ\'\'), \'\'ON\'\', 1)\', stat, msg);\n"
"if (isstring (registry_get (\'DB.DBA.RDF_QUAD_FT_UPGRADE\')))\n"
"goto final_qm_reload;\n"
"__atomic (1);\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"log_message (\'Error during upgrade of free-text index of RDF_QUAD:\');\n"
"log_message (__SQL_STATE || \': \' || \"LEFT\" (__SQL_MESSAGE, 1000));\n"
"goto describe_recovery;\n"
"};\n"
"\n"
"log_enable (0);\n"
"if (exists (select top 1 1 from DB.DBA.RDF_QUAD))\n"
"log_message (\'Upgrading RDF indices.  Can be up to an hour per GB of RDF data.\');\n"
"registry_set (\'DB.DBA.RDF_QUAD_FT_UPGRADE\', \'1\');\n"
"if (exists (select top 1 1 from DB.DBA.SYS_COLS\n"
"where \"TABLE\" = fix_identifier_case (\'DB.DBA.RDF_OBJ\')\n"
"and \"COLUMN\" = fix_identifier_case (\'RO_DIGEST\')\n"
"and COL_DTP = __tag of varchar ))\n"
"{\n"
"exec (\'drop index RO_DIGEST\', stat, msg);\n"
"exec (\'alter table DB.DBA.RDF_OBJ drop RO_DIGEST\', stat, msg);\n"
"\n"
"exec (\'alter table DB.DBA.RDF_OBJ add RO_FLAGS smallint not null default 0\', stat, msg);\n"
"exec (\'alter table DB.DBA.RDF_OBJ add RO_DT_AND_LANG integer not null default 16843009\', stat, msg);\n"
"\n"
"commit work;\n"
"}\n"
"set isolation=\'uncommitted\';\n"
"{\n"
"declare longtyped_cur cursor for select G,S,P,O\n"
"from DB.DBA.RDF_QUAD\n"
"where isstring (O) and length (O) = 29;\n"
"declare g_old, s_old, p_old any;\n"
"declare o_old varchar;\n"
"declare val_len, o_id integeR;\n"
"declare o_new any;\n"
"whenever not found goto longtyped_cur_end;\n"
"open longtyped_cur;\n"
"while (1)\n"
"{\n"
"declare o_long any;\n"
"declare o_strval varchar;\n"
"fetch longtyped_cur into g_old, s_old, p_old, o_old;\n"
"\n"
"if (o_old [22] <> 0)\n"
"{\n"
"log_message (\'The function DB.DBA.RDF_QUAD_FT_UPGRADE() has found ill formed object literal in DB.DBA.RDF_QUAD\');\n"
"log_message (\'This means that this version of Virtuoso server can not process RDF data stored in the database.\');\n"
"log_message (\'To fix the problem, remove the transaction log and start previous version of Virtuoso.\');\n"
"log_message (sprintf (\'The example of ill literal is |%U|, if escaped like URL\', o_old));\n"
"goto describe_recovery;\n"
"}\n"
"o_long := jso_parse_digest (o_old);\n"
"o_strval := (select case (isnull (RO_LONG)) when 0 then blob_to_string (RO_LONG) else RO_VAL end from DB.DBA.RDF_OBJ where RO_ID = o_long[3]);\n"
"o_new := DB.DBA.RDF_OBJ_ADD (o_long[0], o_strval, o_long[2]);\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O) values (g_old, s_old, p_old, o_new);\n"
"}\n"
"longtyped_cur_end: ;\n"
"}\n"
"delete from DB.DBA.RDF_QUAD where isstring (O) and length (O) = 29;\n"
"\n"
"{\n"
"declare shortobj_cur cursor for select G,S,P,O from DB.DBA.RDF_QUAD where isstring (O) and length (O) < 29;\n"
"declare g_old, s_old, p_old any;\n"
"declare o_old varchar;\n"
"declare val_len, o_id integeR;\n"
"declare o_new any;\n"
"whenever not found goto shortobj_cur_end;\n"
"open shortobj_cur;\n"
"while (1)\n"
"{\n"
"declare o_dt, o_lang integeR;\n"
"fetch shortobj_cur into g_old, s_old, p_old, o_old;\n"
"val_len := length (o_old) - 5;\n"
"if (o_old [val_len+2] <> 0)\n"
"{\n"
"log_message (\'The function DB.DBA.RDF_QUAD_FT_UPGRADE() has found ill formed object literal in DB.DBA.RDF_QUAD\');\n"
"log_message (\'This means that this version of Virtuoso server can not process RDF data stored in the database.\');\n"
"log_message (\'To fix the problem, remove the transaction log and start previous version of Virtuoso.\');\n"
"log_message (sprintf (\'The example of ill literal is |%U|, if escaped like URL\', o_old));\n"
"goto describe_recovery;\n"
"}\n"
"o_dt := o_old[0] + o_old[1]*256;\n"
"o_lang := o_old[val_len+3] + o_old[val_len+4]*256;\n"
"o_new := DB.DBA.RDF_OBJ_ADD (o_dt, subseq (o_old, 2, val_len+2), o_lang);\n"
"if (isstring (o_new))\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O) values (g_old, s_old, p_old, o_new || \'012345678901234567890123456789\');\n"
"else\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O) values (g_old, s_old, p_old, o_new);\n"
"commit work;\n"
"}\n"
"shortobj_cur_end: ;\n"
"}\n"
"delete from DB.DBA.RDF_QUAD where isstring (O) and length (O) < 29;\n"
"\n"
"{\n"
"declare tmpval_cur cursor for select G,S,P,O\n"
"from DB.DBA.RDF_QUAD\n"
"where isstring (O) and length (O) > 29;\n"
"declare g_old, s_old, p_old any;\n"
"declare o_old varchar;\n"
"whenever not found goto tmpval_cur_end;\n"
"open tmpval_cur;\n"
"while (1)\n"
"{\n"
"fetch tmpval_cur into g_old, s_old, p_old, o_old;\n"
"\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O) values (g_old, s_old, p_old, subseq (o_old, 0, length (o_old) - 30));\n"
"}\n"
"tmpval_cur_end: ;\n"
"}\n"
"delete from DB.DBA.RDF_QUAD where isstring (O) and length (O) > 29;\n"
"\n"
"commit work;\n"
"log_enable (1);\n"
"}\n"
"__atomic (0);\n"
"exec (\'checkpoint\');\n"
"\n"
"final_qm_reload:\n"
"DB.DBA.SPARQL_RELOAD_QM_GRAPH ();\n"
"insert soft rdf_datatype (rdt_iid, rdt_twobyte, rdt_qname) values\n"
"(iri_to_id (\'http://www.openlinksw.com/schemas/virtrdf#Geometry\'), 256, \'http://www.openlinksw.com/schemas/virtrdf#Geometry\');\n"
"\n"
"return;\n"
"\n"
"describe_recovery:\n"
"log_message (\'Remove the transaction log and start previous version of Virtuoso.\');\n"
"log_message (\'You may use the database with new version of Virtuoso server for\');\n"
"log_message (\'diagnostics and error recovery; to make it possible, add parameter\');\n"
"log_message (\'\"RecoveryMode=1\" to the [SPARQL] section of \' || virtuoso_ini_path ());\n"
"log_message (\'and restart the server; remove the parameter and restart as soon as possible\');\n"
"log_message (\'This error is critical. The server will now exit. Sorry.\');\n"
"\n"
"raw_exit ();\n"
"}\n"
"--src sparql.sql:10860\n";


static const char *other30 = 
" DB.DBA.RDF_QUAD_FT_UPGRADE ()\n";
static const char *other31 = 
"DB.DBA.RDF_CREATE_SPARQL_ROLES ()\n";
static const char *proc284 = 
"create procedure rdfs_pn (in is_class int)\n"
"{\n"
"return case when is_class = 1 then iri_to_id (\'http://www.w3.org/2000/01/rdf-schema#subClassOf\')\n"
"else  iri_to_id (\'http://www.w3.org/2000/01/rdf-schema#subPropertyOf\') end;\n"
"}\n"
"--src sparql.sql:11108\n";

static const char *proc285 = 
"create procedure rdf_owl_sas_p (in gr iri_id, in name varchar, in super_c iri_id, in c iri_i, in visited any, inout supers any, in pos int)\n"
"{\n"
"for select o from rdf_quad where g = gr and p = rdf_sas_iri () and s = c do\n"
"{\n"
"rdfs_closure_1 (gr, name, super_c, o, 0, visited, supers, pos);\n"
"}\n"
"for select s from rdf_quad where g = gr and p = rdf_sas_iri () and o = c do\n"
"{\n"
"rdfs_closure_1 (gr, name, super_c, s, 0, visited, supers, pos);\n"
"}\n"
"}\n"
"--src sparql.sql:11116\n";

static const char *tbl17 = 
"create table DB.DBA.SYS_RDF_SCHEMA (RS_NAME VARCHAR , RS_URI VARCHAR, RS_G IRI_ID,\n"
"PRIMARY KEY (RS_NAME, RS_URI))\n"
"alter index SYS_RDF_SCHEMA on DB.DBA.SYS_RDF_SCHEMA partition cluster replicated\n";

static const char *proc286 = 
"create procedure rdfs_load_schema (in ri_name varchar, in gn varchar)\n"
"{\n"
"declare gr iri_id;\n"
"declare visited any;\n"
"declare supers any;\n"
"declare eq_c, eq_p iri_id;\n"
"declare cc, res, st, msg, meta  any;\n"
"declare v any;\n"
"declare inx int;\n"
"\n"
"gr := iri_to_id (gn, 0, 0);\n"
"if (isinteger (gr))\n"
"return;\n"
"\n"
"exec (sprintf (\'select S, P, O from DB.DBA.RDF_QUAD where G = __i2idn (\'\'%S\'\')  and (P = rdf_owl_iri (1) or P = rdf_owl_iri (0) or P = rdf_owl_iri (2) or P = rdf_owl_iri (3) or P = rdf_sas_iri ()) option (QUIETCAST)\', gn),\n"
"null, null,  vector (), 0, meta, null, cc);\n"
"\n"
"while (0 = exec_next (cc, null, null, res))\n"
"{\n"
"declare s, p, o any;\n"
"s := res[0]; p := res[1]; o := res[2];\n"
"if (p = rdf_sas_iri ())\n"
"{\n"
"rdf_inf_dir (ri_name, s, o, 2);\n"
"rdf_inf_dir (ri_name, s, o, 3);\n"
"}\n"
"else\n"
"rdf_inf_dir (ri_name, o, s, case when p = rdf_owl_iri (0) then 0 when p = rdf_owl_iri (1) then 1\n"
"when p = rdf_owl_iri (2) then 2 else 3 end);\n"
"}\n"
"exec_close (cc);\n"
"\n"
"v := (select vector_agg (S) from RDF_QUAD where G = gr and O = iri_to_id (\'http://www.w3.org/2002/07/owl#InverseFunctionalProperty\') and P = iri_to_id (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\') option (QUIETCAST));\n"
"if (0 < length (v))\n"
"{\n"
"rdf_inf_set_ifp_list (ri_name, v);\n"
"for (inx := 0; inx < length (v); inx := inx + 1)\n"
"{\n"
"declare excl any;\n"
"excl := (select vector_agg (O) from RDF_QUAD where S = v[inx] and P = iri_to_id (\'http://www.openlinksw.com/schemas/virtrdf#nullIFPValue\') and G = gr option (QUIETCAST));\n"
"if (length (excl) > 0)\n"
"rdf_inf_set_ifp_exclude_list (ri_name, v[inx], excl);\n"
"}\n"
"}\n"
"\n"
"v := (select DB.DBA.VECTOR_CONCAT_AGG (vector (id_to_iri (q1.S), id_to_iri (q1.O), id_to_iri (q1.O), id_to_iri (q1.S))) from DB.DBA.RDF_QUAD as q1 where\n"
"q1.G = gr and q1.P = iri_to_id (\'http://www.w3.org/2002/07/owl#inverseOf\') and\n"
"isiri_id (q1.O) and\n"
"((id_to_iri (q1.S) <= id_to_iri (q1.O)) or not exists\n"
"(select top 1 1 from DB.DBA.RDF_QUAD as q2 where\n"
"q2.G = gr and q2.P = iri_to_id (\'http://www.w3.org/2002/07/owl#inverseOf\') and q2.S = q1.O and q2.O = q1.S) )\n"
"option (QUIETCAST));\n"
"v := vector_concat (v,\n"
"(select DB.DBA.VECTOR_CONCAT_AGG (vector (id_to_iri (q1.S), id_to_iri (q1.S))) from RDF_QUAD as q1 where q1.G = gr and q1.O = iri_to_id (\'http://www.w3.org/2002/07/owl#SymmetricProperty\') and q1.P = iri_to_id (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\') option (QUIETCAST)) );\n"
"if (0 < length (v))\n"
"{\n"
"gvector_sort (v, 2, 0, 1);\n"
"rdf_inf_set_inverses (ri_name, v);\n"
"}\n"
"\n"
"v := (select DB.DBA.VECTOR_CONCAT_AGG (vector (id_to_iri (q1.S), 1)) from RDF_QUAD as q1 where q1.G = gr and q1.O = iri_to_id (\'http://www.w3.org/2002/07/owl#TransitiveProperty\') and q1.P = iri_to_id (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\') option (QUIETCAST));\n"
"if (0 < length (v))\n"
"{\n"
"gvector_sort (v, 2, 0, 1);\n"
"rdf_inf_set_prop_props (ri_name, v);\n"
"}\n"
"}\n"
"--src sparql.sql:11136\n";

static const char *proc287 = 
"create procedure rdf_schema_ld ()\n"
"{\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"return 0;\n"
"return (select  count (*) from sys_rdf_schema where 0 = rdfs_load_schema (rs_name, rs_uri));\n"
"}\n"
"--src sparql.sql:11206\n";

static const char *other32 = 
"rdf_schema_ld ()\n";
static const char *proc288 = 
"create procedure CL_RDF_INF_CHANGED_SRV (in name varchar)\n"
"{\n"
"set isolation = \'committed\';\n"
"return (select  count (*) from sys_rdf_schema where rs_name = name and 0 = rdfs_load_schema (rs_name, rs_uri));\n"
"}\n"
"--src sparql.sql:11218\n";

static const char *proc289 = 
"create procedure CL_RDF_INF_CHANGED (in name varchar)\n"
"{\n"
"declare aq any;\n"
"aq := async_queue (1);\n"
"aq_request (aq, \'DB.DBA.CL_RDF_INF_CHANGED_SRV\', vector (name));\n"
"aq_wait_all (aq);\n"
"}\n"
"--src sparql.sql:11225\n";

static const char *proc290 = 
"create procedure rdfs_rule_set (in name varchar, in gn varchar, in remove int := 0)\n"
"{\n"
"if (remove)\n"
"delete from sys_rdf_schema where rs_name = name and rs_uri = gn;\n"
"else\n"
"{\n"
"delete from sys_rdf_schema where rs_name = name and rs_uri = gn;\n"
"insert into sys_rdf_schema (rs_name, rs_uri) values (name, gn);\n"
"}\n"
"commit work;\n"
"if (0 = sys_stat (\'cl_run_local_only\'))\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'DB.DBA.CL_RDF_INF_CHANGED (?)\', vector (name));\n"
"else\n"
"{\n"
"rdf_inf_clear (name);\n"
"rdfs_load_schema (name, gn);\n"
"log_text (\'db.dba.rdfs_load_schema (?, ?)\', name, gn);\n"
"}\n"
"}\n"
"--src sparql.sql:11234\n";

static const char *proc291 = 
"create function DB.DBA.RDF_IID_OF_QNAME (in qname varchar) returns IRI_ID\n"
"{\n"
"whenever sqlstate \'*\' goto retnull;\n"
"return iri_to_id (qname, 0, null);\n"
"retnull:\n"
"return null;\n"
"}\n"
"--src sparql.sql:11255\n";

static const char *proc292 = 
"create procedure SPARQL_INI_PARAMS (inout metas any, inout dta any)\n"
"{\n"
"declare item_cnt int;\n"
"declare items any;\n"
"declare item_name, item_value varchar;\n"
"declare res_dict any;\n"
"declare tmp any;\n"
"\n"
"item_cnt := cfg_item_count (virtuoso_ini_path (), \'SPARQL\');\n"
"tmp := string_output ();\n"
"\n"
"for (declare i int, i := 0; i < item_cnt; i := i + 1)\n"
"{\n"
"item_name := cfg_item_name (virtuoso_ini_path (), \'SPARQL\', i);\n"
"item_value := cfg_item_value (virtuoso_ini_path (), \'SPARQL\', item_name);\n"
"http (sprintf (\'<http://www.openlinksw.com/schemas/virtini#SPARQL> <http://www.openlinksw.com/schemas/virtini#%U> \"%s\" .\\r\\n\',\n"
"item_name, item_value), tmp);\n"
"}\n"
"tmp := string_output_string (tmp);\n"
"res_dict := DB.DBA.RDF_TTL2HASH (tmp, \'\');\n"
"metas := vector (vector (vector (\'res_dict\', 242, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0)), 1);\n"
"dta := vector (vector (res_dict));\n"
"}\n"
"--src sparql.sql:11264\n";

/* sparql_io.sql */

static const char *proc293 = 
" create procedure DB.DBA.SPARQL_RSET_XML_WRITE_NS (inout ses any)\n"
"{\n"
"\n"
"http (\'<sparql xmlns=\"http://www.w3.org/2005/sparql-results#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2.xsd\">\', ses);\n"
"}\n"
"--src sparql_io.sql:24\n";

static const char *proc294 = 
" create procedure DB.DBA.SPARQL_RSET_XML_WRITE_HEAD (inout ses any, in colnames any)\n"
"{\n"
"declare i, col_count integer;\n"
"http (\'\\n <head>\', ses);\n"
"i := 0; col_count := length (colnames);\n"
"while (i < col_count)\n"
"{\n"
"http (sprintf (\'\\n  <variable name=\"%s\"/>\', colnames[i]), ses);\n"
"i := i + 1;\n"
"}\n"
"http (\'\\n </head>\', ses);\n"
"}\n"
"--src sparql_io.sql:33\n";

static const char *proc295 = 
" create function DB.DBA.SPARQL_RSET_XML_HTTP_PRE (in colnames any, in accept varchar)\n"
"{\n"
"declare ses integer;\n"
"ses := 0;\n"
"if (strchr (accept, \' \') is not null)\n"
"accept := subseq (accept, strchr (accept, \' \')+1);\n"
"http_header (\'Content-Type: \' || accept || \'; charset=UTF-8\\r\\n\');\n"
"http_flush (1);\n"
"DB.DBA.SPARQL_RSET_XML_WRITE_NS (ses);\n"
"DB.DBA.SPARQL_RSET_XML_WRITE_HEAD (ses, colnames);\n"
"http (\'\\n <results>\');\n"
"return colnames;\n"
"}\n"
"--src sparql_io.sql:48\n";

static const char *proc296 = 
" create procedure DB.DBA.SPARQL_RSET_XML_HTTP_INIT (inout env any)\n"
"{\n"
"env := 0;\n"
"}\n"
"--src sparql_io.sql:64\n";

static const char *proc297 = 
" create function DB.DBA.SPARQL_RSET_XML_HTTP_FINAL (inout env any)\n"
"{\n"
"http (\'\\n </results>\');\n"
"http (\'\\n</sparql>\');\n"
"}\n"
"--src sparql_io.sql:71\n";

static const char *other33 = 
" create aggregate DB.DBA.SPARQL_RSET_XML_HTTP (inout colnames any, inout row any) from\n"
"DB.DBA.SPARQL_RSET_XML_HTTP_INIT,\n"
"sparql_rset_xml_write_row,\n"
"DB.DBA.SPARQL_RSET_XML_HTTP_FINAL\n";

static const char *proc298 = 
" create function DB.DBA.SPARQL_DICT_XML_HTTP_PRE (in colnames any, in accept varchar)\n"
"{\n"
"declare ses integer;\n"
"http_header (\'Content-Type: \' || accept || \'; charset=UTF-8\\r\\n\');\n"
"http_flush (1);\n"
"ses := 0;\n"
"DB.DBA.SPARQL_RSET_XML_WRITE_NS (ses);\n"
"http (\'\\n <head><variable name=\"S\"/><variable name=\"P\"/><variable name=\"O\"/></head>\');\n"
"http (\'\\n <results distinct=\"false\" ordered=\"true\">\');\n"
"return colnames;\n"
"}\n"
"--src sparql_io.sql:87\n";

static const char *other34 = 
" create aggregate DB.DBA.SPARQL_DICT_XML_HTTP (inout colnames any, inout row any) from\n"
"DB.DBA.SPARQL_RSET_XML_HTTP_INIT,\n"
"sparql_dict_xml_write_row,\n"
"DB.DBA.SPARQL_RSET_XML_HTTP_FINAL\n";

static const char *proc299 = 
" create procedure SPARQL_RSET_TTL_WRITE_NS (inout ses any)\n"
"{\n"
"http (\'@prefix res: <http://www.w3.org/2005/sparql-results#> .\n"
"@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"_:_ a res:ResultSet .\\n\', ses);\n"
"}\n"
"--src sparql_io.sql:109\n";

static const char *proc300 = 
" create procedure DB.DBA.SPARQL_RSET_TTL_WRITE_HEAD (inout ses any, in colnames any)\n"
"{\n"
"declare i, col_count integer;\n"
"col_count := length (colnames);\n"
"if (0 = col_count)\n"
"return;\n"
"http (\'_:_ res:resultVariable \"\', ses);\n"
"for (i := 0; i < col_count; i := i + 1)\n"
"{\n"
"if (i > 0)\n"
"http (\'\" , \"\', ses);\n"
"http_escape (colnames[i], 11, ses, 0, 1);\n"
"}\n"
"http (\'\" .\\n\', ses);\n"
"}\n"
"--src sparql_io.sql:118\n";

static const char *proc301 = 
" create function DB.DBA.SPARQL_RSET_TTL_HTTP_PRE (in colnames any, in accept varchar)\n"
"{\n"
"declare ses, colctr, colcount integer;\n"
"declare res any;\n"
"\n"
"http_header (\'Content-Type: \' || accept || \'; charset=UTF-8\\r\\n\');\n"
"http_flush (1);\n"
"ses := 0;\n"
"DB.DBA.SPARQL_RSET_TTL_WRITE_NS (ses);\n"
"DB.DBA.SPARQL_RSET_TTL_WRITE_HEAD (ses, colnames);\n"
"colcount := length (colnames);\n"
"res := make_array (colcount * 7, \'any\');\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"res [colctr * 7] := colnames [colctr];\n"
"}\n"
"return vector (dict_new (16000), 0, \'\', \'\', \'\', 0, 0, res, 0);\n"
"}\n"
"--src sparql_io.sql:136\n";

static const char *proc302 = 
" create procedure DB.DBA.SPARQL_RSET_TTL_HTTP_INIT (inout env any)\n"
"{\n"
"env := 0;\n"
"}\n"
"--src sparql_io.sql:157\n";

static const char *proc303 = 
" create function DB.DBA.SPARQL_RSET_TTL_HTTP_FINAL (inout env any)\n"
"{\n"
" ;\n"
"}\n"
"--src sparql_io.sql:164\n";

static const char *other35 = 
" create aggregate DB.DBA.SPARQL_RSET_TTL_HTTP (inout colnames any, inout row any) from\n"
"DB.DBA.SPARQL_RSET_TTL_HTTP_INIT,\n"
"sparql_rset_ttl_write_row,\n"
"DB.DBA.SPARQL_RSET_TTL_HTTP_FINAL\n";

static const char *proc304 = 
" create procedure SPARQL_RSET_NT_WRITE_NS (inout ses any)\n"
"{\n"
"http (\'_:_ <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/1999/02/22-rdf-syntax-ns#ResultSet> .\\n\', ses);\n"
"}\n"
"--src sparql_io.sql:178\n";

static const char *proc305 = 
" create procedure DB.DBA.SPARQL_RSET_NT_WRITE_HEAD (inout ses any, in colnames any)\n"
"{\n"
"declare i, col_count integer;\n"
"col_count := length (colnames);\n"
"for (i := 0; i < col_count; i := i + 1)\n"
"{\n"
"http (\'_:_ <http://www.w3.org/2005/sparql-results#resultVariable> \"\', ses);\n"
"http_escape (colnames[i], 11, ses, 0, 1);\n"
"http (\'\" .\\n\', ses);\n"
"}\n"
"}\n"
"--src sparql_io.sql:185\n";

static const char *proc306 = 
" create function DB.DBA.SPARQL_RSET_NT_HTTP_PRE (in colnames any, in accept varchar)\n"
"{\n"
"declare ses, colctr, colcount integer;\n"
"declare res any;\n"
"\n"
"http_header (\'Content-Type: \' || accept || \'; charset=UTF-8\\r\\n\');\n"
"http_flush (1);\n"
"ses := 0;\n"
"DB.DBA.SPARQL_RSET_NT_WRITE_HEAD (ses, colnames);\n"
"colcount := length (colnames);\n"
"res := make_array (colcount * 7, \'any\');\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"res [colctr * 7] := colnames [colctr];\n"
"}\n"
"return vector (0, res, 0);\n"
"}\n"
"--src sparql_io.sql:199\n";

static const char *other36 = 
" create aggregate DB.DBA.SPARQL_RSET_NT_HTTP (inout colnames any, inout row any) from\n"
"DB.DBA.SPARQL_RSET_TTL_HTTP_INIT,\n"
"sparql_rset_nt_write_row,\n"
"DB.DBA.SPARQL_RSET_TTL_HTTP_FINAL\n";

static const char *proc307 = 
"create procedure DB.DBA.SPARQL_REXEC_INT (\n"
"in res_mode integer,\n"
"in service varchar,\n"
"in query varchar,\n"
"in dflt_graph varchar,\n"
"inout named_graphs any,\n"
"inout req_hdr any,\n"
"in maxrows integer,\n"
"inout metas any,\n"
"inout bnode_dict any\n"
")\n"
"{\n"
"declare req_uri, req_method, req_body, local_req_hdr, ret_body, ret_hdr any;\n"
"declare ret_content_type, ret_known_content_type, ret_format varchar;\n"
"req_body := string_output();\n"
"http (\'query=\', req_body);\n"
"http_url (query, 0, req_body);\n"
"if (dflt_graph is not null and dflt_graph <> \'\')\n"
"{\n"
"http (\'&default-graph-uri=\', req_body);\n"
"http_url (dflt_graph, 0, req_body);\n"
"}\n"
"foreach (varchar uri in named_graphs) do\n"
"{\n"
"http (\'&named-graph-uri=\', req_body);\n"
"http_url (uri, 0, req_body);\n"
"}\n"
"if (maxrows is not null)\n"
"http (sprintf (\'&maxrows=%d\', maxrows), req_body);\n"
"req_body := string_output_string (req_body);\n"
"local_req_hdr := \'Accept: application/sparql-results+xml, text/rdf+n3, text/rdf+ttl, text/rdf+turtle, text/turtle, application/turtle, application/x-turtle, application/rdf+xml, application/xml\';\n"
"if (length (req_body) + length (service) >= 1900)\n"
"{\n"
"req_method := \'POST\';\n"
"req_uri := service;\n"
"local_req_hdr := local_req_hdr || \'\\r\\nContent-Type: application/x-www-form-urlencoded\';\n"
"}\n"
"else\n"
"{\n"
"req_method := \'GET\';\n"
"req_uri := service || \'?\' || req_body;\n"
"req_body := \'\';\n"
"}\n"
"if (length (req_hdr) > 0)\n"
"req_hdr := concat (req_hdr, \'\\r\\n\', local_req_hdr );\n"
"else\n"
"req_hdr := local_req_hdr;\n"
"\n"
"\n"
"\n"
"ret_body := http_get (req_uri, ret_hdr, req_method, req_hdr, req_body);\n"
"\n"
"\n"
"ret_content_type := http_request_header (ret_hdr, \'Content-Type\', null, null);\n"
"ret_known_content_type := http_sys_find_best_sparql_accept (ret_content_type, 0, ret_format);\n"
"if (ret_format is null or not (ret_format in (\'XML\', \'RDFXML\', \'TTL\')))\n"
"{\n"
"declare ret_begin, ret_html any;\n"
"ret_begin := \"LEFT\" (ret_body, 1024);\n"
"ret_html := xtree_doc (ret_begin, 2);\n"
"if (xpath_eval (\'/html|/xhtml\', ret_html) is not null)\n"
"ret_content_type := \'text/html\';\n"
"else if (xpath_eval (\'[xmlns:rset=\"http://www.w3.org/2005/sparql-results#\"] /rset:sparql\', ret_html) is not null\n"
"or xpath_eval (\'[xmlns:rset2=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2\"] /rset2:sparql\', ret_html) is not null)\n"
"ret_content_type := \'application/sparql-results+xml\';\n"
"else if (xpath_eval (\'[xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"] /rdf:rdf\', ret_html) is not null)\n"
"ret_content_type := \'application/rdf+xml\';\n"
"else if (strstr (ret_begin, \'<html>\') is not null or\n"
"strstr (ret_begin, \'<xhtml>\') is not null )\n"
"ret_content_type := \'text/html\';\n"
"else\n"
"{\n"
"ret_content_type := \'text/plain\';\n"
"}\n"
"}\n"
"if (ret_format = \'XML\')\n"
"{\n"
"declare ret_xml, var_list, var_metas, ret_row, out_nulls any;\n"
"declare var_ctr, var_count integer;\n"
"declare vect_acc any;\n"
"declare row_inx integer;\n"
"\n"
"ret_xml := xtree_doc (ret_body, 0);\n"
"var_list := xpath_eval (\'[xmlns:rset=\"http://www.w3.org/2005/sparql-results#\"] [xmlns:rset2=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2\"]\n"
"/rset:sparql/rset:head/rset:variable | /rset2:sparql/rset2:head/rset2:variable\', ret_xml, 0);\n"
"if (0 = length (var_list))\n"
"{\n"
"declare bool_ret any;\n"
"bool_ret := xpath_eval (\'[xmlns:rset=\"http://www.w3.org/2005/sparql-results#\"] [xmlns:rset2=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2\"]\n"
"/rset:sparql/rset:boolean | /rset2:sparql/rset2:boolean\', ret_xml);\n"
"if (bool_ret is not null)\n"
"{\n"
"bool_ret := cast (bool_ret as varchar);\n"
"if (\'true\' = bool_ret)\n"
"bool_ret := 1;\n"
"else if (\'false\' = bool_ret)\n"
"bool_ret := 0;\n"
"else\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'DB.DBA.SPARQL_REXEC(\'\'%.300s\'\', ...) has received invalid boolean value \'\'%.300s\'\'\',\n"
"service, bool_ret ) );\n"
"metas :=\n"
"vector (\n"
"vector (\n"
"vector (\'__ask_retval\', 242, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0) ),\n"
"1 );\n"
"if (0 = res_mode)\n"
"{\n"
"declare __ask_retval integer;\n"
"result_names (__ask_retval);\n"
"result (bool_ret);\n"
"}\n"
"else if (1 = res_mode)\n"
"return vector (vector (bool_ret));\n"
"return;\n"
"}\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'DB.DBA.SPARQL_REXEC(\'\'%.300s\'\', ...) has received result with no variables\',\n"
"service ) );\n"
"}\n"
"var_count := length (var_list);\n"
"var_metas := make_array (var_count, \'any\');\n"
"out_nulls := make_array (var_count, \'any\');\n"
"for (var_ctr := var_count - 1; var_ctr >= 0; var_ctr := var_ctr - 1)\n"
"{\n"
"declare var_name varchar;\n"
"var_name := cast (xpath_eval (\'@name\', var_list[var_ctr]) as varchar);\n"
"var_list [var_ctr] := var_name;\n"
"var_metas [var_ctr] := vector (var_name, 242, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0);\n"
"out_nulls [var_ctr] := null;\n"
"}\n"
"\n"
"if (0 = res_mode)\n"
"exec_result_names (var_metas);\n"
"else if (1 = res_mode)\n"
"vectorbld_init (vect_acc);\n"
"row_inx := 0;\n"
"for (ret_row := xpath_eval (\'[xmlns:rset=\"http://www.w3.org/2005/sparql-results#\"] [xmlns:rset2=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2\"]\n"
"/rset:sparql/rset:results/rset:result | /rset2:sparql/rset2:results/rset2:result\', ret_xml);\n"
"ret_row is not null;\n"
"ret_row := xpath_eval (\'[xmlns:rset=\"http://www.w3.org/2005/sparql-results#\"] [xmlns:rset2=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2\"]\n"
"following-sibling::rset:result | following-sibling::rset2:result\', ret_row) )\n"
"{\n"
"declare out_fields, ret_cols any;\n"
"declare col_ctr, col_count integer;\n"
"out_fields := out_nulls;\n"
"ret_cols := xpath_eval (\'[xmlns:rset=\"http://www.w3.org/2005/sparql-results#\"] [xmlns:rset2=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2\"]\n"
"rset:binding | rset2:binding\', ret_row, 0);\n"
"col_count := length (ret_cols);\n"
"for (col_ctr := col_count - 1; col_ctr >= 0; col_ctr := col_ctr - 1)\n"
"{\n"
"declare ret_col any;\n"
"declare var_name, var_type, var_strval varchar;\n"
"declare var_pos integer;\n"
"ret_col := ret_cols[col_ctr];\n"
"var_name := cast (xpath_eval (\'string(@name)\', ret_col) as varchar);\n"
"\n"
"var_pos := position (var_name, var_list) - 1;\n"
"if (var_pos >= 0)\n"
"{\n"
"var_type := cast (xpath_eval (\'local-name(*)\', ret_col) as varchar);\n"
"var_strval := charset_recode (xpath_eval (\'string(*)\', ret_col), \'_WIDE_\', \'UTF-8\');\n"
"\n"
"if (\'uri\' = var_type)\n"
"out_fields [var_pos] := iri_to_id (var_strval);\n"
"else if (\'bnode\' = var_type)\n"
"{\n"
"declare local_iid IRI_ID;\n"
"if (bnode_dict is null)\n"
"{\n"
"bnode_dict := dict_new ();\n"
"local_iid := iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\'));\n"
"dict_put (bnode_dict, var_strval, local_iid);\n"
"}\n"
"else\n"
"{\n"
"local_iid := dict_get (bnode_dict, var_strval, null);\n"
"if (local_iid is null)\n"
"{\n"
"local_iid := iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\'));\n"
"dict_put (bnode_dict, var_strval, local_iid);\n"
"}\n"
"}\n"
"out_fields [var_pos] := local_iid;\n"
"}\n"
"else if (\'literal\' = var_type)\n"
"{\n"
"declare lang, dt varchar;\n"
"lang := charset_recode (xpath_eval (\'*/@xml:lang\', ret_col), \'_WIDE_\', \'UTF-8\');\n"
"dt := charset_recode (xpath_eval (\'*/@datatype\', ret_col), \'_WIDE_\', \'UTF-8\');\n"
"out_fields [var_pos] := DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL_STRINGS (\n"
"var_strval, dt, lang );\n"
"}\n"
"else\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'DB.DBA.SPARQL_REXEC(\'\'%.300s\'\', ...) contains unsupported type of bound value \'\'%.300s\'\'\',\n"
"service, var_type ) );\n"
"}\n"
"}\n"
"if (0 = res_mode)\n"
"exec_result (out_fields);\n"
"else if (1 = res_mode)\n"
"vectorbld_acc (vect_acc, out_fields);\n"
"row_inx := row_inx + 1;\n"
"if (maxrows is not null and maxrows > 0 and row_inx >= maxrows)\n"
"ret_row := xpath_eval (\'[xmlns:rset=\"http://www.w3.org/2005/sparql-results#\"] [xmlns:rset2=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2\"]\n"
"../rset:result[position() = last()] | ../rset2:result[position() = last()]\', ret_row);\n"
"}\n"
"metas := vector (var_metas, 1);\n"
"if (0 = res_mode)\n"
"{\n"
"return;\n"
"}\n"
"else if (1 = res_mode)\n"
"{\n"
"vectorbld_final (vect_acc);\n"
"return vect_acc;\n"
"}\n"
"}\n"
"if (ret_format = \'RDFXML\')\n"
"{\n"
"declare res_dict any;\n"
"res_dict := DB.DBA.RDF_RDFXML_TO_DICT (ret_body,\'http://local.virt/tmp\',\'http://local.virt/tmp\');\n"
"metas := vector (vector (vector (\'res_dict\', 242, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0)), 1);\n"
"if (0 = res_mode)\n"
"{\n"
"result_names (res_dict);\n"
"result (res_dict);\n"
"return;\n"
"}\n"
"else if (1 = res_mode)\n"
"return vector (vector (res_dict));\n"
"}\n"
"if (ret_format = \'TTL\')\n"
"{\n"
"declare res_dict any;\n"
"res_dict := DB.DBA.RDF_TTL2HASH (ret_body, \'\');\n"
"metas := vector (vector (vector (\'res_dict\', 242, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0)), 1);\n"
"if (0 = res_mode)\n"
"{\n"
"result_names (res_dict);\n"
"result (res_dict);\n"
"return;\n"
"}\n"
"else if (1 = res_mode)\n"
"return vector (vector (res_dict));\n"
"}\n"
"if (strstr (ret_content_type, \'text/plain\') is not null)\n"
"{\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'DB.DBA.SPARQL_REXEC(\'\'%.300s\'\', ...) returned Content-Type \'\'%.300s\'\' status \'\'%.300s\'\'\\n%.1000s\',\n"
"service, ret_content_type, ret_hdr[0], \"LEFT\" (ret_body, 1024) ) );\n"
"}\n"
"if (strstr (ret_content_type, \'text/html\') is not null)\n"
"{\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'DB.DBA.SPARQL_REXEC(\'\'%.300s\'\', ...) returned Content-Type \'\'%.300s\'\' status \'\'%.300s\'\'\\n%.1000s\',\n"
"service, ret_content_type, ret_hdr[0],\n"
"cast (xtree_doc (ret_body, 2) as varchar) ) );\n"
"}\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'DB.DBA.SPARQL_REXEC(\'\'%.300s\'\', ...) returned unsupported Content-Type \'\'%.300s\'\'\',\n"
"service, ret_content_type ) );\n"
"}\n"
"--src sparql_io.sql:228\n";

static const char *proc308 = 
"create procedure DB.DBA.SPARQL_REXEC (\n"
"in service varchar,\n"
"in query varchar,\n"
"in dflt_graph varchar,\n"
"in named_graphs any,\n"
"in req_hdr any,\n"
"in maxrows integer,\n"
"in bnode_dict any\n"
")\n"
"{\n"
"declare metas any;\n"
"DB.DBA.SPARQL_REXEC_INT (0, service, query, dflt_graph, named_graphs, req_hdr, maxrows, metas, bnode_dict);\n"
"}\n"
"--src sparql_io.sql:494\n";

static const char *proc309 = 
"create function DB.DBA.SPARQL_REXEC_TO_ARRAY (\n"
"in service varchar,\n"
"in query varchar,\n"
"in dflt_graph varchar,\n"
"in named_graphs any,\n"
"in req_hdr any,\n"
"in maxrows integer,\n"
"in bnode_dict any\n"
") returns any\n"
"{\n"
"declare metas any;\n"
"return DB.DBA.SPARQL_REXEC_INT (1, service, query, dflt_graph, named_graphs, req_hdr, maxrows, metas, bnode_dict);\n"
"}\n"
"--src sparql_io.sql:509\n";

static const char *proc310 = 
"create procedure DB.DBA.SPARQL_REXEC_WITH_META (\n"
"in service varchar,\n"
"in query varchar,\n"
"in dflt_graph varchar,\n"
"in named_graphs any,\n"
"in req_hdr any,\n"
"in maxrows integer,\n"
"in bnode_dict any,\n"
"out metadata any,\n"
"out resultset any\n"
")\n"
"{\n"
"resultset := DB.DBA.SPARQL_REXEC_INT (1, service, query, dflt_graph, named_graphs, req_hdr, maxrows, metadata, bnode_dict);\n"
"\n"
"}\n"
"--src sparql_io.sql:524\n";

static const char *proc311 = 
"create procedure \"querySoap\"  (in  \"Command\" varchar\n"
", in  \"Properties\" any\n"
", out \"Error\" any __soap_fault \'__XML__\'\n"
", out \"ws_sparql_xsd\" any\n"
")\n"
"__soap_options ( __soap_type:=\'__ANY__\',\n"
"\"soapAction\":=\'urn:FIXME:querySoap\',\n"
"\"RequestNamespace\":=\'urn:http://www.w3.org/2005/08/sparql-protocol-query/#\',\n"
"\"ResponseNamespace\":=\'urn:http://www.w3.org/2005/08/sparql-protocol-query/#\',\n"
"\"PartName\":=\'return\'\n"
")\n"
"{\n"
"declare stmt, state, msg, mdta, dta, res, ses any;\n"
"stmt := get_keyword (\'Statement\', \"Command\");\n"
"ses := string_output ();\n"
"\n"
"\n"
"res := exec (stmt, state, msg, vector (), 0, mdta, dta);\n"
"\n"
"SPARQL_RSET_XML_WRITE_NS (ses);\n"
"SPARQL_RESULTS_XML_WRITE_HEAD (ses, mdta);\n"
"SPARQL_RESULTS_XML_WRITE_RES (ses, mdta, dta);\n"
"\n"
"\n"
"http (\'</sparql>\', ses);\n"
"\n"
"ses := string_output_string (ses);\n"
"string_to_file (\'out.xml\', ses, -2);\n"
"res := xml_tree_doc (ses);\n"
"return res;\n"
"}\n"
"--src sparql_io.sql:545\n";

static const char *proc312 = 
" create procedure SPARQL_WRITE_EXEC_STATUS (inout ses any, in line_format varchar, inout status any)\n"
"{\n"
"declare lctr, lcount integer;\n"
"declare lines any;\n"
"if (status is null)\n"
"return;\n"
"http (sprintf (line_format, \'SQL State\', status[0]), ses);\n"
"lines := split_and_decode (status[1], 0, \'\\0\\0\\n\');\n"
"lcount := length (lines);\n"
"for (lctr := 0; lctr < lcount; lctr := lctr + 1)\n"
"{\n"
"http (sprintf (line_format, case (lctr) when 0 then \'SQL Message\' else \'\' end, lines[lctr]), ses);\n"
"}\n"
"http (sprintf (line_format, \'Exec Time\', cast (status[2] as varchar) || \' ms\'), ses);\n"
"http (sprintf (line_format, \'DB Activity\', cast (status[3] as varchar)), ses);\n"
"}\n"
"--src sparql_io.sql:579\n";

static const char *proc313 = 
"create procedure SPARQL_RESULTS_XML_WRITE_HEAD (inout ses any, in mdta any)\n"
"{\n"
"declare i, col_count integer;\n"
"\n"
"http (\'\\n <head>\', ses);\n"
"\n"
"mdta := mdta[0];\n"
"i := 0; col_count := length (mdta);\n"
"while (i < col_count)\n"
"{\n"
"declare _name varchar;\n"
"declare _type, _type_name, nill int;\n"
"_name := mdta[i][0];\n"
"_type := mdta[i][1];\n"
"if (length (mdta[i]) > 4)\n"
"nill := mdta[i][4];\n"
"else\n"
"nill := 0;\n"
"http (sprintf (\'\\n  <variable name=\"%s\"/>\', _name), ses);\n"
"i := i + 1;\n"
"}\n"
"\n"
"http (\'\\n </head>\', ses);\n"
"}\n"
"--src sparql_io.sql:598\n";

static const char *proc314 = 
"create procedure SPARQL_RESULTS_XML_WRITE_RES (inout ses any, in mdta any, inout dta any)\n"
"{\n"
"http (\'\\n <results distinct=\"false\" ordered=\"true\">\', ses);\n"
"\n"
"for (declare ctr integer, ctr := 0; ctr < length (dta); ctr := ctr + 1)\n"
"SPARQL_RESULTS_XML_WRITE_ROW (ses, mdta, dta[ctr]);\n"
"\n"
"http (\'\\n </results>\', ses);\n"
"}\n"
"--src sparql_io.sql:624\n";

static const char *proc315 = 
"create procedure DB.DBA.SPARQL_RESULTS_XML_WRITE_ROW (inout ses any, in mdta any, inout dta any)\n"
"{\n"
"\n"
"http (\'\\n  <result>\', ses);\n"
"mdta := mdta[0];\n"
"for (declare x any, x := 0; x < length (mdta); x := x + 1)\n"
"{\n"
"declare _name varchar;\n"
"declare _val any;\n"
"_name := mdta[x][0];\n"
"_val := dta[x];\n"
"if (_val is null)\n"
"goto end_of_binding;\n"
"if (isiri_id (_val))\n"
"{\n"
"if (_val >= min_bnode_iri_id ())\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><bnode>%s</bnode></binding>\', _name, id_to_iri (_val)), ses);\n"
"else\n"
"{\n"
"declare res varchar;\n"
"res := id_to_iri (_val);\n"
"\n"
"if (res is null)\n"
"res := sprintf (\'bad://%d\', iri_id_num (_val));\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><uri>\', _name), ses);\n"
"http_value (res, 0, ses);\n"
"http (\'</uri></binding>\', ses);\n"
"}\n"
"}\n"
"else if (isstring (_val) and (1 = __box_flags (_val)))\n"
"{\n"
"if (_val like \'nodeID://%\')\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><bnode>%s</bnode></binding>\', _name, _val), ses);\n"
"else\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><uri>%V</uri></binding>\', _name, _val), ses);\n"
"}\n"
"else\n"
"{\n"
"declare lang, dt varchar;\n"
"declare is_xml_lit int;\n"
"declare sql_val any;\n"
"if (__tag (_val) = 185)\n"
"{\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><literal>\', _name), ses);\n"
"http_value (_val, 0, ses);\n"
"http (\'</literal></binding>\', ses);\n"
"goto end_of_binding;\n"
"}\n"
"if (__tag (_val) = 230)\n"
"{\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><literal datatype=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral\">\', _name), ses);\n"
"http_value (_val, 0, ses);\n"
"http (\'</literal></binding>\', ses);\n"
"goto end_of_binding;\n"
"}\n"
"lang := DB.DBA.RDF_LANGUAGE_OF_LONG (_val, null);\n"
"dt := DB.DBA.RDF_DATATYPE_IRI_OF_LONG (_val, null);\n"
"if (dt = \'http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral\')\n"
"is_xml_lit := 1;\n"
"else\n"
"is_xml_lit := 0;\n"
"if (lang is not null)\n"
"{\n"
"if (dt is not null)\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><literal xml:lang=\"%V\" datatype=\"%V\">\',\n"
"_name, cast (lang as varchar), cast (dt as varchar)), ses);\n"
"else\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><literal xml:lang=\"%V\">\',\n"
"_name, cast (lang as varchar)), ses);\n"
"}\n"
"else\n"
"{\n"
"if (dt is not null)\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><literal datatype=\"%V\">\',\n"
"_name, cast (dt as varchar)), ses);\n"
"else\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><literal>\',\n"
"_name), ses);\n"
"}\n"
"sql_val := __rdf_sqlval_of_obj (_val, 1);\n"
"if (isentity (sql_val))\n"
"is_xml_lit := 1;\n"
"if (__tag (sql_val) = __tag of varchar)\n"
"sql_val := charset_recode (sql_val, \'UTF-8\', \'_WIDE_\');\n"
"if (is_xml_lit) http (\'<![CDATA[\', ses);\n"
"http_value (sql_val, 0, ses);\n"
"if (is_xml_lit) http (\']]>\', ses);\n"
"http (\'</literal></binding>\', ses);\n"
"}\n"
"end_of_binding: ;\n"
"}\n"
"\n"
"http (\'\\n  </result>\', ses);\n"
"}\n"
"--src sparql_io.sql:635\n";

static const char *proc316 = 
"create procedure SPARQL_RESULTS_RDFXML_WRITE_NS (inout ses any)\n"
"{\n"
"http (\'<rdf:RDF xmlns:res=\"http://www.w3.org/2005/sparql-results#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n"
"<rdf:Description rdf:nodeID=\"rset\">\n"
"<rdf:type rdf:resource=\"http://www.w3.org/2005/sparql-results#ResultSet\" />\', ses);\n"
"}\n"
"--src sparql_io.sql:731\n";

static const char *proc317 = 
"create procedure SPARQL_RESULTS_RDFXML_WRITE_HEAD (inout ses any, in mdta any)\n"
"{\n"
"declare i, col_count integer;\n"
"mdta := mdta[0];\n"
"i := 0; col_count := length (mdta);\n"
"while (i < col_count)\n"
"{\n"
"declare _name varchar;\n"
"declare _type, _type_name, nill int;\n"
"_name := mdta[i][0];\n"
"_type := mdta[i][1];\n"
"if (length (mdta[i]) > 4)\n"
"nill := mdta[i][4];\n"
"else\n"
"nill := 0;\n"
"http (sprintf (\'\\n    <res:resultVariable>%V</res:resultVariable>\', _name), ses);\n"
"i := i + 1;\n"
"}\n"
"}\n"
"--src sparql_io.sql:739\n";

static const char *proc318 = 
"create procedure SPARQL_RESULTS_RDFXML_WRITE_RES (inout ses any, in mdta any, inout dta any)\n"
"{\n"
"for (declare ctr integer, ctr := 0; ctr < length (dta); ctr := ctr + 1)\n"
"{\n"
"http ( sprintf (\'\\n    <res:solution rdf:nodeID=\"r%d\">\', ctr), ses);\n"
"SPARQL_RESULTS_RDFXML_WRITE_ROW (ses, mdta, dta, ctr);\n"
"http (\'\\n    </res:solution>\', ses);\n"
"}\n"
"}\n"
"--src sparql_io.sql:760\n";

static const char *proc319 = 
"create procedure SPARQL_RESULTS_RDFXML_WRITE_ROW (inout ses any, in mdta any, inout dta any, in rowno integer)\n"
"{\n"
"mdta := mdta[0];\n"
"for (declare x any, x := 0; x < length (mdta); x := x + 1)\n"
"{\n"
"declare _name varchar;\n"
"declare _val any;\n"
"_name := mdta[x][0];\n"
"_val := dta[rowno][x];\n"
"if (_val is null)\n"
"goto end_of_binding;\n"
"http (sprintf (\'\\n      <res:binding rdf:nodeID=\"r%dc%d\"><res:variable>%V</res:variable><res:value\', rowno, x, _name), ses);\n"
"if (isiri_id (_val))\n"
"{\n"
"if (_val >= min_bnode_iri_id ())\n"
"{\n"
"http (sprintf (\' rdf:nodeID=\"b%s\"/></res:binding>\', id_to_iri (_val)), ses);\n"
"}\n"
"else\n"
"{\n"
"declare res varchar;\n"
"res := id_to_iri (_val);\n"
"\n"
"if (res is null)\n"
"res := sprintf (\'bad://%d\', iri_id_num (_val));\n"
"http (sprintf (\' rdf:resource=\"%V\"/></res:binding>\', res), ses);\n"
"}\n"
"}\n"
"else if (isstring (_val) and (1 = __box_flags (_val)))\n"
"{\n"
"if (_val like \'nodeID://%\')\n"
"http (sprintf (\' rdf:nodeID=\"b%s\"/></res:binding>\', subseq(_val, 9)), ses);\n"
"else\n"
"http (sprintf (\' rdf:resource=\"%V\"/></res:binding>\', _val), ses);\n"
"}\n"
"else\n"
"{\n"
"declare lang, dt varchar;\n"
"declare val_tag integer;\n"
"val_tag := __tag (_val);\n"
"if (val_tag = 185)\n"
"{\n"
"http (\'>\', ses);\n"
"http_value (_val, 0, ses);\n"
"http (\'</res:value></res:binding>\', ses);\n"
"goto end_of_binding;\n"
"}\n"
"if (val_tag = 230)\n"
"{\n"
"http (\' rdf:parseType=\"Literal\">\', ses);\n"
"http_value (_val, 0, ses);\n"
"http (\'</res:value></res:binding>\', ses);\n"
"goto end_of_binding;\n"
"}\n"
"lang := DB.DBA.RDF_LANGUAGE_OF_LONG (_val, null);\n"
"dt := DB.DBA.RDF_DATATYPE_IRI_OF_LONG (_val, null);\n"
"if (lang is not null)\n"
"{\n"
"if (dt is not null)\n"
"http (sprintf (\' xml:lang=\"%V\" datatype=\"%V\">\', cast (lang as varchar), cast (dt as varchar)), ses);\n"
"else\n"
"http (sprintf (\' xml:lang=\"%V\">\', cast (lang as varchar)), ses);\n"
"}\n"
"else\n"
"{\n"
"if (dt is not null)\n"
"http (sprintf (\' datatype=\"%V\">\', cast (dt as varchar)), ses);\n"
"else\n"
"http (\'>\', ses);\n"
"}\n"
"if (__tag of datetime = rdf_box_data_tag (_val))\n"
"__rdf_long_to_ttl (_val, ses);\n"
"else\n"
"{\n"
"_val := __rdf_sqlval_of_obj (_val, 1);\n"
"if (__tag (_val) = __tag of varchar)\n"
"_val := charset_recode (_val, \'UTF-8\', \'_WIDE_\');\n"
"http_value (_val, 0, ses);\n"
"}\n"
"http (\'</res:value></res:binding>\', ses);\n"
"}\n"
"end_of_binding: ;\n"
"}\n"
"}\n"
"--src sparql_io.sql:771\n";

static const char *proc320 = 
"create procedure SPARQL_RESULTS_TTL_WRITE_NS (inout ses any)\n"
"{\n"
"http (\'@prefix res: <http://www.w3.org/2005/sparql-results#> .\n"
"@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"_:_ a res:ResultSet .\\n\', ses);\n"
"}\n"
"--src sparql_io.sql:857\n";

static const char *proc321 = 
"create procedure SPARQL_RESULTS_TTL_WRITE_HEAD (inout ses any, in mdta any)\n"
"{\n"
"declare i, col_count integer;\n"
"mdta := mdta[0];\n"
"i := 0; col_count := length (mdta);\n"
"if (0 = col_count)\n"
"return;\n"
"http (\'_:_ res:resultVariable \"\', ses);\n"
"while (i < col_count)\n"
"{\n"
"declare _name varchar;\n"
"declare _type, _type_name, nill int;\n"
"_name := mdta[i][0];\n"
"_type := mdta[i][1];\n"
"if (length (mdta[i]) > 4)\n"
"nill := mdta[i][4];\n"
"else\n"
"nill := 0;\n"
"http_escape (_name, 11, ses, 0, 1);\n"
"i := i + 1;\n"
"if (i < col_count)\n"
"http (\'\" , \"\', ses);\n"
"}\n"
"http (\'\" .\\n\', ses);\n"
"}\n"
"--src sparql_io.sql:865\n";

static const char *proc322 = 
"create procedure SPARQL_RESULTS_TTL_WRITE_RES (inout ses any, in mdta any, inout dta any)\n"
"{\n"
"declare colctr, colcount, rowctr, len, fake_agg_ctx integer;\n"
"declare cols, colbuf, env any;\n"
"cols := mdta[0];\n"
"colcount := length (cols);\n"
"colbuf := make_array (colcount * 7, \'any\');\n"
"len := length (dta);\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"colbuf [colctr * 7] := cols[colctr][0];\n"
"}\n"
"env := vector (dict_new (__min (len * 3, 16000)), 0, \'\', \'\', \'\', 0, 0, colbuf, ses);\n"
"rowctr := 0;\n"
"while (rowctr < len)\n"
"{\n"
"declare r any;\n"
"r := aref_set_0 (dta, rowctr);\n"
"sparql_rset_ttl_write_row (fake_agg_ctx, env, r);\n"
"aset_zap_arg (dta, rowctr, r);\n"
"rowctr := rowctr + 1;\n"
"}\n"
"}\n"
"--src sparql_io.sql:892\n";

static const char *proc323 = 
"create procedure SPARQL_RESULTS_NT_WRITE_NS (inout ses any)\n"
"{\n"
"http (\'_:_ rdf:type <http://www.w3.org/1999/02/22-rdf-syntax-ns#res:ResultSet> .\\n\', ses);\n"
"}\n"
"--src sparql_io.sql:917\n";

static const char *proc324 = 
"create procedure SPARQL_RESULTS_NT_WRITE_HEAD (inout ses any, in mdta any)\n"
"{\n"
"declare i, col_count integer;\n"
"mdta := mdta[0];\n"
"i := 0; col_count := length (mdta);\n"
"while (i < col_count)\n"
"{\n"
"declare _name varchar;\n"
"declare _type, _type_name, nill int;\n"
"_name := mdta[i][0];\n"
"_type := mdta[i][1];\n"
"if (length (mdta[i]) > 4)\n"
"nill := mdta[i][4];\n"
"else\n"
"nill := 0;\n"
"http (\'_:_ <http://www.w3.org/2005/sparql-results#resultVariable> \"\', ses);\n"
"http_escape (_name, 11, ses, 0, 1);\n"
"http (\'\" .\\n\', ses);\n"
"i := i + 1;\n"
"}\n"
"}\n"
"--src sparql_io.sql:923\n";

static const char *proc325 = 
"create procedure SPARQL_RESULTS_NT_WRITE_RES (inout ses any, in mdta any, inout dta any)\n"
"{\n"
"declare colctr, colcount, rowctr, len, fake_agg_ctx integer;\n"
"declare cols, colbuf, env any;\n"
"cols := mdta[0];\n"
"colcount := length (cols);\n"
"colbuf := make_array (colcount * 7, \'any\');\n"
"len := length (dta);\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"colbuf [colctr * 7] := cols[colctr][0];\n"
"}\n"
"env := vector (0, colbuf, ses);\n"
"rowctr := 0;\n"
"while (rowctr < len)\n"
"{\n"
"declare r any;\n"
"r := aref_set_0 (dta, rowctr);\n"
"sparql_rset_nt_write_row (fake_agg_ctx, env, r);\n"
"aset_zap_arg (dta, rowctr, r);\n"
"rowctr := rowctr + 1;\n"
"}\n"
"}\n"
"--src sparql_io.sql:946\n";

static const char *proc326 = 
"create procedure SPARQL_RESULTS_JAVASCRIPT_HTML_WRITE (inout ses any, inout metas any, inout rset any, in is_js integer := 0, in esc_mode integer := 1)\n"
"{\n"
"declare varctr, varcount, resctr, rescount integer;\n"
"declare trnewline, newline varchar;\n"
"varcount := length (metas[0]);\n"
"rescount := length (rset);\n"
"if (esc_mode = 13)\n"
"{\n"
"newline := \'\';\n"
"trnewline := \'\'\');\\ndocument.writeln(\'\'\';\n"
"}\n"
"else\n"
"newline := trnewline := \'\\n\';\n"
"if (is_js)\n"
"{\n"
"http (\'document.writeln(\'\'\', ses);\n"
"SPARQL_RESULTS_JAVASCRIPT_HTML_WRITE(ses,metas,rset,0,13);\n"
"http (\'\'\');\', ses);\n"
"return;\n"
"}\n"
"http (\'<table class=\"sparql\" border=\"1\">\', ses);\n"
"http (trnewline || \'  <tr>\', ses);\n"
"\n"
"for (varctr := 0; varctr < varcount; varctr := varctr + 1)\n"
"{\n"
"http(newline || \'    <th>\', ses);\n"
"http_escape (metas[0][varctr][0], esc_mode, ses, 0, 1);\n"
"http(\'</th>\', ses);\n"
"}\n"
"http (newline || \'  </tr>\', ses);\n"
"for (resctr := 0; resctr < rescount; resctr := resctr + 1)\n"
"{\n"
"http(trnewline || \'  <tr>\', ses);\n"
"\n"
"\n"
"\n"
"for (varctr := 0; varctr < varcount; varctr := varctr + 1)\n"
"{\n"
"declare val any;\n"
"val := rset[resctr][varctr];\n"
"if (val is null)\n"
"{\n"
"http(newline || \'    <td></td>\', ses);\n"
"goto end_of_val_print;\n"
"}\n"
"http(newline || \'    <td>\', ses);\n"
"if (isiri_id (val))\n"
"http_escape (id_to_iri (val), esc_mode, ses, 1, 1);\n"
"else if (isstring (val) and (1 = __box_flags (val)))\n"
"http_escape (val, esc_mode, ses, 1, 1);\n"
"else if (__tag of varchar = __tag (val))\n"
"{\n"
"http_escape (val, esc_mode, ses, 1, 1);\n"
"}\n"
"else if (185 = __tag (val))\n"
"{\n"
"http_escape (cast (val as varchar), esc_mode, ses, 1, 1);\n"
"}\n"
"else if (__tag of XML = rdf_box_data_tag (val))\n"
"{\n"
"\n"
"\n"
"declare tmpses any;\n"
"tmpses := string_output();\n"
"http_value (val, 0, tmpses);\n"
"http_escape (cast (tmpses as varchar), esc_mode, ses, 1, 1);\n"
"\n"
"\n"
"\n"
"}\n"
"else\n"
"{\n"
"http_escape (__rdf_strsqlval (val), esc_mode, ses, 1, 1);\n"
"}\n"
"http (\'</td>\', ses);\n"
"end_of_val_print: ;\n"
"}\n"
"http(newline || \'  </tr>\', ses);\n"
"}\n"
"http (trnewline || \'</table>\', ses);\n"
"}\n"
"--src sparql_io.sql:971\n";

static const char *proc327 = 
"create procedure SPARQL_RESULTS_JSON_WRITE_BINDING (inout ses any, in colname varchar, inout val any)\n"
"{\n"
"http(\' \"\', ses);\n"
"http_escape (colname, 11, ses, 0, 1);\n"
"http(\'\": { \', ses);\n"
"if (isiri_id (val))\n"
"{\n"
"if (val > min_bnode_iri_id ())\n"
"http (sprintf (\'\"type\": \"bnode\", \"value\": \"%s\', id_to_iri (val)), ses);\n"
"else\n"
"{\n"
"http (\'\"type\": \"uri\", \"value\": \"\', ses);\n"
"http_escape (id_to_iri (val), 11, ses, 1, 1);\n"
"}\n"
"}\n"
"else if (__tag of rdf_box = __tag (val))\n"
"{\n"
"declare res varchar;\n"
"declare dat, typ any;\n"
"dat := __rdf_sqlval_of_obj (val, 1);\n"
"typ := rdf_box_type (val);\n"
"if (not isstring (dat))\n"
"{\n"
"http (\'\"type\": \"typed-literal\", \"datatype\": \"\', ses);\n"
"if (257 <> typ)\n"
"res := coalesce ((select RDT_QNAME from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = typ));\n"
"else\n"
"res := cast (__xsd_type (dat) as varchar);\n"
"http_escape (res, 11, ses, 1, 1);\n"
"http (\'\", \"value\": \"\', ses);\n"
"dat := __rdf_strsqlval (dat);\n"
"}\n"
"else if (257 <> typ)\n"
"{\n"
"http (\'\"type\": \"typed-literal\", \"datatype\": \"\', ses);\n"
"res := coalesce ((select RDT_QNAME from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = typ));\n"
"http_escape (res, 11, ses, 1, 1);\n"
"http (\'\", \"value\": \"\', ses);\n"
"}\n"
"else if (257 <> rdf_box_lang (val))\n"
"{\n"
"http (\'\"type\": \"literal\", \"xml:lang\": \"\', ses);\n"
"res := coalesce ((select lower (RL_ID) from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = rdf_box_lang (val)));\n"
"http_escape (res, 11, ses, 1, 1);\n"
"http (\'\", \"value\": \"\', ses);\n"
"}\n"
"else\n"
"http (\'\"type\": \"literal\", \"value\": \"\', ses);\n"
"http_escape (dat, 11, ses, 1, 1);\n"
"}\n"
"else if (__tag of varchar = __tag (val))\n"
"{\n"
"if (1 = __box_flags (val))\n"
"{\n"
"if (val like \'nodeID://%\')\n"
"http (sprintf (\'\"type\": \"bnode\", \"value\": \"%s\', val), ses);\n"
"else\n"
"{\n"
"http (\'\"type\": \"uri\", \"value\": \"\', ses);\n"
"http_escape (val, 11, ses, 1, 1);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"http (\'\"type\": \"literal\", \"value\": \"\', ses);\n"
"http_escape (val, 11, ses, 1, 1);\n"
"}\n"
"}\n"
"else if (__tag of varbinary = __tag (val))\n"
"{\n"
"http (\'\"type\": \"literal\", \"value\": \"\', ses);\n"
"http_escape (val, 11, ses, 0, 0);\n"
"}\n"
"else if (185 = __tag (val))\n"
"{\n"
"http (\'\"type\": \"literal\", \"value\": \"\', ses);\n"
"http_escape (cast (val as varchar), 11, ses, 1, 1);\n"
"}\n"
"else if (230 = __tag (val))\n"
"{\n"
"http (\'\"type\": \"literal\", \"value\": \"\', ses);\n"
"http_escape (serialize_to_UTF8_xml (val), 11, ses, 1, 1);\n"
"}\n"
"else\n"
"{\n"
"http (\'\"type\": \"typed-literal\", \"datatype\": \"\', ses);\n"
"http_escape (cast (__xsd_type (val) as varchar), 11, ses, 1, 1);\n"
"http (\'\", \"value\": \"\', ses);\n"
"http_escape (__rdf_strsqlval (val), 11, ses, 1, 1);\n"
"}\n"
"http (\'\" }\', ses);\n"
"}\n"
"--src sparql_io.sql:1054\n";

static const char *proc328 = 
"create procedure SPARQL_RESULTS_JSON_WRITE (inout ses any, inout metas any, inout rset any)\n"
"{\n"
"declare varctr, varcount, resctr, rescount integer;\n"
"varcount := length (metas[0]);\n"
"rescount := length (rset);\n"
"http (\'\\n{ \"head\": { \"link\": [], \"vars\": [\', ses);\n"
"for (varctr := 0; varctr < varcount; varctr := varctr + 1)\n"
"{\n"
"if (varctr > 0)\n"
"http(\', \"\', ses);\n"
"else\n"
"http(\'\"\', ses);\n"
"http_escape (metas[0][varctr][0], 11, ses, 0, 1);\n"
"http(\'\"\', ses);\n"
"}\n"
"http (\'] },\\n  \"results\": { \"distinct\": false, \"ordered\": true, \"bindings\": [\', ses);\n"
"for (resctr := 0; resctr < rescount; resctr := resctr + 1)\n"
"{\n"
"declare need_comma integer;\n"
"if (resctr > 0)\n"
"http(\',\\n    {\', ses);\n"
"else\n"
"http(\'\\n    {\', ses);\n"
"need_comma := 0;\n"
"for (varctr := 0; varctr < varcount; varctr := varctr + 1)\n"
"{\n"
"declare val any;\n"
"val := rset[resctr][varctr];\n"
"if (val is null)\n"
"goto end_of_val_print;\n"
"if (need_comma)\n"
"http(\'\\t,\', ses);\n"
"else\n"
"need_comma := 1;\n"
"SPARQL_RESULTS_JSON_WRITE_BINDING (ses, metas[0][varctr][0], val);\n"
"end_of_val_print: ;\n"
"}\n"
"http(\'}\', ses);\n"
"}\n"
"http (\' ] } }\', ses);\n"
"}\n"
"--src sparql_io.sql:1148\n";

static const char *proc329 = 
"create function DB.DBA.SPARQL_RESULTS_WRITE (inout ses any, inout metas any, inout rset any, in accept varchar, in add_http_headers integer, in status any := null) returns varchar\n"
"{\n"
"declare singlefield varchar;\n"
"declare ret_mime, ret_format varchar;\n"
"if (status is not null)\n"
"{\n"
"http_header (concat (coalesce (http_header_get (), \'\'),\n"
"\'X-SQL-State: \', status[0], \'\\r\\nX-SQL-Message: \', status[1],\n"
"\'\\r\\nX-Exec-Milliseconds: \', cast (status[2] as varchar), \'\\r\\nX-Exec-DB-Activity: \', cast (status[3] as varchar),\n"
"\'\\r\\n\' ) );\n"
"}\n"
"if ((1 >= length (rset)) and (1 = length (metas[0])))\n"
"singlefield := metas[0][0][0];\n"
"else\n"
"singlefield := NULL;\n"
"\n"
"if (\'__ask_retval\' = singlefield)\n"
"{\n"
"ret_mime := http_sys_find_best_sparql_accept (accept, 0, ret_format);\n"
"if (ret_format in (\'JSON\', \'JSON;RES\'))\n"
"{\n"
"http (\n"
"concat (\n"
"\'{  \"head\": { \"link\": [] }, \"boolean\": \',\n"
"case (length (rset)) when 0 then \'false\' else \'true\' end,\n"
"\'}\'),\n"
"ses );\n"
"}\n"
"else if (ret_format = \'XML\')\n"
"{\n"
"SPARQL_RSET_XML_WRITE_NS (ses);\n"
"http (\n"
"concat (\n"
"\'\\n <head></head>\\n <boolean>\',\n"
"case (length (rset)) when 0 then \'false\' else \'true\' end,\n"
"\'</boolean>\\n</sparql>\'),\n"
"ses );\n"
"}\n"
"else if (ret_format = \'TTL\')\n"
"{\n"
"http (\'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"@prefix rs: <http://www.w3.org/2005/sparql-results#> .\\n\', ses);\n"
"http (sprintf (\'[] rdf:type rs:results ; rs:boolean %s .\', case (length (rset)) when 0 then \'false\' else \'true\' end), ses);\n"
"}\n"
"else\n"
"{\n"
"ret_mime := \'text/html\';\n"
"http (case (length (rset)) when 0 then \'false\' else \'true\' end, ses);\n"
"}\n"
"goto body_complete;\n"
"}\n"
"if (\'fmtaggret-0\' = singlefield)\n"
"{\n"
"if (strstr (accept, \'application/sparql-results+json\') is not null or strstr (accept, \'application/json\') is not null)\n"
"{\n"
"if (strstr (accept, \'application/sparql-results+json\') is not null)\n"
"ret_mime := \'application/sparql-results+json\';\n"
"else\n"
"ret_mime := \'application/json\';\n"
"}\n"
"else if (strstr (accept, \'application/sparql-results+xml\'))\n"
"{\n"
"ret_mime := \'application/sparql-results+xml\';\n"
"}\n"
"else\n"
"ret_mime := accept;\n"
"http (rset[0][0], ses);\n"
"goto body_complete;\n"
"}\n"
"if ((1 = length (rset)) and\n"
"(1 = length (rset[0])) and\n"
"(214 = __tag (rset[0][0])) )\n"
"{\n"
"declare triples any;\n"
"triples := dict_list_keys (rset[0][0], 1);\n"
"ret_mime := http_sys_find_best_sparql_accept (accept, 1, ret_format);\n"
"if ((ret_format is null) or (ret_format = \'TTL\'))\n"
"{\n"
"if (ret_format is null)\n"
"ret_mime := \'text/rdf+n3\';\n"
"DB.DBA.RDF_TRIPLES_TO_TTL (triples, ses);\n"
"if (status is not null)\n"
"SPARQL_WRITE_EXEC_STATUS (ses, \'#%015s: %s\\n\', status);\n"
"}\n"
"else if (ret_format = \'NT\')\n"
"DB.DBA.RDF_TRIPLES_TO_NT (triples, ses);\n"
"else if (ret_format in (\'JSON\', \'JSON;TALIS\'))\n"
"DB.DBA.RDF_TRIPLES_TO_TALIS_JSON (triples, ses);\n"
"else if (ret_format = \'JSON;RES\')\n"
"DB.DBA.RDF_TRIPLES_TO_JSON (triples, ses);\n"
"else if (ret_format = \'RDFA;XHTML\')\n"
"DB.DBA.RDF_TRIPLES_TO_RDFA_XHTML (triples, ses);\n"
"else if (ret_format = \'SOAP\')\n"
"{\n"
"declare soap_ns, spt_ns varchar;\n"
"declare soap_ver int;\n"
"\n"
"if (strstr (accept, \'application/soap+xml;11\') is not null)\n"
"soap_ver := 11;\n"
"else\n"
"soap_ver := 12;\n"
"soap_ns := DB.DBA.SPARQL_SOAP_NS (soap_ver);\n"
"spt_ns := DB.DBA.SPARQL_PT_NS ();\n"
"if (soap_ver = 12)\n"
"ret_mime := \'application/soap+xml\';\n"
"else\n"
"ret_mime := \'text/xml\';\n"
"http (\'<soapenv:Envelope xmlns:soapenv=\"\'||soap_ns||\'\"><soapenv:Body><query-result xmlns=\"\'||spt_ns||\'\">\', ses);\n"
"http (\'<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" \'||\n"
"\'xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\">\', ses);\n"
"DB.DBA.RDF_TRIPLES_TO_RDF_XML_TEXT (triples, 0, ses);\n"
"http (\'</rdf:RDF>\', ses);\n"
"http (\'</query-result></soapenv:Body></soapenv:Envelope>\', ses);\n"
"}\n"
"else\n"
"{\n"
"ret_mime := \'application/rdf+xml\';\n"
"DB.DBA.RDF_TRIPLES_TO_RDF_XML_TEXT (triples, 1, ses);\n"
"}\n"
"goto body_complete;\n"
"}\n"
"ret_mime := http_sys_find_best_sparql_accept (accept, 0, ret_format);\n"
"if (ret_format in (\'JSON\', \'JSON;RES\'))\n"
"{\n"
"if ((\'callretRDF/XML-0\' = singlefield) or (\'callretTURTLE-0\' = singlefield) or (\'callretTTL-0\' = singlefield))\n"
"{\n"
"http(\'\"\', ses);\n"
"http_escape (cast (rset[0][0] as varchar), 11, ses, 1, 1);\n"
"http(\'\"\', ses);\n"
"}\n"
"else\n"
"SPARQL_RESULTS_JSON_WRITE (ses, metas, rset);\n"
"goto body_complete;\n"
"}\n"
"if ((\'callretRDF/XML-0\' = singlefield) and (\'auto\' = accept))\n"
"{\n"
"ret_mime := \'application/rdf+xml\';\n"
"http (rset[0][0], ses);\n"
"goto body_complete;\n"
"}\n"
"if ((\'callretTURTLE-0\' = singlefield) or (\'callretTTL-0\' = singlefield))\n"
"{\n"
"if ((ret_format = \'TTL\') or (ret_format is null))\n"
"{\n"
"if (ret_format is null)\n"
"ret_mime := \'text/rdf+n3\';\n"
"}\n"
"http (rset[0][0], ses);\n"
"if (status is not null)\n"
"SPARQL_WRITE_EXEC_STATUS (ses, \'#%015s: %s\\n\', status);\n"
"goto body_complete;\n"
"}\n"
"if (ret_format = \'HTML\')\n"
"{\n"
"SPARQL_RESULTS_JAVASCRIPT_HTML_WRITE(ses, metas, rset, 0);\n"
"goto body_complete;\n"
"}\n"
"if (ret_format = \'JS\')\n"
"{\n"
"SPARQL_RESULTS_JAVASCRIPT_HTML_WRITE(ses, metas, rset, 1);\n"
"goto body_complete;\n"
"}\n"
"if (ret_format = \'SOAP\')\n"
"{\n"
"declare soap_ns, spt_ns varchar;\n"
"declare soap_ver int;\n"
"\n"
"if (strstr (accept, \'application/soap+xml;11\') is not null)\n"
"soap_ver := 11;\n"
"else\n"
"soap_ver := 12;\n"
"soap_ns := DB.DBA.SPARQL_SOAP_NS (soap_ver);\n"
"spt_ns := DB.DBA.SPARQL_PT_NS ();\n"
"if (soap_ver = 12)\n"
"ret_mime := \'application/soap+xml\';\n"
"else\n"
"ret_mime := \'text/xml\';\n"
"http (\'<soapenv:Envelope xmlns:soapenv=\"\'||soap_ns||\'\"><soapenv:Body><query-result xmlns=\"\'||spt_ns||\'\">\', ses);\n"
"SPARQL_RSET_XML_WRITE_NS (ses);\n"
"SPARQL_RESULTS_XML_WRITE_HEAD (ses, metas);\n"
"SPARQL_RESULTS_XML_WRITE_RES (ses, metas, rset);\n"
"http (\'\\n</sparql>\', ses);\n"
"http (\'</query-result></soapenv:Body></soapenv:Envelope>\', ses);\n"
"goto body_complete;\n"
"}\n"
"if (ret_format = \'TTL\')\n"
"{\n"
"if (ret_format is null)\n"
"ret_mime := \'text/rdf+n3\';\n"
"SPARQL_RESULTS_TTL_WRITE_NS (ses);\n"
"SPARQL_RESULTS_TTL_WRITE_HEAD (ses, metas);\n"
"SPARQL_RESULTS_TTL_WRITE_RES (ses, metas, rset);\n"
"goto body_complete;\n"
"}\n"
"if (ret_format = \'NT\')\n"
"{\n"
"SPARQL_RESULTS_NT_WRITE_NS (ses);\n"
"SPARQL_RESULTS_NT_WRITE_HEAD (ses, metas);\n"
"SPARQL_RESULTS_NT_WRITE_RES (ses, metas, rset);\n"
"goto body_complete;\n"
"}\n"
"if (ret_format = \'RDFXML\')\n"
"{\n"
"ret_mime := \'application/rdf+xml\';\n"
"SPARQL_RESULTS_RDFXML_WRITE_NS (ses);\n"
"SPARQL_RESULTS_RDFXML_WRITE_HEAD (ses, metas);\n"
"SPARQL_RESULTS_RDFXML_WRITE_RES (ses, metas, rset);\n"
"http (\'\\n  </rdf:Description>\', ses);\n"
"http (\'\\n</rdf:RDF>\', ses);\n"
"goto body_complete;\n"
"}\n"
"ret_mime := \'application/sparql-results+xml\';\n"
"SPARQL_RSET_XML_WRITE_NS (ses);\n"
"SPARQL_RESULTS_XML_WRITE_HEAD (ses, metas);\n"
"SPARQL_RESULTS_XML_WRITE_RES (ses, metas, rset);\n"
"http (\'\\n</sparql>\', ses);\n"
"\n"
"body_complete:\n"
"if (add_http_headers)\n"
"http_header (coalesce (http_header_get (), \'\') || \'Content-Type: \' || ret_mime || \'; charset=UTF-8\\r\\n\');\n"
"return ret_mime;\n"
"}\n"
"--src sparql_io.sql:1191\n";

static const char *proc330 = 
"create procedure WS.WS.SPARQL_VHOST_RESET ()\n"
"{\n"
"if (not exists (select 1 from \"DB\".\"DBA\".\"SYS_USERS\" where U_NAME = \'SPARQL\'))\n"
"{\n"
"DB.DBA.USER_CREATE (\'SPARQL\', uuid(), vector (\'DISABLED\', 1, \'LOGIN_QUALIFIER\', \'SPARQL\'));\n"
"DB.DBA.EXEC_STMT (\'grant SPARQL_SELECT to \"SPARQL\"\', 0);\n"
"}\n"
"if (registry_get (\'__SPARQL_VHOST_RESET\') = \'1\')\n"
"return;\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/SPARQL\');\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/sparql\');\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/services/sparql-query\');\n"
"DB.DBA.VHOST_DEFINE (lpath=>\'/sparql/\', ppath => \'/!sparql/\', is_dav => 1, vsp_user => \'dba\', opts => vector(\'noinherit\', 1));\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/sparql-auth\');\n"
"DB.DBA.VHOST_DEFINE (lpath=>\'/sparql-auth\',\n"
"ppath => \'/!sparql/\',\n"
"is_dav => 1,\n"
"vsp_user => \'dba\',\n"
"opts => vector(\'noinherit\', 1),\n"
"auth_fn=>\'DB.DBA.HP_AUTH_SPARQL_USER\',\n"
"realm=>\'SPARQL\',\n"
"sec=>\'digest\');\n"
"\n"
"\n"
"\n"
"registry_set (\'__SPARQL_VHOST_RESET\', \'1\');\n"
"}\n"
"--src sparql_io.sql:1419\n";

static const char *proc331 = 
"create procedure DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (\n"
"inout path varchar, inout params any, inout lines any,\n"
"in httpcode varchar, in httpstatus varchar,\n"
"in query varchar, in state varchar, in msg varchar, in accept varchar := null)\n"
"{\n"
"\n"
"\n"
"if (httpstatus is null)\n"
"{\n"
"declare errtitle varchar;\n"
"declare delim varchar;\n"
"delim := strchr (msg, \'\\n\');\n"
"if (delim is null)\n"
"errtitle := msg;\n"
"else\n"
"errtitle := subseq (msg, 0, delim);\n"
"httpstatus := sprintf (\'Error %s %s\', state, errtitle);\n"
"}\n"
"if (accept is not null and strstr (accept, \'application/soap+xml\') is not null)\n"
"{\n"
"declare err_str any;\n"
"declare soap_ver int;\n"
"if (strstr (accept, \'application/soap+xml;11\') is not null)\n"
"{\n"
"soap_ver := 11;\n"
"http_header (\'Content-Type: text/xml; charset=UTF-8\\r\\n\');\n"
"}\n"
"else\n"
"{\n"
"soap_ver := 12;\n"
"http_header (\'Content-Type: application/soap+xml; charset=UTF-8\\r\\n\');\n"
"}\n"
"http_request_status (sprintf (\'HTTP/1.1 500 %s\', httpstatus));\n"
"err_str := soap_make_error (\'320\', state, msg, soap_ver);\n"
"http (err_str);\n"
"return;\n"
"}\n"
"http_request_status (sprintf (\'HTTP/1.1 %s %s\', httpcode, httpstatus));\n"
"http_header (\'Content-Type: text/plain\\r\\n\');\n"
"http (concat (state, \' Error \', msg));\n"
"if (query is not null)\n"
"{\n"
"http (\'\\n\\nSPARQL query:\\n\');\n"
"http (query);\n"
"}\n"
"}\n"
"--src sparql_io.sql:1451\n";

static const char *proc332 = 
"create procedure DB.DBA.SPARQL_WSDL11 (in lines any)\n"
"{\n"
"declare host any;\n"
"host := http_request_header (lines, \'Host\', null, null);\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
"<definitions xmlns=\"http://schemas.xmlsoap.org/wsdl/\"\n"
"xmlns:tns=\"http://www.w3.org/2005/08/sparql-protocol-query/#\"\n"
"targetNamespace=\"http://www.w3.org/2005/08/sparql-protocol-query/#\">\n"
"<import namespace=\"http://www.w3.org/2005/08/sparql-protocol-query/#\"\n"
"location=\"http://www.w3.org/TR/sprot11/sparql-protocol-query-11.wsdl\"/>\n"
"<service name=\"SparqlService\">\n"
"<port name=\"SparqlServicePort\" binding=\"tns:QuerySoapBinding\">\n"
"<address location=\"http://%s/sparql\"/>\n"
"</port>\n"
"</service>\n"
"</definitions>\', host));\n"
"}\n"
"--src sparql_io.sql:1499\n";

static const char *proc333 = 
"create procedure DB.DBA.SPARQL_WSDL (in lines any)\n"
"{\n"
"declare host any;\n"
"host := http_request_header (lines, \'Host\', null, null);\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
"<description xmlns=\"http://www.w3.org/2006/01/wsdl\"\n"
"xmlns:tns=\"http://www.w3.org/2005/08/sparql-protocol-query/#\"\n"
"targetNamespace=\"http://www.w3.org/2005/08/sparql-protocol-query/#\">\n"
"<include location=\"http://www.w3.org/TR/rdf-sparql-protocol/sparql-protocol-query.wsdl\" />\n"
"<service name=\"SparqlService\" interface=\"tns:SparqlQuery\">\n"
"<endpoint name=\"SparqlEndpoint\" binding=\"tns:querySoap\" address=\"http://%s/sparql\"/>\n"
"</service>\n"
"</description>\', host));\n"
"}\n"
"--src sparql_io.sql:1518\n";

static const char *proc334 = 
"create procedure DB.DBA.SPARQL_SOAP_NS (in ver int)\n"
"{\n"
"if (ver = 11)\n"
"return \'http://schemas.xmlsoap.org/soap/envelope/\';\n"
"else if (ver = 12)\n"
"return \'http://www.w3.org/2003/05/soap-envelope\';\n"
"else\n"
"signal (\'42000\', \'Un-supported SOAP version\');\n"
"}\n"
"--src sparql_io.sql:1534\n";

static const char *proc335 = 
"create procedure DB.DBA.SPARQL_PT_NS ()\n"
"{\n"
"return \'http://www.w3.org/2005/09/sparql-protocol-types/#\';\n"
"}\n"
"--src sparql_io.sql:1545\n";

static const char *proc336 = 
" create function DB.DBA.PARSE_SPARQL_WS_PARAMS (in lst any) returns any\n"
"{\n"
"declare pval, parse, res any;\n"
"declare lst_len, ctr integer;\n"
"declare pname, ttl_txt varchar;\n"
"lst_len := length (lst);\n"
"ttl_txt := \'\';\n"
"vectorbld_init (res);\n"
"for (ctr := 0; ctr < lst_len; ctr := ctr+2)\n"
"{\n"
"pname := lst[ctr];\n"
"pval := lst[ctr+1];\n"
"if (regexp_like (pval, \'^((\"[^\"\\\\\\\\]\")|(\\\'[^\\\'\\\\\\\\]\\\'))\\044\'))\n"
"parse := subseq (pval, 1, length (pval)-1);\n"
"else if (regexp_like (pval, \'^((\"\"\"[^\"\\\\\\\\]\"\"\")|(\\\'\\\'\\\'[^\\\'\\\\\\\\]\\\'\\\'\\\'))\\044\'))\n"
"parse := subseq (pval, 3, length (pval)-3);\n"
"else if (regexp_like (\'^<.+>\\044\', pval))\n"
"{\n"
"parse := (subseq (pval, 1, length (pval)-1));\n"
"__box_flags_set (parse, 1);\n"
"}\n"
"else if (regexp_like (pval, \'^([+-]?[0-9]+)\\044\'))\n"
"parse := cast (pval as integer);\n"
"else if (regexp_like (pval, \'^([+-]?[0-9]+\\.[0-9]+([eE][+-]?[0-9]+)?)\\044\'))\n"
"parse := cast (pval as double precision);\n"
"else\n"
"{\n"
"parse := null;\n"
"ttl_txt := concat (ttl_txt, \'<\', pname, \'> <p> \', pval, \' .\\n\');\n"
"}\n"
"if (parse is not null)\n"
"\n"
"vectorbld_acc (res, \':\' || pname, parse);\n"
"}\n"
"if (ttl_txt <> \'\')\n"
"{\n"
"declare triples any;\n"
"triples := DB.DBA.RDF_TTL2SQLHASH (ttl_txt, \'\', \'!sparql\', 0);\n"
"triples := dict_list_keys (triples, 1);\n"
"foreach (any t in triples) do\n"
"{\n"
"vectorbld_acc (res, \':\' || t[0], t[2]);\n"
"}\n"
"}\n"
"vectorbld_final (res);\n"
"return res;\n"
"}\n"
"--src sparql_io.sql:1552\n";

static const char *proc337 = 
"create procedure DB.DBA.rdf_find_str (in x any)\n"
"{\n"
"return cast (x as varchar);\n"
"}\n"
"--src sparql_io.sql:1601\n";

static const char *other37 = 
"grant execute on DB.DBA.rdf_find_str to public\n";
static const char *proc338 = 
"create procedure WS.WS.\"/!sparql/\" (inout path varchar, inout params any, inout lines any)\n"
"{\n"
"declare query, full_query, format, should_sponge, debug, def_qry varchar;\n"
"declare dflt_graphs, named_graphs any;\n"
"declare paramctr, paramcount, qry_params, maxrows, can_sponge, start_time integer;\n"
"declare ses, content any;\n"
"declare def_max, add_http_headers, hard_timeout, timeout, client_supports_partial_res, sp_ini, soap_ver int;\n"
"declare http_meth, content_type, ini_dflt_graph, get_user, jsonp_callback varchar;\n"
"declare state, msg varchar;\n"
"declare metas, rset any;\n"
"declare accept, soap_action, user_id varchar;\n"
"declare exec_time, exec_db_activity any;\n"
"\n"
"if (registry_get (\'__sparql_endpoint_debug\') = \'1\')\n"
"{\n"
"for (declare i int, i := 0; i < length (params); i := i + 2)\n"
"{\n"
"if (isstring (params[i+1]))\n"
"dbg_printf (\'%s=%s\',params[i],params[i+1]);\n"
"else if (__tag (params[i+1]) = 185)\n"
"dbg_printf (\'%s=%s\',params[i],\'<strses>\');\n"
"else\n"
"dbg_printf (\'%s=%s\',params[i],\'<box>\');\n"
"}\n"
"}\n"
"\n"
"set http_charset=\'utf-8\';\n"
"ses := 0;\n"
"query := null;\n"
"format := \'\';\n"
"should_sponge := \'\';\n"
"debug := get_keyword (\'debug\', params, case (get_keyword (\'query\', params, \'\')) when \'\' then \'1\' else \'\' end);\n"
"add_http_headers := 1;\n"
"sp_ini := 0;\n"
"dflt_graphs := vector ();\n"
"named_graphs := vector ();\n"
"maxrows := 1024*1024;\n"
"http_meth := http_request_get (\'REQUEST_METHOD\');\n"
"ini_dflt_graph := cfg_item_value (virtuoso_ini_path (), \'SPARQL\', \'DefaultGraph\');\n"
"hard_timeout := atoi (coalesce (cfg_item_value (virtuoso_ini_path (), \'SPARQL\', \'MaxQueryExecutionTime\'), \'0\')) * 1000;\n"
"timeout := atoi (coalesce (cfg_item_value (virtuoso_ini_path (), \'SPARQL\', \'ExecutionTimeout\'), \'0\')) * 1000;\n"
"client_supports_partial_res := 0;\n"
"def_qry := cfg_item_value (virtuoso_ini_path (), \'SPARQL\', \'DefaultQuery\');\n"
"if (def_qry is null)\n"
"def_qry := \'SELECT * WHERE {?s ?p ?o}\';\n"
"def_max := atoi (coalesce (cfg_item_value (virtuoso_ini_path (), \'SPARQL\', \'ResultSetMaxRows\'), \'-1\'));\n"
"\n"
"user_id := connection_get (\'SPARQLUserId\', \'SPARQL\');\n"
"get_user := \'\';\n"
"soap_ver := 0;\n"
"soap_action := http_request_header (lines, \'SOAPAction\', null, null);\n"
"content_type := http_request_header (lines, \'Content-Type\', null, \'\');\n"
"\n"
"if (content_type = \'application/soap+xml\')\n"
"soap_ver := 12;\n"
"else if (soap_action is not null)\n"
"soap_ver := 11;\n"
"\n"
"content := null;\n"
"can_sponge := coalesce ((select top 1 1\n"
"from DB.DBA.SYS_USERS as sup\n"
"join DB.DBA.SYS_ROLE_GRANTS as g on (sup.U_ID = g.GI_SUPER)\n"
"join DB.DBA.SYS_USERS as sub on (g.GI_SUB = sub.U_ID)\n"
"where sup.U_NAME = \'SPARQL\' and sub.U_NAME = \'SPARQL_SPONGE\' ), 0);\n"
"declare exit handler for sqlstate \'*\' {\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'500\', \'SPARQL Request Failed\',\n"
"query, __SQL_STATE, __SQL_MESSAGE, format);\n"
"return;\n"
"};\n"
"\n"
"\n"
"if (http_path () = \'/sparql/services.wsdl\')\n"
"{\n"
"http_header (\'Content-Type: application/wsdl+xml\\r\\n\');\n"
"\n"
"DB.DBA.SPARQL_WSDL (lines);\n"
"return;\n"
"}\n"
"else if (http_path () = \'/sparql/services11.wsdl\')\n"
"{\n"
"http_header (\'Content-Type: text/xml\\r\\n\');\n"
"DB.DBA.SPARQL_WSDL11 (lines);\n"
"return;\n"
"}\n"
"\n"
"paramcount := length (params);\n"
"if (((0 = paramcount) or ((2 = paramcount) and (\'Content\' = params[0]))) and soap_ver = 0)\n"
"{\n"
"declare redir varchar;\n"
"redir := registry_get (\'WS.WS.SPARQL_DEFAULT_REDIRECT\');\n"
"if (isstring (redir))\n"
"{\n"
"http_request_status (\'HTTP/1.1 301 Moved Permanently\');\n"
"http_header (sprintf (\'Location: %s\\r\\n\', redir));\n"
"return;\n"
"}\n"
"http(\'<html xmlns=\"http://www.w3.org/1999/xhtml\">\\n\');\n"
"http(\'	<head>\\n\');\n"
"http(\'		<title>Virtuoso SPARQL Query Form</title>\\n\');\n"
"http(\'		<style type=\"text/css\">\\n\');\n"
"http(\'		label.n { display: inline; margin-top: 10pt; }\\n\');\n"
"http(\'		body { font-family: arial, helvetica, sans-serif; font-size: 9pt; color: #234; }\\n\');\n"
"http(\'		fieldset { border: 2px solid #86b9d9; }\\n\');\n"
"http(\'		legend { font-size: 12pt; color: #86b9d9; }\\n\');\n"
"http(\'		label { font-weight: bold; }\\n\');\n"
"http(\'		h1 { width: 100%; background-color: #86b9d9; font-size: 18pt; font-weight: normal; color: #fff; height: 4ex; text-align: right; vertical-align: middle; padding-right:  8px; }\\n\');\n"
"http(\'		textarea { width: 100%; padding: 3px; }\\n\');\n"
"http(\'		</style>\\n\');\n"
"http(\'		<script language=\"JavaScript\">\\n\');\n"
"http(\'var last_format = 1;\\n\');\n"
"http(\'function format_select(query_obg)\\n\');\n"
"http(\'{\\n\');\n"
"http(\'  var query = query_obg.value; \\n\');\n"
"http(\'  var format = query_obg.form.format;\\n\');\n"
"http(\'\\n\');\n"
"http(\'  if ((query.match(/construct/i) || query.match(/describe/i)) && last_format == 1) {\\n\');\n"
"http(\'    for(var i = format.options.length; i > 0; i--)\\n\');\n"
"http(\'      format.options[i] = null;\');\n"
"http(\'    format.options[1] = new Option(\\\'N3/Turtle\\\',\\\'text/rdf+n3\\\');\\n\');\n"
"http(\'    format.options[2] = new Option(\\\'JSON\\\',\\\'application/rdf+json\\\');\\n\');\n"
"http(\'    format.options[3] = new Option(\\\'RDF/XML\\\',\\\'application/rdf+xml\\\');\\n\');\n"
"http(\'    format.options[4] = new Option(\\\'NTriples\\\',\\\'text/plain\\\');\\n\');\n"
"http(\'    format.options[5] = new Option(\\\'XHTML+RDFa\\\',\\\'application/xhtml+xml\\\');\\n\');\n"
"http(\'    format.selectedIndex = 1;\\n\');\n"
"http(\'    last_format = 2;\\n\');\n"
"http(\'  }\\n\');\n"
"http(\'\\n\');\n"
"http(\'  if (!(query.match(/construct/i) || query.match(/describe/i)) && last_format == 2) {\\n\');\n"
"http(\'    for(var i = format.options.length; i > 0; i--)\\n\');\n"
"http(\'      format.options[i] = null;\\n\');\n"
"http(\'    format.options[1] = new Option(\\\'HTML\\\',\\\'text/html\\\');\\n\');\n"
"http(\'    format.options[2] = new Option(\\\'Spreadsheet\\\',\\\'application/vnd.ms-excel\\\');\\n\');\n"
"http(\'    format.options[3] = new Option(\\\'XML\\\',\\\'application/sparql-results+xml\\\');\\n\');\n"
"http(\'    format.options[4] = new Option(\\\'JSON\\\',\\\'application/sparql-results+json\\\');\\n\');\n"
"http(\'    format.options[5] = new Option(\\\'Javascript\\\',\\\'application/javascript\\\');\\n\');\n"
"http(\'    format.options[6] = new Option(\\\'N3/Turtle\\\',\\\'text/rdf+n3\\\');\\n\');\n"
"http(\'    format.options[7] = new Option(\\\'RDF/XML\\\',\\\'application/rdf+xml\\\');\\n\');\n"
"http(\'    format.options[8] = new Option(\\\'NTriples\\\',\\\'text/plain\\\');\\n\');\n"
"http(\'    format.selectedIndex = 1;\\n\');\n"
"http(\'    last_format = 1;\\n\');\n"
"http(\'  }\\n\');\n"
"http(\'}\\n\');\n"
"http(\'		</script>\\n\');\n"
"http(\'	</head>\\n\');\n"
"http(\'	<body>\\n\');\n"
"http(\'		<div id=\"header\">\\n\');\n"
"http(\'			<h1>OpenLink Virtuoso SPARQL Query</h1>\\n\');\n"
"http(\'		</div>\\n\');\n"
"http(\'		<div id=\"main\">\\n\');\n"
"http(\'			<p>This query page is designed to help you test OpenLink Virtuoso SPARQL protocol endpoint. <br/>\\n\');\n"
"http(\'			Consult the <a href=\"http://virtuoso.openlinksw.com/wiki/main/Main/VOSSparqlProtocol\">Virtuoso Wiki page</a> describing the service \\n\');\n"
"http(\'			or the <a href=\"http://docs.openlinksw.com/virtuoso/\">Online Virtuoso Documentation</a> section <a href=\"http://docs.openlinksw.com/virtuoso/rdfandsparql.html\">RDF Database and SPARQL</a>.</p>\\n\');\n"
"http(\'			<p>There is also a rich Web based user interface with sample queries. \\n\');\n"
"if (DB.DBA.VAD_CHECK_VERSION(\'iSPARQL\') is null)\n"
"http(\'			In order to use it you must install the iSPARQL package (isparql_dav.vad).</p>\\n\');\n"
"else\n"
"http(\'			You can access it at: <a href=\"/isparql\">/isparql</a>.</p>\\n\');\n"
"http(\'			<form action=\"\" method=\"GET\">\\n\');\n"
"http(\'			<fieldset>\\n\');\n"
"http(\'			<legend>Query</legend>\\n\');\n"
"http(\'			  <label for=\"default-graph-uri\">Default Graph URI</label>\\n\');\n"
"http(\'			  <br />\\n\');\n"
"http(\'			  <input type=\"text\" name=\"default-graph-uri\" id=\"default-graph-uri\"\\n\');\n"
"http(sprintf (\'				  	value=\"%s\" size=\"80\"/>\\n\', coalesce (ini_dflt_graph, \'\') ));\n"
"http(\'			  <br /><br />\\n\');\n"
"if (can_sponge)\n"
"{\n"
"declare s_param varchar;\n"
"s_param := get_keyword (\'should-sponge\', params, \'\');\n"
"http(\'<select name=\"should-sponge\" id=\"should-sponge\">\');\n"
"http(\'  <option\' ||\n"
"case (s_param) when \'\' then \' selected=\"selected\"\' else \'\' end ||\n"
"\' value=\"\">Use only local data (including data retrieved before), but do not retrieve more</option>\\n\');\n"
"http(\'  <option\' ||\n"
"case (s_param) when \'soft\' then \' selected=\"selected\"\' else \'\' end ||\n"
"\' value=\"soft\">Retrieve remote RDF data for all missing source graphs</option>\\n\');\n"
"http(\'  <option\' ||\n"
"case (s_param) when \'grab-all\' then \' selected=\"selected\"\' else \'\' end ||\n"
"\' value=\"grab-all\">Retrieve all missing remote RDF data that might be useful</option>\\n\');\n"
"http(\'  <option\' ||\n"
"case (s_param) when \'grab-all-seealso\' then \' selected=\"selected\"\' else \'\' end ||\n"
"\' value=\"grab-all-seealso\">Retrieve all missing remote RDF data that might be useful, including seeAlso references</option>\\n\');\n"
"http(\'  <option\' ||\n"
"case (s_param) when \'grab-everything\' then \' selected=\"selected\"\' else \'\' end ||\n"
"\' value=\"grab-everything\">Try to download all referenced resources (this may be very slow and inefficient)</option>\\n\');\n"
"http(\'</select>\\n\');\n"
"http(\'			  <br />\\n\');\n"
"}\n"
"else\n"
"{\n"
"declare host_ur varchar;\n"
"host_ur := registry_get (\'URIQADefaultHost\');\n"
"\n"
"http(\'			  <i>Security restrictions of this server do not allow you to retrieve remote RDF data.\n"
"DBA may wish to grant \"SPARQL_SPONGE\" privilege to \"SPARQL\" account to remove the restriction.\\n\');\n"
"http(\'In order to do this, please perform the following steps:</i>\\n\');\n"
"http(\'<br />\\n\');\n"
"http(\'1. Go to the Virtuoso Administration Conductor i.e. \\n\');\n"
"if (not isstring (host_ur))\n"
"{\n"
"http(\'http://host:port/conductor\\n\');\n"
"}\n"
"else\n"
"{\n"
"http(sprintf(\'http://%s/conductor\\n\',host_ur));\n"
"};\n"
"\n"
"http(\'<br />\\n\');\n"
"http(\'2. Login as dba user\\n\');\n"
"http(\'<br />\\n\');\n"
"http(\'3. Go to System Admin->User Accounts->Roles\\n\');\n"
"http(\'<br />\\n\');\n"
"http(\'4. Click the link \"Edit\" for \"SPARQL_SPONGE\"\\n\');\n"
"http(\'<br />\\n\');\n"
"http(\'5. Select from the list of available user/groups \"SPARQL\" and click the \">>\" button so to add it to the right-positioned list.\\n\');\n"
"http(\'<br />\\n\');\n"
"http(\'6. Click the button \"Update\"\\n\');\n"
"http(\'<br />\\n\');\n"
"http(\'7. Access again the sparql endpoint in order to be able to retrieve remote data.\\n\');\n"
"http(\'<br /><br />\\n\');\n"
"}\n"
"http(\'			  <label for=\"query\">Query text</label>\\n\');\n"
"http(\'			  <br />\\n\');\n"
"http(\'			  <textarea rows=\"10\" cols=\"80\" name=\"query\" id=\"query\" onchange=\"format_select(this)\" onkeyup=\"format_select(this)\">\'|| def_qry ||\'</textarea>\\n\');\n"
"http(\'			  <br /><br />\\n\');\n"
"\n"
"\n"
"\n"
"\n"
"http(\'			  <label for=\"format\" class=\"n\">Display Results As:</label>\\n\');\n"
"http(\'			  <select name=\"format\">\\n\');\n"
"http(\'			    <option value=\"auto\">Auto</option>\\n\');\n"
"http(\'			    <option value=\"text/html\" selected=\"selected\">HTML</option>\\n\');\n"
"http(\'			    <option value=\"application/vnd.ms-excel\">Spreadsheet</option>\\n\');\n"
"http(\'			    <option value=\"application/sparql-results+xml\">XML</option>\\n\');\n"
"http(\'			    <option value=\"application/sparql-results+json\">JSON</option>\\n\');\n"
"http(\'			    <option value=\"application/javascript\">Javascript</option>\\n\');\n"
"http(\'			    <option value=\"text/plain\">NTriples</option>\\n\');\n"
"http(\'			    <option value=\"application/rdf+xml\">RDF/XML</option>\\n\');\n"
"http(\'			  </select>\\n\');\n"
"http(\'&nbsp;&nbsp;&nbsp;\\n\');\n"
"http(\'<input name=\"debug\" type=\"checkbox\"\' || case (debug) when \'\' then \'\' else \' checked\' end || \'/>\');\n"
"http(\'&nbsp;<label for=\"debug\" class=\"n\"><nobr>Rigorous check of the query</nobr></label>\\n\');\n"
"http(\'&nbsp;&nbsp;&nbsp;\\n\');\n"
"http(\'<input name=\"timeout\" type=\"text\"\' || case (isnull (timeout)) when 0 then cast (timeout as varchar) else \'\' end || \'/>\');\n"
"http(\'&nbsp;<label for=\"timeout\" class=\"n\"><nobr>Execution timeout, in milliseconds, values less than 1000 are ignored</nobr></label>\\n\');\n"
"http(\'&nbsp;&nbsp;&nbsp;\\n\');\n"
"http(\'			  <input type=\"submit\" value=\"Run Query\"/>\');\n"
"http(\'&nbsp;<input type=\"reset\" value=\"Reset\"/>\\n\');\n"
"http(\'			</fieldset>\\n\');\n"
"http(\'			</form>\\n\');\n"
"http(\'		</div>\\n\');\n"
"http(\'	</body>\\n\');\n"
"http(\'</html>\\n\');\n"
"return;\n"
"}\n"
"qry_params := dict_new (7);\n"
"for (paramctr := 0; paramctr < paramcount; paramctr := paramctr + 2)\n"
"{\n"
"declare pname, pvalue varchar;\n"
"pname := params [paramctr];\n"
"pvalue := params [paramctr+1];\n"
"if (\'query\' = pname)\n"
"query := pvalue;\n"
"else if (\'find\' = pname)\n"
"{\n"
"declare cls, words, ft, vec, cond varchar;\n"
"cls := get_keyword (\'class\', params);\n"
"maxrows := atoi (get_keyword (\'maxrows\', params, cast (maxrows as varchar)));\n"
"if (def_max > 0 and def_max < maxrows)\n"
"maxrows := def_max;\n"
"if (cls is not null)\n"
"cond := sprintf (\' ?s a %s . \', cls);\n"
"else\n"
"cond := \'\';\n"
"ft := trim (DB.DBA.FTI_MAKE_SEARCH_STRING_INNER (pvalue, words), \'()\');\n"
"if (ft is null or length (words) = 0)\n"
"{\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'400\', \'Bad Request\',\n"
"query, \'22023\', \'The value of \"find\" parameter of web service endpoint is not a valid search string\' );\n"
"return;\n"
"}\n"
"vec := DB.DBA.SYS_SQL_VECTOR_PRINT (words);\n"
"if (get_keyword (\'format\', params, \'\') like \'%/rdf+%\' or http_request_header (lines, \'Accept\', null, \'\') like \'%/rdf+%\')\n"
"query := sprintf (\'construct { ?s ?p `bif:search_excerpt (bif:vector (%s), sql:rdf_find_str(?o))` } \' ||\n"
"\'where { ?s ?p ?o . %s filter (bif:contains (?o, \'\'%s\'\')) } limit %d\', vec, cond, ft, maxrows);\n"
"else\n"
"query := sprintf (\'select ?s ?p (bif:search_excerpt (bif:vector (%s), sql:rdf_find_str(?o))) \' ||\n"
"\'where { ?s ?p ?o . %s filter (bif:contains (?o, \'\'%s\'\')) } limit %d\', vec, cond, ft, maxrows);\n"
"}\n"
"else if (\'default-graph-uri\' = pname and length (pvalue))\n"
"{\n"
"if (position (pvalue, dflt_graphs) <= 0)\n"
"dflt_graphs := vector_concat (dflt_graphs, vector (pvalue));\n"
"}\n"
"else if (\'named-graph-uri\' = pname and length (pvalue))\n"
"{\n"
"if (position (pvalue, named_graphs) <= 0)\n"
"named_graphs := vector_concat (named_graphs, vector (pvalue));\n"
"}\n"
"else if (\'maxrows\' = pname)\n"
"{\n"
"maxrows := cast (pvalue as integer);\n"
"}\n"
"else if (\'should-sponge\' = pname)\n"
"{\n"
"if (can_sponge)\n"
"should_sponge := trim(pvalue);\n"
"}\n"
"else if (\'format\' = pname or \'output\' = pname)\n"
"{\n"
"format := pvalue;\n"
"}\n"
"else if (\'timeout\' = pname)\n"
"{\n"
"declare t integer;\n"
"t := cast (pvalue as integer) * 1000;\n"
"if (t is not null and t >= 1000)\n"
"{\n"
"if (hard_timeout >= 1000)\n"
"timeout := __min (t, hard_timeout);\n"
"else\n"
"timeout := t;\n"
"}\n"
"client_supports_partial_res := 1;\n"
"}\n"
"else if (\'ini\' = pname)\n"
"{\n"
"sp_ini := 1;\n"
"}\n"
"else if (query is null and \'query-uri\' = pname and length (pvalue))\n"
"{\n"
"if (cfg_item_value (virtuoso_ini_path (), \'SPARQL\', \'ExternalQuerySource\') = \'1\')\n"
"{\n"
"declare uri varchar;\n"
"declare hf, hdr, charset any;\n"
"uri := pvalue;\n"
"if (uri like \'http://%\' and uri not like \'http://localdav.virt/%\' and uri not like \'http://local.virt/dav/%\')\n"
"{\n"
"query := http_get (uri, hdr);\n"
"if (hdr[0] not like \'% 200%\')\n"
"signal (\'22023\', concat (\'HTTP request failed: \', hdr[0], \'for URI \', uri));\n"
"charset := http_request_header (hdr, \'Content-Type\', \'charset\', \'\');\n"
"if (charset <> \'\')\n"
"{\n"
"query := charset_recode (query, charset, \'UTF-8\');\n"
"}\n"
"}\n"
"else\n"
"{\n"
"query := DB.DBA.XML_URI_GET (\'\', pvalue);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'403\', \'Prohibited\', query, \'22023\', \'The external query sources are prohibited.\');\n"
"return;\n"
"}\n"
"}\n"
"else if (\'xslt-uri\' = pname and length (pvalue))\n"
"{\n"
"if (cfg_item_value (virtuoso_ini_path (), \'SPARQL\', \'ExternalXsltSource\') = \'1\')\n"
"{\n"
"add_http_headers := 0;\n"
"http_xslt (pvalue);\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'403\', \'Prohibited\', query, \'22023\', \'The XSL-T transformation is prohibited\');\n"
"return;\n"
"}\n"
"}\n"
"else if (\'get-login\' = pname)\n"
"{\n"
"get_user := pvalue;\n"
"}\n"
"else if (\'callback\' = pname)\n"
"{\n"
"jsonp_callback := pvalue;\n"
"}\n"
"else if (pname[0] = \'?\'[0])\n"
"{\n"
"dict_put (qry_params, subseq (pname, 1), pvalue);\n"
"}\n"
"}\n"
"if (format <> \'\')\n"
"{\n"
"format := (\n"
"case lower(format)\n"
"when \'json\' then \'application/sparql-results+json\'\n"
"when \'js\' then \'application/javascript\'\n"
"when \'html\' then \'text/html\'\n"
"when \'sparql\' then \'application/sparql-results+xml\'\n"
"when \'xml\' then \'application/sparql-results+xml\'\n"
"when \'rdf\' then \'application/rdf+xml\'\n"
"when \'n3\' then \'text/rdf+n3\'\n"
"else format\n"
"end);\n"
"}\n"
"\n"
"if (def_max > 0 and def_max < maxrows)\n"
"maxrows := def_max;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (http_meth = \'POST\' and soap_ver > 0)\n"
"{\n"
"declare xt, dgs, ngs any;\n"
"declare soap_ns, spt_ns, ns_decl varchar;\n"
"soap_ns := DB.DBA.SPARQL_SOAP_NS (soap_ver);\n"
"spt_ns := DB.DBA.SPARQL_PT_NS ();\n"
"ns_decl := \'[ xmlns:soap=\"\'||soap_ns||\'\" xmlns:sp=\"\'||spt_ns||\'\" ] \';\n"
"content := http_body_read ();\n"
"if (registry_get (\'__sparql_endpoint_debug\') = \'1\')\n"
"dbg_printf (\'content=[%s]\', string_output_string (content));\n"
"xt := xtree_doc (content);\n"
"query := charset_recode (xpath_eval (ns_decl||\'string (/soap:Envelope/soap:Body/sp:query-request/query)\', xt), \'_WIDE_\', \'UTF-8\');\n"
"dgs := xpath_eval (ns_decl||\'/soap:Envelope/soap:Body/sp:query-request/default-graph-uri\', xt, 0);\n"
"ngs := xpath_eval (ns_decl||\'/soap:Envelope/soap:Body/sp:query-request/named-graph-uri\', xt, 0);\n"
"foreach (any frag in dgs) do\n"
"{\n"
"declare pvalue varchar;\n"
"pvalue := charset_recode (xpath_eval (\'string(.)\', frag), \'_WIDE_\', \'UTF-8\');\n"
"if (position (pvalue, dflt_graphs) <= 0)\n"
"dflt_graphs := vector_concat (dflt_graphs, vector (pvalue));\n"
"}\n"
"foreach (any frag in ngs) do\n"
"{\n"
"declare pvalue varchar;\n"
"pvalue := charset_recode (xpath_eval (\'string(.)\', frag), \'_WIDE_\', \'UTF-8\');\n"
"if (position (pvalue, named_graphs) <= 0)\n"
"named_graphs := vector_concat (named_graphs, vector (pvalue));\n"
"}\n"
"format := sprintf(\'application/soap+xml;%d\', soap_ver);\n"
"}\n"
"if (format <> \'\')\n"
"accept := format;\n"
"else\n"
"accept := http_request_header (lines, \'Accept\', null, \'\');\n"
"if (sp_ini)\n"
"{\n"
"SPARQL_INI_PARAMS (metas, rset);\n"
"goto write_results;\n"
"}\n"
"\n"
"if (query is null)\n"
"{\n"
"if (strstr (content_type, \'application/xml\') is not null)\n"
"{\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'400\', \'Bad Request\',\n"
"query, \'22023\', \'XML notation of SPARQL queries is not supported\' );\n"
"return;\n"
"}\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'400\', \'Bad Request\',\n"
"query, \'22023\', \'The request does not contain text of SPARQL query\', format);\n"
"return;\n"
"}\n"
"\n"
"full_query := query;\n"
"\n"
"declare req_hosts varchar;\n"
"declare req_hosts_split any;\n"
"declare hctr integer;\n"
"req_hosts := http_request_header (lines, \'Host\', null, null);\n"
"req_hosts := replace (req_hosts, \', \', \',\');\n"
"req_hosts_split := split_and_decode (req_hosts, 0, \'\\0\\0,\');\n"
"for (hctr := length (req_hosts_split) - 1; hctr >= 0; hctr := hctr - 1)\n"
"{\n"
"for (select top 1 SH_GRAPH_URI, SH_DEFINES from DB.DBA.SYS_SPARQL_HOST\n"
"where req_hosts_split [hctr] like SH_HOST) do\n"
"{\n"
"if (length (dflt_graphs) = 0 and length (SH_GRAPH_URI))\n"
"dflt_graphs := vector (SH_GRAPH_URI);\n"
"if (SH_DEFINES is not null)\n"
"full_query := concat (SH_DEFINES, \' \', full_query);\n"
"goto host_found;\n"
"}\n"
"}\n"
"host_found:\n"
"\n"
"foreach (varchar dg in dflt_graphs) do\n"
"{\n"
"full_query := concat (\'define input:default-graph-uri <\', dg, \'> \', full_query);\n"
"http_header (http_header_get () || sprintf (\'X-SPARQL-default-graph: %U\\r\\n\', dg));\n"
"}\n"
"foreach (varchar ng in named_graphs) do\n"
"{\n"
"full_query := concat (\'define input:named-graph-uri <\', ng, \'> \', full_query);\n"
"http_header (http_header_get () || sprintf (\'X-SPARQL-named-graph: %U\\r\\n\', ng));\n"
"}\n"
"if ((should_sponge = \'soft\') or (should_sponge = \'replacing\'))\n"
"full_query := concat (sprintf(\'define get:soft \"%s\" \',should_sponge), full_query);\n"
"else if (should_sponge = \'grab-all\')\n"
"full_query := concat (\'define input:grab-all \"yes\" define input:grab-depth 5 define input:grab-limit 100 \', full_query);\n"
"else if (should_sponge = \'grab-all-seealso\')\n"
"full_query := concat (\'define input:grab-all \"yes\" define input:grab-depth 5 define input:grab-limit 200 define input:grab-seealso <http://www.w3.org/2000/01/rdf-schema#seeAlso> define input:grab-seealso <http://xmlns.com/foaf/0.1/seeAlso> \', full_query);\n"
"else if (should_sponge = \'grab-everything\')\n"
"full_query := concat (\'define input:grab-all \"yes\" define input:grab-intermediate \"yes\" define input:grab-depth 5 define input:grab-limit 500 define input:grab-seealso <http://www.w3.org/2000/01/rdf-schema#seeAlso> define input:grab-seealso <http://xmlns.com/foaf/0.1/seeAlso> \', full_query);\n"
"\n"
"if (debug <> \'\')\n"
"full_query := concat (\'define sql:signal-void-variables 1 \', full_query);\n"
"if (get_user <> \'\')\n"
"full_query := concat (\'define get:login \"\', get_user, \'\" \', full_query);\n"
"if (dict_size (qry_params) > 0)\n"
"{\n"
"declare pnames any;\n"
"pnames := dict_list_keys (qry_params, 0);\n"
"foreach (varchar pname in pnames) do\n"
"{\n"
"full_query := concat (\'define sql:param \"\', pname, \'\" \', full_query);\n"
"}\n"
"qry_params := DB.DBA.PARSE_SPARQL_WS_PARAMS (dict_to_vector (qry_params, 1));\n"
"}\n"
"else\n"
"qry_params := vector ();\n"
"state := \'00000\';\n"
"metas := null;\n"
"rset := null;\n"
"if (registry_get (\'__sparql_endpoint_debug\') = \'1\')\n"
"dbg_printf (\'query=[%s]\', full_query);\n"
"\n"
"declare sc_max int;\n"
"declare sc decimal;\n"
"sc_max := atoi (coalesce (cfg_item_value (virtuoso_ini_path (), \'SPARQL\', \'MaxQueryCostEstimationTime\'), \'-1\'));\n"
"if (sc_max < 0)\n"
"sc_max := atoi (coalesce (cfg_item_value (virtuoso_ini_path (), \'SPARQL\', \'MaxExecutionTime\'), \'-1\'));\n"
"if (sc_max > 0)\n"
"{\n"
"state := \'00000\';\n"
"sc := exec_score (concat (\'sparql \', full_query), state, msg);\n"
"if ((sc/1000) > sc_max)\n"
"{\n"
"signal (\'42000\', sprintf (\'The estimated execution time %d (sec) exceeds the limit of %d (sec).\', sc/1000, sc_max));\n"
"}\n"
"}\n"
"\n"
"state := \'00000\';\n"
"metas := null;\n"
"rset := null;\n"
"\n"
"if (not client_supports_partial_res)\n"
"{\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"declare fmtxml, fmtttl varchar;\n"
"if (strstr (accept, \'application/sparql-results+xml\') is not null)\n"
"fmtxml := \'\"HTTP+XML application/sparql-results+xml\" \';\n"
"if (strstr (accept, \'text/rdf+n3\') is not null)\n"
"fmtttl := \'\"HTTP+TTL text/rdf+n3\" \';\n"
"else if (strstr (accept, \'text/rdf+ttl\') is not null)\n"
"fmtttl := \'\"HTTP+TTL text/rdf+ttl\" \';\n"
"else if (strstr (accept, \'text/rdf+turtle\') is not null)\n"
"fmtttl := \'\"HTTP+TTL text/rdf+turtle\" \';\n"
"else if (strstr (accept, \'text/turtle\') is not null)\n"
"fmtttl := \'\"HTTP+TTL text/turtle\" \';\n"
"else if (strstr (accept, \'application/turtle\') is not null)\n"
"fmtttl := \'\"HTTP+TTL application/turtle\" \';\n"
"else if (strstr (accept, \'application/x-turtle\') is not null)\n"
"fmtttl := \'\"HTTP+TTL application/x-turtle\" \';\n"
"if (isstring (fmtttl))\n"
"{\n"
"if (isstring (fmtxml))\n"
"full_query := \'define output:format \' || fmtxml || \'define output:dict-format \' || fmtttl || full_query;\n"
"else\n"
"full_query := \'define output:format \' || fmtttl || full_query;\n"
"}\n"
"\n"
" ;\n"
"}\n"
"\n"
"\n"
"\n"
"commit work;\n"
"if (client_supports_partial_res and (timeout > 0))\n"
"{\n"
"set RESULT_TIMEOUT = timeout;\n"
"\n"
"set TRANSACTION_TIMEOUT=timeout + 10000;\n"
"}\n"
"else if (hard_timeout >= 1000)\n"
"{\n"
"set TRANSACTION_TIMEOUT=hard_timeout;\n"
"}\n"
"set_user_id (user_id);\n"
"start_time := msec_time();\n"
"exec ( concat (\'sparql \', full_query), state, msg, qry_params, vector (\'max_rows\', maxrows, \'use_cache\', 1), metas, rset);\n"
"commit work;\n"
"\n"
"if (state = \'00000\')\n"
"goto write_results;\n"
"if (state = \'S1TAT\')\n"
"{\n"
"exec_time := msec_time () - start_time;\n"
"exec_db_activity := db_activity ();\n"
"\n"
"\n"
"\n"
"}\n"
"else\n"
"{\n"
"declare state2, msg2 varchar;\n"
"state2 := \'00000\';\n"
"exec (\'isnull (sparql_to_sql_text (?))\', state2, msg2, vector (full_query));\n"
"if (state2 <> \'00000\')\n"
"{\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'400\', \'Bad Request\',\n"
"full_query, state2, msg2, format);\n"
"return;\n"
"}\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'500\', \'SPARQL Request Failed\',\n"
"full_query, state, msg, format);\n"
"return;\n"
"}\n"
"write_results:\n"
"if ((1 <> length (metas[0])) or (\'aggret-0\' <> metas[0][0][0]))\n"
"{\n"
"declare status any;\n"
"if (isinteger (msg))\n"
"status := NULL;\n"
"else\n"
"status := vector (state, msg, exec_time, exec_db_activity);\n"
"if (isstring (jsonp_callback))\n"
"http (jsonp_callback || \'(\\n\');\n"
"DB.DBA.SPARQL_RESULTS_WRITE (ses, metas, rset, accept, add_http_headers, status);\n"
"if (isstring (jsonp_callback))\n"
"http (\')\');\n"
"}\n"
"}\n"
"--src sparql_io.sql:1612\n";

static const char *other38 = 
"registry_set (\'/!sparql/\', \'no_vsp_recompile\')\n";
static const char *proc339 = 
" create function DB.DBA.SPARQL_ROUTE_IF_DAV (in graph_iri varchar, in output_format_name varchar)\n"
"{\n"
"\n"
"\n"
"if (graph_iri like \'http://local.virt/DAV/%\')\n"
"return subseq (graph_iri, 17);\n"
"return NULL;\n"
"}\n"
"--src sparql_io.sql:2272\n";

static const char *proc340 = 
"create procedure DB.DBA.SPARQL_ROUTE_DICT_CONTENT_DAV (\n"
"in graph_iri varchar,\n"
"in opname varchar,\n"
"in storage_name varchar,\n"
"in output_storage_name varchar,\n"
"in output_format_name varchar,\n"
"in del_dict any,\n"
"in ins_dict any,\n"
"in env any,\n"
"in uid varchar,\n"
"in log_mode integer,\n"
"in compose_report integer )\n"
"{\n"
"declare split, in_mime, mime, perr, fake_content varchar;\n"
"declare final_res, triples, out_ses, rc any;\n"
"declare old_perms, pwd varchar;\n"
"declare old_gid, old_uid any;\n"
"declare dir any;\n"
"split := DB.DBA.SPARQL_ROUTE_IF_DAV (graph_iri, output_format_name);\n"
"\n"
"if (\'dba\' = uid)\n"
"uid := \'dav\';\n"
"pwd := (select pwd_magic_calc (U_NAME, U_PASSWORD, 1) from SYS_USERS where U_NAME=uid);\n"
"\n"
"if (split is not null)\n"
"{\n"
"dir := DAV_DIR_LIST (split, 0, uid, pwd);\n"
"if (isinteger (dir) and (0 > dir))\n"
"signal (\'RDFXX\', sprintf (\'SPARUL %s can not get DAV directory info about \"%.200s\": %s\', opname, split, DB.DBA.DAV_PERROR (dir)));\n"
"if (1 = length (dir))\n"
"{\n"
"if (\'c\' = dir[0][1])\n"
"signal (\'RDFXX\', sprintf (\'SPARUL %s can not edit \"%.200s\": it is collection, not a resource\', opname, split));\n"
"old_perms := dir[0][5];\n"
"old_gid := dir[0][6];\n"
"old_uid := dir[0][7];\n"
"in_mime := dir[0][9];\n"
"}\n"
"else\n"
"signal (\'RDFXX\', sprintf (\'SPARUL %s can not edit \"%.200s\": can not get directory listing with it\', opname, split));\n"
"fake_content := null;\n"
"mime := DB.DBA.RDF_SPONGE_GUESS_CONTENT_TYPE (graph_iri, in_mime, fake_content);\n"
"if (\'application/rdf+xml\' = mime)\n"
"{\n"
"if ((output_format_name is not null) and (output_format_name <> \'AUTO\') and (output_format_name <> \'RDF/XML\'))\n"
"signal (\'RDFXX\', sprintf (\'SPARUL can not update resource \"%.200s\" because its MIME type \"%s\" conflicts with directive output:format \"%s\"\', graph_iri, coalesce (in_mime, mime), output_format_name));\n"
"}\n"
"else if (\'text/rdf+n3\' = mime)\n"
"{\n"
"if ((output_format_name is not null) and (output_format_name <> \'AUTO\') and (output_format_name <> \'TURTLE\') and (output_format_name <> \'TTL\'))\n"
"signal (\'RDFXX\', sprintf (\'SPARUL can not update resource \"%.200s\" because its MIME type \"%s\" conflicts with directive output:format \"%s\"\', graph_iri, coalesce (in_mime, mime), output_format_name));\n"
"}\n"
"else\n"
"signal (\'RDFXX\', sprintf (\'SPARUL can not update resource \"%.200s\" of MIME type \"%s\" because only \"application/rdf+xml\" and \"text/rdf+n3\" are supported\', graph_iri, coalesce (in_mime, mime)));\n"
"}\n"
"if (\'INSERT\' = opname)\n"
"final_res := DB.DBA.SPARQL_INSERT_DICT_CONTENT (graph_iri, ins_dict, uid, log_mode, compose_report);\n"
"else if (\'DELETE\' = opname)\n"
"final_res := DB.DBA.SPARQL_DELETE_DICT_CONTENT (graph_iri, del_dict, uid, log_mode, compose_report);\n"
"else if (\'MODIFY\' = opname)\n"
"final_res := DB.DBA.SPARQL_MODIFY_BY_DICT_CONTENTS (graph_iri, del_dict, ins_dict, uid, log_mode, compose_report);\n"
"if (split is not null)\n"
"{\n"
"out_ses := string_output();\n"
"triples := (select VECTOR_AGG (vector (\"s\", \"p\", \"o\")) from\n"
"(sparql define input:storage \"\" define output:valmode \"LONG\"\n"
"select ?s ?p ?o where {\n"
"graph `iri(?:graph_iri)` { ?s ?p ?o } }\n"
"order by (str(?s)) (str(?p)) ) as sub );\n"
"if (\'application/rdf+xml\' = mime)\n"
"DB.DBA.RDF_TRIPLES_TO_RDF_XML_TEXT (triples, 1, out_ses);\n"
"else if ((\'text/rdf+n3\' = mime) or (\'text/rdf+ttl\' = mime) or (\'text/rdf+turtle\' = mime) or (\'text/turtle\' = mime) or (\'text/n3\' = mime))\n"
"DB.DBA.RDF_TRIPLES_TO_TTL (triples, out_ses);\n"
"else if (\'text/plain\' = mime)\n"
"DB.DBA.RDF_TRIPLES_TO_NT (triples, out_ses);\n"
"else if ((\'application/json\' = mime) or (\'application/rdf+json\' = mime) or (\'application/x-rdf+json\' = mime))\n"
"DB.DBA.RDF_TRIPLES_TO_TALIS_JSON (triples, out_ses);\n"
"else if (\'application/xhtml+xml\' = mime)\n"
"DB.DBA.RDF_TRIPLES_TO_RDFA_XHTML (triples, out_ses);\n"
"rc := DB.DBA.DAV_RES_UPLOAD (split, out_ses, mime, old_perms, old_uid, old_gid, uid, pwd);\n"
"if (isinteger (rc) and rc < 0)\n"
"signal (\'RDFXX\', sprintf (\'Unable to change \"%.200s\" in DAV: %s\', split, DB.DBA.DAV_PERROR (rc)));\n"
"}\n"
"if (not isinteger (final_res))\n"
"return final_res;\n"
"}\n"
"--src sparql_io.sql:2282\n";

static const char *proc341 = 
"create procedure\n"
"WS.WS.__http_handler_rq (in content any, in params any, in lines any, inout ipath_ostat any)\n"
"{\n"
"return DB.DBA.http_rq_file_handler(content, params, lines, ipath_ostat);\n"
"}\n"
"--src sparql_io.sql:2371\n";

static const char *proc342 = 
"create procedure\n"
"WS.WS.__http_handler_head_rq (in content any, in params any, in lines any, inout ipath_ostat any)\n"
"{\n"
"return DB.DBA.http_rq_file_handler(content, params, lines, ipath_ostat);\n"
"}\n"
"--src sparql_io.sql:2378\n";

static const char *proc343 = 
"create procedure\n"
"DB.DBA.http_rq_file_handler (in content any, in params any, in lines any, inout ipath_ostat any)\n"
"{\n"
"declare accept varchar;\n"
"declare _format varchar;\n"
"\n"
"accept := http_request_header (lines, \'Accept\', null, \'\');\n"
"\n"
"_format := get_keyword(\'format\', params, \'\');\n"
"if (_format <> \'\')\n"
"{\n"
"_format := (\n"
"case lower(_format)\n"
"when \'json\' then \'application/sparql-results+json\'\n"
"when \'js\' then \'application/javascript\'\n"
"when \'html\' then \'text/html\'\n"
"when \'spreadsheet\' then \'application/vnd.ms-excel\'\n"
"when \'sparql\' then \'application/sparql-results+xml\'\n"
"when \'xml\' then \'application/sparql-results+xml\'\n"
"when \'rdf\' then \'application/rdf+xml\'\n"
"when \'n3\' then \'text/rdf+n3\'\n"
"else _format\n"
"end);\n"
"}\n"
"\n"
"if (_format <> \'\' or\n"
"strcasestr (accept, \'application/sparql-results+json\') is not null or\n"
"strcasestr (accept, \'application/json\') is not null or\n"
"strcasestr (accept, \'application/sparql-results+xml\') is not null or\n"
"strcasestr (accept, \'text/rdf+n3\') is not null or\n"
"strcasestr (accept, \'text/rdf+ttl\') is not null or\n"
"strcasestr (accept, \'text/rdf+turtle\') is not null or\n"
"strcasestr (accept, \'text/turtle\') is not null or\n"
"strcasestr (accept, \'application/rdf+xml\') is not null or\n"
"strcasestr (accept, \'application/javascript\') is not null or\n"
"strcasestr (accept, \'application/soap+xml\') is not null or\n"
"strcasestr (accept, \'application/rdf+turtle\') is not null\n"
")\n"
"{\n"
"http_request_status (\'HTTP/1.1 303 See Other\');\n"
"http_header (sprintf(\'Location: /sparql?query=%U&format=%U\\r\\n\', content, accept));\n"
"return \'\';\n"
"}\n"
"if (strcasestr (accept, \'application/sparql-query\') is not null)\n"
"http_header (\'Content-Type: application/sparql-query\\r\\n\');\n"
"else\n"
"http_header (\'Content-Type: text/plain\\r\\n\');\n"
"http (content);\n"
"return \'\';\n"
"}\n"
"--src sparql_io.sql:2385\n";

static const char *proc344 = 
"create procedure DB.DBA.RDF_GRANT_SPARQL_IO ()\n"
"{\n"
"declare state, msg varchar;\n"
"declare cmds any;\n"
"cmds := vector (\n"
"\'grant execute on DB.DBA.SPARQL_REXEC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_REXEC_TO_ARRAY to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_REXEC_WITH_META to SPARQL_SELECT\',\n"
"\'grant execute on WS.WS.\"/!sparql/\" to \"SPARQL\"\',\n"
"\'grant execute on DB.DBA.SPARQL_ROUTE_DICT_CONTENT_DAV to SPARQL_UPDATE\' );\n"
"foreach (varchar cmd in cmds) do\n"
"{\n"
"exec (cmd, state, msg);\n"
"}\n"
"}\n"
"--src sparql_io.sql:2437\n";


static const char *other39 = 
" DB.DBA.RDF_GRANT_SPARQL_IO ()\n";
/* rdf_sponge.sql */

static const char *proc345 = 
" create procedure DB.DBA.RDF_FT_INDEX_GRABBED (inout grabbed any, inout options any)\n"
"{\n"
"declare grabbed_list any;\n"
"declare grab_ctr, grab_count integer;\n"
"declare g_iri varchar;\n"
"if (not get_keyword (\'refresh_free_text\', options, 0))\n"
"return;\n"
"g_iri := get_keyword (\'get:group-destination\', options);\n"
"\n"
"if (isstring (g_iri) and __rdf_obj_ft_rule_count_in_graph (iri_to_id (g_iri)))\n"
"{\n"
"VT_INC_INDEX_DB_DBA_RDF_OBJ();\n"
"commit work;\n"
"\n"
"return;\n"
"}\n"
"grabbed_list := dict_to_vector (grabbed, 0);\n"
"grab_count := length (grabbed_list);\n"
"\n"
"for (grab_ctr := 1; grab_ctr < grab_count; grab_ctr := grab_ctr + 2)\n"
"{\n"
"g_iri := grabbed_list[grab_ctr];\n"
"if (isstring (g_iri) and __rdf_obj_ft_rule_count_in_graph (iri_to_id (g_iri)))\n"
"{\n"
"VT_INC_INDEX_DB_DBA_RDF_OBJ();\n"
"commit work;\n"
"\n"
"return;\n"
"}\n"
"}\n"
"\n"
"}\n"
"--src rdf_sponge.sql:27\n";

static const char *proc346 = 
"create function DB.DBA.RDF_GRAB_SINGLE (in val any, inout grabbed any, inout env any) returns integer\n"
"{\n"
"declare url, get_method, recov varchar;\n"
"declare dest varchar;\n"
"declare opts any;\n"
"\n"
"{\n"
"whenever sqlstate \'*\' goto end_of_sponge;\n"
"if (val is null)\n"
"return 0;\n"
"if (isiri_id (val))\n"
"{\n"
"if (is_bnode_iri_id (val))\n"
"return 0;\n"
"val := id_to_iri (val);\n"
"}\n"
"if (217 = __tag (val))\n"
"val := cast (val as varchar);\n"
"call (get_keyword (\'resolver\', env)) (get_keyword (\'base_iri\', env), val, url, dest, get_method);\n"
"if (url is not null and not dict_get (grabbed, url, 0))\n"
"{\n"
"declare final_dest, final_gdest varchar;\n"
"final_dest := get_keyword (\'get:destination\', env, dest);\n"
"final_gdest := get_keyword (\'get:group-destination\', env, dest);\n"
"opts := vector (\n"
"\'get:soft\', get_keyword_ucase (\'get:soft\', env, \'soft\'),\n"
"\'get:refresh\', get_keyword_ucase (\'get:refresh\', env),\n"
"\'get:method\', get_method,\n"
"\'get:destination\', final_dest,\n"
"\'get:group-destination\', final_gdest\n"
");\n"
"dict_put (grabbed, url, 1);\n"
"call (get_keyword (\'loader\', env))(url, opts);\n"
"commit work;\n"
"dict_put (grabbed, url, coalesce (final_dest, dest));\n"
"\n"
"if (get_keyword (\'refresh_free_text\', env, 0) and\n"
"(__rdf_obj_ft_rule_count_in_graph (iri_to_id (final_dest)) or\n"
"__rdf_obj_ft_rule_count_in_graph (iri_to_id (final_gdest)) ) )\n"
"{\n"
"VT_INC_INDEX_DB_DBA_RDF_OBJ();\n"
"\n"
"commit work;\n"
"}\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"end_of_sponge:\n"
"commit work;\n"
"recov := get_keyword_ucase (\'get:error-recovery\', env);\n"
"if (recov is not null)\n"
"{\n"
"whenever sqlstate \'*\' goto end_of_recov;\n"
"call (recov) (__SQL_STATE, __SQL_MESSAGE);\n"
"commit work;\n"
"return 0;\n"
"end_of_recov:\n"
"rollback work;\n"
"}\n"
"return 0;\n"
"}\n"
"--src rdf_sponge.sql:61\n";

static const char *proc347 = 
"create procedure DB.DBA.RDF_GRAB_SINGLE_ASYNC (in val any, in grabbed any, in env any, in counter_limit integer := 1)\n"
"{\n"
"\n"
"if (dict_size (grabbed) < counter_limit)\n"
"DB.DBA.RDF_GRAB_SINGLE (val, grabbed, vector_concat (vector (\'refresh_free_text\', 0), env));\n"
"}\n"
"--src rdf_sponge.sql:125\n";

static const char *proc348 = 
"create function DB.DBA.RDF_GRAB_SEEALSO (in subj varchar, in opt_g varchar, inout env any) returns integer\n"
"{\n"
"declare grabbed, aq any;\n"
"declare sa_graphs, sa_preds any;\n"
"declare doc_limit integer;\n"
"if (not isiri_id (subj))\n"
"return 1;\n"
"aq := async_queue (8);\n"
"grabbed := get_keyword (\'grabbed\', env);\n"
"doc_limit := get_keyword (\'doc_limit\', env);\n"
"if (dict_size (grabbed) > doc_limit)\n"
"goto out_of_limit;\n"
"sa_preds := get_keyword (\'sa_preds\', env);\n"
"sa_graphs := get_keyword (\'sa_graphs\', env);\n"
"\n"
"foreach (varchar pred in sa_preds) do\n"
"{\n"
"foreach (varchar graph in sa_graphs) do\n"
"{\n"
"for (sparql define input:storage \"\" select ?val where { graph ?:graph { ?:subj ?:pred ?val . filter (isIRI(?val)) } } ) do\n"
"{\n"
"\n"
"if (\"val\" like \'http://%\')\n"
"{\n"
"\n"
"\n"
"aq_request (aq, \'DB.DBA.RDF_GRAB_SINGLE_ASYNC\', vector (\"val\", grabbed, env, doc_limit));\n"
"if (dict_size (grabbed) > doc_limit)\n"
"goto out_of_limit;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"if (opt_g is not null)\n"
"{\n"
"foreach (varchar pred in sa_preds) do\n"
"{\n"
"for (sparql define input:storage \"\" select ?val where { graph ?:opt_g { ?:subj ?:pred ?val . filter (isIRI(?val)) } } ) do\n"
"{\n"
"\n"
"if (\"val\" like \'http://%\')\n"
"{\n"
"\n"
"\n"
"aq_request (aq, \'DB.DBA.RDF_GRAB_SINGLE_ASYNC\', vector (\"val\", grabbed, env, doc_limit));\n"
"if (dict_size (grabbed) > doc_limit)\n"
"goto out_of_limit;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"if (bit_and (1, get_keyword (\'flags\', env, 0)))\n"
"{\n"
"declare subj_iri varchar;\n"
"subj_iri := id_to_iri (subj);\n"
"if (subj_iri like \'http://%\')\n"
"{\n"
"\n"
"\n"
"aq_request (aq, \'DB.DBA.RDF_GRAB_SINGLE_ASYNC\', vector (subj_iri, grabbed, env, doc_limit));\n"
"}\n"
"}\n"
"out_of_limit:\n"
"commit work;\n"
"aq_wait_all (aq);\n"
"DB.DBA.RDF_FT_INDEX_GRABBED (grabbed, env);\n"
"if (dict_size (grabbed) > doc_limit)\n"
"return 4;\n"
"return 2;\n"
"}\n"
"--src rdf_sponge.sql:133\n";

static const char *proc349 = 
"create procedure\n"
"DB.DBA.RDF_GRAB (\n"
"in app_params any, in seed varchar, in iter varchar, in final varchar, in ret_limit integer,\n"
"in const_iris any, in sa_graphs any, in sa_preds any, in depth integer, in doc_limit integer,\n"
"in base_iri varchar, in destination varchar, in group_destination varchar, in resolver varchar, in loader varchar,\n"
"in refresh_free_text integer, in plain_ret integer, in flags integer,\n"
"in uid any )\n"
"{\n"
"declare rctr, rcount, colcount, iter_ctr integer;\n"
"declare stat, msg varchar;\n"
"declare grab_params, all_params any;\n"
"declare grabbed, metas, rset, aq any;\n"
"\n"
"grab_params := vector (\'sa_graphs\', sa_graphs, \'sa_preds\', sa_preds,\n"
"\'doc_limit\', doc_limit, \'base_iri\', base_iri,\n"
"\'get:destination\', destination,\n"
"\'get:group-destination\', group_destination,\n"
"\'resolver\', resolver, \'loader\', loader,\n"
"\'refresh_free_text\', refresh_free_text,\n"
"\'flags\', flags, \'grabbed\', dict_new() );\n"
"all_params := vector_concat (vector (grab_params), app_params);\n"
"aq := async_queue (8);\n"
"grabbed := dict_new ();\n"
"foreach (any val in const_iris) do\n"
"{\n"
"\n"
"if (val is not null and __rgs_ack_cbk (val, uid, 4))\n"
"{\n"
"\n"
"\n"
"aq_request (aq, \'DB.DBA.RDF_GRAB_SINGLE_ASYNC\', vector (val, grabbed, grab_params, doc_limit));\n"
"}\n"
"}\n"
"commit work;\n"
"aq_wait_all (aq);\n"
"commit work;\n"
"DB.DBA.RDF_FT_INDEX_GRABBED (grabbed, grab_params);\n"
"commit work;\n"
"if (dict_size (grabbed) >= doc_limit)\n"
"goto final_exec;\n"
"for (iter_ctr := 0; iter_ctr <= depth; iter_ctr := iter_ctr + 1)\n"
"{\n"
"declare old_doc_count integer;\n"
"old_doc_count := dict_size (grabbed);\n"
"stat := \'00000\';\n"
"exec (case (iter_ctr) when 0 then seed else iter end, stat, msg, all_params, __max (ret_limit, doc_limit, 1000), metas, rset);\n"
"if (stat <> \'00000\')\n"
"signal (stat, msg);\n"
"rcount := length (rset);\n"
"colcount := length (metas[0]);\n"
"\n"
"for (rctr := 0; rctr < rcount; rctr := rctr + 1)\n"
"{\n"
"declare colctr integer;\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"declare val any;\n"
"declare dest varchar;\n"
"val := rset[rctr][colctr];\n"
"if (is_named_iri_id (val) and __rgs_ack_cbk (val, uid, 4))\n"
"{\n"
"\n"
"\n"
"aq_request (aq, \'DB.DBA.RDF_GRAB_SINGLE_ASYNC\', vector (val, grabbed, grab_params, doc_limit));\n"
"if (dict_size (grabbed) >= doc_limit)\n"
"goto final_exec;\n"
"}\n"
"}\n"
"}\n"
"commit work;\n"
"aq_wait_all (aq);\n"
"commit work;\n"
"DB.DBA.RDF_FT_INDEX_GRABBED (grabbed, grab_params);\n"
"commit work;\n"
"if (old_doc_count = dict_size (grabbed))\n"
"goto final_exec;\n"
"}\n"
"\n"
"final_exec:\n"
"stat := \'00000\';\n"
"exec (final, stat, msg, app_params, ret_limit, metas, rset);\n"
"if (stat <> \'00000\')\n"
"signal (stat, msg);\n"
"if (plain_ret)\n"
"return rset[0][0];\n"
"rcount := length (rset);\n"
"result_names (rset);\n"
"for (rctr := 0; rctr < rcount; rctr := rctr + 1)\n"
"result (rset[rctr]);\n"
"}\n"
"--src rdf_sponge.sql:205\n";

static const char *proc350 = 
"create function DB.DBA.RDF_GRAB_RESOLVER_DEFAULT (in base varchar, in rel_uri varchar, out abs_uri varchar, out dest_uri varchar, out get_method varchar)\n"
"{\n"
"declare rel_lattice_pos, base_lattice_pos integer;\n"
"declare lattice_tail varchar;\n"
"if (217 = __tag (rel_uri))\n"
"rel_uri := cast (rel_uri as varchar);\n"
"if (217 = __tag (base))\n"
"base := cast (base as varchar);\n"
"rel_lattice_pos := strrchr (rel_uri, \'#\');\n"
"lattice_tail := \'\';\n"
"if (rel_lattice_pos is not null)\n"
"{\n"
"lattice_tail := subseq (rel_uri, rel_lattice_pos);\n"
"rel_uri := subseq (rel_uri, 0, rel_lattice_pos);\n"
"}\n"
"if ((base is not null) and (base <> \'\'))\n"
"{\n"
"base_lattice_pos := strrchr (cast (base as varchar), \'#\');\n"
"if (base_lattice_pos is not null)\n"
"{\n"
"if (\'\' = lattice_tail)\n"
"lattice_tail := subseq (base, base_lattice_pos);\n"
"base := subseq (base, 0, base_lattice_pos);\n"
"}\n"
"}\n"
"else\n"
"base := \'\';\n"
"if (base = \'\')\n"
"abs_uri := rel_uri;\n"
"else\n"
"abs_uri := XML_URI_RESOLVE_LIKE_GET (base, rel_uri);\n"
"dest_uri := abs_uri;\n"
"if (abs_uri like \'%/\')\n"
"get_method := \'GET+MGET\';\n"
"else\n"
"get_method := \'GET\';\n"
"\n"
"}\n"
"--src rdf_sponge.sql:297\n";

static const char *proc351 = 
"create procedure DB.DBA.SPARQL_EVAL_TO_ARRAY (in query varchar, in dflt_graph varchar, in maxrows integer)\n"
"{\n"
"declare state, msg varchar;\n"
"declare metas, rset any;\n"
"if (dflt_graph is not null)\n"
"query := concat (\'sparql define input:default-graph-uri <\', dflt_graph, \'> \', query);\n"
"else\n"
"query := concat (\'sparql \', query);\n"
"state := \'00000\';\n"
"metas := null;\n"
"rset := null;\n"
"exec (query, state, msg, vector(), maxrows, metas, rset);\n"
"\n"
"if (state <> \'00000\')\n"
"signal (state, msg);\n"
"return rset;\n"
"}\n"
"--src rdf_sponge.sql:342\n";

static const char *proc352 = 
"create procedure DB.DBA.SPARQL_EVAL (in query varchar, in dflt_graph varchar, in maxrows integer)\n"
"{\n"
"declare sqltext, state, msg varchar;\n"
"declare metas, rset any;\n"
"if (dflt_graph is not null)\n"
"query := concat (\'sparql define input:default-graph-uri <\', dflt_graph, \'> \', query);\n"
"else\n"
"query := concat (\'sparql \', query);\n"
"state := \'00000\';\n"
"metas := null;\n"
"rset := null;\n"
"exec (query, state, msg, vector(), maxrows, metas, rset);\n"
"if (state <> \'00000\')\n"
"signal (state, msg);\n"
"\n"
"exec_result_names (metas[0]);\n"
"foreach (any row in rset) do\n"
"{\n"
"exec_result (row);\n"
"}\n"
"}\n"
"--src rdf_sponge.sql:361\n";

static const char *tbl18 = 
"create table DB.DBA.SYS_HTTP_SPONGE (\n"
"HS_LOCAL_IRI varchar not null,\n"
"HS_PARSER varchar not null,\n"
"HS_ORIGIN_URI varchar not null,\n"
"HS_ORIGIN_LOGIN varchar,\n"
"HS_LAST_LOAD datetime,\n"
"HS_LAST_ETAG varchar,\n"
"HS_LAST_READ datetime,\n"
"HS_EXP_IS_TRUE integer,\n"
"HS_EXPIRATION datetime,\n"
"HS_LAST_MODIFIED datetime,\n"
"HS_DOWNLOAD_SIZE integer,\n"
"HS_DOWNLOAD_MSEC_TIME integer,\n"
"HS_READ_COUNT integer,\n"
"HS_SQL_STATE varchar,\n"
"HS_SQL_MESSAGE varchar,\n"
"HS_FROM_IRI varchar,\n"
"HS_QUALITY double precision,\n"
"primary key (HS_LOCAL_IRI, HS_PARSER)\n"
")\n"
"alter index SYS_HTTP_SPONGE on DB.DBA.SYS_HTTP_SPONGE partition (HS_LOCAL_IRI varchar)\n"
"create index SYS_HTTP_SPONGE_EXPIRATION on DB.DBA.SYS_HTTP_SPONGE (HS_EXPIRATION desc) partition (HS_LOCAL_IRI varchar)\n"
"create index SYS_HTTP_SPONGE_FROM_IRI on DB.DBA.SYS_HTTP_SPONGE (HS_FROM_IRI, HS_PARSER) partition (HS_FROM_IRI varchar)\n";

static const char *proc353 = 
"create procedure DB.DBA.SYS_HTTP_SPONGE_GET_CACHE_PARAMS\n"
"(\n"
"in explicit_refresh any,\n"
"in old_last_modified any,\n"
"inout ret_hdr any,\n"
"inout new_expiration any,\n"
"out ret_content_type any,\n"
"out ret_etag any,\n"
"out ret_date any,\n"
"out ret_expires any,\n"
"out ret_last_modif any,\n"
"out ret_dt_date any,\n"
"out ret_dt_expires any,\n"
"out ret_dt_last_modified any\n"
")\n"
"{\n"
"declare ret_304_not_modified int;\n"
"\n"
"ret_304_not_modified := 0;\n"
"if (ret_hdr[0] like \'HTTP%304%\')\n"
"{\n"
"ret_304_not_modified := 1;\n"
"}\n"
"\n"
"ret_content_type := http_request_header (ret_hdr, \'Content-Type\', null, null);\n"
"ret_etag := http_request_header (ret_hdr, \'ETag\', null, null);\n"
"ret_date := http_request_header (ret_hdr, \'Date\', null, null);\n"
"ret_expires := http_request_header (ret_hdr, \'Expires\', null, null);\n"
"ret_last_modif := http_request_header (ret_hdr, \'Last-Modified\', null, null);\n"
"ret_dt_date := http_string_date (ret_date, NULL, NULL);\n"
"ret_dt_expires := http_string_date (ret_expires, NULL, now());\n"
"ret_dt_last_modified := http_string_date (ret_last_modif, NULL, now());\n"
"if (http_request_header (ret_hdr, \'Pragma\', null, null) = \'no-cache\' or\n"
"http_request_header (ret_hdr, \'Cache-Control\', null, null) like \'no-cache%\' )\n"
"ret_dt_expires := now ();\n"
"if (ret_304_not_modified and ret_dt_last_modified is null)\n"
"ret_dt_last_modified := old_last_modified;\n"
"if (ret_dt_date is not null)\n"
"{\n"
"if (ret_dt_expires is not null)\n"
"ret_dt_expires := dateadd (\'second\', datediff (\'second\', ret_dt_date, now()), ret_dt_expires);\n"
"if (ret_dt_last_modified is not null)\n"
"ret_dt_last_modified := dateadd (\'second\', datediff (\'second\', ret_dt_date, now()), ret_dt_last_modified);\n"
"}\n"
"if (ret_dt_expires is not null and\n"
"(ret_dt_expires < coalesce (ret_dt_date, ret_dt_last_modified, now ())) )\n"
"ret_dt_expires := NULL;\n"
"if (ret_dt_expires is not null)\n"
"new_expiration := ret_dt_expires;\n"
"else\n"
"{\n"
"if (ret_dt_date is not null and ret_dt_last_modified is not null and (ret_dt_date >= ret_dt_last_modified))\n"
"new_expiration := dateadd (\'second\',\n"
"__min (\n"
"3600 * 24 * 7,\n"
"0.7 * datediff (\'second\', ret_dt_last_modified, ret_dt_date)\n"
"),\n"
"now());\n"
"}\n"
"if (ret_304_not_modified)\n"
"{\n"
"if (new_expiration is null and explicit_refresh is not null)\n"
"new_expiration := dateadd (\'second\', 0.7 * explicit_refresh, now());\n"
"\n"
"if (ret_dt_expires is null and new_expiration is not null and explicit_refresh is not null)\n"
"new_expiration := __min (new_expiration, dateadd (\'second\', explicit_refresh, now()));\n"
"}\n"
"}\n"
"--src rdf_sponge.sql:419\n";

static const char *proc354 = 
"create procedure DB.DBA.SYS_HTTP_SPONGE_DEP_URL_NOT_CHANGED (in local_iri varchar, in parser varchar, in explicit_refresh int)\n"
"{\n"
"\n"
"for select\n"
"HS_LOCAL_IRI as old_local_iri,\n"
"HS_LAST_LOAD as old_last_load,\n"
"HS_READ_COUNT as old_read_count,\n"
"HS_EXP_IS_TRUE as old_exp_is_true,\n"
"HS_EXPIRATION as old_expiration,\n"
"HS_LAST_MODIFIED as old_last_modified\n"
"from DB.DBA.SYS_HTTP_SPONGE where HS_FROM_IRI = local_iri and HS_PARSER = parser\n"
"do\n"
"{\n"
"\n"
"\n"
"if (old_expiration is not null)\n"
"{\n"
"if ((old_expiration >= now()) and (\n"
"explicit_refresh is null or\n"
"old_exp_is_true or\n"
"(dateadd (\'second\', explicit_refresh, old_last_load) >= now()) ) )\n"
"{\n"
"\n"
"update DB.DBA.SYS_HTTP_SPONGE\n"
"set HS_LAST_READ = now(), HS_READ_COUNT = old_read_count + 1\n"
"where HS_LOCAL_IRI = old_local_iri and HS_LAST_READ < now();\n"
"commit work;\n"
"}\n"
"else\n"
"{\n"
"return 0;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (old_last_load >= now() and old_expiration is null)\n"
"{\n"
"\n"
"return 0;\n"
"}\n"
"}\n"
"}\n"
"return 1;\n"
"}\n"
"--src rdf_sponge.sql:492\n";

static const char *proc355 = 
"create procedure DB.DBA.RDF_HTTP_MAKE_HTTP_REQ (in url varchar, in meth varchar, in req varchar)\n"
"{\n"
"declare hf any;\n"
"declare str any;\n"
"\n"
"hf := rfc1808_parse_uri (url);\n"
"str := meth || \' \' || hf[2] || case when hf[4] <> \'\' then \'?\' else \'\' end || hf[4] || \' HTTP/1.1\\r\\n\' ||\n"
"\'Host: \' || hf[1] || \'\\r\\n\' || req;\n"
"str := replace (str, \'\\r\', \'\\n\');\n"
"str := replace (str, \'\\n\\n\', \'\\n\');\n"
"return split_and_decode (str, 0, \'\\0\\0\\n\');\n"
"}\n"
"--src rdf_sponge.sql:538\n";

static const char *proc356 = 
"create function DB.DBA.SYS_HTTP_SPONGE_UP (in local_iri varchar, in get_uri varchar, in parser varchar, in eraser varchar, in options any)\n"
"{\n"
"declare new_origin_uri, new_origin_login, new_last_etag varchar;\n"
"declare old_origin_uri, old_origin_login, old_last_etag varchar;\n"
"declare new_last_load, new_expiration datetime;\n"
"declare old_last_load, old_expiration, old_last_modified datetime;\n"
"declare load_begin_msec, load_end_msec, old_exp_is_true,\n"
"old_download_size, old_download_msec_time, old_read_count,\n"
"new_download_size, explicit_refresh integer;\n"
"declare get_method varchar;\n"
"declare ret_hdr, immg, req_hdr_arr any;\n"
"declare req_hdr varchar;\n"
"declare ret_body, ret_content_type, ret_etag, ret_last_modified, ret_date, ret_last_modif, ret_expires varchar;\n"
"declare get_proxy varchar;\n"
"declare ret_dt_date, ret_dt_last_modified, ret_dt_expires datetime;\n"
"declare ret_304_not_modified integer;\n"
"declare parser_rc, max_refresh int;\n"
"\n"
"\n"
"new_origin_uri := cast (get_keyword_ucase (\'get:uri\', options, get_uri) as varchar);\n"
"new_origin_login := cast (get_keyword_ucase (\'get:login\', options) as varchar);\n"
"explicit_refresh := get_keyword_ucase (\'get:refresh\', options);\n"
"if (explicit_refresh is null)\n"
"{\n"
"max_refresh := cfg_item_value (virtuoso_ini_path (), \'SPARQL\', \'MaxCacheExpiration\');\n"
"if (max_refresh is not null)\n"
"{\n"
"max_refresh := atoi (max_refresh);\n"
"if (max_refresh >= 0)\n"
"explicit_refresh := max_refresh;\n"
"}\n"
"}\n"
"else if (isstring (explicit_refresh))\n"
"explicit_refresh := atoi (explicit_refresh);\n"
"set isolation=\'serializable\';\n"
"whenever not found goto add_new_origin;\n"
"select HS_ORIGIN_URI, HS_ORIGIN_LOGIN, HS_LAST_LOAD, HS_LAST_ETAG,\n"
"HS_EXP_IS_TRUE, HS_EXPIRATION, HS_LAST_MODIFIED,\n"
"HS_DOWNLOAD_SIZE, HS_DOWNLOAD_MSEC_TIME, HS_READ_COUNT\n"
"into old_origin_uri, old_origin_login, old_last_load, old_last_etag,\n"
"old_exp_is_true, old_expiration, old_last_modified,\n"
"old_download_size, old_download_msec_time, old_read_count\n"
"from DB.DBA.SYS_HTTP_SPONGE where HS_LOCAL_IRI = local_iri and HS_PARSER = parser for update;\n"
"\n"
"if ((new_origin_uri <> old_origin_uri) and (eraser is not null))\n"
"signal (\'RDFXX\',\n"
"sprintf (\'Can not get-and-cache RDF graph <%.500s> from <%.500s> because is has been loaded from <%.500s>\',\n"
"local_iri, new_origin_uri, old_origin_uri) );\n"
"\n"
"if (coalesce (new_origin_login, \'\') <> coalesce (old_origin_login, \'\') and\n"
"old_expiration is not null )\n"
"signal (\'RDFXX\',\n"
"sprintf (\'Can not get-and-cache RDF graph <%.500s> from <%.500s> using %s because is has been loaded using %s\',\n"
"local_iri, new_origin_uri,\n"
"case (isnull (new_origin_login)) when 0 then sprintf (\'login \"%.100s\"\', new_origin_login) else \'anonymous access\' end,\n"
"case (isnull (old_origin_login)) when 0 then sprintf (\'login \"%.100s\"\', old_origin_login) else \'anonymous access\' end ) );\n"
"\n"
"\n"
"\n"
"if (eraser is null)\n"
"{\n"
"\n"
"goto perform_actual_load;\n"
"}\n"
"if (old_expiration is not null)\n"
"{\n"
"if ((old_expiration >= now() and (old_exp_is_true or old_last_etag is null) and explicit_refresh is null) or\n"
"(explicit_refresh is not null and dateadd (\'second\', explicit_refresh, old_last_load) >= now()))\n"
"{\n"
"\n"
"update DB.DBA.SYS_HTTP_SPONGE\n"
"set HS_LAST_READ = now(), HS_READ_COUNT = old_read_count + 1\n"
"where HS_LOCAL_IRI = local_iri and HS_LAST_READ < now();\n"
"commit work;\n"
"return local_iri;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"\n"
"return local_iri;\n"
"}\n"
"\n"
"update_old_origin:\n"
"\n"
"update DB.DBA.SYS_HTTP_SPONGE\n"
"set HS_LAST_LOAD = now(), HS_LAST_ETAG = NULL, HS_LAST_READ = NULL,\n"
"HS_EXP_IS_TRUE = 0, HS_EXPIRATION = NULL, HS_LAST_MODIFIED = NULL,\n"
"HS_DOWNLOAD_SIZE = NULL, HS_DOWNLOAD_MSEC_TIME = NULL,\n"
"HS_READ_COUNT = 0,\n"
"HS_SQL_STATE = NULL, HS_SQL_MESSAGE = NULL\n"
"where\n"
"HS_LOCAL_IRI = local_iri and HS_PARSER = parser;\n"
"commit work;\n"
"goto perform_actual_load;\n"
"\n"
"add_new_origin:\n"
"\n"
"old_origin_uri := NULL; old_origin_login := NULL; old_last_load := NULL; old_last_etag := NULL;\n"
"old_expiration := NULL; old_download_size := NULL; old_download_msec_time := NULL;\n"
"old_exp_is_true := 0; old_read_count := 0;\n"
"insert into DB.DBA.SYS_HTTP_SPONGE (HS_LOCAL_IRI, HS_PARSER, HS_ORIGIN_URI, HS_ORIGIN_LOGIN, HS_LAST_LOAD)\n"
"values (local_iri, parser, new_origin_uri, new_origin_login, now());\n"
"commit work;\n"
"goto perform_actual_load;\n"
"\n"
"perform_actual_load:\n"
"\n"
"new_expiration := NULL;\n"
"new_last_etag := NULL;\n"
"ret_304_not_modified := 0;\n"
"load_begin_msec := msec_time();\n"
"set isolation=\'committed\';\n"
"commit work;\n"
"get_method := cast (get_keyword_ucase (\'get:method\', options, \'GET\') as varchar);\n"
"\n"
"if (get_method in (\'POST\', \'GET\', \'GET+MGET\'))\n"
"{\n"
"req_hdr := NULL;\n"
"get_proxy := get_keyword_ucase (\'get:proxy\', options);\n"
"connection_set (\'sparql-get:proxy\', get_proxy);\n"
"\n"
"\n"
"\n"
"if (old_last_etag is not null and explicit_refresh is null)\n"
"req_hdr := \'If-None-Match: \' || old_last_etag;\n"
"else if (old_last_load is not null and explicit_refresh is null)\n"
"req_hdr := \'If-Modified-Since: \' || DB.DBA.date_rfc1123 (old_last_load);\n"
"\n"
"\n"
"\n"
"req_hdr := req_hdr || case when length (req_hdr) > 0 then \'\\r\\n\' else \'\' end\n"
"|| \'User-Agent: OpenLink Virtuoso RDF crawler\\r\\n\'\n"
"|| \'Accept: application/rdf+xml; q=1.0, text/rdf+n3; q=0.9, application/rdf+turtle; q=0.7, application/x-turtle; q=0.6, application/turtle; q=0.5, application/xml; q=0.2, */*; q=0.1\';\n"
"\n"
"\n"
"{\n"
"declare mtd, new_origin_uri_save varchar;\n"
"declare exit handler for sqlstate \'*\' {\n"
"\n"
"delete from DB.DBA.SYS_HTTP_SPONGE where HS_LOCAL_IRI = local_iri and HS_PARSER = parser;\n"
"commit work;\n"
"resignal;\n"
"};\n"
"new_origin_uri_save := new_origin_uri;\n"
"if (get_method = \'GET+MGET\')\n"
"mtd := \'GET\';\n"
"else\n"
"mtd := get_method;\n"
"ret_body := DB.DBA.RDF_HTTP_URL_GET (new_origin_uri, \'\', ret_hdr, mtd, req_hdr, NULL, get_proxy, 0);\n"
"if (new_origin_uri <> new_origin_uri_save)\n"
"{\n"
"declare pos int;\n"
"pos := position (\'http-redirect-to\', options);\n"
"if (pos > 0)\n"
"options[pos-1] := new_origin_uri;\n"
"else\n"
"options := vector_concat (options, vector (\'http-redirect-to\', new_origin_uri));\n"
"}\n"
"new_origin_uri := new_origin_uri_save;\n"
"}\n"
"\n"
"if (ret_hdr[0] like \'HTTP%404%\')\n"
"{\n"
"delete from DB.DBA.SYS_HTTP_SPONGE where HS_LOCAL_IRI = local_iri and HS_PARSER = parser;\n"
"commit work;\n"
"signal (\'HT404\', sprintf (\'Resource \"%.1000s\" not found\', new_origin_uri));\n"
"}\n"
"if (ret_hdr[0] like \'HTTP%304%\')\n"
"{\n"
"ret_304_not_modified := 1;\n"
"goto resp_received;\n"
"}\n"
"goto resp_received;\n"
"}\n"
"if (eraser is not null)\n"
"call (eraser) (local_iri, new_origin_uri, options);\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'Unable to get data from \"%.1000s\": This version of Virtuoso does not support OPTION (get:method \"%.100s\")\',\n"
"new_origin_uri, get_method ) );\n"
"\n"
"resp_received:\n"
"\n"
"DB.DBA.SYS_HTTP_SPONGE_GET_CACHE_PARAMS (explicit_refresh, old_last_modified, ret_hdr, new_expiration,\n"
"ret_content_type, ret_etag, ret_date, ret_expires, ret_last_modif,\n"
"ret_dt_date, ret_dt_expires, ret_dt_last_modified);\n"
"\n"
"if (ret_304_not_modified)\n"
"{\n"
"update DB.DBA.SYS_HTTP_SPONGE\n"
"set HS_LAST_LOAD = now(), HS_LAST_ETAG = old_last_etag, HS_LAST_READ = now(),\n"
"HS_EXP_IS_TRUE = case (isnull (ret_dt_expires)) when 1 then 0 else 1 end,\n"
"HS_EXPIRATION = coalesce (ret_dt_expires, new_expiration, now()),\n"
"HS_LAST_MODIFIED = coalesce (old_last_modified, ret_dt_last_modified),\n"
"HS_DOWNLOAD_SIZE = old_download_size,\n"
"HS_DOWNLOAD_MSEC_TIME = old_download_msec_time,\n"
"HS_READ_COUNT = old_read_count + 1,\n"
"HS_SQL_STATE = NULL, HS_SQL_MESSAGE = NULL\n"
"where\n"
"HS_LOCAL_IRI = local_iri;\n"
"commit work;\n"
"return local_iri;\n"
"}\n"
"if (ret_body is null)\n"
"{\n"
"rollback work;\n"
"update DB.DBA.SYS_HTTP_SPONGE\n"
"set HS_SQL_STATE = \'RDFXX\',\n"
"HS_SQL_MESSAGE = sprintf (\'Unable to retrieve RDF data from \"%.500s\": %.500s\', new_origin_uri, ret_hdr[0]),\n"
"HS_EXPIRATION = now (),\n"
"HS_EXP_IS_TRUE = 0\n"
"where\n"
"HS_LOCAL_IRI = local_iri and HS_PARSER = parser;\n"
"commit work;\n"
"signal (\'RDFXX\', sprintf (\'Unable to retrieve RDF data from \"%.500s\": %.500s\', new_origin_uri, ret_hdr[0]));\n"
"}\n"
"\n"
"new_download_size := length (ret_body);\n"
"\n"
"\n"
"\n"
"\n"
"{\n"
"whenever sqlstate \'*\' goto error_during_load;\n"
"parser_rc := 0;\n"
"req_hdr_arr := DB.DBA.RDF_HTTP_MAKE_HTTP_REQ (new_origin_uri, get_method, req_hdr);\n"
"if (eraser is not null)\n"
"call (eraser) (local_iri, new_origin_uri, options);\n"
"parser_rc := call (parser) (local_iri, new_origin_uri, ret_content_type, ret_hdr, ret_body, options, req_hdr_arr);\n"
"\n"
"if (parser_rc is not null)\n"
"{\n"
"new_last_etag := ret_etag;\n"
"if (__tag (parser_rc) = 193 and eraser is not null and ret_content_type like \'%html\')\n"
"{\n"
"declare sa any;\n"
"sa := get_keyword (\'seeAlso\', parser_rc);\n"
"foreach (varchar dep in sa) do\n"
"{\n"
"DB.DBA.SYS_HTTP_SPONGE_UP (local_iri, dep, parser, NULL, options);\n"
"}\n"
"}\n"
"}\n"
"else\n"
"new_last_etag := null;\n"
"\n"
"load_end_msec := msec_time();\n"
"if (new_expiration is null)\n"
"new_expiration := dateadd (\'second\', load_end_msec - load_begin_msec, now());\n"
"if (ret_dt_expires is null and explicit_refresh is not null)\n"
"new_expiration := __min (new_expiration, dateadd (\'second\', 0.7 * explicit_refresh, now()));\n"
"commit work;\n"
"update DB.DBA.SYS_HTTP_SPONGE\n"
"set HS_LAST_LOAD = now(), HS_LAST_ETAG = new_last_etag, HS_LAST_READ = now(),\n"
"HS_EXP_IS_TRUE = case (isnull (ret_dt_expires)) when 1 then 0 else 1 end,\n"
"HS_EXPIRATION = coalesce (ret_dt_expires, new_expiration, now()),\n"
"HS_LAST_MODIFIED = ret_dt_last_modified,\n"
"HS_DOWNLOAD_SIZE = new_download_size,\n"
"HS_DOWNLOAD_MSEC_TIME = load_end_msec - load_begin_msec,\n"
"HS_READ_COUNT = 1,\n"
"HS_SQL_STATE = NULL, HS_SQL_MESSAGE = NULL\n"
"where\n"
"HS_LOCAL_IRI = local_iri and HS_PARSER = parser;\n"
"commit work;\n"
"return local_iri;\n"
"}\n"
"\n"
"error_during_load:\n"
"rollback work;\n"
"\n"
"\n"
"load_end_msec := msec_time();\n"
"if (new_expiration is null)\n"
"new_expiration := dateadd (\'second\', load_end_msec - load_begin_msec, now());\n"
"if (ret_dt_expires is null and explicit_refresh is not null)\n"
"new_expiration := __min (new_expiration, dateadd (\'second\', 0.7 * explicit_refresh, now()));\n"
"\n"
"update DB.DBA.SYS_HTTP_SPONGE\n"
"set HS_SQL_STATE = __SQL_STATE,\n"
"HS_SQL_MESSAGE = __SQL_MESSAGE,\n"
"HS_EXPIRATION = coalesce (ret_dt_expires, new_expiration, now()),\n"
"HS_EXP_IS_TRUE = case (isnull (ret_dt_expires)) when 1 then 0 else 1 end\n"
"where\n"
"HS_LOCAL_IRI = local_iri and HS_PARSER = parser;\n"
"commit work;\n"
"return local_iri;\n"
"}\n"
"--src rdf_sponge.sql:552\n";

static const char *proc357 = 
"create function DB.DBA.SYS_FILE_SPONGE_UP (in local_iri varchar, in get_uri varchar, in parser varchar, in eraser varchar, in options any)\n"
"{\n"
"declare new_origin_uri, str, base_uri, mime_type, dummy, tmp any;\n"
"declare inx int;\n"
"new_origin_uri := cast (get_keyword_ucase (\'get:uri\', options, get_uri) as varchar);\n"
"inx := 5;\n"
"base_uri := local_iri;\n"
"base_uri := charset_recode (base_uri, \'UTF-8\', NULL);\n"
"while (length (base_uri) > inx + 1 and aref (base_uri, inx) = ascii (\'/\'))\n"
"inx := inx + 1;\n"
"str := file_to_string (concat (http_root(), \'/\' , subseq (base_uri, inx)));\n"
"dummy := vector ();\n"
"tmp := vector (\'OK\');\n"
"mime_type := null;\n"
"if (eraser is not null)\n"
"call (eraser) (local_iri, new_origin_uri, options);\n"
"DB.DBA.RDF_LOAD_HTTP_RESPONSE (local_iri, new_origin_uri, mime_type, tmp, str, options, dummy);\n"
"return local_iri;\n"
"}\n"
"--src rdf_sponge.sql:843\n";

static const char *proc358 = 
"create function DB.DBA.RDF_SPONGE_GUESS_CONTENT_TYPE (in origin_uri varchar, in ret_content_type varchar, inout ret_body any) returns varchar\n"
"{\n"
"if (ret_content_type is not null)\n"
"{\n"
"if (strstr (ret_content_type, \'application/sparql-results+xml\') is not null)\n"
"return \'application/sparql-results+xml\';\n"
"if (strstr (ret_content_type, \'application/rdf+xml\') is not null)\n"
"return \'application/rdf+xml\';\n"
"if (\n"
"strstr (ret_content_type, \'text/rdf+n3\') is not null or\n"
"strstr (ret_content_type, \'text/rdf+ttl\') is not null or\n"
"strstr (ret_content_type, \'text/rdf+turtle\') is not null or\n"
"strstr (ret_content_type, \'text/turtle\') is not null or\n"
"strstr (ret_content_type, \'application/x-turtle\') is not null or\n"
"strstr (ret_content_type, \'application/turtle\') is not null )\n"
"return \'text/rdf+n3\';\n"
"}\n"
"declare ret_begin, ret_html any;\n"
"ret_begin := subseq (ret_body, 0, 1024);\n"
"ret_html := xtree_doc (ret_begin, 2);\n"
"if (xpath_eval (\'/html|/xhtml\', ret_html) is not null)\n"
"return \'text/html\';\n"
"if (xpath_eval (\'[xmlns:rset=\"http://www.w3.org/2005/sparql-results#\"] /rset:sparql\', ret_html) is not null\n"
"or xpath_eval (\'[xmlns:rset2=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2\"] /rset2:sparql\', ret_html) is not null)\n"
"return \'application/sparql-results+xml\';\n"
"if (xpath_eval (\'[xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"] /rdf:rdf\', ret_html) is not null)\n"
"return \'application/rdf+xml\';\n"
"if (strstr (ret_begin, \'<html>\') is not null or\n"
"strstr (ret_begin, \'<xhtml>\') is not null )\n"
"return \'text/html\';\n"
"if (ret_content_type is null or\n"
"strstr (ret_content_type, \'text/plain\') is not null or\n"
"strstr (ret_content_type, \'application/octet-stream\') is not null )\n"
"{\n"
"declare ret_lines any;\n"
"declare ret_lcount, ret_lctr integer;\n"
"ret_lines := split_and_decode (ret_begin, 0, \'\\0\\t\\n\');\n"
"ret_lcount := length (ret_lines);\n"
"for (ret_lctr := 0; ret_lctr < ret_lcount; ret_lctr := ret_lctr + 1)\n"
"{\n"
"declare l varchar;\n"
"l := rtrim (replace (ret_lines [ret_lctr], \'\\r\', \'\'));\n"
"\n"
"if ((\"LEFT\" (l, 7) = \'@prefix\') or (\"LEFT\" (l, 5) = \'@base\') or (\"LEFT\" (l, 8) = \'@keyword\'))\n"
"return \'text/rdf+n3\';\n"
"if (((\"LEFT\" (l, 1) = \'<\') or (\"LEFT\" (l, 1) = \'[\')) and (\"RIGHT\" (origin_uri, 4) in (\'.ttl\', \'.TTL\', \'.n3\', \'.N3\')))\n"
"return \'text/rdf+n3\';\n"
"if (not ((l like \'#%\') or (l=\'\')))\n"
"return \'text/plain\';\n"
"}\n"
"}\n"
"return ret_content_type;\n"
"}\n"
"--src rdf_sponge.sql:865\n";

static const char *tbl19 = 
"create table DB.DBA.SYS_RDF_MAPPERS (\n"
"RM_ID integer identity,\n"
"RM_PATTERN varchar,\n"
"RM_TYPE varchar default \'MIME\',\n"
"RM_HOOK varchar,\n"
"RM_KEY  long varchar,\n"
"RM_DESCRIPTION long varchar,\n"
"RM_ENABLED integer default 1,\n"
"RM_OPTIONS any,\n"
"RM_PID integer identity,\n"
"primary key (RM_HOOK))\n"
"alter index SYS_RDF_MAPPERS on DB.DBA.SYS_RDF_MAPPERS partition cluster replicated\n"
"create index SYS_RDF_MAPPERS_I1 on DB.DBA.SYS_RDF_MAPPERS (RM_ID) partition cluster replicated\n"
"create index SYS_RDF_MAPPERS_I2 on DB.DBA.SYS_RDF_MAPPERS (RM_PID) partition cluster replicated\n";

static const char *proc359 = 
"create procedure DB.DBA.RDF_HTTP_URL_GET (inout url any, in base any, inout hdr any,\n"
"in meth any := \'GET\', in req_hdr varchar := null, in cnt any := null, in proxy any := null, in sig int := 1)\n"
"{\n"
"declare content varchar;\n"
"declare olduri varchar;\n"
"\n"
"declare redirects, is_https int;\n"
"\n"
"\n"
"hdr := null;\n"
"redirects := 15;\n"
"url := WS.WS.EXPAND_URL (base, url);\n"
"again:\n"
"olduri := url;\n"
"if (redirects <= 0)\n"
"signal (\'22023\', \'Too many HTTP redirects\', \'RDFXX\');\n"
"\n"
"if (lower (url) like \'https://%\' and proxy is not null)\n"
"signal (\'22023\', \'The HTTPS retrieval is not supported via proxy\', \'RDFXX\');\n"
"is_https := 0;\n"
"if (lower (url) like \'https://%\')\n"
"is_https := 1;\n"
"\n"
"if (proxy is null)\n"
"content := http_client_ext (url=>url, headers=>hdr, http_method=>meth, http_headers=>req_hdr, body=>cnt);\n"
"else\n"
"content := http_get (url, hdr, meth, req_hdr, cnt, proxy);\n"
"redirects := redirects - 1;\n"
"\n"
"if (hdr[0] not like \'HTTP/1._ 200 %\')\n"
"{\n"
"if (hdr[0] like \'HTTP/1._ 30_ %\')\n"
"{\n"
"url := http_request_header (hdr, \'Location\');\n"
"if (isstring (url))\n"
"{\n"
"url := WS.WS.EXPAND_URL (olduri, url);\n"
"goto again;\n"
"}\n"
"}\n"
"if (sig)\n"
"signal (\'22023\', trim(hdr[0], \'\\r\\n\'), \'RDFXX\');\n"
"\n"
"return NULL;\n"
"}\n"
"\n"
"return content;\n"
"}\n"
"--src rdf_sponge.sql:971\n";

static const char *proc360 = 
"create procedure DB.DBA.RDF_SW_PING (in endp varchar, in url varchar)\n"
"{\n"
"declare rc any;\n"
"declare err, msg any;\n"
"declare xt any;\n"
"commit work;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"insert into DB.DBA.SYS_SPARQL_SW_LOG (PL_SERVER, PL_URI, PL_RC, PL_MSG)\n"
"values (endp, url, __SQL_STATE, __SQL_MESSAGE);\n"
"commit work;\n"
"return;\n"
"};\n"
"\n"
"err := \'\';\n"
"msg := \'n/a\';\n"
"xt := null;\n"
"if (cfg_item_value (virtuoso_ini_path (), \'SPARQL\', \'RestPingService\') = \'1\')\n"
"{\n"
"rc := http_get (endp||sprintf (\'?url=%U\', url));\n"
"xt := xtree_doc (rc);\n"
"}\n"
"else\n"
"{\n"
"rc := DB.DBA.XMLRPC_CALL (endp, \'weblogUpdates.ping\', vector (\'\', url));\n"
"if (isarray (rc))\n"
"xt := xml_tree_doc (rc);\n"
"}\n"
"if (xt is not null)\n"
"{\n"
"err := cast (xpath_eval (\'//flerror/text()\', xml_cut(xt), 1) as varchar);\n"
"msg := cast (xpath_eval (\'//message/text()\', xml_cut(xt), 1) as varchar);\n"
"}\n"
"insert into DB.DBA.SYS_SPARQL_SW_LOG (PL_SERVER, PL_URI, PL_RC, PL_MSG)\n"
"values (endp, url, err, msg);\n"
"\n"
"commit work;\n"
"return;\n"
"}\n"
"--src rdf_sponge.sql:1022\n";

static const char *proc361 = 
"create procedure DB.DBA.RDF_PROC_COLS (in pname varchar)\n"
"{\n"
"set_user_id (\'dba\', 1);\n"
"return procedure_cols (pname);\n"
"}\n"
"--src rdf_sponge.sql:1063\n";

static const char *proc362 = 
"create procedure DB.DBA.RDF_LOAD_HTTP_RESPONSE (in graph_iri varchar, in new_origin_uri varchar, inout ret_content_type varchar, inout ret_hdr any, inout ret_body any, inout options any, inout req_hdr_arr any)\n"
"{\n"
"declare dest, groupdest, cset varchar;\n"
"declare rc any;\n"
"declare aq, ps any;\n"
"declare xd, xt any;\n"
"declare saved_log_mode integer;\n"
"aq := null;\n"
"ps := cfg_item_value (virtuoso_ini_path (), \'SPARQL\', \'PingService\');\n"
"if (length (ps))\n"
"{\n"
"aq := async_queue (1);\n"
"}\n"
"\n"
"\n"
"ret_content_type := DB.DBA.RDF_SPONGE_GUESS_CONTENT_TYPE (new_origin_uri, ret_content_type, ret_body);\n"
"\n"
"dest := get_keyword_ucase (\'get:destination\', options);\n"
"groupdest := get_keyword_ucase (\'get:group-destination\', options);\n"
"if (strstr (ret_content_type, \'application/sparql-results+xml\') is not null)\n"
"signal (\'RDFXX\', sprintf (\'Unable to load RDF graph <%.500s> from <%.500s>: the sparql-results XML answer does not contain triples\', graph_iri, new_origin_uri));\n"
"if (strstr (ret_content_type, \'application/rdf+xml\') is not null)\n"
"{\n"
"\n"
"\n"
"whenever sqlstate \'*\' goto load_grddl;\n"
"log_enable (2, 1);\n"
"xt := xtree_doc (ret_body);\n"
"\n"
"if (xpath_eval (\'[ xmlns:dv=\"http://www.w3.org/2003/g/data-view#\" ] /*[1]/@dv:transformation\', xt) is not null)\n"
"goto load_grddl;\n"
"DB.DBA.RDF_LOAD_RDFXML (ret_body, new_origin_uri, coalesce (dest, graph_iri));\n"
"if (groupdest is not null)\n"
"DB.DBA.RDF_LOAD_RDFXML (ret_body, new_origin_uri, groupdest);\n"
"if (__proc_exists (\'DB.DBA.RDF_LOAD_POST_PROCESS\'))\n"
"call (\'DB.DBA.RDF_LOAD_POST_PROCESS\') (graph_iri, new_origin_uri, dest, ret_body, ret_content_type, options);\n"
"log_enable (saved_log_mode, 1);\n"
"if (aq is not null)\n"
"aq_request (aq, \'DB.DBA.RDF_SW_PING\', vector (ps, new_origin_uri));\n"
"return 1;\n"
"}\n"
"else if (\n"
"strstr (ret_content_type, \'text/rdf+n3\') is not null or\n"
"strstr (ret_content_type, \'text/rdf+ttl\') is not null or\n"
"strstr (ret_content_type, \'text/rdf+turtle\') is not null or\n"
"strstr (ret_content_type, \'text/turtle\') is not null or\n"
"strstr (ret_content_type, \'application/rdf+n3\') is not null or\n"
"strstr (ret_content_type, \'application/rdf+turtle\') is not null or\n"
"strstr (ret_content_type, \'application/turtle\') is not null or\n"
"strstr (ret_content_type, \'application/x-turtle\') is not null )\n"
"{\n"
"whenever sqlstate \'*\' goto load_grddl;\n"
"log_enable (2, 1);\n"
"\n"
"\n"
"DB.DBA.TTLP (ret_body, new_origin_uri, coalesce (dest, graph_iri));\n"
"if (groupdest is not null)\n"
"DB.DBA.TTLP (ret_body, new_origin_uri, groupdest);\n"
"if (__proc_exists (\'DB.DBA.RDF_LOAD_POST_PROCESS\'))\n"
"call (\'DB.DBA.RDF_LOAD_POST_PROCESS\') (graph_iri, new_origin_uri, dest, ret_body, ret_content_type, options);\n"
"log_enable (saved_log_mode, 1);\n"
"if (aq is not null)\n"
"aq_request (aq, \'DB.DBA.RDF_SW_PING\', vector (ps, new_origin_uri));\n"
"return 1;\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"load_grddl:;\n"
"cset := http_request_header (ret_hdr, \'Content-Type\', \'charset\', null);\n"
"for select RM_PATTERN, RM_TYPE, RM_HOOK, RM_KEY, RM_OPTIONS from DB.DBA.SYS_RDF_MAPPERS where RM_ENABLED = 1 order by RM_ID do\n"
"{\n"
"declare val_match, pcols, new_opts any;\n"
"declare npars int;\n"
"\n"
"if (RM_TYPE = \'MIME\')\n"
"{\n"
"val_match := ret_content_type;\n"
"}\n"
"else if (RM_TYPE = \'URL\' or RM_TYPE = \'HTTP\')\n"
"{\n"
"val_match := new_origin_uri;\n"
"}\n"
"else\n"
"val_match := null;\n"
"\n"
"if (registry_get (\'__sparql_mappers_debug\') = \'1\')\n"
"dbg_obj_prin1 (\'Trying \', RM_HOOK);\n"
"if (isstring (val_match) and regexp_match (RM_PATTERN, val_match) is not null)\n"
"{\n"
"if (__proc_exists (RM_HOOK) is null)\n"
"goto try_next_mapper;\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"goto try_next_mapper;\n"
"};\n"
"pcols := DB.DBA.RDF_PROC_COLS (RM_HOOK);\n"
"npars := 8;\n"
"if (isarray (pcols))\n"
"npars := length (pcols);\n"
"\n"
"if (registry_get (\'__sparql_mappers_debug\') = \'1\')\n"
"dbg_obj_prin1 (\'Match \', RM_HOOK);\n"
"new_opts := vector_concat (options, RM_OPTIONS, vector (\'content-type\', ret_content_type, \'charset\', cset));\n"
"if (RM_TYPE <> \'HTTP\')\n"
"{\n"
"if (npars = 7)\n"
"rc := call (RM_HOOK) (graph_iri, new_origin_uri, dest, ret_body, aq, ps, RM_KEY);\n"
"else\n"
"rc := call (RM_HOOK) (graph_iri, new_origin_uri, dest, ret_body, aq, ps, RM_KEY, new_opts);\n"
"}\n"
"else\n"
"{\n"
"if (npars = 7)\n"
"rc := call (RM_HOOK) (graph_iri, new_origin_uri, dest, ret_body, aq, ps, vector (req_hdr_arr, ret_hdr));\n"
"else\n"
"rc := call (RM_HOOK) (graph_iri, new_origin_uri, dest, ret_body, aq, ps, vector (req_hdr_arr, ret_hdr), new_opts);\n"
"}\n"
"if (registry_get (\'__sparql_mappers_debug\') = \'1\')\n"
"{\n"
"dbg_obj_prin1 (\'Return \', rc, RM_HOOK);\n"
"if (__tag(rc) = 193 or rc < 0 or rc > 0)\n"
"dbg_obj_prin1 (\'END of mappings\');\n"
"}\n"
"if (__tag(rc) = 193 or rc < 0 or rc > 0)\n"
"{\n"
"if (__proc_exists (\'DB.DBA.RDF_LOAD_POST_PROCESS\'))\n"
"call (\'DB.DBA.RDF_LOAD_POST_PROCESS\') (graph_iri, new_origin_uri, dest, ret_body, ret_content_type, options);\n"
"if (__tag(rc) = 193)\n"
"return rc;\n"
"return (case when rc < 0 then 0 else 1 end);\n"
"}\n"
"}\n"
"try_next_mapper:;\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (dest is null)\n"
"{\n"
"DB.DBA.SPARUL_CLEAR (graph_iri, 1, 0);\n"
"commit work;\n"
"}\n"
"if (strstr (ret_content_type, \'text/plain\') is not null)\n"
"{\n"
"signal (\'RDFXX\', sprintf (\n"
"\'Unable to load RDF graph <%.500s> from <%.500s>: returned Content-Type \'\'%.300s\'\' status \'\'%.300s\'\'\\n%.500s\',\n"
"graph_iri, new_origin_uri, ret_content_type, ret_hdr[0], subseq (ret_body, 0, 500) ) );\n"
"}\n"
"if (strstr (ret_content_type, \'text/html\') is not null)\n"
"{\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'Unable to load RDF graph <%.500s> from <%.500s>: returned Content-Type \'\'%.300s\'\' status \'\'%.300s\'\'\\n%.500s\',\n"
"graph_iri, new_origin_uri, ret_content_type, ret_hdr[0],\n"
"\n"
"subseq (ret_body, 0, 500)\n"
") );\n"
"}\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'Unable to load RDF graph <%.500s> from <%.500s>: returned unsupported Content-Type \'\'%.300s\'\'\',\n"
"graph_iri, new_origin_uri, ret_content_type ) );\n"
"resignal_parse_error:\n"
"log_enable (saved_log_mode, 1);\n"
"resignal;\n"
"}\n"
"--src rdf_sponge.sql:1071\n";

static const char *proc363 = 
"create procedure DB.DBA.RDF_FORGET_HTTP_RESPONSE (in graph_iri varchar, in new_origin_uri varchar, inout options any)\n"
"{\n"
"declare dest varchar;\n"
"dest := get_keyword_ucase (\'get:destination\', options);\n"
"if (dest is null)\n"
"DB.DBA.SPARUL_CLEAR (graph_iri, 1, 0);\n"
"}\n"
"--src rdf_sponge.sql:1250\n";

static const char *proc364 = 
"create function DB.DBA.RDF_SPONGE_UP (in graph_iri varchar, in options any, in uid integer := -1)\n"
"{\n"
"declare aq, cookie varchar;\n"
"declare dest, local_iri varchar;\n"
"\n"
"if (cfg_item_value (virtuoso_ini_path (), \'SPARQL\', \'AsyncQueue\') = \'0\')\n"
"{\n"
"return DB.DBA.RDF_SPONGE_UP_1 (graph_iri, options, uid);\n"
"}\n"
"commit work;\n"
"set_user_id (\'dba\', 1);\n"
"cookie := connection_get (\'__rdf_sponge_sid\');\n"
"if (cookie is not null)\n"
"options := vector_concat (options, vector (\'rdf_sponge_sid\', cookie));\n"
"if (connection_get (\'__rdf_sponge_debug\') is not null)\n"
"options := vector_concat (options, vector (\'rdf_sponge_debug\', connection_get (\'__rdf_sponge_debug\')));\n"
"if (is_http_ctx ())\n"
"options := vector_concat (options, vector (\'http_host\', http_request_header(http_request_header (), \'Host\', null, null)));\n"
"aq := async_queue (1);\n"
"aq_request (aq, \'DB.DBA.RDF_SPONGE_UP_1\', vector (graph_iri, options, uid));\n"
"commit work;\n"
"aq_wait_all (aq);\n"
"\n"
"graph_iri := cast (graph_iri as varchar);\n"
"dest := get_keyword_ucase (\'get:destination\', options);\n"
"if (dest is not null)\n"
"local_iri := \'destMD5=\' || md5(dest) || \'&graphMD5=\' || md5(graph_iri);\n"
"else\n"
"local_iri := graph_iri;\n"
"return local_iri;\n"
"}\n"
"--src rdf_sponge.sql:1259\n";

static const char *proc365 = 
"create function DB.DBA.RDF_SPONGE_UP_1 (in graph_iri varchar, in options any, in uid integer := -1)\n"
"{\n"
"declare dest, get_soft, local_iri, immg, res_graph_iri, cookie varchar;\n"
"declare perms integer;\n"
"\n"
"graph_iri := cast (graph_iri as varchar);\n"
"set_user_id (\'dba\', 1);\n"
"dest := get_keyword_ucase (\'get:destination\', options);\n"
"if (dest is not null)\n"
"local_iri := \'destMD5=\' || md5(dest) || \'&graphMD5=\' || md5(graph_iri);\n"
"else\n"
"dest := local_iri := graph_iri;\n"
"cookie := get_keyword (\'rdf_sponge_sid\', options);\n"
"if (cookie is not null)\n"
"connection_set (\'__rdf_sponge_sid\', cookie);\n"
"if (get_keyword (\'rdf_sponge_debug\', options) is not null)\n"
"connection_set (\'__rdf_sponge_debug\', get_keyword (\'rdf_sponge_debug\', options));\n"
"if (get_keyword (\'http_host\', options) is not null)\n"
"connection_set (\'__http_host\', get_keyword (\'http_host\', options));\n"
"\n"
"perms := DB.DBA.RDF_GRAPH_USER_PERMS_GET (dest, case (uid) when -1 then http_nobody_uid() else uid end);\n"
"get_soft := get_keyword_ucase (\'get:soft\', options);\n"
"if (\'soft\' = get_soft)\n"
"{\n"
"if ((dest = graph_iri) and exists (select 1 from DB.DBA.RDF_QUAD where G = iri_to_id (graph_iri, 0) ) and\n"
"not exists (select 1 from DB.DBA.SYS_HTTP_SPONGE\n"
"where HS_LOCAL_IRI = local_iri and HS_PARSER = \'DB.DBA.RDF_LOAD_HTTP_RESPONSE\' and\n"
"HS_EXPIRATION is not null))\n"
"{\n"
"\n"
"if (not bit_and (perms, 1))\n"
"{\n"
"\n"
"return null;\n"
"}\n"
"res_graph_iri := local_iri;\n"
"goto graph_is_ready;\n"
"}\n"
"\n"
"}\n"
"else\n"
"if ((\'replacing\' = get_soft) or (\'replace\' = get_soft))\n"
"{\n"
"\n"
" ;\n"
"}\n"
"else\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'This version of Virtuoso supports only \"soft\" and \"replacing\" values of \"define get:soft ...\", not \"%.500s\"\',\n"
"get_soft ) );\n"
"if (not bit_and (perms, 8))\n"
"{\n"
"\n"
"return null;\n"
"}\n"
"\n"
"\n"
"immg := cfg_item_value (virtuoso_ini_path (), \'SPARQL\', \'ImmutableGraphs\');\n"
"if (immg is not null)\n"
"{\n"
"immg := split_and_decode (immg, 0, \'\\0\\0,\');\n"
"foreach (any imm in immg) do\n"
"{\n"
"imm := trim (imm);\n"
"if (imm = dest)\n"
"{\n"
"res_graph_iri := dest;\n"
"\n"
"goto graph_is_ready;\n"
"}\n"
"}\n"
"}\n"
"\n"
"if (lower (graph_iri) like \'file:%\')\n"
"{\n"
"res_graph_iri := DB.DBA.SYS_FILE_SPONGE_UP (local_iri, graph_iri, null, \'DB.DBA.RDF_FORGET_HTTP_RESPONSE\', options);\n"
"goto graph_is_ready;\n"
"}\n"
"else if (lower (graph_iri) like \'http:%\' or lower (graph_iri) like \'https:%\')\n"
"{\n"
"res_graph_iri := DB.DBA.SYS_HTTP_SPONGE_UP (local_iri, graph_iri, \'DB.DBA.RDF_LOAD_HTTP_RESPONSE\', \'DB.DBA.RDF_FORGET_HTTP_RESPONSE\', options);\n"
"goto graph_is_ready;\n"
"}\n"
"else\n"
"{\n"
"declare sch any;\n"
"sch := rfc1808_parse_uri (graph_iri);\n"
"sch := upper (sch[0]);\n"
"\n"
"if (__proc_exists (\'DB.DBA.SYS_\'||sch||\'_SPONGE_UP\') is not null)\n"
"{\n"
"res_graph_iri := call (\'DB.DBA.SYS_\'||sch||\'_SPONGE_UP\') (local_iri, graph_iri, options);\n"
"goto graph_is_ready;\n"
"}\n"
"else\n"
"{\n"
"\n"
"return null;\n"
"}\n"
"}\n"
"graph_is_ready:\n"
"\n"
"if (__rdf_obj_ft_rule_check (iri_to_id (res_graph_iri), null) and\n"
"get_keyword (\'refresh_free_text\', options, 0) )\n"
"VT_INC_INDEX_DB_DBA_RDF_OBJ();\n"
"return res_graph_iri;\n"
"}\n"
"--src rdf_sponge.sql:1292\n";

static const char *proc366 = 
"create function DB.DBA.RDF_SPONGE_UP_LIST (in sources any)\n"
"{\n"
"declare need_reindex integer;\n"
"declare aq any;\n"
"need_reindex := 0;\n"
"aq := async_queue (8);\n"
"foreach (any src in sources) do\n"
"{\n"
"declare res_graph_iri any;\n"
"res_graph_iri := DB.DBA.RDF_SPONGE_UP (src[0], vector_concat (vector (\'refresh_free_text\', 0), src[1]));\n"
"if (__rdf_obj_ft_rule_check (iri_to_id (res_graph_iri), null) and\n"
"get_keyword (\'refresh_free_text\', src[1], 0) )\n"
"need_reindex := 1;\n"
"}\n"
"if (need_reindex)\n"
"VT_INC_INDEX_DB_DBA_RDF_OBJ();\n"
"return 1;\n"
"}\n"
"--src rdf_sponge.sql:1401\n";

static const char *proc367 = 
"create procedure DB.DBA.RDF_GRANT_SPONGE ()\n"
"{\n"
"declare state, msg varchar;\n"
"declare cmds any;\n"
"cmds := vector (\n"
"\'create role SPARQL_SPONGE\',\n"
"\'grant SPARQL_SELECT to SPARQL_SPONGE\',\n"
"\'grant SPARQL_SPONGE to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_GRAB_SINGLE to SPARQL_SPONGE\',\n"
"\'grant execute on DB.DBA.RDF_GRAB_SINGLE_ASYNC to SPARQL_SPONGE\',\n"
"\'grant execute on DB.DBA.RDF_GRAB_SEEALSO to SPARQL_SPONGE\',\n"
"\'grant execute on DB.DBA.RDF_GRAB to SPARQL_SPONGE\',\n"
"\'grant execute on DB.DBA.SPARQL_EVAL_TO_ARRAY to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_EVAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_SPONGE_UP to SPARQL_SPONGE\',\n"
"\'grant execute on DB.DBA.RDF_SPONGE_UP_1 to SPARQL_SPONGE\',\n"
"\'grant execute on DB.DBA.RDF_SPONGE_UP_LIST to SPARQL_SPONGE\' );\n"
"foreach (varchar cmd in cmds) do\n"
"{\n"
"exec (cmd, state, msg);\n"
"}\n"
"}\n"
"--src rdf_sponge.sql:1422\n";


static const char *other40 = 
" DB.DBA.RDF_GRANT_SPONGE ()\n";
/* rdf_schema_objects.sql */

static const char *proc368 = 
"create procedure rdf_view_tbl_opts (in tbls any, in cols any)\n"
"{\n"
"declare res any;\n"
"declare inx, len int;\n"
"len := length (tbls);\n"
"if (not isarray (cols) or length (cols) <> len)\n"
"cols := make_array (len, \'any\');\n"
"res := make_array (len * 2, \'any\');\n"
"inx := 0;\n"
"foreach (varchar t in tbls) do\n"
"{\n"
"declare col_cnt int;\n"
"col_cnt := (select count(*) from TABLE_COLS where \"TABLE\" = t);\n"
"res [inx * 2] := t;\n"
"if (isarray (cols[inx]) and length (cols[inx]) = 2 and isarray (cols[inx][1]) and length (cols[inx][1]) = col_cnt)\n"
"res [(inx * 2) + 1] := cols [inx];\n"
"else\n"
"{\n"
"declare newcols, i any;\n"
"newcols := make_array (col_cnt, \'any\');\n"
"i := 0;\n"
"for select \"COLUMN\", COL_DTP from TABLE_COLS where \"TABLE\" = t order by COL_ID do\n"
"{\n"
"if (COL_DTP <> 131)\n"
"newcols [i] := vector (0, null);\n"
"else\n"
"newcols [i] := vector (\'application/octet-stream\', null);\n"
"i := i + 1;\n"
"}\n"
"res [(inx * 2) + 1] := vector (null, newcols);\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"return res;\n"
"}\n"
"--src rdf_schema_objects.sql:30\n";

static const char *proc369 = 
"create procedure rdf_view_tbl_pk_cols (inout tbls any, out pkcols any)\n"
"{\n"
"declare i, l, mixed int;\n"
"i := 0;\n"
"mixed := 0;\n"
"l := length (tbls);\n"
"if (mod (l, 2) = 0)\n"
"{\n"
"for (i := 0; i < l; i := i + 2)\n"
"{\n"
"if (__tag (tbls[i+1]) = 193)\n"
"mixed := 1;\n"
"}\n"
"}\n"
"if (mixed)\n"
"{\n"
"declare newtb any;\n"
"newtb := make_array (l/2, \'any\');\n"
"pkcols := make_array (l, \'any\');\n"
"for (i := 0; i < l; i := i + 2)\n"
"{\n"
"declare cols any;\n"
"declare j int;\n"
"newtb[i/2] := tbls[i];\n"
"cols := make_array (length (tbls [i + 1]), \'any\');\n"
"j := 0;\n"
"foreach (varchar c in tbls [i + 1]) do\n"
"{\n"
"cols[j] := (select vector (sc.\"COLUMN\", sc.\"COL_DTP\", sc.\"COL_SCALE\", sc.\"COL_PREC\")\n"
"from DB.DBA.TABLE_COLS sc where upper (sc.\"COLUMN\") = upper (c) and upper (\"TABLE\") = upper (tbls[i]));\n"
"if (length (cols[j]) = 0)\n"
"signal (\'22023\', sprintf (\'Non existing column %s for table %s\', c, tbls[i]));\n"
"j := j + 1;\n"
"}\n"
"pkcols[i] := tbls[i];\n"
"pkcols[i+1] := cols;\n"
"}\n"
"tbls := newtb;\n"
"}\n"
"else\n"
"{\n"
"pkcols := make_array (l*2, \'any\');\n"
"for (i := 0; i < l; i := i + 1)\n"
"{\n"
"pkcols[i*2] := tbls[i];\n"
"pkcols[(i*2)+1] := rdf_view_get_primary_key (tbls[i]);\n"
"}\n"
"}\n"
"foreach (varchar t in tbls) do\n"
"{\n"
"if (not exists (select 1 from SYS_KEYS where KEY_TABLE = t))\n"
"signal (\'22023\', sprintf (\'Non existing table %s\', t));\n"
"}\n"
"}\n"
"--src rdf_schema_objects.sql:67\n";

static const char *proc370 = 
"create procedure rdf_view_ns_get (in cols any, in f int)\n"
"{\n"
"declare ses, dict, nss any;\n"
"declare i int;\n"
"ses := string_output ();\n"
"dict := dict_new ();\n"
"for (i := 0; i < length (cols); i := i + 2)\n"
"rdf_view_ns_get_1 (cols[i+1], dict);\n"
"nss := dict_to_vector (dict, 1);\n"
"for (declare i int, i := 0; i < length (nss); i := i + 2)\n"
"{\n"
"if (nss [i] not in (\'rdf\', \'rdfs\', \'scovo\', \'sioc\', \'aowl\', \'xsd\', \'virtrdf\'))\n"
"{\n"
"if (f)\n"
"http (sprintf (\'@prefix %s: <%s> . \\n\', nss[i], nss[i+1]), ses);\n"
"else\n"
"http (sprintf (\'prefix %s: <%s>  \\n\', nss[i], nss[i+1]), ses);\n"
"}\n"
"}\n"
"return string_output_string (ses);\n"
"}\n"
"--src rdf_schema_objects.sql:123\n";

static const char *proc371 = 
"create procedure rdf_view_ns_get_1 (in cols any, inout dict any)\n"
"{\n"
"declare class any;\n"
"declare ns, uri any;\n"
"\n"
"\n"
"class := cols[0];\n"
"cols := cols[1];\n"
"ns := rdf_view_get_ns (class, uri);\n"
"if (length (ns))\n"
"dict_put (dict, ns, uri);\n"
"foreach (any p in cols) do\n"
"{\n"
"ns := null;\n"
"\n"
"if (length (p[1]))\n"
"ns := rdf_view_get_ns (p[1], uri);\n"
"if (length (ns))\n"
"dict_put (dict, ns, uri);\n"
"}\n"
"}\n"
"--src rdf_schema_objects.sql:146\n";

static const char *proc372 = 
"create procedure\n"
"RDF_VIEW_DROP_STMT (in qualifier varchar)\n"
"{\n"
"declare drop_map any;\n"
"declare  mask varchar;\n"
"\n"
"drop_map := \'\';\n"
"mask := sprintf (\'http://%s/schemas/%s/qm-%%\', cfg_item_value(virtuoso_ini_path(), \'URIQA\',\'DefaultHost\'), qualifier);\n"
"for select \"o\" from (sparql define input:storage \"\"\n"
"select ?o from virtrdf:\n"
"{\n"
"virtrdf:DefaultQuadStorage-UserMaps ?p ?o .\n"
"filter ( ?p != rdf:type && ?o like ?:mask)\n"
"}) x do\n"
"{\n"
"drop_map := drop_map || sprintf (\'SPARQL drop silent quad map <%s> .;\\n\', \"o\");\n"
"}\n"
"return drop_map;\n"
"}\n"
"--src rdf_schema_objects.sql:169\n";

static const char *proc373 = 
"create procedure\n"
"RDF_VIEW_FROM_TBL (in qualifier varchar, in _tbls any, in gen_stat int := 0, in cols any := null)\n"
"{\n"
"declare create_count_count, create_class_stmt, create_view_stmt, sparql_pref, ns, sns, uriqa_str, ret, drop_map any;\n"
"declare total_select, total_tb, total, qual, pkcols any;\n"
"declare vname, mask varchar;\n"
"\n"
"ret := make_array (2, \'any\');\n"
"rdf_view_tbl_pk_cols (_tbls, pkcols);\n"
"cols := rdf_view_tbl_opts (_tbls, cols);\n"
"sparql_pref := \'SPARQL\\n\';\n"
"uriqa_str := \'^{URIQADefaultHost}^\';\n"
"sns := ns := sprintf (\'prefix %s: <http://%s/schemas/%s/> \\n\', qualifier, cfg_item_value(virtuoso_ini_path(), \'URIQA\',\'DefaultHost\'), qualifier);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (gen_stat)\n"
"{\n"
"ns := ns || sprintf (\'prefix %s-stat: <http://%s/%s/stat#> \\n\', lcase (qualifier), cfg_item_value(virtuoso_ini_path(), \'URIQA\',\'DefaultHost\'),\n"
"qualifier);\n"
"ns := ns || \'prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \\n\';\n"
"ns := ns || \'prefix void: <http://rdfs.org/ns/void#> \\n\';\n"
"ns := ns || \'prefix scovo: <http://purl.org/NET/scovo#> \\n\';\n"
"}\n"
"\n"
"ns := ns || \'prefix aowl: <http://bblfish.net/work/atom-owl/2006-06-06/> \\n\';\n"
"ns := ns || rdf_view_ns_get (cols, 0);\n"
"create_class_stmt := \'\';\n"
"\n"
"for (declare xx any, xx := 0; xx < length (_tbls) ; xx := xx + 1)\n"
"create_class_stmt := create_class_stmt || rdf_view_create_class (sparql_pref || sns, _tbls[xx], uriqa_str, qualifier, cols, pkcols);\n"
"\n"
"\n"
"create_count_count := \'\';\n"
"total_select := \'\';\n"
"total_tb := \'\';\n"
"for (declare xx any, xx := 0; gen_stat and xx < length (_tbls) ; xx := xx + 1)\n"
"{\n"
"vname := _tbls[xx]||\'Count\';\n"
"total_select := total_select || sprintf (\'(cnt%d*cnt%d)+\', xx*2, (xx*2)+1);\n"
"total_tb := total_tb ||\n"
"sprintf (\'\\n (select count(*) cnt%d from \"%I\".\"%I\".\"%I\") tb%d, \\n (select count(*)+1 as cnt%d from DB.DBA.TABLE_COLS where \"TABLE\" = \'\'%S\'\') tb%d,\',\n"
"xx*2, name_part (_tbls[xx], 0), name_part (_tbls[xx], 1), name_part (_tbls[xx], 2), xx*2, (xx*2)+1, _tbls[xx], (xx*2)+1);\n"
"if (not exists (select 1 from SYS_VIEWS where V_NAME = vname))\n"
"{\n"
"create_count_count := create_count_count || sprintf (\'create view \"%I\".\"%I\".\"%ICount\" as select count (*) as cnt from \"%I\".\"%I\".\"%I\"; \\n\',\n"
"name_part (_tbls[xx], 0),\n"
"name_part (_tbls[xx], 1),\n"
"name_part (_tbls[xx], 2),\n"
"name_part (_tbls[xx], 0),\n"
"name_part (_tbls[xx], 1),\n"
"name_part (_tbls[xx], 2));\n"
"create_count_count := create_count_count || sprintf (\'grant select on \"%I\".\"%I\".\"%ICount\" to SPARQL_SELECT; \\n\',\n"
"name_part (_tbls[xx], 0),\n"
"name_part (_tbls[xx], 1),\n"
"name_part (_tbls[xx], 2));\n"
"}\n"
"}\n"
"\n"
"if (gen_stat and length (_tbls))\n"
"{\n"
"declare own any;\n"
"own := name_part (_tbls[0], 1);\n"
"qual := name_part (_tbls[0], 0);\n"
"vname := qual||\'.\'||own||\'.\'||qualifier||\'__Total\';\n"
"total_select := rtrim (total_select, \'+\') || \' AS cnt\';\n"
"total_tb := rtrim (total_tb, \',\');\n"
"total := sprintf (\'drop view \"%I\".\"%I\".\"%I__Total\"; \\n\', qual, own, qualifier);\n"
"\n"
"total := total || sprintf (\'create view \"%I\".\"%I\".\"%I__Total\" as select \' || total_select || \' from \' || total_tb || \'\\n\',\n"
"qual, own, qualifier);\n"
"create_count_count := create_count_count || total || \'; \\n\';\n"
"create_count_count := create_count_count || sprintf (\'grant select on \"%I\".\"%I\".\"%I__Total\" to SPARQL_SELECT; \\n\',\n"
"qual, own, qualifier);\n"
"\n"
"}\n"
"\n"
"if (create_count_count <> \'\')\n"
"create_count_count := create_count_count || \'\\n\\n\';\n"
"\n"
"create_view_stmt := \'\';\n"
"for (declare inx int, inx := 0; inx < length (_tbls) ; inx := inx + 1)\n"
"create_view_stmt := create_view_stmt || sparql_pref || ns || rdf_view_create_view (inx, qualifier, _tbls, gen_stat, cols, pkcols) || \'\\n;\\n\\n\';\n"
"\n"
"if (gen_stat)\n"
"create_view_stmt := create_view_stmt || sparql_pref || ns || rdf_view_create_void_view (qualifier, _tbls, gen_stat, cols, pkcols) || \'\\n;\\n\\n\';\n"
"\n"
"return create_class_stmt || \'\\n\\n\' || create_count_count || create_view_stmt;\n"
"}\n"
"--src rdf_schema_objects.sql:190\n";

static const char *proc374 = 
"create procedure\n"
"rdf_view_sp (in i int)\n"
"{\n"
"return repeat (\' \', i);\n"
"}\n"
"--src rdf_schema_objects.sql:285\n";

static const char *proc375 = 
"create procedure rdf_view_sql_tb (in tb varchar)\n"
"{\n"
"declare q, o, n varchar;\n"
"q := name_part (tb, 0);\n"
"o := name_part (tb, 1);\n"
"n := name_part (tb, 2);\n"
"return sprintf (\'\"%I\".\"%I\".\"%I\"\', q, o, n);\n"
"}\n"
"--src rdf_schema_objects.sql:292\n";

static const char *proc376 = 
"create procedure rdf_view_tb (in tb varchar)\n"
"{\n"
"declare r varchar;\n"
"r := DB.DBA.SYS_ALFANUM_NAME (tb);\n"
"r := lower (r);\n"
"return r;\n"
"}\n"
"--src rdf_schema_objects.sql:302\n";

static const char *proc377 = 
"create procedure rdf_view_sql_col (in col varchar)\n"
"{\n"
"return sprintf (\'\"%I\"\', col);\n"
"}\n"
"--src rdf_schema_objects.sql:311\n";

static const char *proc378 = 
"create procedure rdf_view_col (in col varchar)\n"
"{\n"
"declare r varchar;\n"
"r := DB.DBA.SYS_ALFANUM_NAME (col);\n"
"r := lower (r);\n"
"return r;\n"
"}\n"
"--src rdf_schema_objects.sql:317\n";

static const char *proc379 = 
"create procedure rdf_view_cls_name (in nam varchar)\n"
"{\n"
"\n"
"return SYS_ALFANUM_NAME (nam);\n"
"}\n"
"--src rdf_schema_objects.sql:326\n";

static const char *proc380 = 
"create procedure rdf_view_get_ns (in uri varchar, out uriSearch varchar)\n"
"{\n"
"declare delim integer;\n"
"declare nsPrefix varchar;\n"
"\n"
"delim := -1;\n"
"uriSearch := uri;\n"
"nsPrefix := null;\n"
"if (length (uri) = 0)\n"
"return null;\n"
"while (nsPrefix is null and delim <> 0)\n"
"{\n"
"delim := coalesce (strrchr (uriSearch, \'/\'), 0);\n"
"delim := __max (delim, coalesce (strrchr (uriSearch, \'#\'), 0));\n"
"delim := __max (delim, coalesce (strrchr (uriSearch, \':\'), 0));\n"
"nsPrefix := coalesce (__xml_get_ns_prefix (subseq (uriSearch, 0, delim + 1), 2),\n"
"__xml_get_ns_prefix (subseq (uriSearch, 0, delim),     2));\n"
"uriSearch := subseq (uriSearch, 0, delim + 1);\n"
"}\n"
"if (nsPrefix is null)\n"
"{\n"
"declare cnt int;\n"
"uriSearch := uri;\n"
"delim := -1;\n"
"delim := coalesce (strrchr (uriSearch, \'/\'), 0);\n"
"delim := __max (delim, coalesce (strrchr (uriSearch, \'#\'), 0));\n"
"delim := __max (delim, coalesce (strrchr (uriSearch, \':\'), 0));\n"
"if (delim > 0)\n"
"uriSearch := subseq (uriSearch, 0, delim + 1);\n"
"cnt := 0;\n"
"while (__xml_get_ns_uri (sprintf (\'rv%d\', cnt), 2) is not null)\n"
"{\n"
"cnt := cnt + 1;\n"
"}\n"
"nsPrefix := sprintf (\'rv%d\', cnt);\n"
"if (uri = \'\')\n"
"signal (\'.....\', \'Empty IRI is not allowed here\');\n"
"DB.DBA.XML_SET_NS_DECL (nsPrefix, uriSearch, 2);\n"
"}\n"
"return nsPrefix;\n"
"}\n"
"--src rdf_schema_objects.sql:333\n";

static const char *proc381 = 
"create procedure rdf_view_uri_curie (in uri varchar)\n"
"{\n"
"declare delim integer;\n"
"declare uriSearch, nsPrefix varchar;\n"
"\n"
"delim := -1;\n"
"uriSearch := uri;\n"
"nsPrefix := null;\n"
"while (nsPrefix is null and delim <> 0)\n"
"{\n"
"delim := coalesce (strrchr (uriSearch, \'/\'), 0);\n"
"delim := __max (delim, coalesce (strrchr (uriSearch, \'#\'), 0));\n"
"delim := __max (delim, coalesce (strrchr (uriSearch, \':\'), 0));\n"
"nsPrefix := coalesce (__xml_get_ns_prefix (subseq (uriSearch, 0, delim + 1), 2),\n"
"__xml_get_ns_prefix (subseq (uriSearch, 0, delim),     2));\n"
"uriSearch := subseq (uriSearch, 0, delim);\n"
"}\n"
"if (nsPrefix is not null)\n"
"{\n"
"declare rhs varchar;\n"
"rhs := subseq(uri, length (uriSearch) + 1, null);\n"
"if (not length (rhs))\n"
"return uri;\n"
"else\n"
"return nsPrefix || \':\' || rhs;\n"
"}\n"
"return uri;\n"
"}\n"
"--src rdf_schema_objects.sql:376\n";

static const char *proc382 = 
"create procedure rdf_view_col_type (in qual varchar, in col varchar, in opts any)\n"
"{\n"
"if (not length (opts))\n"
"return sprintf (\'%s:%s\', qual, col);\n"
"else\n"
"return rdf_view_uri_curie (opts);\n"
"}\n"
"--src rdf_schema_objects.sql:406\n";

static const char *proc383 = 
"create procedure\n"
"rdf_view_create_view (in nth int, in qualifier varchar, in _tbls any, in gen_stat int := 0, in cols any, in pkcols any)\n"
"{\n"
"declare ret, qual, qual_l, tbl_name, tbl_name_l, pks, pk_text, uriqa_str any;\n"
"declare suffix, tname, tbl, own, pref_l any;\n"
"declare cols_arr, inx, col_name, owner, owner_l any;\n"
"\n"
"ret := \'alter quad storage virtrdf:DefaultQuadStorage \\n\';\n"
"suffix := \'_s\';\n"
"uriqa_str := \'^{URIQADefaultHost}^\';\n"
"qual := name_part (_tbls[nth], 0);\n"
"own := name_part (_tbls[nth], 1);\n"
"qual_l := lcase (qual);\n"
"pref_l := lcase (qualifier);\n"
"tbl := _tbls[nth];\n"
"cols_arr := get_keyword (tbl, cols);\n"
"tbl_name := name_part (tbl, 2);\n"
"owner := name_part (tbl, 1);\n"
"tbl_name_l := rdf_view_tb (tbl_name);\n"
"owner_l := rdf_view_tb (owner);\n"
"tname := tbl_name_l || suffix;\n"
"\n"
"\n"
"ret := ret || \' from \' || rdf_view_sql_tb (tbl) || \' as \' || rdf_view_tb (name_part (tbl, 3) || suffix) || \'\\n\';\n"
"\n"
"ret := ret || rdf_view_get_relations (tbl, _tbls, suffix);\n"
"\n"
"ret := ret || sprintf (\' { \\n   create %s:qm-%s\', qualifier, tbl_name_l) ||\n"
"\' as graph iri (\"http://\' || uriqa_str || \'/\' || qualifier || \'#\") \';\n"
"\n"
"if (gen_stat = 0 and nth = (length (_tbls) - 1))\n"
"ret := ret || \'option (exclusive)\' ;\n"
"ret := ret ||\' \\n    { \\n\';\n"
"\n"
"\n"
"ret := ret || rdf_view_sp (6) || \'# Maps from columns of \"\' || tbl || \'\"\\n\';\n"
"ret := ret || rdf_view_sp (6) || rdf_view_get_pk_rel (qualifier, suffix, tbl, 0, pkcols);\n"
"ret := ret || sprintf (\' a %s:%s ;\\n\', qualifier, rdf_view_cls_name (tbl_name));\n"
"if (length (cols_arr[0]))\n"
"ret := ret || rdf_view_sp (6) || sprintf (\' a %s ;\\n\', rdf_view_uri_curie (cols_arr[0]));\n"
"\n"
"inx := 0;\n"
"for select \"COLUMN\" from TABLE_COLS where \"TABLE\" = tbl order by COL_ID do\n"
"{\n"
"col_name := lower (\"COLUMN\");\n"
"if (cols_arr[1][inx][0] = 0 or cols_arr[1][inx][0] = 4)\n"
"{\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'%s %s.%s as %s:%s-%s-%s ;\\n\',\n"
"rdf_view_col_type (qualifier, rdf_view_col(\"COLUMN\"), cols_arr[1][inx][1]),\n"
"tname, rdf_view_sql_col (\"COLUMN\"), qualifier, owner_l, tbl_name_l, rdf_view_col(\"COLUMN\") );\n"
"}\n"
"else if (isstring (cols_arr[1][inx][0]))\n"
"{\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'%s %s as %s:%s-%s-%s ;\\n\',\n"
"rdf_view_col_type (qualifier, rdf_view_col(\"COLUMN\"), cols_arr[1][inx][1]),\n"
"rdf_view_get_bin_rel (qualifier, suffix, tbl, col_name, pkcols),\n"
"qualifier, owner_l, tbl_name_l, rdf_view_col(\"COLUMN\"));\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"if (exists (select top 1 1 from SYS_FOREIGN_KEYS where PK_TABLE = tbl and 0 < position (FK_TABLE, _tbls))\n"
"or\n"
"exists (select top 1 1 from SYS_FOREIGN_KEYS where FK_TABLE = tbl and 0 < position (PK_TABLE, _tbls)))\n"
"ret := ret || rdf_view_sp (6) || \'# Maps from foreign-key relations of \"\' || tbl || \'\"\\n\';\n"
"ret := ret || rdf_view_get_fk_pk_rel (qualifier, suffix, tbl, _tbls, pkcols);\n"
"ret := ret || rdf_view_get_pk_fk_rel (qualifier, suffix, tbl, _tbls, pkcols);\n"
"\n"
"ret := trim (ret, \'\\n\');\n"
"ret := trim (ret, \';\');\n"
"ret := ret || \'.\\n\';\n"
"inx := 0;\n"
"for select \"COLUMN\" from TABLE_COLS where \"TABLE\" = tbl order by COL_ID do\n"
"{\n"
"col_name := lower (\"COLUMN\");\n"
"if (isstring (cols_arr[1][inx][0]))\n"
"{\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'%s a aowl:Content ; aowl:body %s.%s as %s:%s-%s-%s-content ; aowl:type \"%s\" .\\n\',\n"
"rdf_view_get_bin_rel (qualifier, suffix, tbl, col_name, pkcols),\n"
"tname, rdf_view_sql_col (\"COLUMN\"),\n"
"qualifier, owner_l, tbl_name_l, rdf_view_col(\"COLUMN\"), cols_arr[1][inx][0]);\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"ret := ret || \'\\n\';\n"
"\n"
"ret := ret || \'    }\\n }\\n\';\n"
"return ret;\n"
"}\n"
"--src rdf_schema_objects.sql:415\n";

static const char *proc384 = 
"create procedure\n"
"rdf_view_create_void_view (in qualifier varchar, in _tbls any, in gen_stat int := 0, in cols any, in pkcols any)\n"
"{\n"
"declare ret, qual, qual_l, tbl_name, tbl_name_l, pks, pk_text, uriqa_str any;\n"
"declare suffix, tname, tbl, own, pref_l any;\n"
"\n"
"uriqa_str := \'^{URIQADefaultHost}^\';\n"
"qual := name_part (_tbls[0], 0);\n"
"own := name_part (_tbls[0], 1);\n"
"qual_l := lcase (qual);\n"
"pref_l := lcase (qualifier);\n"
"\n"
"ret := \'alter quad storage virtrdf:DefaultQuadStorage \\n\';\n"
"suffix := \'_s\';\n"
"\n"
"for (declare xx any, xx := 0; xx < length (_tbls) ; xx := xx + 1)\n"
"{\n"
"ret := ret || \' from \' || rdf_view_sql_tb (_tbls[xx]||\'Count\') || \' as \' || rdf_view_tb (name_part (_tbls[xx]||\'Count\', 3) || suffix) || \'\\n\';\n"
"}\n"
"ret := ret || \' from \' || rdf_view_sql_tb (qual||\'.\'||own||\'.\'||qualifier||\'__Total\') || \' as \' ||\n"
"rdf_view_tb (qualifier||\'__Total\'||suffix) || \'\\n\';\n"
"\n"
"ret := ret || sprintf (\' { \\n   create %s:qm-VoidStatistics\', qualifier) ||\n"
"\' as graph iri (\"http://\' || uriqa_str || \'/\' || qualifier || \'#\") option (exclusive) \\n    { \\n\';\n"
"\n"
"ret := ret || rdf_view_sp (6) || \'# voID Statistics \\n\';\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'%s-stat: a void:Dataset as %s:dataset-%s ; \\n\', pref_l, qualifier, qual_l);\n"
"ret := ret || rdf_view_sp (6) || sprintf (\' void:sparqlEndpoint <http://%s/sparql> as %s:dataset-sparql-%s ; \\n\',\n"
"cfg_item_value(virtuoso_ini_path(), \'URIQA\',\'DefaultHost\'), qualifier, qual_l);\n"
"\n"
"ret := ret || rdf_view_sp (6) ||	sprintf (\'void:statItem %s-stat:Stat . \\n\', pref_l);\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'%s-stat:Stat a scovo:Item ; \\n\', pref_l);\n"
"ret := ret || rdf_view_sp (6) || sprintf (\' rdf:value %s.cnt as %s:stat-decl-%s ; \\n\', rdf_view_tb (qualifier||\'__Total\'||suffix), qualifier, qual_l);\n"
"ret := ret || rdf_view_sp (6) || sprintf (\' scovo:dimension void:numOfTriples . \\n\\n\');\n"
"\n"
"for (declare xx any, xx := 0; xx < length (_tbls) ; xx := xx + 1)\n"
"{\n"
"tbl := _tbls[xx];\n"
"tbl_name := name_part (tbl, 2);\n"
"tbl_name_l := rdf_view_tb (tbl_name);\n"
"tname := tbl_name_l || suffix;\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'%s-stat: void:statItem %s-stat:%sStat as %s:statitem-%s-%s . \\n\',\n"
"pref_l, pref_l, rdf_view_cls_name (tbl_name), qualifier, qual_l, tbl_name_l);\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'%s-stat:%sStat a scovo:Item as %s:statitem-decl-%s-%s ; \\n\',\n"
"pref_l, rdf_view_cls_name (tbl_name), qualifier, qual_l, tbl_name_l);\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'rdf:value %s.cnt as %s:statitem-cnt-%s-%s ; \\n\',\n"
"rdf_view_tb (tbl_name||\'Count\') || suffix, qualifier, qual_l, tbl_name_l);\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'scovo:dimention void:numberOfResources as %s:statitem-type-1-%s-%s ; \\n\',\n"
"qualifier, qual_l, tbl_name_l);\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'scovo:dimention %s:%s as %s:statitem-type-2-%s-%s .\\n\\n\',\n"
"qualifier, rdf_view_cls_name (tbl_name), qualifier, qual_l, tbl_name_l);\n"
"}\n"
"\n"
"ret := ret || \'    }\\n }\';\n"
"return ret;\n"
"}\n"
"--src rdf_schema_objects.sql:505\n";

static const char *proc385 = 
"create procedure\n"
"rdf_view_get_pk_rel (in pref varchar, in suffix varchar, inout tbl varchar, in set_tb int, in  pkcols any)\n"
"{\n"
"declare pks any;\n"
"declare tbl_name, tbl_name_l, tname, pk_text, ret varchar;\n"
"\n"
"tbl_name := name_part (tbl, 3);\n"
"tbl_name_l := lcase (tbl_name);\n"
"pks := get_keyword (tbl, pkcols);\n"
"tname := tbl_name_l || suffix;\n"
"pk_text := \'\';\n"
"\n"
"for (declare i any, i := 0; i < length (pks) ; i := i + 1)\n"
"pk_text := pk_text || rdf_view_tb (tname) || \'.\' || rdf_view_sql_col (pks[i][0]) || \',\';\n"
"pk_text := trim (pk_text, \',\');\n"
"ret := sprintf (\'%s:%s (%s) \', pref, rdf_view_tb (tbl_name_l), pk_text);\n"
"if (set_tb)\n"
"tbl := tbl_name_l;\n"
"return ret;\n"
"}\n"
"--src rdf_schema_objects.sql:563\n";

static const char *proc386 = 
"create procedure\n"
"rdf_view_get_bin_rel (in pref varchar, in suffix varchar, in tbl varchar, in col_name varchar, in pkcols any)\n"
"{\n"
"declare pks any;\n"
"declare tbl_name, tbl_name_l, tname, pk_text, ret varchar;\n"
"\n"
"tbl_name := name_part (tbl, 3);\n"
"tbl_name_l := lcase (tbl_name);\n"
"pks := get_keyword (tbl, pkcols);\n"
"tname := tbl_name_l || suffix;\n"
"pk_text := \'\';\n"
"\n"
"for (declare i any, i := 0; i < length (pks) ; i := i + 1)\n"
"pk_text := pk_text || rdf_view_tb (tname) || \'.\' || rdf_view_sql_col (pks[i][0]) || \',\';\n"
"pk_text := trim (pk_text, \',\');\n"
"ret := sprintf (\'%s:%s_%s (%s) \', pref, rdf_view_tb (tbl_name_l), col_name, pk_text);\n"
"return ret;\n"
"}\n"
"--src rdf_schema_objects.sql:585\n";

static const char *proc387 = 
"create procedure\n"
"rdf_view_get_fk_pk_rel (in pref varchar, in suffix varchar, in tbl varchar, in tbls any, in pkcols any)\n"
"{\n"
"declare ret any;\n"
"declare tbl_name, tbl_name_l, tname, pk_text varchar;\n"
"\n"
"tbl_name := name_part (tbl, 3);\n"
"tbl_name_l := rdf_view_tb (tbl_name);\n"
"tname := tbl_name_l || suffix;\n"
"\n"
"ret := string_output ();\n"
"for select distinct PK_TABLE as pkt from SYS_FOREIGN_KEYS where FK_TABLE = tbl and PK_TABLE <> tbl and 0 < position (PK_TABLE, tbls) do\n"
"{\n"
"declare fk_rel  any;\n"
"pk_text := rdf_view_get_pk_rel (pref, suffix, pkt, 1, pkcols);\n"
"fk_rel := rdf_view_sp (6) || sprintf (\'%s:has_%s %s as %s:%s_has_%s ;\\n\', pref, rdf_view_tb (pkt), pk_text, pref, tbl_name_l, rdf_view_tb (pkt));\n"
"http (fk_rel, ret);\n"
"}\n"
"return string_output_string (ret);\n"
"}\n"
"--src rdf_schema_objects.sql:605\n";

static const char *proc388 = 
"create procedure\n"
"rdf_view_get_pk_fk_rel (in pref varchar, in suffix varchar, in tbl varchar, in tbls any, in pkcols any)\n"
"{\n"
"declare ret any;\n"
"declare tbl_name, tbl_name_l, tname, pk_text varchar;\n"
"\n"
"tbl_name := name_part (tbl, 3);\n"
"tbl_name_l := rdf_view_tb (tbl_name);\n"
"tname := tbl_name_l || suffix;\n"
"\n"
"ret := string_output ();\n"
"for select distinct FK_TABLE as pkt from SYS_FOREIGN_KEYS where PK_TABLE = tbl and FK_TABLE <> tbl and 0 < position (FK_TABLE, tbls) do\n"
"{\n"
"declare fk_rel  any;\n"
"pk_text := rdf_view_get_pk_rel (pref, suffix, pkt, 1, pkcols);\n"
"fk_rel := rdf_view_sp (6) || sprintf (\'%s:%s_of %s as %s:%s_%s_of ;\\n\', pref, tbl_name_l, pk_text, pref, tbl_name_l, rdf_view_tb (pkt));\n"
"http (fk_rel, ret);\n"
"}\n"
"return string_output_string (ret);\n"
"}\n"
"--src rdf_schema_objects.sql:627\n";

static const char *proc389 = 
"create procedure\n"
"rdf_view_dv_to_printf_str_type (in _dv varchar, in sc int)\n"
"{\n"
"if (_dv = 189 or _dv = 188) return \'%d\';\n"
"else if (_dv = 247) return \'%ld\';\n"
"else if (_dv in (__tag of double precision, __tag of numeric) and sc = 0) return \'%d\';\n"
"else if (_dv = 182 or _dv = 225) return \'%U\';\n"
"else if (__tag of double precision = _dv) return \'%g\';\n"
"else if (__tag of real = _dv) return \'%f\';\n"
"else if (__tag of numeric = _dv) return \'%g\';\n"
"else if (__tag of date = _dv) return \'%1D\';\n"
"else if (__tag of time = _dv) return \'%1D\';\n"
"else if (__tag of datetime = _dv or __tag of timestamp = _dv) return \'%1D\';\n"
"signal (\'42000\', sprintf (\'The current implementation do no supports data type %s (%i) for IRI classes\', dv_type_title (_dv), _dv));\n"
"}\n"
"--src rdf_schema_objects.sql:649\n";

static const char *proc390 = 
"create procedure\n"
"rdf_view_dv_to_sql_str_type (in _dv varchar)\n"
"{\n"
"if (_dv = 189 or _dv = 188 or _dv = 247) return \'integer\';\n"
"else if (_dv = 182 or _dv = 125 or _dv = 131) return \'varchar\';\n"
"else if (__tag of double precision = _dv) return \'numeric\';\n"
"else if (__tag of real = _dv) return \'float\';\n"
"else if (__tag of numeric = _dv) return \'numeric\';\n"
"else if (__tag of date = _dv) return \'date\';\n"
"else if (__tag of time = _dv) return \'time\';\n"
"else if (__tag of datetime = _dv) return \'datetime\';\n"
"else if (__tag of timestamp = _dv) return \'timestamp\';\n"
"else if (__tag of nvarchar = _dv) return \'nvarchar\';\n"
"signal (\'42000\', sprintf (\'The current implementation do no supports data type %s (%i) for IRI classes\', dv_type_title (_dv), _dv));\n"
"}\n"
"--src rdf_schema_objects.sql:666\n";

static const char *proc391 = 
"create procedure\n"
"rdf_view_dv_to_xsd_str_type (in _dv varchar)\n"
"{\n"
"if (_dv = 189 or _dv = 188 or _dv = 247) return \'int\';\n"
"else if (_dv = 182 or _dv = 125 or _dv = 131) return \'string\';\n"
"else if (__tag of double precision = _dv) return \'numeric\';\n"
"else if (__tag of real = _dv) return \'float\';\n"
"else if (__tag of numeric = _dv) return \'numeric\';\n"
"else if (__tag of date = _dv) return \'date\';\n"
"else if (__tag of time = _dv) return \'time\';\n"
"else if (__tag of datetime = _dv) return \'dateTime\';\n"
"else if (__tag of timestamp = _dv) return \'dateTime\';\n"
"else if (__tag of nvarchar = _dv) return \'string\';\n"
"signal (\'42000\', sprintf (\'The current implementation do no supports data type %s (%i) for IRI classes\', dv_type_title (_dv), _dv));\n"
"}\n"
"--src rdf_schema_objects.sql:683\n";

static const char *proc392 = 
"create procedure\n"
"rdf_view_create_class (in decl varchar, in _tbl varchar, in _host varchar, in qualifier varchar, in cols any, in pkcols any)\n"
"{\n"
"declare ret, qual, tbl_name, tbl_name_l, pks, pk_text, sk_str any;\n"
"declare cols_arr, inx, col_name any;\n"
"\n"
"qual := name_part (_tbl, 0);\n"
"tbl_name := name_part (_tbl, 3);\n"
"tbl_name_l := rdf_view_tb (tbl_name);\n"
"pks := get_keyword (_tbl, pkcols);\n"
"pk_text := \'\';\n"
"sk_str := \'\';\n"
"\n"
"if (length (pks) = 0)\n"
"signal (\'22023\', sprintf (\'This version do not support tables without primary key, please remove table %s from set\', _tbl));\n"
"\n"
"for (declare i any, i := 0; i < length (pks) ; i := i + 1)\n"
"{\n"
"pk_text := pk_text || \'in \' || \'_\' || rdf_view_cls_name (pks[i][0]) || \' \' || rdf_view_dv_to_sql_str_type(pks[i][1]) || \' not null,\';\n"
"sk_str := sk_str || \'/\' || rdf_view_cls_name (pks[i][0]) || \'/\' || rdf_view_dv_to_printf_str_type (pks[i][1], pks[i][2]);\n"
"}\n"
"pk_text := trim (pk_text, \',\');\n"
"sk_str  := trim (sk_str , \'/\');\n"
"ret := decl || sprintf (\'create iri class %s:%s \"http://%s/%s/%s/%s#this\" (%s) . ;\\n\',\n"
"qualifier, tbl_name_l, _host, qualifier, tbl_name_l, sk_str, pk_text);\n"
"cols_arr := get_keyword (_tbl, cols);\n"
"inx := 0;\n"
"for select \"COLUMN\" as col from TABLE_COLS where \"TABLE\" = _tbl order by COL_ID do\n"
"{\n"
"if (isstring (cols_arr[1][inx][0]))\n"
"{\n"
"declare ext varchar;\n"
"col_name := lower (col);\n"
"ext := (select top 1 T_EXT from WS.WS.SYS_DAV_RES_TYPES where T_TYPE = cols_arr[1][inx][0]);\n"
"if (length (ext) > 0)\n"
"ext := \'.\' || ext;\n"
"else\n"
"ext := \'\';\n"
"ret := ret || decl || sprintf (\'create iri class %s:%s_%s \"http://%s/%s/objects/%s/%s/%s%s\" (%s) . ;\\n\',\n"
"qualifier, tbl_name_l, col_name, _host, qualifier, tbl_name_l, sk_str, col, ext, pk_text);\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"return ret;\n"
"}\n"
"--src rdf_schema_objects.sql:700\n";

static const char *proc393 = 
"create procedure\n"
"rdf_view_get_primary_key (in _tbl varchar)\n"
"{\n"
"return DB.DBA.REPL_PK_COLS (_tbl);\n"
"}\n"
"--src rdf_schema_objects.sql:747\n";

static const char *proc394 = 
"create procedure\n"
"rdf_view_get_relations (in _tbl varchar, in _tbls varchar, in _suff varchar)\n"
"{\n"
"declare ret, aliases any;\n"
"\n"
"ret := \'\';\n"
"aliases := dict_new (10);\n"
"dict_put (aliases, _tbl, 1);\n"
"foreach (any tbl in _tbls) do\n"
"for (SELECT name_part (PK_TABLE, 1) as PK_TABLE_SCHEMA,\n"
"PK_TABLE,\n"
"name_part (PK_TABLE, 2) as PK_TABLE_NAME,\n"
"PKCOLUMN_NAME as PK_COLUMN_NAME,\n"
"name_part (FK_TABLE, 1) as FK_TABLE_SCHEMA,\n"
"name_part (FK_TABLE, 2) as FK_TABLE_NAME,\n"
"FKCOLUMN_NAME AS FK_COLUMN_NAME,\n"
"KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME\n"
"FROM DB.DBA.SYS_FOREIGN_KEYS WHERE FK_TABLE = tbl and PK_TABLE <> tbl) do\n"
"\n"
"{\n"
"if (position (PK_TABLE, _tbls) <> 0 and (tbl = _tbl or PK_TABLE = _tbl))\n"
"{\n"
"declare alias any;\n"
"if (tbl = _tbl)\n"
"alias := PK_TABLE;\n"
"else\n"
"alias := tbl;\n"
"\n"
"if (dict_get (aliases, alias) is null)\n"
"{\n"
"ret := ret || \' from \' || rdf_view_sql_tb (alias) || \' as \' || rdf_view_tb (name_part (alias, 3) || _suff) || \'\\n\';\n"
"dict_put (aliases, alias, 1);\n"
"}\n"
"ret := ret || sprintf (\' where (^{%s%s.}^.\"%I\" = ^{%s%s.}^.\"%I\") \\n\',\n"
"rdf_view_tb (FK_TABLE_NAME), _suff, FK_COLUMN_NAME,\n"
"rdf_view_tb (PK_TABLE_NAME), _suff, PK_COLUMN_NAME);\n"
"}\n"
"}\n"
"return ret;\n"
"}\n"
"--src rdf_schema_objects.sql:754\n";

static const char *proc395 = 
"create procedure\n"
"RDF_OWL_FROM_TBL (in qual varchar, in _tbls any, in cols any := null)\n"
"{\n"
"declare ses, cols_arr, pkcols any;\n"
"declare ns varchar;\n"
"declare inx int;\n"
"\n"
"rdf_view_tbl_pk_cols (_tbls, pkcols);\n"
"cols := rdf_view_tbl_opts (_tbls, cols);\n"
"ns := sprintf (\'@prefix %s: <http://%s/schemas/%s/> .\\n\', qual, cfg_item_value(virtuoso_ini_path(), \'URIQA\',\'DefaultHost\'), qual);\n"
"ses := string_output ();\n"
"http (\'@prefix owl: <http://www.w3.org/2002/07/owl#> .\\n\', ses);\n"
"http (\'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\\n\', ses);\n"
"http (\'@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\\n\', ses);\n"
"http (\'@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\\n\', ses);\n"
"http (\'@prefix aowl: <http://bblfish.net/work/atom-owl/2006-06-06/> .\\n\', ses);\n"
"http (\'@prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#> .\\n\', ses);\n"
"http (ns, ses);\n"
"http (rdf_view_ns_get (cols, 1), ses);\n"
"http (sprintf (\'\\n%s: a owl:Ontology .\\n\', qual), ses);\n"
"foreach (varchar tbl in _tbls) do\n"
"{\n"
"declare cls, ltb varchar;\n"
"cls := rdf_view_cls_name (name_part (tbl, 2));\n"
"ltb := rdf_view_tb (name_part (tbl, 2));\n"
"\n"
"http (sprintf (\'\\n# %s\\n\', tbl), ses);\n"
"http (sprintf (\'%s:%s a rdfs:Class .\\n\', qual, cls), ses);\n"
"http (sprintf (\'%s:%s rdfs:isDefinedBy %s: .\\n\', qual, cls, qual), ses);\n"
"http (sprintf (\'%s:%s rdfs:label \"%s\" .\\n\', qual, cls, tbl), ses);\n"
"inx := 0;\n"
"cols_arr := get_keyword (tbl, cols);\n"
"if (length (cols_arr[0]))\n"
"http (sprintf (\'%s:%s rdfs:subClassOf %s .\\n\', qual, cls, rdf_view_uri_curie (cols_arr[0])), ses);\n"
"for select \"COLUMN\" as col, COL_DTP as dtp from TABLE_COLS where \"TABLE\" = tbl order by COL_ID do\n"
"{\n"
"declare xsd, label varchar;\n"
"label := col;\n"
"col := rdf_view_col (col);\n"
"xsd := rdf_view_dv_to_xsd_str_type (dtp);\n"
"if (cols_arr[1][inx][0] = 1 or length (cols_arr[1][inx][1]) > 0)\n"
"goto skip_this;\n"
"else if (isstring (cols_arr[1][inx][0]))\n"
"{\n"
"http (sprintf (\'%s:%s a owl:ObjectProperty .\\n\', qual, col), ses);\n"
"\n"
"\n"
"http (sprintf (\'%s:%s rdfs:range aowl:Content .\\n\', qual, col), ses);\n"
"}\n"
"else if (cols_arr[1][inx][0] = 4)\n"
"{\n"
"http (sprintf (\'%s:%s rdfs:subPropertyOf virtrdf:label . \\n\', qual, col), ses);\n"
"http (sprintf (\'%s:%s rdfs:range xsd:%s .\\n\', qual, col, xsd), ses);\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'%s:%s a owl:DatatypeProperty .\\n\', qual, col), ses);\n"
"http (sprintf (\'%s:%s rdfs:range xsd:%s .\\n\', qual, col, xsd), ses);\n"
"}\n"
"\n"
"http (sprintf (\'%s:%s rdfs:domain %s:%s .\\n\', qual, col, qual, cls), ses);\n"
"http (sprintf (\'%s:%s rdfs:isDefinedBy %s: .\\n\', qual, col, qual), ses);\n"
"http (sprintf (\'%s:%s rdfs:label \"%S\" .\\n\', qual, col, label), ses);\n"
"skip_this:\n"
"inx := inx + 1;\n"
"}\n"
"for select distinct PK_TABLE as pkt from SYS_FOREIGN_KEYS where FK_TABLE = tbl and 0 < position (PK_TABLE, _tbls) do\n"
"{\n"
"declare pkcls, lpkt varchar;\n"
"pkcls := rdf_view_cls_name (name_part (pkt, 2));\n"
"lpkt := rdf_view_tb (name_part (pkt, 2));\n"
"\n"
"http (sprintf (\'%s:has_%s a owl:ObjectProperty .\\n\', qual, lpkt), ses);\n"
"http (sprintf (\'%s:has_%s rdfs:domain %s:%s .\\n\', qual, lpkt, qual, cls), ses);\n"
"http (sprintf (\'%s:has_%s rdfs:range %s:%s .\\n\', qual, lpkt, qual, pkcls), ses);\n"
"http (sprintf (\'%s:has_%s rdfs:label \"Relation to %s\" .\\n\', qual, lpkt, pkt), ses);\n"
"http (sprintf (\'%s:has_%s rdfs:isDefinedBy %s: .\\n\', qual, lpkt, qual), ses);\n"
"}\n"
"for select distinct FK_TABLE as pkt from SYS_FOREIGN_KEYS where PK_TABLE = tbl and 0 < position (FK_TABLE, _tbls) do\n"
"{\n"
"declare pkcls varchar;\n"
"pkcls := rdf_view_cls_name (name_part (pkt, 2));\n"
"\n"
"http (sprintf (\'%s:%s_of a owl:ObjectProperty .\\n\', qual, ltb), ses);\n"
"http (sprintf (\'%s:%s_of rdfs:domain %s:%s .\\n\', qual, ltb, qual, cls), ses);\n"
"http (sprintf (\'%s:%s_of rdfs:range %s:%s .\\n\', qual, ltb, qual, pkcls), ses);\n"
"http (sprintf (\'%s:%s_of rdfs:label \"Relation to %s\" .\\n\', qual, ltb, pkt), ses);\n"
"http (sprintf (\'%s:%s_of rdfs:isDefinedBy %s: .\\n\', qual, ltb, qual), ses);\n"
"}\n"
"}\n"
"return string_output_string (ses);\n"
"}\n"
"--src rdf_schema_objects.sql:796\n";

static const char *proc396 = 
"create procedure RDF_VIEW_GEN_VD (in qual varchar)\n"
"{\n"
"declare ses, pref any;\n"
"ses := string_output ();\n"
"pref := lower (qual);\n"
"\n"
"if (0 and (\n"
"exists (select 1 from URL_REWRITE_RULE where URR_RULE = pref || \'_rule1\') or\n"
"exists (select 1 from URL_REWRITE_RULE where URR_RULE = pref || \'_rule2\') or\n"
"exists (select 1 from URL_REWRITE_RULE where URR_RULE = pref || \'_rule3\') or\n"
"exists (select 1 from URL_REWRITE_RULE where URR_RULE = pref || \'_rule4\') or\n"
"exists (select 1 from URL_REWRITE_RULE_LIST where URRL_LIST = pref || \'_rule_list1\') or\n"
"exists (select 1 from HTTP_PATH where HP_HOST = \'*ini*\' and HP_LISTEN_HOST = \'*ini*\' and HP_LPATH = \'/\'||qual)\n"
") )\n"
"return \'\\n-- WARNING: there are already created virtual directory \"/\'||qual||\'\", skipping virtual directory generation\\n\'||\n"
"\'-- WARNING: To avoid this message chose different base URL or drop existing virtual directory and its rewrite rules.\\n\';\n"
"\n"
"http (\n"
"\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\n"
"\'\'<pref>_rule2\'\',\n"
"1,\n"
"\'\'(/[^#]*)\'\',\n"
"vector(\'\'path\'\'),\n"
"1,\n"
"\'\'/sparql?query=DESCRIBE+%%3Chttp%%3A//^{URIQADefaultHost}^%U%%23this%%3E+FROM+%%3Chttp%%3A//^{URIQADefaultHost}^/<qual>%%23%%3E&format=%U\'\',\n"
"vector(\'\'path\'\', \'\'*accept*\'\'),\n"
"null,\n"
"\'\'(text/rdf.n3)|(application/rdf.xml)\'\',\n"
"2,\n"
"null\n"
");\', ses);\n"
"\n"
"http (\'\\n\', ses);\n"
"\n"
"http (\n"
"\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\n"
"\'\'<pref>_rule4\'\',\n"
"1,\n"
"\'\'/<qual>/stat([^#]*)\'\',\n"
"vector(\'\'path\'\'),\n"
"1,\n"
"\'\'/sparql?query=DESCRIBE+%%3Chttp%%3A//^{URIQADefaultHost}^/<qual>/stat%%23%%3E+%%3Fo+FROM+%%3Chttp%%3A//^{URIQADefaultHost}^/<qual>%%23%%3E+WHERE+{+%%3Chttp%%3A//^{URIQADefaultHost}^/<qual>/stat%%23%%3E+%%3Fp+%%3Fo+}&format=%U\'\',\n"
"vector(\'\'*accept*\'\'),\n"
"null,\n"
"\'\'(text/rdf.n3)|(application/rdf.xml)\'\',\n"
"2,\n"
"null\n"
");\', ses);\n"
"\n"
"http (\'\\n\', ses);\n"
"http (\n"
"\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\n"
"\'\'<pref>_rule6\'\',\n"
"1,\n"
"\'\'/<qual>/objects/([^#]*)\'\',\n"
"vector(\'\'path\'\'),\n"
"1,\n"
"\'\'/sparql?query=DESCRIBE+%%3Chttp%%3A//^{URIQADefaultHost}^/<qual>/objects/%U%%3E+FROM+%%3Chttp%%3A//^{URIQADefaultHost}^/<qual>%%23%%3E&format=%U\'\',\n"
"vector(\'\'path\'\', \'\'*accept*\'\'),\n"
"null,\n"
"\'\'(text/rdf.n3)|(application/rdf.xml)\'\',\n"
"2,\n"
"null\n"
");\', ses);\n"
"\n"
"http (\'\\n\', ses);\n"
"http (\n"
"\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\n"
"\'\'<pref>_rule1\'\',\n"
"1,\n"
"\'\'([^#]*)\'\',\n"
"vector(\'\'path\'\'),\n"
"1,\n"
"\'\'/about/html/http://^{URIQADefaultHost}^%s\'\',\n"
"vector(\'\'path\'\'),\n"
"null,\n"
"null,\n"
"2,\n"
"303\n"
");\', ses);\n"
"http (\'\\n\', ses);\n"
"\n"
"http (\n"
"\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\n"
"\'\'<pref>_rule5\'\',\n"
"1,\n"
"\'\'/<qual>/objects/(.*)\'\',\n"
"vector(\'\'path\'\'),\n"
"1,\n"
"\'\'/services/rdf/object.binary?path=%%2F<qual>%%2Fobjects%%2F%U&accept=%U\'\',\n"
"vector(\'\'path\'\', \'\'*accept*\'\'),\n"
"null,\n"
"null,\n"
"2,\n"
"null\n"
");\', ses);\n"
"\n"
"http (\'\\n\', ses);\n"
"http (\'DB.DBA.URLREWRITE_CREATE_RULELIST ( \'\'<pref>_rule_list1\'\', 1, vector ( \'\'<pref>_rule1\'\', \'\'<pref>_rule5\'\', \'\'<pref>_rule2\'\', \'\'<pref>_rule4\'\', \'\'<pref>_rule6\'\'));\', ses);\n"
"\n"
"http (\'\\n\', ses);\n"
"http (\'DB.DBA.VHOST_REMOVE (lpath=>\'\'/<qual>\'\');\', ses);\n"
"http (\'\\n\', ses);\n"
"http(\'DB.DBA.VHOST_DEFINE (lpath=>\'\'/<qual>\'\', ppath=>\'\'/\'\', vsp_user=>\'\'dba\'\', is_dav=>0,\n"
"is_brws=>0, opts=>vector (\'\'url_rewrite\'\', \'\'<pref>_rule_list1\'\')\n"
");\',ses);\n"
"ses := string_output_string (ses);\n"
"ses := replace (ses, \'<pref>\', pref);\n"
"ses := replace (ses, \'<qual>\', qual);\n"
"return ses;\n"
"}\n"
"--src rdf_schema_objects.sql:890\n";

static const char *proc397 = 
"create procedure RDF_OWL_GEN_VD (in qual varchar)\n"
"{\n"
"declare ses, pref any;\n"
"ses := string_output ();\n"
"pref := lower (qual);\n"
"\n"
"if ( 0 and (\n"
"exists (select 1 from URL_REWRITE_RULE where URR_RULE = pref || \'_owl_rule1\') or\n"
"exists (select 1 from URL_REWRITE_RULE where URR_RULE = pref || \'_owl_rule2\') or\n"
"exists (select 1 from URL_REWRITE_RULE_LIST where URRL_LIST = pref || \'_owl_rule_list1\') or\n"
"exists (select 1 from HTTP_PATH where HP_HOST = \'*ini*\' and HP_LISTEN_HOST = \'*ini*\' and HP_LPATH = \'/schemas/\'||qual)\n"
") )\n"
"return \'\\n-- WARNING: there are already created virtual directory \"/schemas/\'||qual||\'\", skipping virtual directory generation\\n\'||\n"
"\'-- WARNING: To avoid this message chose different base URL or drop existing virtual directory and its rewrite rules.\\n\';\n"
"\n"
"http (\n"
"\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\n"
"\'\'<pref>_owl_rule2\'\',\n"
"1,\n"
"\'\'(/[^#]*)\'\',\n"
"vector(\'\'path\'\'),\n"
"1,\n"
"\'\'/sparql?query=DESCRIBE+%%3Chttp%%3A//^{URIQADefaultHost}^%U%%3E+FROM+%%3Chttp%%3A//^{URIQADefaultHost}^/schemas/<qual>%%23%%3E&format=%U\'\',\n"
"vector(\'\'path\'\', \'\'*accept*\'\'),\n"
"null,\n"
"\'\'(text/rdf.n3)|(application/rdf.xml)\'\',\n"
"2,\n"
"null\n"
");\', ses);\n"
"\n"
"http (\'\\n\', ses);\n"
"http (\n"
"\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\n"
"\'\'<pref>_owl_rule1\'\',\n"
"1,\n"
"\'\'([^#]*)\'\',\n"
"vector(\'\'path\'\'),\n"
"1,\n"
"\'\'/about/html/http://^{URIQADefaultHost}^%s\'\',\n"
"vector(\'\'path\'\'),\n"
"null,\n"
"null,\n"
"2,\n"
"303\n"
");\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'DB.DBA.URLREWRITE_CREATE_RULELIST ( \'\'<pref>_owl_rule_list1\'\', 1, vector ( \'\'<pref>_owl_rule1\'\', \'\'<pref>_owl_rule2\'\'));\', ses);\n"
"\n"
"http (\'\\n\', ses);\n"
"http (\'DB.DBA.VHOST_REMOVE (lpath=>\'\'/schemas/<qual>\'\');\', ses);\n"
"http (\'\\n\', ses);\n"
"http(\'DB.DBA.VHOST_DEFINE (lpath=>\'\'/schemas/<qual>\'\', ppath=>\'\'/\'\', vsp_user=>\'\'dba\'\', is_dav=>0,\n"
"is_brws=>0, opts=>vector (\'\'url_rewrite\'\', \'\'<pref>_owl_rule_list1\'\')\n"
");\',ses);\n"
"ses := string_output_string (ses);\n"
"ses := replace (ses, \'<pref>\', pref);\n"
"ses := replace (ses, \'<qual>\', qual);\n"
"return ses;\n"
"}\n"
"--src rdf_schema_objects.sql:1003\n";

/* rdf_void.sql */

static const char *tbl20 = 
"create table DB.DBA.RDF_VOID_GRAPH (\n"
"RVG_IID IRI_ID not null primary key,\n"
"RVG_IRI varchar not null,\n"
"RVG_COMMENT varchar\n"
")\n"
"alter index RDF_VOID_GRAPH on DB.DBA.RDF_VOID_GRAPH partition cluster replicated\n"
"create index RDF_VOID_GRAPH_IRI on DB.DBA.RDF_VOID_GRAPH (RVG_IRI) partition cluster replicated\n";

static const char *tbl21 = 
"create table DB.DBA.RDF_VOID_GRAPH_MEMBER (\n"
"RVGM_GROUP_IID IRI_ID not null,\n"
"RVGM_MEMBER_IID IRI_ID not null,\n"
"primary key (RVGM_GROUP_IID, RVGM_MEMBER_IID)\n"
")\n"
"alter index RDF_VOID_GRAPH_MEMBER on DB.DBA.RDF_VOID_GRAPH_MEMBER partition cluster replicated\n";

static const char *proc398 = 
"create procedure RDF_VOID_INIT ()\n"
"{\n"
"XML_REMOVE_NS_BY_PREFIX (\'scovo\', 2);\n"
"XML_REMOVE_NS_BY_PREFIX (\'void\', 2);\n"
"XML_SET_NS_DECL (\'scovo\', \'http://purl.org/NET/scovo#\', 2);\n"
"XML_SET_NS_DECL (\'void\', \'http://rdfs.org/ns/void#\', 2);\n"
"}\n"
"--src rdf_void.sql:42\n";

static const char *other41 = 
"RDF_VOID_INIT ()\n";
static const char *proc399 = 
"create procedure RDF_VOID_SPLIT_IRI (in rel varchar, out pref varchar, out name varchar)\n"
"{\n"
"declare delim1, delim2, delim3, pos int;\n"
"delim1 := coalesce (strrchr (rel, \'/\'), -1);\n"
"delim2 := coalesce (strrchr (rel, \'#\'), -1);\n"
"delim3 := coalesce (strrchr (rel, \':\'), -1);\n"
"pos := __max (delim1, delim2, delim3);\n"
"\n"
"name := subseq (rel, pos + 1);\n"
"pref := subseq (rel, 0, pos);\n"
"}\n"
"--src rdf_void.sql:54\n";

static const char *proc400 = 
"create procedure RDF_VOID_STORE (in graph varchar, in to_graph_name varchar := null, in src varchar := null)\n"
"{\n"
"declare ses any;\n"
"declare host varchar;\n"
"\n"
"if (src is null)\n"
"ses := RDF_VOID_GEN (graph);\n"
"else\n"
"ses := src;\n"
"if (to_graph_name is null)\n"
"{\n"
"host := cfg_item_value(virtuoso_ini_path(), \'URIQA\',\'DefaultHost\');\n"
"to_graph_name := \'http://\' || host || \'/stats/void#\';\n"
"}\n"
"exec (sprintf (\'sparql delete from <%s> { ?s1 ?p1 ?s2 } from <%s> where { <%s#Dataset> void:statItem ?s1 . ?s1 ?p1 ?s2 }\',\n"
"to_graph_name, to_graph_name, graph));\n"
"TTLP (ses, graph, to_graph_name, 185);\n"
"return;\n"
"}\n"
"--src rdf_void.sql:67\n";

static const char *proc401 = 
"create procedure RDF_VOID_ALL_GEN (in target_graph varchar, in details int := 0)\n"
"{\n"
"declare total, subset, ns_ctr int;\n"
"declare ses, hf any;\n"
"declare host varchar;\n"
"\n"
"ses := string_output (http_strses_memory_size ());\n"
"\n"
"host := null;\n"
"\n"
"if (is_http_ctx ())\n"
"host := http_request_header(http_request_header (), \'Host\', null, null);\n"
"if (host is null)\n"
"host := cfg_item_value(virtuoso_ini_path(), \'URIQA\',\'DefaultHost\');\n"
"if (host is null)\n"
"{\n"
"hf := WS.WS.PARSE_URI (target_graph);\n"
"host := hf[1];\n"
"}\n"
"\n"
"\n"
"ns_ctr := 1;\n"
"total := 0;\n"
"target_graph := rtrim (target_graph, \'/#\') || \'/\';\n"
"RDF_VOID_NS (ses);\n"
"http (sprintf (\'\\n\'), ses);\n"
"http (sprintf (\'@prefix ns%d: <%s> .\\n\', ns_ctr, target_graph), ses);\n"
"http (sprintf (\'ns%d:Dataset a void:Dataset ; \\n\', ns_ctr), ses);\n"
"http (sprintf (\' void:sparqlEndpoint <http://%s/sparql> . \\n\', host), ses);\n"
"for select RVG_IID, RVG_IRI, RVG_COMMENT from RDF_VOID_GRAPH where RVG_IRI like target_graph || \'%\' do\n"
"{\n"
"\n"
"declare gr_pref_ctr, grp_cnt int;\n"
"ns_ctr := ns_ctr + 1;\n"
"grp_cnt := 0;\n"
"RVG_IRI := rtrim (RVG_IRI, \'/#\') || \'/\';\n"
"http (sprintf (\'@prefix ns%d: <%s> .\\n\', ns_ctr, RVG_IRI), ses);\n"
"http (sprintf (\'ns%d:Dataset a void:Dataset . \\n\', ns_ctr), ses);\n"
"http (sprintf (\'ns1:Dataset void:subset ns%d:Dataset . \\n\', ns_ctr), ses);\n"
"gr_pref_ctr := ns_ctr;\n"
"for select RVGM_MEMBER_IID from RDF_VOID_GRAPH_MEMBER where RVGM_GROUP_IID = RVG_IID do\n"
"{\n"
"\n"
"ns_ctr := ns_ctr + 1;\n"
"RDF_VOID_GEN_1 (id_to_iri (RVGM_MEMBER_IID), null, sprintf (\'ns%d\', ns_ctr),\n"
"target_graph || rtrim (id_to_iri (RVGM_MEMBER_IID), \'/#\') || \'/\',\n"
"ses, grp_cnt, 1, details);\n"
"http (sprintf (\'ns%d:Dataset void:subset ns%d:Dataset . \\n\', gr_pref_ctr, ns_ctr), ses);\n"
"}\n"
"http (sprintf (\'ns%d:Dataset void:statItem ns%d:Stat . \\n\', gr_pref_ctr, gr_pref_ctr), ses);\n"
"http (sprintf (\'ns%d:Stat a scovo:Item ; \\n rdf:value %d ; \\n\', gr_pref_ctr, grp_cnt), ses);\n"
"http (sprintf (\' scovo:dimension void:numOfTriples . \\n\'), ses);\n"
"http (sprintf (\'\\n\'), ses);\n"
"total := total + grp_cnt;\n"
"}\n"
"http (sprintf (\'ns1:Dataset void:statItem ns1:Stat . \\n\'), ses);\n"
"http (sprintf (\'ns1:Stat a scovo:Item ; \\n rdf:value %d ; \\n\', total), ses);\n"
"http (sprintf (\' scovo:dimension void:numOfTriples . \\n\'), ses);\n"
"http (sprintf (\'\\n\'), ses);\n"
"return ses;\n"
"}\n"
"--src rdf_void.sql:88\n";

static const char *proc402 = 
"create procedure RDF_VOID_NS (inout ses any)\n"
"{\n"
"http (\'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\\n\', ses);\n"
"http (\'@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\\n\', ses);\n"
"http (\'@prefix owl: <http://www.w3.org/2002/07/owl#> .\\n\', ses);\n"
"http (\'@prefix dc: <http://purl.org/dc/elements/1.1/> .\\n\', ses);\n"
"http (\'@prefix scovo: <http://purl.org/NET/scovo#> .\\n\', ses);\n"
"http (\'@prefix void: <http://rdfs.org/ns/void#> .\\n\', ses);\n"
"}\n"
"--src rdf_void.sql:151\n";

static const char *proc403 = 
"create procedure RDF_VOID_GEN (in graph varchar, in gr_name varchar := null)\n"
"{\n"
"declare ses any;\n"
"declare dummy int;\n"
"dummy := 0;\n"
"ses := string_output (http_strses_memory_size ());\n"
"RDF_VOID_NS (ses);\n"
"http (sprintf (\'\\n\'), ses);\n"
"RDF_VOID_GEN_1 (graph, gr_name, \'this\', \'\', ses, dummy, 1, 1);\n"
"return ses;\n"
"}\n"
"--src rdf_void.sql:162\n";

static const char *proc404 = 
"create procedure RDF_VOID_DIST_O_SRV (in graph any)\n"
"{\n"
"declare cnt int;\n"
"cnt := (select count(distinct O) from DB.DBA.RDF_QUAD table option (no cluster) where G = graph);\n"
"return cnt;\n"
"}\n"
"--src rdf_void.sql:175\n";

static const char *proc405 = 
"create procedure RDF_VOID_DIST_O (in graph varchar)\n"
"{\n"
"declare daq, r any;\n"
"declare s int;\n"
"daq := daq (0);\n"
"daq_call (daq, \'DB.DBA.SYS_COLS\', \'SYS_COLS_BY_NAME\', \'DB.DBA.RDF_VOID_DIST_O_SRV\', vector (iri_to_id (graph)), 1);\n"
"while (r:= daq_next (daq))\n"
"{\n"
"if (length (r) >2 and isarray (r[2]) and r[2][0] = 3)\n"
"{\n"
"declare err any;\n"
"err := r[2][1];\n"
"if (isarray (err))\n"
"signal (err[2], err[2]);\n"
"}\n"
"s := s + r[2][1];\n"
"}\n"
"return s;\n"
"}\n"
"--src rdf_void.sql:183\n";

static const char *proc406 = 
"create procedure RDF_VOID_GEN_1 (in graph varchar, in gr_name varchar := null,\n"
"in ns_pref varchar := \'this\', in this_ns varchar := \'\',\n"
"inout ses any, inout total int, in ep int := 1, in details int := 1)\n"
"{\n"
"declare _cnt, _cnt_subj, _cnt_obj, has_links int;\n"
"declare preds, dict any;\n"
"declare pref, name, pred, host varchar;\n"
"declare nam, inx any;\n"
"\n"
"preds := vector (\'owl:sameAs\', \'rdfs:seeAlso\');\n"
"host := null;\n"
"if (is_http_ctx ())\n"
"host := http_request_header(http_request_header (), \'Host\', null, null);\n"
"if (host is null)\n"
"host := cfg_item_value(virtuoso_ini_path(), \'URIQA\',\'DefaultHost\');\n"
"\n"
"\n"
"\n"
"_cnt := (sparql define input:storage \"\" select count(*) where { graph `iri (?:graph)` { ?s ?p ?o . } });\n"
"total := total + _cnt;\n"
"\n"
"http (sprintf (\'@prefix %s: <%s> .\\n\', ns_pref, this_ns), ses);\n"
"\n"
"http (sprintf (\'\\n\'), ses);\n"
"\n"
"http (sprintf (\'%s:Dataset a void:Dataset ; \\n\', ns_pref), ses);\n"
"http (sprintf (\' rdfs:seeAlso <%s> ; \\n\', graph), ses);\n"
"if (gr_name is not null)\n"
"http (sprintf (\' rdfs:label \"%s\" ; \\n\', gr_name), ses);\n"
"if (ep)\n"
"http (sprintf (\' void:sparqlEndpoint <http://%s/sparql> ; \\n\', host), ses);\n"
"http (sprintf (\' void:statItem %s:Stat ; \\n\', ns_pref), ses);\n"
"\n"
"http (sprintf (\' void:statItem %s:DistinctSubjectsStat ; \\n\', ns_pref), ses);\n"
"http (sprintf (\' void:statItem %s:DistinctObjectsStat . \\n\', ns_pref), ses);\n"
"\n"
"http (sprintf (\'%s:Stat a scovo:Item ; \\n rdf:value %d ; \\n\', ns_pref, _cnt), ses);\n"
"http (sprintf (\' scovo:dimension void:numOfTriples . \\n\'), ses);\n"
"\n"
"if (details)\n"
"{\n"
"declare exit handler for sqlstate \'*\' { goto end1; };\n"
"_cnt_subj := (select count(distinct S) from DB.DBA.RDF_QUAD where G = iri_to_id (graph));\n"
"http (sprintf (\'%s:DistinctSubjectsStat a scovo:Item ; \\n rdf:value %d ; \\n\', ns_pref, _cnt_subj), ses);\n"
"http (sprintf (\' scovo:dimension void:numOfTriples . \\n\'), ses);\n"
"end1:;\n"
"}\n"
"if (details)\n"
"{\n"
"declare exit handler for sqlstate \'*\' { goto end2; };\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"_cnt_obj  := RDF_VOID_DIST_O (graph);\n"
"}\n"
"else\n"
"{\n"
"_cnt_obj  := (sparql define input:storage \"\" select count(distinct (?o)) where { graph `iri (?:graph)` { ?s ?p ?o . filter (isIRI (?o)) } });\n"
"}\n"
"http (sprintf (\'%s:DistinctObjectsStat a scovo:Item ; \\n rdf:value %d ; \\n\', ns_pref, _cnt_obj), ses);\n"
"http (sprintf (\' scovo:dimension void:numOfTriples . \\n\'), ses);\n"
"end2:;\n"
"}\n"
"\n"
"http (sprintf (\'\\n\'), ses);\n"
"\n"
"has_links := 0;\n"
"dict := dict_new ();\n"
"foreach (any rel in preds) do\n"
"{\n"
"RDF_VOID_SPLIT_IRI (rel, pref, name);\n"
"pred := __xml_get_ns_uri (pref, 2) || name;\n"
"\n"
"_cnt := (sparql define input:storage \"\" select count(*)\n"
"where { graph `iri (?:graph)` { ?s `iri (?:pred)` ?o . filter (?o != iri (?:graph)) } });\n"
"if (_cnt)\n"
"{\n"
"nam := name;\n"
"inx := 1;\n"
"while (dict_get (dict, nam, 0))\n"
"{\n"
"nam := name||cast (inx as varchar);\n"
"inx := inx + 1;\n"
"}\n"
"name := nam;\n"
"dict_put (dict, nam, 1);\n"
"http (sprintf (\'%s:Dataset void:containsLinks %s:%sLinks .\\n\', ns_pref, ns_pref, name), ses);\n"
"\n"
"http (sprintf (\'%s:%sLinks a void:Linkset ; \\n\', ns_pref, name), ses);\n"
"http (sprintf (\' void:statItem %s:%sStat . \\n\', ns_pref, name), ses);\n"
"\n"
"http (sprintf (\'%s:%sStat a  scovo:Item ; \\n\', ns_pref, name), ses);\n"
"http (sprintf (\' rdf:value %d ; \\n\', _cnt), ses);\n"
"http (sprintf (\' scovo:dimension %s:%sType .\\n\', ns_pref, name), ses);\n"
"\n"
"http (sprintf (\'%s:%sType rdf:type %s:TypeOfLink ;\\n\', ns_pref, name, ns_pref), ses);\n"
"http (sprintf (\' void:linkPredicate %s .\\n\', rel), ses);\n"
"http (sprintf (\'\\n\'), ses);\n"
"has_links := has_links + 1;\n"
"}\n"
"}\n"
"\n"
"for select \"class\", \"cnt\" from (sparql define input:storage \"\" select ?class (count(*)) as ?cnt\n"
"where { graph `iri (?:graph)` { [] a ?class . filter (!isLiteral (?class)) } } group by ?class order by desc 2) s do\n"
"{\n"
"if (\"class\" like \'http://rdfs.org/ns/void#%\' or \"class\" like \'http://purl.org/NET/scovo#%\'\n"
"or \"class\" = graph || \'#TypeOfLink\' or \"class\" like graph || \'#%Links\')\n"
"goto skip;\n"
"RDF_VOID_SPLIT_IRI (\"class\", pref, name);\n"
"if (name is null)\n"
"goto skip;\n"
"nam := sprintf (\'%U\', name);\n"
"inx := 1;\n"
"while (dict_get (dict, nam, 0))\n"
"{\n"
"nam := name||cast (inx as varchar);\n"
"nam := sprintf (\'%U\', nam);\n"
"inx := inx + 1;\n"
"}\n"
"name := nam;\n"
"dict_put (dict, nam, 1);\n"
"http (sprintf (\'%s:Dataset void:statItem %s:%sStat .\\n\', ns_pref, ns_pref, name), ses);\n"
"http (sprintf (\'%s:%sStat a  scovo:Item ; \\n\', ns_pref, name), ses);\n"
"http (sprintf (\' rdf:value %d ; \\n\', \"cnt\"), ses);\n"
"http (sprintf (\' scovo:dimension <%s> ; \\n\', \"class\"), ses);\n"
"http (sprintf (\' scovo:dimension void:numberOfResources . \\n\'), ses);\n"
"http (sprintf (\'\\n\'), ses);\n"
"skip:;\n"
"}\n"
"\n"
"if (has_links)\n"
"http (sprintf (\'%s:TypeOfLink rdfs:subClassOf scovo:Dimension . \\n\', ns_pref), ses);\n"
"return ses;\n"
"}\n"
"--src rdf_void.sql:204\n";

static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name))) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name))) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


void
sqls_define_sparql (void)
{
  /* sparql.sql */

  ddl_ensure_table ("DB.DBA.RDF_QUAD", tbl0);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_IID_OF_QNAME_SAFE", proc0);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_IID_OF_QNAME_COMP", proc1);
  DEFINE_PROC ("DB.DBA.RDF_QNAME_OF_IID", proc2);
  ddl_ensure_table ("DB.DBA.RDF_OBJ", tbl1);
  ddl_ensure_table ("DB.DBA.RO_START", tbl2);
  ddl_ensure_table ("DB.DBA.RDF_DATATYPE", tbl3);
  ddl_ensure_table ("DB.DBA.RDF_LANGUAGE", tbl4);
  ddl_ensure_table ("DB.DBA.SYS_SPARQL_HOST", tbl5);
  ddl_ensure_table ("DB.DBA.RDF_OBJ_FT_RULES", tbl6);
  ddl_ensure_table ("DB.DBA.SYS_SPARQL_SW_LOG", tbl7);
  ddl_ensure_table ("DB.DBA.SYS_XML_PERSISTENT_NS_DECL", tbl8);
  ddl_ensure_table ("DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH", tbl9);
  ddl_ensure_table ("DB.DBA.RDF_GEO", tbl10);
  ddl_ensure_table ("DB.DBA.RDF_LABEL", tbl11);
  ddl_ensure_table ("DB.DBA.SYS_FAKE_0", tbl12);
  ddl_ensure_table ("DB.DBA.SYS_FAKE_1", tbl13);
  ddl_ensure_table ("do this always", other3);
  ddl_ensure_table ("do this always", other4);
  ddl_ensure_table ("do this always", other5);
  ddl_ensure_table ("do this always", other6);
  ddl_ensure_table ("do this always", other7);
  ddl_ensure_table ("do this always", other8);
  ddl_ensure_table ("do this always", other9);
  ddl_ensure_table ("do this always", other10);
  DEFINE_PROC ("RDF_GEO_INIT", proc3);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_RO_FLAGS_INDEX_HOOK", proc4);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_RO_FLAGS_UNINDEX_HOOK", proc5);
  DEFINE_PROC ("sparql_exec_quiet", proc6);
  ddl_ensure_table ("do this always", other11);
  ddl_ensure_table ("do this always", other12); 
  DEFINE_PUBLIC_PROC ("DB.DBA.XML_SET_NS_DECL", proc7); 
  DEFINE_PUBLIC_PROC ("DB.DBA.XML_REMOVE_NS_BY_PREFIX", proc8); 
  DEFINE_PUBLIC_PROC ("DB.DBA.XML_CLEAR_ALL_NS_DECLS", proc9); 
  DEFINE_PUBLIC_PROC ("DB.DBA.XML_SELECT_ALL_NS_DECLS", proc10);
  DEFINE_PROC ("DB.DBA.XML_LOAD_ALL_NS_DECLS", proc11);
  ddl_ensure_table ("do this always", other13);
  ddl_ensure_table ("do this always", other14);
  DEFINE_PROC ("DB.DBA.RDF_LOAD_ALL_FT_RULES", proc12);
  ddl_ensure_table ("do this always", other15);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_IID_OF_QNAME", proc14);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_IID_OF_LONG", proc15);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_GRAPH_IIDS_OF_QNAMES", proc16);
  DEFINE_PROC ("DB.DBA.RDF_TWOBYTE_OF_DATATYPE", proc17);
  DEFINE_PROC ("DB.DBA.RDF_TWOBYTE_OF_LANGUAGE", proc18);
  DEFINE_PROC ("DB.DBA.RQ_LONG_OF_O", proc19);
  DEFINE_PROC ("DB.DBA.RDF_BOX_COMPLETE", proc20);
  DEFINE_PROC ("DB.DBA.RQ_SQLVAL_OF_O", proc21);
  DEFINE_PROC ("DB.DBA.RQ_BOOL_OF_O", proc22);
  DEFINE_PROC ("DB.DBA.RQ_IID_OF_O", proc23);
  DEFINE_PROC ("DB.DBA.RQ_O_IS_LIT", proc24);
  DEFINE_PROC ("RDF_G_INS", proc25);
  DEFINE_PROC ("cl_rdf_geo_insert", proc26);
  DEFINE_PROC ("rdf_geo_add", proc27);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_ADD", proc28);
  DEFINE_PROC ("DB.DBA.RDF_FIND_RO_DIGEST", proc29);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL", proc30);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT", proc31);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL", proc32);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_FT", proc33);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_STRINGS", proc34);
  DEFINE_PROC ("DB.DBA.RDF_LONG_OF_OBJ", proc35);
  DEFINE_PROC ("DB.DBA.RDF_DATATYPE_OF_OBJ", proc36);
  DEFINE_PROC ("DB.DBA.RDF_LANGUAGE_OF_OBJ", proc37);
  DEFINE_PROC ("DB.DBA.RDF_SQLVAL_OF_OBJ", proc38);
  DEFINE_PROC ("DB.DBA.RDF_BOOL_OF_OBJ", proc39);
  DEFINE_PROC ("DB.DBA.RDF_QNAME_OF_OBJ", proc40);
  DEFINE_PROC ("DB.DBA.RDF_STRSQLVAL_OF_OBJ", proc41);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_OF_LONG", proc42);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_OF_SQLVAL", proc43);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_LONG_OF_SQLVAL", proc44);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL", proc45);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL_STRINGS", proc46);
  DEFINE_PROC ("DB.DBA.RDF_QNAME_OF_LONG_SAFE", proc47);
  DEFINE_PROC ("DB.DBA.RDF_SQLVAL_OF_LONG", proc48);
  DEFINE_PROC ("DB.DBA.RDF_BOOL_OF_LONG", proc49);
  DEFINE_PROC ("DB.DBA.RDF_DATATYPE_OF_LONG", proc50);
  DEFINE_PROC ("DB.DBA.RDF_DATATYPE_IRI_OF_LONG", proc51);
  DEFINE_PROC ("DB.DBA.RDF_LANGUAGE_OF_LONG", proc52);
  DEFINE_PROC ("DB.DBA.RDF_STRSQLVAL_OF_LONG", proc53);
  DEFINE_PROC ("DB.DBA.RDF_WIDESTRSQLVAL_OF_LONG", proc54); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_DATATYPE_OF_SQLVAL", proc55);
  DEFINE_PROC ("DB.DBA.RDF_LONG_OF_SQLVAL", proc56); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_STRSQLVAL_OF_SQLVAL", proc57); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_LANGUAGE_OF_SQLVAL", proc58); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_IS_BLANK_REF", proc59); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_IS_URI_REF", proc60); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_IS_REF", proc61); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_IS_LITERAL", proc62); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#boolean", proc63); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#date", proc64); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#dateTime", proc65); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#double", proc66); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#float", proc67); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#integer", proc68); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#int", proc69); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#time", proc70); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#string", proc71); 
  DEFINE_PUBLIC_PROC ("DB.DBA.__and", proc72); 
  DEFINE_PUBLIC_PROC ("DB.DBA.__or", proc73); 
  DEFINE_PUBLIC_PROC ("DB.DBA.__not", proc74);
  DEFINE_PROC ("DB.DBA.RDF_QUAD_URI", proc75);
  DEFINE_PROC ("DB.DBA.RDF_QUAD_URI_L", proc76);
  DEFINE_PROC ("DB.DBA.RDF_QUAD_URI_L_TYPED", proc77);
  DEFINE_PROC ("DB.DBA.TTLP_EV_NEW_GRAPH", proc78);
  DEFINE_PROC ("DB.DBA.TTLP_EV_NEW_BLANK", proc79);
  DEFINE_PROC ("DB.DBA.TTLP_EV_GET_IID", proc80);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE", proc81);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE_L", proc82);
  DEFINE_PROC ("DB.DBA.TTLP_EV_COMMIT", proc83);
  DEFINE_PROC ("DB.DBA.TTLP_EV_REPORT_DEFAULT", proc84);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE_XLAT", proc85);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE_L_XLAT", proc86); 
  DEFINE_PUBLIC_PROC ("DB.DBA.TTLP_XLAT_CONCAT", proc87);
  DEFINE_PROC ("DB.DBA.TTLP", proc88);
  DEFINE_PROC ("DB.DBA.TTLP_WITH_IRI_TRANSLATION", proc89);
  DEFINE_PROC ("DB.DBA.TTLP_VALIDATE", proc90);
  DEFINE_PROC ("DB.DBA.TTLP_VALIDATE_LOCAL_FILE", proc91);
  DEFINE_PROC ("DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH", proc92);
  DEFINE_PROC ("DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK", proc93);
  DEFINE_PROC ("DB.DBA.RDF_TTL2HASH_EXEC_GET_IID", proc94);
  DEFINE_PROC ("DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE", proc95);
  DEFINE_PROC ("DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L", proc96);
  DEFINE_PROC ("DB.DBA.RDF_TTL2HASH", proc97);
  DEFINE_PROC ("DB.DBA.RDF_TTL2SQLHASH_EXEC_GET_IID", proc98);
  DEFINE_PROC ("DB.DBA.RDF_TTL2SQLHASH_EXEC_TRIPLE", proc99);
  DEFINE_PROC ("DB.DBA.RDF_TTL2SQLHASH_EXEC_TRIPLE_L", proc100);
  DEFINE_PROC ("DB.DBA.RDF_TTL2SQLHASH", proc101);
  DEFINE_PROC ("DB.DBA.RDF_LOAD_RDFXML", proc102);
  DEFINE_PROC ("DB.DBA.RDF_RDFXML_TO_DICT", proc103);
  DEFINE_PROC ("DB.DBA.RDF_LOAD_RDFA", proc104);
  DEFINE_PROC ("DB.DBA.RDF_LOAD_RDFA_WITH_IRI_TRANSLATION", proc105);
  DEFINE_PROC ("DB.DBA.RDF_RDFA_TO_DICT", proc106); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_XML_IRI_TO_TTL", proc107); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_XML_OBJ_TO_TTL", proc108); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_NEW_BLANK", proc109); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_TRIPLE", proc110); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_TRIPLE_L", proc111); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_CONVERT_RDFXML_TO_TTL", proc112); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_CONVERT_RDFXML_FILE_TO_TTL_FILE", proc113);
  DEFINE_PROC ("DB.DBA.RDF_LONG_TO_TTL", proc114);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_VERBOSE_TTL", proc115);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_TTL", proc116);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_NT", proc117);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_TO_TTL", proc118);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_RDF_XML_TEXT", proc119);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_TALIS_JSON", proc120);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_JSON", proc121);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_RDFA_XHTML", proc122);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_INIT", proc123);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_ACC", proc124);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_FIN", proc125);
  ddl_ensure_table ("do this always", other16);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_INIT", proc126);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_ACC", proc127);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_FIN", proc128);
  ddl_ensure_table ("do this always", other17);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_INIT", proc129);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_ACC", proc130);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_FIN", proc131);
  ddl_ensure_table ("do this always", other18);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_INIT", proc132);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_ACC", proc133);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_FIN", proc134);
  ddl_ensure_table ("do this always", other19);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TTL", proc135);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_NT", proc136);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_RDF_XML", proc137);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TALIS_JSON", proc138);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_RDFA_XHTML", proc139); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_INIT", proc140); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_ACC", proc141); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_FIN", proc142);
  ddl_ensure_table ("do this always", other20); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_INIT", proc143); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_ACC", proc144); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_FIN", proc145);
  ddl_ensure_table ("do this always", other21); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_INIT", proc146); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_ACC", proc147); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_FIN", proc148);
  ddl_ensure_table ("do this always", other22); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_NT_FIN", proc149);
  ddl_ensure_table ("do this always", other23);
  DEFINE_PROC ("DB.DBA.RDF_INSERT_TRIPLES_CL", proc150);
  DEFINE_PROC ("DB.DBA.RDF_INSERT_TRIPLES", proc151);
  DEFINE_PROC ("DB.DBA.RDF_DELETE_TRIPLES", proc152);
  DEFINE_PROC ("DB.DBA.RDF_DELETE_TRIPLES_AGG", proc153);
  DEFINE_PROC ("DB.DBA.RDF_MODIFY_TRIPLES", proc154); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_INIT", proc155); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_INS_OR_DEL_CTOR_IMPL", proc156); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_DELETE_CTOR_ACC", proc157); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_INSERT_CTOR_ACC", proc158); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_MODIFY_CTOR_ACC", proc159); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_FIN", proc160); 
  ddl_ensure_table ("do this always", other24); 
  ddl_ensure_table ("do this always", other25); 
  ddl_ensure_table ("do this always", other26);
  DEFINE_PROC ("DB.DBA.SPARQL_INSERT_DICT_CONTENT", proc161);
  DEFINE_PROC ("DB.DBA.SPARQL_DELETE_DICT_CONTENT", proc162);
  DEFINE_PROC ("DB.DBA.SPARQL_MODIFY_BY_DICT_CONTENTS", proc163);
  DEFINE_PROC ("DB.DBA.SPARUL_CLEAR", proc164);
  DEFINE_PROC ("DB.DBA.SPARUL_LOAD", proc165);
  DEFINE_PROC ("DB.DBA.SPARUL_CREATE", proc166);
  DEFINE_PROC ("DB.DBA.SPARUL_DROP", proc167);
  DEFINE_PROC ("DB.DBA.SPARUL_RUN", proc168);
  DEFINE_PROC ("DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS", proc169); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_REGEX", proc170); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_LANGMATCHES", proc171); 
  DEFINE_PUBLIC_PROC ("DB.DBA.BEST_LANGMATCH_INIT", proc172); 
  DEFINE_PUBLIC_PROC ("DB.DBA.BEST_LANGMATCH_ACC", proc173); 
  DEFINE_PUBLIC_PROC ("DB.DBA.BEST_LANGMATCH_FINAL", proc174); 
  ddl_ensure_table ("do this always", other27); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_CONSTRUCT_INIT", proc175); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_CONSTRUCT_ACC", proc176); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_CONSTRUCT_FIN", proc177); 
  ddl_ensure_table ("do this always", other28);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_AGG_INIT", proc178);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_AGG_ACC", proc179);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_AGG_FIN", proc180);
  ddl_ensure_table ("do this always", other29);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_DICT", proc181);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_DICT_SPO", proc182);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_DICT_SPO_PHYSICAL", proc183);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_DICT_CBD", proc184);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_DICT_CBD_PHYSICAL", proc185); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_DICT_OF_TRIPLES_TO_THREE_COLS", proc186);
  DEFINE_PROC ("DB.DBA.RDF_TYPEMIN_OF_OBJ", proc187);
  DEFINE_PROC ("DB.DBA.RDF_TYPEMAX_OF_OBJ", proc188);
  DEFINE_PROC ("DB.DBA.RDF_IID_CMP", proc189);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_CMP", proc190);
  DEFINE_PROC ("DB.DBA.RDF_LONG_CMP", proc191); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_DIST_SER_LONG", proc192); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_DIST_DESER_LONG", proc193);
  DEFINE_PROC ("JSO_MAKE_INHERITANCE", proc194);
  DEFINE_PROC ("JSO_LOAD_INSTANCE", proc195);
  DEFINE_PROC ("JSO_LIST_INSTANCES_OF_GRAPH", proc196);
  DEFINE_PROC ("JSO_LOAD_GRAPH", proc197);
  DEFINE_PROC ("JSO_PIN_GRAPH", proc198); 
  DEFINE_PUBLIC_PROC ("JSO_SYS_GRAPH", proc199);
  DEFINE_PROC ("JSO_LOAD_AND_PIN_SYS_GRAPH_RO", proc200);
  DEFINE_PROC ("JSO_LOAD_AND_PIN_SYS_GRAPH", proc201);
  DEFINE_PROC ("JSO_DUMP_IRI", proc202);
  DEFINE_PROC ("JSO_DUMP_FLD", proc203);
  DEFINE_PROC ("DB.DBA.JSO_VECTOR_TO_TTL", proc204);
  DEFINE_PROC ("DB.DBA.JSO_FILTERED_PROPLIST", proc205);
  DEFINE_PROC ("DB.DBA.JSO_DUMP_ALL", proc206);
  DEFINE_PROC ("DB.DBA.RDF_BACKUP_METADATA", proc207);
  DEFINE_PROC ("DB.DBA.RDF_RESTORE_METADATA", proc208);
  DEFINE_PROC ("DB.DBA.RDF_AUDIT_METADATA", proc209);
  DEFINE_PROC ("DB.DBA.RDF_QM_CHANGE", proc210);
  DEFINE_PROC ("DB.DBA.RDF_QM_CHANGE_OPT", proc211);
  DEFINE_PROC ("DB.DBA.RDF_QM_APPLY_CHANGES", proc212);
  DEFINE_PROC ("DB.DBA.RDF_QM_ASSERT_JSO_TYPE", proc213);
  DEFINE_PROC ("DB.DBA.RDF_QM_ASSERT_STORAGE_FLAG", proc214);
  DEFINE_PROC ("DB.DBA.RDF_QM_ASSERT_STORAGE_CONTAINS_MAPPING", proc215);
  DEFINE_PROC ("DB.DBA.RDF_QM_ASSERT_STORAGE_IS_FLAGGED", proc216);
  DEFINE_PROC ("DB.DBA.RDF_QM_GC_SUBTREE", proc217);
  DEFINE_PROC ("DB.DBA.RDF_QM_GC_MAPPING_SUBTREE", proc218);
  DEFINE_PROC ("DB.DBA.RDF_QM_DROP_MAPPING", proc219);
  DEFINE_PROC ("DB.DBA.RDF_QM_MACROEXPAND_TEMPLATE", proc220);
  DEFINE_PROC ("DB.DBA.RDF_QM_CBD_OF_IRI_CLASS", proc221);
  DEFINE_PROC ("DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FORMAT", proc222);
  DEFINE_PROC ("DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FUNCTIONS", proc223);
  DEFINE_PROC ("DB.DBA.RDF_QM_DEFINE_LITERAL_CLASS_FUNCTIONS", proc224); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_BAD_CLASS_INV_FUNCTION", proc225); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SQLNAME_NOTATION_TO_NAME", proc226); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SQLQNAME_NOTATION_TO_QNAME", proc227);
  DEFINE_PROC ("DB.DBA.RDF_QM_CHECK_CLASS_FUNCTION_HEADERS", proc228);
  DEFINE_PROC ("DB.DBA.RDF_QM_DEFINE_SUBCLASS", proc229);
  DEFINE_PROC ("DB.DBA.RDF_QM_DROP_CLASS", proc230);
  DEFINE_PROC ("DB.DBA.RDF_QM_DROP_QUAD_STORAGE", proc231);
  DEFINE_PROC ("DB.DBA.RDF_QM_DEFINE_QUAD_STORAGE", proc232);
  DEFINE_PROC ("DB.DBA.RDF_QM_BEGIN_ALTER_QUAD_STORAGE", proc233);
  DEFINE_PROC ("DB.DBA.RDF_QM_END_ALTER_QUAD_STORAGE", proc234);
  DEFINE_PROC ("DB.DBA.RDF_QM_STORE_ATABLES", proc235);
  DEFINE_PROC ("DB.DBA.RDF_QM_FT_USAGE", proc236);
  DEFINE_PROC ("DB.DBA.RDF_QM_CHECK_COLUMNS_FORM_KEY", proc237);
  DEFINE_PROC ("DB.DBA.RDF_QM_DEFINE_MAP_VALUE", proc238);
  DEFINE_PROC ("DB.DBA.RDF_QM_NORMALIZE_QMV", proc239);
  DEFINE_PROC ("DB.DBA.RDF_QM_DEFINE_MAPPING", proc240);
  DEFINE_PROC ("DB.DBA.RDF_QM_ATTACH_MAPPING", proc241);
  DEFINE_PROC ("DB.DBA.RDF_QM_ADD_MAPPING_TO_STORAGE", proc242);
  DEFINE_PROC ("DB.DBA.RDF_QM_DELETE_MAPPING_FROM_STORAGE", proc243);
  DEFINE_PROC ("DB.DBA.RDF_QM_SET_DEFAULT_MAPPING", proc244);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE_W", proc245);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE_L_W", proc246);
  DEFINE_PROC ("DB.DBA.TTLP_EV_NEW_GRAPH_A", proc247);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE_A", proc248);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE_L_A", proc249);
  DEFINE_PROC ("DB.DBA.TTLP_EV_COMMIT_A", proc250);
  DEFINE_PROC ("DB.DBA.TTLP_MT", proc251);
  DEFINE_PROC ("DB.DBA.TTLP_MT_LOCAL_FILE", proc252);
  DEFINE_PROC ("DB.DBA.RDF_LOAD_RDFXML_MT", proc253);
  DEFINE_PROC ("DB.DBA.VT_DECODE_KEYWORD_ITM", proc254);
  DEFINE_PROC ("DB.DBA.VT_ENCODE_KEYWORD_ITM", proc255);
  DEFINE_PROC ("DB.DBA.VT_COMPOSE_KEYWORD_INDEX_LINES", proc256); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_OBJ_PATCH_CONTAINS_BY_GRAPH", proc257); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_OBJ_PATCH_CONTAINS_BY_MANY_GRAPHS", proc258);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH", proc259);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH_OLD", proc260);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_FT_RULE_ADD", proc261);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_FT_RULE_DEL", proc262);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_FT_RECOVER", proc263);
  ddl_ensure_table ("DB.DBA.RDF_GRAPH_GROUP", tbl14);
  ddl_ensure_table ("DB.DBA.RDF_GRAPH_GROUP_MEMBER", tbl15);
  ddl_ensure_table ("DB.DBA.RDF_GRAPH_USER", tbl16);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_CREATE", proc264);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_DROP", proc265);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_CHECK_VISIBILITY_CHANGE", proc266);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_INS_MEMONLY", proc267);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_INS", proc268);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_DEL_MEMONLY", proc269);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_DEL", proc270);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_USER_PERMS_GET", proc271);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_USER_PERMS_ACK", proc272); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_GRAPH_USER_PERM_TITLE", proc273);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_USER_PERMS_ASSERT", proc274);
  DEFINE_PROC ("DB.DBA.RDF_DEFAULT_USER_PERMS_SET_MEMONLY", proc275);
  DEFINE_PROC ("DB.DBA.RDF_DEFAULT_USER_PERMS_SET", proc276);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_USER_PERMS_SET_MEMONLY", proc277);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_USER_PERMS_SET", proc278);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_LIST_GET", proc279);
  DEFINE_PROC ("DB.DBA.SPARQL_RELOAD_QM_GRAPH", proc280);
  DEFINE_PROC ("DB.DBA.RDF_CREATE_SPARQL_ROLES", proc281);
  DEFINE_PROC ("DB.DBA.RDF_QUAD_AUDIT", proc282);
  DEFINE_PROC ("DB.DBA.RDF_QUAD_FT_UPGRADE", proc283);
  ddl_ensure_table ("do this always", other31);
  DEFINE_PROC ("rdfs_pn", proc284);
  DEFINE_PROC ("rdf_owl_sas_p", proc285);
  ddl_ensure_table ("DB.DBA.SYS_RDF_SCHEMA", tbl17);
  DEFINE_PROC ("rdfs_load_schema", proc286);
  DEFINE_PROC ("rdf_schema_ld", proc287);
  ddl_ensure_table ("do this always", other32);
  DEFINE_PROC ("CL_RDF_INF_CHANGED_SRV", proc288);
  DEFINE_PROC ("CL_RDF_INF_CHANGED", proc289);
  DEFINE_PROC ("rdfs_rule_set", proc290);
  DEFINE_PROC ("DB.DBA.RDF_IID_OF_QNAME", proc291);
  DEFINE_PROC ("SPARQL_INI_PARAMS", proc292);

  /* sparql_io.sql */
 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_XML_WRITE_NS", proc293); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_XML_WRITE_HEAD", proc294); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_XML_HTTP_PRE", proc295); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_XML_HTTP_INIT", proc296); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_XML_HTTP_FINAL", proc297); 
  ddl_ensure_table ("do this always", other33); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_DICT_XML_HTTP_PRE", proc298); 
  ddl_ensure_table ("do this always", other34); 
  DEFINE_PUBLIC_PROC ("SPARQL_RSET_TTL_WRITE_NS", proc299); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_TTL_WRITE_HEAD", proc300); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_TTL_HTTP_PRE", proc301); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_TTL_HTTP_INIT", proc302); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_TTL_HTTP_FINAL", proc303); 
  ddl_ensure_table ("do this always", other35); 
  DEFINE_PUBLIC_PROC ("SPARQL_RSET_NT_WRITE_NS", proc304); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_NT_WRITE_HEAD", proc305); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_NT_HTTP_PRE", proc306); 
  ddl_ensure_table ("do this always", other36);
  DEFINE_PROC ("DB.DBA.SPARQL_REXEC_INT", proc307);
  DEFINE_PROC ("DB.DBA.SPARQL_REXEC", proc308);
  DEFINE_PROC ("DB.DBA.SPARQL_REXEC_TO_ARRAY", proc309);
  DEFINE_PROC ("DB.DBA.SPARQL_REXEC_WITH_META", proc310);
  DEFINE_PROC ("querySoap", proc311); 
  DEFINE_PUBLIC_PROC ("SPARQL_WRITE_EXEC_STATUS", proc312);
  DEFINE_PROC ("SPARQL_RESULTS_XML_WRITE_HEAD", proc313);
  DEFINE_PROC ("SPARQL_RESULTS_XML_WRITE_RES", proc314);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_XML_WRITE_ROW", proc315);
  DEFINE_PROC ("SPARQL_RESULTS_RDFXML_WRITE_NS", proc316);
  DEFINE_PROC ("SPARQL_RESULTS_RDFXML_WRITE_HEAD", proc317);
  DEFINE_PROC ("SPARQL_RESULTS_RDFXML_WRITE_RES", proc318);
  DEFINE_PROC ("SPARQL_RESULTS_RDFXML_WRITE_ROW", proc319);
  DEFINE_PROC ("SPARQL_RESULTS_TTL_WRITE_NS", proc320);
  DEFINE_PROC ("SPARQL_RESULTS_TTL_WRITE_HEAD", proc321);
  DEFINE_PROC ("SPARQL_RESULTS_TTL_WRITE_RES", proc322);
  DEFINE_PROC ("SPARQL_RESULTS_NT_WRITE_NS", proc323);
  DEFINE_PROC ("SPARQL_RESULTS_NT_WRITE_HEAD", proc324);
  DEFINE_PROC ("SPARQL_RESULTS_NT_WRITE_RES", proc325);
  DEFINE_PROC ("SPARQL_RESULTS_JAVASCRIPT_HTML_WRITE", proc326);
  DEFINE_PROC ("SPARQL_RESULTS_JSON_WRITE_BINDING", proc327);
  DEFINE_PROC ("SPARQL_RESULTS_JSON_WRITE", proc328);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_WRITE", proc329);
  DEFINE_PROC ("WS.WS.SPARQL_VHOST_RESET", proc330);
  DEFINE_PROC ("DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT", proc331);
  DEFINE_PROC ("DB.DBA.SPARQL_WSDL11", proc332);
  DEFINE_PROC ("DB.DBA.SPARQL_WSDL", proc333);
  DEFINE_PROC ("DB.DBA.SPARQL_SOAP_NS", proc334);
  DEFINE_PROC ("DB.DBA.SPARQL_PT_NS", proc335); 
  DEFINE_PUBLIC_PROC ("DB.DBA.PARSE_SPARQL_WS_PARAMS", proc336);
  DEFINE_PROC ("DB.DBA.rdf_find_str", proc337);
  ddl_ensure_table ("do this always", other37);
  DEFINE_PROC ("WS.WS./!sparql/", proc338);
  ddl_ensure_table ("do this always", other38); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_ROUTE_IF_DAV", proc339);
  DEFINE_PROC ("DB.DBA.SPARQL_ROUTE_DICT_CONTENT_DAV", proc340);
  DEFINE_PROC ("WS.WS.__http_handler_rq", proc341);
  DEFINE_PROC ("WS.WS.__http_handler_head_rq", proc342);
  DEFINE_PROC ("DB.DBA.http_rq_file_handler", proc343);
  DEFINE_PROC ("DB.DBA.RDF_GRANT_SPARQL_IO", proc344);

  /* rdf_sponge.sql */
 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FT_INDEX_GRABBED", proc345);
  DEFINE_PROC ("DB.DBA.RDF_GRAB_SINGLE", proc346);
  DEFINE_PROC ("DB.DBA.RDF_GRAB_SINGLE_ASYNC", proc347);
  DEFINE_PROC ("DB.DBA.RDF_GRAB_SEEALSO", proc348);
  DEFINE_PROC ("DB.DBA.RDF_GRAB", proc349);
  DEFINE_PROC ("DB.DBA.RDF_GRAB_RESOLVER_DEFAULT", proc350);
  DEFINE_PROC ("DB.DBA.SPARQL_EVAL_TO_ARRAY", proc351);
  DEFINE_PROC ("DB.DBA.SPARQL_EVAL", proc352);
  ddl_ensure_table ("DB.DBA.SYS_HTTP_SPONGE", tbl18);
  DEFINE_PROC ("DB.DBA.SYS_HTTP_SPONGE_GET_CACHE_PARAMS", proc353);
  DEFINE_PROC ("DB.DBA.SYS_HTTP_SPONGE_DEP_URL_NOT_CHANGED", proc354);
  DEFINE_PROC ("DB.DBA.RDF_HTTP_MAKE_HTTP_REQ", proc355);
  DEFINE_PROC ("DB.DBA.SYS_HTTP_SPONGE_UP", proc356);
  DEFINE_PROC ("DB.DBA.SYS_FILE_SPONGE_UP", proc357);
  DEFINE_PROC ("DB.DBA.RDF_SPONGE_GUESS_CONTENT_TYPE", proc358);
  ddl_ensure_table ("DB.DBA.SYS_RDF_MAPPERS", tbl19);
  DEFINE_PROC ("DB.DBA.RDF_HTTP_URL_GET", proc359);
  DEFINE_PROC ("DB.DBA.RDF_SW_PING", proc360);
  DEFINE_PROC ("DB.DBA.RDF_PROC_COLS", proc361);
  DEFINE_PROC ("DB.DBA.RDF_LOAD_HTTP_RESPONSE", proc362);
  DEFINE_PROC ("DB.DBA.RDF_FORGET_HTTP_RESPONSE", proc363);
  DEFINE_PROC ("DB.DBA.RDF_SPONGE_UP", proc364);
  DEFINE_PROC ("DB.DBA.RDF_SPONGE_UP_1", proc365);
  DEFINE_PROC ("DB.DBA.RDF_SPONGE_UP_LIST", proc366);
  DEFINE_PROC ("DB.DBA.RDF_GRANT_SPONGE", proc367);

  /* rdf_schema_objects.sql */

  DEFINE_PROC ("rdf_view_tbl_opts", proc368);
  DEFINE_PROC ("rdf_view_tbl_pk_cols", proc369);
  DEFINE_PROC ("rdf_view_ns_get", proc370);
  DEFINE_PROC ("rdf_view_ns_get_1", proc371);
  DEFINE_PROC ("RDF_VIEW_DROP_STMT", proc372);
  DEFINE_PROC ("RDF_VIEW_FROM_TBL", proc373);
  DEFINE_PROC ("rdf_view_sp", proc374);
  DEFINE_PROC ("rdf_view_sql_tb", proc375);
  DEFINE_PROC ("rdf_view_tb", proc376);
  DEFINE_PROC ("rdf_view_sql_col", proc377);
  DEFINE_PROC ("rdf_view_col", proc378);
  DEFINE_PROC ("rdf_view_cls_name", proc379);
  DEFINE_PROC ("rdf_view_get_ns", proc380);
  DEFINE_PROC ("rdf_view_uri_curie", proc381);
  DEFINE_PROC ("rdf_view_col_type", proc382);
  DEFINE_PROC ("rdf_view_create_view", proc383);
  DEFINE_PROC ("rdf_view_create_void_view", proc384);
  DEFINE_PROC ("rdf_view_get_pk_rel", proc385);
  DEFINE_PROC ("rdf_view_get_bin_rel", proc386);
  DEFINE_PROC ("rdf_view_get_fk_pk_rel", proc387);
  DEFINE_PROC ("rdf_view_get_pk_fk_rel", proc388);
  DEFINE_PROC ("rdf_view_dv_to_printf_str_type", proc389);
  DEFINE_PROC ("rdf_view_dv_to_sql_str_type", proc390);
  DEFINE_PROC ("rdf_view_dv_to_xsd_str_type", proc391);
  DEFINE_PROC ("rdf_view_create_class", proc392);
  DEFINE_PROC ("rdf_view_get_primary_key", proc393);
  DEFINE_PROC ("rdf_view_get_relations", proc394);
  DEFINE_PROC ("RDF_OWL_FROM_TBL", proc395);
  DEFINE_PROC ("RDF_VIEW_GEN_VD", proc396);
  DEFINE_PROC ("RDF_OWL_GEN_VD", proc397);

  /* rdf_void.sql */

  ddl_ensure_table ("DB.DBA.RDF_VOID_GRAPH", tbl20);
  ddl_ensure_table ("DB.DBA.RDF_VOID_GRAPH_MEMBER", tbl21);
  DEFINE_PROC ("RDF_VOID_INIT", proc398);
  ddl_ensure_table ("do this always", other41);
  DEFINE_PROC ("RDF_VOID_SPLIT_IRI", proc399);
  DEFINE_PROC ("RDF_VOID_STORE", proc400);
  DEFINE_PROC ("RDF_VOID_ALL_GEN", proc401);
  DEFINE_PROC ("RDF_VOID_NS", proc402);
  DEFINE_PROC ("RDF_VOID_GEN", proc403);
  DEFINE_PROC ("RDF_VOID_DIST_O_SRV", proc404);
  DEFINE_PROC ("RDF_VOID_DIST_O", proc405);
  DEFINE_PROC ("RDF_VOID_GEN_1", proc406);
}


void
sqls_arfw_define_sparql (void)
{
  /* sparql.sql */

  ddl_ensure_table ("do this always", other0);
  ddl_ensure_table ("do this always", other1);
  ddl_ensure_table ("do this always", other2);
  DEFINE_PROC ("DB.DBA.RDF_GLOBAL_RESET", proc13);
  ddl_ensure_table ("do this always", other30);

  /* sparql_io.sql */

 if (sch_proc_def_exists (bootstrap_cli, "DB.DBA.USER_CREATE"))
  ddl_ensure_table ("do this always", other39);

  /* rdf_sponge.sql */

 if (sch_proc_def_exists (bootstrap_cli, "DB.DBA.USER_CREATE"))
  ddl_ensure_table ("do this always", other40);

}
