/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* cov_report.xsl */

static const char *xsl1[]= {
"<?xml version=\"1.0\"?>\n"
"<!--\n"
" -\n"
" -  $Id: cov_report.xsl,v 1.3.2.1 2009/04/16 09:48:07 source Exp $\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2009 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\" >\n"
"<xsl:output method=\"text\" indent=\"yes\" />\n"
"<xsl:param name=\"file_name\" />\n"
"<xsl:variable name=\"pad\" select=\"'        '\"/>\n"
"<xsl:template match=\"/\">\n"
"Lines: <xsl:value-of select=\"count (pl_stats/*[@file = $file_name]/line)\"/>\n"
"TotalLines: <xsl:value-of  select=\"sum (pl_stats/*[@file = $file_name]/@lct)\" />\n"
"Coverage: <xsl:value-of select=\"(100 * count (pl_stats/*[@file = $file_name]/line[number(@ctr) > 0])) div sum (pl_stats/*[@file = $file_name]/@lct)\" /> %\n"
"<xsl:text>\n"
"</xsl:text>\n"
"\n"
"<xsl:for-each select=\"pl_stats/*[@file = $file_name]\">\n"
"<xsl:sort select=\"concat(@file,line[1]/@no)\" order=\"ascending\"/>\n"
"<xsl:text>\n"
"</xsl:text>\n"
"<xsl:variable name=\"pcalls\" select=\"number(@calls)\" />\n"
"<xsl:value-of select=\"substring ($pad, 1, 8 - string-length ($pcalls))\"/>\n"
"<xsl:value-of select=\"$pcalls\"/> : <xsl:value-of select=\"@name\"/> <xsl:call-template name=\"cls_name\"/>: (<xsl:value-of select=\"@time\"/> msec)\n"
"<xsl:text>\n"
"        </xsl:text>\n"
"<xsl:for-each select=\"line\">\n"
"<xsl:sort select=\"@no\"/>\n"
"<xsl:variable name=\"lineno\" select=\"number(@no)\" />\n"
"<xsl:variable name=\"linectr\" select=\"number(@ctr)\" />\n"
"<xsl:value-of select=\"substring ($pad, 1, 6 - string-length ($lineno))\"/>\n"
"<xsl:choose>\n"
"<xsl:when test=\"number(@ctr) > 0\">\n"
"<xsl:value-of select=\"$lineno\"/> : <xsl:value-of select=\"substring ($pad, 1, 6 - string-length ($linectr))\"/><xsl:value-of select=\"$linectr\"/> : <xsl:value-of select=\".\"/>\n"
"<xsl:text>\n"
"        </xsl:text>\n"
"</xsl:when>\n"
"<xsl:otherwise>\n"
"<xsl:value-of select=\"$lineno\"/> :     ## : <xsl:value-of select=\".\"/><xsl:text>\n"
"        </xsl:text>\n"
"</xsl:otherwise>\n"
"</xsl:choose>\n"
"</xsl:for-each>\n"
"<xsl:text>\n"
"        </xsl:text>\n"
"<xsl:for-each select=\"caller\">\n"
"<xsl:sort select=\"@ct\"/>\n"
"<xsl:variable name=\"pct\" select=\"number(@ct)\" />\n"
"<xsl:value-of select=\"substring ($pad, 1, 6 - string-length ($pct))\"/>\n"
"<xsl:value-of select=\"$pct\"/> : <xsl:value-of select=\"@name\"/>\n"
"<xsl:text>\n"
"        </xsl:text>\n"
"</xsl:for-each>\n"
"</xsl:for-each>\n"
"</xsl:template>\n"
"<xsl:template name=\"cls_name\">\n"
"    <xsl:if test=\"@class\">\n"
"	<xsl:text> of </xsl:text> <xsl:value-of select=\"@class\"/><xsl:text> </xsl:text>\n"
"    </xsl:if>\n"
"</xsl:template>\n"
"</xsl:stylesheet>\n"
"\n"
"\n"
,
 NULL };

/* cov_time.xsl */

static const char *xsl2[]= {
"<?xml version=\"1.0\"?>\n"
"<!--\n"
" -\n"
" -  $Id: cov_time.xsl,v 1.5 2009/04/09 13:22:12 source Exp $\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2006 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\" >\n"
"<xsl:output method=\"text\" indent=\"no\" />\n"
"<xsl:param name=\"files\"/>\n"
"<xsl:variable name=\"pad\" select=\"'              '\"/>\n"
"<xsl:variable name=\"lpad\" select=\"'                        '\"/>\n"
"<xsl:template match=\"/\">\n"
"    <xsl:text/> Flat profile (by self):<xsl:text>&#10;</xsl:text>\n"
"    <xsl:text/>    self                calls  name (average)<xsl:text>&#10;</xsl:text>\n"
"    <xsl:text/>    -----------------------------------------<xsl:text>&#10;</xsl:text>\n"
"<xsl:for-each select=\"pl_stats/proc|pl_stats/method\">\n"
"<xsl:sort select=\"format-number(number (@self), '000000000000.')\" order=\"descending\"/>\n"
"<xsl:variable name=\"tim\" select=\"format-number(number (@self), '.')\" />\n"
"<xsl:variable name=\"avg\" select=\"format-number(number (@self) div number (@calls), '.0000')\" />\n"
"<xsl:variable name=\"pcalls\" select=\"number(@calls)\" />\n"
"<xsl:value-of select=\"substring ($pad, 1, 14 - string-length ($tim))\"/>\n"
"<xsl:value-of select=\"$tim\"/>\n"
"<xsl:value-of select=\"substring ($pad, 1, 14 - string-length ($pcalls))\"/>\n"
"<xsl:value-of select=\"$pcalls\"/> : <xsl:value-of select=\"@name\"/> <xsl:call-template name=\"cls_name\"/> : (<xsl:value-of select=\"$avg\"/> msec)<xsl:text/><xsl:text>&#10;</xsl:text>\n"
"</xsl:for-each>\n"
"    <xsl:text>&#10;</xsl:text>\n"
"    <xsl:text>&#10;</xsl:text>\n"
"    <xsl:text/> Flat profile (by cumulative):<xsl:text>&#10;</xsl:text>\n"
"    <xsl:text/>    cumulative          calls  name (average)<xsl:text>&#10;</xsl:text>\n"
"    <xsl:text/>    -----------------------------------------<xsl:text>&#10;</xsl:text>\n"
"<xsl:for-each select=\"pl_stats/proc|pl_stats/method\">\n"
"<xsl:sort select=\"format-number(number (@time), '000000000000.')\" order=\"descending\"/>\n"
"<xsl:variable name=\"tim\" select=\"format-number(number (@time), '.')\" />\n"
"<xsl:variable name=\"avg\" select=\"format-number(number (@time) div number (@calls), '.0000')\" />\n"
"<xsl:variable name=\"pcalls\" select=\"number(@calls)\" />\n"
"<xsl:value-of select=\"substring ($pad, 1, 14 - string-length ($tim))\"/>\n"
"<xsl:value-of select=\"$tim\"/>\n"
"<xsl:value-of select=\"substring ($pad, 1, 14 - string-length ($pcalls))\"/>\n"
"<xsl:value-of select=\"$pcalls\"/> : <xsl:value-of select=\"@name\"/> <xsl:call-template name=\"cls_name\"/> : (<xsl:value-of select=\"$avg\"/> msec)<xsl:text/><xsl:text>&#10;</xsl:text>\n"
"</xsl:for-each>\n"
"\n"
"Coverage:\n"
"<xsl:variable name=\"src\" select=\".\"/>\n"
"file                             lines         total      coverage (%)\n"
"----------------------------------------------------------------------\n"
"<xsl:for-each select=\"$files/files/file\" >\n"
"    <xsl:variable name=\"file\" select=\"@name\"/>\n"
"    <xsl:variable name=\"lines\" select=\"count ($src/pl_stats/*[@file = $file]/line[number(@ctr) > 0])\"/>\n"
"    <xsl:variable name=\"total\" select=\"sum ($src/pl_stats/*[@file = $file]/@lct)\"/>\n"
"    <xsl:variable name=\"pct\" select=\"format-number((100 * $lines div $total), '.0000')\"/>\n"
"    <xsl:text/><xsl:value-of select=\"$file\"/>\n"
"    <xsl:value-of select=\"substring ($lpad, 1, 24 - string-length ($file))\"/>\n"
"    <xsl:text/>\n"
"    <xsl:value-of select=\"substring ($pad, 1, 14 - string-length ($lines))\"/>\n"
"    <xsl:value-of select=\"$lines\"/>\n"
"    <xsl:text/>\n"
"    <xsl:value-of select=\"substring ($pad, 1, 14 - string-length ($lines))\"/>\n"
"    <xsl:value-of  select=\"$total\" />\n"
"    <xsl:text/>\n"
"    <xsl:value-of select=\"substring ($pad, 1, 14 - string-length ($pct))\"/>\n"
"    <xsl:value-of select=\"$pct\" /><xsl:text>&#10;</xsl:text>\n"
"</xsl:for-each>\n"
"----------------------------------------------------------------------\n"
"</xsl:template>\n"
"<xsl:template name=\"cls_name\">\n"
"    <xsl:if test=\"@class\">\n"
"	<xsl:text> of </xsl:text> <xsl:value-of select=\"@class\"/><xsl:text> </xsl:text>\n"
"    </xsl:if>\n"
"</xsl:template>\n"
"<xsl:template match=\"*|@*|text()\"/>\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

static const char * xslt_define = "xslt_sheet (?, xtree_doc (?, 128, ?, 'LATIN-1', 'x-any', 'BuildStandalone=ENABLE'))";
static query_t *xslt_define_qr;

#define XSLT_DEFINE(name, text1) \
  { \
    caddr_t text = NULL;\
    static const char *elm;\
    int inx, len = 0;\
    for (inx = 0; ; inx++) { \
        elm = text1[inx];\
        if (!elm) break;\
        len += (int) strlen (elm);\
      }\
    text = dk_alloc_box (len + 1, DV_STRING);\
    text[0] = 0;\
    for (inx = 0; ; inx++) { \
        elm = text1[inx];\
        if (!elm) break;\
        strcat_box_ck (text, elm);\
      }\
    \
    if (!xslt_define_qr) \
      xslt_define_qr = sql_compile (xslt_define, bootstrap_cli, NULL, SQLC_DEFAULT); \
    if (xslt_define_qr) \
      { \
        caddr_t err = NULL; \
        err = qr_quick_exec (xslt_define_qr, bootstrap_cli, NULL, NULL, 3, \
               ":0", name, QRP_STR, ":1", text, QRP_STR, ":2", name, QRP_STR); \
        if (err) { \
          log_error ("Error executing a server init statement : %s: %s -- %.50s", \
          ((caddr_t *) err)[QC_ERRNO], ((caddr_t *) err)[QC_ERROR_STRING], \
                      text); \
          dk_free_tree (err); \
	    } \
	  local_commit (bootstrap_cli); \
      } \
    dk_free_box (text);\
  }

static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name))) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name))) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


void
sqls_define_pldbg (void)
{
  /* cov_report.xsl */

  XSLT_DEFINE ("http://local.virt/cov_report", xsl1);

  /* cov_time.xsl */

  XSLT_DEFINE ("http://local.virt/cov_time", xsl2);
}


void
sqls_arfw_define_pldbg (void)
{
}
