/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConcat;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSingleton;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.util.FileManager;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.util.StringTokenizer;
import virtuoso.jena.driver.VirtGraph;

public class VirtuosoQueryExecution
implements QueryExecution {
    private QueryIterConcat output = null;
    String virt_graph = null;
    private VirtGraph graph;
    private String virt_query;
    int prefetchSize = 200;
    java.sql.Statement stmt = null;

    public VirtuosoQueryExecution(String string, VirtGraph virtGraph) {
        this.graph = virtGraph;
        this.virt_graph = this.graph.getGraphName();
        this.prefetchSize = this.graph.getFetchSize();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "";
        while (stringTokenizer.hasMoreTokens() && !(string2 = stringTokenizer.nextToken().toLowerCase()).equals("describe") && !string2.equals("construct") && !string2.equals("ask")) {
        }
        this.virt_query = string2.equals("describe") || string2.equals("construct") || string2.equals("ask") ? "sparql\n define output:format '_JAVA_'\n " + string : "sparql\n " + string;
    }

    public ResultSet execSelect() {
        ResultSet resultSet = null;
        try {
            Connection connection = this.graph.getConnection();
            this.stmt = connection.createStatement();
            this.stmt.setFetchSize(this.prefetchSize);
            java.sql.ResultSet resultSet2 = this.stmt.executeQuery(this.virt_query);
            resultSet = this.ViruosoResultBindingsToJenaResults(resultSet2);
            this.stmt.close();
            this.stmt = null;
            return resultSet;
        }
        catch (Exception exception) {
            throw new JenaException("Convert results are FAILED.:" + exception);
        }
    }

    public ResultSet ViruosoResultBindingsToJenaResults(java.sql.ResultSet resultSet) {
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                BindingMap bindingMap = new BindingMap();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    bindingMap.add(Var.alloc((String)resultSetMetaData.getColumnLabel(i)), VirtGraph.Object2Node(resultSet.getObject(i)));
                }
                if (this.virt_graph != null && !this.virt_graph.equals("virt:DEFAULT")) {
                    bindingMap.add(Var.alloc((String)"graph"), Node.createURI((String)this.virt_graph));
                }
                this.AddToRes((Binding)bindingMap);
            }
        }
        catch (Exception exception) {
            throw new JenaException("ViruosoResultBindingsToJenaResults is FAILED.:" + exception);
        }
        return new ResultSetStream(null, null, (QueryIterator)this.output);
    }

    private void AddToRes(Binding binding) {
        QueryIterSingleton queryIterSingleton = new QueryIterSingleton(binding, null);
        if (this.output == null) {
            this.output = new QueryIterConcat(null);
        }
        this.output.add((QueryIterator)queryIterSingleton);
    }

    public void setFileManager(FileManager fileManager) {
        throw new JenaException("UnsupportedMethodException");
    }

    public void setInitialBinding(QuerySolution querySolution) {
        throw new JenaException("UnsupportedMethodException");
    }

    public Dataset getDataset() {
        return null;
    }

    public Context getContext() {
        return null;
    }

    public Model execConstruct() {
        return this.execConstruct(ModelFactory.createDefaultModel());
    }

    public Model execConstruct(Model model) {
        try {
            Connection connection = this.graph.getConnection();
            this.stmt = connection.createStatement();
            this.stmt.setFetchSize(this.prefetchSize);
            java.sql.ResultSet resultSet = this.stmt.executeQuery(this.virt_query);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                Node node;
                Node node2;
                Node node3 = VirtGraph.Object2Node(resultSet.getObject(1));
                Statement statement = ModelUtils.tripleToStatement((Model)model, (Triple)new Triple(node3, node2 = VirtGraph.Object2Node(resultSet.getObject(2)), node = VirtGraph.Object2Node(resultSet.getObject(3))));
                if (statement == null) continue;
                model.add(statement);
            }
            this.stmt.close();
            this.stmt = null;
        }
        catch (Exception exception) {
            throw new JenaException("Convert results are FAILED.:" + exception);
        }
        return model;
    }

    public Model execDescribe() {
        return this.execDescribe(ModelFactory.createDefaultModel());
    }

    public Model execDescribe(Model model) {
        try {
            Connection connection = this.graph.getConnection();
            this.stmt = connection.createStatement();
            this.stmt.setFetchSize(this.prefetchSize);
            java.sql.ResultSet resultSet = this.stmt.executeQuery(this.virt_query);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                Node node;
                Node node2;
                Node node3 = VirtGraph.Object2Node(resultSet.getObject(1));
                Statement statement = ModelUtils.tripleToStatement((Model)model, (Triple)new Triple(node3, node2 = VirtGraph.Object2Node(resultSet.getObject(2)), node = VirtGraph.Object2Node(resultSet.getObject(3))));
                if (statement == null) continue;
                model.add(statement);
            }
            this.stmt.close();
            this.stmt = null;
        }
        catch (Exception exception) {
            throw new JenaException("Convert results are FAILED.:" + exception);
        }
        return model;
    }

    public boolean execAsk() {
        boolean bl = false;
        try {
            Connection connection = this.graph.getConnection();
            this.stmt = connection.createStatement();
            java.sql.ResultSet resultSet = this.stmt.executeQuery(this.virt_query);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                if (resultSet.getInt(1) != 1) continue;
                bl = true;
            }
            this.stmt.close();
            this.stmt = null;
        }
        catch (Exception exception) {
            throw new JenaException("Convert results are FAILED.:" + exception);
        }
        return bl;
    }

    public void abort() {
        if (this.stmt != null) {
            try {
                this.stmt.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void close() {
        if (this.stmt != null) {
            try {
                this.stmt.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

