/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.shared.JenaException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import virtuoso.jena.driver.VirtGraph;

public class VirtBulkUpdateHandler
extends SimpleBulkUpdateHandler {
    public VirtBulkUpdateHandler(VirtGraph virtGraph) {
        super((GraphWithPerform)virtGraph);
    }

    public void add(Triple[] tripleArray) {
        this.addIterator(Arrays.asList(tripleArray).iterator(), false);
        this.manager.notifyAddArray((Graph)this.graph, tripleArray);
    }

    protected void add(List list, boolean bl) {
        this.addIterator(list.iterator(), false);
        if (bl) {
            this.manager.notifyAddList((Graph)this.graph, list);
        }
    }

    public void addIterator(Iterator iterator, boolean bl) {
        VirtGraph virtGraph = (VirtGraph)this.graph;
        ArrayList arrayList = bl ? new ArrayList() : null;
        try {
            boolean bl2 = virtGraph.getConnection().getAutoCommit();
            if (bl2) {
                virtGraph.getConnection().setAutoCommit(false);
            }
            virtGraph.add(iterator, arrayList);
            if (bl2) {
                virtGraph.getConnection().commit();
                virtGraph.getConnection().setAutoCommit(true);
            }
        }
        catch (Exception exception) {
            throw new JenaException("Couldn't create transaction:" + exception);
        }
        if (bl) {
            this.manager.notifyAddIterator((Graph)this.graph, arrayList);
        }
    }

    public void delete(Triple[] tripleArray) {
        this.deleteIterator(Arrays.asList(tripleArray).iterator(), false);
        this.manager.notifyDeleteArray((Graph)this.graph, tripleArray);
    }

    protected void delete(List list, boolean bl) {
        this.deleteIterator(list.iterator(), false);
        if (bl) {
            this.manager.notifyDeleteList((Graph)this.graph, list);
        }
    }

    public void deleteIterator(Iterator iterator, boolean bl) {
        VirtGraph virtGraph = (VirtGraph)this.graph;
        ArrayList arrayList = bl ? new ArrayList() : null;
        try {
            boolean bl2 = virtGraph.getConnection().getAutoCommit();
            if (bl2) {
                virtGraph.getConnection().setAutoCommit(false);
            }
            virtGraph.delete(iterator, arrayList);
            if (bl2) {
                virtGraph.getConnection().commit();
                virtGraph.getConnection().setAutoCommit(true);
            }
        }
        catch (Exception exception) {
            throw new JenaException("Couldn't create transaction:" + exception);
        }
        if (bl) {
            this.manager.notifyDeleteIterator((Graph)this.graph, arrayList);
        }
    }

    public void removeAll() {
        VirtGraph virtGraph = (VirtGraph)this.graph;
        virtGraph.clearGraph(virtGraph.getGraphName());
        this.notifyRemoveAll();
    }

    public void remove(Node node, Node node2, Node node3) {
        VirtGraph virtGraph = (VirtGraph)this.graph;
        virtGraph.delete_match((TripleMatch)Triple.createMatch((Node)node, (Node)node2, (Node)node3));
        this.manager.notifyEvent((Graph)this.graph, (Object)GraphEvents.remove((Node)node, (Node)node2, (Node)node3));
    }
}

