/*****************************************************************************
 *
 * grail - Gesture Recognition And Instantiation Library
 *
 * Copyright (C) 2010-2012 Canonical Ltd.
 *
 * This library is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#include "grail-recognizer.h"
#include <string.h>
#include <malloc.h>
#include <errno.h>

int gru_init(struct grail *ge)
{
	struct gesture_recognizer *gru;
	gru = calloc(1, sizeof(struct gesture_recognizer));
	if (!gru)
		return -ENOMEM;
	ge->gru = gru;
	gru_init_motion(ge);
	return 0;
}

void gru_destroy(struct grail *ge)
{
	free(ge->gru);
	ge->gru = NULL;
}

void gru_recognize(struct grail *ge, const struct utouch_frame *frame)
{
	if (!ge->gin || !ge->gru)
		return;
	gru_motion(ge, frame);
	gru_touch(ge, frame);
	gru_drag(ge, frame);
	gru_pinch(ge, frame);
	gru_rotate(ge, frame);
	gru_wintouch(ge, frame);
	gru_windrag(ge, frame);
	gru_winpinch(ge, frame);
	gru_winrotate(ge, frame);
	gru_tapping(ge, frame);
}
