/*****************************************************************************
 *
 * grail - Gesture Recognition And Instantiation Library
 *
 * Copyright (C) 2010-2012 Canonical Ltd.
 * Copyright (C) 2010 Henrik Rydberg <rydberg@bitmath.org>
 *
 * This library is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#include "grail-recognizer.h"
#include <math.h>
#include <stdio.h>

static const int getype[DIM_TOUCH + 1] = {
	-1,
	GRAIL_TYPE_TOUCH1,
	GRAIL_TYPE_TOUCH2,
	GRAIL_TYPE_TOUCH3,
	GRAIL_TYPE_TOUCH4,
	GRAIL_TYPE_TOUCH5,
};

int gru_touch(struct grail *ge,
	      const struct utouch_frame *frame)
{
	struct gesture_recognizer *gru = ge->gru;
	struct combo_model *state = &gru->touch;
	struct move_model *move = &gru->move;
	if (frame->slot_revision != frame->prev->slot_revision) {
		if (state->active) {
			gru_end(ge, state->gid, move,
				state->prop, state->nprop);
			state->active = 0;
		}
	}
	if (!state->active) {
		int type = getype[move->ntouch];
		if (type <= 0)
			return 0;
		state->gid = gin_gid_begin(ge, type, -PRIO_GESTURE, frame);
		state->active = 1;
	}
	if (move->time - move->fm[FM_X].original_ms <= move->fm[FM_X].hold_ms)
		return 0;
	state->nprop = gin_add_contact_props(ge->gin, state->prop, frame);
	gru_event(ge, state->gid, move, state->prop, state->nprop);
	return 1;
}

int gru_wintouch(struct grail *ge,
		 const struct utouch_frame *frame)
{
	struct gesture_recognizer *gru = ge->gru;
	struct combo_model *state = &gru->wintouch;
	struct move_model *move = &gru->move;
	if (frame->slot_revision != frame->prev->slot_revision) {
		if (state->active && out_of_bounds(state, move)) {
			gru_end(ge, state->gid, move,
				state->prop, state->nprop);
			state->active = 0;
		}
	}
	if (!state->active) {
		if (move->ntouch == 4) {
			state->gid = gin_gid_begin(ge, GRAIL_TYPE_MTOUCH,
						   -PRIO_META, frame);
			state->mintouch = 1;
			state->maxtouch = 4;
			state->active = 1;
		} else if (move->ntouch == 3) {
			state->gid = gin_gid_begin(ge, GRAIL_TYPE_ETOUCH,
						   -PRIO_ENV, frame);
			state->mintouch = 1;
			state->maxtouch = 3;
			state->active = 1;
		} else {
			return 0;
		}
	}
	if (move->time - move->fm[FM_X].original_ms <= move->fm[FM_X].hold_ms)
		return 0;
	state->nprop = gin_add_contact_props(ge->gin, state->prop, frame);
	gru_event(ge, state->gid, move, state->prop, state->nprop);
	return 1;
}
