/* i386-win32.pe.h
   created from i386-win32.pe.bin, 32178 (0x7db2) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2009 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2009 Laszlo Molnar
   Copyright (C) 2000-2009 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ml1050@users.sourceforge.net>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_I386_WIN32_PE_SIZE    32178
#define STUB_I386_WIN32_PE_ADLER32 0x5a1944bd
#define STUB_I386_WIN32_PE_CRC32   0x480174ce

unsigned char stub_i386_win32_pe[32178] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */  64, 32,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */ 190,  0,187,  0,128,124, 36,  8,  1, 15,133,252,255,255,255, 96,
/* 0x0040 */ 190,  0,  0,  0,  0,141,190,  0,  0,  0,  0,102,255,135,  0,  0,
/* 0x0050 */   0,  0,102,129,135,  0,  0,  0,  0,  0,  0,199,135,  0,  0,  0,
/* 0x0060 */   0,  0,  0,  0,  0, 87,131,205,255,235,  3,164,235,  3,138,  6,
/* 0x0070 */  70,136,  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,
/* 0x0080 */   1, 49,192, 64,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139,
/* 0x0090 */  30,131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,
/* 0x00a0 */ 252, 17,219,115,255,  1,219,115,255,117,  9,139, 30,131,238,252,
/* 0x00b0 */  17,219,115,255, 49,201,131,232,  3,114, 13,193,224,  8,138,  6,
/* 0x00c0 */  70,131,240,255,116,255,137,197,  1,219,117,  7,139, 30,131,238,
/* 0x00d0 */ 252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x00e0 */  17,201,117,255, 65,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x00f0 */  17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115, 48,  1,
/* 0x0100 */ 219,115, 48,117,  9,139, 30,131,238,252, 17,219,115, 48, 65, 65,
/* 0x0110 */ 131,193,  2,129,253,  0,243,255,255,131,209,  1,137,242,141, 52,
/* 0x0120 */  47,243,164,137,214,233,252,255,255,255,141, 20, 47,131,253,252,
/* 0x0130 */ 118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,
/* 0x0140 */ 139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,
/* 0x0150 */ 207,233,252,255,255,255,235,  3,164,235,  3,138,  6, 70,136,  7,
/* 0x0160 */  71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192,
/* 0x0170 */  64,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,
/* 0x0180 */ 252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x0190 */ 114, 15,  1,219,115, 11,117, 15,139, 30,131,238,252, 17,219,114,
/* 0x01a0 */  15, 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,235,
/* 0x01b0 */ 255, 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,240,
/* 0x01c0 */ 255,116,255,209,248,137,197,235, 11,  1,219,117,  7,139, 30,131,
/* 0x01d0 */ 238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x01e0 */ 219, 17,201,117,255, 65,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x01f0 */ 219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115, 68,
/* 0x0200 */   1,219,115, 68,117,  9,139, 30,131,238,252, 17,219,115, 68, 65,
/* 0x0210 */  65,131,193,  2,129,253,  0,251,255,255,131,209,  1,137,242,141,
/* 0x0220 */  52, 47,243,164,137,214,233,252,255,255,255,141, 20, 47,131,253,
/* 0x0230 */ 252,118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,
/* 0x0240 */ 255,139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,
/* 0x0250 */   1,207,233,252,255,255,255,235,  3,164,235,  3,138,  6, 70,136,
/* 0x0260 */   7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,
/* 0x0270 */ 192, 64,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,
/* 0x0280 */ 238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x0290 */ 219,114, 30,  1,219,115, 11,117, 30,139, 30,131,238,252, 17,219,
/* 0x02a0 */ 114, 30, 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,
/* 0x02b0 */ 235,255,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,235,
/* 0x02c0 */ 255, 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,240,
/* 0x02d0 */ 255,116,255,209,248,137,197,235, 11,  1,219,117,  7,139, 30,131,
/* 0x02e0 */ 238,252, 17,219,114,204, 65,  1,219,117,  7,139, 30,131,238,252,
/* 0x02f0 */  17,219,114,190,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,
/* 0x0300 */ 201,  1,219,117,  7,139, 30,131,238,252, 17,219,115, 81,  1,219,
/* 0x0310 */ 115, 81,117,  9,139, 30,131,238,252, 17,219,115, 81, 65, 65,131,
/* 0x0320 */ 193,  2,129,253,  0,251,255,255,131,209,  2,137,242,141, 52, 47,
/* 0x0330 */ 243,164,137,214,233,252,255,255,255,141, 20, 47,131,253,252,118,
/* 0x0340 */ 255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,139,
/* 0x0350 */   2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,
/* 0x0360 */ 233,252,255,255,255,137,229,141,156, 36,  0,  0,  0,  0, 49,192,
/* 0x0370 */  80, 57,220,117,251, 70, 70, 83,104,  0,  0,  0,  0, 87,131,195,
/* 0x0380 */   4, 83,104,  0,  0,  0,  0, 86,131,195,  4, 83, 80,199,  3,  0,
/* 0x0390 */   0,  0,  0,137,229,139, 85,  0,172, 74,136,193, 36,  7,192,233,
/* 0x03a0 */   3,187,  0,253,255,255,211,227,141,164, 92,144,241,255,255,131,
/* 0x03b0 */ 228,224,106,  0,106,  0,137,227, 83,131,195,  4,139, 77,  0,255,
/* 0x03c0 */  49, 87, 83,131,195,  4,136, 67,  2,172, 74,136,193, 36, 15,136,
/* 0x03d0 */   3,192,233,  4,136, 75,  1, 82, 86, 83, 80, 85, 87, 86, 83,131,
/* 0x03e0 */ 236,124,139,148, 36,144,  0,  0,  0,199, 68, 36,116,  0,  0,  0,
/* 0x03f0 */   0,198, 68, 36,115,  0,139,172, 36,156,  0,  0,  0,141, 66,  4,
/* 0x0400 */ 137, 68, 36,120,184,  1,  0,  0,  0, 15,182, 74,  2,137,195,211,
/* 0x0410 */ 227,137,217, 73,137, 76, 36,108, 15,182, 74,  1,211,224, 72,137,
/* 0x0420 */  68, 36,104,139,132, 36,168,  0,  0,  0, 15,182, 50,199, 69,  0,
/* 0x0430 */   0,  0,  0,  0,199, 68, 36, 96,  0,  0,  0,  0,199,  0,  0,  0,
/* 0x0440 */   0,  0,184,  0,  3,  0,  0,137,116, 36,100,199, 68, 36, 92,  1,
/* 0x0450 */   0,  0,  0,199, 68, 36, 88,  1,  0,  0,  0,199, 68, 36, 84,  1,
/* 0x0460 */   0,  0,  0,199, 68, 36, 80,  1,  0,  0,  0, 15,182, 74,  1,  1,
/* 0x0470 */ 241,211,224,141,136, 54,  7,  0,  0, 57, 76, 36,116,115, 14,139,
/* 0x0480 */  68, 36,120,102,199,  0,  0,  4,131,192,  2,226,246,139,156, 36,
/* 0x0490 */ 148,  0,  0,  0, 49,255,199, 68, 36, 72,255,255,255,255,137,218,
/* 0x04a0 */   3,148, 36,152,  0,  0,  0,137, 84, 36, 76, 49,210, 59, 92, 36,
/* 0x04b0 */  76, 15,132,124,  9,  0,  0, 15,182,  3,193,231,  8, 66, 67,  9,
/* 0x04c0 */ 199,131,250,  4,126,231,139,140, 36,164,  0,  0,  0, 57, 76, 36,
/* 0x04d0 */ 116, 15,131,100,  9,  0,  0,139,116, 36,116, 35,116, 36,108,139,
/* 0x04e0 */  68, 36, 96,139, 84, 36,120,193,224,  4,137,116, 36, 68,  1,240,
/* 0x04f0 */ 129,124, 36, 72,255,255,255,  0,141, 44, 66,119, 24, 59, 92, 36,
/* 0x0500 */  76, 15,132, 44,  9,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,
/* 0x0510 */ 231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,232, 11,
/* 0x0520 */  15,183,202, 15,175,193, 57,199, 15,131,221,  1,  0,  0,137, 68,
/* 0x0530 */  36, 72,184,  0,  8,  0,  0, 41,200,138, 76, 36,100,193,248,  5,
/* 0x0540 */ 190,  1,  0,  0,  0,141,  4,  2, 15,182, 84, 36,115,102,137, 69,
/* 0x0550 */   0,139, 68, 36,116, 35, 68, 36,104,139,108, 36,120,211,224,185,
/* 0x0560 */   8,  0,  0,  0, 43, 76, 36,100,211,250,  1,208,105,192,  0,  6,
/* 0x0570 */   0,  0,131,124, 36, 96,  6,141,132,  5,108, 14,  0,  0,137, 68,
/* 0x0580 */  36, 20, 15,142,202,  0,  0,  0,139, 68, 36,116, 43, 68, 36, 92,
/* 0x0590 */ 139,148, 36,160,  0,  0,  0, 15,182,  4,  2,137, 68, 36, 64,209,
/* 0x05a0 */ 100, 36, 64,139, 76, 36, 64,141, 20, 54,139,108, 36, 20,129,225,
/* 0x05b0 */   0,  1,  0,  0,129,124, 36, 72,255,255,255,  0,141, 68, 77,  0,
/* 0x05c0 */ 137, 76, 36, 60,141, 44, 16,119, 24, 59, 92, 36, 76, 15,132, 96,
/* 0x05d0 */   8,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,
/* 0x05e0 */ 199,139, 68, 36, 72,102,139,141,  0,  2,  0,  0,193,232, 11, 15,
/* 0x05f0 */ 183,241, 15,175,198, 57,199,115, 35,137, 68, 36, 72,184,  0,  8,
/* 0x0600 */   0,  0, 41,240,137,214,193,248,  5,131,124, 36, 60,  0,141,  4,
/* 0x0610 */   1,102,137,133,  0,  2,  0,  0,116, 34,235, 46, 41, 68, 36, 72,
/* 0x0620 */  41,199,137,200,141,114,  1,102,193,232,  5,102, 41,193,131,124,
/* 0x0630 */  36, 60,  0,102,137,141,  0,  2,  0,  0,116, 14,129,254,255,  0,
/* 0x0640 */   0,  0, 15,142, 87,255,255,255,235,121,129,254,255,  0,  0,  0,
/* 0x0650 */ 127,113,141, 20, 54,139,108, 36, 20,  1,213,129,124, 36, 72,255,
/* 0x0660 */ 255,255,  0,119, 24, 59, 92, 36, 76, 15,132,196,  7,  0,  0,193,
/* 0x0670 */ 100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,
/* 0x0680 */  72,102,139, 77,  0,193,232, 11, 15,183,241, 15,175,198, 57,199,
/* 0x0690 */ 115, 25,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,
/* 0x06a0 */ 248,  5,141,  4,  1,102,137, 69,  0,235,159, 41, 68, 36, 72, 41,
/* 0x06b0 */ 199,137,200,141,114,  1,102,193,232,  5,102, 41,193,102,137, 77,
/* 0x06c0 */   0,235,135,139, 84, 36,116,137,240,139,140, 36,160,  0,  0,  0,
/* 0x06d0 */ 136, 68, 36,115,136,  4, 10, 66,131,124, 36, 96,  3,137, 84, 36,
/* 0x06e0 */ 116,127, 13,199, 68, 36, 96,  0,  0,  0,  0,233, 27,  7,  0,  0,
/* 0x06f0 */ 131,124, 36, 96,  9,127, 10,131,108, 36, 96,  3,233, 10,  7,  0,
/* 0x0700 */   0,131,108, 36, 96,  6,233,  0,  7,  0,  0,139, 76, 36, 72, 41,
/* 0x0710 */ 199,139,116, 36, 96, 41,193,137,208,102,193,232,  5,102, 41,194,
/* 0x0720 */ 129,249,255,255,255,  0,102,137, 85,  0,139,108, 36,120,141,116,
/* 0x0730 */ 117,  0,137,116, 36, 56,119, 22, 59, 92, 36, 76, 15,132,241,  6,
/* 0x0740 */   0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,199,139,108,
/* 0x0750 */  36, 56,137,200,193,232, 11,102,139,149,128,  1,  0,  0, 15,183,
/* 0x0760 */ 234, 15,175,197, 57,199,115, 82,137,198,184,  0,  8,  0,  0, 41,
/* 0x0770 */ 232,139,108, 36, 88,193,248,  5,139, 76, 36, 84,141,  4,  2,139,
/* 0x0780 */  84, 36, 56,137, 76, 36, 80,139, 76, 36,120,102,137,130,128,  1,
/* 0x0790 */   0,  0,139, 68, 36, 92,137,108, 36, 84,137, 68, 36, 88, 49,192,
/* 0x07a0 */ 131,124, 36, 96,  6, 15,159,192,129,193,100,  6,  0,  0,141,  4,
/* 0x07b0 */  64,137, 68, 36, 96,233,116,  2,  0,  0,137,206, 41,199, 41,198,
/* 0x07c0 */ 137,208,102,193,232,  5,139, 76, 36, 56,102, 41,194,129,254,255,
/* 0x07d0 */ 255,255,  0,102,137,145,128,  1,  0,  0,119, 22, 59, 92, 36, 76,
/* 0x07e0 */  15,132, 77,  6,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,
/* 0x07f0 */   9,199,139,108, 36, 56,137,242,193,234, 11,102,139,141,152,  1,
/* 0x0800 */   0,  0, 15,183,193, 15,175,208, 57,215, 15,131,227,  0,  0,  0,
/* 0x0810 */ 189,  0,  8,  0,  0,137,214, 41,197,199, 68, 36, 52,  0,  8,  0,
/* 0x0820 */   0,137,232,193,248,  5,141,  4,  1,139, 76, 36, 56,102,137,129,
/* 0x0830 */ 152,  1,  0,  0,139, 68, 36, 96,139, 76, 36, 68,193,224,  5,  3,
/* 0x0840 */  68, 36,120,129,250,255,255,255,  0,141, 44, 72,119, 22, 59, 92,
/* 0x0850 */  36, 76, 15,132,219,  5,  0,  0, 15,182,  3,193,231,  8,193,230,
/* 0x0860 */   8, 67,  9,199,102,139,149,224,  1,  0,  0,137,240,193,232, 11,
/* 0x0870 */  15,183,202, 15,175,193, 57,199,115, 96, 41, 76, 36, 52,193,124,
/* 0x0880 */  36, 52,  5,139,116, 36, 52,137, 68, 36, 72,131,124, 36,116,  0,
/* 0x0890 */ 141,  4, 50,102,137,133,224,  1,  0,  0, 15,132,147,  5,  0,  0,
/* 0x08a0 */  49,192,131,124, 36, 96,  6,139,172, 36,160,  0,  0,  0,139, 84,
/* 0x08b0 */  36,116, 15,159,192,141, 68,  0,  9,137, 68, 36, 96,139, 68, 36,
/* 0x08c0 */ 116, 43, 68, 36, 92,138, 68,  5,  0,136, 68, 36,115,136,  4, 42,
/* 0x08d0 */  66,137, 84, 36,116,233, 49,  5,  0,  0, 41,198, 41,199,137,208,
/* 0x08e0 */ 102,193,232,  5,102, 41,194,102,137,149,224,  1,  0,  0,233, 31,
/* 0x08f0 */   1,  0,  0,137,200, 41,214,102,193,232,  5,139,108, 36, 56,102,
/* 0x0900 */  41,193, 41,215,129,254,255,255,255,  0,102,137,141,152,  1,  0,
/* 0x0910 */   0,119, 22, 59, 92, 36, 76, 15,132, 22,  5,  0,  0, 15,182,  3,
/* 0x0920 */ 193,231,  8,193,230,  8, 67,  9,199,139, 76, 36, 56,137,240,193,
/* 0x0930 */ 232, 11,102,139,145,176,  1,  0,  0, 15,183,202, 15,175,193, 57,
/* 0x0940 */ 199,115, 35,137,198,184,  0,  8,  0,  0, 41,200,139,108, 36, 56,
/* 0x0950 */ 193,248,  5,141,  4,  2,102,137,133,176,  1,  0,  0,139, 68, 36,
/* 0x0960 */  88,233,160,  0,  0,  0,137,241, 41,199, 41,193,137,208,102,193,
/* 0x0970 */ 232,  5,102, 41,194,139, 68, 36, 56,129,249,255,255,255,  0,102,
/* 0x0980 */ 137,144,176,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132,161,  4,
/* 0x0990 */   0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,199,139,116,
/* 0x09a0 */  36, 56,137,200,193,232, 11,102,139,150,200,  1,  0,  0, 15,183,
/* 0x09b0 */ 234, 15,175,197, 57,199,115, 32,137,198,184,  0,  8,  0,  0, 41,
/* 0x09c0 */ 232,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,200,  1,
/* 0x09d0 */   0,  0,139, 68, 36, 84,235, 38,137,206, 41,199, 41,198,137,208,
/* 0x09e0 */ 102,193,232,  5,102, 41,194,139, 68, 36, 56,102,137,144,200,  1,
/* 0x09f0 */   0,  0,139, 84, 36, 84,139, 68, 36, 80,137, 84, 36, 80,139, 76,
/* 0x0a00 */  36, 88,137, 76, 36, 84,139,108, 36, 92,137, 68, 36, 92,137,108,
/* 0x0a10 */  36, 88, 49,192,131,124, 36, 96,  6,139, 76, 36,120, 15,159,192,
/* 0x0a20 */ 129,193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36, 96,129,254,
/* 0x0a30 */ 255,255,255,  0,119, 22, 59, 92, 36, 76, 15,132,243,  3,  0,  0,
/* 0x0a40 */  15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139, 17,137,
/* 0x0a50 */ 240,193,232, 11, 15,183,234, 15,175,197, 57,199,115, 47,137, 68,
/* 0x0a60 */  36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,
/* 0x0a70 */   5,199, 68, 36, 44,  0,  0,  0,  0,141,  4,  2,102,137,  1,139,
/* 0x0a80 */  68, 36, 68,141, 76,  1,  4,137, 76, 36, 16,235,114, 41,198, 41,
/* 0x0a90 */ 199,137,208,102,193,232,  5,102, 41,194,129,254,255,255,255,  0,
/* 0x0aa0 */ 102,137, 17,119, 22, 59, 92, 36, 76, 15,132,132,  3,  0,  0, 15,
/* 0x0ab0 */ 182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139, 81,  2,137,
/* 0x0ac0 */ 240,193,232, 11, 15,183,234, 15,175,197, 57,199,115, 59,137, 68,
/* 0x0ad0 */  36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,
/* 0x0ae0 */   5,199, 68, 36, 44,  8,  0,  0,  0,141,  4,  2,139, 84, 36, 68,
/* 0x0af0 */ 102,137, 65,  2,141,140, 17,  4,  1,  0,  0,137, 76, 36, 16,199,
/* 0x0b00 */  68, 36, 48,  3,  0,  0,  0,235, 47, 41,198, 41,199,137,208,137,
/* 0x0b10 */ 116, 36, 72,102,193,232,  5,199, 68, 36, 44, 16,  0,  0,  0,102,
/* 0x0b20 */  41,194,199, 68, 36, 48,  8,  0,  0,  0,102,137, 81,  2,129,193,
/* 0x0b30 */   4,  2,  0,  0,137, 76, 36, 16,139, 76, 36, 48,186,  1,  0,  0,
/* 0x0b40 */   0,137, 76, 36, 40,141, 44, 18,139,116, 36, 16,  1,238,129,124,
/* 0x0b50 */  36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,209,  2,
/* 0x0b60 */   0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,
/* 0x0b70 */ 139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,202, 15,175,193,
/* 0x0b80 */  57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,
/* 0x0b90 */ 248,  5,141,  4,  2,137,234,102,137,  6,235, 21, 41, 68, 36, 72,
/* 0x0ba0 */  41,199,137,208,102,193,232,  5,102, 41,194,102,137, 22,141, 85,
/* 0x0bb0 */   1,139,116, 36, 40, 78,137,116, 36, 40,117,137,138, 76, 36, 48,
/* 0x0bc0 */ 184,  1,  0,  0,  0,211,224, 41,194,  3, 84, 36, 44,131,124, 36,
/* 0x0bd0 */  96,  3,137, 84, 36, 12, 15,143,231,  1,  0,  0,131, 68, 36, 96,
/* 0x0be0 */   7,131,250,  3,137,208,126,  5,184,  3,  0,  0,  0,139,116, 36,
/* 0x0bf0 */ 120,193,224,  7,199, 68, 36, 36,  6,  0,  0,  0,141,132,  6, 96,
/* 0x0c00 */   3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,  0,141, 44,  0,139,
/* 0x0c10 */ 116, 36,  8,  1,238,129,124, 36, 72,255,255,255,  0,119, 24, 59,
/* 0x0c20 */  92, 36, 76, 15,132, 10,  2,  0,  0,193,100, 36, 72,  8, 15,182,
/* 0x0c30 */   3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,232,
/* 0x0c40 */  11, 15,183,202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,
/* 0x0c50 */   0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,  6,137,
/* 0x0c60 */ 232,235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102,
/* 0x0c70 */  41,194,141, 69,  1,102,137, 22,139,108, 36, 36, 77,137,108, 36,
/* 0x0c80 */  36,117,137,141, 80,192,131,250,  3,137, 20, 36, 15,142, 39,  1,
/* 0x0c90 */   0,  0,137,208,137,214,209,248,131,230,  1,141, 72,255,131,206,
/* 0x0ca0 */   2,131,250, 13,137, 76, 36, 32,127, 28,139,108, 36,120,211,230,
/* 0x0cb0 */   1,210,137, 52, 36,141, 68,117,  0, 41,208,  5, 94,  5,  0,  0,
/* 0x0cc0 */ 137, 68, 36,  4,235, 86,141, 80,251,129,124, 36, 72,255,255,255,
/* 0x0cd0 */   0,119, 24, 59, 92, 36, 76, 15,132, 86,  1,  0,  0,193,100, 36,
/* 0x0ce0 */  72,  8, 15,182,  3,193,231,  8, 67,  9,199,209,108, 36, 72,  1,
/* 0x0cf0 */ 246, 59,124, 36, 72,114,  7, 43,124, 36, 72,131,206,  1, 74,117,
/* 0x0d00 */ 200,139, 68, 36,120,193,230,  4,137, 52, 36,  5, 68,  6,  0,  0,
/* 0x0d10 */ 199, 68, 36, 32,  4,  0,  0,  0,137, 68, 36,  4,199, 68, 36, 28,
/* 0x0d20 */   1,  0,  0,  0,184,  1,  0,  0,  0,139,108, 36,  4,  1,192,137,
/* 0x0d30 */  68, 36, 24,  1,197,129,124, 36, 72,255,255,255,  0,119, 24, 59,
/* 0x0d40 */  92, 36, 76, 15,132,234,  0,  0,  0,193,100, 36, 72,  8, 15,182,
/* 0x0d50 */   3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,
/* 0x0d60 */ 232, 11, 15,183,242, 15,175,198, 57,199,115, 27,137, 68, 36, 72,
/* 0x0d70 */ 184,  0,  8,  0,  0, 41,240,193,248,  5,141,  4,  2,102,137, 69,
/* 0x0d80 */   0,139, 68, 36, 24,235, 31, 41, 68, 36, 72, 41,199,137,208,102,
/* 0x0d90 */ 193,232,  5,102, 41,194,139, 68, 36, 24,102,137, 85,  0,139, 84,
/* 0x0da0 */  36, 28, 64,  9, 20, 36,139, 76, 36, 32,209,100, 36, 28, 73,137,
/* 0x0db0 */  76, 36, 32, 15,133,112,255,255,255,139, 52, 36, 70,137,116, 36,
/* 0x0dc0 */  92,116, 89,139, 76, 36, 12,139,108, 36,116,131,193,  2, 57,108,
/* 0x0dd0 */  36, 92,119, 95,139,132, 36,160,  0,  0,  0,137,234, 43, 68, 36,
/* 0x0de0 */  92,  3,148, 36,160,  0,  0,  0,141, 52, 40,138,  6, 70,136, 68,
/* 0x0df0 */  36,115,136,  2, 66,255, 68, 36,116, 73,116, 15,139,172, 36,164,
/* 0x0e00 */   0,  0,  0, 57,108, 36,116,114,226,235, 17,139,132, 36,164,  0,
/* 0x0e10 */   0,  0, 57, 68, 36,116, 15,130,187,246,255,255,129,124, 36, 72,
/* 0x0e20 */ 255,255,255,  0,119, 21, 59, 92, 36, 76,184,  1,  0,  0,  0,116,
/* 0x0e30 */  41,235,  7,184,  1,  0,  0,  0,235, 32, 67, 43,156, 36,148,  0,
/* 0x0e40 */   0,  0, 49,192,139,148, 36,156,  0,  0,  0,139, 76, 36,116,137,
/* 0x0e50 */  26,139,156, 36,168,  0,  0,  0,137, 11,131,196,124, 91, 94, 95,
/* 0x0e60 */  93, 85, 87, 86, 83,131,236,124,139,148, 36,144,  0,  0,  0,199,
/* 0x0e70 */  68, 36,116,  0,  0,  0,  0,198, 68, 36,115,  0,139,172, 36,156,
/* 0x0e80 */   0,  0,  0,141, 66,  4,137, 68, 36,120,184,  1,  0,  0,  0, 15,
/* 0x0e90 */ 182, 74,  2,137,195,211,227,137,217, 73,137, 76, 36,108, 15,182,
/* 0x0ea0 */  74,  1,211,224, 72,137, 68, 36,104,139,132, 36,168,  0,  0,  0,
/* 0x0eb0 */  15,182, 50,199, 69,  0,  0,  0,  0,  0,199, 68, 36, 96,  0,  0,
/* 0x0ec0 */   0,  0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,137,116, 36,
/* 0x0ed0 */ 100,199, 68, 36, 92,  1,  0,  0,  0,199, 68, 36, 88,  1,  0,  0,
/* 0x0ee0 */   0,199, 68, 36, 84,  1,  0,  0,  0,199, 68, 36, 80,  1,  0,  0,
/* 0x0ef0 */   0, 15,182, 74,  1,  1,241,211,224,141,136, 54,  7,  0,  0, 57,
/* 0x0f00 */  76, 36,116,115, 14,139, 68, 36,120,102,199,  0,  0,  4,131,192,
/* 0x0f10 */   2,226,246,139,156, 36,148,  0,  0,  0, 49,255,199, 68, 36, 72,
/* 0x0f20 */ 255,255,255,255,137,218,  3,148, 36,152,  0,  0,  0,137, 84, 36,
/* 0x0f30 */  76, 49,210, 59, 92, 36, 76, 15,132,124,  9,  0,  0, 15,182,  3,
/* 0x0f40 */ 193,231,  8, 66, 67,  9,199,131,250,  4,126,231,139,140, 36,164,
/* 0x0f50 */   0,  0,  0, 57, 76, 36,116, 15,131,100,  9,  0,  0,139,116, 36,
/* 0x0f60 */ 116, 35,116, 36,108,139, 68, 36, 96,139, 84, 36,120,193,224,  4,
/* 0x0f70 */ 137,116, 36, 68,  1,240,129,124, 36, 72,255,255,255,  0,141, 44,
/* 0x0f80 */  66,119, 24, 59, 92, 36, 76, 15,132, 44,  9,  0,  0,193,100, 36,
/* 0x0f90 */  72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,
/* 0x0fa0 */ 139, 85,  0,193,232, 11, 15,183,202, 15,175,193, 57,199, 15,131,
/* 0x0fb0 */ 221,  1,  0,  0,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,138,
/* 0x0fc0 */  76, 36,100,193,248,  5,190,  1,  0,  0,  0,141,  4,  2, 15,182,
/* 0x0fd0 */  84, 36,115,102,137, 69,  0,139, 68, 36,116, 35, 68, 36,104,139,
/* 0x0fe0 */ 108, 36,120,211,224,185,  8,  0,  0,  0, 43, 76, 36,100,211,250,
/* 0x0ff0 */   1,208,105,192,  0,  6,  0,  0,131,124, 36, 96,  6,141,132,  5,
/* 0x1000 */ 108, 14,  0,  0,137, 68, 36, 20, 15,142,202,  0,  0,  0,139, 68,
/* 0x1010 */  36,116, 43, 68, 36, 92,139,148, 36,160,  0,  0,  0, 15,182,  4,
/* 0x1020 */   2,137, 68, 36, 64,209,100, 36, 64,139, 76, 36, 64,141, 20, 54,
/* 0x1030 */ 139,108, 36, 20,129,225,  0,  1,  0,  0,129,124, 36, 72,255,255,
/* 0x1040 */ 255,  0,141, 68, 77,  0,137, 76, 36, 60,141, 44, 16,119, 24, 59,
/* 0x1050 */  92, 36, 76, 15,132, 96,  8,  0,  0,193,100, 36, 72,  8, 15,182,
/* 0x1060 */   3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139,141,  0,  2,
/* 0x1070 */   0,  0,193,232, 11, 15,183,241, 15,175,198, 57,199,115, 35,137,
/* 0x1080 */  68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,131,
/* 0x1090 */ 124, 36, 60,  0,141,  4,  1,102,137,133,  0,  2,  0,  0,116, 34,
/* 0x10a0 */ 235, 46, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,
/* 0x10b0 */   5,102, 41,193,131,124, 36, 60,  0,102,137,141,  0,  2,  0,  0,
/* 0x10c0 */ 116, 14,129,254,255,  0,  0,  0, 15,142, 87,255,255,255,235,121,
/* 0x10d0 */ 129,254,255,  0,  0,  0,127,113,141, 20, 54,139,108, 36, 20,  1,
/* 0x10e0 */ 213,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,
/* 0x10f0 */ 132,196,  7,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,
/* 0x1100 */  67,  9,199,139, 68, 36, 72,102,139, 77,  0,193,232, 11, 15,183,
/* 0x1110 */ 241, 15,175,198, 57,199,115, 25,137, 68, 36, 72,184,  0,  8,  0,
/* 0x1120 */   0, 41,240,137,214,193,248,  5,141,  4,  1,102,137, 69,  0,235,
/* 0x1130 */ 159, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,  5,
/* 0x1140 */ 102, 41,193,102,137, 77,  0,235,135,139, 84, 36,116,137,240,139,
/* 0x1150 */ 140, 36,160,  0,  0,  0,136, 68, 36,115,136,  4, 10, 66,131,124,
/* 0x1160 */  36, 96,  3,137, 84, 36,116,127, 13,199, 68, 36, 96,  0,  0,  0,
/* 0x1170 */   0,233, 27,  7,  0,  0,131,124, 36, 96,  9,127, 10,131,108, 36,
/* 0x1180 */  96,  3,233, 10,  7,  0,  0,131,108, 36, 96,  6,233,  0,  7,  0,
/* 0x1190 */   0,139, 76, 36, 72, 41,199,139,116, 36, 96, 41,193,137,208,102,
/* 0x11a0 */ 193,232,  5,102, 41,194,129,249,255,255,255,  0,102,137, 85,  0,
/* 0x11b0 */ 139,108, 36,120,141,116,117,  0,137,116, 36, 56,119, 22, 59, 92,
/* 0x11c0 */  36, 76, 15,132,241,  6,  0,  0, 15,182,  3,193,231,  8,193,225,
/* 0x11d0 */   8, 67,  9,199,139,108, 36, 56,137,200,193,232, 11,102,139,149,
/* 0x11e0 */ 128,  1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 82,137,198,
/* 0x11f0 */ 184,  0,  8,  0,  0, 41,232,139,108, 36, 88,193,248,  5,139, 76,
/* 0x1200 */  36, 84,141,  4,  2,139, 84, 36, 56,137, 76, 36, 80,139, 76, 36,
/* 0x1210 */ 120,102,137,130,128,  1,  0,  0,139, 68, 36, 92,137,108, 36, 84,
/* 0x1220 */ 137, 68, 36, 88, 49,192,131,124, 36, 96,  6, 15,159,192,129,193,
/* 0x1230 */ 100,  6,  0,  0,141,  4, 64,137, 68, 36, 96,233,116,  2,  0,  0,
/* 0x1240 */ 137,206, 41,199, 41,198,137,208,102,193,232,  5,139, 76, 36, 56,
/* 0x1250 */ 102, 41,194,129,254,255,255,255,  0,102,137,145,128,  1,  0,  0,
/* 0x1260 */ 119, 22, 59, 92, 36, 76, 15,132, 77,  6,  0,  0, 15,182,  3,193,
/* 0x1270 */ 231,  8,193,230,  8, 67,  9,199,139,108, 36, 56,137,242,193,234,
/* 0x1280 */  11,102,139,141,152,  1,  0,  0, 15,183,193, 15,175,208, 57,215,
/* 0x1290 */  15,131,227,  0,  0,  0,189,  0,  8,  0,  0,137,214, 41,197,199,
/* 0x12a0 */  68, 36, 52,  0,  8,  0,  0,137,232,193,248,  5,141,  4,  1,139,
/* 0x12b0 */  76, 36, 56,102,137,129,152,  1,  0,  0,139, 68, 36, 96,139, 76,
/* 0x12c0 */  36, 68,193,224,  5,  3, 68, 36,120,129,250,255,255,255,  0,141,
/* 0x12d0 */  44, 72,119, 22, 59, 92, 36, 76, 15,132,219,  5,  0,  0, 15,182,
/* 0x12e0 */   3,193,231,  8,193,230,  8, 67,  9,199,102,139,149,224,  1,  0,
/* 0x12f0 */   0,137,240,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 96,
/* 0x1300 */  41, 76, 36, 52,193,124, 36, 52,  5,139,116, 36, 52,137, 68, 36,
/* 0x1310 */  72,131,124, 36,116,  0,141,  4, 50,102,137,133,224,  1,  0,  0,
/* 0x1320 */  15,132,147,  5,  0,  0, 49,192,131,124, 36, 96,  6,139,172, 36,
/* 0x1330 */ 160,  0,  0,  0,139, 84, 36,116, 15,159,192,141, 68,  0,  9,137,
/* 0x1340 */  68, 36, 96,139, 68, 36,116, 43, 68, 36, 92,138, 68,  5,  0,136,
/* 0x1350 */  68, 36,115,136,  4, 42, 66,137, 84, 36,116,233, 49,  5,  0,  0,
/* 0x1360 */  41,198, 41,199,137,208,102,193,232,  5,102, 41,194,102,137,149,
/* 0x1370 */ 224,  1,  0,  0,233, 31,  1,  0,  0,137,200, 41,214,102,193,232,
/* 0x1380 */   5,139,108, 36, 56,102, 41,193, 41,215,129,254,255,255,255,  0,
/* 0x1390 */ 102,137,141,152,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 22,
/* 0x13a0 */   5,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,139,
/* 0x13b0 */  76, 36, 56,137,240,193,232, 11,102,139,145,176,  1,  0,  0, 15,
/* 0x13c0 */ 183,202, 15,175,193, 57,199,115, 35,137,198,184,  0,  8,  0,  0,
/* 0x13d0 */  41,200,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,176,
/* 0x13e0 */   1,  0,  0,139, 68, 36, 88,233,160,  0,  0,  0,137,241, 41,199,
/* 0x13f0 */  41,193,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,129,
/* 0x1400 */ 249,255,255,255,  0,102,137,144,176,  1,  0,  0,119, 22, 59, 92,
/* 0x1410 */  36, 76, 15,132,161,  4,  0,  0, 15,182,  3,193,231,  8,193,225,
/* 0x1420 */   8, 67,  9,199,139,116, 36, 56,137,200,193,232, 11,102,139,150,
/* 0x1430 */ 200,  1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 32,137,198,
/* 0x1440 */ 184,  0,  8,  0,  0, 41,232,139,108, 36, 56,193,248,  5,141,  4,
/* 0x1450 */   2,102,137,133,200,  1,  0,  0,139, 68, 36, 84,235, 38,137,206,
/* 0x1460 */  41,199, 41,198,137,208,102,193,232,  5,102, 41,194,139, 68, 36,
/* 0x1470 */  56,102,137,144,200,  1,  0,  0,139, 84, 36, 84,139, 68, 36, 80,
/* 0x1480 */ 137, 84, 36, 80,139, 76, 36, 88,137, 76, 36, 84,139,108, 36, 92,
/* 0x1490 */ 137, 68, 36, 92,137,108, 36, 88, 49,192,131,124, 36, 96,  6,139,
/* 0x14a0 */  76, 36,120, 15,159,192,129,193,104, 10,  0,  0,141, 68, 64,  8,
/* 0x14b0 */ 137, 68, 36, 96,129,254,255,255,255,  0,119, 22, 59, 92, 36, 76,
/* 0x14c0 */  15,132,243,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,
/* 0x14d0 */   9,199,102,139, 17,137,240,193,232, 11, 15,183,234, 15,175,197,
/* 0x14e0 */  57,199,115, 47,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,
/* 0x14f0 */ 100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  0,  0,  0,  0,141,
/* 0x1500 */   4,  2,102,137,  1,139, 68, 36, 68,141, 76,  1,  4,137, 76, 36,
/* 0x1510 */  16,235,114, 41,198, 41,199,137,208,102,193,232,  5,102, 41,194,
/* 0x1520 */ 129,254,255,255,255,  0,102,137, 17,119, 22, 59, 92, 36, 76, 15,
/* 0x1530 */ 132,132,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,
/* 0x1540 */ 199,102,139, 81,  2,137,240,193,232, 11, 15,183,234, 15,175,197,
/* 0x1550 */  57,199,115, 59,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,
/* 0x1560 */ 100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  8,  0,  0,  0,141,
/* 0x1570 */   4,  2,139, 84, 36, 68,102,137, 65,  2,141,140, 17,  4,  1,  0,
/* 0x1580 */   0,137, 76, 36, 16,199, 68, 36, 48,  3,  0,  0,  0,235, 47, 41,
/* 0x1590 */ 198, 41,199,137,208,137,116, 36, 72,102,193,232,  5,199, 68, 36,
/* 0x15a0 */  44, 16,  0,  0,  0,102, 41,194,199, 68, 36, 48,  8,  0,  0,  0,
/* 0x15b0 */ 102,137, 81,  2,129,193,  4,  2,  0,  0,137, 76, 36, 16,139, 76,
/* 0x15c0 */  36, 48,186,  1,  0,  0,  0,137, 76, 36, 40,141, 44, 18,139,116,
/* 0x15d0 */  36, 16,  1,238,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92,
/* 0x15e0 */  36, 76, 15,132,209,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,
/* 0x15f0 */ 193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,232, 11,
/* 0x1600 */  15,183,202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,
/* 0x1610 */   8,  0,  0, 41,200,193,248,  5,141,  4,  2,137,234,102,137,  6,
/* 0x1620 */ 235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,
/* 0x1630 */ 194,102,137, 22,141, 85,  1,139,116, 36, 40, 78,137,116, 36, 40,
/* 0x1640 */ 117,137,138, 76, 36, 48,184,  1,  0,  0,  0,211,224, 41,194,  3,
/* 0x1650 */  84, 36, 44,131,124, 36, 96,  3,137, 84, 36, 12, 15,143,231,  1,
/* 0x1660 */   0,  0,131, 68, 36, 96,  7,131,250,  3,137,208,126,  5,184,  3,
/* 0x1670 */   0,  0,  0,139,116, 36,120,193,224,  7,199, 68, 36, 36,  6,  0,
/* 0x1680 */   0,  0,141,132,  6, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,
/* 0x1690 */   0,  0,141, 44,  0,139,116, 36,  8,  1,238,129,124, 36, 72,255,
/* 0x16a0 */ 255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 10,  2,  0,  0,193,
/* 0x16b0 */ 100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,
/* 0x16c0 */  72,102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,199,115,
/* 0x16d0 */  24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,
/* 0x16e0 */   4,  2,102,137,  6,137,232,235, 21, 41, 68, 36, 72, 41,199,137,
/* 0x16f0 */ 208,102,193,232,  5,102, 41,194,141, 69,  1,102,137, 22,139,108,
/* 0x1700 */  36, 36, 77,137,108, 36, 36,117,137,141, 80,192,131,250,  3,137,
/* 0x1710 */  20, 36, 15,142, 39,  1,  0,  0,137,208,137,214,209,248,131,230,
/* 0x1720 */   1,141, 72,255,131,206,  2,131,250, 13,137, 76, 36, 32,127, 28,
/* 0x1730 */ 139,108, 36,120,211,230,  1,210,137, 52, 36,141, 68,117,  0, 41,
/* 0x1740 */ 208,  5, 94,  5,  0,  0,137, 68, 36,  4,235, 86,141, 80,251,129,
/* 0x1750 */ 124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 86,
/* 0x1760 */   1,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,
/* 0x1770 */ 199,209,108, 36, 72,  1,246, 59,124, 36, 72,114,  7, 43,124, 36,
/* 0x1780 */  72,131,206,  1, 74,117,200,139, 68, 36,120,193,230,  4,137, 52,
/* 0x1790 */  36,  5, 68,  6,  0,  0,199, 68, 36, 32,  4,  0,  0,  0,137, 68,
/* 0x17a0 */  36,  4,199, 68, 36, 28,  1,  0,  0,  0,184,  1,  0,  0,  0,139,
/* 0x17b0 */ 108, 36,  4,  1,192,137, 68, 36, 24,  1,197,129,124, 36, 72,255,
/* 0x17c0 */ 255,255,  0,119, 24, 59, 92, 36, 76, 15,132,234,  0,  0,  0,193,
/* 0x17d0 */ 100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,
/* 0x17e0 */  72,102,139, 85,  0,193,232, 11, 15,183,242, 15,175,198, 57,199,
/* 0x17f0 */ 115, 27,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,193,248,  5,
/* 0x1800 */ 141,  4,  2,102,137, 69,  0,139, 68, 36, 24,235, 31, 41, 68, 36,
/* 0x1810 */  72, 41,199,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 24,
/* 0x1820 */ 102,137, 85,  0,139, 84, 36, 28, 64,  9, 20, 36,139, 76, 36, 32,
/* 0x1830 */ 209,100, 36, 28, 73,137, 76, 36, 32, 15,133,112,255,255,255,139,
/* 0x1840 */  52, 36, 70,137,116, 36, 92,116, 89,139, 76, 36, 12,139,108, 36,
/* 0x1850 */ 116,131,193,  2, 57,108, 36, 92,119, 95,139,132, 36,160,  0,  0,
/* 0x1860 */   0,137,234, 43, 68, 36, 92,  3,148, 36,160,  0,  0,  0,141, 52,
/* 0x1870 */  40,138,  6, 70,136, 68, 36,115,136,  2, 66,255, 68, 36,116, 73,
/* 0x1880 */ 116, 15,139,172, 36,164,  0,  0,  0, 57,108, 36,116,114,226,235,
/* 0x1890 */  17,139,132, 36,164,  0,  0,  0, 57, 68, 36,116, 15,130,187,246,
/* 0x18a0 */ 255,255,129,124, 36, 72,255,255,255,  0,119, 21, 59, 92, 36, 76,
/* 0x18b0 */ 184,  1,  0,  0,  0,116, 41,235,  7,184,  1,  0,  0,  0,235, 32,
/* 0x18c0 */  67, 43,156, 36,148,  0,  0,  0, 49,192,139,148, 36,156,  0,  0,
/* 0x18d0 */   0,139, 76, 36,116,137, 26,139,156, 36,168,  0,  0,  0,137, 11,
/* 0x18e0 */ 131,196,124, 91, 94, 95, 93,  3,115,252,  3,123,248, 49,192,141,
/* 0x18f0 */ 140, 36,  0,255,255,255,137,236, 80, 57,204,117,251,137,236, 49,
/* 0x1900 */ 201, 94,141,190,  0,  0,  0,  0,137,247,185,  0,  0,  0,  0,138,
/* 0x1910 */   7, 71, 44,232, 60,  1,119,247,128, 63,  0,117,  4,139,  7,138,
/* 0x1920 */  95,  4,102,193,232,  8,134,196,193,192, 16,134,196, 41,248,128,
/* 0x1930 */ 235,232,  1,240,137,  7,131,199,  5,136,216,226,  9,185,  0,  0,
/* 0x1940 */   0,  0,176,232,176,233,242,174,117,  6,128, 63,  0,117,255,139,
/* 0x1950 */   7,102,193,232,  8,134,196,193,192, 16,134,196, 41,248,  1,240,
/* 0x1960 */ 171,235,  4,185,  0,  0,  0,  0,235, 30,138,  7,131,199,  1, 60,
/* 0x1970 */ 128,114, 10, 60,143,119,  6,128,127,254, 15,116,  5, 44,232, 60,
/* 0x1980 */   1,119,255,128, 63,  0,117,255,139,  7,102,193,232,  8,193,192,
/* 0x1990 */  16,134,196, 41,248,  1,240,137,  7,131,199,  4,131,233,  4,138,
/* 0x19a0 */   7,131,199,  1,226, 13,131,233,  1,127,  6,141,190,  0,  0,  0,
/* 0x19b0 */   0,139,  7,  9,192,116,255,139, 95,  4,141,132, 48,  0,  0,  0,
/* 0x19c0 */   0,  1,243, 80,131,199,  8,255,150,  0,  0,  0,  0,149,138,  7,
/* 0x19d0 */  71,  8,192,116,220,137,249,121,  6,122, 14,139,  7,131,199,  4,
/* 0x19e0 */ 139,132, 48,  0,  0,  0,  0,235, 14, 15,183,  7, 71, 80, 71,185,
/* 0x19f0 */  87, 72,242,174, 85,255,150,  0,  0,  0,  0,  9,192,116,  7,137,
/* 0x1a00 */   3,131,195,  4,235, 34, 97, 49,192,194, 12,  0,255,150,  0,  0,
/* 0x1a10 */   0,  0,141,190,  0,  0,  0,  0,131,199,  4,141, 94,252, 49,192,
/* 0x1a20 */ 138,  7, 71,  9,192,116,  1, 60,239,119, 17,  1,195,139,  3,134,
/* 0x1a30 */ 196,193,192, 16,134,196,  1,240,137,  3,235,226, 36, 15,193,224,
/* 0x1a40 */  16,102,139,  7,131,199,  2,  9,192,117, 12,139,  7,131,199,  4,
/* 0x1a50 */ 235, 12,135,247,141,143,  0,  0,  0,  0,169,102,  1, 12,  7,173,
/* 0x1a60 */   9,192,117,247,193,233, 16,169,102,  1, 12,  7,173,  9,192,117,
/* 0x1a70 */ 247,139,174,  0,  0,  0,  0,141,190,  0,  0,  0,  0,187,  0,  0,
/* 0x1a80 */   0,  0, 80, 84,106,  4, 83, 87,255,213,141,135,  0,  0,  0,  0,
/* 0x1a90 */ 128, 32,127,128, 96, 40,127, 88, 80, 84, 80, 83, 87,255,213, 88,
/* 0x1aa0 */  97,141, 68, 36,128,106,  0, 57,196,117,250,131,236,128, 49,192,
/* 0x1ab0 */  64,194, 12,  0,233,252,255,255,255, 85, 80, 88, 33,161,216,208,
/* 0x1ac0 */ 213,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1ad0 */   0,  0,  0,  0,  0,  0,  0,  0, 45,102,105,108,101, 32,102,111,
/* 0x1ae0 */ 114,109, 97,116, 32,101,108,102, 51, 50, 45,105, 51, 56, 54, 10,
/* 0x1af0 */  10, 83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78,
/* 0x1b00 */  97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,
/* 0x1b10 */ 101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32,
/* 0x1b20 */  32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,
/* 0x1b30 */ 111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115,
/* 0x1b40 */  10, 32, 32, 48, 32, 80, 69, 73, 83, 68, 76, 76, 49, 32, 32, 32,
/* 0x1b50 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48,
/* 0x1b60 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1b70 */  32, 48, 48, 48, 48, 48, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x1b80 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x1b90 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 80,
/* 0x1ba0 */  69, 77, 65, 73, 78, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x1bb0 */  48, 48, 48, 48, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1bc0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1bd0 */  48, 51,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1be0 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x1bf0 */  79, 78, 76, 89, 10, 32, 32, 50, 32, 80, 69, 73, 67, 79, 78, 83,
/* 0x1c00 */  49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32,
/* 0x1c10 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1c20 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 98, 32, 32, 50,
/* 0x1c30 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x1c40 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x1c50 */  32, 51, 32, 80, 69, 73, 67, 79, 78, 83, 50, 32, 32, 32, 32, 32,
/* 0x1c60 */  32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48,
/* 0x1c70 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1c80 */  48, 48, 48, 48, 48, 53, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1c90 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x1ca0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 80, 69, 84,
/* 0x1cb0 */  76, 83, 72, 65, 75, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1cc0 */  48, 48, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1cd0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 53,
/* 0x1ce0 */  98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1cf0 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1d00 */  76, 89, 10, 32, 32, 53, 32, 80, 69, 77, 65, 73, 78, 48, 50, 32,
/* 0x1d10 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32, 48,
/* 0x1d20 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d30 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 54, 53, 32, 32, 50, 42, 42,
/* 0x1d40 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x1d50 */  68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 80, 69, 77, 65, 73, 78,
/* 0x1d60 */  48, 51, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51,
/* 0x1d70 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1d80 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 54, 54, 32, 32,
/* 0x1d90 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x1da0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32, 78, 50, 66,
/* 0x1db0 */  83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1dc0 */  48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1dd0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 54,
/* 0x1de0 */  57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1df0 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1e00 */  76, 89, 10, 32, 32, 56, 32, 78, 50, 66, 70, 65, 83, 49, 48, 32,
/* 0x1e10 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48,
/* 0x1e20 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e30 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 54, 99, 32, 32, 50, 42, 42,
/* 0x1e40 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x1e50 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57,
/* 0x1e60 */  32, 78, 50, 66, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48,
/* 0x1e70 */  48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e80 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1e90 */  48, 48, 48, 54,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1ea0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1eb0 */  32, 49, 48, 32, 78, 50, 66, 68, 69, 67, 49, 48, 32, 32, 32, 32,
/* 0x1ec0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48,
/* 0x1ed0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1ee0 */  48, 48, 48, 48, 48, 48, 55, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1ef0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1f00 */  76, 89, 10, 32, 49, 49, 32, 78, 50, 66, 83, 77, 65, 50, 48, 32,
/* 0x1f10 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48,
/* 0x1f20 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f30 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 55,102, 32, 32, 50, 42, 42,
/* 0x1f40 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x1f50 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 50,
/* 0x1f60 */  32, 78, 50, 66, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x1f70 */  48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f80 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1f90 */  48, 48, 48, 56, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1fa0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x1fb0 */  65, 68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 78, 50, 66, 68, 69,
/* 0x1fc0 */  67, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1fd0 */ 100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1fe0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 56, 98, 32,
/* 0x1ff0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2000 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 52, 32, 78, 50,
/* 0x2010 */  66, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x2020 */  48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2030 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2040 */  57, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2050 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x2060 */  78, 76, 89, 10, 32, 49, 53, 32, 78, 50, 66, 70, 65, 83, 51, 48,
/* 0x2070 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32,
/* 0x2080 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2090 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 97, 53, 32, 32, 50, 42,
/* 0x20a0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x20b0 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,
/* 0x20c0 */  54, 32, 78, 50, 66, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32,
/* 0x20d0 */  48, 48, 48, 48, 48, 48, 51,101, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x20e0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x20f0 */  48, 48, 48, 48, 98, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2100 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x2110 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 55, 32, 78, 50, 66, 83,
/* 0x2120 */  77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2130 */  48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2140 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,102, 50,
/* 0x2150 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2160 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x2170 */  89, 10, 32, 49, 56, 32, 78, 50, 66, 70, 65, 83, 52, 48, 32, 32,
/* 0x2180 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48,
/* 0x2190 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x21a0 */  32, 32, 48, 48, 48, 48, 48, 48,102,102, 32, 32, 50, 42, 42, 48,
/* 0x21b0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x21c0 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 57, 32,
/* 0x21d0 */  78, 50, 66, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x21e0 */  48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x21f0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2200 */  48, 49, 48,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2210 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2220 */  50, 48, 32, 78, 50, 66, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32,
/* 0x2230 */  32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48,
/* 0x2240 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2250 */  48, 48, 48, 48, 49, 49, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2260 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x2270 */  89, 10, 32, 50, 49, 32, 78, 50, 66, 68, 69, 67, 53, 48, 32, 32,
/* 0x2280 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48,
/* 0x2290 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x22a0 */  32, 32, 48, 48, 48, 48, 48, 49, 49, 51, 32, 32, 50, 42, 42, 48,
/* 0x22b0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x22c0 */  79, 78, 76, 89, 10, 32, 50, 50, 32, 78, 50, 66, 83, 77, 65, 54,
/* 0x22d0 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101, 32,
/* 0x22e0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x22f0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 49, 99, 32, 32, 50,
/* 0x2300 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x2310 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2320 */  50, 51, 32, 78, 50, 66, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32,
/* 0x2330 */  32, 48, 48, 48, 48, 48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48,
/* 0x2340 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2350 */  48, 48, 48, 48, 49, 50, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2360 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x2370 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 52, 32, 78, 50, 66,
/* 0x2380 */  70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2390 */  48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x23a0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 52,
/* 0x23b0 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x23c0 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x23d0 */  76, 89, 10, 32, 50, 53, 32, 78, 50, 66, 68, 69, 67, 54, 48, 32,
/* 0x23e0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x23f0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2400 */  48, 32, 32, 48, 48, 48, 48, 48, 49, 53, 54, 32, 32, 50, 42, 42,
/* 0x2410 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x2420 */  68, 79, 78, 76, 89, 10, 32, 50, 54, 32, 78, 50, 68, 83, 77, 65,
/* 0x2430 */  49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51,
/* 0x2440 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2450 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 53, 54, 32, 32,
/* 0x2460 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x2470 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x2480 */  32, 50, 55, 32, 78, 50, 68, 70, 65, 83, 49, 48, 32, 32, 32, 32,
/* 0x2490 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,
/* 0x24a0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x24b0 */  48, 48, 48, 48, 48, 49, 53, 57, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x24c0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x24d0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 56, 32, 78, 50,
/* 0x24e0 */  68, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x24f0 */  48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2500 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,
/* 0x2510 */  53, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2520 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 57,
/* 0x2530 */  32, 78, 50, 68, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2540 */  48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2550 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2560 */  48, 48, 49, 54, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2570 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x2580 */  32, 51, 48, 32, 78, 50, 68, 83, 77, 65, 50, 48, 32, 32, 32, 32,
/* 0x2590 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48,
/* 0x25a0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x25b0 */  48, 48, 48, 48, 48, 49, 54, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x25c0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x25d0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 49, 32, 78, 50,
/* 0x25e0 */  68, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x25f0 */  48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2600 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,
/* 0x2610 */  55, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2620 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x2630 */  78, 76, 89, 10, 32, 51, 50, 32, 78, 50, 68, 68, 69, 67, 50, 48,
/* 0x2640 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32,
/* 0x2650 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2660 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 55, 56, 32, 32, 50, 42,
/* 0x2670 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x2680 */  65, 68, 79, 78, 76, 89, 10, 32, 51, 51, 32, 78, 50, 68, 83, 77,
/* 0x2690 */  65, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x26a0 */ 100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x26b0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 56, 53, 32,
/* 0x26c0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x26d0 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x26e0 */  10, 32, 51, 52, 32, 78, 50, 68, 70, 65, 83, 51, 48, 32, 32, 32,
/* 0x26f0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48,
/* 0x2700 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2710 */  32, 48, 48, 48, 48, 48, 49, 57, 50, 32, 32, 50, 42, 42, 48, 32,
/* 0x2720 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x2730 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 53, 32, 78,
/* 0x2740 */  50, 68, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x2750 */  48, 48, 48, 53, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2760 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2770 */  49, 97, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2780 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x2790 */  79, 78, 76, 89, 10, 32, 51, 54, 32, 78, 50, 68, 83, 77, 65, 52,
/* 0x27a0 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32,
/* 0x27b0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x27c0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,102, 51, 32, 32, 50,
/* 0x27d0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x27e0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x27f0 */  51, 55, 32, 78, 50, 68, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32,
/* 0x2800 */  32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48,
/* 0x2810 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2820 */  48, 48, 48, 48, 50, 48, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2830 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x2840 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 56, 32, 78, 50, 68,
/* 0x2850 */  83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2860 */  48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2870 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 48,
/* 0x2880 */ 102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2890 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 57, 32,
/* 0x28a0 */  78, 50, 68, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x28b0 */  48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x28c0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x28d0 */  48, 50, 49, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x28e0 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x28f0 */  52, 48, 32, 78, 50, 68, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32,
/* 0x2900 */  32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48,
/* 0x2910 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2920 */  48, 48, 48, 48, 50, 49, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2930 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x2940 */  89, 10, 32, 52, 49, 32, 78, 50, 68, 83, 77, 65, 54, 48, 32, 32,
/* 0x2950 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101, 32, 32, 48, 48,
/* 0x2960 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2970 */  32, 32, 48, 48, 48, 48, 48, 50, 49,100, 32, 32, 50, 42, 42, 48,
/* 0x2980 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x2990 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 50, 32,
/* 0x29a0 */  78, 50, 68, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x29b0 */  48, 48, 48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x29c0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x29d0 */  48, 50, 50, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x29e0 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x29f0 */  68, 79, 78, 76, 89, 10, 32, 52, 51, 32, 78, 50, 68, 70, 65, 83,
/* 0x2a00 */  54, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 54,
/* 0x2a10 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2a20 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 52, 49, 32, 32,
/* 0x2a30 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x2a40 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x2a50 */  32, 52, 52, 32, 78, 50, 68, 68, 69, 67, 54, 48, 32, 32, 32, 32,
/* 0x2a60 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2a70 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2a80 */  48, 48, 48, 48, 48, 50, 53, 55, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2a90 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2aa0 */  76, 89, 10, 32, 52, 53, 32, 78, 50, 69, 83, 77, 65, 49, 48, 32,
/* 0x2ab0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48,
/* 0x2ac0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ad0 */  48, 32, 32, 48, 48, 48, 48, 48, 50, 53, 55, 32, 32, 50, 42, 42,
/* 0x2ae0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x2af0 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 54,
/* 0x2b00 */  32, 78, 50, 69, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2b10 */  48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2b20 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2b30 */  48, 48, 50, 53, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2b40 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x2b50 */  65, 68, 79, 78, 76, 89, 10, 32, 52, 55, 32, 78, 50, 69, 70, 65,
/* 0x2b60 */  83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2b70 */  54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2b80 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 53, 99, 32,
/* 0x2b90 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2ba0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 56, 32, 78, 50,
/* 0x2bb0 */  69, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x2bc0 */  48, 48, 48, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2bd0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,
/* 0x2be0 */  54, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2bf0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 57,
/* 0x2c00 */  32, 78, 50, 69, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2c10 */  48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c20 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2c30 */  48, 48, 50, 54,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2c40 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x2c50 */  65, 68, 79, 78, 76, 89, 10, 32, 53, 48, 32, 78, 50, 69, 70, 65,
/* 0x2c60 */  83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c70 */  55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2c80 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 55, 50, 32,
/* 0x2c90 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2ca0 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x2cb0 */  10, 32, 53, 49, 32, 78, 50, 69, 68, 69, 67, 50, 48, 32, 32, 32,
/* 0x2cc0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48,
/* 0x2cd0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2ce0 */  32, 48, 48, 48, 48, 48, 50, 55, 57, 32, 32, 50, 42, 42, 48, 32,
/* 0x2cf0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x2d00 */  78, 76, 89, 10, 32, 53, 50, 32, 78, 50, 69, 83, 77, 65, 51, 48,
/* 0x2d10 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32,
/* 0x2d20 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2d30 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 56, 54, 32, 32, 50, 42,
/* 0x2d40 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x2d50 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53,
/* 0x2d60 */  51, 32, 78, 50, 69, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32,
/* 0x2d70 */  48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2d80 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2d90 */  48, 48, 48, 50, 57, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2da0 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x2db0 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 52, 32, 78, 50, 69, 68,
/* 0x2dc0 */  69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2dd0 */  53,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2de0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 97, 50,
/* 0x2df0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2e00 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x2e10 */  89, 10, 32, 53, 53, 32, 78, 50, 69, 83, 77, 65, 52, 48, 32, 32,
/* 0x2e20 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48,
/* 0x2e30 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2e40 */  32, 32, 48, 48, 48, 48, 48, 51, 48, 49, 32, 32, 50, 42, 42, 48,
/* 0x2e50 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x2e60 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 54, 32,
/* 0x2e70 */  78, 50, 69, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2e80 */  48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2e90 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2ea0 */  48, 51, 48,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2eb0 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x2ec0 */  68, 79, 78, 76, 89, 10, 32, 53, 55, 32, 78, 50, 69, 83, 77, 65,
/* 0x2ed0 */  53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x2ee0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2ef0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 49,100, 32, 32,
/* 0x2f00 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x2f10 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 56, 32, 78, 50, 69,
/* 0x2f20 */  70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2f30 */  48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2f40 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 49,
/* 0x2f50 */ 102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2f60 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 57, 32,
/* 0x2f70 */  78, 50, 69, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2f80 */  48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2f90 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2fa0 */  48, 51, 50, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2fb0 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2fc0 */  54, 48, 32, 78, 50, 69, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32,
/* 0x2fd0 */  32, 48, 48, 48, 48, 48, 48, 48,101, 32, 32, 48, 48, 48, 48, 48,
/* 0x2fe0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2ff0 */  48, 48, 48, 48, 51, 50, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3000 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x3010 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 49, 32, 78, 50, 69,
/* 0x3020 */  70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x3030 */  48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3040 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 51,
/* 0x3050 */  57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3060 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x3070 */  76, 89, 10, 32, 54, 50, 32, 78, 50, 69, 70, 65, 83, 54, 49, 32,
/* 0x3080 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 54, 32, 32, 48,
/* 0x3090 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x30a0 */  48, 32, 32, 48, 48, 48, 48, 48, 51, 52,102, 32, 32, 50, 42, 42,
/* 0x30b0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x30c0 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 51,
/* 0x30d0 */  32, 78, 50, 69, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x30e0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x30f0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3100 */  48, 48, 51, 54, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3110 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3120 */  32, 54, 52, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 32, 32,
/* 0x3130 */  32, 32, 48, 48, 48, 48, 48, 48, 50,101, 32, 32, 48, 48, 48, 48,
/* 0x3140 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3150 */  48, 48, 48, 48, 48, 51, 54, 53, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3160 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x3170 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 53, 32, 76, 90,
/* 0x3180 */  77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x3190 */  48, 48, 52, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x31a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,
/* 0x31b0 */  57, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x31c0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 54,
/* 0x31d0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48,
/* 0x31e0 */  48, 48, 48, 48, 97, 56, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x31f0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3200 */  48, 48, 51,100, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3210 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3220 */  32, 54, 55, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32,
/* 0x3230 */  32, 32, 48, 48, 48, 48, 48, 97, 56, 54, 32, 32, 48, 48, 48, 48,
/* 0x3240 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3250 */  48, 48, 48, 48, 48,101, 54, 49, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3260 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x3270 */  76, 89, 10, 32, 54, 56, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x3280 */  48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 97, 32, 32, 48,
/* 0x3290 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x32a0 */  48, 32, 32, 48, 48, 48, 48, 49, 56,101, 55, 32, 32, 50, 42, 42,
/* 0x32b0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x32c0 */  68, 79, 78, 76, 89, 10, 32, 54, 57, 32, 80, 69, 77, 65, 73, 78,
/* 0x32d0 */  49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x32e0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x32f0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 48, 49, 32, 32,
/* 0x3300 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3310 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 48, 32, 80, 69, 67,
/* 0x3320 */  84, 84, 80, 79, 83, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x3330 */  48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3340 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 48,
/* 0x3350 */  50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3360 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x3370 */  76, 89, 10, 32, 55, 49, 32, 80, 69, 67, 84, 84, 78, 85, 76, 32,
/* 0x3380 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48,
/* 0x3390 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x33a0 */  48, 32, 32, 48, 48, 48, 48, 49, 57, 48, 56, 32, 32, 50, 42, 42,
/* 0x33b0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x33c0 */  68, 79, 78, 76, 89, 10, 32, 55, 50, 32, 67, 65, 76, 76, 84, 82,
/* 0x33d0 */  48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101,
/* 0x33e0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x33f0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 48, 97, 32, 32,
/* 0x3400 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3410 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3420 */  32, 55, 51, 32, 67, 84, 67, 76, 69, 86, 69, 49, 32, 32, 32, 32,
/* 0x3430 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48,
/* 0x3440 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3450 */  48, 48, 48, 48, 49, 57, 49, 56, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3460 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x3470 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 52, 32, 67, 65,
/* 0x3480 */  76, 76, 84, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x3490 */  48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x34a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,
/* 0x34b0 */  49,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x34c0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 53,
/* 0x34d0 */  32, 67, 84, 66, 83, 72, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48,
/* 0x34e0 */  48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x34f0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3500 */  48, 49, 57, 50, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3510 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3520 */  32, 55, 54, 32, 67, 84, 66, 82, 79, 82, 48, 49, 32, 32, 32, 32,
/* 0x3530 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,
/* 0x3540 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3550 */  48, 48, 48, 48, 49, 57, 50, 54, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3560 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x3570 */  76, 89, 10, 32, 55, 55, 32, 67, 84, 66, 83, 87, 65, 48, 49, 32,
/* 0x3580 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48,
/* 0x3590 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x35a0 */  48, 32, 32, 48, 48, 48, 48, 49, 57, 50, 56, 32, 32, 50, 42, 42,
/* 0x35b0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x35c0 */  68, 79, 78, 76, 89, 10, 32, 55, 56, 32, 67, 65, 76, 76, 84, 82,
/* 0x35d0 */  48, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 48,
/* 0x35e0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x35f0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 50,100, 32, 32,
/* 0x3600 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3610 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3620 */  32, 55, 57, 32, 67, 65, 76, 76, 84, 82, 49, 48, 32, 32, 32, 32,
/* 0x3630 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48,
/* 0x3640 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3650 */  48, 48, 48, 48, 49, 57, 51,100, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3660 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x3670 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 48, 32, 67, 65,
/* 0x3680 */  76, 76, 84, 82, 69, 56, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x3690 */  48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x36a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,
/* 0x36b0 */  52, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x36c0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 49,
/* 0x36d0 */  32, 67, 65, 76, 76, 84, 82, 69, 57, 32, 32, 32, 32, 32, 32, 48,
/* 0x36e0 */  48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x36f0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3700 */  48, 49, 57, 52, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3710 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3720 */  32, 56, 50, 32, 67, 65, 76, 76, 84, 82, 49, 49, 32, 32, 32, 32,
/* 0x3730 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48,
/* 0x3740 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3750 */  48, 48, 48, 48, 49, 57, 52, 54, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3760 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x3770 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 51, 32, 67, 84,
/* 0x3780 */  67, 76, 69, 86, 69, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x3790 */  48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x37a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,
/* 0x37b0 */  52, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x37c0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x37d0 */  78, 76, 89, 10, 32, 56, 52, 32, 67, 65, 76, 76, 84, 82, 49, 50,
/* 0x37e0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,
/* 0x37f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3800 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 52,102, 32, 32, 50, 42,
/* 0x3810 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x3820 */  65, 68, 79, 78, 76, 89, 10, 32, 56, 53, 32, 67, 84, 66, 83, 72,
/* 0x3830 */  82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3840 */  52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3850 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 53, 49, 32,
/* 0x3860 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x3870 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 54, 32, 67, 84,
/* 0x3880 */  66, 82, 79, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x3890 */  48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x38a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,
/* 0x38b0 */  53, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x38c0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 55,
/* 0x38d0 */  32, 67, 84, 66, 83, 87, 65, 49, 49, 32, 32, 32, 32, 32, 32, 48,
/* 0x38e0 */  48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x38f0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3900 */  48, 49, 57, 53, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3910 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3920 */  32, 56, 56, 32, 67, 65, 76, 76, 84, 82, 49, 51, 32, 32, 32, 32,
/* 0x3930 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48,
/* 0x3940 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3950 */  48, 48, 48, 48, 49, 57, 53, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3960 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x3970 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 57, 32, 99,116,
/* 0x3980 */ 111,107, 51, 50, 46, 48, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x3990 */  48, 48, 48, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x39a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,
/* 0x39b0 */  54, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x39c0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x39d0 */  78, 76, 89, 10, 32, 57, 48, 32, 99,116,111,107, 51, 50, 46, 49,
/* 0x39e0 */  48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101, 32, 32,
/* 0x39f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3a00 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 54,102, 32, 32, 50, 42,
/* 0x3a10 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x3a20 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57,
/* 0x3a30 */  49, 32, 99,116,111,107, 51, 50, 46, 50, 48, 32, 32, 32, 32, 32,
/* 0x3a40 */  48, 48, 48, 48, 48, 48, 50, 50, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3a50 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3a60 */  48, 48, 49, 57, 55,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3a70 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x3a80 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 50, 32, 99,116,111,107,
/* 0x3a90 */  51, 50, 46, 51, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3aa0 */  48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3ab0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 57,102,
/* 0x3ac0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3ad0 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x3ae0 */  89, 10, 32, 57, 51, 32, 99,116,111,107, 51, 50, 46, 52, 48, 32,
/* 0x3af0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48,
/* 0x3b00 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b10 */  32, 32, 48, 48, 48, 48, 49, 57, 97, 54, 32, 32, 50, 42, 42, 48,
/* 0x3b20 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x3b30 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 52, 32,
/* 0x3b40 */  80, 69, 73, 77, 80, 79, 82, 84, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x3b50 */  48, 48, 48, 48, 50, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b60 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3b70 */  49, 57, 97, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3b80 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x3b90 */  68, 79, 78, 76, 89, 10, 32, 57, 53, 32, 80, 69, 73, 66, 89, 79,
/* 0x3ba0 */  82, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x3bb0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3bc0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,100, 55, 32, 32,
/* 0x3bd0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3be0 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3bf0 */  32, 57, 54, 32, 80, 69, 75, 51, 50, 79, 82, 68, 32, 32, 32, 32,
/* 0x3c00 */  32, 32, 48, 48, 48, 48, 48, 48, 49, 48, 32, 32, 48, 48, 48, 48,
/* 0x3c10 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3c20 */  48, 48, 48, 48, 49, 57,100, 57, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3c30 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x3c40 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 55, 32, 80, 69,
/* 0x3c50 */  73, 77, 79, 82, 68, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x3c60 */  48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3c70 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,
/* 0x3c80 */ 101, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3c90 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 56,
/* 0x3ca0 */  32, 80, 69, 73, 77, 80, 79, 82, 50, 32, 32, 32, 32, 32, 32, 48,
/* 0x3cb0 */  48, 48, 48, 48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3cc0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3cd0 */  48, 49, 57,102, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3ce0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x3cf0 */  65, 68, 79, 78, 76, 89, 10, 32, 57, 57, 32, 80, 69, 73, 69, 82,
/* 0x3d00 */  68, 76, 76, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d10 */  54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3d20 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 48, 54, 32,
/* 0x3d30 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x3d40 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 48, 32, 80, 69,
/* 0x3d50 */  73, 69, 82, 69, 88, 69, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x3d60 */  48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3d70 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,
/* 0x3d80 */  48, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3d90 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x3da0 */  78, 76, 89, 10, 49, 48, 49, 32, 80, 69, 73, 77, 68, 79, 78, 69,
/* 0x3db0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3dc0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3dd0 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 49, 50, 32, 32, 50, 42,
/* 0x3de0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x3df0 */  65, 68, 79, 78, 76, 89, 10, 49, 48, 50, 32, 80, 69, 82, 69, 76,
/* 0x3e00 */  79, 67, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e10 */  54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3e20 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 49, 50, 32,
/* 0x3e30 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x3e40 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x3e50 */  10, 49, 48, 51, 32, 80, 69, 82, 69, 76, 79, 67, 50, 32, 32, 32,
/* 0x3e60 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48,
/* 0x3e70 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3e80 */  32, 48, 48, 48, 48, 49, 97, 49, 56, 32, 32, 50, 42, 42, 48, 32,
/* 0x3e90 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x3ea0 */  78, 76, 89, 10, 49, 48, 52, 32, 80, 69, 82, 69, 76, 79, 67, 51,
/* 0x3eb0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32,
/* 0x3ec0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3ed0 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 49, 98, 32, 32, 50, 42,
/* 0x3ee0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x3ef0 */  65, 68, 79, 78, 76, 89, 10, 49, 48, 53, 32, 82, 69, 76, 79, 67,
/* 0x3f00 */  51, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50,
/* 0x3f10 */  57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3f20 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 49,101, 32,
/* 0x3f30 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x3f40 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x3f50 */  10, 49, 48, 54, 32, 82, 69, 76, 51, 50, 66, 73, 71, 32, 32, 32,
/* 0x3f60 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48,
/* 0x3f70 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3f80 */  32, 48, 48, 48, 48, 49, 97, 52, 55, 32, 32, 50, 42, 42, 48, 32,
/* 0x3f90 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x3fa0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 55, 32, 82,
/* 0x3fb0 */  69, 76, 79, 67, 51, 50, 74, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x3fc0 */  48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3fd0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x3fe0 */  97, 53, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3ff0 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x4000 */  79, 78, 76, 89, 10, 49, 48, 56, 32, 82, 69, 76, 51, 50, 69, 78,
/* 0x4010 */  68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4020 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x4030 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 53, 50, 32, 32, 50,
/* 0x4040 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x4050 */  69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 57, 32, 80, 69, 82, 76,
/* 0x4060 */  79, 72, 73, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x4070 */  48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x4080 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 53, 50,
/* 0x4090 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x40a0 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x40b0 */  89, 10, 49, 49, 48, 32, 80, 69, 82, 69, 76, 76, 79, 48, 32, 32,
/* 0x40c0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 97, 32, 32, 48, 48,
/* 0x40d0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x40e0 */  32, 32, 48, 48, 48, 48, 49, 97, 53, 97, 32, 32, 50, 42, 42, 48,
/* 0x40f0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x4100 */  79, 78, 76, 89, 10, 49, 49, 49, 32, 80, 69, 82, 69, 76, 72, 73,
/* 0x4110 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32,
/* 0x4120 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x4130 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 54, 52, 32, 32, 50,
/* 0x4140 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x4150 */  69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 50, 32, 80, 69, 68, 69,
/* 0x4160 */  80, 72, 65, 75, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x4170 */  50,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x4180 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 55, 49,
/* 0x4190 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x41a0 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x41b0 */  89, 10, 49, 49, 51, 32, 80, 69, 77, 65, 73, 78, 50, 48, 32, 32,
/* 0x41c0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48,
/* 0x41d0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x41e0 */  32, 32, 48, 48, 48, 48, 49, 97, 97, 48, 32, 32, 50, 42, 42, 48,
/* 0x41f0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x4200 */  79, 78, 76, 89, 10, 49, 49, 52, 32, 67, 76, 69, 65, 82, 83, 84,
/* 0x4210 */  65, 67, 75, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32,
/* 0x4220 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x4230 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 97, 49, 32, 32, 50,
/* 0x4240 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x4250 */  69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 53, 32, 80, 69, 77, 65,
/* 0x4260 */  73, 78, 50, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x4270 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x4280 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 97,101,
/* 0x4290 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x42a0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 54, 32, 80,
/* 0x42b0 */  69, 82, 69, 84, 85, 82, 78, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x42c0 */  48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x42d0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x42e0 */  97, 97,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x42f0 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49,
/* 0x4300 */  55, 32, 80, 69, 68, 79, 74, 85, 77, 80, 32, 32, 32, 32, 32, 32,
/* 0x4310 */  48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x4320 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x4330 */  48, 48, 49, 97, 98, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x4340 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x4350 */  69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 56, 32, 85, 80, 88, 49,
/* 0x4360 */  72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x4370 */  50, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x4380 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 98, 57,
/* 0x4390 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x43a0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66, 79,
/* 0x43b0 */  76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x43c0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65,
/* 0x43d0 */  49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83,
/* 0x43e0 */  77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x43f0 */  32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 49, 49,  9, 48,
/* 0x4400 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 49, 49,
/* 0x4410 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4420 */  32, 32, 78, 50, 66, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48,
/* 0x4430 */  48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x4440 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x4450 */  66, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4460 */  78, 50, 66, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4470 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67,
/* 0x4480 */  51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 68,
/* 0x4490 */  69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x44a0 */  32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 53, 48,  9, 48,
/* 0x44b0 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 53, 48,
/* 0x44c0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x44d0 */  32, 32, 78, 50, 66, 70, 65, 83, 54, 49,  9, 48, 48, 48, 48, 48,
/* 0x44e0 */  48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 54, 49, 10, 48, 48, 48,
/* 0x44f0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x4500 */  66, 68, 69, 67, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4510 */  78, 50, 66, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4520 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65,
/* 0x4530 */  49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83,
/* 0x4540 */  77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4550 */  32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 49, 49,  9, 48,
/* 0x4560 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 49, 49,
/* 0x4570 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4580 */  32, 32, 78, 50, 68, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48,
/* 0x4590 */  48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x45a0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x45b0 */  68, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x45c0 */  78, 50, 68, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x45d0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67,
/* 0x45e0 */  51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 68,
/* 0x45f0 */  69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4600 */  32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 53, 48,  9, 48,
/* 0x4610 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 53, 48,
/* 0x4620 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4630 */  32, 32, 78, 50, 68, 70, 65, 83, 54, 49,  9, 48, 48, 48, 48, 48,
/* 0x4640 */  48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 54, 49, 10, 48, 48, 48,
/* 0x4650 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x4660 */  68, 68, 69, 67, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4670 */  78, 50, 68, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4680 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65,
/* 0x4690 */  49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83,
/* 0x46a0 */  77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x46b0 */  32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 49, 49,  9, 48,
/* 0x46c0 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 49, 49,
/* 0x46d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x46e0 */  32, 32, 78, 50, 69, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48,
/* 0x46f0 */  48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x4700 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x4710 */  69, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4720 */  78, 50, 69, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4730 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67,
/* 0x4740 */  51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 68,
/* 0x4750 */  69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4760 */  32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 53, 48,  9, 48,
/* 0x4770 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 53, 48,
/* 0x4780 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4790 */  32, 32, 78, 50, 69, 70, 65, 83, 54, 49,  9, 48, 48, 48, 48, 48,
/* 0x47a0 */  48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 54, 49, 10, 48, 48, 48,
/* 0x47b0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x47c0 */  69, 68, 69, 67, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x47d0 */  78, 50, 69, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x47e0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x47f0 */  48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76,
/* 0x4800 */  84, 82, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4810 */  32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48,  9, 48,
/* 0x4820 */  48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 48,
/* 0x4830 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4840 */  32, 32, 67, 65, 76, 76, 84, 82, 49, 49,  9, 48, 48, 48, 48, 48,
/* 0x4850 */  48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 49, 10, 48, 48, 48,
/* 0x4860 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65,
/* 0x4870 */  76, 76, 84, 82, 49, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4880 */  67, 65, 76, 76, 84, 82, 49, 51, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4890 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50,
/* 0x48a0 */  46, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,
/* 0x48b0 */ 107, 51, 50, 46, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x48c0 */ 108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 49,
/* 0x48d0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,107, 51,
/* 0x48e0 */  50, 46, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x48f0 */  32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 50, 48,  9,
/* 0x4900 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,107, 51, 50, 46,
/* 0x4910 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4920 */  32,100, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48,  9, 48, 48,
/* 0x4930 */  48, 48, 48, 48, 48, 48, 32, 99,116,111,107, 51, 50, 46, 52, 48,
/* 0x4940 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4950 */  32, 32, 80, 69, 73, 77, 80, 79, 82, 84,  9, 48, 48, 48, 48, 48,
/* 0x4960 */  48, 48, 48, 32, 80, 69, 73, 77, 80, 79, 82, 84, 10, 48, 48, 48,
/* 0x4970 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x4980 */  73, 77, 79, 82, 68, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4990 */  80, 69, 73, 77, 79, 82, 68, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x49a0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 77, 80, 79,
/* 0x49b0 */  82, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 77,
/* 0x49c0 */  80, 79, 82, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x49d0 */  32, 32, 32,100, 32, 32, 80, 69, 73, 77, 68, 79, 78, 69,  9, 48,
/* 0x49e0 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 77, 68, 79, 78, 69,
/* 0x49f0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4a00 */  32, 32, 82, 69, 76, 79, 67, 51, 50, 48,  9, 48, 48, 48, 48, 48,
/* 0x4a10 */  48, 48, 48, 32, 82, 69, 76, 79, 67, 51, 50, 48, 10, 48, 48, 48,
/* 0x4a20 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 82, 69,
/* 0x4a30 */  76, 79, 67, 51, 50, 74,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4a40 */  82, 69, 76, 79, 67, 51, 50, 74, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4a50 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 77, 65, 73, 78,
/* 0x4a60 */  50, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 77, 65,
/* 0x4a70 */  73, 78, 50, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4a80 */  32, 32, 32,100, 32, 32, 80, 69, 73, 83, 68, 76, 76, 49,  9, 48,
/* 0x4a90 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 83, 68, 76, 76, 49,
/* 0x4aa0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4ab0 */  32, 32, 80, 69, 77, 65, 73, 78, 48, 49,  9, 48, 48, 48, 48, 48,
/* 0x4ac0 */  48, 48, 48, 32, 80, 69, 77, 65, 73, 78, 48, 49, 10, 48, 48, 48,
/* 0x4ad0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x4ae0 */  73, 67, 79, 78, 83, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4af0 */  80, 69, 73, 67, 79, 78, 83, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b00 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 67, 79, 78,
/* 0x4b10 */  83, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 67,
/* 0x4b20 */  79, 78, 83, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4b30 */  32, 32, 32,100, 32, 32, 80, 69, 84, 76, 83, 72, 65, 75,  9, 48,
/* 0x4b40 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 84, 76, 83, 72, 65, 75,
/* 0x4b50 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4b60 */  32, 32, 80, 69, 77, 65, 73, 78, 48, 50,  9, 48, 48, 48, 48, 48,
/* 0x4b70 */  48, 48, 48, 32, 80, 69, 77, 65, 73, 78, 48, 50, 10, 48, 48, 48,
/* 0x4b80 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x4b90 */  77, 65, 73, 78, 48, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4ba0 */  80, 69, 77, 65, 73, 78, 48, 51, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4bb0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83,
/* 0x4bc0 */  49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70,
/* 0x4bd0 */  65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4be0 */  32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 50, 48,  9, 48,
/* 0x4bf0 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 50, 48,
/* 0x4c00 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4c10 */  32, 32, 78, 50, 66, 70, 65, 83, 50, 48,  9, 48, 48, 48, 48, 48,
/* 0x4c20 */  48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 50, 48, 10, 48, 48, 48,
/* 0x4c30 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x4c40 */  66, 83, 77, 65, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4c50 */  78, 50, 66, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c60 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83,
/* 0x4c70 */  51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70,
/* 0x4c80 */  65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4c90 */  32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 52, 48,  9, 48,
/* 0x4ca0 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 52, 48,
/* 0x4cb0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4cc0 */  32, 32, 78, 50, 66, 70, 65, 83, 52, 48,  9, 48, 48, 48, 48, 48,
/* 0x4cd0 */  48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 52, 48, 10, 48, 48, 48,
/* 0x4ce0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x4cf0 */  66, 83, 77, 65, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4d00 */  78, 50, 66, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d10 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83,
/* 0x4d20 */  53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70,
/* 0x4d30 */  65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4d40 */  32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 54, 48,  9, 48,
/* 0x4d50 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 54, 48,
/* 0x4d60 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4d70 */  32, 32, 78, 50, 66, 70, 65, 83, 54, 48,  9, 48, 48, 48, 48, 48,
/* 0x4d80 */  48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 54, 48, 10, 48, 48, 48,
/* 0x4d90 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x4da0 */  68, 70, 65, 83, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4db0 */  78, 50, 68, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4dc0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65,
/* 0x4dd0 */  50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83,
/* 0x4de0 */  77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4df0 */  32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 50, 48,  9, 48,
/* 0x4e00 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 50, 48,
/* 0x4e10 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4e20 */  32, 32, 78, 50, 68, 83, 77, 65, 51, 48,  9, 48, 48, 48, 48, 48,
/* 0x4e30 */  48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 51, 48, 10, 48, 48, 48,
/* 0x4e40 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x4e50 */  68, 70, 65, 83, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4e60 */  78, 50, 68, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4e70 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65,
/* 0x4e80 */  52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83,
/* 0x4e90 */  77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4ea0 */  32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 52, 48,  9, 48,
/* 0x4eb0 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 52, 48,
/* 0x4ec0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4ed0 */  32, 32, 78, 50, 68, 83, 77, 65, 53, 48,  9, 48, 48, 48, 48, 48,
/* 0x4ee0 */  48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 53, 48, 10, 48, 48, 48,
/* 0x4ef0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x4f00 */  68, 70, 65, 83, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4f10 */  78, 50, 68, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4f20 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65,
/* 0x4f30 */  54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83,
/* 0x4f40 */  77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4f50 */  32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 48,  9, 48,
/* 0x4f60 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 54, 48,
/* 0x4f70 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4f80 */  32, 32, 78, 50, 69, 70, 65, 83, 49, 48,  9, 48, 48, 48, 48, 48,
/* 0x4f90 */  48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 49, 48, 10, 48, 48, 48,
/* 0x4fa0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x4fb0 */  69, 83, 77, 65, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4fc0 */  78, 50, 69, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4fd0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83,
/* 0x4fe0 */  50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70,
/* 0x4ff0 */  65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x5000 */  32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 51, 48,  9, 48,
/* 0x5010 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65, 51, 48,
/* 0x5020 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x5030 */  32, 32, 78, 50, 69, 70, 65, 83, 51, 48,  9, 48, 48, 48, 48, 48,
/* 0x5040 */  48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 51, 48, 10, 48, 48, 48,
/* 0x5050 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x5060 */  69, 83, 77, 65, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5070 */  78, 50, 69, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5080 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83,
/* 0x5090 */  52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70,
/* 0x50a0 */  65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x50b0 */  32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 53, 48,  9, 48,
/* 0x50c0 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65, 53, 48,
/* 0x50d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x50e0 */  32, 32, 78, 50, 69, 70, 65, 83, 53, 48,  9, 48, 48, 48, 48, 48,
/* 0x50f0 */  48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 53, 48, 10, 48, 48, 48,
/* 0x5100 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x5110 */  69, 83, 77, 65, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5120 */  78, 50, 69, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5130 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83,
/* 0x5140 */  54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70,
/* 0x5150 */  65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x5160 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48,
/* 0x5170 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68,
/* 0x5180 */  69, 67, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x5190 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,
/* 0x51a0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 69,
/* 0x51b0 */  76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x51c0 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x51d0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68,
/* 0x51e0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x51f0 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x5200 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68,
/* 0x5210 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x5220 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x5230 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68,
/* 0x5240 */  69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x5250 */  32, 32, 32,100, 32, 32, 80, 69, 77, 65, 73, 78, 49, 48,  9, 48,
/* 0x5260 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 77, 65, 73, 78, 49, 48,
/* 0x5270 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x5280 */  32, 32, 80, 69, 67, 84, 84, 80, 79, 83,  9, 48, 48, 48, 48, 48,
/* 0x5290 */  48, 48, 48, 32, 80, 69, 67, 84, 84, 80, 79, 83, 10, 48, 48, 48,
/* 0x52a0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x52b0 */  67, 84, 84, 78, 85, 76,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x52c0 */  80, 69, 67, 84, 84, 78, 85, 76, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x52d0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86,
/* 0x52e0 */  69, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 67, 76,
/* 0x52f0 */  69, 86, 69, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x5300 */  32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 49,  9, 48,
/* 0x5310 */  48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 48, 49,
/* 0x5320 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x5330 */  32, 32, 67, 84, 66, 83, 72, 82, 48, 49,  9, 48, 48, 48, 48, 48,
/* 0x5340 */  48, 48, 48, 32, 67, 84, 66, 83, 72, 82, 48, 49, 10, 48, 48, 48,
/* 0x5350 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,
/* 0x5360 */  66, 82, 79, 82, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5370 */  67, 84, 66, 82, 79, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5380 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65,
/* 0x5390 */  48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 83,
/* 0x53a0 */  87, 65, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x53b0 */  32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 50,  9, 48,
/* 0x53c0 */  48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 48, 50,
/* 0x53d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x53e0 */  32, 32, 67, 65, 76, 76, 84, 82, 69, 56,  9, 48, 48, 48, 48, 48,
/* 0x53f0 */  48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 69, 56, 10, 48, 48, 48,
/* 0x5400 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65,
/* 0x5410 */  76, 76, 84, 82, 69, 57,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5420 */  67, 65, 76, 76, 84, 82, 69, 57, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5430 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86,
/* 0x5440 */  69, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 67, 76,
/* 0x5450 */  69, 86, 69, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x5460 */  32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 50,  9, 48,
/* 0x5470 */  48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 50,
/* 0x5480 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x5490 */  32, 32, 67, 84, 66, 83, 72, 82, 49, 49,  9, 48, 48, 48, 48, 48,
/* 0x54a0 */  48, 48, 48, 32, 67, 84, 66, 83, 72, 82, 49, 49, 10, 48, 48, 48,
/* 0x54b0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,
/* 0x54c0 */  66, 82, 79, 82, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x54d0 */  67, 84, 66, 82, 79, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x54e0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65,
/* 0x54f0 */  49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 83,
/* 0x5500 */  87, 65, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x5510 */  32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 51, 48,  9,
/* 0x5520 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,107, 51, 50, 46,
/* 0x5530 */  51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x5540 */  32,100, 32, 32, 80, 69, 73, 66, 89, 79, 82, 68,  9, 48, 48, 48,
/* 0x5550 */  48, 48, 48, 48, 48, 32, 80, 69, 73, 66, 89, 79, 82, 68, 10, 48,
/* 0x5560 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x5570 */  80, 69, 75, 51, 50, 79, 82, 68,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x5580 */  48, 32, 80, 69, 75, 51, 50, 79, 82, 68, 10, 48, 48, 48, 48, 48,
/* 0x5590 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 69,
/* 0x55a0 */  82, 68, 76, 76,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69,
/* 0x55b0 */  73, 69, 82, 68, 76, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x55c0 */ 108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 69, 82, 69, 88, 69,
/* 0x55d0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 69, 82, 69,
/* 0x55e0 */  88, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x55f0 */  32,100, 32, 32, 80, 69, 82, 69, 76, 79, 67, 49,  9, 48, 48, 48,
/* 0x5600 */  48, 48, 48, 48, 48, 32, 80, 69, 82, 69, 76, 79, 67, 49, 10, 48,
/* 0x5610 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x5620 */  80, 69, 82, 69, 76, 79, 67, 50,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x5630 */  48, 32, 80, 69, 82, 69, 76, 79, 67, 50, 10, 48, 48, 48, 48, 48,
/* 0x5640 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 69,
/* 0x5650 */  76, 79, 67, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69,
/* 0x5660 */  82, 69, 76, 79, 67, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5670 */ 108, 32, 32, 32, 32,100, 32, 32, 82, 69, 76, 51, 50, 66, 73, 71,
/* 0x5680 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 69, 76, 51, 50, 66,
/* 0x5690 */  73, 71, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x56a0 */  32,100, 32, 32, 82, 69, 76, 51, 50, 69, 78, 68,  9, 48, 48, 48,
/* 0x56b0 */  48, 48, 48, 48, 48, 32, 82, 69, 76, 51, 50, 69, 78, 68, 10, 48,
/* 0x56c0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x56d0 */  80, 69, 82, 76, 79, 72, 73, 48,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x56e0 */  48, 32, 80, 69, 82, 76, 79, 72, 73, 48, 10, 48, 48, 48, 48, 48,
/* 0x56f0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 69,
/* 0x5700 */  76, 76, 79, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69,
/* 0x5710 */  82, 69, 76, 76, 79, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5720 */ 108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 69, 76, 72, 73, 48,
/* 0x5730 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 82, 69, 76, 72,
/* 0x5740 */  73, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x5750 */  32,100, 32, 32, 80, 69, 68, 69, 80, 72, 65, 75,  9, 48, 48, 48,
/* 0x5760 */  48, 48, 48, 48, 48, 32, 80, 69, 68, 69, 80, 72, 65, 75, 10, 48,
/* 0x5770 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x5780 */  80, 69, 77, 65, 73, 78, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x5790 */  48, 32, 80, 69, 77, 65, 73, 78, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x57a0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 69, 65,
/* 0x57b0 */  82, 83, 84, 65, 67, 75,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x57c0 */  67, 76, 69, 65, 82, 83, 84, 65, 67, 75, 10, 48, 48, 48, 48, 48,
/* 0x57d0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 69,
/* 0x57e0 */  84, 85, 82, 78,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69,
/* 0x57f0 */  82, 69, 84, 85, 82, 78, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5800 */ 108, 32, 32, 32, 32,100, 32, 32, 80, 69, 68, 79, 74, 85, 77, 80,
/* 0x5810 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 68, 79, 74, 85,
/* 0x5820 */  77, 80, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x5830 */  32,100, 32, 32, 85, 80, 88, 49, 72, 69, 65, 68,  9, 48, 48, 48,
/* 0x5840 */  48, 48, 48, 48, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68, 10, 48,
/* 0x5850 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5860 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,115,
/* 0x5870 */ 116, 97,114,116, 95,111,102, 95, 99,111,109,112,114,101,115,115,
/* 0x5880 */ 101,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x5890 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x58a0 */  48, 48, 32,115,116, 97,114,116, 95,111,102, 95,117,110, 99,111,
/* 0x58b0 */ 109,112,114,101,115,115,101,100, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x58c0 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x58d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,105, 99,111,110, 95,111,102,
/* 0x58e0 */ 102,115,101,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x58f0 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,
/* 0x5900 */  48, 48, 48, 48, 32,105, 99,111,110, 95,100,101,108,116, 97, 10,
/* 0x5910 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5920 */  32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5930 */ 116,108,115, 95, 97,100,100,114,101,115,115, 10, 48, 48, 48, 48,
/* 0x5940 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x5950 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,116,108,115, 95,
/* 0x5960 */ 118, 97,108,117,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x5970 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x5980 */  48, 48, 48, 48, 48, 32,108,122,109, 97, 95,115,116, 97, 99,107,
/* 0x5990 */  95, 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x59a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48,
/* 0x59b0 */  48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,117, 95,108,
/* 0x59c0 */ 101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x59d0 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x59e0 */  48, 48, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48,
/* 0x59f0 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x5a00 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,
/* 0x5a10 */ 109, 97, 95,112,114,111,112,101,114,116,105,101,115, 10, 48, 48,
/* 0x5a20 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x5a30 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,
/* 0x5a40 */ 108,116,101,114, 95, 98,117,102,102,101,114, 95,115,116, 97,114,
/* 0x5a50 */ 116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x5a60 */  32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x5a70 */  48, 32,102,105,108,116,101,114, 95,108,101,110,103,116,104, 10,
/* 0x5a80 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5a90 */  32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5aa0 */ 102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48,
/* 0x5ab0 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x5ac0 */  42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,111,109,112,114,
/* 0x5ad0 */ 101,115,115,101,100, 95,105,109,112,111,114,116,115, 10, 48, 48,
/* 0x5ae0 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x5af0 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,115,116,
/* 0x5b00 */  97,114,116, 95,111,102, 95,105,109,112,111,114,116,115, 10, 48,
/* 0x5b10 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5b20 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x5b30 */ 111, 97,100, 76,105, 98,114, 97,114,121, 65, 10, 48, 48, 48, 48,
/* 0x5b40 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x5b50 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,107,101,114,110,
/* 0x5b60 */ 101,108, 51, 50, 95,111,114,100,105,110, 97,108,115, 10, 48, 48,
/* 0x5b70 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x5b80 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 71,101,
/* 0x5b90 */ 116, 80,114,111, 99, 65,100,100,114,101,115,115, 10, 48, 48, 48,
/* 0x5ba0 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x5bb0 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69,120,105,
/* 0x5bc0 */ 116, 80,114,111, 99,101,115,115, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5bd0 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x5be0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,115,116, 97,114,116, 95,111,
/* 0x5bf0 */ 102, 95,114,101,108,111, 99,115, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5c00 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x5c10 */  48, 48, 48, 48, 48, 48, 48, 48, 32,114,101,108,111, 99, 95,100,
/* 0x5c20 */ 101,108,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x5c30 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,
/* 0x5c40 */  48, 48, 48, 32, 86,105,114,116,117, 97,108, 80,114,111,116,101,
/* 0x5c50 */  99,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x5c60 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x5c70 */  48, 48, 32,118,112, 95, 98, 97,115,101, 10, 48, 48, 48, 48, 48,
/* 0x5c80 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x5c90 */  42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,118,112, 95,115,105,
/* 0x5ca0 */ 122,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x5cb0 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x5cc0 */  48, 48, 32,115,119,114,105, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5cd0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48,
/* 0x5ce0 */  48, 48, 48, 48, 48, 48, 48, 32,111,114,105,103,105,110, 97,108,
/* 0x5cf0 */  95,101,110,116,114,121, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x5d00 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x5d10 */  80, 69, 73, 83, 68, 76, 76, 49, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x5d20 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5d30 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x5d40 */  48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x5d50 */  32, 32, 32, 32, 32, 32, 32, 80, 69, 77, 65, 73, 78, 50, 49, 10,
/* 0x5d60 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x5d70 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 77, 65, 73, 78, 48,
/* 0x5d80 */  49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x5d90 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x5da0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95,
/* 0x5db0 */  51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5dc0 */ 115,116, 97,114,116, 95,111,102, 95, 99,111,109,112,114,101,115,
/* 0x5dd0 */ 115,101,100, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51,
/* 0x5de0 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,115,
/* 0x5df0 */ 116, 97,114,116, 95,111,102, 95,117,110, 99,111,109,112,114,101,
/* 0x5e00 */ 115,115,101,100, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x5e10 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69,
/* 0x5e20 */  73, 67, 79, 78, 83, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x5e30 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5e40 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x5e50 */  48, 51, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x5e60 */  32, 32, 32, 32, 32,105, 99,111,110, 95,111,102,102,115,101,116,
/* 0x5e70 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x5e80 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 67, 79, 78,
/* 0x5e90 */  83, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x5ea0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5eb0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,
/* 0x5ec0 */  95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5ed0 */  32,105, 99,111,110, 95,111,102,102,115,101,116, 10, 48, 48, 48,
/* 0x5ee0 */  48, 48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32,
/* 0x5ef0 */  32, 32, 32, 32, 32, 32, 32, 32,105, 99,111,110, 95,100,101,108,
/* 0x5f00 */ 116, 97, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x5f10 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 84, 76,
/* 0x5f20 */  83, 72, 65, 75, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5f30 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5f40 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x5f50 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x5f60 */  32, 32, 32,116,108,115, 95, 97,100,100,114,101,115,115, 10, 48,
/* 0x5f70 */  48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 51, 50,
/* 0x5f80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32,116,108,115, 95,118, 97,
/* 0x5f90 */ 108,117,101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x5fa0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66,
/* 0x5fb0 */  83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x5fc0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5fd0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5fe0 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x5ff0 */  32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x6000 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x6010 */  32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 49, 48, 93, 58,
/* 0x6020 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6030 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6040 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x6050 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66,
/* 0x6060 */  68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x6070 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x6080 */  50, 66, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x6090 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x60a0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x60b0 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x60c0 */  32, 32, 32, 32, 32, 32, 78, 50, 66, 83, 77, 65, 49, 48, 10, 10,
/* 0x60d0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x60e0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 50, 48,
/* 0x60f0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x6100 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x6110 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x6120 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x6130 */  50, 66, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x6140 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x6150 */  91, 78, 50, 66, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x6160 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x6170 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x6180 */  48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6190 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48,
/* 0x61a0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x61b0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83,
/* 0x61c0 */  51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x61d0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x61e0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,
/* 0x61f0 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6200 */  32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x6210 */  48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x6220 */  32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 10, 82,
/* 0x6230 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x6240 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 68, 69, 67, 51, 48, 93,
/* 0x6250 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x6260 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x6270 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 49, 32, 82, 95, 51, 56,
/* 0x6280 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x6290 */  66, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 50,102, 32,
/* 0x62a0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x62b0 */  32, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79,
/* 0x62c0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x62d0 */  79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 52, 48, 93, 58, 10, 79,
/* 0x62e0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x62f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x6300 */  48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x6310 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69,
/* 0x6320 */  67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x6330 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66,
/* 0x6340 */  70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x6350 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6360 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x6370 */  51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x6380 */  32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 48, 48, 48,
/* 0x6390 */  48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x63a0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48,
/* 0x63b0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x63c0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65,
/* 0x63d0 */  54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x63e0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x63f0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82,
/* 0x6400 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x6410 */  32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x6420 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x6430 */  82, 32, 91, 78, 50, 66, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70,
/* 0x6440 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x6450 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x6460 */  48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x6470 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 70, 65, 83,
/* 0x6480 */  54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56,
/* 0x6490 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x64a0 */  66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x64b0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x64c0 */  78, 50, 66, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x64d0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x64e0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x64f0 */  48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x6500 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10,
/* 0x6510 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x6520 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 49,
/* 0x6530 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x6540 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x6550 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x6560 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6570 */  78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x6580 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x6590 */  32, 91, 78, 50, 68, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70,
/* 0x65a0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x65b0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x65c0 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x65d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49,
/* 0x65e0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x65f0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77,
/* 0x6600 */  65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x6610 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6620 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x6630 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6640 */  32, 32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x6650 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6660 */  79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 50, 48, 93, 58, 10, 79,
/* 0x6670 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x6680 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x6690 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x66a0 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65,
/* 0x66b0 */  83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x66c0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,
/* 0x66d0 */  83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x66e0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x66f0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x6700 */  99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x6710 */  32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69,
/* 0x6720 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x6730 */  32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 51, 48, 93, 58,
/* 0x6740 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6750 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6760 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54,
/* 0x6770 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,
/* 0x6780 */  68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82,
/* 0x6790 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x67a0 */  32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x67b0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x67c0 */  82, 32, 91, 78, 50, 68, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70,
/* 0x67d0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x67e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x67f0 */  48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x6800 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67,
/* 0x6810 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 50, 49, 32, 82, 95, 51, 56,
/* 0x6820 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x6830 */  68, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 52, 51, 32,
/* 0x6840 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6850 */  32, 32, 78, 50, 68, 68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79,
/* 0x6860 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6870 */  79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 52, 48, 93, 58, 10, 79,
/* 0x6880 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x6890 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x68a0 */  48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x68b0 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,
/* 0x68c0 */  67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x68d0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,
/* 0x68e0 */  70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x68f0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6900 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x6910 */  51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x6920 */  32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48,
/* 0x6930 */  48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6940 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,
/* 0x6950 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6960 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65,
/* 0x6970 */  54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x6980 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6990 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82,
/* 0x69a0 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x69b0 */  32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x69c0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x69d0 */  82, 32, 91, 78, 50, 68, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70,
/* 0x69e0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x69f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x6a00 */  48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x6a10 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65, 83,
/* 0x6a20 */  54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56,
/* 0x6a30 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x6a40 */  68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x6a50 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x6a60 */  78, 50, 68, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x6a70 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6a80 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x6a90 */  48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x6aa0 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10,
/* 0x6ab0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x6ac0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 49,
/* 0x6ad0 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x6ae0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x6af0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x6b00 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6b10 */  78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x6b20 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x6b30 */  32, 91, 78, 50, 69, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70,
/* 0x6b40 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x6b50 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x6b60 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x6b70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49,
/* 0x6b80 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x6b90 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77,
/* 0x6ba0 */  65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x6bb0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6bc0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x6bd0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6be0 */  32, 32, 78, 50, 69, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x6bf0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6c00 */  79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 50, 48, 93, 58, 10, 79,
/* 0x6c10 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x6c20 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x6c30 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x6c40 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65,
/* 0x6c50 */  83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x6c60 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,
/* 0x6c70 */  83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x6c80 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6c90 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x6ca0 */  99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x6cb0 */  32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69,
/* 0x6cc0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x6cd0 */  32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 51, 48, 93, 58,
/* 0x6ce0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6cf0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6d00 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54,
/* 0x6d10 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,
/* 0x6d20 */  68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82,
/* 0x6d30 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6d40 */  32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x6d50 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x6d60 */  82, 32, 91, 78, 50, 69, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70,
/* 0x6d70 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x6d80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x6d90 */  48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x6da0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67,
/* 0x6db0 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56,
/* 0x6dc0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x6dd0 */  69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32,
/* 0x6de0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6df0 */  32, 32, 78, 50, 69, 68, 69, 67, 54, 48, 10, 10, 82, 69, 76, 79,
/* 0x6e00 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6e10 */  79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 52, 48, 93, 58, 10, 79,
/* 0x6e20 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x6e30 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x6e40 */  48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x6e50 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,
/* 0x6e60 */  67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x6e70 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,
/* 0x6e80 */  70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x6e90 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6ea0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x6eb0 */  51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x6ec0 */  32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48,
/* 0x6ed0 */  48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6ee0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,
/* 0x6ef0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6f00 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65,
/* 0x6f10 */  54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x6f20 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6f30 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82,
/* 0x6f40 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x6f50 */  32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x6f60 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x6f70 */  82, 32, 91, 78, 50, 69, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70,
/* 0x6f80 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x6f90 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x6fa0 */  48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x6fb0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65, 83,
/* 0x6fc0 */  54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56,
/* 0x6fd0 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x6fe0 */  69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x6ff0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x7000 */  78, 50, 69, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x7010 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7020 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x7030 */  48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x7040 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10,
/* 0x7050 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x7060 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69,
/* 0x7070 */  67, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x7080 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7090 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32,
/* 0x70a0 */  82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x70b0 */  32, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,
/* 0x70c0 */ 117,115,116, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95, 51,
/* 0x70d0 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,
/* 0x70e0 */ 122,109, 97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48,
/* 0x70f0 */  49,101, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x7100 */  32, 32, 32, 32, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10,
/* 0x7110 */  48, 48, 48, 48, 48, 48, 50, 97, 32, 82, 95, 51, 56, 54, 95, 51,
/* 0x7120 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,
/* 0x7130 */ 112,114,111,112,101,114,116,105,101,115, 10, 10, 82, 69, 76, 79,
/* 0x7140 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x7150 */  79, 82, 32, 91, 80, 69, 67, 84, 84, 80, 79, 83, 93, 58, 10, 79,
/* 0x7160 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x7170 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x7180 */  48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 51,
/* 0x7190 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,
/* 0x71a0 */ 114, 95, 98,117,102,102,101,114, 95,115,116, 97,114,116, 10, 10,
/* 0x71b0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x71c0 */  68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 48, 48,
/* 0x71d0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x71e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x71f0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x7200 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,
/* 0x7210 */ 105,108,116,101,114, 95,108,101,110,103,116,104, 10, 10, 82, 69,
/* 0x7220 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x7230 */  32, 70, 79, 82, 32, 91, 67, 84, 67, 76, 69, 86, 69, 49, 93, 58,
/* 0x7240 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x7250 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x7260 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54,
/* 0x7270 */  95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,
/* 0x7280 */ 116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x7290 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x72a0 */  32, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82, 69, 76,
/* 0x72b0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x72c0 */  70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 48, 50, 93, 58, 10,
/* 0x72d0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x72e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x72f0 */  10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95,
/* 0x7300 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76,
/* 0x7310 */  84, 82, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x7320 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65,
/* 0x7330 */  76, 76, 84, 82, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x7340 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7350 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x7360 */  48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x7370 */  32, 32, 32, 32, 32,102,105,108,116,101,114, 95,108,101,110,103,
/* 0x7380 */ 116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x7390 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76,
/* 0x73a0 */  84, 82, 49, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x73b0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x73c0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51,
/* 0x73d0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x73e0 */  32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 51, 10, 10, 82, 69, 76,
/* 0x73f0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x7400 */  70, 79, 82, 32, 91, 67, 84, 67, 76, 69, 86, 69, 50, 93, 58, 10,
/* 0x7410 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x7420 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x7430 */  10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95,
/* 0x7440 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,
/* 0x7450 */ 101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32,
/* 0x7460 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x7470 */  32, 32, 67, 65, 76, 76, 84, 82, 49, 49, 10, 10, 82, 69, 76, 79,
/* 0x7480 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x7490 */  79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 51, 93, 58, 10, 79,
/* 0x74a0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x74b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x74c0 */  48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x74d0 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84,
/* 0x74e0 */  82, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x74f0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,
/* 0x7500 */ 107, 51, 50, 46, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x7510 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7520 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x7530 */  48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x7540 */  32, 32, 32, 32, 32,102,105,108,116,101,114, 95,108,101,110,103,
/* 0x7550 */ 116,104, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56,
/* 0x7560 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,
/* 0x7570 */ 111,107, 51, 50, 46, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x7580 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x7590 */  91, 99,116,111,107, 51, 50, 46, 49, 48, 93, 58, 10, 79, 70, 70,
/* 0x75a0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x75b0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x75c0 */  48, 48, 48, 48, 48,100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x75d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46,
/* 0x75e0 */  50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x75f0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107,
/* 0x7600 */  51, 50, 46, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x7610 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7620 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x7630 */  53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x7640 */  32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48,
/* 0x7650 */  48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32,
/* 0x7660 */  32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,
/* 0x7670 */  99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51,
/* 0x7680 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,
/* 0x7690 */ 116,111,107, 51, 50, 46, 52, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x76a0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x76b0 */  32, 91, 99,116,111,107, 51, 50, 46, 51, 48, 93, 58, 10, 79, 70,
/* 0x76c0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x76d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x76e0 */  48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x76f0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50,
/* 0x7700 */  46, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x7710 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,
/* 0x7720 */ 107, 51, 50, 46, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x7730 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7740 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x7750 */  48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x7760 */  32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 48, 48, 10, 10,
/* 0x7770 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x7780 */  68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 77, 80, 79, 82, 84,
/* 0x7790 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x77a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x77b0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51,
/* 0x77c0 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,
/* 0x77d0 */ 111,109,112,114,101,115,115,101,100, 95,105,109,112,111,114,116,
/* 0x77e0 */ 115, 10, 48, 48, 48, 48, 48, 48, 48, 98, 32, 82, 95, 51, 56, 54,
/* 0x77f0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 80, 69, 73,
/* 0x7800 */  77, 68, 79, 78, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82,
/* 0x7810 */  95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7820 */  32,115,116, 97,114,116, 95,111,102, 95,105,109,112,111,114,116,
/* 0x7830 */ 115, 10, 48, 48, 48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56, 54,
/* 0x7840 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76,111, 97,
/* 0x7850 */ 100, 76,105, 98,114, 97,114,121, 65, 10, 10, 82, 69, 76, 79, 67,
/* 0x7860 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x7870 */  82, 32, 91, 80, 69, 73, 66, 89, 79, 82, 68, 93, 58, 10, 79, 70,
/* 0x7880 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x7890 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x78a0 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x78b0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 80, 69, 73, 77, 79, 82,
/* 0x78c0 */  68, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x78d0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 75, 51,
/* 0x78e0 */  50, 79, 82, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x78f0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7900 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97,
/* 0x7910 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x7920 */  32, 32, 32,107,101,114,110,101,108, 51, 50, 95,111,114,100,105,
/* 0x7930 */ 110, 97,108,115, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95,
/* 0x7940 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7950 */  80, 69, 73, 77, 80, 79, 82, 50, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x7960 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x7970 */  32, 91, 80, 69, 73, 77, 80, 79, 82, 50, 93, 58, 10, 79, 70, 70,
/* 0x7980 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x7990 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x79a0 */  48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x79b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 71,101,116, 80,114,111, 99,
/* 0x79c0 */  65,100,100,114,101,115,115, 10, 48, 48, 48, 48, 48, 48, 49, 53,
/* 0x79d0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x79e0 */  32, 32, 32, 80, 69, 73, 77, 80, 79, 82, 84, 10, 10, 82, 69, 76,
/* 0x79f0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x7a00 */  70, 79, 82, 32, 91, 80, 69, 73, 69, 82, 69, 88, 69, 93, 58, 10,
/* 0x7a10 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x7a20 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x7a30 */  10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95,
/* 0x7a40 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 69,120,105,116,
/* 0x7a50 */  80,114,111, 99,101,115,115, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x7a60 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x7a70 */  91, 80, 69, 82, 69, 76, 79, 67, 49, 93, 58, 10, 79, 70, 70, 83,
/* 0x7a80 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x7a90 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x7aa0 */  48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32,
/* 0x7ab0 */  32, 32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,102,
/* 0x7ac0 */  95,114,101,108,111, 99,115, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x7ad0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x7ae0 */  91, 82, 69, 76, 79, 67, 51, 50, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x7af0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x7b00 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x7b10 */  48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x7b20 */  32, 32, 32, 32, 32, 32, 32, 32, 82, 69, 76, 79, 67, 51, 50, 74,
/* 0x7b30 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x7b40 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 82, 69, 76, 51, 50, 66,
/* 0x7b50 */  73, 71, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x7b60 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7b70 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,
/* 0x7b80 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7b90 */  32, 82, 69, 76, 79, 67, 51, 50, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x7ba0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x7bb0 */  82, 32, 91, 82, 69, 76, 79, 67, 51, 50, 74, 93, 58, 10, 79, 70,
/* 0x7bc0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x7bd0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x7be0 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x7bf0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 82, 69, 76, 79, 67, 51,
/* 0x7c00 */  50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x7c10 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 82, 76,
/* 0x7c20 */  79, 72, 73, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x7c30 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7c40 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x7c50 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x7c60 */  32, 32, 32,114,101,108,111, 99, 95,100,101,108,116, 10, 10, 82,
/* 0x7c70 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x7c80 */  83, 32, 70, 79, 82, 32, 91, 80, 69, 68, 69, 80, 72, 65, 75, 93,
/* 0x7c90 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x7ca0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x7cb0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56,
/* 0x7cc0 */  54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,105,
/* 0x7cd0 */ 114,116,117, 97,108, 80,114,111,116,101, 99,116, 10, 48, 48, 48,
/* 0x7ce0 */  48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32,
/* 0x7cf0 */  32, 32, 32, 32, 32, 32, 32, 32,118,112, 95, 98, 97,115,101, 10,
/* 0x7d00 */  48, 48, 48, 48, 48, 48, 48,100, 32, 82, 95, 51, 56, 54, 95, 51,
/* 0x7d10 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,118,112, 95,115,105,
/* 0x7d20 */ 122,101, 10, 48, 48, 48, 48, 48, 48, 49, 98, 32, 82, 95, 51, 56,
/* 0x7d30 */  54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,115,119,
/* 0x7d40 */ 114,105, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x7d50 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 68, 79,
/* 0x7d60 */  74, 85, 77, 80, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x7d70 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7d80 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x7d90 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x7da0 */  32, 32, 32,111,114,105,103,105,110, 97,108, 95,101,110,116,114,
/* 0x7db0 */ 121, 10
};
