/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *
 */

namespace Unity.FilesPlace {

  public enum ResultsColumn
  {
    URI = 0,
    ICON_HINT,
    GROUP_ID,
    MIMETYPE,
    DISPLAY_NAME,
    COMMENT
  }
  
  public enum SectionsColumn
  {
    DISPLAY_NAME = 0,
    ICON_HINT
  }
  
  public enum Section
  {
    ALL_FILES = 0,
    DOCUMENTS,
    FOLDERS,
    IMAGES,
    AUDIO,
    VIDEOS,
    PRESENTATIONS,
    OTHER,
    LAST_SECTION
  }
  
  public enum GroupsColumn
  {
    RENDERER = 0,
    DISPLAY_NAME,
    ICON_HINT
  }
  
  public enum Group
  {
    TOP_RESULTS,
    RECENT,
    DOWNLOADS,
    FAVORITE_FOLDERS,
    FILES, /* generic group used in global search */
    EMPTY_SEARCH,
    EMPTY_SECTION,
    TODAY,
    YESTERDAY,
    THIS_WEEK,
    LAST_WEEK,
    THIS_MONTH,
    PAST_SIX_MONTHS,
    THIS_YEAR,
    LAST_YEAR,
  }
}
