/* runner.c generated by valac 0.12.0, the Vala compiler
 * generated from runner.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Didier Roche <didrocks@ubuntu.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <unity.h>
#include <gee.h>
#include <gconf/gconf-client.h>
#include <dee.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <unity-package-search.h>
#include <gconf/gconf.h>
#include <gobject/gvaluecollector.h>


#define UNITY_APPLICATIONS_PLACE_TYPE_ABOUT_ENTRY (unity_applications_place_about_entry_get_type ())
#define UNITY_APPLICATIONS_PLACE_ABOUT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_APPLICATIONS_PLACE_TYPE_ABOUT_ENTRY, UnityApplicationsPlaceAboutEntry))
#define UNITY_APPLICATIONS_PLACE_ABOUT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_APPLICATIONS_PLACE_TYPE_ABOUT_ENTRY, UnityApplicationsPlaceAboutEntryClass))
#define UNITY_APPLICATIONS_PLACE_IS_ABOUT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_APPLICATIONS_PLACE_TYPE_ABOUT_ENTRY))
#define UNITY_APPLICATIONS_PLACE_IS_ABOUT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_APPLICATIONS_PLACE_TYPE_ABOUT_ENTRY))
#define UNITY_APPLICATIONS_PLACE_ABOUT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_APPLICATIONS_PLACE_TYPE_ABOUT_ENTRY, UnityApplicationsPlaceAboutEntryClass))

typedef struct _UnityApplicationsPlaceAboutEntry UnityApplicationsPlaceAboutEntry;
typedef struct _UnityApplicationsPlaceAboutEntryClass UnityApplicationsPlaceAboutEntryClass;
typedef struct _UnityApplicationsPlaceAboutEntryPrivate UnityApplicationsPlaceAboutEntryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _UnityApplicationsPlaceParamSpecAboutEntry UnityApplicationsPlaceParamSpecAboutEntry;

#define UNITY_APPLICATIONS_PLACE_TYPE_RUNNER (unity_applications_place_runner_get_type ())
#define UNITY_APPLICATIONS_PLACE_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_APPLICATIONS_PLACE_TYPE_RUNNER, UnityApplicationsPlaceRunner))
#define UNITY_APPLICATIONS_PLACE_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_APPLICATIONS_PLACE_TYPE_RUNNER, UnityApplicationsPlaceRunnerClass))
#define UNITY_APPLICATIONS_PLACE_IS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_APPLICATIONS_PLACE_TYPE_RUNNER))
#define UNITY_APPLICATIONS_PLACE_IS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_APPLICATIONS_PLACE_TYPE_RUNNER))
#define UNITY_APPLICATIONS_PLACE_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_APPLICATIONS_PLACE_TYPE_RUNNER, UnityApplicationsPlaceRunnerClass))

typedef struct _UnityApplicationsPlaceRunner UnityApplicationsPlaceRunner;
typedef struct _UnityApplicationsPlaceRunnerClass UnityApplicationsPlaceRunnerClass;
typedef struct _UnityApplicationsPlaceRunnerPrivate UnityApplicationsPlaceRunnerPrivate;

#define UNITY_APPLICATIONS_PLACE_TYPE_DAEMON (unity_applications_place_daemon_get_type ())
#define UNITY_APPLICATIONS_PLACE_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON, UnityApplicationsPlaceDaemon))
#define UNITY_APPLICATIONS_PLACE_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON, UnityApplicationsPlaceDaemonClass))
#define UNITY_APPLICATIONS_PLACE_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON))
#define UNITY_APPLICATIONS_PLACE_IS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON))
#define UNITY_APPLICATIONS_PLACE_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON, UnityApplicationsPlaceDaemonClass))

typedef struct _UnityApplicationsPlaceDaemon UnityApplicationsPlaceDaemon;
typedef struct _UnityApplicationsPlaceDaemonClass UnityApplicationsPlaceDaemonClass;

#define UNITY_APPLICATIONS_PLACE_TYPE_RUNNER_GROUP (unity_applications_place_runner_group_get_type ())
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityApplicationsPlaceRunnerUpdateSearchData UnityApplicationsPlaceRunnerUpdateSearchData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _UnityApplicationsPlaceRunnerFindSystemExecutablesData UnityApplicationsPlaceRunnerFindSystemExecutablesData;
#define _unity_applications_place_about_entry_unref0(var) ((var == NULL) ? NULL : (var = (unity_applications_place_about_entry_unref (var), NULL)))
typedef struct _UnityApplicationsPlaceDaemonPrivate UnityApplicationsPlaceDaemonPrivate;
#define _unity_package_search_result_free0(var) ((var == NULL) ? NULL : (var = (unity_package_search_result_free (var), NULL)))
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))

struct _UnityApplicationsPlaceAboutEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityApplicationsPlaceAboutEntryPrivate * priv;
	gchar* name;
	gchar* exec;
	GIcon* icon;
};

struct _UnityApplicationsPlaceAboutEntryClass {
	GTypeClass parent_class;
	void (*finalize) (UnityApplicationsPlaceAboutEntry *self);
};

struct _UnityApplicationsPlaceParamSpecAboutEntry {
	GParamSpec parent_instance;
};

struct _UnityApplicationsPlaceRunner {
	GObject parent_instance;
	UnityApplicationsPlaceRunnerPrivate * priv;
	UnityPlaceEntryInfo* place_entry;
};

struct _UnityApplicationsPlaceRunnerClass {
	GObjectClass parent_class;
};

struct _UnityApplicationsPlaceRunnerPrivate {
	UnityApplicationsPlaceDaemon* daemon;
	gboolean all_models_synced;
	UnityPlaceSearch* previous_search;
	GeeHashMap* about_entries;
	GeeList* executables;
	GeeList* history;
	GConfClient* client;
};

typedef enum  {
	UNITY_APPLICATIONS_PLACE_RUNNER_GROUP_RESULTS,
	UNITY_APPLICATIONS_PLACE_RUNNER_GROUP_HISTORY
} UnityApplicationsPlaceRunnerGroup;

struct _UnityApplicationsPlaceRunnerUpdateSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityApplicationsPlaceRunner* self;
	UnityPlaceSearch* search;
	UnityPlaceRendererInfo* _tmp0_;
	DeeModel* _tmp1_;
	DeeModel* _tmp2_;
	DeeModel* model;
	GeeArrayList* _tmp3_;
	GeeArrayList* executables_match;
	GeeArrayList* _tmp4_;
	GeeArrayList* dirs_match;
	gchar* _tmp5_;
	gchar* search_string;
	gboolean _tmp6_;
	gboolean has_search;
	gchar* uri;
	GIcon* icon;
	gchar* mimetype;
	gchar* display_name;
	UnityApplicationsPlaceRunnerGroup group_id;
	GeeList* _tmp7_;
	GeeList* _command_list;
	gint _tmp8_;
	gint _command_size;
	gint _command_index;
	gpointer _tmp9_;
	gchar* command;
	GIcon* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GTimer* _tmp16_;
	GTimer* timer;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* commenteaster;
	GThemedIcon* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* commentnoeaster;
	GThemedIcon* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* search_dirname;
	GFile* _tmp34_;
	GFile* directory;
	gboolean search_dirname_in_path;
	const gchar* _tmp35_;
	gchar** _tmp36_;
	gchar** _tmp37_;
	gchar** path_directory_collection;
	int path_directory_collection_length1;
	int path_directory_it;
	gchar* _tmp38_;
	gchar* path_directory;
	gboolean _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GFileEnumerator* _tmp42_;
	GFileEnumerator* iterator;
	GFileInfo* _tmp43_;
	GFileInfo* subelem_info;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* complete_path;
	gboolean _tmp46_;
	gboolean _tmp47_;
	GFileType _tmp48_;
	gboolean _tmp49_;
	const gchar* _tmp50_;
	GError * err;
	GeeList* _tmp51_;
	GeeList* _exec_candidate_list;
	gint _tmp52_;
	gint _exec_candidate_size;
	gint _exec_candidate_index;
	gpointer _tmp53_;
	gchar* exec_candidate;
	gboolean _tmp54_;
	gboolean _tmp55_;
	GIcon* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	GIcon* _tmp63_;
	GeeArrayList* _tmp64_;
	GeeArrayList* _dir_list;
	gint _tmp65_;
	gint _dir_size;
	gint _dir_index;
	gpointer _tmp66_;
	gchar* dir;
	const gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	GeeArrayList* _tmp71_;
	GeeArrayList* _final_exec_list;
	gint _tmp72_;
	gint _final_exec_size;
	gint _final_exec_index;
	gpointer _tmp73_;
	gchar* final_exec;
	const gchar* _tmp74_;
	gchar* _tmp75_;
	GIcon* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gint _tmp82_;
	gint _tmp83_;
	gdouble _tmp84_;
	GError * _inner_error_;
};

struct _UnityApplicationsPlaceRunnerFindSystemExecutablesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityApplicationsPlaceRunner* self;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** path_directory_collection;
	int path_directory_collection_length1;
	int path_directory_it;
	gchar* _tmp4_;
	gchar* path_directory;
	GFile* _tmp5_;
	GFile* dir;
	GFileEnumerator* _tmp6_;
	GFileEnumerator* e;
	GList* _tmp7_;
	GList* files;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp8_;
	GFileInfo* info;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	GError * err;
	GError * _inner_error_;
};

struct _UnityApplicationsPlaceDaemon {
	GObject parent_instance;
	UnityApplicationsPlaceDaemonPrivate * priv;
	UnityPackageSearcher* appsearcher;
};

struct _UnityApplicationsPlaceDaemonClass {
	GObjectClass parent_class;
};


static gpointer unity_applications_place_about_entry_parent_class = NULL;
static gpointer unity_applications_place_runner_parent_class = NULL;

gpointer unity_applications_place_about_entry_ref (gpointer instance);
void unity_applications_place_about_entry_unref (gpointer instance);
GParamSpec* unity_applications_place_param_spec_about_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_applications_place_value_set_about_entry (GValue* value, gpointer v_object);
void unity_applications_place_value_take_about_entry (GValue* value, gpointer v_object);
gpointer unity_applications_place_value_get_about_entry (const GValue* value);
GType unity_applications_place_about_entry_get_type (void) G_GNUC_CONST;
enum  {
	UNITY_APPLICATIONS_PLACE_ABOUT_ENTRY_DUMMY_PROPERTY
};
UnityApplicationsPlaceAboutEntry* unity_applications_place_about_entry_new (const gchar* name, const gchar* exec, GIcon* icon);
UnityApplicationsPlaceAboutEntry* unity_applications_place_about_entry_construct (GType object_type, const gchar* name, const gchar* exec, GIcon* icon);
static void unity_applications_place_about_entry_finalize (UnityApplicationsPlaceAboutEntry* obj);
GType unity_applications_place_runner_get_type (void) G_GNUC_CONST;
GType unity_applications_place_daemon_get_type (void) G_GNUC_CONST;
#define UNITY_APPLICATIONS_PLACE_RUNNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_APPLICATIONS_PLACE_TYPE_RUNNER, UnityApplicationsPlaceRunnerPrivate))
enum  {
	UNITY_APPLICATIONS_PLACE_RUNNER_DUMMY_PROPERTY
};
#define UNITY_APPLICATIONS_PLACE_RUNNER_BUS_NAME_PREFIX "com.canonical.Unity.ApplicationsPlace.Runner"
#define UNITY_APPLICATIONS_PLACE_RUNNER_HISTORY_KEY "/apps/gnome-settings/gnome-panel/history-gnome-run"
#define UNITY_APPLICATIONS_PLACE_RUNNER_MAX_HISTORY 10
UnityApplicationsPlaceRunner* unity_applications_place_runner_new (UnityApplicationsPlaceDaemon* daemon);
UnityApplicationsPlaceRunner* unity_applications_place_runner_construct (GType object_type, UnityApplicationsPlaceDaemon* daemon);
static void unity_applications_place_runner_load_about_entries (UnityApplicationsPlaceRunner* self);
static void unity_applications_place_runner_find_system_executables (UnityApplicationsPlaceRunner* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_applications_place_runner_find_system_executables_finish (UnityApplicationsPlaceRunner* self, GAsyncResult* _res_);
static void unity_applications_place_runner_load_history (UnityApplicationsPlaceRunner* self);
static void _lambda0_ (GObject* obj, GParamSpec* pspec, UnityApplicationsPlaceRunner* self);
gboolean unity_applications_place_utils_search_has_really_changed (UnityPlaceSearch* old_search, UnityPlaceSearch* new_search);
static void unity_applications_place_runner_update_search (UnityApplicationsPlaceRunner* self, UnityPlaceSearch* search, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_applications_place_runner_update_search_finish (UnityApplicationsPlaceRunner* self, GAsyncResult* _res_);
static void __lambda0__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_applications_place_runner_check_models_synced (UnityApplicationsPlaceRunner* self, GObject* obj, GParamSpec* pspec);
static void _unity_applications_place_runner_check_models_synced_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_applications_place_runner_update_search_data_free (gpointer _data);
static gboolean unity_applications_place_runner_update_search_co (UnityApplicationsPlaceRunnerUpdateSearchData* data);
gboolean unity_applications_place_utils_search_is_invalid (UnityPlaceSearch* search);
GType unity_applications_place_runner_group_get_type (void) G_GNUC_CONST;
static gchar* unity_applications_place_runner_get_icon_uri_and_mimetype (UnityApplicationsPlaceRunner* self, const gchar* exec_string, GIcon** icon, gchar** uri, gchar** mimetype);
static void unity_applications_place_runner_release_entrylock (UnityApplicationsPlaceRunner* self);
gchar* unity_applications_place_utils_subst_tilde (const gchar* s);
static gboolean _lambda1_ (UnityApplicationsPlaceRunner* self);
static gboolean __lambda1__gsource_func (gpointer self);
static void unity_applications_place_runner_find_system_executables_data_free (gpointer _data);
static gboolean unity_applications_place_runner_find_system_executables_co (UnityApplicationsPlaceRunnerFindSystemExecutablesData* data);
static void unity_applications_place_runner_find_system_executables_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GIcon* unity_applications_place_daemon_find_pkg_icon (UnityApplicationsPlaceDaemon* self, UnityPackageInfo* pkginfo);
static void unity_applications_place_runner_populate_groups (UnityApplicationsPlaceRunner* self, DeeModel* groups);
#define CONFIG_DATADIR "/usr/share"
#define UNITY_APPLICATIONS_PLACE_ICON_PATH CONFIG_DATADIR "/icons/unity-icon-theme/places/svg/"
void unity_applications_place_runner_add_history (UnityApplicationsPlaceRunner* self, const gchar* last_command);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
#define CONFIG_PREFIX "/usr"
static void unity_applications_place_runner_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


UnityApplicationsPlaceAboutEntry* unity_applications_place_about_entry_construct (GType object_type, const gchar* name, const gchar* exec, GIcon* icon) {
	UnityApplicationsPlaceAboutEntry* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GIcon* _tmp2_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (exec != NULL, NULL);
	g_return_val_if_fail (icon != NULL, NULL);
	self = (UnityApplicationsPlaceAboutEntry*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	_tmp1_ = g_strdup (exec);
	_g_free0 (self->exec);
	self->exec = _tmp1_;
	_tmp2_ = _g_object_ref0 (icon);
	_g_object_unref0 (self->icon);
	self->icon = _tmp2_;
	return self;
}


UnityApplicationsPlaceAboutEntry* unity_applications_place_about_entry_new (const gchar* name, const gchar* exec, GIcon* icon) {
	return unity_applications_place_about_entry_construct (UNITY_APPLICATIONS_PLACE_TYPE_ABOUT_ENTRY, name, exec, icon);
}


static void unity_applications_place_value_about_entry_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void unity_applications_place_value_about_entry_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_applications_place_about_entry_unref (value->data[0].v_pointer);
	}
}


static void unity_applications_place_value_about_entry_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_applications_place_about_entry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer unity_applications_place_value_about_entry_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* unity_applications_place_value_about_entry_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityApplicationsPlaceAboutEntry* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_applications_place_about_entry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* unity_applications_place_value_about_entry_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityApplicationsPlaceAboutEntry** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_applications_place_about_entry_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* unity_applications_place_param_spec_about_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UnityApplicationsPlaceParamSpecAboutEntry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UNITY_APPLICATIONS_PLACE_TYPE_ABOUT_ENTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer unity_applications_place_value_get_about_entry (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_APPLICATIONS_PLACE_TYPE_ABOUT_ENTRY), NULL);
	return value->data[0].v_pointer;
}


void unity_applications_place_value_set_about_entry (GValue* value, gpointer v_object) {
	UnityApplicationsPlaceAboutEntry* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_APPLICATIONS_PLACE_TYPE_ABOUT_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_APPLICATIONS_PLACE_TYPE_ABOUT_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_applications_place_about_entry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_applications_place_about_entry_unref (old);
	}
}


void unity_applications_place_value_take_about_entry (GValue* value, gpointer v_object) {
	UnityApplicationsPlaceAboutEntry* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_APPLICATIONS_PLACE_TYPE_ABOUT_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_APPLICATIONS_PLACE_TYPE_ABOUT_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_applications_place_about_entry_unref (old);
	}
}


static void unity_applications_place_about_entry_class_init (UnityApplicationsPlaceAboutEntryClass * klass) {
	unity_applications_place_about_entry_parent_class = g_type_class_peek_parent (klass);
	UNITY_APPLICATIONS_PLACE_ABOUT_ENTRY_CLASS (klass)->finalize = unity_applications_place_about_entry_finalize;
}


static void unity_applications_place_about_entry_instance_init (UnityApplicationsPlaceAboutEntry * self) {
	self->ref_count = 1;
}


static void unity_applications_place_about_entry_finalize (UnityApplicationsPlaceAboutEntry* obj) {
	UnityApplicationsPlaceAboutEntry * self;
	self = UNITY_APPLICATIONS_PLACE_ABOUT_ENTRY (obj);
	_g_free0 (self->name);
	_g_free0 (self->exec);
	_g_object_unref0 (self->icon);
}


GType unity_applications_place_about_entry_get_type (void) {
	static volatile gsize unity_applications_place_about_entry_type_id__volatile = 0;
	if (g_once_init_enter (&unity_applications_place_about_entry_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { unity_applications_place_value_about_entry_init, unity_applications_place_value_about_entry_free_value, unity_applications_place_value_about_entry_copy_value, unity_applications_place_value_about_entry_peek_pointer, "p", unity_applications_place_value_about_entry_collect_value, "p", unity_applications_place_value_about_entry_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityApplicationsPlaceAboutEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_applications_place_about_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityApplicationsPlaceAboutEntry), 0, (GInstanceInitFunc) unity_applications_place_about_entry_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_applications_place_about_entry_type_id;
		unity_applications_place_about_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityApplicationsPlaceAboutEntry", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_applications_place_about_entry_type_id__volatile, unity_applications_place_about_entry_type_id);
	}
	return unity_applications_place_about_entry_type_id__volatile;
}


gpointer unity_applications_place_about_entry_ref (gpointer instance) {
	UnityApplicationsPlaceAboutEntry* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_applications_place_about_entry_unref (gpointer instance) {
	UnityApplicationsPlaceAboutEntry* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_APPLICATIONS_PLACE_ABOUT_ENTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _lambda0_ (GObject* obj, GParamSpec* pspec, UnityApplicationsPlaceRunner* self) {
	UnityPlaceSearch* _tmp0_ = NULL;
	UnityPlaceSearch* _tmp1_;
	UnityPlaceSearch* search;
	gboolean _tmp2_;
	UnityPlaceSearch* _tmp3_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	if (!self->priv->all_models_synced) {
		return;
	}
	_tmp0_ = unity_place_entry_info_get_active_search (self->place_entry);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	search = _tmp1_;
	_tmp2_ = unity_applications_place_utils_search_has_really_changed (self->priv->previous_search, search);
	if (!_tmp2_) {
		_g_object_unref0 (search);
		return;
	}
	unity_applications_place_runner_update_search (self, search, NULL, NULL);
	_tmp3_ = _g_object_ref0 (search);
	_g_object_unref0 (self->priv->previous_search);
	self->priv->previous_search = _tmp3_;
	_g_object_unref0 (search);
}


static void __lambda0__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda0_ (_sender, pspec, self);
}


static void _unity_applications_place_runner_check_models_synced_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_applications_place_runner_check_models_synced (self, _sender, pspec);
}


UnityApplicationsPlaceRunner* unity_applications_place_runner_construct (GType object_type, UnityApplicationsPlaceDaemon* daemon) {
	UnityApplicationsPlaceRunner * self = NULL;
	DeeSharedModel* _tmp0_ = NULL;
	DeeSharedModel* sections_model;
	DeeSharedModel* _tmp1_ = NULL;
	DeeSharedModel* groups_model;
	DeeSharedModel* _tmp2_ = NULL;
	DeeSharedModel* results_model;
	UnityPlaceEntryInfo* _tmp3_ = NULL;
	UnityPlaceRendererInfo* _tmp4_ = NULL;
	UnityPlaceRendererInfo* _tmp5_ = NULL;
	GeeHashMap* _tmp6_ = NULL;
	GeeArrayList* _tmp7_ = NULL;
	GConfClient* _tmp8_ = NULL;
	GConfClient* _tmp9_;
	GeeArrayList* _tmp10_ = NULL;
	UnityApplicationsPlaceDaemon* _tmp11_;
	g_return_val_if_fail (daemon != NULL, NULL);
	self = (UnityApplicationsPlaceRunner*) g_object_new (object_type, NULL);
	_tmp0_ = (DeeSharedModel*) dee_shared_model_new (UNITY_APPLICATIONS_PLACE_RUNNER_BUS_NAME_PREFIX "SectionsModel");
	sections_model = _tmp0_;
	dee_model_set_schema ((DeeModel*) sections_model, "s", "s", NULL);
	_tmp1_ = (DeeSharedModel*) dee_shared_model_new (UNITY_APPLICATIONS_PLACE_RUNNER_BUS_NAME_PREFIX "GroupsModel");
	groups_model = _tmp1_;
	dee_model_set_schema ((DeeModel*) groups_model, "s", "s", "s", NULL);
	_tmp2_ = (DeeSharedModel*) dee_shared_model_new (UNITY_APPLICATIONS_PLACE_RUNNER_BUS_NAME_PREFIX "ResultsModel");
	results_model = _tmp2_;
	dee_model_set_schema ((DeeModel*) results_model, "s", "s", "u", "s", "s", "s", NULL);
	_tmp3_ = unity_place_entry_info_new ("/com/canonical/unity/applicationsplace/runner");
	_g_object_unref0 (self->place_entry);
	self->place_entry = _tmp3_;
	unity_place_entry_info_set_sections_model (self->place_entry, (DeeModel*) sections_model);
	_tmp4_ = unity_place_entry_info_get_entry_renderer_info (self->place_entry);
	unity_place_renderer_info_set_groups_model (_tmp4_, (DeeModel*) groups_model);
	_tmp5_ = unity_place_entry_info_get_entry_renderer_info (self->place_entry);
	unity_place_renderer_info_set_results_model (_tmp5_, (DeeModel*) results_model);
	_g_object_unref0 (self->priv->previous_search);
	self->priv->previous_search = NULL;
	_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, UNITY_APPLICATIONS_PLACE_TYPE_ABOUT_ENTRY, (GBoxedCopyFunc) unity_applications_place_about_entry_ref, unity_applications_place_about_entry_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->about_entries);
	self->priv->about_entries = _tmp6_;
	unity_applications_place_runner_load_about_entries (self);
	_tmp7_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_g_object_unref0 (self->priv->executables);
	self->priv->executables = (GeeList*) _tmp7_;
	unity_applications_place_runner_find_system_executables (self, NULL, NULL);
	_tmp8_ = gconf_client_get_default ();
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->client);
	self->priv->client = _tmp9_;
	_tmp10_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_g_object_unref0 (self->priv->history);
	self->priv->history = (GeeList*) _tmp10_;
	unity_applications_place_runner_load_history (self);
	g_signal_connect_object ((GObject*) self->place_entry, "notify::active-search", (GCallback) __lambda0__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) sections_model, "notify::synchronized", (GCallback) _unity_applications_place_runner_check_models_synced_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) groups_model, "notify::synchronized", (GCallback) _unity_applications_place_runner_check_models_synced_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) results_model, "notify::synchronized", (GCallback) _unity_applications_place_runner_check_models_synced_g_object_notify, self, 0);
	self->priv->all_models_synced = FALSE;
	_tmp11_ = _g_object_ref0 (daemon);
	_g_object_unref0 (self->priv->daemon);
	self->priv->daemon = _tmp11_;
	_g_object_unref0 (results_model);
	_g_object_unref0 (groups_model);
	_g_object_unref0 (sections_model);
	return self;
}


UnityApplicationsPlaceRunner* unity_applications_place_runner_new (UnityApplicationsPlaceDaemon* daemon) {
	return unity_applications_place_runner_construct (UNITY_APPLICATIONS_PLACE_TYPE_RUNNER, daemon);
}


static void unity_applications_place_runner_update_search_data_free (gpointer _data) {
	UnityApplicationsPlaceRunnerUpdateSearchData* data;
	data = _data;
	_g_object_unref0 (data->search);
	_g_object_unref0 (data->self);
	g_slice_free (UnityApplicationsPlaceRunnerUpdateSearchData, data);
}


static void unity_applications_place_runner_update_search (UnityApplicationsPlaceRunner* self, UnityPlaceSearch* search, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityApplicationsPlaceRunnerUpdateSearchData* _data_;
	_data_ = g_slice_new0 (UnityApplicationsPlaceRunnerUpdateSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_applications_place_runner_update_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_applications_place_runner_update_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->search = _g_object_ref0 (search);
	unity_applications_place_runner_update_search_co (_data_);
}


static void unity_applications_place_runner_update_search_finish (UnityApplicationsPlaceRunner* self, GAsyncResult* _res_) {
	UnityApplicationsPlaceRunnerUpdateSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean unity_applications_place_runner_update_search_co (UnityApplicationsPlaceRunnerUpdateSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = unity_place_entry_info_get_entry_renderer_info (data->self->place_entry);
	data->_tmp1_ = NULL;
	data->_tmp1_ = unity_place_renderer_info_get_results_model (data->_tmp0_);
	data->_tmp2_ = _g_object_ref0 (data->_tmp1_);
	data->model = data->_tmp2_;
	data->_tmp3_ = NULL;
	data->_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	data->executables_match = data->_tmp3_;
	data->_tmp4_ = NULL;
	data->_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	data->dirs_match = data->_tmp4_;
	dee_model_clear (data->model);
	data->_tmp5_ = NULL;
	data->_tmp5_ = unity_place_search_get_search_string (data->search);
	data->search_string = data->_tmp5_;
	data->_tmp6_ = unity_applications_place_utils_search_is_invalid (data->search);
	data->has_search = !data->_tmp6_;
	data->group_id = UNITY_APPLICATIONS_PLACE_RUNNER_GROUP_HISTORY;
	{
		data->_tmp7_ = _g_object_ref0 (data->self->priv->history);
		data->_command_list = data->_tmp7_;
		data->_tmp8_ = gee_collection_get_size ((GeeCollection*) data->_command_list);
		data->_command_size = data->_tmp8_;
		data->_command_index = -1;
		while (TRUE) {
			data->_command_index = data->_command_index + 1;
			if (!(data->_command_index < data->_command_size)) {
				break;
			}
			data->_tmp9_ = NULL;
			data->_tmp9_ = gee_list_get (data->_command_list, data->_command_index);
			data->command = (gchar*) data->_tmp9_;
			data->_tmp10_ = NULL;
			data->_tmp11_ = NULL;
			data->_tmp12_ = NULL;
			data->_tmp13_ = NULL;
			data->_tmp13_ = unity_applications_place_runner_get_icon_uri_and_mimetype (data->self, data->command, &data->_tmp10_, &data->_tmp11_, &data->_tmp12_);
			_g_object_unref0 (data->icon);
			data->icon = data->_tmp10_;
			_g_free0 (data->uri);
			data->uri = data->_tmp11_;
			_g_free0 (data->mimetype);
			data->mimetype = data->_tmp12_;
			_g_free0 (data->display_name);
			data->display_name = data->_tmp13_;
			data->_tmp14_ = NULL;
			data->_tmp14_ = g_icon_to_string (data->icon);
			data->_tmp15_ = data->_tmp14_;
			dee_model_append (data->model, data->uri, data->_tmp15_, data->group_id, data->mimetype, data->display_name, NULL, NULL);
			_g_free0 (data->_tmp15_);
			_g_free0 (data->command);
		}
		_g_object_unref0 (data->_command_list);
	}
	g_object_freeze_notify ((GObject*) data->self->place_entry);
	if (!data->has_search) {
		unity_applications_place_runner_release_entrylock (data->self);
		unity_place_search_finished (data->search);
		_g_free0 (data->display_name);
		_g_free0 (data->mimetype);
		_g_object_unref0 (data->icon);
		_g_free0 (data->uri);
		_g_free0 (data->search_string);
		_g_object_unref0 (data->dirs_match);
		_g_object_unref0 (data->executables_match);
		_g_object_unref0 (data->model);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp16_ = NULL;
	data->_tmp16_ = g_timer_new ();
	data->timer = data->_tmp16_;
	if (g_strcmp0 (data->search_string, "free the fish") == 0) {
		data->_tmp17_ = g_strdup ("no-easter-egg");
		_g_free0 (data->uri);
		data->uri = data->_tmp17_;
		data->_tmp18_ = NULL;
		data->_tmp18_ = _ ("There is no easter egg in Unity");
		data->_tmp19_ = g_strdup (data->_tmp18_);
		data->commenteaster = data->_tmp19_;
		data->_tmp20_ = NULL;
		data->_tmp20_ = (GThemedIcon*) g_themed_icon_new ("gnome-panel-fish");
		_g_object_unref0 (data->icon);
		data->icon = (GIcon*) data->_tmp20_;
		data->_tmp21_ = NULL;
		data->_tmp21_ = g_icon_to_string (data->icon);
		data->_tmp22_ = data->_tmp21_;
		dee_model_append (data->model, data->uri, data->_tmp22_, 0, "no-mime", data->commenteaster, NULL, NULL);
		_g_free0 (data->_tmp22_);
		unity_applications_place_runner_release_entrylock (data->self);
		unity_place_search_finished (data->search);
		_g_free0 (data->commenteaster);
		_g_timer_destroy0 (data->timer);
		_g_free0 (data->display_name);
		_g_free0 (data->mimetype);
		_g_object_unref0 (data->icon);
		_g_free0 (data->uri);
		_g_free0 (data->search_string);
		_g_object_unref0 (data->dirs_match);
		_g_object_unref0 (data->executables_match);
		_g_object_unref0 (data->model);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		if (g_strcmp0 (data->search_string, "gegls from outer space") == 0) {
			data->_tmp23_ = g_strdup ("really-no-easter-egg");
			_g_free0 (data->uri);
			data->uri = data->_tmp23_;
			data->_tmp24_ = NULL;
			data->_tmp24_ = _ ("Still no easter egg in Unity");
			data->_tmp25_ = g_strdup (data->_tmp24_);
			data->commentnoeaster = data->_tmp25_;
			data->_tmp26_ = NULL;
			data->_tmp26_ = (GThemedIcon*) g_themed_icon_new ("gnome-panel-fish");
			_g_object_unref0 (data->icon);
			data->icon = (GIcon*) data->_tmp26_;
			data->_tmp27_ = NULL;
			data->_tmp27_ = g_icon_to_string (data->icon);
			data->_tmp28_ = data->_tmp27_;
			dee_model_append (data->model, data->uri, data->_tmp28_, 0, "no-mime", data->commentnoeaster, NULL, NULL);
			_g_free0 (data->_tmp28_);
			unity_applications_place_runner_release_entrylock (data->self);
			unity_place_search_finished (data->search);
			_g_free0 (data->commentnoeaster);
			_g_timer_destroy0 (data->timer);
			_g_free0 (data->display_name);
			_g_free0 (data->mimetype);
			_g_object_unref0 (data->icon);
			_g_free0 (data->uri);
			_g_free0 (data->search_string);
			_g_object_unref0 (data->dirs_match);
			_g_object_unref0 (data->executables_match);
			_g_object_unref0 (data->model);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_tmp30_ = g_str_has_prefix (data->search_string, "/");
	if (data->_tmp30_) {
		data->_tmp29_ = TRUE;
	} else {
		data->_tmp31_ = g_str_has_prefix (data->search_string, "~");
		data->_tmp29_ = data->_tmp31_;
	}
	if (data->_tmp29_) {
		data->_tmp32_ = NULL;
		data->_tmp32_ = unity_applications_place_utils_subst_tilde (data->search_string);
		_g_free0 (data->search_string);
		data->search_string = data->_tmp32_;
		data->_tmp33_ = NULL;
		data->_tmp33_ = g_path_get_dirname (data->search_string);
		data->search_dirname = data->_tmp33_;
		data->_tmp34_ = NULL;
		data->_tmp34_ = g_file_new_for_path (data->search_dirname);
		data->directory = data->_tmp34_;
		data->search_dirname_in_path = FALSE;
		data->_tmp35_ = NULL;
		data->_tmp35_ = g_getenv ("PATH");
		data->_tmp37_ = NULL;
		data->_tmp37_ = data->_tmp36_ = g_strsplit (data->_tmp35_, ":", 0);
		{
			data->path_directory_collection = data->_tmp37_;
			data->path_directory_collection_length1 = _vala_array_length (data->_tmp36_);
			for (data->path_directory_it = 0; data->path_directory_it < _vala_array_length (data->_tmp36_); data->path_directory_it = data->path_directory_it + 1) {
				data->_tmp38_ = g_strdup (data->path_directory_collection[data->path_directory_it]);
				data->path_directory = data->_tmp38_;
				{
					if (g_strcmp0 (data->search_dirname, data->path_directory) == 0) {
						data->_tmp39_ = TRUE;
					} else {
						data->_tmp40_ = g_strconcat (data->path_directory, "/", NULL);
						data->_tmp41_ = data->_tmp40_;
						data->_tmp39_ = g_strcmp0 (data->search_dirname, data->_tmp41_) == 0;
						_g_free0 (data->_tmp41_);
					}
					if (data->_tmp39_) {
						data->search_dirname_in_path = TRUE;
						_g_free0 (data->path_directory);
						break;
					}
					_g_free0 (data->path_directory);
				}
			}
			data->path_directory_collection = (_vala_array_free (data->path_directory_collection, data->path_directory_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		data->_tmp42_ = NULL;
		data->_tmp42_ = g_file_enumerate_children (data->directory, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE, 0, NULL, &data->_inner_error_);
		data->iterator = data->_tmp42_;
		if (data->_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		while (TRUE) {
			data->_tmp43_ = NULL;
			data->_tmp43_ = g_file_enumerator_next_file (data->iterator, NULL, &data->_inner_error_);
			data->subelem_info = data->_tmp43_;
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->iterator);
				goto __catch8_g_error;
			}
			if (data->subelem_info == NULL) {
				_g_object_unref0 (data->subelem_info);
				break;
			}
			data->_tmp44_ = NULL;
			data->_tmp44_ = g_file_info_get_name (data->subelem_info);
			data->_tmp45_ = NULL;
			data->_tmp45_ = g_build_filename (data->search_dirname, data->_tmp44_, NULL);
			data->complete_path = data->_tmp45_;
			data->_tmp47_ = g_str_has_prefix (data->complete_path, data->search_string);
			if (data->_tmp47_) {
				data->_tmp46_ = g_strcmp0 (data->complete_path, data->search_string) != 0;
			} else {
				data->_tmp46_ = FALSE;
			}
			if (data->_tmp46_) {
				data->_tmp48_ = g_file_info_get_file_type (data->subelem_info);
				if (data->_tmp48_ == G_FILE_TYPE_DIRECTORY) {
					gee_abstract_collection_add ((GeeAbstractCollection*) data->dirs_match, data->complete_path);
				} else {
					data->_tmp49_ = g_file_info_get_attribute_boolean (data->subelem_info, G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE);
					if (data->_tmp49_) {
						if (data->search_dirname_in_path) {
							data->_tmp50_ = NULL;
							data->_tmp50_ = g_file_info_get_name (data->subelem_info);
							gee_abstract_collection_add ((GeeAbstractCollection*) data->executables_match, data->_tmp50_);
						} else {
							gee_abstract_collection_add ((GeeAbstractCollection*) data->executables_match, data->complete_path);
						}
					}
				}
			}
			_g_free0 (data->complete_path);
			_g_object_unref0 (data->subelem_info);
		}
		_g_object_unref0 (data->iterator);
		goto __finally8;
		__catch8_g_error:
		{
			data->err = data->_inner_error_;
			data->_inner_error_ = NULL;
			g_warning ("runner.vala:233: Error listing directory executables: %s\n", data->err->message);
			_g_error_free0 (data->err);
		}
		__finally8:
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->directory);
			_g_free0 (data->search_dirname);
			_g_timer_destroy0 (data->timer);
			_g_free0 (data->display_name);
			_g_free0 (data->mimetype);
			_g_object_unref0 (data->icon);
			_g_free0 (data->uri);
			_g_free0 (data->search_string);
			_g_object_unref0 (data->dirs_match);
			_g_object_unref0 (data->executables_match);
			_g_object_unref0 (data->model);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (data->directory);
		_g_free0 (data->search_dirname);
	} else {
		{
			data->_tmp51_ = _g_object_ref0 (data->self->priv->executables);
			data->_exec_candidate_list = data->_tmp51_;
			data->_tmp52_ = gee_collection_get_size ((GeeCollection*) data->_exec_candidate_list);
			data->_exec_candidate_size = data->_tmp52_;
			data->_exec_candidate_index = -1;
			while (TRUE) {
				data->_exec_candidate_index = data->_exec_candidate_index + 1;
				if (!(data->_exec_candidate_index < data->_exec_candidate_size)) {
					break;
				}
				data->_tmp53_ = NULL;
				data->_tmp53_ = gee_list_get (data->_exec_candidate_list, data->_exec_candidate_index);
				data->exec_candidate = (gchar*) data->_tmp53_;
				data->_tmp55_ = g_str_has_prefix (data->exec_candidate, data->search_string);
				if (data->_tmp55_) {
					data->_tmp54_ = g_strcmp0 (data->exec_candidate, data->search_string) != 0;
				} else {
					data->_tmp54_ = FALSE;
				}
				if (data->_tmp54_) {
					gee_abstract_collection_add ((GeeAbstractCollection*) data->executables_match, data->exec_candidate);
				}
				_g_free0 (data->exec_candidate);
			}
			_g_object_unref0 (data->_exec_candidate_list);
		}
	}
	gee_list_sort ((GeeList*) data->executables_match, NULL);
	gee_list_sort ((GeeList*) data->dirs_match, NULL);
	data->group_id = UNITY_APPLICATIONS_PLACE_RUNNER_GROUP_RESULTS;
	data->_tmp56_ = NULL;
	data->_tmp57_ = NULL;
	data->_tmp58_ = NULL;
	data->_tmp59_ = NULL;
	data->_tmp59_ = unity_applications_place_runner_get_icon_uri_and_mimetype (data->self, data->search_string, &data->_tmp56_, &data->_tmp57_, &data->_tmp58_);
	_g_object_unref0 (data->icon);
	data->icon = data->_tmp56_;
	_g_free0 (data->uri);
	data->uri = data->_tmp57_;
	_g_free0 (data->mimetype);
	data->mimetype = data->_tmp58_;
	_g_free0 (data->display_name);
	data->display_name = data->_tmp59_;
	data->_tmp60_ = NULL;
	data->_tmp60_ = g_icon_to_string (data->icon);
	data->_tmp61_ = data->_tmp60_;
	dee_model_append (data->model, data->uri, data->_tmp61_, data->group_id, data->mimetype, data->display_name, NULL, NULL);
	_g_free0 (data->_tmp61_);
	data->_tmp62_ = g_strdup ("inode/directory");
	_g_free0 (data->mimetype);
	data->mimetype = data->_tmp62_;
	data->_tmp63_ = NULL;
	data->_tmp63_ = g_content_type_get_icon (data->mimetype);
	_g_object_unref0 (data->icon);
	data->icon = data->_tmp63_;
	{
		data->_tmp64_ = _g_object_ref0 (data->dirs_match);
		data->_dir_list = data->_tmp64_;
		data->_tmp65_ = gee_collection_get_size ((GeeCollection*) data->_dir_list);
		data->_dir_size = data->_tmp65_;
		data->_dir_index = -1;
		while (TRUE) {
			data->_dir_index = data->_dir_index + 1;
			if (!(data->_dir_index < data->_dir_size)) {
				break;
			}
			data->_tmp66_ = NULL;
			data->_tmp66_ = gee_abstract_list_get ((GeeAbstractList*) data->_dir_list, data->_dir_index);
			data->dir = (gchar*) data->_tmp66_;
			data->_tmp67_ = NULL;
			data->_tmp67_ = string_to_string (data->dir);
			data->_tmp68_ = NULL;
			data->_tmp68_ = g_strconcat ("unity-runner://", data->_tmp67_, NULL);
			_g_free0 (data->uri);
			data->uri = data->_tmp68_;
			data->_tmp69_ = NULL;
			data->_tmp69_ = g_icon_to_string (data->icon);
			data->_tmp70_ = data->_tmp69_;
			dee_model_append (data->model, data->uri, data->_tmp70_, data->group_id, data->mimetype, data->dir, NULL, NULL);
			_g_free0 (data->_tmp70_);
			_g_free0 (data->dir);
		}
		_g_object_unref0 (data->_dir_list);
	}
	{
		data->_tmp71_ = _g_object_ref0 (data->executables_match);
		data->_final_exec_list = data->_tmp71_;
		data->_tmp72_ = gee_collection_get_size ((GeeCollection*) data->_final_exec_list);
		data->_final_exec_size = data->_tmp72_;
		data->_final_exec_index = -1;
		while (TRUE) {
			data->_final_exec_index = data->_final_exec_index + 1;
			if (!(data->_final_exec_index < data->_final_exec_size)) {
				break;
			}
			data->_tmp73_ = NULL;
			data->_tmp73_ = gee_abstract_list_get ((GeeAbstractList*) data->_final_exec_list, data->_final_exec_index);
			data->final_exec = (gchar*) data->_tmp73_;
			data->_tmp74_ = NULL;
			data->_tmp74_ = string_to_string (data->final_exec);
			data->_tmp75_ = NULL;
			data->_tmp75_ = g_strconcat ("unity-runner://", data->_tmp74_, NULL);
			_g_free0 (data->uri);
			data->uri = data->_tmp75_;
			data->_tmp76_ = NULL;
			data->_tmp77_ = NULL;
			data->_tmp78_ = NULL;
			data->_tmp79_ = NULL;
			data->_tmp79_ = unity_applications_place_runner_get_icon_uri_and_mimetype (data->self, data->final_exec, &data->_tmp76_, &data->_tmp77_, &data->_tmp78_);
			_g_object_unref0 (data->icon);
			data->icon = data->_tmp76_;
			_g_free0 (data->uri);
			data->uri = data->_tmp77_;
			_g_free0 (data->mimetype);
			data->mimetype = data->_tmp78_;
			_g_free0 (data->display_name);
			data->display_name = data->_tmp79_;
			data->_tmp80_ = NULL;
			data->_tmp80_ = g_icon_to_string (data->icon);
			data->_tmp81_ = data->_tmp80_;
			dee_model_append (data->model, data->uri, data->_tmp81_, data->group_id, data->mimetype, data->display_name, NULL, NULL);
			_g_free0 (data->_tmp81_);
			_g_free0 (data->final_exec);
		}
		_g_object_unref0 (data->_final_exec_list);
	}
	g_timer_stop (data->timer);
	data->_tmp82_ = gee_collection_get_size ((GeeCollection*) data->dirs_match);
	data->_tmp83_ = gee_collection_get_size ((GeeCollection*) data->executables_match);
	data->_tmp84_ = g_timer_elapsed (data->timer, NULL);
	g_debug ("runner.vala:288: Entry search listed %i dir matches and %i exec matche" \
"s in %fms for search: %s", data->_tmp82_, data->_tmp83_, data->_tmp84_ * 1000, data->search_string);
	unity_applications_place_runner_release_entrylock (data->self);
	unity_place_search_finished (data->search);
	_g_timer_destroy0 (data->timer);
	_g_free0 (data->display_name);
	_g_free0 (data->mimetype);
	_g_object_unref0 (data->icon);
	_g_free0 (data->uri);
	_g_free0 (data->search_string);
	_g_object_unref0 (data->dirs_match);
	_g_object_unref0 (data->executables_match);
	_g_object_unref0 (data->model);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean _lambda1_ (UnityApplicationsPlaceRunner* self) {
	gboolean result = FALSE;
	g_object_thaw_notify ((GObject*) self->place_entry);
	result = FALSE;
	return result;
}


static gboolean __lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda1_ (self);
	return result;
}


static void unity_applications_place_runner_release_entrylock (UnityApplicationsPlaceRunner* self) {
	g_return_if_fail (self != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda1__gsource_func, g_object_ref (self), g_object_unref);
}


static void unity_applications_place_runner_find_system_executables_data_free (gpointer _data) {
	UnityApplicationsPlaceRunnerFindSystemExecutablesData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (UnityApplicationsPlaceRunnerFindSystemExecutablesData, data);
}


static void unity_applications_place_runner_find_system_executables (UnityApplicationsPlaceRunner* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityApplicationsPlaceRunnerFindSystemExecutablesData* _data_;
	_data_ = g_slice_new0 (UnityApplicationsPlaceRunnerFindSystemExecutablesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_applications_place_runner_find_system_executables);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_applications_place_runner_find_system_executables_data_free);
	_data_->self = _g_object_ref0 (self);
	unity_applications_place_runner_find_system_executables_co (_data_);
}


static void unity_applications_place_runner_find_system_executables_finish (UnityApplicationsPlaceRunner* self, GAsyncResult* _res_) {
	UnityApplicationsPlaceRunnerFindSystemExecutablesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_applications_place_runner_find_system_executables_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityApplicationsPlaceRunnerFindSystemExecutablesData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	unity_applications_place_runner_find_system_executables_co (data);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean unity_applications_place_runner_find_system_executables_co (UnityApplicationsPlaceRunnerFindSystemExecutablesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = gee_collection_get_size ((GeeCollection*) data->self->priv->executables);
	if (data->_tmp0_ > 0) {
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_getenv ("PATH");
	data->_tmp3_ = NULL;
	data->_tmp3_ = data->_tmp2_ = g_strsplit (data->_tmp1_, ":", 0);
	{
		data->path_directory_collection = data->_tmp3_;
		data->path_directory_collection_length1 = _vala_array_length (data->_tmp2_);
		for (data->path_directory_it = 0; data->path_directory_it < _vala_array_length (data->_tmp2_); data->path_directory_it = data->path_directory_it + 1) {
			data->_tmp4_ = g_strdup (data->path_directory_collection[data->path_directory_it]);
			data->path_directory = data->_tmp4_;
			{
				data->_tmp5_ = NULL;
				data->_tmp5_ = g_file_new_for_path (data->path_directory);
				data->dir = data->_tmp5_;
				data->_state_ = 1;
				g_file_enumerate_children_async (data->dir, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE, 0, G_PRIORITY_DEFAULT, NULL, unity_applications_place_runner_find_system_executables_ready, data);
				return FALSE;
				_state_1:
				data->_tmp6_ = NULL;
				data->_tmp6_ = g_file_enumerate_children_finish (data->dir, data->_res_, &data->_inner_error_);
				data->e = data->_tmp6_;
				if (data->_inner_error_ != NULL) {
					goto __catch9_g_error;
				}
				while (TRUE) {
					data->_state_ = 2;
					g_file_enumerator_next_files_async (data->e, 10, G_PRIORITY_DEFAULT, NULL, unity_applications_place_runner_find_system_executables_ready, data);
					return FALSE;
					_state_2:
					data->_tmp7_ = NULL;
					data->_tmp7_ = g_file_enumerator_next_files_finish (data->e, data->_res_, &data->_inner_error_);
					data->files = data->_tmp7_;
					if (data->_inner_error_ != NULL) {
						_g_object_unref0 (data->e);
						goto __catch9_g_error;
					}
					if (data->files == NULL) {
						__g_list_free__g_object_unref0_0 (data->files);
						break;
					}
					{
						data->info_collection = data->files;
						for (data->info_it = data->info_collection; data->info_it != NULL; data->info_it = data->info_it->next) {
							data->_tmp8_ = _g_object_ref0 ((GFileInfo*) data->info_it->data);
							data->info = data->_tmp8_;
							{
								data->_tmp9_ = g_file_info_get_attribute_boolean (data->info, G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE);
								if (data->_tmp9_) {
									data->_tmp10_ = NULL;
									data->_tmp10_ = g_file_info_get_name (data->info);
									gee_collection_add ((GeeCollection*) data->self->priv->executables, data->_tmp10_);
								}
								_g_object_unref0 (data->info);
							}
						}
					}
					__g_list_free__g_object_unref0_0 (data->files);
				}
				_g_object_unref0 (data->e);
				goto __finally9;
				__catch9_g_error:
				{
					data->err = data->_inner_error_;
					data->_inner_error_ = NULL;
					g_warning ("runner.vala:335: Error listing directory executables: %s\n", data->err->message);
					_g_error_free0 (data->err);
				}
				__finally9:
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->dir);
					_g_free0 (data->path_directory);
					data->path_directory_collection = (_vala_array_free (data->path_directory_collection, data->path_directory_collection_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
				_g_object_unref0 (data->dir);
				_g_free0 (data->path_directory);
			}
		}
		data->path_directory_collection = (_vala_array_free (data->path_directory_collection, data->path_directory_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gchar* string_delimit (const gchar* self, const gchar* delimiters, gchar new_delimiter) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strdelimit (_result_, delimiters, new_delimiter);
	result = _result_;
	return result;
}


static gchar* unity_applications_place_runner_get_icon_uri_and_mimetype (UnityApplicationsPlaceRunner* self, const gchar* exec_string, GIcon** icon, gchar** uri, gchar** mimetype) {
	GIcon* _icon = NULL;
	gchar* _uri = NULL;
	gchar* _mimetype = NULL;
	gchar* result = NULL;
	UnityApplicationsPlaceAboutEntry* entry;
	gchar* _tmp0_;
	gpointer _tmp1_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_ = NULL;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* s;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	UnityPackageSearchResult* _tmp22_ = NULL;
	UnityPackageSearchResult* _tmp23_;
	UnityPackageSearchResult* appresults;
	GThemedIcon* _tmp26_ = NULL;
	gchar* _tmp27_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (exec_string != NULL, NULL);
	entry = NULL;
	_tmp0_ = g_strdup ("application/x-unity-run");
	_g_free0 (_mimetype);
	_mimetype = _tmp0_;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->about_entries, exec_string);
	_unity_applications_place_about_entry_unref0 (entry);
	entry = (UnityApplicationsPlaceAboutEntry*) _tmp1_;
	if (entry != NULL) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		GIcon* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = string_to_string (entry->exec);
		_tmp3_ = g_strconcat ("unity-runner://", _tmp2_, NULL);
		_g_free0 (_uri);
		_uri = _tmp3_;
		_tmp4_ = _g_object_ref0 (entry->icon);
		_g_object_unref0 (_icon);
		_icon = _tmp4_;
		_tmp5_ = g_strdup (entry->name);
		result = _tmp5_;
		_unity_applications_place_about_entry_unref0 (entry);
		if (icon) {
			*icon = _icon;
		} else {
			_g_object_unref0 (_icon);
		}
		if (uri) {
			*uri = _uri;
		} else {
			_g_free0 (_uri);
		}
		if (mimetype) {
			*mimetype = _mimetype;
		} else {
			_g_free0 (_mimetype);
		}
		return result;
	}
	_tmp6_ = string_to_string (exec_string);
	_tmp7_ = g_strconcat ("unity-runner://", _tmp6_, NULL);
	_g_free0 (_uri);
	_uri = _tmp7_;
	_tmp8_ = g_file_test (exec_string, G_FILE_TEST_IS_DIR);
	if (_tmp8_) {
		gchar* _tmp9_;
		GIcon* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp9_ = g_strdup ("inode/directory");
		_g_free0 (_mimetype);
		_mimetype = _tmp9_;
		_tmp10_ = g_content_type_get_icon (_mimetype);
		_g_object_unref0 (_icon);
		_icon = _tmp10_;
		_tmp11_ = g_strdup (exec_string);
		result = _tmp11_;
		_unity_applications_place_about_entry_unref0 (entry);
		if (icon) {
			*icon = _icon;
		} else {
			_g_object_unref0 (_icon);
		}
		if (uri) {
			*uri = _uri;
		} else {
			_g_free0 (_uri);
		}
		if (mimetype) {
			*mimetype = _mimetype;
		} else {
			_g_free0 (_mimetype);
		}
		return result;
	}
	_tmp12_ = string_delimit (exec_string, "-", '_');
	_tmp13_ = _tmp12_;
	_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, " ", 0);
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _vala_array_length (_tmp14_);
	_tmp17_ = g_strdup (_tmp16_[0]);
	_tmp18_ = _tmp17_;
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp13_);
	s = _tmp18_;
	_tmp19_ = string_to_string (s);
	_tmp20_ = g_strconcat ("type:Application AND exec:", _tmp19_, NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = unity_package_searcher_search (self->priv->daemon->appsearcher, _tmp21_, (guint) 0, UNITY_PACKAGE_SEARCHTYPE_EXACT, UNITY_PACKAGE_SORT_BY_NAME);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	appresults = _tmp23_;
	{
		GSList* pkginfo_collection;
		GSList* pkginfo_it;
		pkginfo_collection = appresults->results;
		for (pkginfo_it = pkginfo_collection; pkginfo_it != NULL; pkginfo_it = pkginfo_it->next) {
			UnityPackageInfo* pkginfo;
			pkginfo = (UnityPackageInfo*) pkginfo_it->data;
			{
				GIcon* _tmp24_ = NULL;
				gchar* _tmp25_;
				if (pkginfo->desktop_file == NULL) {
					continue;
				}
				_tmp24_ = unity_applications_place_daemon_find_pkg_icon (self->priv->daemon, pkginfo);
				_g_object_unref0 (_icon);
				_icon = _tmp24_;
				_tmp25_ = g_strdup (exec_string);
				result = _tmp25_;
				_unity_package_search_result_free0 (appresults);
				_g_free0 (s);
				_unity_applications_place_about_entry_unref0 (entry);
				if (icon) {
					*icon = _icon;
				} else {
					_g_object_unref0 (_icon);
				}
				if (uri) {
					*uri = _uri;
				} else {
					_g_free0 (_uri);
				}
				if (mimetype) {
					*mimetype = _mimetype;
				} else {
					_g_free0 (_mimetype);
				}
				return result;
			}
		}
	}
	_tmp26_ = (GThemedIcon*) g_themed_icon_new ("gtk-execute");
	_g_object_unref0 (_icon);
	_icon = (GIcon*) _tmp26_;
	_tmp27_ = g_strdup (exec_string);
	result = _tmp27_;
	_unity_package_search_result_free0 (appresults);
	_g_free0 (s);
	_unity_applications_place_about_entry_unref0 (entry);
	if (icon) {
		*icon = _icon;
	} else {
		_g_object_unref0 (_icon);
	}
	if (uri) {
		*uri = _uri;
	} else {
		_g_free0 (_uri);
	}
	if (mimetype) {
		*mimetype = _mimetype;
	} else {
		_g_free0 (_mimetype);
	}
	return result;
}


static void unity_applications_place_runner_check_models_synced (UnityApplicationsPlaceRunner* self, GObject* obj, GParamSpec* pspec) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	DeeModel* _tmp2_ = NULL;
	DeeModel* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp2_ = unity_place_entry_info_get_sections_model (self->place_entry);
	_tmp3_ = _tmp2_;
	g_object_get (DEE_IS_SHARED_MODEL (_tmp3_) ? ((DeeSharedModel*) _tmp3_) : NULL, "synchronized", &_tmp4_, NULL);
	if (_tmp4_) {
		UnityPlaceRendererInfo* _tmp5_ = NULL;
		DeeModel* _tmp6_ = NULL;
		DeeModel* _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = unity_place_entry_info_get_entry_renderer_info (self->place_entry);
		_tmp6_ = unity_place_renderer_info_get_groups_model (_tmp5_);
		_tmp7_ = _tmp6_;
		g_object_get (DEE_IS_SHARED_MODEL (_tmp7_) ? ((DeeSharedModel*) _tmp7_) : NULL, "synchronized", &_tmp8_, NULL);
		_tmp1_ = _tmp8_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		UnityPlaceRendererInfo* _tmp9_ = NULL;
		DeeModel* _tmp10_ = NULL;
		DeeModel* _tmp11_;
		gboolean _tmp12_;
		_tmp9_ = unity_place_entry_info_get_entry_renderer_info (self->place_entry);
		_tmp10_ = unity_place_renderer_info_get_results_model (_tmp9_);
		_tmp11_ = _tmp10_;
		g_object_get (DEE_IS_SHARED_MODEL (_tmp11_) ? ((DeeSharedModel*) _tmp11_) : NULL, "synchronized", &_tmp12_, NULL);
		_tmp0_ = _tmp12_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		if (self->priv->all_models_synced == FALSE) {
			UnityPlaceRendererInfo* _tmp13_ = NULL;
			DeeModel* _tmp14_ = NULL;
			self->priv->all_models_synced = TRUE;
			_tmp13_ = unity_place_entry_info_get_entry_renderer_info (self->place_entry);
			_tmp14_ = unity_place_renderer_info_get_groups_model (_tmp13_);
			unity_applications_place_runner_populate_groups (self, _tmp14_);
			g_object_notify ((GObject*) self->place_entry, "active-search");
		}
	}
}


static void unity_applications_place_runner_populate_groups (UnityApplicationsPlaceRunner* self, DeeModel* groups) {
	guint _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	UnityPlaceRendererInfo* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (groups != NULL);
	_tmp0_ = dee_model_get_n_rows (groups);
	if (_tmp0_ != 0) {
		g_debug ("runner.vala:414: The groups model already populated. We probably clone" \
"d it off Unity. Rebuilding.");
		dee_model_clear (groups);
	}
	_tmp1_ = _ ("Results");
	dee_model_append (groups, "UnityDefaultRenderer", _tmp1_, UNITY_APPLICATIONS_PLACE_ICON_PATH "group-installed.svg", NULL);
	_tmp2_ = _ ("History");
	dee_model_append (groups, "UnityDefaultRenderer", _tmp2_, UNITY_APPLICATIONS_PLACE_ICON_PATH "group-available.svg", NULL);
	_tmp3_ = unity_place_entry_info_get_entry_renderer_info (self->place_entry);
	_tmp4_ = g_strdup_printf ("%u", (guint) UNITY_APPLICATIONS_PLACE_RUNNER_GROUP_HISTORY);
	_tmp5_ = _tmp4_;
	unity_place_renderer_info_set_hint (_tmp3_, "ExpandedGroups", _tmp5_);
	_g_free0 (_tmp5_);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_slist_free__g_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
	g_slist_free (self);
}


void unity_applications_place_runner_add_history (UnityApplicationsPlaceRunner* self, const gchar* last_command) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* new_history;
	gint i;
	GeeList* _tmp9_;
	GSList* history_store;
	UnityPlaceSearch* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (last_command != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	new_history = _tmp0_;
	i = 0;
	gee_abstract_list_insert ((GeeAbstractList*) new_history, i, last_command);
	{
		gint j;
		j = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				gint _tmp3_;
				gpointer _tmp4_ = NULL;
				gchar* _tmp5_;
				gboolean _tmp6_;
				gpointer _tmp7_ = NULL;
				gchar* _tmp8_;
				if (!_tmp1_) {
					j++;
				}
				_tmp1_ = FALSE;
				_tmp3_ = gee_collection_get_size ((GeeCollection*) self->priv->history);
				if (j < _tmp3_) {
					_tmp2_ = i < UNITY_APPLICATIONS_PLACE_RUNNER_MAX_HISTORY;
				} else {
					_tmp2_ = FALSE;
				}
				if (!_tmp2_) {
					break;
				}
				_tmp4_ = gee_list_get (self->priv->history, j);
				_tmp5_ = (gchar*) _tmp4_;
				_tmp6_ = g_strcmp0 (_tmp5_, last_command) == 0;
				_g_free0 (_tmp5_);
				if (_tmp6_) {
					continue;
				}
				_tmp7_ = gee_list_get (self->priv->history, j);
				_tmp8_ = (gchar*) _tmp7_;
				gee_abstract_collection_add ((GeeAbstractCollection*) new_history, _tmp8_);
				_g_free0 (_tmp8_);
				i++;
			}
		}
	}
	_tmp9_ = _g_object_ref0 ((GeeList*) new_history);
	_g_object_unref0 (self->priv->history);
	self->priv->history = _tmp9_;
	history_store = NULL;
	{
		GeeList* _tmp10_;
		GeeList* _command_list;
		gint _tmp11_;
		gint _command_size;
		gint _command_index;
		_tmp10_ = _g_object_ref0 (self->priv->history);
		_command_list = _tmp10_;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _command_list);
		_command_size = _tmp11_;
		_command_index = -1;
		while (TRUE) {
			gpointer _tmp12_ = NULL;
			gchar* command;
			gchar* _tmp13_;
			_command_index = _command_index + 1;
			if (!(_command_index < _command_size)) {
				break;
			}
			_tmp12_ = gee_list_get (_command_list, _command_index);
			command = (gchar*) _tmp12_;
			_tmp13_ = g_strdup (command);
			history_store = g_slist_prepend (history_store, _tmp13_);
			_g_free0 (command);
		}
		_g_object_unref0 (_command_list);
	}
	gconf_client_set_list (self->priv->client, UNITY_APPLICATIONS_PLACE_RUNNER_HISTORY_KEY, GCONF_VALUE_STRING, history_store, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch10_g_error;
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("runner.vala:461: Can't store the history: %s", e->message);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		__g_slist_free__g_free0_0 (history_store);
		_g_object_unref0 (new_history);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp14_ = unity_place_entry_info_get_active_search (self->place_entry);
	unity_applications_place_runner_update_search (self, _tmp14_, NULL, NULL);
	__g_slist_free__g_free0_0 (history_store);
	_g_object_unref0 (new_history);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	guint8* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = -1;
	_tmp0_ = strlen (self);
	res_length1 = (gint) _tmp0_;
	_tmp1_ = res;
	*result_length1 = res_length1;
	result = _tmp1_;
	return result;
}


static void unity_applications_place_runner_load_history (UnityApplicationsPlaceRunner* self) {
	gint i;
	GSList* _tmp0_ = NULL;
	GSList* history_store;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	i = 0;
	_tmp0_ = gconf_client_get_list (self->priv->client, UNITY_APPLICATIONS_PLACE_RUNNER_HISTORY_KEY, GCONF_VALUE_STRING, &_inner_error_);
	history_store = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch11_g_error;
	}
	{
		GSList* command_collection;
		GSList* command_it;
		command_collection = history_store;
		for (command_it = command_collection; command_it != NULL; command_it = command_it->next) {
			gchar* _tmp1_;
			gchar* command;
			_tmp1_ = g_strdup ((const gchar*) command_it->data);
			command = _tmp1_;
			{
				guint8* _tmp2_ = NULL;
				gint _tmp3_;
				if (i >= UNITY_APPLICATIONS_PLACE_RUNNER_MAX_HISTORY) {
					_g_free0 (command);
					break;
				}
				_tmp2_ = string_get_data (command, &_tmp3_);
				gee_list_insert (self->priv->history, 0, (const gchar*) _tmp2_);
				i++;
				_g_free0 (command);
			}
		}
	}
	__g_slist_free__g_free0_0 (history_store);
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("runner.vala:484: Can't access to the history: %s", e->message);
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void unity_applications_place_runner_load_about_entries (UnityApplicationsPlaceRunner* self) {
	UnityApplicationsPlaceAboutEntry* entry = NULL;
	gchar* name = NULL;
	gchar* exec = NULL;
	GIcon* icon = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GIcon* _tmp5_ = NULL;
	GIcon* _tmp6_;
	GIcon* _tmp7_;
	UnityApplicationsPlaceAboutEntry* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GThemedIcon* _tmp12_ = NULL;
	UnityApplicationsPlaceAboutEntry* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("about:config");
	_g_free0 (name);
	name = _tmp0_;
	_tmp1_ = g_strdup ("ccsm -p unityshell");
	_g_free0 (exec);
	exec = _tmp1_;
	_tmp2_ = string_to_string (CONFIG_PREFIX);
	_tmp3_ = g_strconcat (_tmp2_, "/share/ccsm/icons/hicolor/64x64/apps/plugin-unityshell.png", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_icon_new_for_string (_tmp4_, &_inner_error_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		goto __catch12_g_error;
	}
	_g_object_unref0 (icon);
	icon = _tmp7_;
	goto __finally12;
	__catch12_g_error:
	{
		GError * err;
		GThemedIcon* _tmp8_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("runner.vala:502: Can't find unityshell icon: %s", err->message);
		_tmp8_ = (GThemedIcon*) g_themed_icon_new ("gtk-execute");
		_g_object_unref0 (icon);
		icon = (GIcon*) _tmp8_;
		_g_error_free0 (err);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (icon);
		_g_free0 (exec);
		_g_free0 (name);
		_unity_applications_place_about_entry_unref0 (entry);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp9_ = unity_applications_place_about_entry_new (name, exec, icon);
	_unity_applications_place_about_entry_unref0 (entry);
	entry = _tmp9_;
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->about_entries, name, entry);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->about_entries, exec, entry);
	_tmp10_ = g_strdup ("Robots have a plan.");
	_g_free0 (name);
	name = _tmp10_;
	_tmp11_ = g_strdup ("firefox about:robots");
	_g_free0 (exec);
	exec = _tmp11_;
	_tmp12_ = (GThemedIcon*) g_themed_icon_new ("battery");
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp12_;
	_tmp13_ = unity_applications_place_about_entry_new (name, exec, icon);
	_unity_applications_place_about_entry_unref0 (entry);
	entry = _tmp13_;
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->about_entries, "about:robots", entry);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->about_entries, exec, entry);
	_g_object_unref0 (icon);
	_g_free0 (exec);
	_g_free0 (name);
	_unity_applications_place_about_entry_unref0 (entry);
}


static void unity_applications_place_runner_class_init (UnityApplicationsPlaceRunnerClass * klass) {
	unity_applications_place_runner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityApplicationsPlaceRunnerPrivate));
	G_OBJECT_CLASS (klass)->finalize = unity_applications_place_runner_finalize;
}


static void unity_applications_place_runner_instance_init (UnityApplicationsPlaceRunner * self) {
	self->priv = UNITY_APPLICATIONS_PLACE_RUNNER_GET_PRIVATE (self);
}


static void unity_applications_place_runner_finalize (GObject* obj) {
	UnityApplicationsPlaceRunner * self;
	self = UNITY_APPLICATIONS_PLACE_RUNNER (obj);
	_g_object_unref0 (self->priv->daemon);
	_g_object_unref0 (self->place_entry);
	_g_object_unref0 (self->priv->previous_search);
	_g_object_unref0 (self->priv->about_entries);
	_g_object_unref0 (self->priv->executables);
	_g_object_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->client);
	G_OBJECT_CLASS (unity_applications_place_runner_parent_class)->finalize (obj);
}


GType unity_applications_place_runner_get_type (void) {
	static volatile gsize unity_applications_place_runner_type_id__volatile = 0;
	if (g_once_init_enter (&unity_applications_place_runner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityApplicationsPlaceRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_applications_place_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityApplicationsPlaceRunner), 0, (GInstanceInitFunc) unity_applications_place_runner_instance_init, NULL };
		GType unity_applications_place_runner_type_id;
		unity_applications_place_runner_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityApplicationsPlaceRunner", &g_define_type_info, 0);
		g_once_init_leave (&unity_applications_place_runner_type_id__volatile, unity_applications_place_runner_type_id);
	}
	return unity_applications_place_runner_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



