/* url-checker.c generated by valac 0.14.2, the Vala compiler
 * generated from url-checker.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 * Modified by Angelo Compagnucci <angelo.compagnucci@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define UNITY_FILES_LENS_TYPE_URL_TYPE (unity_files_lens_url_type_get_type ())

#define UNITY_FILES_LENS_TYPE_URL_CHECKER (unity_files_lens_url_checker_get_type ())
#define UNITY_FILES_LENS_URL_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_FILES_LENS_TYPE_URL_CHECKER, UnityFilesLensUrlChecker))
#define UNITY_FILES_LENS_URL_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_FILES_LENS_TYPE_URL_CHECKER, UnityFilesLensUrlCheckerClass))
#define UNITY_FILES_LENS_IS_URL_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_FILES_LENS_TYPE_URL_CHECKER))
#define UNITY_FILES_LENS_IS_URL_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_FILES_LENS_TYPE_URL_CHECKER))
#define UNITY_FILES_LENS_URL_CHECKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_FILES_LENS_TYPE_URL_CHECKER, UnityFilesLensUrlCheckerClass))

typedef struct _UnityFilesLensUrlChecker UnityFilesLensUrlChecker;
typedef struct _UnityFilesLensUrlCheckerClass UnityFilesLensUrlCheckerClass;
typedef struct _UnityFilesLensUrlCheckerPrivate UnityFilesLensUrlCheckerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	UNITY_FILES_LENS_URL_TYPE_UNKNOWN,
	UNITY_FILES_LENS_URL_TYPE_WEB,
	UNITY_FILES_LENS_URL_TYPE_MOUNTABLE
} UnityFilesLensUrlType;

struct _UnityFilesLensUrlChecker {
	GObject parent_instance;
	UnityFilesLensUrlCheckerPrivate * priv;
};

struct _UnityFilesLensUrlCheckerClass {
	GObjectClass parent_class;
};

struct _UnityFilesLensUrlCheckerPrivate {
	gchar* _web_icon;
	gchar* _mountable_icon;
	GRegex* web_regex;
	GRegex* mountable_regex;
};


static gpointer unity_files_lens_url_checker_parent_class = NULL;

GType unity_files_lens_url_type_get_type (void) G_GNUC_CONST;
GType unity_files_lens_url_checker_get_type (void) G_GNUC_CONST;
#define UNITY_FILES_LENS_URL_CHECKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_FILES_LENS_TYPE_URL_CHECKER, UnityFilesLensUrlCheckerPrivate))
enum  {
	UNITY_FILES_LENS_URL_CHECKER_DUMMY_PROPERTY,
	UNITY_FILES_LENS_URL_CHECKER_WEB_ICON,
	UNITY_FILES_LENS_URL_CHECKER_MOUNTABLE_ICON
};
#define UNITY_FILES_LENS_URL_CHECKER_TLD_REGEX "(ac|ad|ae|aero|af|ag|ai|al|am|an|ao|aq|ar|arpa|" "as|asia|at|au|aw|ax|az|ba|bb|bd|be|bf|bg|bh|bi|biz|bj|bm|bn|bo|br|bs|b" \
"t|bv|bw|" "by|bz|ca|cat|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|com|coop|cr|cu|cv|cw|cx|" \
"cy|cz|de|" "dj|dk|dm|do|dz|ec|edu|ee|eg|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|" \
"gf|gg|gh|" "gi|gl|gm|gn|gov|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|" \
"in|info|" "int|io|iq|ir|is|it|je|jm|jo|jobs|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|l" \
"a|lb|lc|" "li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|me|mg|mh|mil|mk|ml|mm|mn|mo|mobi|mp|m" \
"q|mr|ms|mt|" "mu|museum|mv|mw|mx|my|mz|na|name|nc|ne|net|nf|ng|ni|nl|no|np|nr|nu|nz|" \
"om|org|pa|" "pe|pf|pg|ph|pk|pl|pm|pn|pr|pro|ps|pt|pw|py|qa|re|ro|rs|ru|rw|sa|sb|sc|" \
"sd|se|sg|" "sh|si|sj|sk|sl|sm|sn|so|sr|st|su|sv|sx|sy|sz|tc|td|tel|tf|tg|th|tj|tk|" \
"tl|tm|tn|" "to|tp|tr|travel|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|" \
"ws|xn|xxx|" "ye|yt|za|zm|zw|local|[0-9]{1,3})"
UnityFilesLensUrlChecker* unity_files_lens_url_checker_new (void);
UnityFilesLensUrlChecker* unity_files_lens_url_checker_construct (GType object_type);
static void unity_files_lens_url_checker_set_web_icon (UnityFilesLensUrlChecker* self, const gchar* value);
static void unity_files_lens_url_checker_set_mountable_icon (UnityFilesLensUrlChecker* self, const gchar* value);
gchar* unity_files_lens_url_checker_check_url (UnityFilesLensUrlChecker* self, const gchar* sample, UnityFilesLensUrlType* url_type);
gchar* unity_files_lens_url_checker_get_icon_for_type (UnityFilesLensUrlChecker* self, UnityFilesLensUrlType url_type);
const gchar* unity_files_lens_url_checker_get_web_icon (UnityFilesLensUrlChecker* self);
const gchar* unity_files_lens_url_checker_get_mountable_icon (UnityFilesLensUrlChecker* self);
static void unity_files_lens_url_checker_finalize (GObject* obj);
static void _vala_unity_files_lens_url_checker_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_files_lens_url_checker_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType unity_files_lens_url_type_get_type (void) {
	static volatile gsize unity_files_lens_url_type_type_id__volatile = 0;
	if (g_once_init_enter (&unity_files_lens_url_type_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_FILES_LENS_URL_TYPE_UNKNOWN, "UNITY_FILES_LENS_URL_TYPE_UNKNOWN", "unknown"}, {UNITY_FILES_LENS_URL_TYPE_WEB, "UNITY_FILES_LENS_URL_TYPE_WEB", "web"}, {UNITY_FILES_LENS_URL_TYPE_MOUNTABLE, "UNITY_FILES_LENS_URL_TYPE_MOUNTABLE", "mountable"}, {0, NULL, NULL}};
		GType unity_files_lens_url_type_type_id;
		unity_files_lens_url_type_type_id = g_enum_register_static ("UnityFilesLensUrlType", values);
		g_once_init_leave (&unity_files_lens_url_type_type_id__volatile, unity_files_lens_url_type_type_id);
	}
	return unity_files_lens_url_type_type_id__volatile;
}


UnityFilesLensUrlChecker* unity_files_lens_url_checker_construct (GType object_type) {
	UnityFilesLensUrlChecker * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GThemedIcon* _tmp4_;
	GThemedIcon* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	self = (UnityFilesLensUrlChecker*) g_object_new (object_type, NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("web-browser");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_icon_to_string ((GIcon*) _tmp1_);
	_tmp3_ = _tmp2_;
	unity_files_lens_url_checker_set_web_icon (self, _tmp3_);
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	_tmp4_ = (GThemedIcon*) g_themed_icon_new ("folder-remote");
	_tmp5_ = _tmp4_;
	_tmp6_ = g_icon_to_string ((GIcon*) _tmp5_);
	_tmp7_ = _tmp6_;
	unity_files_lens_url_checker_set_mountable_icon (self, _tmp7_);
	_g_free0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	{
		GRegex* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		GRegex* _tmp11_;
		_tmp8_ = g_regex_new ("(http[s]?://.+)|" "([a-zA-Z0-9\\-\\.]+\\." UNITY_FILES_LENS_URL_CHECKER_TLD_REGEX "\\b.*)", G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (self->priv->web_regex);
		self->priv->web_regex = _tmp9_;
		_tmp10_ = g_regex_new ("(\\\\|(ftp|ssh|sftp|smb|dav)://).+", 0, 0, &_inner_error_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (self->priv->mountable_regex);
		self->priv->mountable_regex = _tmp11_;
	}
	goto __finally10;
	__catch10_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("url-checker.vala:61: Error compiling regular expressions for URL match" \
"ing. URL launching will not work: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


UnityFilesLensUrlChecker* unity_files_lens_url_checker_new (void) {
	return unity_files_lens_url_checker_construct (UNITY_FILES_LENS_TYPE_URL_CHECKER);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally11;
	__catch11_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* unity_files_lens_url_checker_check_url (UnityFilesLensUrlChecker* self, const gchar* sample, UnityFilesLensUrlType* url_type) {
	UnityFilesLensUrlType _vala_url_type = 0;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	GRegex* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sample != NULL, NULL);
	_vala_url_type = UNITY_FILES_LENS_URL_TYPE_UNKNOWN;
	_tmp0_ = sample;
	_tmp1_ = string_strip (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		result = NULL;
		if (url_type) {
			*url_type = _vala_url_type;
		}
		return result;
	}
	_tmp4_ = self->priv->mountable_regex;
	_tmp5_ = sample;
	_tmp6_ = g_regex_match (_tmp4_, _tmp5_, 0, NULL);
	if (_tmp6_) {
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		_vala_url_type = UNITY_FILES_LENS_URL_TYPE_MOUNTABLE;
		_tmp7_ = sample;
		_tmp8_ = string_replace (_tmp7_, "\\\\", "smb://");
		result = _tmp8_;
		if (url_type) {
			*url_type = _vala_url_type;
		}
		return result;
	} else {
		GRegex* _tmp9_;
		const gchar* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = self->priv->web_regex;
		_tmp10_ = sample;
		_tmp11_ = g_regex_match (_tmp9_, _tmp10_, 0, NULL);
		if (_tmp11_) {
			gchar* _tmp12_ = NULL;
			const gchar* _tmp13_;
			gboolean _tmp14_ = FALSE;
			_vala_url_type = UNITY_FILES_LENS_URL_TYPE_WEB;
			_tmp13_ = sample;
			_tmp14_ = g_str_has_prefix (_tmp13_, "http");
			if (_tmp14_) {
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = sample;
				_tmp16_ = g_strdup (_tmp15_);
				_g_free0 (_tmp12_);
				_tmp12_ = _tmp16_;
			} else {
				const gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp17_ = sample;
				_tmp18_ = g_strconcat ("http://", _tmp17_, NULL);
				_g_free0 (_tmp12_);
				_tmp12_ = _tmp18_;
			}
			result = _tmp12_;
			if (url_type) {
				*url_type = _vala_url_type;
			}
			return result;
		}
	}
	result = NULL;
	if (url_type) {
		*url_type = _vala_url_type;
	}
	return result;
}


gchar* unity_files_lens_url_checker_get_icon_for_type (UnityFilesLensUrlChecker* self, UnityFilesLensUrlType url_type) {
	gchar* result = NULL;
	UnityFilesLensUrlType _tmp0_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = url_type;
	switch (_tmp0_) {
		case UNITY_FILES_LENS_URL_TYPE_WEB:
		{
			const gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp1_ = self->priv->_web_icon;
			_tmp2_ = g_strdup (_tmp1_);
			result = _tmp2_;
			return result;
		}
		case UNITY_FILES_LENS_URL_TYPE_MOUNTABLE:
		{
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = self->priv->_mountable_icon;
			_tmp4_ = g_strdup (_tmp3_);
			result = _tmp4_;
			return result;
		}
		default:
		break;
	}
	_tmp5_ = self->priv->_web_icon;
	_tmp6_ = g_strdup (_tmp5_);
	result = _tmp6_;
	return result;
}


const gchar* unity_files_lens_url_checker_get_web_icon (UnityFilesLensUrlChecker* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_web_icon;
	result = _tmp0_;
	return result;
}


static void unity_files_lens_url_checker_set_web_icon (UnityFilesLensUrlChecker* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_web_icon);
	self->priv->_web_icon = _tmp1_;
	g_object_notify ((GObject *) self, "web-icon");
}


const gchar* unity_files_lens_url_checker_get_mountable_icon (UnityFilesLensUrlChecker* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mountable_icon;
	result = _tmp0_;
	return result;
}


static void unity_files_lens_url_checker_set_mountable_icon (UnityFilesLensUrlChecker* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mountable_icon);
	self->priv->_mountable_icon = _tmp1_;
	g_object_notify ((GObject *) self, "mountable-icon");
}


static void unity_files_lens_url_checker_class_init (UnityFilesLensUrlCheckerClass * klass) {
	unity_files_lens_url_checker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityFilesLensUrlCheckerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_files_lens_url_checker_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_files_lens_url_checker_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_files_lens_url_checker_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_URL_CHECKER_WEB_ICON, g_param_spec_string ("web-icon", "web-icon", "web-icon", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_URL_CHECKER_MOUNTABLE_ICON, g_param_spec_string ("mountable-icon", "mountable-icon", "mountable-icon", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void unity_files_lens_url_checker_instance_init (UnityFilesLensUrlChecker * self) {
	self->priv = UNITY_FILES_LENS_URL_CHECKER_GET_PRIVATE (self);
}


static void unity_files_lens_url_checker_finalize (GObject* obj) {
	UnityFilesLensUrlChecker * self;
	self = UNITY_FILES_LENS_URL_CHECKER (obj);
	_g_free0 (self->priv->_web_icon);
	_g_free0 (self->priv->_mountable_icon);
	_g_regex_unref0 (self->priv->web_regex);
	_g_regex_unref0 (self->priv->mountable_regex);
	G_OBJECT_CLASS (unity_files_lens_url_checker_parent_class)->finalize (obj);
}


GType unity_files_lens_url_checker_get_type (void) {
	static volatile gsize unity_files_lens_url_checker_type_id__volatile = 0;
	if (g_once_init_enter (&unity_files_lens_url_checker_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityFilesLensUrlCheckerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_files_lens_url_checker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFilesLensUrlChecker), 0, (GInstanceInitFunc) unity_files_lens_url_checker_instance_init, NULL };
		GType unity_files_lens_url_checker_type_id;
		unity_files_lens_url_checker_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityFilesLensUrlChecker", &g_define_type_info, 0);
		g_once_init_leave (&unity_files_lens_url_checker_type_id__volatile, unity_files_lens_url_checker_type_id);
	}
	return unity_files_lens_url_checker_type_id__volatile;
}


static void _vala_unity_files_lens_url_checker_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityFilesLensUrlChecker * self;
	self = UNITY_FILES_LENS_URL_CHECKER (object);
	switch (property_id) {
		case UNITY_FILES_LENS_URL_CHECKER_WEB_ICON:
		g_value_set_string (value, unity_files_lens_url_checker_get_web_icon (self));
		break;
		case UNITY_FILES_LENS_URL_CHECKER_MOUNTABLE_ICON:
		g_value_set_string (value, unity_files_lens_url_checker_get_mountable_icon (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_files_lens_url_checker_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityFilesLensUrlChecker * self;
	self = UNITY_FILES_LENS_URL_CHECKER (object);
	switch (property_id) {
		case UNITY_FILES_LENS_URL_CHECKER_WEB_ICON:
		unity_files_lens_url_checker_set_web_icon (self, g_value_get_string (value));
		break;
		case UNITY_FILES_LENS_URL_CHECKER_MOUNTABLE_ICON:
		unity_files_lens_url_checker_set_mountable_icon (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



