/* utils.c generated by valac 0.14.0, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <unity.h>
#include <gee.h>
#include <pwd.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))



GAppInfo* unity_applications_lens_utils_get_app_info_for_actor (const gchar* actor);
gchar* unity_applications_lens_utils_get_desktop_id_for_actor (const gchar* actor);
gboolean unity_applications_lens_utils_check_actor_has_category (const gchar* actor, GeeSet* categories);
gboolean unity_applications_lens_utils_search_is_invalid (UnityLensSearch* search);
gboolean unity_applications_lens_utils_search_has_really_changed (UnityLensSearch* old_search, UnityLensSearch* new_search);
gchar* unity_applications_lens_utils_subst_tilde (const gchar* s);


GAppInfo* unity_applications_lens_utils_get_app_info_for_actor (const gchar* actor) {
	GAppInfo* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* desktop_id;
	UnityAppInfoManager* _tmp2_ = NULL;
	UnityAppInfoManager* _tmp3_;
	GAppInfo* _tmp4_ = NULL;
	GAppInfo* _tmp5_;
	g_return_val_if_fail (actor != NULL, NULL);
	_tmp0_ = actor;
	_tmp1_ = unity_applications_lens_utils_get_desktop_id_for_actor (_tmp0_);
	desktop_id = _tmp1_;
	_tmp2_ = unity_app_info_manager_get_instance ();
	_tmp3_ = _tmp2_;
	_tmp4_ = unity_app_info_manager_lookup (_tmp3_, desktop_id);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	_g_free0 (desktop_id);
	return result;
}


gboolean unity_applications_lens_utils_check_actor_has_category (const gchar* actor, GeeSet* categories) {
	gboolean result = FALSE;
	GeeSet* _tmp0_;
	UnityAppInfoManager* _tmp1_ = NULL;
	UnityAppInfoManager* appman;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* desktop_id;
	UnityAppInfoManager* _tmp4_;
	const gchar* _tmp5_;
	GAppInfo* _tmp6_ = NULL;
	GAppInfo* appinfo;
	GAppInfo* _tmp7_;
	UnityAppInfoManager* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_ = 0;
	gchar** _tmp11_ = NULL;
	gchar** actor_cats;
	gint actor_cats_length1;
	gint _actor_cats_size_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp13_;
	gint _tmp13__length1;
	g_return_val_if_fail (actor != NULL, FALSE);
	_tmp0_ = categories;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = unity_app_info_manager_get_instance ();
	appman = _tmp1_;
	_tmp2_ = actor;
	_tmp3_ = unity_applications_lens_utils_get_desktop_id_for_actor (_tmp2_);
	desktop_id = _tmp3_;
	_tmp4_ = appman;
	_tmp5_ = desktop_id;
	_tmp6_ = unity_app_info_manager_lookup (_tmp4_, _tmp5_);
	appinfo = _tmp6_;
	_tmp7_ = appinfo;
	if (_tmp7_ == NULL) {
		result = FALSE;
		_g_object_unref0 (appinfo);
		_g_free0 (desktop_id);
		_g_object_unref0 (appman);
		return result;
	}
	_tmp8_ = appman;
	_tmp9_ = desktop_id;
	_tmp11_ = unity_app_info_manager_get_categories (_tmp8_, _tmp9_, &_tmp10_);
	actor_cats = _tmp11_;
	actor_cats_length1 = _tmp10_;
	_actor_cats_size_ = actor_cats_length1;
	_tmp12_ = actor_cats;
	_tmp12__length1 = actor_cats_length1;
	if (_tmp12_ == NULL) {
		result = FALSE;
		_g_object_unref0 (appinfo);
		_g_free0 (desktop_id);
		_g_object_unref0 (appman);
		return result;
	}
	_tmp13_ = actor_cats;
	_tmp13__length1 = actor_cats_length1;
	{
		gchar** cat_collection = NULL;
		gint cat_collection_length1 = 0;
		gint _cat_collection_size_ = 0;
		gint cat_it = 0;
		cat_collection = _tmp13_;
		cat_collection_length1 = _tmp13__length1;
		for (cat_it = 0; cat_it < _tmp13__length1; cat_it = cat_it + 1) {
			gchar* _tmp14_;
			gchar* cat = NULL;
			_tmp14_ = g_strdup (cat_collection[cat_it]);
			cat = _tmp14_;
			{
				GeeSet* _tmp15_;
				const gchar* _tmp16_;
				gboolean _tmp17_ = FALSE;
				_tmp15_ = categories;
				_tmp16_ = cat;
				_tmp17_ = gee_collection_contains ((GeeCollection*) _tmp15_, _tmp16_);
				if (_tmp17_) {
					result = TRUE;
					_g_free0 (cat);
					_g_object_unref0 (appinfo);
					_g_free0 (desktop_id);
					_g_object_unref0 (appman);
					return result;
				}
				_g_free0 (cat);
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (appinfo);
	_g_free0 (desktop_id);
	_g_object_unref0 (appman);
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


gchar* unity_applications_lens_utils_get_desktop_id_for_actor (const gchar* actor) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_val_if_fail (actor != NULL, NULL);
	_tmp0_ = actor;
	_tmp1_ = g_str_has_prefix (_tmp0_, "application://");
	if (_tmp1_) {
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		_tmp2_ = actor;
		_tmp3_ = string_substring (_tmp2_, (glong) 14, (glong) (-1));
		result = _tmp3_;
		return result;
	} else {
		const gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = actor;
		_tmp5_ = g_str_has_prefix (_tmp4_, "app://");
		if (_tmp5_) {
			const gchar* _tmp6_;
			gchar* _tmp7_ = NULL;
			_tmp6_ = actor;
			_tmp7_ = string_substring (_tmp6_, (glong) 6, (glong) (-1));
			result = _tmp7_;
			return result;
		} else {
			const gchar* _tmp8_;
			gboolean _tmp9_ = FALSE;
			_tmp8_ = actor;
			_tmp9_ = g_str_has_prefix (_tmp8_, "/");
			if (_tmp9_) {
				const gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				_tmp10_ = actor;
				_tmp11_ = g_path_get_basename (_tmp10_);
				result = _tmp11_;
				return result;
			}
		}
	}
	_tmp12_ = actor;
	_tmp13_ = g_strdup (_tmp12_);
	result = _tmp13_;
	return result;
}


gboolean unity_applications_lens_utils_search_is_invalid (UnityLensSearch* search) {
	gboolean result = FALSE;
	UnityLensSearch* _tmp0_;
	UnityLensSearch* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	_tmp0_ = search;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	} else {
		UnityLensSearch* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = search;
		_tmp2_ = unity_lens_search_get_search_string (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_ == NULL) {
			result = TRUE;
			return result;
		}
	}
	_tmp4_ = search;
	_tmp5_ = unity_lens_search_get_search_string (_tmp4_);
	_tmp6_ = _tmp5_;
	result = g_strcmp0 (_tmp6_, "") == 0;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


gboolean unity_applications_lens_utils_search_has_really_changed (UnityLensSearch* old_search, UnityLensSearch* new_search) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	UnityLensSearch* _tmp1_;
	gboolean _tmp3_;
	gchar* s1 = NULL;
	gchar* s2 = NULL;
	UnityLensSearch* _tmp4_;
	_tmp1_ = old_search;
	if (_tmp1_ == NULL) {
		UnityLensSearch* _tmp2_;
		_tmp2_ = new_search;
		_tmp0_ = _tmp2_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = old_search;
	if (_tmp4_ == NULL) {
		result = TRUE;
		_g_free0 (s2);
		_g_free0 (s1);
		return result;
	} else {
		UnityLensSearch* _tmp5_;
		_tmp5_ = new_search;
		if (_tmp5_ == NULL) {
			UnityLensSearch* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_ = FALSE;
			const gchar* _tmp11_;
			gboolean _tmp15_;
			_tmp6_ = old_search;
			_tmp7_ = unity_lens_search_get_search_string (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (s2);
			s2 = _tmp9_;
			_tmp11_ = s2;
			if (_tmp11_ == NULL) {
				_tmp10_ = TRUE;
			} else {
				const gchar* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				_tmp12_ = s2;
				_tmp13_ = string_strip (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp10_ = g_strcmp0 (_tmp14_, "") == 0;
				_g_free0 (_tmp14_);
			}
			_tmp15_ = _tmp10_;
			if (_tmp15_) {
				result = FALSE;
				_g_free0 (s2);
				_g_free0 (s1);
				return result;
			} else {
				result = TRUE;
				_g_free0 (s2);
				_g_free0 (s1);
				return result;
			}
		} else {
			UnityLensSearch* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			UnityLensSearch* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			_tmp16_ = new_search;
			_tmp17_ = unity_lens_search_get_search_string (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup (_tmp18_);
			_g_free0 (s1);
			s1 = _tmp19_;
			_tmp20_ = old_search;
			_tmp21_ = unity_lens_search_get_search_string (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strdup (_tmp22_);
			_g_free0 (s2);
			s2 = _tmp23_;
			_tmp24_ = s1;
			if (_tmp24_ == NULL) {
				gboolean _tmp25_ = FALSE;
				const gchar* _tmp26_;
				gboolean _tmp30_;
				_tmp26_ = s2;
				if (_tmp26_ == NULL) {
					_tmp25_ = TRUE;
				} else {
					const gchar* _tmp27_;
					gchar* _tmp28_ = NULL;
					gchar* _tmp29_;
					_tmp27_ = s2;
					_tmp28_ = string_strip (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp25_ = g_strcmp0 (_tmp29_, "") == 0;
					_g_free0 (_tmp29_);
				}
				_tmp30_ = _tmp25_;
				if (_tmp30_) {
					result = FALSE;
					_g_free0 (s2);
					_g_free0 (s1);
					return result;
				} else {
					result = TRUE;
					_g_free0 (s2);
					_g_free0 (s1);
					return result;
				}
			} else {
				const gchar* _tmp31_;
				_tmp31_ = s2;
				if (_tmp31_ == NULL) {
					gboolean _tmp32_ = FALSE;
					const gchar* _tmp33_;
					gboolean _tmp37_;
					_tmp33_ = s1;
					if (_tmp33_ == NULL) {
						_tmp32_ = TRUE;
					} else {
						const gchar* _tmp34_;
						gchar* _tmp35_ = NULL;
						gchar* _tmp36_;
						_tmp34_ = s1;
						_tmp35_ = string_strip (_tmp34_);
						_tmp36_ = _tmp35_;
						_tmp32_ = g_strcmp0 (_tmp36_, "") == 0;
						_g_free0 (_tmp36_);
					}
					_tmp37_ = _tmp32_;
					if (_tmp37_) {
						result = FALSE;
						_g_free0 (s2);
						_g_free0 (s1);
						return result;
					} else {
						result = TRUE;
						_g_free0 (s2);
						_g_free0 (s1);
						return result;
					}
				} else {
					const gchar* _tmp38_;
					gchar* _tmp39_ = NULL;
					gchar* _tmp40_;
					const gchar* _tmp41_;
					gchar* _tmp42_ = NULL;
					gchar* _tmp43_;
					gboolean _tmp44_;
					_tmp38_ = s1;
					_tmp39_ = string_strip (_tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = s2;
					_tmp42_ = string_strip (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = g_strcmp0 (_tmp40_, _tmp43_) != 0;
					_g_free0 (_tmp43_);
					_g_free0 (_tmp40_);
					result = _tmp44_;
					_g_free0 (s2);
					_g_free0 (s1);
					return result;
				}
			}
		}
	}
	_g_free0 (s2);
	_g_free0 (s1);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar* unity_applications_lens_utils_subst_tilde (const gchar* s) {
	gchar* result = NULL;
	gint k = 0;
	gchar* name = NULL;
	struct passwd* pw = NULL;
	const gchar* _tmp0_;
	gchar _tmp1_ = '\0';
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean _tmp10_;
	const gchar* _tmp17_;
	gint _tmp18_ = 0;
	gint _tmp19_;
	const gchar* _tmp25_;
	struct passwd* _tmp26_ = NULL;
	struct passwd* _tmp27_;
	gint _tmp30_;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = s;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	if (_tmp1_ != '~') {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = s;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		_g_free0 (name);
		return result;
	}
	_tmp5_ = s;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == 1) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp8_;
		gchar _tmp9_ = '\0';
		_tmp8_ = s;
		_tmp9_ = string_get (_tmp8_, (glong) 1);
		_tmp4_ = _tmp9_ == '/';
	}
	_tmp10_ = _tmp4_;
	if (_tmp10_) {
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp11_ = g_get_home_dir ();
		_tmp12_ = s;
		_tmp13_ = string_substring (_tmp12_, (glong) 1, (glong) (-1));
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp11_, _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		result = _tmp16_;
		_g_free0 (name);
		return result;
	}
	_tmp17_ = s;
	_tmp18_ = string_index_of (_tmp17_, "/", 0);
	k = _tmp18_;
	_tmp19_ = k;
	if (_tmp19_ == (-1)) {
		const gchar* _tmp20_;
		gchar* _tmp21_ = NULL;
		_tmp20_ = s;
		_tmp21_ = string_substring (_tmp20_, (glong) 1, (glong) (-1));
		_g_free0 (name);
		name = _tmp21_;
	} else {
		const gchar* _tmp22_;
		gint _tmp23_;
		gchar* _tmp24_ = NULL;
		_tmp22_ = s;
		_tmp23_ = k;
		_tmp24_ = string_substring (_tmp22_, (glong) 1, (glong) (_tmp23_ - 1));
		_g_free0 (name);
		name = _tmp24_;
	}
	_tmp25_ = name;
	_tmp26_ = getpwnam (_tmp25_);
	pw = _tmp26_;
	_tmp27_ = pw;
	if (_tmp27_ == NULL) {
		const gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp28_ = s;
		_tmp29_ = g_strdup (_tmp28_);
		result = _tmp29_;
		_g_free0 (name);
		return result;
	}
	_tmp30_ = k;
	if (_tmp30_ == (-1)) {
		struct passwd* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp31_ = pw;
		_tmp32_ = _tmp31_->pw_dir;
		_tmp33_ = g_strdup (_tmp32_);
		result = _tmp33_;
		_g_free0 (name);
		return result;
	} else {
		struct passwd* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp34_ = pw;
		_tmp35_ = _tmp34_->pw_dir;
		_tmp36_ = s;
		_tmp37_ = k;
		_tmp38_ = string_substring (_tmp36_, (glong) _tmp37_, (glong) (-1));
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat (_tmp35_, _tmp39_, NULL);
		_tmp41_ = _tmp40_;
		_g_free0 (_tmp39_);
		result = _tmp41_;
		_g_free0 (name);
		return result;
	}
	_g_free0 (name);
}



