/* unity-greeter.c generated by valac 0.18.1, the Vala compiler
 * generated from unity-greeter.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Robert Ancell <robert.ancell@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-xlib.h>
#include <gtk/gtk.h>
#include <lightdm.h>
#include <canberra.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <cairo.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <gdk/gdkx.h>
#include <stdio.h>
#include "sys/mman.h"
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <unistd.h>
#include <float.h>
#include <math.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <gobject/gvaluecollector.h>


#define TYPE_UNITY_GREETER (unity_greeter_get_type ())
#define UNITY_GREETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNITY_GREETER, UnityGreeter))
#define UNITY_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNITY_GREETER, UnityGreeterClass))
#define IS_UNITY_GREETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNITY_GREETER))
#define IS_UNITY_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNITY_GREETER))
#define UNITY_GREETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNITY_GREETER, UnityGreeterClass))

typedef struct _UnityGreeter UnityGreeter;
typedef struct _UnityGreeterClass UnityGreeterClass;
typedef struct _UnityGreeterPrivate UnityGreeterPrivate;

#define TYPE_SETTINGS_DAEMON (settings_daemon_get_type ())
#define SETTINGS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_DAEMON, SettingsDaemon))
#define SETTINGS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_DAEMON, SettingsDaemonClass))
#define IS_SETTINGS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_DAEMON))
#define IS_SETTINGS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_DAEMON))
#define SETTINGS_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_DAEMON, SettingsDaemonClass))

typedef struct _SettingsDaemon SettingsDaemon;
typedef struct _SettingsDaemonClass SettingsDaemonClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _ca_context_destroy0(var) ((var == NULL) ? NULL : (var = (ca_context_destroy (var), NULL)))
#define _unity_greeter_unref0(var) ((var == NULL) ? NULL : (var = (unity_greeter_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_FADABLE_BOX (fadable_box_get_type ())
#define FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE_BOX, FadableBox))
#define FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADABLE_BOX, FadableBoxClass))
#define IS_FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE_BOX))
#define IS_FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADABLE_BOX))
#define FADABLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADABLE_BOX, FadableBoxClass))

typedef struct _FadableBox FadableBox;
typedef struct _FadableBoxClass FadableBoxClass;

#define TYPE_GREETER_LIST (greeter_list_get_type ())
#define GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GREETER_LIST, GreeterList))
#define GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GREETER_LIST, GreeterListClass))
#define IS_GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GREETER_LIST))
#define IS_GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GREETER_LIST))
#define GREETER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GREETER_LIST, GreeterListClass))

typedef struct _GreeterList GreeterList;
typedef struct _GreeterListClass GreeterListClass;

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;

#define BACKGROUND_TYPE_DRAW_FLAGS (background_draw_flags_get_type ())
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_USER_LIST (user_list_get_type ())
#define USER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST, UserList))
#define USER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST, UserListClass))
#define IS_USER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST))
#define IS_USER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST))
#define USER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST, UserListClass))

typedef struct _UserList UserList;
typedef struct _UserListClass UserListClass;

#define TYPE_MENU_BAR (menu_bar_get_type ())
#define MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENU_BAR, MenuBar))
#define MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENU_BAR, MenuBarClass))
#define IS_MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENU_BAR))
#define IS_MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENU_BAR))
#define MENU_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENU_BAR, MenuBarClass))

typedef struct _MenuBar MenuBar;
typedef struct _MenuBarClass MenuBarClass;

#define TYPE_LIST_STACK (list_stack_get_type ())
#define LIST_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_STACK, ListStack))
#define LIST_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_STACK, ListStackClass))
#define IS_LIST_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_STACK))
#define IS_LIST_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_STACK))
#define LIST_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_STACK, ListStackClass))

typedef struct _ListStack ListStack;
typedef struct _ListStackClass ListStackClass;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
typedef struct _ParamSpecUnityGreeter ParamSpecUnityGreeter;

struct _UnityGreeter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityGreeterPrivate * priv;
	gboolean test_mode;
};

struct _UnityGreeterClass {
	GTypeClass parent_class;
	void (*finalize) (UnityGreeter *self);
};

struct _UnityGreeterPrivate {
	gchar* state_file;
	GKeyFile* state;
	cairo_surface_t* background_surface;
	SettingsDaemon* settings_daemon;
	MainWindow* main_window;
	LightDMGreeter* greeter;
	ca_context* canberra_context;
};

typedef enum  {
	BACKGROUND_DRAW_FLAGS_NONE,
	BACKGROUND_DRAW_FLAGS_GRID
} BackgroundDrawFlags;

struct _MainWindow {
	GtkWindow parent_instance;
	MainWindowPrivate * priv;
	UserList* user_list;
	MenuBar* menubar;
	ListStack* stack;
};

struct _MainWindowClass {
	GtkWindowClass parent_class;
};

struct _ParamSpecUnityGreeter {
	GParamSpec parent_instance;
};


static gpointer unity_greeter_parent_class = NULL;
extern UnityGreeter* unity_greeter_singleton;
UnityGreeter* unity_greeter_singleton = NULL;
static GTimer* unity_greeter_log_timer;
static GTimer* unity_greeter_log_timer = NULL;

#define grid_size 40
gpointer unity_greeter_ref (gpointer instance);
void unity_greeter_unref (gpointer instance);
GParamSpec* param_spec_unity_greeter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_unity_greeter (GValue* value, gpointer v_object);
void value_take_unity_greeter (GValue* value, gpointer v_object);
gpointer value_get_unity_greeter (const GValue* value);
GType unity_greeter_get_type (void) G_GNUC_CONST;
GType settings_daemon_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define UNITY_GREETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_UNITY_GREETER, UnityGreeterPrivate))
enum  {
	UNITY_GREETER_DUMMY_PROPERTY
};
static UnityGreeter* unity_greeter_new (gboolean test_mode_);
static UnityGreeter* unity_greeter_construct (GType object_type, gboolean test_mode_);
static cairo_surface_t* unity_greeter_create_root_surface (GdkScreen* screen);
static void __lambda29_ (UnityGreeter* self, const gchar* text, LightDMMessageType type);
static void ___lambda29__lightdm_greeter_show_message (LightDMGreeter* _sender, const gchar* text, LightDMMessageType type, gpointer self);
static void __lambda30_ (UnityGreeter* self, const gchar* text, LightDMPromptType type);
static void ___lambda30__lightdm_greeter_show_prompt (LightDMGreeter* _sender, const gchar* text, LightDMPromptType type, gpointer self);
static void __lambda31_ (UnityGreeter* self);
static void ___lambda31__lightdm_greeter_autologin_timer_expired (LightDMGreeter* _sender, gpointer self);
static void __lambda32_ (UnityGreeter* self);
static void ___lambda32__lightdm_greeter_authentication_complete (LightDMGreeter* _sender, gpointer self);
SettingsDaemon* settings_daemon_new (void);
SettingsDaemon* settings_daemon_construct (GType object_type);
void settings_daemon_start (SettingsDaemon* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void settings_daemon_start_finish (SettingsDaemon* self, GAsyncResult* _res_);
MainWindow* main_window_new (void);
MainWindow* main_window_construct (GType object_type);
static void unity_greeter_start_fake_wm (UnityGreeter* self);
static gboolean unity_greeter_ready_cb (UnityGreeter* self);
static gboolean _unity_greeter_ready_cb_gsource_func (gpointer self);
gchar* unity_greeter_get_state (UnityGreeter* self, const gchar* key);
void unity_greeter_set_state (UnityGreeter* self, const gchar* key, const gchar* value);
GType fadable_box_get_type (void) G_GNUC_CONST;
GType greeter_list_get_type (void) G_GNUC_CONST;
void unity_greeter_push_list (UnityGreeter* self, GreeterList* widget);
void main_window_push_list (MainWindow* self, GreeterList* widget);
void unity_greeter_pop_list (UnityGreeter* self);
void main_window_pop_list (MainWindow* self);
void unity_greeter_add_style_class (GtkWidget* widget);
LightDMLayout* unity_greeter_get_layout_by_name (const gchar* name);
GType background_get_type (void) G_GNUC_CONST;
void unity_greeter_start_session (UnityGreeter* self, const gchar* session, Background* bg);
GType background_draw_flags_get_type (void) G_GNUC_CONST;
void background_draw_full (Background* self, cairo_t* c, BackgroundDrawFlags flags);
static void unity_greeter_refresh_background (GdkScreen* screen, cairo_surface_t* surface);
gboolean ug_settings_get_boolean (const gchar* key);
#define UG_SETTINGS_KEY_PLAY_READY_SOUND "play-ready-sound"
void unity_greeter_show (UnityGreeter* self);
void main_window_set_keyboard_state (MainWindow* self);
gboolean unity_greeter_is_authenticated (UnityGreeter* self);
void unity_greeter_authenticate (UnityGreeter* self, const gchar* userid);
void unity_greeter_authenticate_as_guest (UnityGreeter* self);
void unity_greeter_authenticate_remote (UnityGreeter* self, const gchar* session, const gchar* userid);
void unity_greeter_cancel_authentication (UnityGreeter* self);
void unity_greeter_respond (UnityGreeter* self, const gchar* response);
gchar* unity_greeter_authentication_user (UnityGreeter* self);
gchar* unity_greeter_default_session_hint (UnityGreeter* self);
gchar* unity_greeter_select_user_hint (UnityGreeter* self);
gboolean unity_greeter_show_manual_login_hint (UnityGreeter* self);
gboolean unity_greeter_show_remote_login_hint (UnityGreeter* self);
gboolean unity_greeter_hide_users_hint (UnityGreeter* self);
gboolean unity_greeter_has_guest_account_hint (UnityGreeter* self);
static GdkFilterReturn unity_greeter_focus_upon_map (UnityGreeter* self, GdkXEvent* gxevent, GdkEvent* event);
GType user_list_get_type (void) G_GNUC_CONST;
GType menu_bar_get_type (void) G_GNUC_CONST;
GType list_stack_get_type (void) G_GNUC_CONST;
GtkWindow* menu_bar_get_keyboard_window (MenuBar* self);
static GdkFilterReturn _unity_greeter_focus_upon_map_gdk_filter_func (GdkXEvent* xevent, GdkEvent* event, gpointer self);
static void unity_greeter_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message);
gint unity_greeter_main (gchar** args, int args_length1);
static void _unity_greeter_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
gchar* ug_settings_get_string (const gchar* key);
#define UG_SETTINGS_KEY_THEME_NAME "theme-name"
#define UG_SETTINGS_KEY_ICON_THEME_NAME "icon-theme-name"
#define UG_SETTINGS_KEY_FONT_NAME "font-name"
gdouble ug_settings_get_double (const gchar* key);
#define UG_SETTINGS_KEY_XFT_DPI "xft-dpi"
#define UG_SETTINGS_KEY_XFT_ANTIALIAS "xft-antialias"
#define UG_SETTINGS_KEY_XFT_HINTSTYLE "xft-hintstyle"
#define UG_SETTINGS_KEY_XFT_RGBA "xft-rgba"
static void g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void unity_greeter_finalize (UnityGreeter* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _unity_greeter_ref0 (gpointer self) {
	return self ? unity_greeter_ref (self) : NULL;
}


static void __lambda29_ (UnityGreeter* self, const gchar* text, LightDMMessageType type) {
	const gchar* _tmp0_;
	LightDMMessageType _tmp1_;
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	_tmp1_ = type;
	g_signal_emit_by_name (self, "show-message", _tmp0_, _tmp1_);
}


static void ___lambda29__lightdm_greeter_show_message (LightDMGreeter* _sender, const gchar* text, LightDMMessageType type, gpointer self) {
	__lambda29_ (self, text, type);
}


static void __lambda30_ (UnityGreeter* self, const gchar* text, LightDMPromptType type) {
	const gchar* _tmp0_;
	LightDMPromptType _tmp1_;
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	_tmp1_ = type;
	g_signal_emit_by_name (self, "show-prompt", _tmp0_, _tmp1_);
}


static void ___lambda30__lightdm_greeter_show_prompt (LightDMGreeter* _sender, const gchar* text, LightDMPromptType type, gpointer self) {
	__lambda30_ (self, text, type);
}


static void __lambda31_ (UnityGreeter* self) {
	LightDMGreeter* _tmp0_;
	_tmp0_ = self->priv->greeter;
	lightdm_greeter_authenticate_autologin (_tmp0_);
}


static void ___lambda31__lightdm_greeter_autologin_timer_expired (LightDMGreeter* _sender, gpointer self) {
	__lambda31_ (self);
}


static void __lambda32_ (UnityGreeter* self) {
	g_signal_emit_by_name (self, "authentication-complete");
}


static void ___lambda32__lightdm_greeter_authentication_complete (LightDMGreeter* _sender, gpointer self) {
	__lambda32_ (self);
}


static gboolean _unity_greeter_ready_cb_gsource_func (gpointer self) {
	gboolean result;
	result = unity_greeter_ready_cb (self);
	return result;
}


static UnityGreeter* unity_greeter_construct (GType object_type, gboolean test_mode_) {
	UnityGreeter* self = NULL;
	UnityGreeter* _tmp0_;
	gboolean _tmp1_;
	GdkScreen* _tmp2_ = NULL;
	cairo_surface_t* _tmp3_ = NULL;
	LightDMGreeter* _tmp4_;
	LightDMGreeter* _tmp5_;
	LightDMGreeter* _tmp6_;
	LightDMGreeter* _tmp7_;
	LightDMGreeter* _tmp8_;
	gboolean connected;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* state_dir;
	gchar* _tmp21_ = NULL;
	GKeyFile* _tmp22_;
	MainWindow* _tmp29_;
	GError * _inner_error_ = NULL;
	self = (UnityGreeter*) g_type_create_instance (object_type);
	_tmp0_ = _unity_greeter_ref0 (self);
	_unity_greeter_unref0 (unity_greeter_singleton);
	unity_greeter_singleton = _tmp0_;
	_tmp1_ = test_mode_;
	self->test_mode = _tmp1_;
	g_debug ("unity-greeter.vala:54: Creating background surface");
	_tmp2_ = gdk_screen_get_default ();
	_tmp3_ = unity_greeter_create_root_surface (_tmp2_);
	_cairo_surface_destroy0 (self->priv->background_surface);
	self->priv->background_surface = _tmp3_;
	_tmp4_ = lightdm_greeter_new ();
	_g_object_unref0 (self->priv->greeter);
	self->priv->greeter = _tmp4_;
	_tmp5_ = self->priv->greeter;
	g_signal_connect (_tmp5_, "show-message", (GCallback) ___lambda29__lightdm_greeter_show_message, self);
	_tmp6_ = self->priv->greeter;
	g_signal_connect (_tmp6_, "show-prompt", (GCallback) ___lambda30__lightdm_greeter_show_prompt, self);
	_tmp7_ = self->priv->greeter;
	g_signal_connect (_tmp7_, "autologin-timer-expired", (GCallback) ___lambda31__lightdm_greeter_autologin_timer_expired, self);
	_tmp8_ = self->priv->greeter;
	g_signal_connect (_tmp8_, "authentication-complete", (GCallback) ___lambda32__lightdm_greeter_authentication_complete, self);
	connected = FALSE;
	{
		LightDMGreeter* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		_tmp9_ = self->priv->greeter;
		_tmp10_ = lightdm_greeter_connect_sync (_tmp9_, &_inner_error_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			goto __catch20_g_error;
		}
		connected = _tmp11_;
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("unity-greeter.vala:69: Failed to connect to LightDM daemon");
		_g_error_free0 (e);
	}
	__finally20:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp13_ = connected;
	if (!_tmp13_) {
		gboolean _tmp14_;
		_tmp14_ = self->test_mode;
		_tmp12_ = !_tmp14_;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp15_ = _tmp12_;
	if (_tmp15_) {
		exit (EXIT_FAILURE);
	}
	_tmp16_ = self->test_mode;
	if (!_tmp16_) {
		SettingsDaemon* _tmp17_;
		SettingsDaemon* _tmp18_;
		_tmp17_ = settings_daemon_new ();
		_g_object_unref0 (self->priv->settings_daemon);
		self->priv->settings_daemon = _tmp17_;
		_tmp18_ = self->priv->settings_daemon;
		settings_daemon_start (_tmp18_, NULL, NULL);
	}
	_tmp19_ = g_get_user_cache_dir ();
	_tmp20_ = g_build_filename (_tmp19_, "unity-greeter", NULL);
	state_dir = _tmp20_;
	g_mkdir_with_parents (state_dir, 0775);
	_tmp21_ = g_build_filename (state_dir, "state", NULL);
	_g_free0 (self->priv->state_file);
	self->priv->state_file = _tmp21_;
	_tmp22_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->state);
	self->priv->state = _tmp22_;
	{
		GKeyFile* _tmp23_;
		const gchar* _tmp24_;
		_tmp23_ = self->priv->state;
		_tmp24_ = self->priv->state_file;
		g_key_file_load_from_file (_tmp23_, _tmp24_, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = e;
		if (!g_error_matches (_tmp25_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			const gchar* _tmp26_;
			GError* _tmp27_;
			const gchar* _tmp28_;
			_tmp26_ = self->priv->state_file;
			_tmp27_ = e;
			_tmp28_ = _tmp27_->message;
			g_warning ("unity-greeter.vala:92: Failed to load state from %s: %s\n", _tmp26_, _tmp28_);
		}
		_g_error_free0 (e);
	}
	__finally21:
	if (_inner_error_ != NULL) {
		_g_free0 (state_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp29_ = main_window_new ();
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->main_window);
	self->priv->main_window = _tmp29_;
	unity_greeter_start_fake_wm (self);
	gdk_threads_add_idle (_unity_greeter_ready_cb_gsource_func, self);
	_g_free0 (state_dir);
	return self;
}


static UnityGreeter* unity_greeter_new (gboolean test_mode_) {
	return unity_greeter_construct (TYPE_UNITY_GREETER, test_mode_);
}


gchar* unity_greeter_get_state (UnityGreeter* self, const gchar* key) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp0_ = self->priv->state;
		_tmp1_ = key;
		_tmp2_ = g_key_file_get_value (_tmp0_, "greeter", _tmp1_, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch22_g_error;
		}
		result = _tmp3_;
		return result;
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally22:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


void unity_greeter_set_state (UnityGreeter* self, const gchar* key, const gchar* value) {
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GKeyFile* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* data;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = key;
	_tmp2_ = value;
	g_key_file_set_value (_tmp0_, "greeter", _tmp1_, _tmp2_);
	_tmp3_ = self->priv->state;
	_tmp4_ = g_key_file_to_data (_tmp3_, NULL, NULL);
	data = _tmp4_;
	{
		const gchar* _tmp5_;
		_tmp5_ = self->priv->state_file;
		g_file_set_contents (_tmp5_, data, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch23_g_error;
		}
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_debug ("unity-greeter.vala:123: Failed to write state: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally23:
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (data);
}


void unity_greeter_push_list (UnityGreeter* self, GreeterList* widget) {
	MainWindow* _tmp0_;
	GreeterList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->main_window;
	_tmp1_ = widget;
	main_window_push_list (_tmp0_, _tmp1_);
}


void unity_greeter_pop_list (UnityGreeter* self) {
	MainWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_window;
	main_window_pop_list (_tmp0_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void unity_greeter_add_style_class (GtkWidget* widget) {
	GtkWidget* _tmp0_;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* ctx;
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_widget_get_style_context (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	ctx = _tmp2_;
	gtk_style_context_add_class (ctx, "lightdm");
	_g_object_unref0 (ctx);
}


LightDMLayout* unity_greeter_get_layout_by_name (const gchar* name) {
	LightDMLayout* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = lightdm_get_layouts ();
	{
		GList* layout_collection = NULL;
		GList* layout_it = NULL;
		layout_collection = _tmp0_;
		for (layout_it = layout_collection; layout_it != NULL; layout_it = layout_it->next) {
			LightDMLayout* layout = NULL;
			layout = (LightDMLayout*) layout_it->data;
			{
				LightDMLayout* _tmp1_;
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp1_ = layout;
				_tmp2_ = lightdm_layout_get_name (_tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = name;
				if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
					LightDMLayout* _tmp5_;
					LightDMLayout* _tmp6_;
					_tmp5_ = layout;
					_tmp6_ = _g_object_ref0 (_tmp5_);
					result = _tmp6_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


void unity_greeter_start_session (UnityGreeter* self, const gchar* session, Background* bg) {
	cairo_surface_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* c;
	Background* _tmp2_;
	cairo_t* _tmp3_;
	GdkScreen* _tmp4_ = NULL;
	cairo_surface_t* _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bg != NULL);
	_tmp0_ = self->priv->background_surface;
	_tmp1_ = cairo_create (_tmp0_);
	c = _tmp1_;
	_tmp2_ = bg;
	_tmp3_ = c;
	background_draw_full (_tmp2_, _tmp3_, BACKGROUND_DRAW_FLAGS_NONE);
	_cairo_destroy0 (c);
	c = NULL;
	_tmp4_ = gdk_screen_get_default ();
	_tmp5_ = self->priv->background_surface;
	unity_greeter_refresh_background (_tmp4_, _tmp5_);
	_tmp6_ = self->test_mode;
	if (_tmp6_) {
		g_debug ("unity-greeter.vala:164: Successfully logged in!  Quitting...");
		gtk_main_quit ();
	} else {
		g_signal_emit_by_name (self, "starting-session");
		{
			LightDMGreeter* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->greeter;
			_tmp8_ = session;
			lightdm_greeter_start_session_sync (_tmp7_, _tmp8_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch24_g_error;
			}
		}
		goto __finally24;
		__catch24_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("unity-greeter.vala:176: Failed to start session: %s", _tmp10_);
			_g_error_free0 (e);
		}
		__finally24:
		if (_inner_error_ != NULL) {
			_cairo_destroy0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_cairo_destroy0 (c);
}


static gboolean unity_greeter_ready_cb (UnityGreeter* self) {
	gboolean result = FALSE;
	ca_context* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_debug ("unity-greeter.vala:183: starting system-ready sound");
	ca_context_create (&_tmp0_);
	_ca_context_destroy0 (self->priv->canberra_context);
	self->priv->canberra_context = _tmp0_;
	_tmp1_ = ug_settings_get_boolean (UG_SETTINGS_KEY_PLAY_READY_SOUND);
	if (_tmp1_) {
		ca_context* _tmp2_;
		_tmp2_ = self->priv->canberra_context;
		ca_context_play (_tmp2_, (guint32) 0, CA_PROP_CANBERRA_XDG_THEME_NAME, "ubuntu", CA_PROP_EVENT_ID, "system-ready", NULL);
	}
	result = FALSE;
	return result;
}


void unity_greeter_show (UnityGreeter* self) {
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	GdkWindow* _tmp2_ = NULL;
	MainWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	g_debug ("unity-greeter.vala:200: Showing main window");
	_tmp0_ = self->priv->main_window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->main_window;
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) _tmp1_);
	gdk_window_focus (_tmp2_, (guint32) GDK_CURRENT_TIME);
	_tmp3_ = self->priv->main_window;
	main_window_set_keyboard_state (_tmp3_);
}


gboolean unity_greeter_is_authenticated (UnityGreeter* self) {
	gboolean result = FALSE;
	LightDMGreeter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->greeter;
	_tmp1_ = lightdm_greeter_get_is_authenticated (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void unity_greeter_authenticate (UnityGreeter* self, const gchar* userid) {
	LightDMGreeter* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->greeter;
	_tmp1_ = userid;
	lightdm_greeter_authenticate (_tmp0_, _tmp1_);
}


void unity_greeter_authenticate_as_guest (UnityGreeter* self) {
	LightDMGreeter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->greeter;
	lightdm_greeter_authenticate_as_guest (_tmp0_);
}


void unity_greeter_authenticate_remote (UnityGreeter* self, const gchar* session, const gchar* userid) {
	UnityGreeter* _tmp0_;
	LightDMGreeter* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = unity_greeter_singleton;
	_tmp1_ = _tmp0_->priv->greeter;
	_tmp2_ = session;
	_tmp3_ = userid;
	lightdm_greeter_authenticate_remote (_tmp1_, _tmp2_, _tmp3_);
}


void unity_greeter_cancel_authentication (UnityGreeter* self) {
	LightDMGreeter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->greeter;
	lightdm_greeter_cancel_authentication (_tmp0_);
}


void unity_greeter_respond (UnityGreeter* self, const gchar* response) {
	LightDMGreeter* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (response != NULL);
	_tmp0_ = self->priv->greeter;
	_tmp1_ = response;
	lightdm_greeter_respond (_tmp0_, _tmp1_);
}


gchar* unity_greeter_authentication_user (UnityGreeter* self) {
	gchar* result = NULL;
	LightDMGreeter* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->greeter;
	_tmp1_ = lightdm_greeter_get_authentication_user (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}


gchar* unity_greeter_default_session_hint (UnityGreeter* self) {
	gchar* result = NULL;
	LightDMGreeter* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->greeter;
	_tmp1_ = lightdm_greeter_get_default_session_hint (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}


gchar* unity_greeter_select_user_hint (UnityGreeter* self) {
	gchar* result = NULL;
	LightDMGreeter* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->greeter;
	_tmp1_ = lightdm_greeter_get_select_user_hint (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}


gboolean unity_greeter_show_manual_login_hint (UnityGreeter* self) {
	gboolean result = FALSE;
	LightDMGreeter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->greeter;
	_tmp1_ = lightdm_greeter_get_show_manual_login_hint (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


gboolean unity_greeter_show_remote_login_hint (UnityGreeter* self) {
	gboolean result = FALSE;
	LightDMGreeter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->greeter;
	_tmp1_ = lightdm_greeter_get_show_remote_login_hint (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


gboolean unity_greeter_hide_users_hint (UnityGreeter* self) {
	gboolean result = FALSE;
	LightDMGreeter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->greeter;
	_tmp1_ = lightdm_greeter_get_hide_users_hint (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


gboolean unity_greeter_has_guest_account_hint (UnityGreeter* self) {
	gboolean result = FALSE;
	LightDMGreeter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->greeter;
	_tmp1_ = lightdm_greeter_get_has_guest_account_hint (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static GdkFilterReturn unity_greeter_focus_upon_map (UnityGreeter* self, GdkXEvent* gxevent, GdkEvent* event) {
	GdkFilterReturn result = 0;
	GdkXEvent* _tmp0_;
	XEvent* xevent;
	XEvent* _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (gxevent != NULL, 0);
	g_return_val_if_fail (event != NULL, 0);
	_tmp0_ = gxevent;
	xevent = (XEvent*) _tmp0_;
	_tmp1_ = xevent;
	_tmp2_ = (*_tmp1_).type;
	if (_tmp2_ == ((gint) MapNotify)) {
		XEvent* _tmp3_;
		XMapEvent _tmp4_;
		Display* _tmp5_;
		GdkDisplay* _tmp6_ = NULL;
		GdkDisplay* _tmp7_;
		GdkDisplay* display;
		XEvent* _tmp8_;
		XMapEvent _tmp9_;
		Window _tmp10_;
		Window xwin;
		GdkDisplay* _tmp11_;
		Window _tmp12_;
		GdkWindow* _tmp13_ = NULL;
		GdkWindow* _tmp14_;
		GdkWindow* win;
		Window keyboard_xid;
		MainWindow* _tmp15_;
		MenuBar* _tmp16_;
		GtkWindow* _tmp17_;
		GtkWindow* _tmp18_;
		gboolean _tmp25_ = FALSE;
		Window _tmp26_;
		Window _tmp27_;
		gboolean _tmp30_;
		_tmp3_ = xevent;
		_tmp4_ = (*_tmp3_).xmap;
		_tmp5_ = _tmp4_.display;
		_tmp6_ = gdk_x11_lookup_xdisplay (_tmp5_);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		display = _tmp7_;
		_tmp8_ = xevent;
		_tmp9_ = (*_tmp8_).xmap;
		_tmp10_ = _tmp9_.window;
		xwin = _tmp10_;
		_tmp11_ = display;
		_tmp12_ = xwin;
		_tmp13_ = gdk_x11_window_foreign_new_for_display (_tmp11_, _tmp12_);
		_tmp14_ = _g_object_ref0 (_tmp13_);
		win = _tmp14_;
		keyboard_xid = (Window) 0;
		_tmp15_ = self->priv->main_window;
		_tmp16_ = _tmp15_->menubar;
		_tmp17_ = menu_bar_get_keyboard_window (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_ != NULL) {
			MainWindow* _tmp19_;
			MenuBar* _tmp20_;
			GtkWindow* _tmp21_;
			GtkWindow* _tmp22_;
			GdkWindow* _tmp23_ = NULL;
			Window _tmp24_ = 0;
			_tmp19_ = self->priv->main_window;
			_tmp20_ = _tmp19_->menubar;
			_tmp21_ = menu_bar_get_keyboard_window (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = gtk_widget_get_window ((GtkWidget*) _tmp22_);
			_tmp24_ = gdk_x11_window_get_xid (_tmp23_);
			keyboard_xid = _tmp24_;
		}
		_tmp26_ = xwin;
		_tmp27_ = keyboard_xid;
		if (_tmp26_ != _tmp27_) {
			GdkWindow* _tmp28_;
			GdkWindowTypeHint _tmp29_ = 0;
			_tmp28_ = win;
			_tmp29_ = gdk_window_get_type_hint (_tmp28_);
			_tmp25_ = _tmp29_ != GDK_WINDOW_TYPE_HINT_NOTIFICATION;
		} else {
			_tmp25_ = FALSE;
		}
		_tmp30_ = _tmp25_;
		if (_tmp30_) {
			GdkWindow* _tmp31_;
			MainWindow* _tmp32_;
			MenuBar* _tmp33_;
			GtkWindow* _tmp34_;
			GtkWindow* _tmp35_;
			_tmp31_ = win;
			gdk_window_focus (_tmp31_, (guint32) GDK_CURRENT_TIME);
			_tmp32_ = self->priv->main_window;
			_tmp33_ = _tmp32_->menubar;
			_tmp34_ = menu_bar_get_keyboard_window (_tmp33_);
			_tmp35_ = _tmp34_;
			if (_tmp35_ != NULL) {
				MainWindow* _tmp36_;
				MenuBar* _tmp37_;
				GtkWindow* _tmp38_;
				GtkWindow* _tmp39_;
				GdkWindow* _tmp40_ = NULL;
				_tmp36_ = self->priv->main_window;
				_tmp37_ = _tmp36_->menubar;
				_tmp38_ = menu_bar_get_keyboard_window (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = gtk_widget_get_window ((GtkWidget*) _tmp39_);
				gdk_window_raise (_tmp40_);
			}
		}
		_g_object_unref0 (win);
		_g_object_unref0 (display);
	} else {
		XEvent* _tmp41_;
		gint _tmp42_;
		_tmp41_ = xevent;
		_tmp42_ = (*_tmp41_).type;
		if (_tmp42_ == ((gint) UnmapNotify)) {
			Window xwin = 0;
			gint revert_to = 0;
			XEvent* _tmp43_;
			XUnmapEvent _tmp44_;
			Display* _tmp45_;
			Window _tmp46_ = 0;
			gint _tmp47_ = 0;
			gint _tmp48_;
			_tmp43_ = xevent;
			_tmp44_ = (*_tmp43_).xunmap;
			_tmp45_ = _tmp44_.display;
			XGetInputFocus (_tmp45_, &_tmp46_, &_tmp47_);
			xwin = _tmp46_;
			revert_to = _tmp47_;
			_tmp48_ = revert_to;
			if (_tmp48_ == ((gint) RevertToNone)) {
				MainWindow* _tmp49_;
				GdkWindow* _tmp50_ = NULL;
				MainWindow* _tmp51_;
				MenuBar* _tmp52_;
				GtkWindow* _tmp53_;
				GtkWindow* _tmp54_;
				_tmp49_ = self->priv->main_window;
				_tmp50_ = gtk_widget_get_window ((GtkWidget*) _tmp49_);
				gdk_window_focus (_tmp50_, (guint32) GDK_CURRENT_TIME);
				_tmp51_ = self->priv->main_window;
				_tmp52_ = _tmp51_->menubar;
				_tmp53_ = menu_bar_get_keyboard_window (_tmp52_);
				_tmp54_ = _tmp53_;
				if (_tmp54_ != NULL) {
					MainWindow* _tmp55_;
					MenuBar* _tmp56_;
					GtkWindow* _tmp57_;
					GtkWindow* _tmp58_;
					GdkWindow* _tmp59_ = NULL;
					_tmp55_ = self->priv->main_window;
					_tmp56_ = _tmp55_->menubar;
					_tmp57_ = menu_bar_get_keyboard_window (_tmp56_);
					_tmp58_ = _tmp57_;
					_tmp59_ = gtk_widget_get_window ((GtkWidget*) _tmp58_);
					gdk_window_raise (_tmp59_);
				}
			}
		}
	}
	result = GDK_FILTER_CONTINUE;
	return result;
}


static GdkFilterReturn _unity_greeter_focus_upon_map_gdk_filter_func (GdkXEvent* xevent, GdkEvent* event, gpointer self) {
	GdkFilterReturn result;
	result = unity_greeter_focus_upon_map (self, xevent, event);
	return result;
}


static void unity_greeter_start_fake_wm (UnityGreeter* self) {
	GdkWindow* _tmp0_ = NULL;
	GdkWindow* _tmp1_;
	GdkWindow* root;
	GdkEventMask _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_get_default_root_window ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	root = _tmp1_;
	_tmp2_ = gdk_window_get_events (root);
	gdk_window_set_events (root, _tmp2_ | GDK_SUBSTRUCTURE_MASK);
	gdk_window_add_filter (root, _unity_greeter_focus_upon_map_gdk_filter_func, self);
	_g_object_unref0 (root);
}


static cairo_surface_t* unity_greeter_create_root_surface (GdkScreen* screen) {
	cairo_surface_t* result = NULL;
	GdkScreen* _tmp0_;
	GdkVisual* _tmp1_ = NULL;
	GdkVisual* _tmp2_;
	GdkVisual* visual;
	GdkScreen* _tmp3_;
	GdkDisplay* _tmp4_ = NULL;
	Display* _tmp5_ = NULL;
	Display* display;
	GdkScreen* _tmp6_;
	GdkWindow* _tmp7_ = NULL;
	Window _tmp8_ = 0;
	GdkScreen* _tmp9_;
	gint _tmp10_ = 0;
	GdkScreen* _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint pixmap;
	Visual* _tmp15_ = NULL;
	GdkScreen* _tmp16_;
	gint _tmp17_ = 0;
	GdkScreen* _tmp18_;
	gint _tmp19_ = 0;
	cairo_surface_t* _tmp20_;
	cairo_surface_t* surface;
	g_return_val_if_fail (screen != NULL, NULL);
	_tmp0_ = screen;
	_tmp1_ = gdk_screen_get_system_visual (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	visual = _tmp2_;
	_tmp3_ = screen;
	_tmp4_ = gdk_screen_get_display (_tmp3_);
	_tmp5_ = gdk_x11_display_get_xdisplay (_tmp4_);
	display = _tmp5_;
	_tmp6_ = screen;
	_tmp7_ = gdk_screen_get_root_window (_tmp6_);
	_tmp8_ = gdk_x11_window_get_xid (_tmp7_);
	_tmp9_ = screen;
	_tmp10_ = gdk_screen_get_width (_tmp9_);
	_tmp11_ = screen;
	_tmp12_ = gdk_screen_get_height (_tmp11_);
	_tmp13_ = gdk_visual_get_depth (visual);
	_tmp14_ = XCreatePixmap (display, (Drawable) _tmp8_, (guint) _tmp10_, (guint) _tmp12_, (guint) _tmp13_);
	pixmap = _tmp14_;
	_tmp15_ = gdk_x11_visual_get_xvisual (visual);
	_tmp16_ = screen;
	_tmp17_ = gdk_screen_get_width (_tmp16_);
	_tmp18_ = screen;
	_tmp19_ = gdk_screen_get_height (_tmp18_);
	_tmp20_ = cairo_xlib_surface_create (display, pixmap, _tmp15_, _tmp17_, _tmp19_);
	surface = _tmp20_;
	result = surface;
	_g_object_unref0 (visual);
	return result;
}


static void unity_greeter_refresh_background (GdkScreen* screen, cairo_surface_t* surface) {
	GdkScreen* _tmp0_;
	GdkDisplay* _tmp1_ = NULL;
	Display* _tmp2_ = NULL;
	Display* display;
	cairo_surface_t* _tmp3_;
	GdkScreen* _tmp4_;
	GdkWindow* _tmp5_ = NULL;
	Window _tmp6_ = 0;
	cairo_surface_t* _tmp7_;
	gint _tmp8_ = 0;
	GdkScreen* _tmp9_;
	GdkWindow* _tmp10_ = NULL;
	Window _tmp11_ = 0;
	g_return_if_fail (screen != NULL);
	g_return_if_fail (surface != NULL);
	gdk_flush ();
	_tmp0_ = screen;
	_tmp1_ = gdk_screen_get_display (_tmp0_);
	_tmp2_ = gdk_x11_display_get_xdisplay (_tmp1_);
	display = _tmp2_;
	_tmp3_ = surface;
	cairo_surface_flush (_tmp3_);
	_tmp4_ = screen;
	_tmp5_ = gdk_screen_get_root_window (_tmp4_);
	_tmp6_ = gdk_x11_window_get_xid (_tmp5_);
	_tmp7_ = surface;
	_tmp8_ = cairo_xlib_surface_get_drawable (_tmp7_);
	XSetWindowBackgroundPixmap (display, _tmp6_, _tmp8_);
	_tmp9_ = screen;
	_tmp10_ = gdk_screen_get_root_window (_tmp9_);
	_tmp11_ = gdk_x11_window_get_xid (_tmp10_);
	XClearWindow (display, _tmp11_);
}


static void unity_greeter_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message) {
	gchar* prefix = NULL;
	GLogLevelFlags _tmp0_;
	FILE* _tmp8_;
	GTimer* _tmp9_;
	gdouble _tmp10_ = 0.0;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (message != NULL);
	_tmp0_ = log_level;
	switch (_tmp0_ & G_LOG_LEVEL_MASK) {
		case G_LOG_LEVEL_ERROR:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("ERROR:");
			_g_free0 (prefix);
			prefix = _tmp1_;
			break;
		}
		case G_LOG_LEVEL_CRITICAL:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("CRITICAL:");
			_g_free0 (prefix);
			prefix = _tmp2_;
			break;
		}
		case G_LOG_LEVEL_WARNING:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("WARNING:");
			_g_free0 (prefix);
			prefix = _tmp3_;
			break;
		}
		case G_LOG_LEVEL_MESSAGE:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("MESSAGE:");
			_g_free0 (prefix);
			prefix = _tmp4_;
			break;
		}
		case G_LOG_LEVEL_INFO:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("INFO:");
			_g_free0 (prefix);
			prefix = _tmp5_;
			break;
		}
		case G_LOG_LEVEL_DEBUG:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("DEBUG:");
			_g_free0 (prefix);
			prefix = _tmp6_;
			break;
		}
		default:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("LOG:");
			_g_free0 (prefix);
			prefix = _tmp7_;
			break;
		}
	}
	_tmp8_ = stderr;
	_tmp9_ = unity_greeter_log_timer;
	_tmp10_ = g_timer_elapsed (_tmp9_, NULL);
	_tmp11_ = prefix;
	_tmp12_ = message;
	fprintf (_tmp8_, "[%+.2fs] %s %s\n", _tmp10_, _tmp11_, _tmp12_);
	_g_free0 (prefix);
}


static void _unity_greeter_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	unity_greeter_log_cb (log_domain, log_levels, message);
}


gint unity_greeter_main (gchar** args, int args_length1) {
	gint result = 0;
	GPid atspi_pid;
	GTimer* _tmp6_;
	uid_t _tmp7_ = {0};
	const gchar* _tmp8_ = NULL;
	GdkWindow* _tmp9_ = NULL;
	GdkCursor* _tmp10_;
	GdkCursor* _tmp11_;
	gboolean do_show_version;
	gboolean do_test_mode;
	GOptionEntry _tmp12_ = {0};
	GOptionEntry versionOption;
	GOptionEntry _tmp13_ = {0};
	GOptionEntry testOption;
	GOptionEntry _tmp14_ = {0};
	GOptionEntry nullOption;
	GOptionEntry _tmp15_;
	GOptionEntry _tmp16_;
	GOptionEntry _tmp17_;
	GOptionEntry* _tmp18_ = NULL;
	GOptionEntry* options;
	gint options_length1;
	gint _options_size_;
	const gchar* _tmp19_ = NULL;
	GOptionContext* _tmp20_;
	GOptionContext* c;
	GOptionContext* _tmp21_;
	GOptionEntry* _tmp22_;
	gint _tmp22__length1;
	GOptionContext* _tmp23_;
	GOptionGroup* _tmp24_ = NULL;
	gboolean _tmp34_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	GtkSettings* _tmp40_ = NULL;
	GtkSettings* _tmp41_;
	GtkSettings* settings;
	gchar* _tmp42_ = NULL;
	gchar* value;
	const gchar* _tmp43_;
	gchar* _tmp46_ = NULL;
	const gchar* _tmp47_;
	gchar* _tmp50_ = NULL;
	const gchar* _tmp51_;
	gdouble _tmp54_ = 0.0;
	gdouble double_value;
	gdouble _tmp55_;
	gboolean _tmp58_ = FALSE;
	gboolean boolean_value;
	GtkSettings* _tmp59_;
	gboolean _tmp60_;
	gchar* _tmp61_ = NULL;
	const gchar* _tmp62_;
	gchar* _tmp65_ = NULL;
	const gchar* _tmp66_;
	gboolean _tmp69_;
	UnityGreeter* _tmp70_;
	UnityGreeter* greeter;
	UnityGreeter* _tmp71_;
	GPid _tmp72_;
	GError * _inner_error_ = NULL;
	mlockall (MCL_CURRENT | MCL_FUTURE);
	g_unsetenv ("UBUNTU_MENUPROXY");
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_setenv ("GTK_MODULES", "atk-bridge", FALSE);
	atspi_pid = (GPid) 0;
	{
		gchar** argv = NULL;
		gint argv_length1 = 0;
		gint _argv_size_ = 0;
		gchar** _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gchar** _tmp2_;
		gint _tmp2__length1;
		GPid _tmp3_ = 0;
		g_shell_parse_argv ("/usr/lib/at-spi2-core/at-spi-bus-launcher --launch-immediately", &_tmp1_, &_tmp0_, &_inner_error_);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		argv = _tmp0_;
		argv_length1 = _tmp1_;
		_argv_size_ = argv_length1;
		if (_inner_error_ != NULL) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			goto __catch25_g_error;
		}
		_tmp2_ = argv;
		_tmp2__length1 = argv_length1;
		g_spawn_async (NULL, _tmp2_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp3_, &_inner_error_);
		atspi_pid = _tmp3_;
		if (_inner_error_ != NULL) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			goto __catch25_g_error;
		}
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("unity-greeter.vala:432: Error starting the at-spi registry: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally25:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	gtk_init (&args_length1, &args);
	_tmp6_ = g_timer_new ();
	_g_timer_destroy0 (unity_greeter_log_timer);
	unity_greeter_log_timer = _tmp6_;
	g_log_set_default_handler (_unity_greeter_log_cb_glog_func, NULL);
	_tmp7_ = getuid ();
	_tmp8_ = g_getenv ("LANG");
	g_debug ("unity-greeter.vala:440: Starting unity-greeter %s UID=%d LANG=%s", VERSION, (gint) _tmp7_, _tmp8_);
	g_debug ("unity-greeter.vala:443: Setting cursor");
	_tmp9_ = gdk_get_default_root_window ();
	_tmp10_ = gdk_cursor_new (GDK_LEFT_PTR);
	_tmp11_ = _tmp10_;
	gdk_window_set_cursor (_tmp9_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	do_show_version = FALSE;
	do_test_mode = FALSE;
	_tmp12_.long_name = "version";
	_tmp12_.short_name = 'v';
	_tmp12_.flags = 0;
	_tmp12_.arg = G_OPTION_ARG_NONE;
	_tmp12_.arg_data = &do_show_version;
	_tmp12_.description = "Show release version";
	_tmp12_.arg_description = NULL;
	versionOption = _tmp12_;
	_tmp13_.long_name = "test-mode";
	_tmp13_.short_name = (gchar) 0;
	_tmp13_.flags = 0;
	_tmp13_.arg = G_OPTION_ARG_NONE;
	_tmp13_.arg_data = &do_test_mode;
	_tmp13_.description = "Run in test mode";
	_tmp13_.arg_description = NULL;
	testOption = _tmp13_;
	_tmp14_.long_name = NULL;
	nullOption = _tmp14_;
	_tmp15_ = versionOption;
	_tmp16_ = testOption;
	_tmp17_ = nullOption;
	_tmp18_ = g_new0 (GOptionEntry, 3);
	_tmp18_[0] = _tmp15_;
	_tmp18_[1] = _tmp16_;
	_tmp18_[2] = _tmp17_;
	options = _tmp18_;
	options_length1 = 3;
	_options_size_ = options_length1;
	g_debug ("unity-greeter.vala:457: Loading command line options");
	_tmp19_ = _ ("- Unity Greeter");
	_tmp20_ = g_option_context_new (_tmp19_);
	c = _tmp20_;
	_tmp21_ = c;
	_tmp22_ = options;
	_tmp22__length1 = options_length1;
	g_option_context_add_main_entries (_tmp21_, _tmp22_, GETTEXT_PACKAGE);
	_tmp23_ = c;
	_tmp24_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp23_, _tmp24_);
	{
		GOptionContext* _tmp25_;
		_tmp25_ = c;
		g_option_context_parse (_tmp25_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		FILE* _tmp26_;
		GError* _tmp27_;
		const gchar* _tmp28_;
		FILE* _tmp29_;
		const gchar* _tmp30_ = NULL;
		gchar** _tmp31_;
		gint _tmp31__length1;
		const gchar* _tmp32_;
		FILE* _tmp33_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = stderr;
		_tmp27_ = e;
		_tmp28_ = _tmp27_->message;
		fprintf (_tmp26_, "%s\n", _tmp28_);
		_tmp29_ = stderr;
		_tmp30_ = _ ("Run '%s --help' to see a full list of available command line options.");
		_tmp31_ = args;
		_tmp31__length1 = args_length1;
		_tmp32_ = _tmp31_[0];
		fprintf (_tmp29_, _tmp30_, _tmp32_);
		_tmp33_ = stderr;
		fprintf (_tmp33_, "\n");
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (c);
		options = (g_free (options), NULL);
		return result;
	}
	__finally26:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (c);
		options = (g_free (options), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp34_ = do_show_version;
	if (_tmp34_) {
		FILE* _tmp35_;
		_tmp35_ = stderr;
		fprintf (_tmp35_, "unity-greeter %s\n", VERSION);
		result = EXIT_SUCCESS;
		_g_option_context_free0 (c);
		options = (g_free (options), NULL);
		return result;
	}
	_tmp36_ = do_test_mode;
	if (_tmp36_) {
		g_debug ("unity-greeter.vala:482: Running in test mode");
	}
	_tmp37_ = do_test_mode;
	if (!_tmp37_) {
		g_setenv ("NM_APPLET_HIDE_POLICY_ITEMS", "1", TRUE);
		{
			g_spawn_command_line_async ("nm-applet", &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch27_g_error;
			}
		}
		goto __finally27;
		__catch27_g_error:
		{
			GError* e = NULL;
			GError* _tmp38_;
			const gchar* _tmp39_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp38_ = e;
			_tmp39_ = _tmp38_->message;
			g_warning ("unity-greeter.vala:495: Error starting nm-applet: %s", _tmp39_);
			_g_error_free0 (e);
		}
		__finally27:
		if (_inner_error_ != NULL) {
			_g_option_context_free0 (c);
			options = (g_free (options), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	g_debug ("unity-greeter.vala:500: Setting GTK+ settings");
	_tmp40_ = gtk_settings_get_default ();
	_tmp41_ = _g_object_ref0 (_tmp40_);
	settings = _tmp41_;
	_tmp42_ = ug_settings_get_string (UG_SETTINGS_KEY_THEME_NAME);
	value = _tmp42_;
	_tmp43_ = value;
	if (g_strcmp0 (_tmp43_, "") != 0) {
		GtkSettings* _tmp44_;
		const gchar* _tmp45_;
		_tmp44_ = settings;
		_tmp45_ = value;
		g_object_set ((GObject*) _tmp44_, "gtk-theme-name", _tmp45_, NULL, NULL);
	}
	_tmp46_ = ug_settings_get_string (UG_SETTINGS_KEY_ICON_THEME_NAME);
	_g_free0 (value);
	value = _tmp46_;
	_tmp47_ = value;
	if (g_strcmp0 (_tmp47_, "") != 0) {
		GtkSettings* _tmp48_;
		const gchar* _tmp49_;
		_tmp48_ = settings;
		_tmp49_ = value;
		g_object_set ((GObject*) _tmp48_, "gtk-icon-theme-name", _tmp49_, NULL, NULL);
	}
	_tmp50_ = ug_settings_get_string (UG_SETTINGS_KEY_FONT_NAME);
	_g_free0 (value);
	value = _tmp50_;
	_tmp51_ = value;
	if (g_strcmp0 (_tmp51_, "") != 0) {
		GtkSettings* _tmp52_;
		const gchar* _tmp53_;
		_tmp52_ = settings;
		_tmp53_ = value;
		g_object_set ((GObject*) _tmp52_, "gtk-font-name", _tmp53_, NULL, NULL);
	}
	_tmp54_ = ug_settings_get_double (UG_SETTINGS_KEY_XFT_DPI);
	double_value = _tmp54_;
	_tmp55_ = double_value;
	if (_tmp55_ != 0.0) {
		GtkSettings* _tmp56_;
		gdouble _tmp57_;
		_tmp56_ = settings;
		_tmp57_ = double_value;
		g_object_set ((GObject*) _tmp56_, "gtk-xft-dpi", (gint) (1024 * _tmp57_), NULL, NULL);
	}
	_tmp58_ = ug_settings_get_boolean (UG_SETTINGS_KEY_XFT_ANTIALIAS);
	boolean_value = _tmp58_;
	_tmp59_ = settings;
	_tmp60_ = boolean_value;
	g_object_set ((GObject*) _tmp59_, "gtk-xft-antialias", _tmp60_, NULL, NULL);
	_tmp61_ = ug_settings_get_string (UG_SETTINGS_KEY_XFT_HINTSTYLE);
	_g_free0 (value);
	value = _tmp61_;
	_tmp62_ = value;
	if (g_strcmp0 (_tmp62_, "") != 0) {
		GtkSettings* _tmp63_;
		const gchar* _tmp64_;
		_tmp63_ = settings;
		_tmp64_ = value;
		g_object_set ((GObject*) _tmp63_, "gtk-xft-hintstyle", _tmp64_, NULL, NULL);
	}
	_tmp65_ = ug_settings_get_string (UG_SETTINGS_KEY_XFT_RGBA);
	_g_free0 (value);
	value = _tmp65_;
	_tmp66_ = value;
	if (g_strcmp0 (_tmp66_, "") != 0) {
		GtkSettings* _tmp67_;
		const gchar* _tmp68_;
		_tmp67_ = settings;
		_tmp68_ = value;
		g_object_set ((GObject*) _tmp67_, "gtk-xft-rgba", _tmp68_, NULL, NULL);
	}
	g_debug ("unity-greeter.vala:523: Creating Unity Greeter");
	_tmp69_ = do_test_mode;
	_tmp70_ = unity_greeter_new (_tmp69_);
	greeter = _tmp70_;
	g_debug ("unity-greeter.vala:526: Showing greeter");
	_tmp71_ = greeter;
	unity_greeter_show (_tmp71_);
	g_debug ("unity-greeter.vala:529: Starting main loop");
	gtk_main ();
	_tmp72_ = atspi_pid;
	if (_tmp72_ != ((GPid) 0)) {
		GPid _tmp73_;
		gint status = 0;
		GPid _tmp74_;
		gint _tmp75_ = 0;
		_tmp73_ = atspi_pid;
		kill ((pid_t) _tmp73_, SIGKILL);
		_tmp74_ = atspi_pid;
		waitpid ((pid_t) _tmp74_, &_tmp75_, 0);
		status = _tmp75_;
		atspi_pid = (GPid) 0;
	}
	result = EXIT_SUCCESS;
	_unity_greeter_unref0 (greeter);
	_g_free0 (value);
	_g_object_unref0 (settings);
	_g_option_context_free0 (c);
	options = (g_free (options), NULL);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return unity_greeter_main (argv, argc);
}


static void g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_INT) (gpointer data1, const char* arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void value_unity_greeter_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_unity_greeter_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_greeter_unref (value->data[0].v_pointer);
	}
}


static void value_unity_greeter_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_greeter_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_unity_greeter_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_unity_greeter_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityGreeter* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_greeter_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_unity_greeter_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityGreeter** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_greeter_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_unity_greeter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecUnityGreeter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_UNITY_GREETER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_unity_greeter (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNITY_GREETER), NULL);
	return value->data[0].v_pointer;
}


void value_set_unity_greeter (GValue* value, gpointer v_object) {
	UnityGreeter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNITY_GREETER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UNITY_GREETER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_greeter_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_greeter_unref (old);
	}
}


void value_take_unity_greeter (GValue* value, gpointer v_object) {
	UnityGreeter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNITY_GREETER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UNITY_GREETER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_greeter_unref (old);
	}
}


static void unity_greeter_class_init (UnityGreeterClass * klass) {
	unity_greeter_parent_class = g_type_class_peek_parent (klass);
	UNITY_GREETER_CLASS (klass)->finalize = unity_greeter_finalize;
	g_type_class_add_private (klass, sizeof (UnityGreeterPrivate));
	g_signal_new ("show_message", TYPE_UNITY_GREETER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_INT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_INT);
	g_signal_new ("show_prompt", TYPE_UNITY_GREETER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_INT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_INT);
	g_signal_new ("authentication_complete", TYPE_UNITY_GREETER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("starting_session", TYPE_UNITY_GREETER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void unity_greeter_instance_init (UnityGreeter * self) {
	self->priv = UNITY_GREETER_GET_PRIVATE (self);
	self->test_mode = FALSE;
	self->ref_count = 1;
}


static void unity_greeter_finalize (UnityGreeter* obj) {
	UnityGreeter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNITY_GREETER, UnityGreeter);
	_g_free0 (self->priv->state_file);
	_g_key_file_unref0 (self->priv->state);
	_cairo_surface_destroy0 (self->priv->background_surface);
	_g_object_unref0 (self->priv->settings_daemon);
	_g_object_unref0 (self->priv->main_window);
	_g_object_unref0 (self->priv->greeter);
	_ca_context_destroy0 (self->priv->canberra_context);
}


GType unity_greeter_get_type (void) {
	static volatile gsize unity_greeter_type_id__volatile = 0;
	if (g_once_init_enter (&unity_greeter_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_unity_greeter_init, value_unity_greeter_free_value, value_unity_greeter_copy_value, value_unity_greeter_peek_pointer, "p", value_unity_greeter_collect_value, "p", value_unity_greeter_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityGreeterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_greeter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityGreeter), 0, (GInstanceInitFunc) unity_greeter_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_greeter_type_id;
		unity_greeter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityGreeter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_greeter_type_id__volatile, unity_greeter_type_id);
	}
	return unity_greeter_type_id__volatile;
}


gpointer unity_greeter_ref (gpointer instance) {
	UnityGreeter* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_greeter_unref (gpointer instance) {
	UnityGreeter* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_GREETER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



