// -*- mode: js; js-indent-level: 4; indent-tabs-mode: nil -*-

var Cu = Components.utils;
var Ci = Components.interfaces;
var Cc = Components.classes;
var Cr = Components.results;
var Cm = Components.manager;

Cu.import("resource://gre/modules/XPCOMUtils.jsm");
Cu.import("resource://gre/modules/Services.jsm");

Cu.import("resource://unity/chromeless.js");

const CONTRACT_ID = "@mozilla.org/commandlinehandler/general-startup;1?type=chromeless";
const CLASS_ID = Components.ID('{0d43c900-cbb9-11e1-9b23-0800200c9a66}');
const CLASS_NAME = "UnityCommandLineHandler";

var prefs = Cc["@mozilla.org/preferences-service;1"]
    .getService(Components.interfaces.nsIPrefService);

function CommandLineHandler() {
};

CommandLineHandler.prototype = {
    classDescription: CLASS_NAME,
    classID: CLASS_ID,
    contractID: CONTRACT_ID,
    _xpcom_categories: [{
        category: "command-line-handler",
        entry: "m-chromeless"
    }],

    QueryInterface: XPCOMUtils.generateQI([ Ci.nsICommandLineHandler ]),

    handle : function clh_handle(cmdLine) {
        if (cmdLine.handleFlag("chromeless", false)) {
            Chromeless.activate();
            cmdLine.preventDefault = false;
            if (cmdLine.length == 1) {
                var arg = cmdLine.getArgument(0);

                if (arg.match('https?://')) {
                    var browserPrefs = prefs.getBranch("browser.newtab.");
                    browserPrefs.setCharPref('url', arg);
                }
            }
        }
    },

    helpInfo : "  -chromeless        Chromeless mode.\n"
};

var NSGetFactory = XPCOMUtils.generateNSGetFactory([CommandLineHandler]);
