// -*- mode: js; js-indent-level: 4; indent-tabs-mode: nil -*-

var Cu = Components.utils;
var Ci = Components.interfaces;
var Cc = Components.classes;
var Cr = Components.results;
var Cm = Components.manager;

var sss = Cc["@mozilla.org/content/style-sheet-service;1"].getService(Ci.nsIStyleSheetService);
var ios = Cc["@mozilla.org/network/io-service;1"].getService(Ci.nsIIOService);

var Chromeless = {
    _activated: false,

    activate: function () {
        var uri = ios.newURI("chrome://unity/skin/chromeless.css", null, null);
        sss.loadAndRegisterSheet(uri, sss.USER_SHEET);

        Chromeless._activated = true;
    },

    deactivate: function () {
        if (Chromeless._activated) {
            var uri = ios.newURI("chrome://unity/skin/chromeless.css", null, null);
            sss.unregisterSheet(uri, sss.USER_SHEET);

            Chromeless._activated = false;
        }
    }
}

var EXPORTED_SYMBOLS = [ "Chromeless" ];
