# -*- coding: utf-8 -*-

# Authors: Natalia B. Bidart <nataliabidart@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Tests for the control panel cache."""

from ubuntuone.controlpanel import backend, cache
from ubuntuone.controlpanel.tests import TestCase


class FakedBackend(object):
    """A faked backend."""


class CacheTestCase(TestCase):
    """Test suite for the Cache object."""

    def setUp(self):
        super(CacheTestCase, self).setUp()
        self.patch(backend, 'ControlBackend', object)
        self.obj = cache.Cache()
        self.addCleanup(self.obj.clear)

    def test_backend(self):
        """The backend instance is successfully created."""
        self.assertIsInstance(self.obj.backend, cache.backend.ControlBackend)

    def test_set_backend(self):
        """The backend instance is successfully assigned."""
        expected = object()
        assert self.obj.backend is not expected
        self.obj.backend = expected
        self.assertTrue(self.obj.backend is expected)

    def test_backend_is_cached(self):
        """The backend instance is cached."""
        obj2 = cache.Cache()
        self.assertTrue(self.obj.backend is obj2.backend)

    def test_clear(self):
        """The cached stuff are cleared."""
        old_backend = self.obj.backend
        self.obj.clear()
        self.assertFalse(self.obj.backend is old_backend)
