# -*- coding: utf-8 -*-

# Authors: Alejandro J. Cura <alecu@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Tests for the Qt UI."""

from ubuntuone.controlpanel.gui.qt import gui
from ubuntuone.controlpanel.gui.qt.tests import BaseTestCase


class MainWindowTestCase(BaseTestCase):
    """Test the qt main window."""

    innerclass_ui = gui.mainwindow_ui
    innerclass_name = "Ui_MainWindow"
    class_ui = gui.MainWindow

    def test_close_event_calls_custom_close_callback(self):
        """When closing the window, close_callback is called."""
        self.ui.close_callback = self._set_called
        self.ui.closeEvent(event=gui.QtGui.QCloseEvent())
        self.assertEqual(self._called,
                         ((), {}), 'close_callback called.')

    def test_close_callback_can_be_none(self):
        """The close_callback can be None."""
        self.ui.close_callback = None
        self.ui.closeEvent(event=gui.QtGui.QCloseEvent())
        # world did not explode

    def test_on_signin_canceled(self):
        """On SigninPanel's signinCanceled, close."""
        self.patch(self.ui, 'closeEvent', self._set_called)
        self.ui.ui.control_panel.ui.signin.signinCanceled.emit()
        self.assertEqual(len(self._called[0]), 1)
        self.assertIsInstance(self._called[0][0], gui.QtGui.QCloseEvent)
