# -*- coding: utf-8 -*-

# Author: Alejandro J. Cura <alecu@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Tests for the account tab."""

from twisted.internet import defer

from ubuntuone.controlpanel.gui.qt import account as gui
from ubuntuone.controlpanel.gui.qt.tests import (
    SAMPLE_ACCOUNT_INFO, SAMPLE_EMAIL, SAMPLE_NAME, SAMPLE_PLAN,
)
from ubuntuone.controlpanel.gui.qt.tests.test_ubuntuonebin import (
    UbuntuOneBinTestCase,
)


class AccountPanelTestCase(UbuntuOneBinTestCase):
    """Test the qt control panel."""

    innerclass_ui = gui.account_ui
    innerclass_name = "Ui_Form"
    class_ui = gui.AccountPanel

    @defer.inlineCallbacks
    def setUp(self):
        yield super(AccountPanelTestCase, self).setUp()
        self.ui.backend.next_result = SAMPLE_ACCOUNT_INFO

    def test_is_processing_while_asking_info(self):
        """The ui is processing while the contents are loaded."""
        def check():
            """The ui must be is_processing."""
            self.assertTrue(self.ui.is_processing, 'ui must be processing')
            return SAMPLE_ACCOUNT_INFO

        self.patch(self.ui.backend, 'account_info', check)

        return self.ui.load()  # trigger the info request

    def test_is_not_processing_after_info_ready(self):
        """The ui is not processing when contents are load."""
        self.ui.process_info(SAMPLE_ACCOUNT_INFO)

        self.assertFalse(self.ui.is_processing)

    @defer.inlineCallbacks
    def test_info_is_requested_on_load(self):
        """The info is requested to the backend."""
        yield self.ui.load()
        self.assert_backend_called('account_info')

    def test_process_info(self):
        """The info is processed when ready."""
        self.ui.process_info(SAMPLE_ACCOUNT_INFO)
        self.assertEqual(self.ui.ui.name_label.text(), SAMPLE_NAME)
        self.assertEqual(self.ui.ui.email_label.text(), SAMPLE_EMAIL)
        self.assertEqual(self.ui.ui.services_description_label.text(),
                         SAMPLE_PLAN)

    def test_edit_account_button(self):
        """When clicking the edit account button, the proper url is opened."""
        self.assert_uri_hook_called(self.ui.ui.edit_profile_button,
                                    gui.EDIT_PROFILE_LINK)

    def test_edit_services_button(self):
        """When clicking the mobile plan button, the proper url is opened."""
        self.assert_uri_hook_called(self.ui.ui.edit_services_button,
                                    gui.EDIT_ACCOUNT_LINK)
