# tests.platform.linux.test_notification
#
# Author: Eric Casteleijn <eric.casteleijn@canonical.com>
#
# Copyright 2010 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Test the notification on linux. These tests are kind of stupid, but at
least they ensure 100% coverage and hence no silly/syntax errors.

"""


from mocker import MockerTestCase as TestCase

from ubuntuone.platform.linux.notification import Notification, ICON_NAME

FAKE_APP_NAME = "Teh wonderful app."
FAKE_TITLE = "Sous titre"
FAKE_MESSAGE = "Oi! You there!"
FAKE_APPENDAGE = "Appendix I."
FAKE_ICON = "fakicon"
FAKE_NEW_TITLE = "Nouveau titre"
FAKE_NEW_MESSAGE = "HELLOOOOOO"
FAKE_NEW_ICON = "novicon"


def callback(indicator, message_time=None):
    """Dummy callback."""
    pass


class NotificationTestCase(TestCase):
    """Test the Messaging API."""

    def test_send_notification(self):
        """On notification, pynotify receives the proper calls."""
        mock_notify = self.mocker.replace("pynotify")
        mock_notify.init(FAKE_APP_NAME)
        mock_notify.Notification(FAKE_TITLE, FAKE_MESSAGE, ICON_NAME)
        mock_notification = self.mocker.mock()
        self.mocker.result(mock_notification)
        mock_notification.show()
        self.mocker.replay()
        Notification(FAKE_APP_NAME).send_notification(FAKE_TITLE, FAKE_MESSAGE)

    def test_send_two_notifications(self):
        """On notification, pynotify receives the proper calls."""
        mock_notify = self.mocker.replace("pynotify")
        mock_notify.init(FAKE_APP_NAME)
        mock_notify.Notification(FAKE_TITLE, FAKE_MESSAGE, ICON_NAME)
        mock_notification = self.mocker.mock()
        self.mocker.result(mock_notification)
        mock_notification.show()
        mock_notification.update(
            FAKE_TITLE + '2', FAKE_MESSAGE + '2', ICON_NAME)
        mock_notification.show()
        self.mocker.replay()
        notifier = Notification(FAKE_APP_NAME)
        notifier.send_notification(FAKE_TITLE, FAKE_MESSAGE)
        notifier.send_notification(FAKE_TITLE + '2', FAKE_MESSAGE + '2')

    def test_send_notification_with_icon(self):
        """On notification with icon, pynotify receives the proper calls."""
        mock_notify = self.mocker.replace("pynotify")
        mock_notify.init(FAKE_APP_NAME)
        mock_notify.Notification(FAKE_TITLE, FAKE_MESSAGE, FAKE_ICON)
        mock_notification = self.mocker.mock()
        self.mocker.result(mock_notification)
        mock_notification.show()
        self.mocker.replay()
        Notification(FAKE_APP_NAME).send_notification(
            FAKE_TITLE, FAKE_MESSAGE, FAKE_ICON)

    def test_append_notification(self):
        """On notification append, pynotify receives the proper calls."""
        mock_notify = self.mocker.replace("pynotify")
        mock_notify.init(FAKE_APP_NAME)
        mock_notify.Notification(FAKE_TITLE, FAKE_MESSAGE, ICON_NAME)
        mock_notification = self.mocker.mock()
        self.mocker.result(mock_notification)
        mock_notification.set_hint_string('x-canonical-append', '')
        mock_notification.show()
        mock_notification.update(FAKE_TITLE, FAKE_APPENDAGE, ICON_NAME)
        mock_notification.set_hint_string('x-canonical-append', '')
        mock_notification.show()
        self.mocker.replay()
        notifier = Notification(FAKE_APP_NAME)
        notifier.send_notification(FAKE_TITLE, FAKE_MESSAGE, append=True)
        notifier.send_notification(FAKE_TITLE, FAKE_APPENDAGE, append=True)
