# -*- coding: utf-8 -*-
#
# Copyright 2009 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Tests for the Ubuntu SSO library."""

import os

from twisted.internet import defer
from twisted.trial import unittest

from ubuntu_sso.keyring import get_token_name

APP_NAME = u'The Super App!'
CAPTCHA_ID = u'test'
CAPTCHA_PATH = os.path.abspath(os.path.join(os.curdir, 'ubuntu_sso', 'tests',
                                            'files', 'captcha.png'))
CAPTCHA_SOLUTION = u'william Byrd'
EMAIL = u'test@example.com'
EMAIL_TOKEN = u'B2Pgtf'
GTK_GUI_CLASS = 'UbuntuSSOClientGUI'
GTK_GUI_MODULE = 'ubuntu_sso.gtk.gui'
HELP_TEXT = """Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam sed
lorem nibh. Suspendisse gravida nulla non nunc suscipit pulvinar tempus ut
augue. Morbi consequat, ligula a elementum pretium, dolor nulla tempus metus,
sed viverra nisi risus non velit."""
NAME = u'Juanito Pérez'
PASSWORD = u'h3lloWorld'
PING_URL = u'http://localhost/ping-me/'
RESET_PASSWORD_TOKEN = u'8G5Wtq'
TOKEN = {u'consumer_key': u'xQ7xDAz',
         u'consumer_secret': u'KzCJWCTNbbntwfyCKKjomJDzlgqxLy',
         u'token_name': u'test',
         u'token': u'GkInOfSMGwTXAUoVQwLUoPxElEEUdhsLVNTPhxHJDUIeHCPNEo',
         u'token_secret': u'qFYImEtlczPbsCnYyuwLoPDlPEnvNcIktZphPQklAWrvyfFMV'}
TOKEN_NAME = get_token_name(APP_NAME)
TC_URL = u'http://localhost/'
WINDOW_ID = 5


class TestCase(unittest.TestCase):
    """Customized test case that keeps tracks of method calls."""

    @defer.inlineCallbacks
    def setUp(self):
        yield super(TestCase, self).setUp()
        self._called = False

    def _set_called(self, *args, **kwargs):
        """Keep track of a method call."""
        self._called = (args, kwargs)
