/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ubufox.
 *
 * The Initial Developer of the Original Code is
 * Canonical Ltd.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Chris Coulson <chris.coulson@canonical.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var EXPORTS = [ "gobject" ];

const GOBJECT_LIBNAME = "gobject-2.0";
const GOBJECT_ABIS = [ 0 ];

require("libs/glib.js");

var signalHandlers = {};

function gobject_defines(lib) {
  // Enums
  /* GConnectFlags */
  CTypesUtils.defineFlags(this, "GConnectFlags", 1, [
    "G_CONNECT_AFTER",
    "G_CONNECT_SWAPPED"
  ]);

  // Types
  this.GType = glib.gsize;
  this.GObject = ctypes.StructType("GObject");
  this.GClosure = ctypes.StructType("GClosure");
  this.GCallback = ctypes.voidptr_t;

  // Templates
  this.GClosureNotify = ctypes.FunctionType(ctypes.default_abi, ctypes.void_t,
                                            [glib.gpointer, this.GClosure.ptr]).ptr;

  // Functions
  lib.lazy_bind("g_boxed_free", ctypes.void_t, [this.GType, glib.gpointer]);
  lib.lazy_bind("g_object_ref", glib.gpointer, [glib.gpointer]);
  lib.lazy_bind("g_object_unref", ctypes.void_t, [glib.gpointer]);

  lib.lazy_bind_with_wrapper("g_signal_connect", function(aWrapped, aInstance,
                                                          aSignal, aHandler) {
    let id = aWrapped(aInstance, aSignal, aHandler, null, null, 0);
    // Root the callback
    signalHandlers[id] = aHandler;
  }, glib.gulong, [glib.gpointer, glib.gchar.ptr, this.GCallback,
                   glib.gpointer, this.GClosureNotify, this.GConnectFlags],
     "g_signal_connect_data");

  lib.lazy_bind_with_wrapper("g_signal_handler_disconnect", function(aWrapped,
                                                                     aInstance,
                                                                     aId) {
    aWrapped(aInstance, aId);
    // Unroot the callback
    delete signalHandlers[aId];
  }, ctypes.void_t, [glib.gpointer, glib.gulong]);

  /**
   * Wraps a JS callback as a ctypes function, suitable for using
   * as a gobject signal handler
   *
   * @param  aHandler
   *         JS callback to be used as a gobject signal handler
   * @param  aRetType
   *         The native return type of the signal handler
   * @param  aArgTypes
   *         An array of the native argument types of the signal handler
   * @return A newly wrapped ctypes function, suitable for using as a
   *         gobject signal handler
   */
  this.wrapSignalHandler = function gobject_wrapSignalHandler(aHandler,
                                                              aRetType,
                                                              aArgTypes) {
    let cb = function() {
      try {
        return aHandler.apply(null, arguments);
      } catch(e) {
        Cu.reportError(e);
      }
    };

    return ctypes.FunctionType(ctypes.default_abi, aRetType,
                               aArgTypes).ptr(cb);
  }
}

var gobject = CTypesUtils.newLibrary(GOBJECT_LIBNAME, GOBJECT_ABIS, gobject_defines);
