/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is edsintegration.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corp.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Mike Conley <mconley@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */

var EXPORTED_SYMBOLS = [ "ReferenceService" ];

const Cu = Components.utils;
const Cc = Components.classes;
const Ci = Components.interfaces;

Cu.import("resource://edsintegration/LibGLib.jsm");

var ReferenceService = {
  _registry: {},

  register: function RS_register(aURI) {
    this._registry[aURI] = new ReferenceContainer();
    return this._registry[aURI];
  },

}

var ReferenceContainer = function() {
  this._refs = {};
  this._signals = {};
}

ReferenceContainer.prototype = {
  get refs() {
    return this._refs;
  },

  signal_connect: function RS_signal_connect(aPtr, aSignal, aCb, aData) {
    let signalId = LibGLib.g_signal_connect(aPtr, aSignal, aCb, aData);
    let sigConnection = new SignalConnection(aPtr, signalId);
    this._signals[signalId] = sigConnection;
  },

  dispose: function RS_dispose() {
    for (let signalId in this._signals) {
      let connection = this._signals[signalId];

      if (connection.ptr.isNull())
        continue;

      LibGLib.g_signal_handler_disconnect(connection.ptr, connection.signalId);
    }
    this._signals = {};
  },

  disconnect: function RS_disconnect(aId) {
    if (!this._signals[aId])
      return;
    let connection = this._signals[aId];
    LibGLib.g_signal_handler_disconnect(connection.ptr, connection.signalId);
    delete this._signals[aId];
  },
}

function SignalConnection(aPtr, aSignalId) { 
  this._signalId = aSignalId;
  this._ptr = aPtr;
}

SignalConnection.prototype = {
  get signalId() {
    return this._signalId;
  },
  get ptr() {
    return this._ptr;
  },
}
