/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is edsintegration.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corp.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Mike Conley <mconley@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */

var EXPORTED_SYMBOLS = [ "LibGCancellable" ];

const Cu = Components.utils;
const Cc = Components.classes;
const Ci = Components.interfaces;

Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://gre/modules/Services.jsm");
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

Cu.import("resource://edsintegration/libgio-ctypes.jsm");
Cu.import("resource://edsintegration/LibGLib.jsm");


XPCOMUtils.defineLazyGetter(this, "GCancellable", function() {
  return ctypes.StructType("GCancellable");
});

XPCOMUtils.defineLazyGetter(this, "g_cancellable_new", function() {
  var g_cancellable_new =
    libgio.declare("g_cancellable_new",
                   ctypes.default_abi,
                   GCancellable.ptr);

  if (!g_cancellable_new)
    throw "g_cancellable_new is unavailable";

  return g_cancellable_new;
});

XPCOMUtils.defineLazyGetter(this, "g_cancellable_set_error_if_cancelled", function() {
  var g_cancellable_set_error_if_cancelled =
    libgio.declare("g_cancellable_set_error_if_cancelled",
                   ctypes.default_abi,
                   LibGLib.gboolean,
                   GCancellable.ptr,
                   LibGLib.GError.ptr.ptr);

  if (!g_cancellable_set_error_if_cancelled)
    throw "g_cancellable_set_error_if_cancelled is unavailable";

  return g_cancellable_set_error_if_cancelled;
});


var LibGCancellable = {
  GCancellable: GCancellable,

  newGCancellable: function LGC_newGCancellable() {
    return g_cancellable_new();
  },

  setErrorIfCancelled: function LGC_setErrorIfCancelled(aCancellable, aErrPtr) {
    return g_cancellable_set_error_if_cancelled(aCancellable, aErrPtr)
           == LibGLib.TRUE;
  },

}
