/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is edsintegration.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corp.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Mike Conley <mconley@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */

var EXPORTED_SYMBOLS = [ "LibEVCard" ];

const Cu = Components.utils;
const Cc = Components.classes;
const Ci = Components.interfaces;

Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://gre/modules/Services.jsm");
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

Cu.import("resource://edsintegration/LibGLib.jsm");
Cu.import("resource://edsintegration/libebook-ctypes.jsm");

XPCOMUtils.defineLazyGetter(this, "EVCard", function() {
  return ctypes.StructType("EVCard");
});

XPCOMUtils.defineLazyGetter(this, "EVCardAttribute", function() {
  return ctypes.StructType("EVCardAttribute");
});

XPCOMUtils.defineLazyGetter(this, "EVCardAttributeParam", function() {
  return ctypes.StructType("EVCardAttributeParam");
});

XPCOMUtils.defineLazyGetter(this, "e_vcard_add_attribute", function() {
  var e_vcard_add_attribute =
    libebook.declare("e_vcard_add_attribute",
                     ctypes.default_abi,
                     ctypes.void_t,
                     EVCard.ptr,
                     EVCardAttribute.ptr);
  if (!e_vcard_add_attribute)
    throw "e_vcard_add_attribute is unavailable";

  return e_vcard_add_attribute;
});

XPCOMUtils.defineLazyGetter(this, "e_vcard_attribute_add_param_with_value", function() {
  var e_vcard_attribute_add_param_with_value =
    libebook.declare("e_vcard_attribute_add_param_with_value",
                     ctypes.default_abi,
                     ctypes.void_t,
                     EVCardAttribute.ptr,
                     EVCardAttributeParam.ptr,
                     LibGLib.gchar.ptr);
  if (!e_vcard_attribute_add_param_with_value)
    throw "e_vcard_attribute_add_param_with_value is unavailable";

  return e_vcard_attribute_add_param_with_value;
});


XPCOMUtils.defineLazyGetter(this, "e_vcard_get_attributes", function() {
  var e_vcard_get_attributes =
    libebook.declare("e_vcard_get_attributes",
                     ctypes.default_abi,
                     LibGLib.GList.ptr,
                     EVCard.ptr);
  if (!e_vcard_get_attributes)
    throw "e_vcard_get_attributes is unavailable";

  return e_vcard_get_attributes;
});

XPCOMUtils.defineLazyGetter(this, "e_vcard_attribute_add_value", function() {
  var e_vcard_attribute_add_value =
    libebook.declare("e_vcard_attribute_add_value",
                     ctypes.default_abi,
                     ctypes.void_t,
                     EVCardAttribute.ptr,
                     LibGLib.gchar.ptr);
  if (!e_vcard_attribute_add_value)
    throw "e_vcard_add_value is unavailable";

  return e_vcard_attribute_add_value;
});

XPCOMUtils.defineLazyGetter(this, "e_vcard_attribute_free", function() {
  var e_vcard_attribute_free =
    libebook.declare("e_vcard_attribute_free",
                     ctypes.default_abi,
                     ctypes.void_t,
                     EVCardAttribute.ptr);
  if (!e_vcard_attribute_free)
    throw "e_vcard_attribute_free is unavailable";

  return e_vcard_attribute_free;
});

XPCOMUtils.defineLazyGetter(this, "e_vcard_attribute_get_name", function() {
  var e_vcard_attribute_get_name =
    libebook.declare("e_vcard_attribute_get_name",
                     ctypes.default_abi,
                     LibGLib.gchar.ptr,
                     EVCardAttribute.ptr);
  if (!e_vcard_attribute_get_name)
    throw "e_vcard_attribute_get_name is unavailable";

  return e_vcard_attribute_get_name;
});

XPCOMUtils.defineLazyGetter(this, "e_vcard_attribute_get_value", function() {
  var e_vcard_attribute_get_value =
    libebook.declare("e_vcard_attribute_get_value",
                     ctypes.default_abi,
                     LibGLib.gchar.ptr,
                     EVCardAttribute.ptr);
  if (!e_vcard_attribute_get_value)
    throw "e_vcard_attribute_get_value is unavailable";

  return e_vcard_attribute_get_value;
});

XPCOMUtils.defineLazyGetter(this, "e_vcard_attribute_has_type", function() {
  var e_vcard_attribute_has_type =
    libebook.declare("e_vcard_attribute_has_type",
                     ctypes.default_abi,
                     LibGLib.gboolean,
                     EVCardAttribute.ptr,
                     LibGLib.gchar.ptr);
  if (!e_vcard_attribute_has_type)
    throw "e_vcard_attribute_has_type is unavailable";

  return e_vcard_attribute_has_type;
});

XPCOMUtils.defineLazyGetter(this, "e_vcard_attribute_copy", function() {
  var e_vcard_attribute_copy =
    libebook.declare("e_vcard_attribute_copy",
                     ctypes.default_abi,
                     EVCardAttribute.ptr,
                     EVCardAttribute.ptr);
  if (!e_vcard_attribute_copy)
    throw "e_vcard_attribute_copy is unavailable";

  return e_vcard_attribute_copy;
});

XPCOMUtils.defineLazyGetter(this, "e_vcard_attribute_new", function() {
  var e_vcard_attribute_new =
    libebook.declare("e_vcard_attribute_new",
                     ctypes.default_abi,
                     EVCardAttribute.ptr,
                     LibGLib.gchar.ptr,
                     LibGLib.gchar.ptr);
  if (!e_vcard_attribute_new)
    throw "e_vcard_attribute_new is unavailable";

  return e_vcard_attribute_new;
});

XPCOMUtils.defineLazyGetter(this, "e_vcard_attribute_param_new", function() {
  var e_vcard_attribute_param_new =
    libebook.declare("e_vcard_attribute_param_new",
                     ctypes.default_abi,
                     EVCardAttributeParam.ptr,
                     LibGLib.gchar.ptr);
  if (!e_vcard_attribute_param_new)
    throw "e_vcard_attribute_param_new is unavailable";

  return e_vcard_attribute_param_new;
});


XPCOMUtils.defineLazyGetter(this, "e_vcard_remove_attributes", function() {
  var e_vcard_remove_attributes =
    libebook.declare("e_vcard_remove_attributes",
                     ctypes.default_abi,
                     ctypes.void_t,
                     EVCard.ptr,
                     LibGLib.gchar.ptr,
                     LibGLib.gchar.ptr);
  if (!e_vcard_remove_attributes)
    throw "e_vcard_remove_attributes is unavailable";

  return e_vcard_remove_attributes;
});

var LibEVCard = {
  EVC_EMAIL: "EMAIL",
  EVC_TEL: "TEL",
  EVC_TYPE: "TYPE",
  EVC_X_ASSISTANT: "X-EVOLUTION-ASSISTANT",
  EVC_X_CALLBACK: "X-EVOLUTION-CALLBACK",
  EVC_X_RADIO: "X-EVOLUTION-RADIO",
  EVC_X_TELEX: "X-EVOLUTION-TELEX",
  EVC_X_TTYTDD: "X-EVOLUTION-TTYTDD",
  WORK: "WORK",
  HOME: "HOME",
  OTHER: "OTHER",

  EVCard: EVCard,
  EVCardAttribute: EVCardAttribute,
  EVCardAttributeParam: EVCardAttributeParam,

  getAttributes: function LEVC_getAttributes(aEVCard) {
    return e_vcard_get_attributes(aEVCard);
  },

  getAttributeName: function LEVC_getAttributeName(aEVCardAttribute) {
    let result = e_vcard_attribute_get_name(aEVCardAttribute);
    return result.readString();
  },

  getAttributeValue: function LEVC_getAttributeValue(aEVCardAttribute) {
    let result = e_vcard_attribute_get_value(aEVCardAttribute);
    return result.readString();
  },

  getAttributesNamed: function LEVC_getAttributesNamed(aEVCard, aAttrName) {
    let attrList = LibEVCard.getAttributes(aEVCard);
    for (let a = attrList; !a.isNull(); a = a.contents.next) {
      let attr = ctypes.cast(a.contents.data, LibEVCard.EVCardAttribute.ptr);
      let name = LibEVCard.getAttributeName(attr);
      if (name == aAttrName) {
        yield attr;
      }
    }
    yield null;
  },

  addAttribute: function LEVC_addAttribute(aEVCard, aEVCardAttribute) {
    e_vcard_add_attribute(aEVCard, aEVCardAttribute);
  },

  attributeAddParamWithValue: function LEVC_addParamWithValue(aAttr, aParam, aValue) {
    return e_vcard_attribute_add_param_with_value(aAttr, aParam, aValue);
  },

  attributeAddValue: function LEVC_attributeAddValue(aEVCardAttribute, aValue) {
    e_vcard_attribute_add_value(aEVCardAttribute, aValue);
  },

  attributeCopy: function LEVC_attributeCopy(aEVCardAttribute) {
    return e_vcard_attribute_copy(aEVCardAttribute);
  },

  attributeFree: function LEVC_attributeFree(aEVCardAttribute) {
    e_vcard_attribute_free(aEVCardAttribute);
  },

  attributeHasType: function LEVC_attributeHasType(aEVCardAttribute, aType) {
    return e_vcard_attribute_has_type(aEVCardAttribute, aType) == LibGLib.TRUE;
  },

  attributeNew: function LEVC_attributeNew(aAttrGroup, aAttrName) {
    return e_vcard_attribute_new(aAttrGroup, aAttrName);
  },

  attributeParamNew: function LEVC_attributeParamNew(aAttrName) {
    return e_vcard_attribute_param_new(aAttrName);
  },

  removeAttributes: function LEVC_removeAttributes(aEVCard, aAttrGroup, aAttrName) {
    e_vcard_remove_attributes(aEVCard, aAttrGroup, aAttrName);
  }
}
