/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is edsintegration.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corp.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Mike Conley <mconley@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */

var EXPORTED_SYMBOLS = [ "LibESource" ];

const Cu = Components.utils;
const Cc = Components.classes;
const Ci = Components.interfaces;

Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://gre/modules/Services.jsm");
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

Cu.import("resource://edsintegration/LibGLib.jsm");
Cu.import("resource://edsintegration/libedataserver-ctypes.jsm");

XPCOMUtils.defineLazyGetter(this, "ESource", function() {
  return ctypes.StructType("ESource");
});

XPCOMUtils.defineLazyGetter(this, "e_source_peek_name", function() {
  var e_source_peek_name =
    libedataserver.declare("e_source_peek_name",
                           ctypes.default_abi,
                           LibGLib.gchar.ptr,
                           ESource.ptr);
  if (!e_source_peek_name)
    throw "e_source_peek_name is unavailable";

  return e_source_peek_name;
});

XPCOMUtils.defineLazyGetter(this, "e_source_set_name", function() {
  var e_source_set_name =
    libedataserver.declare("e_source_set_name",
                           ctypes.default_abi,
                           ctypes.void_t,
                           ESource.ptr,
                           LibGLib.gchar.ptr);

  if (!e_source_set_name)
    throw "e_source_set_name is unavailable";

  return e_source_set_name;
});

XPCOMUtils.defineLazyGetter(this, "e_source_get_property", function() {
  var e_source_get_property =
    libedataserver.declare("e_source_get_property",
                           ctypes.default_abi,
                           LibGLib.gchar.ptr,
                           ESource.ptr,
                           LibGLib.gchar.ptr);

  if (!e_source_get_property)
    throw "e_source_get_property is unavailable";

  return e_source_get_property;
});

XPCOMUtils.defineLazyGetter(this, "e_source_get_readonly", function() {
  var e_source_get_readonly =
    libedataserver.declare("e_source_get_readonly",
                           ctypes.default_abi,
                           LibGLib.gboolean,
                           ESource.ptr);

  if (!e_source_get_readonly)
    throw "e_source_get_readonly is unavailable";

  return e_source_get_readonly;
});

XPCOMUtils.defineLazyGetter(this, "e_source_new_with_absolute_uri", function() {
  var e_source_new_with_absolute_uri =
    libedataserver.declare("e_source_new_with_absolute_uri",
                           ctypes.default_abi,
                           ESource.ptr,
                           LibGLib.gchar.ptr,
                           LibGLib.gchar.ptr);

  if (!e_source_new_with_absolute_uri)
    throw "e_source_new_with_absolute_uri is unavailable";

  return e_source_new_with_absolute_uri;
});


XPCOMUtils.defineLazyGetter(this, "e_source_peek_uid", function() {
  var e_source_peek_uid =
    libedataserver.declare("e_source_peek_uid",
                           ctypes.default_abi,
                           LibGLib.gchar.ptr,
                           ESource.ptr);
  if (!e_source_peek_uid)
    throw "e_source_peek_uid is unavailable";

  return e_source_peek_uid;
});

XPCOMUtils.defineLazyGetter(this, "e_source_get_uri", function() {
  var e_source_get_uri =
    libedataserver.declare("e_source_get_uri",
                           ctypes.default_abi,
                           LibGLib.gchar.ptr,
                           ESource.ptr);
  if (!e_source_get_uri)
    throw "e_source_get_uri is unavailable";

  return e_source_get_uri;
});

var LibESource = {
  ESource: ESource,
  getName: function LES_getName(aEsource) {
    let name = e_source_peek_name(aEsource);
    if (!name)
      throw("Could not get name for ESource");
    return name.readString();
  },

  getProperty: function LES_getProperty(aESource, aProp) {
    let value = e_source_get_property(aESource, aProp);
    if (!value || value.isNull())
      return null;
    return value.readString();
  },

  setName: function LES_setName(aEsource, aName) {
    e_source_set_name(aEsource, aName);
  },

  getReadOnly: function LES_getReadOnly(aEsource) {
    return e_source_get_readonly(aEsource) == LibGLib.TRUE;
  },

  newWithAbsoluteUri: function LES_newWithAbsoluteUri(aName, aUri) {
    return e_source_new_with_absolute_uri(aName, aUri);
  },

  peekUid: function LES_peekUid(aESource) {
    return e_source_peek_uid(aESource);
  }
}


