#! /bin/bash
# Execute this script with the command 
# 			bashscript/dosome.sh < /dev/null > dosome.log
# (from the featpost root directory)
# Don't worry about the error messages.
# L. Nobre G.
# IYP (2005)

export TEX=latex
mkdir alleps
mkdir allpng
mkdir allps
mkdir ppm
mkdir galreyimages
cd macro
mpost --ini featpost.mp
cd ..
ln -s macro/featpost.mem
ln -s latex/mflogohack.sty
echo \\documentclass[twocolumn]{article}\
     \\usepackage[dvips]{epsfig}\
     \\usepackage{mflogohack}\
     \\begin{document}\
     \\title{\\FP\\ Exemplifier}\
     \\author{L.\\ Nobre G.}\
     \\maketitle\
     \\begin{center}\
     > FeatPostExemplifier.tex
for a in example/standard/*.mp 
do
  b=`basename $a .mp`
  mpost -mem featpost example/standard/$b
  for c in $b.?
  do
    echo \\vfill\
      \\begin\{tabular\}\{c\}\
      \\epsfig\{file=$c\,width=0.9\\columnwidth\} \\\\\
      \\texttt\{$c\}\
      \\end\{tabular\} \\\\ >> FeatPostExemplifier.tex
    echo \\documentclass{article}\\usepackage[dvips]{epsfig}\\begin{document}\\pagestyle{empty}\\epsfig{file=$c,width=0.9\\textwidth}\\end{document} > $c.latex
    latex $c.latex
    dvips -E -o $c.PS $c.dvi
    epstopdf --nogs $c.PS > $c.eps 
    gs -q -sDEVICE=png256 -r120 -dTextAlphaBits=4 -dGraphicsAlphaBits=4 -dCOLORSCREEN -dNOPAUSE -sOutputFile=$c.gs.png $c.eps
#    composite -filter Lanczos -geometry 300x300 -gravity Center $c.gs.png png/borderframetest.png ppm/t_$c.ppm
    composite -filter Lanczos -geometry 120x120 -gravity Center $c.gs.png png/border140.png ppm/t_$c.ppm
  done
  for ((num=0;num<10;num=num+1))
  do
    cp $b.$num.gs.png galreyimages/$b$num.png
    mv ppm/t_$b.$num.ppm ppm/t_$b$num.ppm
  done
done
echo \\end{center}\\end{document} >> FeatPostExemplifier.tex
latex FeatPostExemplifier.tex
dvips -o FeatPostExemplifier.ps FeatPostExemplifier.dvi
bzip2 FeatPostExemplifier.ps
mv FeatPostExemplifier.ps.bz2 doc/
rm FeatPostExemplifier.*
rm mflogohack.sty
rm *.?.PS *.?.aux *.?.latex *.?.dvi *.log *.?.mgk *.?.orig
rm example/standard/*.mpx
mv *.? allps/
mv *.?.gs.png allpng/
mv *.?.png nontextualpng/
mv *.?.eps alleps/
#animate -delay 125 ppm/* &
cd doc
linuxdoc -B html --split=2 --toc=2 featpost.sgml
linuxdoc -B latex featpost.sgml
mv featpost.tex ../latex/
cd ../latex
latex featpost.tex
latex featpost.tex
dvips -o featpost.ps featpost.dvi
ps2pdf featpost.ps
mv featpost.ps featpost.pdf ../doc/
#sed 's/article/ltugboat/' featpost.tex > tugboatMan.tex
#latex tugboatMan.tex
#latex tugboatMan.tex
#dvips -o ../doc/tugboatMan.ps tugboatMan.dvi
cd ../galrey
source galrey.sh
cd ..
for a in ppm/t_*.ppm
do
  convert $a galreyimages/`basename $a ppm`png
done
pwd






