var addDialBundle;
var fontArray;

function Startup() {
  addDialBundle = document.getElementById("bundle_editDial");
  
  var backgroundImageStyle = window.arguments[0];
  var advancedStyle = window.arguments[1];
  var font = window.arguments[2];
  
  // decode them
  if (backgroundImageStyle != '') {
    var styleParts = backgroundImageStyle.split('#');
    document.getElementById("imageLocation").value = styleParts[0];

    // Horizontal position
    if (styleParts[1] == 'l') {
      document.getElementById("horizontalPosition").selectedIndex = 1;
    } else if (styleParts[1] == 'r') {
      document.getElementById("horizontalPosition").selectedIndex = 2;
    }
    
    // Vertical position
    if (styleParts[2] == 't') {
      document.getElementById("verticalPosition").selectedIndex = 1;
    } else if (styleParts[2] == 'b') {
      document.getElementById("verticalPosition").selectedIndex = 2;
    }
    
    // Repeat background
    if (styleParts[3] == 'h') {
      document.getElementById("repeatBackground").selectedIndex = 1;
    } else if (styleParts[3] == 'v') {
      document.getElementById("repeatBackground").selectedIndex = 2;
    } else if (styleParts[3] == 'b') {
      document.getElementById("repeatBackground").selectedIndex = 3;
    }
    
    document.getElementById("backgroundImage").checked = true;
  }
  if (advancedStyle != '') {
    document.getElementById("advancedStyleBox").value = advancedStyle;
    document.getElementById("advancedStyle").checked = true;
  }
  
  var fontEnumerator = Components.classes["@mozilla.org/gfx/fontenumerator;1"].getService(Components.interfaces.nsIFontEnumerator);
  var totalFonts = {};
  var defaultFont;
  var popup = document.getElementById("fontTypePopup");
  fontArray = fontEnumerator.EnumerateAllFonts(totalFonts);
  
  for (var c=0; c<totalFonts.value; c++) {
    var newItem = document.createElement("menuitem");
    newItem.setAttribute("label", fontArray[c]);
    popup.appendChild(newItem);
  }
  if (font != '') {
    var fontParts = font.split('#');
    defaultFont = fontParts[0];
    document.getElementById("fontSize").value = fontParts[1];
    if (fontParts[2] > 0) {
      document.getElementById("fontBold").checked = true;
    }
    if (fontParts[3] > 0) {
      document.getElementById("fontItalic").checked = true;
    }
    document.getElementById("font").checked = true;
  } else {
    var labelFontStyle = document.defaultView.getComputedStyle(document.getElementById("fontTypeLabel"),null);
    defaultFont = labelFontStyle.getPropertyValue("font-family");
  }

  // Set default font
  var foundFont = false;
  var foundFontIndex = 0;
  for (var c=0; (c<totalFonts.value)&&!foundFont; c++) {
    if (fontArray[c] == defaultFont) {
      foundFontIndex = c;
      foundFont = true;
    }
  }
  document.getElementById("fontType").selectedIndex = foundFontIndex;
  
  advancedStyleChanged();
  backgroundImageChanged();
  fontChanged();
}

function onOK(event) {
  // refresh the fields!
  var backgroundImageStyle = '';
  var advancedStyle = '';
  var font = '';

  if (document.getElementById("backgroundImage").checked) {
    backgroundImageStyle = document.getElementById("imageLocation").value + '#';
    
    switch (document.getElementById("horizontalPosition").selectedIndex) {
      case 0:
        backgroundImageStyle += 'c';
        break;
      case 1:
        backgroundImageStyle += 'l';
        break;
      case 2:
        backgroundImageStyle += 'r';
        break;
    }
    
    backgroundImageStyle += '#';
    
    switch (document.getElementById("verticalPosition").selectedIndex) {
      case 0:
        backgroundImageStyle += 'c';
        break;
      case 1:
        backgroundImageStyle += 't';
        break;
      case 2:
        backgroundImageStyle += 'b';
        break;
    }
    
    backgroundImageStyle += '#';
    
    switch (document.getElementById("repeatBackground").selectedIndex) {
      case 0:
        backgroundImageStyle += 'n';
        break;
      case 1:
        backgroundImageStyle += 'h';
        break;
      case 2:
        backgroundImageStyle += 'v';
        break;
      case 3:
        backgroundImageStyle += 'b';
        break;
    }
  }
  
  if (document.getElementById("advancedStyle").checked) {
    advancedStyle = document.getElementById("advancedStyleBox").value;
  }
  
  if (document.getElementById("font").checked) {
    font = fontArray[document.getElementById("fontType").selectedIndex];
    font += '#';
    font += document.getElementById("fontSize").value;
    font += '#';
    if (document.getElementById("fontBold").checked) {
      font += '1';
    } else {
      font += '0';
    }
    font += '#';
    if (document.getElementById("fontItalic").checked) {
      font += '1';
    } else {
      font += '0';
    }
  }

  
  window.opener.processAdditionalStyleOutput(backgroundImageStyle, advancedStyle, font);
  return true;
}

function onCancel(event) {
  // Do nothing
  
  return true;
}

function backgroundImageChanged() {
  var backgroundImageCheckbox = document.getElementById("backgroundImage");
  document.getElementById("imageLocationLabel").disabled = !backgroundImageCheckbox.checked;
  document.getElementById("imageLocation").disabled = !backgroundImageCheckbox.checked;
  document.getElementById("chooseFileButton").disabled = !backgroundImageCheckbox.checked;
  document.getElementById("horizontalPositionLabel").disabled = !backgroundImageCheckbox.checked;
  document.getElementById("horizontalPosition").disabled = !backgroundImageCheckbox.checked;
  document.getElementById("verticalPositionLabel").disabled = !backgroundImageCheckbox.checked;
  document.getElementById("verticalPosition").disabled = !backgroundImageCheckbox.checked;
  document.getElementById("repeatBackgroundLabel").disabled = !backgroundImageCheckbox.checked;
  document.getElementById("repeatBackground").disabled = !backgroundImageCheckbox.checked;
}

function advancedStyleChanged() {
  var advancedStyleCheckbox = document.getElementById("advancedStyle");
  document.getElementById("advancedStyleBox").disabled = !advancedStyleCheckbox.checked;
}

function fontChanged() {
  var fontCheckbox = document.getElementById("font");
  document.getElementById("fontTypeLabel").disabled = !fontCheckbox.checked;
  document.getElementById("fontType").disabled = !fontCheckbox.checked;
  document.getElementById("fontSizeLabel").disabled = !fontCheckbox.checked;
  document.getElementById("fontSize").disabled = !fontCheckbox.checked;
  document.getElementById("fontBold").disabled = !fontCheckbox.checked;
  document.getElementById("fontItalic").disabled = !fontCheckbox.checked;
}

function showFileBrowser() {
  var nsIFilePicker = Components.interfaces.nsIFilePicker;
  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
  fp.init(window, addDialBundle.getString("selectFile"), nsIFilePicker.modeOpen);
  fp.appendFilters(nsIFilePicker.filterImages);
  fp.appendFilters(nsIFilePicker.filterAll);
  var res = fp.show();
  if (res == nsIFilePicker.returnOK){
    document.getElementById("imageLocation").value = fp.fileURL.spec;
  }
}
