.TH sane\-xerox_mfp 5 "15 Dec 2008" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-xerox_mfp
.SH NAME
sane\-xerox_mfp \- SANE backend for Xerox Phaser 3200MFP device
.SH DESCRIPTION
The
.B sane\-xerox_mfp
library implements a SANE (Scanner Access Now Easy) backend that provides
access to the following USB and network multifunction-peripheral:
.PP
.RS
Phaser 3200MFP
.br
Dell MFP Laser Printer 1815dn
.br
Xerox Phaser 6110MFP
.br
Samsung CLX-3170fn & CLX-3175FW
.br
Samsung SCX-4200
.br
Samsung SCX-4300
.br
Samsung SCX-4500
.br
Samsung SCX-4500W
.br
Samsung SCX4725-FN
.br
Xerox WorkCentre 3119 Series
.RE
.PP
If you own a scanner other than the ones listed above that works with this
backend, please let us know this by sending the scanner's exact model name and
the USB vendor and device ids (e.g. from
.IR /proc/bus/usb/devices ,
.I sane\-find\-scanner
or syslog) to us. Even if the scanner's name is only slightly different from
the models mentioned above, please let us know.
.SH CONFIGURATION
.I @CONFIGDIR@/xerox_mfp.conf
USB scanners do not need any configuration.

For SCX-4500W in network mode you need to specify
.PP
.RS
.B tcp host_address [port]
.RE
.PP
The 
.B host_address
is passed through resolver, thus can be a dotted quad or a name from /etc/hosts or resolvable through DNS.
.SH FILES
.TP
.I @CONFIGDIR@/xerox_mfp.conf
The backend configuration file. By default all scanner types/models are enabled, you
may want to comment out unwanted.
.TP
.I @LIBDIR@/libsane\-xerox_mfp.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-xerox_mfp.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.B SANE_DEBUG_XEROX_MFP
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  Higher
debug levels increase the verbosity of the output. 

Example: 
export SANE_DEBUG_XEROX_MFP=4
.SH AUTHOR
Alex Belkin <abc@telekom.ru>

Samsung SCX-4500W scan over network support
Alexander Kuznetsov <acca(at)cpan.org>
.SH BUGS:
Multicast autoconfiguration for LAN scanners is not implemented yet. IPv6 addressing never been tested.

.SH "SEE ALSO"
.BR sane (7),
.BR sane\-usb (5)
.br

